/*
 * Decompiled with CFR 0.152.
 */
package Assets;

import Assets.Texture;
import Misc.Output;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class TextureManager {
    private HashMap<Integer, Texture> textures = new HashMap();

    public TextureManager() {
    }

    public TextureManager(String dir) {
        this();
        File[] files;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource("images");
        String path = url.getPath();
        for (File f : files = new File(path).listFiles()) {
            System.out.println(f.getAbsolutePath());
        }
        try {
            File textureDirectory = new File(dir);
            Output.infoln("Loading textures from \"" + textureDirectory.getAbsolutePath() + "\"\n");
            File[] textureFiles = textureDirectory.listFiles();
            assert (textureFiles != null);
            for (File textureFile : textureFiles) {
                String filename = textureFile.getName();
                Output.infoln("Loading " + filename + " ...");
                if (!filename.contains(".png") && !filename.contains(".jpg")) continue;
                BufferedImage img = ImageIO.read(textureFile);
                String basename = filename.replace(".png", "").replace(".jpg", "");
                Texture newTexture = new Texture(basename, img);
                this.textures.put(basename.hashCode(), newTexture);
            }
        }
        catch (Exception e) {
            Output.errorln("Could not load texture directory \"" + dir + "\"");
            Output.errorln(e.getMessage());
            System.exit(1);
        }
    }

    public Texture getTexture(String name) {
        if (!this.textures.containsKey(name.hashCode())) {
            Output.warnln("Could not find texture \"" + name + "\", defaulting.");
            System.exit(1);
        }
        return this.textures.get(name.hashCode());
    }

    public void updateTextures(double scale) {
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        for (Texture t : this.textures.values()) {
            t.updateScaledImage(scaleOp, scale);
        }
    }

    public Texture get(int hashcode) {
        return this.textures.get(hashcode);
    }

    public BufferedImage getImage(String name) {
        return this.getTexture((String)name).image;
    }
}

