/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Assets.TextureManager;
import Engine.KeyboardHandler;
import Engine.RenderEngine;
import Misc.Output;
import World.World;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class Engine
extends JPanel
implements Runnable {
    double tps;
    double realFPS = 0.0;
    int mspt;
    int frameNumber = 0;
    int tick = 0;
    public boolean isPaused = false;
    public boolean showStats = true;
    long timeAtLastTick;
    Thread mainThread;
    Thread renderThread;
    private TextureManager tm;
    private RenderEngine re;
    protected World w;
    public KeyboardHandler kh;
    public JPanel jp;
    private BufferedImage bi;

    public Engine(int tps, int wwidth, int wheight) {
        try {
            this.tm = new TextureManager("res/images/");
            this.tm.updateTextures(1.0);
        }
        catch (Exception e) {
            Output.errorln("");
            e.printStackTrace();
            System.exit(-1);
        }
        this.w = new World(100, 100);
        this.re = new RenderEngine(wwidth, wheight, 60, this);
        this.bi = new BufferedImage(this.re.width, this.re.height, 5);
        this.tps = tps;
        this.mspt = (int)(1000.0 / this.tps);
        this.jp = this;
        this.kh = new KeyboardHandler(this, this.jp.getInputMap(), this.jp.getActionMap());
    }

    public void start() {
        this.mainThread = new Thread(this);
        this.mainThread.start();
        this.renderThread = new Thread(this.re);
        this.renderThread.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.interpret();
        this.re.draw(g2, this.w, this.tm, this);
        if (this.showStats) {
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(10, 10, 300, 30);
            g.setColor(Color.WHITE);
            g.drawString("Frame number: " + this.frameNumber + "\nTick number: " + this.tick, 10, 30);
        }
        ++this.frameNumber;
    }

    public void interpret() {
        if (KeyboardHandler.keyStroke[119]) {
            this.re.ycenter -= 4.0;
        }
        if (KeyboardHandler.keyStroke[115]) {
            this.re.ycenter += 4.0;
        }
        if (KeyboardHandler.keyStroke[97]) {
            this.re.xcenter -= 4.0;
        }
        if (KeyboardHandler.keyStroke[100]) {
            this.re.xcenter += 4.0;
        }
        if (KeyboardHandler.keyStroke[113]) {
            this.re.zoom *= 0.98;
            this.tm.updateTextures(this.re.zoom);
        }
        if (KeyboardHandler.keyStroke[101]) {
            this.re.zoom *= 1.02;
            this.tm.updateTextures(this.re.zoom);
        }
        if (KeyboardHandler.keyStroke[32]) {
            Output.infoln("Toggled pause");
            this.isPaused = !this.isPaused;
            KeyboardHandler.keyStroke[32] = false;
        }
        if (KeyboardHandler.keyStroke[49]) {
            Output.infoln("Toggled stats");
            this.showStats = !this.showStats;
            KeyboardHandler.keyStroke[49] = false;
        }
        if (KeyboardHandler.keyStroke[114]) {
            this.w.generateWorld();
            KeyboardHandler.keyStroke[114] = false;
        }
    }

    @Override
    public void run() {
        this.timeAtLastTick = System.currentTimeMillis();
        while (true) {
            if (!this.isPaused) {
                this.w.update();
                ++this.tick;
            }
            long timeSinceLastTick = System.currentTimeMillis() - this.timeAtLastTick;
            Output.infoln("Updated world after " + timeSinceLastTick);
            try {
                Thread.sleep((long)(1 + this.mspt) - timeSinceLastTick);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.timeAtLastTick = System.currentTimeMillis();
        }
    }
}

