/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Assets.Texture;
import Assets.TextureManager;
import Engine.Engine;
import Misc.Output;
import World.World;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class RenderEngine
implements Runnable {
    long timeAtLastFrame = 0L;
    long[] lastFrameTimes = new long[100];
    int lastFrameNumber = 0;
    private BufferedImage frame;
    public long timeAtLastTick = 0L;
    public int width = 800;
    public int height = 800;
    public int reqFPS = 60;
    public long mspf = 1000 / this.reqFPS;
    public double xcenter = 0.0;
    public double ycenter = 0.0;
    public double zoom = 1.0;
    public World w;
    public Engine en;

    public RenderEngine(int width, int height, int reqFPS, Engine en) {
        this.width = width;
        this.height = height;
        this.reqFPS = reqFPS;
        this.mspf = 1000 / this.reqFPS;
        this.frame = new BufferedImage(width, height, 5);
        this.w = en.w;
        this.en = en;
        this.xcenter = (double)this.en.getWidth() / 2.0;
        this.ycenter = (double)this.en.getHeight() / 2.0;
    }

    public boolean draw(Graphics2D g2, World w, TextureManager tm, ImageObserver io) {
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, this.width, this.height);
        int[] textures = new int[]{"Volcan".hashCode(), "Tree".hashCode(), "Grass".hashCode(), "Sky".hashCode(), "Cloud".hashCode(), "Water".hashCode()};
        for (int i = 0; i < w.myWorld.length; ++i) {
            for (int j = 0; j < w.myWorld[0].length; ++j) {
                Texture tex = tm.get(textures[w.myWorld[i][j]]);
                int x = (int)((double)(tex.width * i) * this.zoom) - (int)this.xcenter;
                int y = (int)((double)(tex.height * j) * this.zoom) - (int)this.ycenter;
                if (!((double)x + (double)tex.width * tex.scale >= 0.0) || x >= this.width || !((double)y + (double)tex.height * tex.scale >= 0.0) || y >= this.height) continue;
                g2.drawImage((Image)tex.scaledImage, x, y, io);
            }
        }
        Output.infoln("Time since last frame: " + (System.currentTimeMillis() - this.timeAtLastFrame) + "ms");
        this.timeAtLastFrame = System.currentTimeMillis();
        return true;
    }

    @Override
    public void run() {
        this.timeAtLastTick = System.currentTimeMillis();
        while (true) {
            this.width = this.en.getWidth();
            this.height = this.en.getHeight();
            this.en.repaint();
            long timeSinceLastFrame = System.currentTimeMillis() - this.timeAtLastTick;
            try {
                Thread.sleep(this.mspf - timeSinceLastFrame);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
            this.timeAtLastTick = System.currentTimeMillis();
        }
    }
}

