
public class PredatorAgent extends Agent {

	boolean _predator;
	
	public PredatorAgent( int __x, int __y, World __w )
	{
		super(__x,__y,__w);
		
		_predator = true;
	}

	public int canEat(int x, int y) {
		int id = -1;

		for (Agent a: _world.prey) {
			id++;
			if (a._x == x && a._y == y && a._etat != 1)
				return id;
		}
		return -1;
	}
	
	public void step( )
	{
		// met a jour l'agent
		
		// A COMPLETER

		int cellColor[] = _world.getCellState(_x, _y);
		
		cellColor[redId] = 255;
		cellColor[greenId] = 240;
		cellColor[blueId] = 225;

		//System.out.println("Predator color: " + _x + "  " + _y);

		_world.setCellState(_x, _y, cellColor);

		if ( Math.random() > 0.5 ) // au hasard
			_orient = (_orient+1) %4;
		else
			_orient = (_orient-1+4) %4;

		// met a jour: la position de l'agent (depend de l'orientation)
		int tent_x = _x;
		int tent_y = _y;

		switch ( _orient )
		{
			case 0: // nord
				tent_y = ( _y - 1 + _world.getHeight() ) % _world.getHeight();
				break;
			case 1:	// est
				tent_x = ( _x + 1 + _world.getWidth() ) % _world.getWidth();
				break;
			case 2:	// sud
				tent_y = ( _y + 1 + _world.getHeight() ) % _world.getHeight();
				break;
			case 3:	// ouest
				tent_x = ( _x - 1 + _world.getWidth() ) % _world.getWidth();
				break;
		}

		int eat_index = canEat(tent_x, tent_y);
		if (eat_index != -1) {
			Agent a = _world.prey.get(eat_index);

			Agent.kill(a);
			System.out.println("Prey à " + a._x + "  " + a._y + " est mort");
			System.out.println("Il reste " + _world.cpt_proies(0));
		}

		_x = tent_x;
		_y = tent_y;
	}
	
}
