import java.util.ArrayList;

public class MyEcosystem_predprey extends CAtoolbox {

	public static void main(String[] args) {

		// initialisation generale
		int dx = 10;
		int dy = 10;
		
		int displayWidth = dx;  // 200
		int displayHeight = dy; // 200

		// pick dimension for display
		if ( displayWidth < 200 )
			displayWidth = 200;
		else
			if ( displayWidth > 600 )
				displayWidth = 600;
			else
				if ( displayWidth < 300 )
					displayWidth = displayWidth * 2; 
		if ( displayHeight < 200 )
			displayHeight = 200;
		else
			if ( displayHeight > 600 )
				displayHeight = 600;
			else
				if ( displayHeight < 300 )
					displayHeight = displayHeight * 2; 
		
		
		int delai = 0;//100; // -- delay before refreshing display -- program is hold during delay, even if no screen update was requested. USE WITH CARE.
		int nombreDePasMaximum = Integer.MAX_VALUE;
		int displaySpeed = 1;//50; // from 1 to ...

		int nb_essaies = 10;
		Stats moyennes = new Stats(nb_essaies);

	    // initialisation des paramètres
		int max_prey = 20;
		int max_predators = 5;

		WorldLogger wl = new WorldLogger("stats/out_" + nb_essaies + "_" + max_prey + "_" + max_predators + ".csv");

		// boucle pour effectuer tous des essaies
		for (int iter = 0; iter < nb_essaies; iter++) {
			// création du mode d'affichage
			CAImageBuffer image = new CAImageBuffer(dx,dy);
			ImageFrame imageFrame =	ImageFrame.makeFrame( "My Ecosystem", image, delai, displayWidth, displayHeight );

			System.out.println("Iter: " + iter);

			int it = 0;
			World world = new World(dx, dy, true, true);

			// ajouter tous les agents au monde
			for (int i = 0; i != max_prey; i++)
				world.add(new PreyAgent((int) (Math.random() * dx), (int) (Math.random() * dy), world));
			for (int i = 0; i != max_predators; i++)
				world.add(new PredatorAgent((int) (Math.random() * dx), (int) (Math.random() * dy), world));

			// mise a jour de l'état du monde
			while (it != nombreDePasMaximum) {
				System.out.println("New");

				int cpt = world.cpt_proies(0);
				moyennes.ajouter(it, cpt, world.cpt_pred(0));

				// si il n'y a plus de proies
				if (cpt == 0) {
					break;
				}

				//if ( it % displaySpeed == 0 )
					world.display(image);

				// 2 - update
				world.step();

				world.display(image);

				// 3 - iterate
				it++;

				if (delai > 0) {
					try {
						Thread.sleep(delai);
					} catch (InterruptedException e) { }
				}
			}
		}

		// écrire dans le fichier et sortir du programme
		wl.log(moyennes);
		wl.close();
		System.exit(0);
	}

}
