import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

// Contient l'info qu'il faut pour une certaine itération
class Info {
    public int iter = 0;
    public int proies = 0;
    public int pred = 0;

    public Info(int iter) {
        this.iter = iter;
    }

    public Info(int iter, int proies, int pred) {
        this.iter = iter;
        this.proies = proies;
        this.pred = pred;
    }

    public void ajouter(int proies, int pred) {
        this.proies += proies;
        this.pred += pred;
    }
}

// Gère la sauvegarde des données
class Stats {
    public ArrayList<Info> stats;
    public int nb_essaies = 0;

    public Stats(int nb_essaies) {
        this.stats = new ArrayList<Info>();
        this.nb_essaies = nb_essaies;
    }

    public void ajouter(int iter, int proies, int pred) {
        if (stats.size() <= iter) {
            stats.add(new Info(iter, proies, pred));
        }
        else {
            stats.get(iter).ajouter(proies, pred);
        }
    }
}

// Écrit les données sauvegardées dans un fichier
public class WorldLogger {
    public FileWriter file;

    public WorldLogger(String filename) {
        try {
            file = new FileWriter(filename);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void log(Stats s) {
        for (Info i: s.stats) {
            try {
                file.write(i.iter + "," + ((double)i.proies / (double)s.nb_essaies) + "\n");
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        try {
            file.flush();
            file.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
