#include "board.hpp"

using BH = BoardHelper;
using MH = MoveHelper;

void BoardHelper::reset(BOARD) {
    b[0] = 4, b[1] = 4, b[2] = 4, b[3] = 4, b[4] = 4, b[5] = 4, b[6] = 0;
    b[7] = 4, b[8] = 4, b[9] = 4, b[10] = 4, b[11] = 4, b[12] = 4, b[13] = 0;
}

void BoardHelper::init(BOARD) {
    reset(b);
}

Move* MoveHelper::create_move(Move* m, int8 move_pos, int8 player) {
    Move* new_move = (Move*)malloc(sizeof(Move));
    new_move->id = next_id;
    next_id++;
    new_move->parent = m;
    new_move->player = player;
    new_move->layer = m->layer + 1;
    new_move->move_pos = move_pos;
    memcpy(new_move->b, m->b, BOARD_SIZE * sizeof(int8));
    new_move->res = UNEXPLORED;
    new_move->number_of_next = 0;
    return new_move;
}

void MoveHelper::execute_move(Move *m) {
    // inits
    int8 offset = (m->player == P1) ? 0 : 7;
    int8 direction = (m->player == P1) ? 1 : -1;
    int8 pos = offset + m->move_pos;

    int8 beads = m->b[pos];

    // add beads to corresponding holes
    for (int8 i = 0; i < beads; i++) {
        pos += direction;
        pos %= BOARD_SIZE;
        if (m->player == P1 && pos == P2)
            pos = 0;
        if (m->player == P2 && pos == P1)
            pos = P1 - 1;
        m->b[pos]++;
    }

    // check if can repeat for next move
    if (m->player == pos) {
        m->res = PLAY_AGAIN;
    }

    // check if eligible for capture
    if ((m->b[pos] == 1 && pos != P1) && pos != P2) {
        if (m->player == P1 && pos < P1) {
            m->b[P1] += m->b[(P2 - 1) - pos];
            m->b[(P2 - 1) - pos] = 0;
            m->res = CAPTURE;
        }
        else if (m->player == P2 && pos > P1) {
            m->b[P2] += m->b[(P1 - 1) - (P2 - pos)];
            m->b[(P1 - 1) - (P2 - pos)] = 0;
            m->res = CAPTURE;
        }
    }

    m->res = DONE;
}

void MoveHelper::print(Move* m) {
    cout << "id: " << m->id << "\tP" << ((m->player == P1) ? "1" : "2") << \
        "\tlayer: " << m->layer << "\tres: " << m->res << "\tmove_pos: " << \
        m->move_pos << "\n";
    BH::print(m->b);
    cout << "\n";
}

Move* MoveHelper::play(Move* m) {
    if (m->res != ROOT && m->layer <= MAX_ITER)
        MH::execute_move(m);

    MH::print(m);

    int8 p = m->player;
    if (m->res == DONE) {
        if (p == P1)
            p = P2;
        else
            p = P1;
    }

    int8 offset = (p == P1) ? 0 : 7;

    for (int i = offset; i < 6 + offset; i++) {
        if (m->b[i] >= 0) {
            m->number_of_next += 1;
            m->next[i] = MH::create_move(m, i - offset, p);
        }
    }

    for (int i = 0; i < 6; i++) {
        if (m->next[i])
            MH::play(m->next[i]);
    }
}

Move* init_game(Move* m) {

}

ostream& operator<<(ostream &strm, const Move &m) {
    strm << "id: " << m.id << "\tP" << ((m.player == P1) ? "1" : "2") << \
        "\tlayer: " << m.layer << "\tres: " << m.res << "\tmove_pos: " << \
        m.move_pos << "\n";
    BH::print(m.b);
    return strm;
}

RESULT BoardHelper::can_play_again(BOARD, int8 move, int8 player) {
    return CAPTURE;
}

int8 BoardHelper::get_score(BOARD, int8 player) {
    return player == P1 ? b[P1] : b[P2];
}

void BoardHelper::print(const BOARD) {
    cout << "   ";
    for (int i = 1; i < 7; i++)
        cout << (int)b[P2 - i] << "  ";
    cout << '\n';

    cout << " " << (int)b[P2] << "                  " << (int)b[P1] << '\n';

    cout << "   ";
    for (int i = 0; i < 6; i++)
        cout << (int)b[i] << "  ";
    cout << '\n';
}

int main(int argc, char *argv[]) {
    setbuf(stdout, 0);
    BOARD;
    MoveHelper mh;
    cout << "Testinng" << endl;

    Move* root = (Move*)malloc(sizeof(Move));
    root->player = P1;
    root->layer = 1;
    root->id = next_id;
    next_id++;
    BH::init(root->b);
    root->res = ROOT;

    mh.play(root);
    return 0;
}