import sys

sys.path.append( '/home/tristan/Documents/earth-reverse-engineering/client/' )

import Bezier4
import numpy as np

def process_file(filename):
    pfile = open(filename + ".txt", 'r')

    plines = pfile.readlines()
    t_points = np.arange(0, 1, 0.00001)

    points = []

    for pl in plines:
        newp = [float(p) for p in pl.split(' ')]
        points.append(newp)
        print(newp)

    points1 = np.array(points)
    curve1 = Bezier4.curve9(t_points, points1)
    
    ofile = open(filename + "_out.txt", 'w')

    for s in curve1:
        ofile.write(f"{s[0]} {s[1]} {s[2]}\n")

    ofile.close()

process_file("points")
process_file("directions")

segmentResults = []
"""
# Iterate the control points in the spline and interpolate them.
for i in range(1, len(spline.bezier_points)):
    
    # You always need at least 2 points to interpolate between.  Get the first and
    # second points for this segment of the spline.
    firstPt = spline.bezier_points[i-1]
    secondPt = spline.bezier_points[i]
    
    # Get all the points on the curve between these two items.  Uses the default of 12 for a "preview" resolution
    # on the curve.  Note the +1 because the "preview resolution" tells how many segments to use.  ie. 2 =&gt; 2 segments
    # or 3 points.  The "interpolate_bezier" functions takes the number of points it should generate.
    segmentResults.append(mathutils.geometry.interpolate_bezier(firstPt.co, firstPt.handle_right, secondPt.handle_left, secondPt.co, 2000))
"""

