#include <fstream>
#include <sys/stat.h>
#ifdef _WIN32
	#include <direct.h>
#endif

#include "SDL.h"
#ifdef EMSCRIPTEN
#   include <GLES2/gl2.h>
#   include "emscripten.h"
#else
#   if defined(_WIN32) || defined(__linux__)
#      include <glad/glad.h>
#      include "gl2/src/glad.c"
#   else
#      define GL_GLEXT_PROTOTYPES
#   endif
#endif

#include <math.h>
#include <Eigen/Dense>
using namespace Eigen;
#include "rocktree_util.h"

#include <SDL_opengl.h>
#include <string.h>

#include "simple_cpp_sockets.h"

SDL_Window* sdl_window;

u_short static_udp_port = 11012;
UDPServer server(static_udp_port);

float _in_x = 1;
float _in_y = 0;
float _in_z = 0;
float _in_w = 1;

//#define FOLLOW_TRAIL 1

#ifndef FOLLOW_TRAIL
std::ofstream points("points.txt", std::ios::out);
std::ofstream directions("directions.txt", std::ios::out);
#endif

std::ifstream points_out("points_out.txt", std::ios::in);
std::ifstream directions_out("directions_out.txt", std::ios::in);


static rocktree_t *_planetoid = NULL;

SDL_Joystick *controller;

std::vector<std::string> split(const std::string& s, char delimiter)
{
   std::vector<std::string> tokens;
   std::string token;
   std::istringstream tokenStream(s);
   while (std::getline(tokenStream, token, delimiter))
   {
      tokens.push_back(token);
   }
   return tokens;
}

void listenKinect() {
	int bind_status = server.socket_bind();

	// Return if there is an issue binding
	if (bind_status) {};

	server.listenKinect();
}

void UDPServer::listenKinect()
{
    sockaddr_in client;
    char client_ip[INET_ADDRSTRLEN];
    socklen_t slen = sizeof(client);
    char message_buffer[512];
    std::cout << "Waiting for data..." << std::endl;

    while(true)
    {
        // This is a blocking call
        ssize_t recv_len = recvfrom(m_socket, message_buffer, sizeof(message_buffer), 0, reinterpret_cast<sockaddr*>(&client), &slen);
        if (recv_len == SOCKET_ERROR)
        {
            std::cout << "Receive Data error." << std::endl;
        }
        std::cout << "Received packet from " << inet_ntop(AF_INET, &client.sin_addr, client_ip, INET_ADDRSTRLEN) << ':' << ntohs(client.sin_port) << std::endl;
        std::cout << message_buffer << std::endl;

		std::vector<std::string> path = split(message_buffer, '/');
		std::cout << "path[1]: " << path[1] << std::endl;


	if (path[1] == "quat") {
			//cv::Quatf in_quat(stof(path[2]), stof(path[3]), stof(path[4]), stof(path[5]));
			//std::vector<std::string> path4 = split(path[4], ' ');

			//yaw = stof(path4[0]);
			//pitch = stof(path[2]);

			//final_x = camera_fact * cos(yaw)*(cos(pitch*pitch));
			//final_y = camera_fact * sin(yaw)*(cos(pitch*pitch));

			//if (!isnan(final_x) && !isnan(final_y)) {

			/*if (!flycam) {
				//cam.from = embree::Vec3f(camera_fact * (-final_x - mesh_offset_x) - scene_x, camera_fact * (pitch + mesh_offset_z) + scene_z, camera_fact * (-final_y - mesh_offset_y) - scene_y);
				cam.to = embree_pos;
				embree::Vec3fa ff(final_x, pitch, -final_y);
				//ff *= 1;
				cam.from = cam.to - ff;
			}
			else if (flycam) {
				look_iter += look_iter == 0;
				cv::Quatf look_quat(0, 0, 1, 0); //(look_iter / 8) % 3 - 1, (look_iter / 4) % 3 - 1, (look_iter / 2) % 3 - 1, (look_iter / 1) % 3 - 1); // 0, 0, 1, 0
				look_quat = look_quat.normalize();
				//cout << "Look_quat: " << look_quat.toVec() << endl;

				cv::Quatf final_quat = in_quat * look_quat * in_quat.conjugate();
				cv::Vec3f final_axis = final_quat.getAxis();

				up_iter += (up_iter == 0) + (up_iter == look_iter);

				cv::Quatf up_quat(0, 0, 0, 1); // (up_iter / 4) % 3 - 1, (up_iter / 8) % 3 - 1, (up_iter / 1) % 3 - 1, (up_iter / 2) % 3 - 1); // 0, 0, 0, 1
				up_quat = up_quat.normalize();
				//cout << "up_quat: " << up_quat.toVec() << endl;

				final_quat = in_quat * up_quat * in_quat.conjugate();
				cv::Vec3f final_up = final_quat.getAxis();

				cam.from = embree_pos;
				//embree::Vec3fa ff(final_axis[0], final_axis[1], final_axis[2]);
				embree::Vec3fa ff(-final_axis[0], -final_axis[1], final_axis[2]);

				if (ff[0] + ff[1] + ff[2] != 0)
					cam.to = cam.from + ff;
				// cout << "Quat " << path[2] << " " << path[3] << " "  << path[4] << " " << path[5] << endl;


				//embree::Vec3fa fup(final_up[0], final_up[1], final_up[2]);
				embree::Vec3fa fup(-final_up[0], -final_up[1], final_up[2]);
				cam.up = fup;
				//cam.dolly(-0.005f);
				//ff *= 1;
				//cam.to = cam.from + ff;
				embree_pos += cam_speed * ff;

				//cam.up = embree::Vec3f(-roll, cos(roll), 0);
				cout << "Quat " << path[2] << " " << path[3] << " "  << path[4] << " " << path[5] << endl;
			}*/
			//auto rotation = quat.matrix();
			//direction = (rotation * direction).normalized();
			_in_x = stof(path[2]);
			_in_y = stof(path[3]);
			_in_z = stof(path[4]);
			_in_w = stof(path[5]);

		//std::cout << std::endl;
		//cout << "Set " << path[2] << " to " << path[3] << endl;
	}

	else if (path[1] == "z") {
	}
		//float z = stof(path[2]) * 20.f;
		//cam.fov += z;
		//cout << "camera fov: " << cam.fov << "\n";
    }
}


void loadPlanet() {
	auto planetoid = new rocktree_t();
	planetoid->downloaded = false;
	_planetoid = planetoid;

	getPlanetoid([=](std::unique_ptr<PlanetoidMetadata> _metadata) {		
		if (!_metadata) fprintf(stderr, "%s", "no planetoid\n"), abort();
		populatePlanetoid(planetoid, std::move(_metadata));
		
		auto bulk = planetoid->root_bulk;
		assert(bulk->dl_state == dl_state_stub);		
		bulk->setStartedDownloading();
		getBulk(bulk->request, bulk, [=](auto _) { /* todo rm cb */ });
	});
}

void initGL(gl_ctx_t &ctx) {
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);
	ctx.program = makeShader(
		"uniform mat4 transform;"
		"uniform vec2 uv_offset;"
		"uniform vec2 uv_scale;"
		"uniform bool octant_mask[8];"
		"attribute vec3 position;"
		"attribute float octant;"	
		"attribute vec2 texcoords;"		
		"varying vec2 v_texcoords;"
		"void main() {"
		"	float mask = octant_mask[int(octant)] ? 0.0 : 1.0;"
		"	v_texcoords = (texcoords + uv_offset) * uv_scale * mask;"
		"	gl_Position = transform * vec4(position, 1.0) * mask;"
		"}",

		"#ifdef GL_ES\n"
		"precision mediump float;\n"
		"#endif\n"
		"uniform sampler2D texture;"
		"varying vec2 v_texcoords;"
		"void main() {"
		"	gl_FragColor = vec4(texture2D(texture, v_texcoords).rgb, 1.0);"
		"}"
	);
	/*ctx.program = makeShader(
		"uniform mat4 transform;"
		"uniform vec2 uv_offset;"
		"uniform vec2 uv_scale;"
		"uniform bool octant_mask[8];"
		"attribute vec3 position;"
		"attribute float octant;"
		"attribute vec2 texcoords;"
		"varying vec2 v_texcoords;"
		"void main() {"
		"	float mask = octant_mask[int(octant)] ? 0.0 : 1.0;"
		"	v_texcoords = (texcoords + uv_offset) * uv_scale * mask;"
		"	gl_Position = transform * vec4(position, 1.0) * mask;"
		"}",

		"#ifdef GL_ES\n"
		"precision mediump float;\n"
		"#endif\n"
		"uniform sampler2D texture;"
		"varying vec2 v_texcoords;"
		"void main() {"
		"	vec3 newrgb = vec3(texture2D(texture, v_texcoords).r + texture2D(texture, v_texcoords).g + texture2D(texture, v_texcoords).b) / 3.0;"
		"	gl_FragColor = vec4(newrgb.rgb, 1.0);"
		"}"
	);*/
	glUseProgram(ctx.program);
	ctx.transform_loc = glGetUniformLocation(ctx.program, "transform");
	ctx.uv_offset_loc = glGetUniformLocation(ctx.program, "uv_offset");
	ctx.uv_scale_loc = glGetUniformLocation(ctx.program, "uv_scale");
	ctx.octant_mask_loc = glGetUniformLocation(ctx.program, "octant_mask");
	ctx.texture_loc = glGetUniformLocation(ctx.program, "texture");
	ctx.position_loc = glGetAttribLocation(ctx.program, "position");
	ctx.octant_loc = glGetAttribLocation(ctx.program, "octant");
	ctx.texcoords_loc = glGetAttribLocation(ctx.program, "texcoords");

	glEnableVertexAttribArray(ctx.position_loc);
	glEnableVertexAttribArray(ctx.octant_loc);
	glEnableVertexAttribArray(ctx.texcoords_loc);
}

Uint64 NOW = SDL_GetPerformanceCounter();
Uint64 LAST = 0;
double deltaTime = 0;

double changing_mag = 1.0;

double speed = 20.0;

double total_added = 0;

int held = 0;
int held2 = 0;

int quality = 2000;

void save_depth() {
	char *data = (char*)malloc(4 * 1920 * 1080);
	//glFlush();

	glReadPixels(0, 0, 1920, 1080, GL_DEPTH_COMPONENT,  GL_UNSIGNED_INT, data);

	std::cout << data[10000] << " " << data[10001] << " " << data[20434] << " " << data[23452] << " " << data[45733] << " " << data[324522] << "\n";

	std::ofstream out_depth("out_depth.raw", std::ios::out | std::ios::binary);

	out_depth.write(data, 1920*1080*4);// << data;

	out_depth.close();
}

void drawPlanet(gl_ctx_t &ctx) {
	auto planetoid = _planetoid;
	if (!planetoid) return;
	if (!planetoid->downloaded) return;
	if (planetoid->root_bulk->dl_state != dl_state_downloaded) return;	
	auto current_bulk = planetoid->root_bulk;
	auto planet_radius = planetoid->radius;

	Matrix4d projection, viewprojection;

	int width, height;
	SDL_GL_GetDrawableSize(sdl_window, &width, &height);
	glViewport(0, 0, width, height);
	auto sky = 0x000000;
	//auto sky = 0x83b5fc;
	glClearColor((sky>>16 & 0xff) / 255.0f, (sky>>8 & 0xff) / 255.0f, (sky & 0xff) / 255.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	

	auto mouse_state = SDL_GetMouseState(NULL, NULL);
	auto state = SDL_GetKeyboardState(NULL);
	auto key_up_pressed = state[SDL_SCANCODE_W];
	auto key_left_pressed = state[SDL_SCANCODE_A];
	auto key_down_pressed = state[SDL_SCANCODE_S];
	auto key_right_pressed = state[SDL_SCANCODE_D];
	auto key_q_pressed = state[SDL_SCANCODE_Q];
	auto key_e_pressed = state[SDL_SCANCODE_E];
	auto key_low_speed_pressed = state[SDL_SCANCODE_LEFTBRACKET];
	auto key_high_speed_pressed = state[SDL_SCANCODE_RIGHTBRACKET];
	auto key_boost_pressed = state[SDL_SCANCODE_LSHIFT] || state[SDL_SCANCODE_RSHIFT];
	auto mouse_pressed = mouse_state & SDL_BUTTON(SDL_BUTTON_LEFT);

	should_clear = state[SDL_SCANCODE_SPACE];

	// from lat/lon
	// Paris
	static Vector3d ecef = { 4199.344, 173.068, 4782.098 };//...https://www.oc.nps.edu/oc2902w/coord/llhxyz.htm };

	// LA
	//static Vector3d ecef = { -2506438.195020, -4666892.079650, 3539693.923606 };//...https://www.oc.nps.edu/oc2902w/coord/llhxyz.htm };
	static auto ecef_norm = ecef.normalized();
	static Vector3d eye = (ecef_norm * (planet_radius + 10000));

#ifdef FOLLOW_TRAIL
	double new_x = 0;
	double new_y = 0;
	double new_z = 0;

	points_out >> new_x >> new_y >> new_z;

	eye[0] = new_x * 1000.0;
	eye[1] = new_y * 1000.0;
	eye[2] = new_z * 1000.0;

	//ecef_norm = ecef.normalized();
	//eye = (ecef_norm * (planet_radius + 10000));
#endif

	// nyc
	//static Vector3d eye = { 1329866.230289, -4643494.267515, 4154677.131562 };
	static Vector3d direction = { 0.219862, -0.419329, 0.312226 };

	// print position every 2 seconds
	{
		static double ms = 0;
		ms += deltaTime;
		if (ms > 2000) {
			ms = 0;
			printf("pos: %f %f %f, dir: %f %f %f\n", eye.x(), eye.y(), eye.z(), direction.x(), direction.y(), direction.z());
		}
	}

#ifndef FOLLOW_TRAIL
	if (held > 0)
		held--;
	if (state[SDL_SCANCODE_BACKSPACE] && held == 0) {
		held = 120;
		points << eye.x() / 1000.0 << " " << eye.y() / 1000.0 << " " << eye.z() / 1000.0 << "\n";
	}
#endif
	// up is the vec from the planetoid's center towards the sky
	auto up = eye.normalized();

	// projection
	float aspect_ratio = (float)width / (float)height;
	float fov = 0.25f * (float)M_PI;
	auto altitude = eye.norm() - planet_radius;
	auto horizon = sqrt( altitude * (2*planet_radius + altitude) );
	auto near = horizon > 370000 ? altitude / 2 : 1;
	auto far = horizon;
	if (near >= far) near = far - 0.1;
	if (isnan(far) || far < near) far = near + 1;
	//printf("near: %f  far: %f\n", near, far);
	projection = perspective(fov, aspect_ratio, 1.f, far);

	if (key_low_speed_pressed)
		changing_mag /= 1.1;
	if (key_high_speed_pressed)
		changing_mag *= 1.1;
	
	// rotation
	int mouse_x, mouse_y;
	SDL_GetRelativeMouseState(&mouse_x, &mouse_y);

	float values[6];

	for (int i = 0; i < 6; i++) {
		values[i] = ((float)SDL_JoystickGetAxis(controller, i) / 32768.f);
		values[i] = (values[i] < 0 ? -values[i] : values[i]) < 0.1 ? 0 : values[i];
	}

	values[4] = (values[4] + 1.0) / 2.0;
	values[5] = (values[5] + 1.0) / 2.0;

	double yaw = mouse_x * 0.001 + values[2] * 0.02;
	double pitch = -mouse_y * 0.001 + -values[3] * 0.02;
	auto overhead = direction.dot(-up);
	if ((overhead > 0.99 && pitch < 0) || (overhead < -0.99 && pitch > 0))
		pitch = 0;
	auto pitch_axis = direction.cross(up);
	auto yaw_axis = direction.cross(pitch_axis);
	pitch_axis.normalize();
	AngleAxisd roll_angle(0, Vector3d::UnitZ());
	AngleAxisd yaw_angle(yaw, yaw_axis);
	AngleAxisd pitch_angle(pitch, pitch_axis);
	auto quat = roll_angle * yaw_angle * pitch_angle;//Quaterniond(_in_x, _in_y, _in_z, _in_w);//roll_angle * yaw_angle * pitch_angle;
	//quat.x = _in_x;
	//quat.y = _in_y;
	//quat.z = _in_z;
	//quat.w = _in_w;

	//quat = Quaterniond(_in_x, _in_y, _in_z, _in_w);

	auto rotation = quat.matrix();
	auto look_quat = Quaterniond(0, 0, 1, 0);
	auto final_quat = quat * look_quat * quat.conjugate();

	direction = (rotation * direction).normalized();

#ifndef FOLLOW_TRAIL
	if (held2 > 0)
		held2--;
	if (state[SDL_SCANCODE_BACKSPACE] && held2 == 0) {
		held2 = 120;
		directions << direction.x() << " " << direction.y() << " " << direction.z() << "\n";
	}
#endif

#ifdef FOLLOW_TRAIL
	directions_out >> new_x >> new_y >> new_z;

	direction[0] = new_x;
	direction[1] = new_y;
	direction[2] = new_z;
#endif

	//int axis = s.axis;
	//int value = SDL_JoystickGetAxis(controller, axis);
	//speed += ((values[5]) - (values[4])) / 1.0;

	// movement
	auto speed_amp = fmin(1300, powf(fmax(0, (altitude - 500)/10000)+1, 1.337)) / 6;
	auto mag = 100*(deltaTime/17.0)*(1+key_boost_pressed*4) * speed_amp * changing_mag;
	auto sideways = direction.cross(up).normalized();	
	auto forwards = direction * mag;
	auto backwards = -direction * mag;
	auto left = -sideways * mag;
	auto right = sideways * mag;
	auto q = -up * mag;
	auto e = up * mag;
	auto new_eye =  eye + key_up_pressed * forwards
	                    + key_down_pressed * backwards
	                    + key_left_pressed * left
	                    + key_right_pressed * right
	                    + key_q_pressed * q
	                    + key_e_pressed * e
	                    + (values[0] * right * 4.0)
	                    + (((values[1] + 1.0) * changing_mag) * (values[5] - values[4]) * forwards * 4.0);
	auto pot_altitude = new_eye.norm() - planet_radius;
	if (pot_altitude < 1000 * 1000 * 10) {
		eye = new_eye;		
	}

	auto view = lookAt(eye, eye + direction, up);
	viewprojection = projection * view;

	auto frustum_planes = getFrustumPlanes(viewprojection); // for obb culling

	const std::string octs[] = { "0", "1", "2", "3", "4", "5", "6", "7" };
	std::vector<std::pair<std::string, rocktree_t::bulk_t *>> valid = { std::make_pair("", current_bulk) };
	decltype(valid) next_valid;
	std::map<std::string, rocktree_t::node_t *> potential_nodes;
	//std::multimap<double, rocktree_t::node_t *> dist_nodes;

	// todo: improve download order
	// todo: abort emscripten_fetch_close() https://emscripten.org/docs/api_reference/fetch.html
	//       and/or emscripten coroutine fetch semaphore	
	// todo: purge branches less aggressively	
	// todo: workers instead of shared mem https://emscripten.org/docs/api_reference/emscripten.h.html#worker-api	

	std::map<std::string, rocktree_t::bulk_t *> potential_bulks;

	//int oct_total = 0;

	// node culling and level of detail using breadth-first search
	for (;;) {
		for(auto cur2 : valid) {
			auto cur = cur2.first;
			auto bulk = cur2.second;

			if (cur.size() > 0 && cur.size() % 4 == 0) {
				auto rel = cur.substr (floor((cur.size() - 1) / 4) * 4, 4);
				auto bulk_kv = bulk->bulks.find(rel);
				auto has_bulk = bulk_kv != bulk->bulks.end();
				if (!has_bulk) continue;
				auto b = bulk_kv->second.get();
				potential_bulks[cur] = b;
				if (b->dl_state == dl_state_stub) {
					b->setStartedDownloading();
					getBulk(b->request, b, [=](auto) {});			
				}
				if (b->dl_state != dl_state_downloaded) continue;
				bulk = b;
			}
			potential_bulks[cur] = bulk;

						
			for(auto o : octs) {
				auto nxt = cur + o;				
				auto nxt_rel = nxt.substr (floor((nxt.size() - 1) / 4) * 4, 4);
				auto node_kv = bulk->nodes.find(nxt_rel);
				if (node_kv == bulk->nodes.end()) // node at "nxt" doesn't exist
					continue;				
				auto node = node_kv->second.get();						

				//std::cout << "r " << (&node->obb.extents)->norm() << "  \n";

				// cull outside frustum using obb
				// todo: check if it could cull more
				if (obb_frustum_outside == classifyObbFrustum(&node->obb, frustum_planes)) {
					continue;
				}

				// level of detail
				/*{
					auto obb_center = node->obb.center;
					auto obb_max_diameter = fmax(fmax(node->obb.extents[0], node->obb.extents[1]), node->obb.extents[2]);			
					
					auto t = Affine3d().Identity();
					t.translate(Vector3d(obb_center.x(), obb_center.y(), obb_center.z()));
					t.scale(obb_max_diameter);
					Matrix4d viewprojection_d;
					for(auto i = 0; i < 16; i++) viewprojection_d.data()[i] = viewprojection.data()[i];
					auto m = viewprojection_d * t;
					auto s = m(3, 3);
					if (s < 0) s = -s; // ?
					auto diameter_in_clipspace = 2 * (obb_max_diameter / s);  // *2 because clip space is -1 to +1
					auto amplify = 8; // todo: meters per texel
					if (diameter_in_clipspace < 0.5 / amplify) {
						continue;
					}
				}*/

				{
					auto t = Affine3d().Identity();					
					t.translate(eye + (eye-node->obb.center).norm() * direction);
					auto m = viewprojection * t;
					auto s = m(3, 3);
					auto texels_per_meter = 1.0f / node->meters_per_texel;
					auto wh = quality; // width < height ? width : height;
					auto r = (2.0*(1.0/s)) * wh;
					if (texels_per_meter > r) continue;
				}

				next_valid.push_back(std::make_pair(nxt, bulk));

				if (node->can_have_data) {
					potential_nodes[nxt] = node;
					//auto d = (node->obb.center - eye).squaredNorm();
					//dist_nodes[d] = node;
					//dist_nodes.insert(std::make_pair (d, node));
				}
			}
		}
		if (next_valid.size() == 0) break;
		valid = next_valid;
		next_valid.clear();		
	}	

	for (auto kv = potential_nodes.begin(); kv != potential_nodes.end(); ++kv) { // normal order
	//for (auto kv = potential_nodes.rbegin(); kv != potential_nodes.rend(); ++kv) { // reverse order
	//for (auto kv = dist_nodes.rbegin(); kv != dist_nodes.rend(); ++kv) { // reverse order
	//for (auto kv = dist_nodes.begin(); kv != dist_nodes.end(); ++kv) { // normal order
		auto node = kv->second;
		if (node->dl_state == dl_state_stub) {
			node->setStartedDownloading();
			node->when_added = total_added;
			total_added++;
			getNode(node->request, node, [node](auto) {});
		}
	}

	// unbuffer and obsolete nodes
	std::vector<rocktree_t::bulk_t*> x = {current_bulk};
	auto buf_cnt = 0, obs_n_cnt = 0, total_n = 0;
	while(!x.empty()) {
		auto cur_bulk = x[0]; x.erase(x.begin());
		// prepare next iteration
		for (auto &kv : cur_bulk->bulks) {
			auto b = kv.second.get();
			if (b->dl_state != dl_state_downloaded) continue;
			x.emplace(x.begin(), b);
		}
		// current iteration
		for (auto &kv : cur_bulk->nodes) {
			auto n = kv.second.get();
			if (n->dl_state != dl_state_downloaded) continue;
			
			// just count buffers
			for (auto &m : n->meshes) { if (m.buffered) { buf_cnt++; break;}}
			
			total_n++;
			auto p = n->request.node_key().path();
			auto has = potential_nodes.find(p) != potential_nodes.end();
			if (!has && total_added - n->when_added > 1000) {
			//if (false) {
				// node is obsolete
				obs_n_cnt++;

				// unbuffer
				for (auto &mesh : n->meshes) {
					if (mesh.buffered) unbufferMesh(mesh);
				}
				// clean up
				n->_data = nullptr;
				n->matrix_globe_from_mesh = Matrix4d::Zero();
				n->meshes.clear();
				n->setDeleted();
			}
		}
	}

	// post order dfs purge obsolete bulks
	auto total_b = 0, obs_b_cnt = 0;	
	std::function<void(rocktree_t::bulk_t *)> po;
	po = [&po, &potential_bulks, &obs_b_cnt, &total_b](rocktree_t::bulk_t * b){
		for (auto &kv : b->bulks){
			auto b = kv.second.get();
			if (b->dl_state == dl_state_downloaded)
				po(b);
		}
		total_b++;
		auto p = b->request.node_key().path();
		auto has = potential_bulks.find(p) != potential_bulks.end();
		if (!has) {
			if (b->busy_ctr == 0) {
				b->nodes.clear();
				b->bulks.clear();
				b->setDeleted();
			}			
		}
	};

	po(current_bulk);

	// log stuff about buffers
	{
		static double ms = 0;
		ms += deltaTime;
		if (ms > 2000) {
			ms = 0;
			printf("buffered: %d, tot_n: %d, tot_b: %d, pot_n: %lu, pot_b: %lu, obs n: %d, obs b: %d\n", 
				buf_cnt, total_n, total_b, potential_nodes.size(), potential_bulks.size(), obs_n_cnt, obs_b_cnt
			);
		}
	}

	// 8-bit octant mask flags of nodes
	std::map<std::string, uint8_t> mask_map;

	for (auto kv = potential_nodes.rbegin(); kv != potential_nodes.rend(); ++kv) { // reverse order
		auto full_path = kv->first;
		auto node = kv->second;
		auto level = strlen(full_path.c_str());
		assert(level > 0);		
		assert(node->can_have_data);
		if (node->dl_state != dl_state_downloaded) continue;

		// set octant mask of previous node
		auto octant = (int)(full_path[level - 1] - '0');
		auto prev = full_path.substr (0, level - 1);
		mask_map[prev] |= 1 << octant;

		// skip if node is masked completely
		if (mask_map[full_path] == 0xff) continue;

		// float transform matrix
		Matrix4d transform = viewprojection * node->matrix_globe_from_mesh;
		Matrix4f transform_float;
		for(auto i = 0; i < 16; ++i) transform_float.data()[i] = (float)(transform.data()[i]);

		// buffer, bind, draw
		glUniformMatrix4fv(ctx.transform_loc, 1, GL_FALSE, transform_float.data());
		for (auto &mesh : node->meshes) {
			if (!mesh.buffered) bufferMesh(mesh);
			bindAndDrawMesh(mesh, mask_map[full_path], ctx);
		}
		//bufs[full_path] = node;
	}

	if (state[SDL_SCANCODE_O])
		save_depth();

	if (state[SDL_SCANCODE_UP]) {
		quality += 20;
		std::cout << "Quality = " << quality << std::endl;
	}

	if (state[SDL_SCANCODE_DOWN]) {
		quality -= 20;
		std::cout << "Quality = " << quality << std::endl;
	}
}

void handleJaxis(SDL_JoyAxisEvent s) {
	int axis = s.axis;
	int value = SDL_JoystickGetAxis(controller, axis);


}

bool quit = false;
void mainloop(gl_ctx_t &ctx) {
	SDL_Event sdl_event;

	int val;
	while (SDL_PollEvent(&sdl_event)) {
		switch (sdl_event.type) {
			case SDL_JOYAXISMOTION:
				handleJaxis(sdl_event.jaxis);
				//val = SDL_JoystickGetAxis(controller, sdl_event.jaxis.axis);
				//std::cout << "Got axis " << (int)sdl_event.jaxis.axis << " with val " << val << " \n";
				break;
			case SDL_QUIT:
				quit = true;
				break;
			case SDL_KEYDOWN:
				if (sdl_event.key.keysym.sym == SDLK_ESCAPE) quit = true;
				break;
		}
	}

	LAST = NOW;
	NOW = SDL_GetPerformanceCounter();
	deltaTime = (double)((NOW - LAST)*1000 / (double)SDL_GetPerformanceFrequency());

	drawPlanet(ctx);
	SDL_GL_SwapWindow(sdl_window);
}

void initGamepad(SDL_Joystick *joy) {
	const char *name = SDL_JoystickName(joy);
	const int num_axes = SDL_JoystickNumAxes(joy);
	const int num_buttons = SDL_JoystickNumButtons(joy);
	const int num_hats = SDL_JoystickNumHats(joy);

	printf("Now reading from joystick '%s' with:\n"
			"%d axes\n"
			"%d buttons\n"
			"%d hats\n\n",
			name,
			num_axes,
			num_buttons,
			num_hats);
}

int main(int argc, char* argv[]) {

	int video_width = 2256;
	int video_height = 1504;

	//std::thread t(listenKinect);
	//t.detach();

	if (SDL_VideoInit("offscreen") < 0) {
        SDL_Log("Couldn't initialize the offscreen video driver: %s\n",
            SDL_GetError());
        return SDL_FALSE;
    }

	//SDL_InitSubSystem(SDL_INIT_JOYSTICK);

	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK) != 0) {
		fprintf(stderr, "Couldn't init SDL2: %s\n", SDL_GetError());
		exit(1);
	}
#ifdef EMSCRIPTEN
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK,
		SDL_GL_CONTEXT_PROFILE_ES);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 2);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 0);
#else
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK,
		SDL_GL_CONTEXT_PROFILE_COMPATIBILITY);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 4);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 4);
#endif	
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	sdl_window = SDL_CreateWindow("Earth Client", 
		SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED,
		video_width, video_height, 
		 SDL_WINDOW_OPENGL | SDL_WINDOW_RESIZABLE | SDL_WINDOW_ALLOW_HIGHDPI | SDL_WINDOW_FULLSCREEN);

	if (!sdl_window) {
		fprintf(stderr, "Couldn't create window: %s\n", SDL_GetError());
		exit(1);
	}
	SDL_GLContext gl_context = SDL_GL_CreateContext(sdl_window);
	if (!gl_context) {
		fprintf(stderr, "Couldn't create OpenGL context: %s\n", SDL_GetError());
		exit(1);
	}
	SDL_GL_SetSwapInterval(1);

#if defined(_WIN32) || defined(__linux__)
	// init glad
	if (!gladLoadGL()) {
		fprintf(stderr, "Failed to init glad\n");
		exit(1);
	}
#endif

	if (SDL_NumJoysticks() < 1){
		std::cout << "No joystick detected." << std::endl;
	}
	else{
		controller = SDL_JoystickOpen(0);
		if (controller == NULL){
			std::cout << "Error: Unable to open Joystick." << std::endl;
		}
		else{
			initGamepad(controller);
			//isUsingJoystick = true;
		}
	}

	auto ctx = new gl_ctx_t();

	initGL(*ctx);
	loadPlanet();

	SDL_SetRelativeMouseMode(SDL_TRUE);
	SDL_CaptureMouse(SDL_FALSE);

#ifdef EMSCRIPTEN
	emscripten_set_main_loop_arg([](void* _ctx){	
		auto ctx = (gl_ctx_t *)_ctx;
		mainloop(*ctx);
	}, (void *)ctx, 0, 1);
#else
	while (!quit) mainloop(*ctx);
#endif

	SDL_GL_DeleteContext(gl_context);
	SDL_DestroyWindow(sdl_window);
	SDL_Quit();
	delete ctx;
	
	return 0;
}
