import requests
import json
import time
import os
import m3u8

url_stub = "https://www.radiofrance.fr"
pikapi_stub = "https://www.radiofrance.fr/pikapi/images/" # uuid/576x576

tracks_filename = "tracks.json"
covers_folder = "covers"

# songs within the hour: https://www.radiofrance.fr/api/songs?station=fip&start=1749279600&stop=1749283200

class Track(dict):
    firstLine: str = ""
    secondLine: str = ""
    uuid: str = ""
    cover: str = ""
    startTime: int = 0
    endTime: int = 0

    def __init__(self, firstLine, secondLine, uuid, cover, startTime, endTime):
        dict.__init__(self, firstLine=firstLine, secondLine=secondLine, uuid=uuid, cover=cover, startTime=startTime, endTime=endTime)
        self.firstLine = firstLine
        self.secondLine = secondLine
        self.uuid = uuid
        self.cover = cover
        self.startTime = startTime
        self.endTime = endTime

    def save_cover(self):
        target_cover_filename = covers_folder + "/" + self.cover + ".webp"

        if not os.path.exists(covers_folder):
            os.mkdir(covers_folder)
        if not os.path.exists(target_cover_filename):
            print(f"Could not find cover with uuid: {self.cover}, downloading...")
        else:
            return

        r = requests.get(pikapi_stub + self.cover + "/576x576")
        if r.status_code == 200:
            with open(target_cover_filename, "wb") as t:
                t.write(r.content)
                t.close()
                print(f"Wrote to {target_cover_filename}")
        else:
            print(f"ERROR: Got error: {r.status_code} while trying to download")


tracks = {}

def add_track(tracks: dict, track: dict):
    if track.get("secondLineSongUuid") == None:
        print("ERROR: Trying to add track but track does not have a uuid.")
        print(f"    Track: {track}")
        return

    if tracks.get(track["secondLineSongUuid"]):
        print("INFO: track already added")
        return

    t = track
    new_track = Track(t["firstLine"], t["secondLine"], t["secondLineSongUuid"], t["cover"], t["startTime"], t["endTime"])

    print(f"Trying to add track with uuid: {new_track.uuid}")
    tracks[new_track.uuid] = new_track

    new_track.save_cover()
    return


def save_tracks(tracks):
    out_file = open(tracks_filename, "w")
    json.dump(tracks, out_file)
    print(f"Saved {len(tracks)} tracks to {tracks_filename}")
    out_file.close()


def read_tracks():
    global tracks
    if os.path.exists(tracks_filename):
        in_file = open(tracks_filename, "r")
        tracks = json.load(in_file)
        print(f"Loaded {len(tracks)} tracks from {tracks_filename}")
        in_file.close()
    else:
        tracks = {}
        print(f"Could not locate {tracks_filename}")




def parse_m3u8(m3u8_txt):
    return


def fetch_m3u8():
    requests.get(f"{url_stub}/")

def fetch_current_songs():
    global tracks
    # fetch latest tracks
    url = "https://api.radiofrance.fr/livemeta/live/7/transistor_musical_player"
    raw_tracks = requests.get(url)
    json_tracks = {}

    if raw_tracks.status_code == 200:
        print("Success fetching tracks")
        json_tracks = json.loads(raw_tracks.text)

        if json_tracks.get("now"):
            add_track(tracks, json_tracks["now"])
        if json_tracks.get("prev"):
            add_track(tracks, json_tracks["prev"][0])
        if json_tracks.get("next"):
            add_track(tracks, json_tracks["next"][0])

        delay = int(json_tracks.get("delayToRefresh"))
        return (delay / 1000)

    else:
        print(f"ERROR: Got http code {raw_tracks.status_code} while fetching tracks from " + "\"" + url + "\"")
        return 10

read_tracks()

while True:
    delay = fetch_current_songs()
    print(f"Waiting {delay} seconds...")
    save_tracks(tracks)
    time.sleep(delay)


