import os
import subprocess
from http.server import BaseHTTPRequestHandler, HTTPServer
import urllib.parse
import mimetypes

class MyHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        print(self.path)

        parsed_url = urllib.parse.urlparse(self.path)

        output_filename = parsed_url.path[1:] #'/dev/shm/' + str(len(self.path)) + "_" + filename.split('.')[0].split("/")[-1] + '.wav'
        print(output_filename)

        if self.path == "/":
            output_filename = "flymusic_5_1.html"

        # Open the converted file and read it
        with open(output_filename, 'rb') as f:
            content = f.read()

        # Send response headers
        self.send_response(200)
        #self.send_header('Content-type', 'audio/x-wav')
        mimetype, _ = mimetypes.guess_type(output_filename)
        self.send_header('Content-type', mimetype)
        self.send_header('Content-Length', len(content))
        self.send_header('Access-Control-Allow-Origin', '*')
        self.send_header('Cross-Origin-Embedder-Policy', 'require-corp')
        self.send_header('Cross-Origin-Opener-Policy', 'same-origin')
        self.end_headers()

        # Send the content
        self.wfile.write(content)

def run(server_class=HTTPServer, handler_class=MyHandler):
    server_address = ('', 10454)
    httpd = server_class(server_address, handler_class)
    print('Starting httpd...')
    print("Access here: http://localhost:10454/")
    httpd.serve_forever()

if __name__ == '__main__':
    run()
