GDPC                 `                                                                      8   ,   res://.godot/global_script_class_cache.cfg  ]?           3ΗHJHS    T   res://.godot/imported/Marianne-Regular.otf-4733b69df74be89ffc504d817ffaecce.fontdatapH           zvK;jOl    X   res://.godot/imported/Marianne-Regular.woff2-e239f157ae10b280de4db3f387c7a9b1.fontdata               w/wLΨ߇k    D   res://.godot/imported/icon.svg-218a8f2b3041327d8a5756f3a245f83b.ctex      \
      6(4d=EQǮVj,    H   res://.godot/imported/tesseract.glb-02c38bc0c75f05c5a50fbde9890bb914.scn     0,      DZ-Ggq    L   res://.godot/imported/tesseract.obj-85e8805adca942c009bebe3d2cba6e18.mesh               ޯx;8'    L   res://.godot/imported/tesseract2.obj-e8cc5647172b9a4fdd0ad7b32faa74a2.mesh  @            s1H>~[       res://.godot/uid_cache.bin  E           z2Ĩ:       res://AlbumArt.gd   P            $ׇyFz̙'       res://BottomInfo.gd             56]u:q       res://CollectionBar.gd  p     4      R3V9E>$<Qfk       res://CurveWand.gd  0     <      -^6i=}LG    <   res://GDTIM/CustomInputEvents/InputEventMultiScreenDrag.gd          %      6é>rkl    @   res://GDTIM/CustomInputEvents/InputEventMultiScreenLongPress.gd 0            Y ?5}8vBjv    <   res://GDTIM/CustomInputEvents/InputEventMultiScreenSwipe.gd       $      I<݁WT㟚    <   res://GDTIM/CustomInputEvents/InputEventMultiScreenTap.gd               4@Zk    8   res://GDTIM/CustomInputEvents/InputEventScreenCancel.gd       %      T=^4ݏ:p_    8   res://GDTIM/CustomInputEvents/InputEventScreenPinch.gd              m!    8   res://GDTIM/CustomInputEvents/InputEventScreenTwist.gd              J0r gW9Q    <   res://GDTIM/CustomInputEvents/InputEventSingleScreenDrag.gd P            S'!jQ?Ј1z<    @   res://GDTIM/CustomInputEvents/InputEventSingleScreenLongPress.gd      j      ֬QSS    <   res://GDTIM/CustomInputEvents/InputEventSingleScreenSwipe.gd            k!ꖿV_B    <   res://GDTIM/CustomInputEvents/InputEventSingleScreenTap.gd  @            |5w<ssؿh    <   res://GDTIM/CustomInputEvents/InputEventSingleScreenTouch.gd      }      l,zF,nM9#xYN       res://GDTIM/InputManager.gd P      h:      #.GEW$z       res://GDTIM/RawGesture.gd   U            3'JZ
@s       res://GDTIM/Util.gd pp            3 64CMQ       res://Generator.gd       8<      	ܸW"~)r'       res://HelpMenu.gd   P            N,`*ϹU8A@-       res://Main.tscn      S      3K:    $   res://Marianne-Regular.otf.import   @            8lh%}F/Nd.    $   res://Marianne-Regular.woff2.import G            dzD}ߣ"ɚI̙       res://MusicPlayer.gd{      +'      }sS+ӻ9y1       res://Path.gd   pb           Cޒh&P4:
       res://Player.tscn    r      	      6kUͰh7       res://PlayerMove.gd r     ^"      M=1y>kQ       res://ProgressIndicator.gd  \     h      z2*%90:!       res://Sprite2D.gd   [           \ؤf?rM6o)!       res://ValueCurve.gd P     q      <Zƍwt$       res://ValueCurve.tres              rUU\YU	 Y       res://ValuesCurve.gd     
      gQۿCdׅy       res://XCurve.gd  ^     p      xTЎV<	       res://col_names.txt p           P1p       res://datasets.txt  ]?     P       *_|Α[J/        res://default_bus_layout.tres        X      bDЈwn       res://flymusic_logo_1200.pngi?     !t     ((3GoW    $   res://flymusic_logo_1200.png.import              21G
H}}       res://icon.svg.import               Te
x&K{       res://invert_tess.tres  n     o      aMOoYߜsb       res://invert_tess2.tres              kHw;f       res://project.binaryF     ?      uBG܏c        res://songcache_additions.txt   @     G;     {E)i-xMncT       res://tesseract.glb.import   @            Xe~},E:e       res://tesseract.obj.import  @            >qk
       res://tesseract.tres     A      3 3B7
XtA{Y       res://tesseract2.obj.import Z            1vN?y*$    class_name InputEventMultiScreenDrag
extends InputEventAction

var position   : Vector2
var relative   : Vector2
var fingers    : int
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null, event : InputEventScreenDrag = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		fingers  = raw_gesture.size()
		position = raw_gesture.centroid("drags", "position")
		relative = event.relative/fingers 

func as_string() -> String:
	return "position=" + str(position) + "|relative=" + str(relative) + "|fingers=" + str(fingers)
~hVd{class_name InputEventMultiScreenLongPress
extends InputEventAction

var position   : Vector2
var fingers    : int
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture: 
		fingers = raw_gesture.size()
		position = raw_gesture.centroid("presses", "position")

func as_string() -> String:
	return "position=" + str(position) + "|fingers=" + str(fingers)
MQclass_name InputEventMultiScreenSwipe
extends InputEventAction

var position   : Vector2
var relative   : Vector2
var fingers    : int 
var raw_gesture : RawGesture 

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		fingers = raw_gesture.size()
		position = raw_gesture.centroid("presses", "position")
		relative = raw_gesture.centroid("releases", "position") - position

func as_string() -> String:
	return "position=" + str(position) + "|relative=" + str(relative) + "|fingers=" + str(fingers)
09H*큇4zclass_name InputEventMultiScreenTap
extends InputEventAction

var position   : Vector2
var fingers    : int
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture: 
		fingers = raw_gesture.size()
		position = raw_gesture.centroid("presses", "position")

func as_string() -> String:
	return "position=" + str(position) + "|fingers=" + str(fingers)
eŇ/2class_name InputEventScreenCancel
extends InputEventAction

var raw_gesture : RawGesture
var event       : InputEvent

func _init(_raw_gesture : RawGesture, _event : InputEvent) -> void:
	raw_gesture = _raw_gesture
	event       = _event

func as_string() -> String:
	return "gesture canceled"
M87<jclass_name InputEventScreenPinch
extends InputEventAction

var position   : Vector2
var relative   : float
var distance   : float
var fingers    : int
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null, event : InputEventScreenDrag = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		raw_gesture = _raw_gesture.copy()
		fingers  = raw_gesture.drags.size()
		position = raw_gesture.centroid("drags", "position")

		distance = 0
		for drag in raw_gesture.drags.values():
			var centroid_relative_position = drag.position - position
			distance += centroid_relative_position.length()

		var centroid_relative_position = event.position - position
		relative = ((centroid_relative_position + event.relative).length() - centroid_relative_position.length())


func as_string() -> String:
	return "position=" + str(position) + "|relative=" + str(relative) +"|distance ="+str(distance) + "|fingers=" + str(fingers)
class_name InputEventScreenTwist
extends InputEventAction

var position   : Vector2
var relative   : float
var fingers    : int
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null, event : InputEventScreenDrag = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		fingers  = raw_gesture.drags.size()
		position = raw_gesture.centroid("drags", "position")
			
		var centroid_relative_position = event.position - position
		relative = centroid_relative_position.angle_to(centroid_relative_position + event.relative)/fingers

func as_string() -> String:
	return "position=" + str(position) + "|relative=" + str(relative) + "|fingers=" + str(fingers)
@#NاDclass_name InputEventSingleScreenDrag
extends InputEventAction

var position   : Vector2
var relative   : Vector2
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		var dragEvent = raw_gesture.drags.values()[0]
		position = dragEvent.position
		relative = dragEvent.relative

func as_string():
	return "position=" + str(position) + "|relative=" + str(relative)
J$^class_name InputEventSingleScreenLongPress
extends InputEventAction

var position   : Vector2
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		if !raw_gesture.presses.has(0):
			print("RAW GESTURE:\n" + raw_gesture.as_text())
			var linear_event_history = raw_gesture.get_linear_event_history()
			var history = "\nHISTORY:\n"
			for e in linear_event_history:
				if e is RawGesture.Drag:
					history += "D | "
				else:
					history += "T | "
				history += e.as_text()
				history +="\n"
			print(history)
			var error_msg="Hello! we are trying to fix this bug.\nTo help us please copy the output and comment it (attached as a file) in the following issue: https://github.com/Federico-Ciuffardi/GodotTouchInputManager/issues/20\nAlso, if you can, include in that comment what version of Godot you are using, what platform you are running on, and what you were doing when the error occurred.\nThanks!"
			print(error_msg)			
		position = raw_gesture.presses.values()[0].position


func as_string() -> String:
	return "position=" + str(position)
H.Kclass_name InputEventSingleScreenSwipe
extends InputEventAction

var position   : Vector2
var relative   : Vector2
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		position = raw_gesture.presses[0].position
		relative = raw_gesture.releases[0].position - position


func as_string() -> String:
	return "position=" + str(position) + "|relative=" + str(relative)
 f4class_name InputEventSingleScreenTap
extends InputEventAction

var position   : Vector2
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		position = raw_gesture.presses.values()[0].position

func get_raw_gesture() -> RawGesture:
	return raw_gesture

func as_string() -> String:
	return "position=" + str(position)
5^class_name InputEventSingleScreenTouch
extends InputEventAction

var position   : Vector2
var canceled  : bool
var raw_gesture : RawGesture

func _init(_raw_gesture : RawGesture = null) -> void:
	raw_gesture = _raw_gesture
	if raw_gesture:
		pressed = raw_gesture.releases.is_empty()
		if pressed:
			position = raw_gesture.presses.values()[0].position
		else:
			position = raw_gesture.releases.values()[0].position
		canceled = raw_gesture.size() > 1

func get_raw_gesture() -> RawGesture:
	return raw_gesture

func as_string() -> String:
	return "position=" + str(position) + "|pressed=" + str(pressed) + "|canceled=" + str(canceled)
p# warning-ignore-all:return_value_discarded
# warning-ignore-all:unused_signal

extends Node

##########
# Config #
##########

const DEFAULT_BINDIGS : bool = true

const DEBUG : bool = false 

const DRAG_STARTUP_TIME : float = 0.02

const FINGER_SIZE : float = 100.0

const MULTI_FINGER_RELEASE_THRESHOLD : float = 0.1

const TAP_TIME_LIMIT     : float = 0.2
const TAP_DISTANCE_LIMIT : float = 25.0

const LONG_PRESS_TIME_THRESHOLD : float = 0.75
const LONG_PRESS_DISTANCE_LIMIT : float = 25.0

const SWIPE_TIME_LIMIT         : float = 0.5
const SWIPE_DISTANCE_THRESHOLD : float = 200.0

#########
# CONST #
#########

const Util : GDScript = preload("Util.gd")

const	swipe2dir : Dictionary = \
{
	"swipe_up"         : Vector2.UP,
	"swipe_up_right"   : Vector2.UP + Vector2.RIGHT,
	"swipe_right"      : Vector2.RIGHT,
	"swipe_down_right" : Vector2.DOWN + Vector2.RIGHT,
	"swipe_down"       : Vector2.DOWN,
	"swipe_down_left"  : Vector2.DOWN + Vector2.LEFT,
	"swipe_left"       : Vector2.LEFT,
	"swipe_up_left"    : Vector2.UP + Vector2.LEFT
}


###########
# Signals #
###########

signal touch 
signal drag
signal single_tap
signal single_touch
signal single_drag
signal single_swipe
signal single_long_press
signal multi_drag
signal multi_tap
signal multi_swipe
signal multi_long_press
signal pinch
signal twist
signal raw_gesture
signal cancel
signal any_gesture

########
# Enum #
########

enum Gesture {PINCH, MULTI_DRAG, TWIST, SINGLE_DRAG, NONE}

########
# Vars #
########

var raw_gesture_data : RawGesture = RawGesture.new() # Current raw_gesture
var real_raw : RawGesture

var _mouse_event_press_position : Vector2
var _mouse_event : int = Gesture.NONE


var _drag_startup_timer : Timer = Timer.new()
var _long_press_timer   : Timer = Timer.new()

var _single_touch_cancelled : bool = false
var _single_drag_enabled    : bool = false 

#############
# Functions #
#############

func _ready() -> void:
	_add_timer(_drag_startup_timer, "_on_drag_startup_timer_timeout")
	_add_timer(_long_press_timer,   "_on_long_press_timer_timeout")

	if DEFAULT_BINDIGS:
		_set_default_action("multi_swipe_up"        , _native_key_event(KEY_I))
		_set_default_action("multi_swipe_up_right"  , _native_key_event(KEY_O))
		_set_default_action("multi_swipe_right"     , _native_key_event(KEY_L))
		_set_default_action("multi_swipe_down_right", _native_key_event(KEY_PERIOD))
		_set_default_action("multi_swipe_down"      , _native_key_event(KEY_COMMA))
		_set_default_action("multi_swipe_down_left" , _native_key_event(KEY_M))
		_set_default_action("multi_swipe_left"      , _native_key_event(KEY_J))
		_set_default_action("multi_swipe_up_left"   , _native_key_event(KEY_U))

		_set_default_action("single_swipe_up"        , _native_key_event(KEY_W))
		_set_default_action("single_swipe_up_right"  , _native_key_event(KEY_E))
		_set_default_action("single_swipe_right"     , _native_key_event(KEY_D))
		_set_default_action("single_swipe_down_right", _native_key_event(KEY_C))
		_set_default_action("single_swipe_down"      , _native_key_event(KEY_X))
		_set_default_action("single_swipe_down_left" , _native_key_event(KEY_Z))
		_set_default_action("single_swipe_left"      , _native_key_event(KEY_A))
		_set_default_action("single_swipe_up_left"   , _native_key_event(KEY_Q))

		# _set_default_action("single_touch"           , _native_mouse_button_event(MOUSE_BUTTON_LEFT))
		_set_default_action("multi_touch"              , _native_mouse_button_event(MOUSE_BUTTON_MIDDLE))
		# _set_default_action("pinch"                  , _native_mouse_button_event(MOUSE_BUTTON_RIGHT)) # TODO
		_set_default_action("pinch_outward"            , _native_mouse_button_event(MOUSE_BUTTON_WHEEL_UP))
		_set_default_action("pinch_inward"             , _native_mouse_button_event(MOUSE_BUTTON_WHEEL_DOWN))
		_set_default_action("twist"                    , _native_mouse_button_event(MOUSE_BUTTON_RIGHT))
		# _set_default_action("twist_clockwise"        , _native_mouse_button_event(MOUSE_BUTTON_WHEEL_UP)) # TODO
		# _set_default_action("twist_counterclockwise" , _native_mouse_button_event(MOUSE_BUTTON_WHEEL_DOWN)) # TODO

func _unhandled_input(event : InputEvent) -> void:
	if event is InputEventScreenDrag:
		_handle_screen_drag(event)
	elif event is InputEventScreenTouch:
		_handle_screen_touch(event)
	elif event is InputEventMouseMotion:
		_handle_mouse_motion(event)
	else:
		_handle_action(event)
		
func _handle_mouse_motion(event : InputEventMouseMotion) -> void:
	real_raw = raw_gesture_data.copy()
	if raw_gesture_data.size() == 1 and _mouse_event == Gesture.SINGLE_DRAG:
		_emit("drag", _native_drag_event(0, event.position, event.relative, event.velocity))
	elif raw_gesture_data.size() == 2 and _mouse_event == Gesture.MULTI_DRAG:
		var offset = Vector2(5,5)
		var e0 = _native_drag_event(0, event.position-offset, event.relative, event.velocity)
		raw_gesture_data._update_screen_drag(e0)
		var e1 = _native_drag_event(1, event.position+offset, event.relative, event.velocity)
		raw_gesture_data._update_screen_drag(e1)
		_emit("multi_drag", InputEventMultiScreenDrag.new(raw_gesture_data,e0))
		_emit("multi_drag", InputEventMultiScreenDrag.new(raw_gesture_data,e1))
	elif _mouse_event == Gesture.TWIST:
		var rel1 = event.position - _mouse_event_press_position
		var rel2 = rel1 + event.relative
		var twist_event = InputEventScreenTwist.new()
		twist_event.position = _mouse_event_press_position
		twist_event.relative = rel1.angle_to(rel2)
		twist_event.fingers  = 2
		_emit("twist", twist_event)

func _handle_screen_touch(event : InputEventScreenTouch) -> void:
	if event.index < 0:
		_emit("cancel", InputEventScreenCancel.new(raw_gesture_data, event))
		_end_gesture()
		return

	# ignore orphaned touch release events
	if !event.pressed and not event.index in raw_gesture_data.presses:
		return

	raw_gesture_data._update_screen_touch(event)
	real_raw = raw_gesture_data.copy()
	_emit("raw_gesture", raw_gesture_data)
	var index : int = event.index
	if event.pressed:
		if raw_gesture_data.size() == 1: # First and only touch
			_long_press_timer.start(LONG_PRESS_TIME_THRESHOLD)
			_single_touch_cancelled = false
			_emit("single_touch", InputEventSingleScreenTouch.new(raw_gesture_data))
		elif !_single_touch_cancelled :
				_single_touch_cancelled = true
				_cancel_single_drag()
				_emit("single_touch", InputEventSingleScreenTouch.new(raw_gesture_data))
	else:
		var fingers : int = raw_gesture_data.size() 
		if index == 0:
			_emit("single_touch", InputEventSingleScreenTouch.new(raw_gesture_data))
			if !_single_touch_cancelled:
				var distance : float = (raw_gesture_data.releases[0].position - raw_gesture_data.presses[0].position).length()
				if raw_gesture_data.elapsed_time < TAP_TIME_LIMIT and distance <= TAP_DISTANCE_LIMIT:
					_emit("single_tap", InputEventSingleScreenTap.new(raw_gesture_data))
				if raw_gesture_data.elapsed_time < SWIPE_TIME_LIMIT and distance > SWIPE_DISTANCE_THRESHOLD:
					_emit("single_swipe", InputEventSingleScreenSwipe.new(raw_gesture_data))
		if raw_gesture_data.active_touches == 0: # last finger released
			if _single_touch_cancelled:
				var distance : float = (raw_gesture_data.centroid("releases","position") - raw_gesture_data.centroid("presses","position")).length()
				if raw_gesture_data.elapsed_time < TAP_TIME_LIMIT and distance <= TAP_DISTANCE_LIMIT and\
					raw_gesture_data.is_consistent(TAP_DISTANCE_LIMIT, FINGER_SIZE*fingers) and\
					_released_together(raw_gesture_data, MULTI_FINGER_RELEASE_THRESHOLD):
					_emit("multi_tap", InputEventMultiScreenTap.new(raw_gesture_data))
				if raw_gesture_data.elapsed_time < SWIPE_TIME_LIMIT and distance > SWIPE_DISTANCE_THRESHOLD and\
					raw_gesture_data.is_consistent(FINGER_SIZE, FINGER_SIZE*fingers) and\
					_released_together(raw_gesture_data, MULTI_FINGER_RELEASE_THRESHOLD):
					_emit("multi_swipe", InputEventMultiScreenSwipe.new(raw_gesture_data))
			_end_gesture()
		_cancel_single_drag()

func _handle_screen_drag(event : InputEventScreenDrag) -> void:
	if event.index < 0:
		_emit("cancel", InputEventScreenCancel.new(raw_gesture_data, event))
		_end_gesture()
		return

	raw_gesture_data._update_screen_drag(event)
	real_raw = raw_gesture_data.copy()
	_emit("raw_gesture", raw_gesture_data)
	if raw_gesture_data.drags.size() > 1:
		_cancel_single_drag()
		var gesture : int = _identify_gesture(raw_gesture_data)
		if gesture == Gesture.PINCH:
			_emit("pinch", InputEventScreenPinch.new(raw_gesture_data, event))
		elif gesture == Gesture.MULTI_DRAG:
			_emit("multi_drag", InputEventMultiScreenDrag.new(raw_gesture_data, event))
		elif gesture == Gesture.TWIST:
			_emit("twist",InputEventScreenTwist.new(raw_gesture_data, event))
	else:
		if _single_drag_enabled:
			_emit("single_drag", InputEventSingleScreenDrag.new(raw_gesture_data))
		else:
			if _drag_startup_timer.is_stopped(): _drag_startup_timer.start(DRAG_STARTUP_TIME)

func _handle_action(event : InputEvent) -> void:
	if InputMap.has_action("single_touch") and (event.is_action_pressed("single_touch") or event.is_action_released("single_touch")):
		_emit("touch", _native_touch_event(0, get_viewport().get_mouse_position(), event.pressed))
		if event.pressed:
			_mouse_event = Gesture.SINGLE_DRAG
		else:
			_mouse_event = Gesture.NONE
	elif InputMap.has_action("multi_touch") and (event.is_action_pressed("multi_touch") or event.is_action_released("multi_touch")):
		_emit("touch", _native_touch_event(0, get_viewport().get_mouse_position(), event.pressed))
		_emit("touch", _native_touch_event(1, get_viewport().get_mouse_position(), event.pressed))
		if event.pressed:
			_mouse_event = Gesture.MULTI_DRAG
		else:
			_mouse_event = Gesture.NONE
	elif InputMap.has_action("twist") and (event.is_action_pressed("twist") or event.is_action_released("twist")):
		_mouse_event_press_position = get_viewport().get_mouse_position()
		if event.pressed:
			_mouse_event = Gesture.TWIST
		else:
			_mouse_event = Gesture.NONE
	elif (InputMap.has_action("pinch_outward") and event.is_action_pressed("pinch_outward")) or (InputMap.has_action("pinch_inward") and event.is_action_pressed("pinch_inward")):
		var pinch_event = InputEventScreenPinch.new()
		pinch_event.fingers = 2 
		pinch_event.position = get_viewport().get_mouse_position()
		pinch_event.distance = 400
		pinch_event.relative = 40
		if event.is_action_pressed("pinch_inward"):
			pinch_event.relative *= -1
		_emit("pinch", pinch_event)
	else:
		var swipe_emulation_dir  : Vector2 = Vector2.ZERO
		var is_single_swipe : bool 
		for swipe in swipe2dir:
			var dir = swipe2dir[swipe]
			if InputMap.has_action("single_"+swipe) and event.is_action_pressed("single_"+swipe):
				swipe_emulation_dir  = dir
				is_single_swipe = true
				break
			if InputMap.has_action("multi_"+swipe) and event.is_action_pressed("multi_"+swipe):
				swipe_emulation_dir  = dir
				is_single_swipe = false
				break

		if swipe_emulation_dir != Vector2.ZERO:
			var swipe_event
			if is_single_swipe:
				swipe_event = InputEventSingleScreenSwipe.new()
			else:
				swipe_event = InputEventMultiScreenSwipe.new()
				swipe_event.fingers = 2
			swipe_event.position = get_viewport().get_mouse_position()
			swipe_event.relative = swipe_emulation_dir*SWIPE_DISTANCE_THRESHOLD*2
			if is_single_swipe:
				_emit("single_swipe", swipe_event)
			else:
				_emit("multi_swipe", swipe_event)

# Emits signal sig with the specified args
func _emit(sig : String, val : InputEvent) -> void:
	if DEBUG: print(val.as_text())
	emit_signal("any_gesture", sig, val)
	emit_signal(sig, val)
	Input.parse_input_event(val)


# Disables drag and stops the drag enabling timer
func _cancel_single_drag() -> void:
	_single_drag_enabled = false
	_drag_startup_timer.stop()

func _released_together(_raw_gesture_data : RawGesture, threshold : float) -> bool:
	_raw_gesture_data = _raw_gesture_data.rollback_relative(threshold)[0]
	return _raw_gesture_data.size() == _raw_gesture_data.active_touches

# Checks if the gesture is pinch
func _identify_gesture(_raw_gesture_data : RawGesture) -> int:
	var center : Vector2 = _raw_gesture_data.centroid("drags","position")
	
	var sector : int = -1
	for e in _raw_gesture_data.drags.values():
		var adjusted_position : Vector2 = center - e.position
		var raw_angle      : float = fmod(adjusted_position.angle_to(e.relative) + (PI/4), TAU) 
		var adjusted_angle : float = raw_angle if raw_angle >= 0 else raw_angle + TAU
		var e_sector       : int = int(floor(adjusted_angle / (PI/2)))
		if sector == -1: 
			sector = e_sector
		elif sector != e_sector:
			return Gesture.MULTI_DRAG

	if sector == 0 or sector == 2:
		return Gesture.PINCH
	else: # sector == 1 or sector == 3:
		return Gesture.TWIST

func _on_drag_startup_timer_timeout() -> void:
	_single_drag_enabled = raw_gesture_data.drags.size() == 1

func _on_long_press_timer_timeout() -> void:
	var ends_centroid   : Vector2    = Util.centroid(raw_gesture_data.get_ends().values())
	var starts_centroid : Vector2    = raw_gesture_data.centroid("presses", "position")
	var distance        : float      = (ends_centroid - starts_centroid).length()

	if raw_gesture_data.releases.is_empty() and distance <= LONG_PRESS_DISTANCE_LIMIT and\
		raw_gesture_data.is_consistent(LONG_PRESS_DISTANCE_LIMIT, FINGER_SIZE*raw_gesture_data.size()):
		if _single_touch_cancelled:
			_emit("multi_long_press", InputEventMultiScreenLongPress.new(raw_gesture_data))
		else:
			_emit("single_long_press", InputEventSingleScreenLongPress.new(raw_gesture_data))
	

func _end_gesture() -> void:
	_single_drag_enabled = false
	_long_press_timer.stop()
	raw_gesture_data = RawGesture.new()

# create a native touch event
func _native_touch_event(index : int, position : Vector2, pressed : bool) -> InputEventScreenTouch:
	var native_touch : InputEventScreenTouch = InputEventScreenTouch.new()
	native_touch.index = index
	native_touch.position = position
	native_touch.pressed  = pressed
	return native_touch

# create a native touch event
func _native_drag_event(index : int, position : Vector2, relative : Vector2, velocity : Vector2) -> InputEventScreenDrag:
	var native_drag : InputEventScreenDrag = InputEventScreenDrag.new()
	native_drag.index = index
	native_drag.position = position
	native_drag.relative  = relative 
	native_drag.velocity    = velocity
	return native_drag

func _native_mouse_button_event(button : int) -> InputEventMouseButton:
	var ev = InputEventMouseButton.new()
	ev.button_index = button
	return ev

func _native_key_event(key : int) -> InputEventKey:
	var ev = InputEventKey.new()
	ev.keycode = key
	return ev

func _set_default_action(action : String, event : InputEvent) -> void:
	if !InputMap.has_action(action):
		InputMap.add_action(action)
		InputMap.action_add_event(action,event)

# Macro to add a timer and connect it's timeout to func_name
func _add_timer(timer : Timer, func_name : String) -> void:
	timer.one_shot = true
	if func_name:
		timer.connect("timeout", Callable(self, func_name))
	self.add_child(timer)
tm# warning-ignore-all:return_value_discarded

extends InputEventAction
class_name RawGesture 

#########
# Const #
#########

const Util : GDScript = preload("Util.gd")

###########
# Classes #
###########

class Event:
	var time  : float = -1 # (secs)
	var index : int   = -1
	
	func as_string() -> String:
		return "ind: " + str(index) + " | time: " + str(time)

class Touch:
	extends Event
	var position : Vector2 = Vector2.ZERO
	var pressed  : bool 
	var raw_gesture : RawGesture

	func as_string() -> String:
		return super.as_string() + " | pos: " + str(position) + " | pressed: " + str(pressed)


class Drag:
	extends Event
	var position  : Vector2 = Vector2.ZERO
	var relative  : Vector2 = Vector2.ZERO
	var velocity     : Vector2 = Vector2.ZERO
	var raw_gesture : RawGesture

	func as_string() -> String:
		return super.as_string() + " | pos: " + str(position) + " | relative: " + str(relative)


#############
# Variables #
#############

var presses  : Dictionary # Touch
var releases : Dictionary # Touch
var drags    : Dictionary # Drag
var history  : Dictionary # Array of events

var active_touches : int   = 0

var start_time     : float = -1 # (secs)
var elapsed_time   : float = -1 # (secs)

#############
# Functions #
#############

func size() -> int:
	return presses.size()

func centroid(events_name : String , property_name : String):
	var arr : Array = get(events_name).values()
	arr = Util.map_callv(arr , "get", [property_name])
	return Util.centroid(arr)

func get_ends() -> Dictionary:
	var ends : Dictionary = {}

	for i in presses:
		ends[i] = presses[i].position

	for i in drags:
		ends[i] = drags[i].position

	for i in releases:
		ends[i] = releases[i].position

	return ends

# Check for gesture consistency
func is_consistent(diff_limit : float, length_limit : float = -1) -> bool:
	if length_limit == -1: length_limit = length_limit

	var ends : Dictionary = get_ends()

	var ends_centroid   : Vector2 = Util.centroid(ends.values())
	var starts_centroid : Vector2 = centroid("presses", "position")

	var valid : bool = true
	for i in ends:
		var start_relative_position : Vector2 = presses[i].position  - starts_centroid
		var end_relative_position   : Vector2 = ends[i] - ends_centroid 
		
		valid = start_relative_position.length() < length_limit and \
						end_relative_position.length()   < length_limit and \
						(end_relative_position - start_relative_position).length() < diff_limit

		if !valid:
			break

	return valid

func rollback_relative(time : float) -> Array:
	return rollback_absolute(start_time+elapsed_time - time)

func rollback_absolute(time : float) -> Array:
	var discarded_events : Array = []
	var rg : RawGesture = copy()

	var latest_event_id : Array = rg.latest_event_id(time)
	while !latest_event_id.is_empty():
		var latest_index  : int    = latest_event_id[0]
		var latest_type   : String = latest_event_id[1]
		var latest_event = rg.history[latest_index][latest_type].pop_back()
		discarded_events.append(latest_event)
		if latest_type == "presses":
			rg.active_touches -= 1
		elif latest_type == "releases":
			rg.active_touches += 1
		if rg.history[latest_index][latest_type].is_empty():
			rg.history[latest_index].erase(latest_type)
			if rg.history[latest_index].is_empty():
				rg.history.erase(latest_index)
		latest_event_id = rg.latest_event_id(time)

	for index in rg.presses.keys():
		if rg.history.has(index):
			if rg.history[index].has("presses"):
				var presses_history: Array = rg.history[index]["presses"]
				rg.presses[index] = presses_history.back()
			else:
				rg.presses.erase(index)

			if rg.history[index].has("releases"):
				var releases_history : Array = rg.history[index]["releases"]
				# !releases_history.empty() -> rg.presses.has(index) (touch precedes a release)
				if releases_history.back().time < rg.presses[index].time: 
					rg.releases.erase(index)
				else:
					rg.releases[index] = releases_history.back()
			else:
				rg.releases.erase(index)

			if rg.history[index].has("drags"):
				var drags_history : Array = rg.history[index]["drags"]
				# rg.releases.has(index) -> rg.releases[index].time >= rg.presses[index].time ->
				# rg.releases[index] >= drags_history.back().time (drag should needs a new touch after the release)
				if rg.releases.has(index):
					rg.drags.erase(index)
				else:
					rg.drags[index] = drags_history.back()
			else:
				rg.drags.erase(index)
		else:
			rg.presses.erase(index)
			rg.releases.erase(index)
			rg.drags.erase(index)

	return [rg, discarded_events]

func get_linear_event_history():
	return rollback_absolute(0)[1]

func copy() -> RawGesture:
	var rg : RawGesture = get_script().new()
	rg.presses           = presses.duplicate(true)        
	rg.releases          = releases.duplicate(true)
	rg.drags             = drags.duplicate(true)   
	rg.history           = history.duplicate(true)
	rg.active_touches    = active_touches
	rg.start_time        = start_time    
	rg.elapsed_time      = elapsed_time 
	return rg 

func latest_event_id(latest_time : float = -1) -> Array:
	var res : Array = []
	for index in history:
		for type in history[index]:
			var event_time = history[index][type].back().time
			if event_time >= latest_time:
				res = [index, type]
				latest_time = event_time
	return res

func as_string() -> String:
	var txt = "presses: "
	for e in presses.values():
		txt += "\n" + e.as_string()
	txt += "\ndrags: "
	for e in drags.values():
		txt += "\n" + e.as_string()
	txt += "\nreleases: "
	for e in releases.values():
		txt += "\n" + e.as_string()
	return txt

func _update_screen_drag(event : InputEventScreenDrag, time : float = -1) -> void:
	if time < 0:
		time = Util.now()
	var drag : Drag = Drag.new()
	drag.position  = event.position
	drag.relative  = event.relative
	drag.velocity  = event.velocity
	drag.index     = event.index 
	drag.time      = time
	_add_history(event.index, "drags", drag)
	drags[event.index] = drag
	elapsed_time = time - start_time
	
func _update_screen_touch(event : InputEventScreenTouch, time : float = -1) -> void:
	if time < 0:
		time = Util.now()
	var touch : Touch = Touch.new()
	touch.position = event.position
	touch.pressed  = event.pressed
	touch.index    = event.index 
	touch.time     = time
	if event.pressed:
		_add_history(event.index, "presses", touch)
		presses[event.index] = touch
		active_touches += 1
		releases.erase(event.index)
		drags.erase(event.index)
		if active_touches == 1:
			start_time = time
	else:
		_add_history(event.index, "releases", touch)
		releases[event.index] = touch
		active_touches -= 1
		drags.erase(event.index)
	elapsed_time = time - start_time

func _add_history(index : int, type : String, value) -> void:
	if !history.has(index): 
		history[index] = {}
	if !history[index].has(type): 
		history[index][type] = []
	history[index][type].append(value)
I{P:siconst SEC_IN_USEC : int = 1000000

static func map_callv(i_es : Array, f : String, vargs : Array) -> Array:
	var o_es : Array = []
	for e in i_es: o_es.append(e.callv(f,vargs))
	return o_es

# Precondition: 
# * !arr.empty()
static func centroid(es : Array):
	var sum = es[0]
	for i in range(1,es.size()):
		sum += es[i]
	return sum / es.size()

static func now() -> float:
	return float(Time.get_ticks_usec())/SEC_IN_USEC
e^[gd_scene load_steps=7 format=3 uid="uid://df7jiecrlx6mi"]

[ext_resource type="Script" path="res://PlayerMove.gd" id="1_8sjqh"]
[ext_resource type="Script" path="res://CurveWand.gd" id="2_bf5rj"]

[sub_resource type="QuadMesh" id="QuadMesh_xkcpx"]
size = Vector2(5, 1)

[sub_resource type="QuadMesh" id="QuadMesh_ai4o8"]
size = Vector2(1, 5)

[sub_resource type="Gradient" id="Gradient_x50lx"]
offsets = PackedFloat32Array(0, 0.0338028, 0.622535, 0.709859)
colors = PackedColorArray(0, 0, 0, 1, 1, 1, 1, 0, 0.83, 0.83, 0.7802, 1, 0, 0, 0, 0)

[sub_resource type="GradientTexture2D" id="GradientTexture2D_n5bif"]
gradient = SubResource("Gradient_x50lx")
fill = 1
fill_from = Vector2(0.492308, 0.521368)
fill_to = Vector2(1, 1)

[node name="Player" type="Node3D"]

[node name="PlayerNode" type="Node3D" parent="."]
script = ExtResource("1_8sjqh")

[node name="HTTPRequest" type="HTTPRequest" parent="PlayerNode"]

[node name="Camera3D" type="Camera3D" parent="PlayerNode"]
cull_mask = 1048573
fov = 84.0
far = 100.0

[node name="AudioListener3D" type="AudioListener3D" parent="PlayerNode/Camera3D"]
current = true

[node name="CrossUp" type="MeshInstance2D" parent="PlayerNode/Camera3D"]
position = Vector2(960, 540)
scale = Vector2(2, 2)
mesh = SubResource("QuadMesh_xkcpx")

[node name="CrossDown" type="MeshInstance2D" parent="PlayerNode/Camera3D"]
position = Vector2(960, 540)
scale = Vector2(2, 2)
mesh = SubResource("QuadMesh_ai4o8")

[node name="CurveWand" type="Node3D" parent="PlayerNode"]
script = ExtResource("2_bf5rj")

[node name="Label" type="Label" parent="PlayerNode"]
anchors_preset = 1
anchor_left = 1.0
anchor_right = 1.0
offset_left = -1.0
offset_top = 40.0
offset_bottom = 80.0
grow_horizontal = 0
theme_override_font_sizes/font_size = 18

[node name="Label2" type="Label" parent="PlayerNode"]
anchors_preset = 1
anchor_left = 1.0
anchor_right = 1.0
offset_left = -1.0
offset_bottom = 23.0
grow_horizontal = 0
horizontal_alignment = 2

[node name="Finger1" type="Sprite2D" parent="PlayerNode"]
visible = false
texture = SubResource("GradientTexture2D_n5bif")

[node name="Finger2" type="Sprite2D" parent="PlayerNode"]
visible = false
texture = SubResource("GradientTexture2D_n5bif")

[node name="Finger3" type="Sprite2D" parent="PlayerNode"]
visible = false
texture = SubResource("GradientTexture2D_n5bif")

[node name="DirectionalLight3D" type="DirectionalLight3D" parent="."]
transform = Transform3D(1, 0, 0, 0, 0.770858, 0.637007, 0, -0.637007, 0.770858, 0, 1.21404, 1.50254)
،,~Kextends AudioStreamPlayer3D
class_name MusicPlayer

var pending = false
var load_url = ""
var load_url_full = ""
var ana_url = ""
var info_url = ""
#@export var base_url := "http://localhost:10454/"
@export var base_url := "http://boite.trido.fr/"

var stream_progress = 0
var stream_length := 0.0

var round = 0

var full_stream := PackedByteArray()

@onready var value_curve = get_parent().find_child("ValueCurves") as ValuesCurve

@onready var sprite = get_parent().find_child("AlbumArt") as Sprite2D
@onready var large_album = get_parent().find_child("LargeAlbumArt") as MeshInstance3D
@onready var large_lyrics = get_parent().find_child("LargeLyrics") as Label3D
@onready var playing_info = get_parent().find_child("PlayingInfo") as Label
@onready var info_card = get_parent().find_child("InfoCard") as Label3D

@onready var invert_tess := preload("res://invert_tess2.tres") as ShaderMaterial

@onready var progress_indicator = get_parent().find_child("ProgressIndicator") as Polygon2D

var streamIn: AudioStream
var audioBus: AudioEffectSpectrumAnalyzerInstance

var mag := Vector2.ZERO
var mag_lo := Vector2.ZERO
var mag_med := Vector2.ZERO
var mag_hi := Vector2.ZERO

var fact = 4

var shader_walls: ShaderMaterial
var shader_tess: ShaderMaterial

@export var now_playing: Dictionary
@export var selected_info: Dictionary

@onready var player_node = get_parent().find_child("Player").get_child(0) as PlayerNode
@onready var generator_node = get_parent().find_child("Generator") as Generator

var vals := Vector4(0.1, 0.1, 0.1, 0.1)

var current_info_filename := ""
var infos = Dictionary()

func _ready():
	$HTTPRequest.request_completed.connect(_on_request_completed)
	$HTTPRequest2.request_completed.connect(_on_request_completed2)
	$HTTPRequest3.request_completed.connect(_on_request_completed3)
	$HTTPRequest4.request_completed.connect(_on_request_completed4)
	$HTTPRequest5.request_completed.connect(_on_request_completed_info)
	audioBus = AudioServer.get_bus_effect_instance(0, 0) as AudioEffectSpectrumAnalyzerInstance
	print(AudioServer.get_input_device_list())
	var tess = get_parent().find_child("Tesseract") as MeshInstance3D
	shader_tess = (tess.get_surface_override_material(0) as ShaderMaterial)
	var walls = get_parent().find_child("Walls") as MeshInstance3D
	shader_walls = (walls.get_surface_override_material(0) as ShaderMaterial)
	
	#info_card.material_override = invert_tess
	#shader_walls = (large_album.get_surface_override_material(0) as ShaderMaterial)
	
	#$HTTPRequest.request("https://api.github.com/repos/godotengine/godot/releases/latest")

func _input(event):
	if Input.is_action_just_pressed("play_song"):
		load_song()
	if Input.is_action_just_pressed("escape"):
		get_tree().quit()
	if Input.is_action_just_pressed("sound"):
		if attenuation_model == AudioStreamPlayer3D.ATTENUATION_DISABLED:
			attenuation_model = AudioStreamPlayer3D.ATTENUATION_INVERSE_DISTANCE
			panning_strength = 0
		else:
			attenuation_model = AudioStreamPlayer3D.ATTENUATION_DISABLED
			panning_strength = 0.6

func load_temp_info():
	print("Loading temp info!")


	var song_filename
	if player_node.info_hit.name.is_valid_int():
		song_filename = generator_node.get_song_from_id(player_node.info_hit.name)
	
	if song_filename != current_info_filename and song_filename and ".part" not in song_filename:
		# force static song because of btrfsq
		#var load_url = base_url + "53 - Fred again - Marea (we’ve lost dancing).m4a".uri_encode()
		var card_url = base_url + "info/" + song_filename.uri_encode() + ".m4a"
		
		# update playing location and labels
		current_info_filename = song_filename + ".m4a"
		info_card.position = player_node.info_hit.position + Vector3(0.5, 0, 0)
		info_card.text = "\n".join(song_filename.split("-").slice(1))
		
		info_card.visible = true
		"""
		if infos.get(current_info_filename):
			self.selected_info = infos[current_info_filename]
			update_infocard()
			print("Got repeat!")
		else:
			# request the song
			print("got new info url: " + card_url)
			$HTTPRequest5.request(card_url)
		"""
		pass

func update_infocard():
	var s = selected_info["tags"]
	info_card.text = s["title"] + "\n" + s["album"] + "\n" + s["artist"] + "\n" + s["date"]
	info_card.visible = true
	
func update_lyrics():
	if self.now_playing:
		if self.now_playing.get("tags"):
			var s = now_playing["tags"]
			var l = s["lyrics"]
			large_lyrics.text = l
			large_lyrics.visible = true

func load_song():
	print("Loading song!")
	var player_node = get_parent().find_child("Player").get_child(0) as PlayerNode
	var generator_node = get_parent().find_child("Generator") as Generator

	var song_filename
	if player_node.current_hit:
		if player_node.current_hit.name.is_valid_int():
			song_filename = generator_node.get_song_from_id(player_node.current_hit.name)
	
	if !pending and song_filename:
		pending = true
		if self.playing:
			self.stop()
		
		# force static song because of btrfsq
		#var load_url = base_url + "53 - Fred again - Marea (we’ve lost dancing).m4a".uri_encode()
		var load_url = base_url + "preview/" + song_filename.uri_encode() + ".m4a"
		load_url_full = base_url + "full/" + song_filename.uri_encode() + ".m4a"
		ana_url = base_url + "tags/" + song_filename.uri_encode() + ".m4a"
		info_url = base_url + "info/" + song_filename.uri_encode() + ".m4a"
		
		# update playing location and labels
		position = player_node.current_hit.position
		sprite.texture = player_node.current_hit.mesh.surface_get_material(0).albedo_texture
		
		var album_mat = large_album.mesh.surface_get_material(0)
		album_mat.emission_texture = player_node.current_hit.mesh.surface_get_material(0).albedo_texture
		large_album.visible = true
		playing_info.text = "\n".join(song_filename.split("-").slice(1)).replace(".m4a", "")
		
		# request the song
		print("requesting: " + load_url)
		$HTTPRequest4.request(info_url)
		$HTTPRequest.request(load_url)
		

func _on_request_completed(result, response_code, headers, body):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song couldn't be downloaded. Try a different song.")
	
	print("Received preview!!")
	#print("body size: " + str(body.size()))
	stream.data = body
	round = 0
	full_stream = PackedByteArray()
	#stream_length = stream.get_length()
	self.pending = false
	self.stream_progress = 0

	self.play()
	$HTTPRequest2.request(load_url_full)
	$HTTPRequest3.request(ana_url)
	
func _on_request_completed2(result, response_code, _headers, body):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song couldn't be downloaded. Try a different song.")
	
	print("Received rest of song!!")
	#print("body size: " + str(body.size()))
	
	var moment = self.get_playback_position()
	#self.stop()
	full_stream = body
	#stream_length = stream.get_length()
	#stream.instantiate_playback()

	if !self.playing:
		stream.data = full_stream
		self.play()
	
	#print(json["name"])
	
func _on_request_completed3(result, response_code, _headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song couldn't be analyzed. Try a different song.")
	
	print("Received song analysis!!")
	#print("body size: " + str(body.size()))
	var size = body.size()
	var windows = (size / 4) / 527
	
	var packed_values = body.to_float32_array()
	value_curve.load_windowed_song(packed_values)
	
func _on_request_completed4(result, response_code, _headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song info couldn't be fetched. Try a different song.")
	
	print("Received song info")
	#print("body size: " + str(body.size()))
	var json = JSON.parse_string(body.get_string_from_utf8())
	if json:
		self.now_playing = json["format"]
		stream_length = float(json["format"]["duration"])
		print("stream length: " + str(stream_length))
		update_lyrics()

func _on_request_completed_info(result, response_code, _headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song info couldn't be fetched. Try a different song.")
	
	print("Received song playcard")
	#print("body size: " + str(body.size()))
	var json = JSON.parse_string(body.get_string_from_utf8())
	if json:
		infos[json["format"]["filename"].split("/")[-1]] = json["format"]
		self.selected_info = json["format"]
		#var s = self.selected_info["tags"]
		update_infocard()
		#stream_length = float(json["format"]["duration"])
	

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	if self.playing and stream_length != 0:
		self.stream_progress += delta
		progress_indicator.scale.x = self.stream_progress / stream_length
		
		# Called every frame. 'delta' is the elapsed time since the previous frame.
		mag_lo = audioBus.get_magnitude_for_frequency_range(20, 1000, 1) * fact
		mag_med = audioBus.get_magnitude_for_frequency_range(1000, 4000, 1) * fact
		mag_hi = audioBus.get_magnitude_for_frequency_range(4000, 15000, 1) * fact
		mag = audioBus.get_magnitude_for_frequency_range(0, 15000, 1) * fact
		
		var new_vals = Vector4((mag_lo[0] + mag_lo[1]) / 2.0, (mag_med[0] + mag_med[1]) / 2.0, (mag_hi[0] + mag_hi[1]) / 2.0, (mag[0] + mag[1]) / 2.0)
		vals = 0.2 * new_vals + 0.8 * vals
		shader_tess.set_shader_parameter("audio", vals)
		shader_walls.set_shader_parameter("audio", vals)
		#emission_energy_multiplier
		#print("shader param: " + str(shader.get_shader_parameter("audio")))
		large_album.transparency = 1 - ((mag_lo[0] + mag_lo[1]) / 2.0)
		
		#print("Mag: ", mag_lo)
	else:
		progress_indicator.scale.x = 0
		self.stream_progress = 0

func _on_finished():
	print("Called finished!")
	if round == 0 and self.stream.get_length() > 0:
		if full_stream.size() != 0:
			print("Switched inputs!")
			self.stream.data = full_stream
			#self.stream_progress += 20
			self.play()
			round = 1
	elif round == 1 and self.stream.get_length() > 0:
		print("value curve")
		full_stream = PackedByteArray()
		self.stream_progress = 0.0
		#value_curve.clear()
	else:
		large_album.visible = false
		large_lyrics.visible = false
		
	pass # Replace with function body.
`RSCC      C    
  
  
  
  
  
  
  
  
    (/` v T           	   FontFile            resource_local_to_scene namedata    generate_mipmaps 
   antialiasing 
   font   style weightretch ubpixel_position#   multichannel_signed_distance_fieldmsdf_rangesize llow_system_fallbackfoautohinter    oversamplixed   opentype_feature_ridess    cache/0/varia_coordinatesace_indexemboldentransform 16/0/atde underline !thickness scale $ker/16/0 cript   ://_3gtg0 5         L  wOF2OTTO  L    
j(
` F6$hu [   
7S m9DuA*6zYʈazd"cvrIӔ ?i:	+QkVG(i^ƶ2պmfec24+
z]"v۵7w^~TD233EDD"R%UR%VMg>S?;;a8NY(w08CLNSjgi0	bzb/Z!;
X@cX1D3HOPPzy[4di\%RAM"Ur0'N6n]}X
pE(SoU1؅~WC,۹#bĨVBق0*!UF5it`Da&t6}&&'D	+: N:Np>s5"F?R* L/{bι,A
+m5h*g?D4!HD<>Q$Һ$Ph.3LM8Ȕs+Rҍ*Պ}m,j1c<(R,s!jhFEЉ @c@dTnuS}rU>Ee+Zmc
10ƈR(`JلD20?cFgLj!bz#DN 1%=>9/Czoe5{Wa
4'+
&)"h
en'}`El=ݲp<S*R*.Y8eYCW$%4¼^0z[oSiRpL	(1OJ
.;aKLI^$cP	tu] Ծfݝ}'յO? 2L AZ+(02+HǖLtz|'.p )7&|}Q&3igHhS{%ʚ	k^Tܙk :w;Z{/)f1};}-f	Muh(h҉hɤ Zn߫
"m7kVsonFwϙ3L	T 	YY֗CH[N	7T_g#kP⫪" @(Va)(9mZ]:3ƙh&"gZEfц?	7 I~.I8I\)۷:}8ūp(ÏNW8vΕҁR@vQIxSݷҷ=gpAlLRVDF0 `@8΁OڻN=UrYpbWϷDRC˦:ˊ4,c{XpéNi;Ғ8	x!:&EKzEnqȶ@M6A'=I'g-CwH
{H6HADd=556k=}q/%xizk]v]ß/׽
{`o/RUN%
#%.$sj#NkwC|I#L>Ȥed3յtك^ѕ 

,8@wx!( "(@rav qq60 PП,Zi<ֲg^NR% $a	x fĜ-h"DG%3dGCFkilȅ;sRTǕl:Q-0p?Yl[\ٸmhL*SUՒ[~Zs6Bt1%\*S4%$NR{T&yu[Ъ֤I.B(Nr.c|{W_BM7Y@]bEVXru-_7m:0ba>Ҹ;9qq.4B.'q
K*UVנYmkgفNV/x:[
'a5ۻ;5ެ*U4QiS7s:'td52
Ro2nGן?rɜw~tlnuܵOMÎ
RSP&a`-2(tL[VXݲz}3wvEZ9PGK^@i,?j^6Zug Jr0P@*P:a#zD9\-KM|W+\;%[s	G3iKjq:f`im)o,"Ă LLLJǀe96yt㖕v@eFkel2@ 7@-P0
 )fpՂk+j]W	mRyd^ϵx
>[?_&BdBKCDHFvI Pb%G2A	zUtn
@XP]qxkNz5*ɉTD^΅0N!̉ds^<7Ok_)kak15g]45M;^;qCd4.6zlpF ̩`6NݢJ36FvQQ',而DX(R(TohjcUJxD[ILkfrB%K)&j	Mh(Z߆[2M	+䨡(E,`e~7}ϑkwp%81X"a`Old!'?>l,=6(=}@UT8wWÓ}Uc-j:`T&lWdQ]9ȡNHP?w]h+Ҵ	$ד惰Q5TLń>E[dIg[Z-bV*՜Fe
(-D_F6su~@Z%:MtsWڦ6޺xB>ud3Q>u_֙pPfE6TpPC
\g\^pc¶䤑4tt-̹6,!:ҞTeT<]CRw	>"5BP)+ϕ5kNxqJ=NzÌ:3*; P"QisC4NqTp|E١d- D8]z?<vB`l=jE KgGfW4V$@/3v|(/`  19E?.w+?6F^I)ŉoK$"47Zi<6i)N\3 9&T8*3C⤚,
: <va43,!(N=ݩ9NϚw&2Ł_,aTx2A9f8mO!@`88$D* `"!1%\$E,sU.p#Fe[5Zv`.$BxXq%H$Y ;'E&QeUl n9S	
PP( EB mp$K @@  ( $2nPދBtݧ9,Ʉ"6ʖ9e-ž_-tKC0<xyOcKS?>/2O,<i3ʣ@?R-!`g[v5
8`/;ͽ蘍cƊ̕߆C6Ow<gW>a@
xӬG݉-INtޒej+6":P
}dǸA%)C)%⅐3
8sEYSN۵[tU}xծsUhYlklbn'ӑƴe`VRֳ-mwj~ $`7fmk
oeIg+YN*8UƬՆ7YA8NH aSR31ACSnV[>q&O~?Qp#A)V8E$bW+Sh &{4"("JD-1XFD
HăģFb7q8IM|NdQ!C=Z:	#$M"M#' =Cz9VG/BkBkCcj9e2Zg^!FI|jw@6l1AKuШ)(ҿn|
OasrY|D8
r.9M
)fWlS3o2iS]B\G&^V3t49jeJ´ۖowoY_lz*OAD	&2C3#U"<!]$JgԄàA!ֆ>b`~.39 [+"ALf)Bϔ{df%Fn})h%u.Ӂ?&7t-mE&Rqs>zR# U}gk	}/$A=_AW0kQ8Bgv~?܄d"ns aO;[zo*zSk0w:|3X851-D LA'{LQBV'J<ŹB5&?_W\izeoL$($F`u""eHZ 2t<JHD/f1Y<jkeAs
*dh O`/Տڷ+"[֮cvG!YЂRPA5*-Se2@7,
gPю__	˲QgmP8Zyi*}oM;tZPO.裚0`3(P-9iASAE,("7hf|Q"m$.Ř
y7㢄?>>缽'eлݹŽEv|Zk#qgjoy75'03ڢrJN!02v#|6KxaH+z!=ORvvFV"LaӦcZ0'/Fhvl.Lr;jfP[*,56KU-osBrsJטe2h|<H࿣voR%lzSC"0#ΞQZ}DuֲۇWE\7]~eԁӺb}]/Pl𡝾uQqJPLyxIpA;s?WPO8L;B<NWp12	?zYtS$(~gw?*q:ݴ>YznB`ηs/0c_DoZ?SޤE3+O_*md弤TxK"Q+yYՐk+~OKX(B٘Bv^%1+ZnA4K7".)FFv7|K*>mqN].uv97N~MG7~qW?nz_B;s1epD.1%KYCRs-agn>{{a	*E4Ї4~$	^dMfl bQe,gB i9ffy5ؠY$K6˹8z˻~/_Q.V~͍8iU0D/7-y_.5ߨ_WAx?/ ^qh*$k9]ibl330Ut1'Rx&n
F s2~K|<%v-RE[';\p.^sbN*Z{EIb[7Z
wőO|_&CG5.=SLJrs]-xCe5c1{-#ױi#Q8xb ȴЛW}U6|ڛVw%6u0q(k-os($d+9 fGkcRqx{/!g@l[k
HŖQ_.'¯!d%hJ9rN]R	B [z)|`iX<;}[;>2`ۮ+udgfɮ?O>,(ebI\{qmu-b׌pJ(ί]
4Ȕ[l̓Q:2iA~Z:N"(i	߹Dls*Ip%Gdւ-[V
G,*6{ݾ_TU'yIH;Qg٣^uͰ)|u*6G7c1i
e\ܫP[H%AwVZPv8m*3	Jl/ԉ?tIoXsA:4r3'Xuyr7kIM'$-n[۳ĪkR,ﲸتcS-0[c:Kךn%{E-c}d	Ɩ<oJ)KğBjEdF|m*O毽<
b}W%|/Y 6uKKM^'ǏɸM'^	wۨhR"oTWs{#\D@h
_)6VKz%eԑv)4'ʁ`KqumAYd~j@46TyjTsa YiJdf$za3?C*B+4z'GA|P=j1q<=/_ej=瀏9/~;?jp7"X2Ʉ4ΰ
AB4kG L^)$0?ʶ
*SQ4lS@&(Ol3"C;yJ-ݷy[3{+f
[rqVK;ʸ}J(ac1cUӟ啡IV}f8quiT]YvX~aHWw}qh)1=M4,I@Sc&hLv)B~6Z'yI)gE)z2)IS/#_q_ ­ӳAY󬾓Lv	}A%NwA]jۈG(ÙRKh)ϣM^hӑG/P]f,T:o(ujjKP6_/C4ު?w[kR^M<R G2_-lLP
VrW[ٹaf^)|[-ˢ#4	21Mgr7_>m
1_SLq&5]bWR;Ʒ[~Ga)~"4˯|<$JxoW_ub=eU[hr(/`  ~S2sKr(A50´x=+&N!7W2K3~MF	@`#{5(6XX^*cKY1H)2CeTvS1%M?2;gV<wE_7ojn$3^[aU:bFZOKW
;EFo;7Xl$4wU$,aup|=yGӣ(7ZSP[Nn#[PBǡ6֚?)ɰ>VL.Ai%KGM"/l\.7~ɭ%L&p\Ƀ>tmT_+[a3To	<X́XvB˷6*O;d.bSTO"yw'(S!{#vO(r[K:n/a@YNV̜ *)QVw$@lee33^EYtƻ%un76Jx:ݺltJ?%4*'ʚ}gO߲nF*H~ :ԟAz4%缭,I:Y#d/EdG\A|vډJ
'zݚmlJSh
B_<HN+D!>`b6YH A~[lv܀褂ސ(
BpU@U
Ѵ`,CB3HQk r;7ww#M~z9|2C{	%
F8=I4.\
O;>W~qBȥ].BF Q#߼[j!ȁ)l-Ѵa:v6t3`8B׀]V6؋n~26pG z#l3=7أp@#z-Fo8AQn8އc`.8G+
'0چ50)F_g1m8c}w3WAp.ab>6ckD&= !p<ج/![֊X v,1hE$mlm-,v@b]}lO1<I	<E)&3S	/Yl.CJ_H؃PBL	00{4샟Peՠ áCp@P(	 )̀2(.CfX+T!
A|P'X
kaZډK<hUP|X	Vqˀ;Ђ;*RPDaaռOL?t.oE\E*=BOx쐃ZqOUY	F¹?f &GOIDR8N$S(?)ait,=M]li#q)e0Y(V"zVCzv>	9~Μ#p<ooߋ# 4=!Q#Bhme?@sX);8vH''.KllT$O\)[ۿFFUU?,ty0<vx٤ՔkYx
;[TץZuz>K?M3e&2\2Ne?ցt{13\,?%sst9\΅\8qQvM-,Bא?XPp5WYno+]l#2ͼɒ&O9iI\?6_AJʐP$,AD	]b'HWg<E-%]XQ,VΫ3,y͐vlQY~seq~j5~%v=e}}8Z87v~|bRSY\V9ZJʳ*}Zo UWtmۼOq=$,k{~~U	ϩ;Qi]|]lBL557֞=7DCJ鞜oI\ʯ{q̅'
Cu'<4^unG*ǣu4ǚ/g]Zʍa]W"S|\<;}axr->U|Aq:Ա4tv(m$'8\ m֌N\(-a--?%B֥խn66c.;+{r}u{$Xѡ1QTw&v%e~t]]Mu
S//]K^b/,YPR\.),+i}js\_i*J/Яn+s}wH[2ڳYsފֲke5G-C~uKy0py8d`qpb붡h7iuxѻѸznu\7WO4Mk/LM_]wF?7yu_ɸw5?	7оo:Bo'^\؃3]%={{;!}\a7t}i/
E/]ߧGJFIh㕠Ⰽ2IoN\țTerYxfF§M5Ny
vLso^3u;ww뼯I/'>h⽷t0dgŨicf}<mjkQu\j.~oFi[LWY	lmͰ+l]es:oMv-dl8}!YW)ciNJA:i-1&S/U
/'E@?`xd.ϕxC[bz/'`#럦T)m]K4-+CM-wI_ۋ[poqwA߼}n̚jw麋gs3rDφ]@ūߚtH~
:&+K$xgЧs;)Nh
n- B=ߙ2%	21;"#e5
8FՓa.
xߞtbo}FI"@m͸|7ȈlCi3mEnׁKfbNG,7*u@3n I, fZ֒@>.=wewv6&:PtC#S|Ր!-"$JA`ۿ[WH
z9?Wh6u4ͽ!uoKݏ܅Ux@I:MüLNڒ#p>z4vJ# ^ﳔǏba|>5{X{L<ZLJV-yG|9Mtם/
UV tȪ+u$qkfH,hqaVC|r
^axQkJ-o
>3|5i{@4ᖍKN?xh<ʫC*`["N챑je<Añ=NQm0E`ⵎsp<wz󫀨7|D]k&qv1,4/BxׇT9|&$R(W*\Σ\wԲh}qJL$=h|}8R4ZjF*[@Q2p
Fb跶ɭ-쐴]^RwI5l2R/i1+ħ`Ka4LȾ]vWYZ.iH~M'7G	
M5"nFy-͆LSWevQ8ύɞ\Z+y*T{&yܛUX~B'7fdU@
W@BL(пLU<?x
4+xa+#F܃KW3Divf6XȔE\InpK=BS< <Rϳ0!P᝭x-;c%E;k
(/`  ,
1<ˮjAI[Vܧ,[ =6}/@F	}peHե`:m"Y뼣M{0!"D*+U EG3':@S6e
ۍ¹<r/K]:C]!%([pP⇲<39LDo;J DS1|"R3^r|8	P&'04UJ\ aYXi̙+F*-bt}P)UIt+X
3-HbOBHG̍5${&z'=Ț!ĕn[
P	W	J[#hcV?2
ԯp1$|Yf%|tNO1+e_̾pÖP+/ng ~$tN׭C*~5L
wSӭ|$x27tNZҘA!aEDKֲFssm.د~x`V!ڵ9=y>R;^,Ըs9	>6yu%\_	fV l>ϏHi՗J8e{>#4wPCd,ӨoI؆Rnˠas;@m!i^o
?(_|g! d#7/fP	/
iu
^1N&_hz<pK237_fDPNsi'eBGӤ+ -x,IjU\o (]9M/u-NHf۽2ip
|:4_YllDZLu$UV).Ji/L7VVؔJ *D5Os"pY(IVQ!t.҇%>$	*jޭ,\V"xx1ֆ)Cg1HRhSӭ"Ƿ-&)OڇёY㜯S}_%"%GN
}dBAùBI

[I.nhBӓG1i'd#}ZzT42$LN-CuQ>T#6"W=	͜sGl$	T=iYtp)c\o 
¸(+"	@\vVM]vD6nO R<Ng?ey xκ.OA^YF\Hpuϒ!_8Zx숒 h(Y2*~-
{
.["idYXE
sҽJQ<J̨dۣ?'ܱ8>_i1F~cӫ^Kyw>Sכ*T{@kRuFrYNxi{teQЩ˽!Dd@FP"4uO+dQ~n:TήuſA$kKM:qO_Є5Hm*Ow/?R$s*Cp;璜t* \b'G}YRc +h~`'-r35i>9ܺlbi׵o20:B"g+/G״wcZLaܢ)17W]ab8R,[T(dN?ą{H=O#Փ"
.I\':tfqM
GD\P}Dmq_basVpjh#HBy@[i_6d9-XYLe)4:΁k+0/NzY
)2B3#$ejUԶfOY+KaՌ= l{ڻ8tb\9ZdHQ]ZrLK9rg5)Rڎ$RL7:-] ~;8&j<U>>b]G+DXg"r8S={	~p P О&h%'J2؀2Ч7`2^
SRT+ mC=joҠgW-iȝJzLg/8@3I{$\#5uk.e~,	lň
 Æk?)Ap`2zF@;mEbR4Q쀺偮4\='r@G-M| 8ISZnY⃱st9pXE";q}q!gm4\l+8g
dC'r6G-&?-,ذ,+ ~~fp^ĔxaEUY#+,99ӁX`^9TW.sq̰kUU5Wr٦W^wVc;45o1")((P_;I=y(^?Yq8;}r{XC懠]y	Nm>r)
Nr*6#y.|T!񧨷Im%'լҏ0KURh6޷cZP#Oy	~8{H52n~*=s{ɰs
?,<GI/\Z 0h䧆`g9s]p,G!-Z=s}*C?+p#~n"lV{zg)gIɸ:Y
Ht&AsGGL#I󍇏HS^8Q386@轜p[
BL17gPKe\.)^'<_҆4A0}h9	L6+wU<3PpCcp):Z	gx#2sDߠ~nQZ^'x?<G3
ZJǭS1qG`+-<wn %q>+'kĜKGھ梨mtt QQfyױhz)5*J}t'/Hz 7+>buy=@Fnάe|I#z~
YjkJ>L,OLה8U;} &!)MEדXZh 7}+] *RqJֿ%N<r&SE6EnUl"שaqsPeoT=VSQExANػ.Kvn=E{y)h#-gU@ry=Xo(%񰵽. +yq[Yu}?N]<+ljKAdv;֓:aʫ~̔tCܗ+ګJ?Hnt81X0:
B~Kq#ǡqfd9uė37*Nekv͒fɢcz-L&[ՀFBw\M-P8e5Bz`:#rJm!÷mQghfMA0[)nER:2mWE rvqg,:FoVK99?ɧO;?P{ktI IxH
mm+E`VTpy\$`lE2XofԉoX
P&"A_Wr)=yנ<y{{L%K|SsӃ~K[M(s|4+mַl:zQE/K7jN;YPQm˽(CH^¯=x{qq꺱ЬG*I!L $A8l{YPtG)K`iʞx^rǋ-ƎB=^j(P6`k(PI_Zr!mVHQ5M)X]Rn9t!tWij\X (Ux';Tv\Gt~Sӆe:~Is}۷b~J
64"7
vb/k6^:t^IיE-np&ME*)*ABC'h0Q (/`  N_F7R<ޣDn.6x4Z}&Dy] 3&XHFi4܄ZwX]ȰFS	mi3
${[x:2Ԗ084+7rH*T_(kQ=Nq\h?;.V$/;J^~1-= 0.%t#Cm;ڂ;@R.רoAkV|Va/&aRʌ`[ovlh0TPegpFarmWwi,4^{f;bHys(X2[Mu@Ԭn)]#
9U#ZY@?n/,HdvڀgyQVP浽"(v_갠˴)сa5WT2@Vf~2P+Aa4H R*%.km%.7
ݡ8<Z&ۮET3HY"hws̻+,G\z,f|
arzB NQ]A<]/?Pm1DFgГG6O;"/U(9nPI(ʃCC)ƚd}U`
Tk`شAnUE|>3GDV, <{.ń=:Pֆ8
0ѷƍ~?2/Ybu*>]ȭ)Mr| xy ' 5ѥ
NzSZWkC+ɻZ^Ώ̞ܝzP9(˘$aiHg0Sܓ6 
,{aseQ|(aZ5ISYTXs5Rʮ26EI! %/zIGM%(*/7VP>dNzyErįӄET3`c[0a
owB-V1[iC<<ƊGf
ZZqӗD>R@w̼=4F90,;.?%>Q-kR{s/cVWE6e3LoRl~C*'X0_ܶ2`)@OǬ
 NAO~_p>z_]/ҍM t>~fN9tK)%	;ڊh[5u)OKh(ýHĲkC;Ԥ"򜜙·Z")Aq,F&9&VNM92Q8civ\p
A1qhy
a9;x%X#S"]hON;l;jԅHfRvt^lE:0 {zbubaM"Ff"v,FpО/,S.pnn߳B/ab=KxlqV!uSƠ0ZUr|<"*+qRΆGi\P1pU2-R݆0!bN0mk}	>r@₇TPLG5j45=k	>(}c1ekGm[m'Qv,݁qߪ

=<o_$yD3fEǫyVk"E^ĒU趎M>= jj61~
GŜ܅ԫ0_Ohxso#CGSAҼ>x҄o="HUz\}c_AYDɀ}N26zU%v$]08hj}A9'dG]}Iιg52MA(y
>]9J{b9դW*ґ츚>MI"8XgOb\q(mVmSƖd\T: ڏ
a60f
7!8fCƑskV:ڔ8Ǭvqm?@"caJF74RhR г`Y~Z}A
Cqփd:,J3L(y(k012.xB\Z[$^V߈glh
-Wbx &螙&ȁ\A5/jsz 2B'ágshO7"Z';qősk|oϿѥM"Uأ/Wڼt@9` 6#udWBT[EP]r_!9ʉ}ej^A"ֳ=ۃԒY?(Џ55104b{Ak©c'l阄>LB!Ξ=Wy-/^os5%\9pvA)J궑@ٖy]72}x㤸yE[Zef2GyIaJ8ȿc`JMO4P#9>^$=7%g?!#%t<ڒEܱճ:$V,Ӣݵ(;SJ!TTrX
OO[/o%Ekŀrzld|)CRBYc|pO[
E0	^nCl]KXR<4O7[Wg˱L,Ui\e`4[昊w&c!E4{"y:yZj]OP4}NAI/m]^*I5".ѓNI.֟jZ}	Ϝ&oE@pHGͱkx^L?K؎iᩌغ_aV3'b1<;825|)S<Q&Ra(/7;;ysdt<M`=m+Eoj,ԤzF(CcY}6rmxi(; c"%(K6{`\⁔F
5^,AgkA5
bqan*lRq1˖hiK?v?i~U\sC{ZBMdˠ USwu0l9Oen=gqkޓq@//]B*
lT^"/VtM>$,Eb>9s@d vk#(tkt m#48#BkgkhP'΂L9Os y <g/!ȸԢwY~"-aqVi*g3fqxrKNC< \IpbNv>*Xb5%#N5 ؇N;
	?Qi%t9;r.fZ2@V.SpQ8+գ(.eqd`tqP׿WtLbUwwsq'V"չs}݆
!	yuEf@LF&'zINK-1{g/~%U:V!7X|Q6Җfţn(:#|0o`e V!WǊa[p@ZA0q (Y=T=k߷pɵ1\8ѭ/iT z !)Yuo䡥_x8VcjP:>^e߀[[xxo~B4ï->R3*&fpztkvvx8W}rG"bPJ:11Dv}}swn9b!"cW6b<j;Cگ!Q,IuC:9ȲPQ$}KDl?Hd\dUT;.?\kx=8^Ωi$W\^κ&Exq;
=N)COEZ\ȳ!+AJ]H?ك׈g8]\/z`AqE%=j)(0VCR5jt"s4a`\}(/`  uz  .>S01~yrecc07 hI	A?K)KEdFj
`(ݳe l7dkՀR|kuL"aЭ'խ՗4?Dd M#oK0/TƍxZ*,XY(`yYw0F΄ʊr?_2!gJ14Ix#Y{dxkFeF'b!zIݱtGdI*; v`v/vPSF+~ee 5O>b>QOd}Z77׼:b{_%7Mċc	I7M	4`mQL _TgʊqeoCGLbҀe_<.EVԞ3[ν-myzoB<@Bf(KOgg^`w\|E@vcYqyglX&/jwlE3uퟲUyH<_
*63KЕVtc`=<iGDڳ8;&(48`^妐Źe {h'd;Z9#;1]VOiqbtd^=;`YDn8֗rws(Jb%5jVUR]wϚ/ݮ+
,Өեƌ0jkSS=.EefAZ$֋u
T;o",uoXFJ	Xl5鋝
x\#S0q/z|0ɛydL\:ZeQi~w7F?C=@F-#С\L}n$vRL};8(V42gȡ;n֞HE]L"5Y%hb^~.%>EJւ S`7rDe\0Sde3vN_HE{b¤Rw%֍ڭK
(Z^` +@5_L=sIUMTc4IJ*V{V٤,x$]7jrJgGO - Gût氷ګʏ&*aYE{ć8_Tld:EW	l	w\ZﱁG
Bԧ\iM1F`tyW<'"IMh 8<x6ڷIT tKDAWA&`*5%;4F{C:g?8cIproж^-8@C*DQVWqjU7vn\Hx\Z 4U;EkKc9
mxO;1t*Vyp*贫IB:pLj^RoL8p̑!l
 c/kh\_<DQS=W*Q[[.ۃafKw@]=E{gco;O;M R%Lb"&lw`t5S!ߘgVnQ&9{Д~ƠeG8\4'cԤpBeSv.Mo]%5lV9,(|מ5o/8u\,HdfpWZ"5ZS aB\R2`ܷ^I4]5Jin>C
zO|gb&-+o o9C^YW4(#>p"Vyӫ0kOu,D4 or KH+f^qlyj#8̰4:č! ;ǮQoْ?"+}<GTwumoj1skf6#ÜUE0{IҚ&s,8qpr[1
{<cV!0!&{Cqx&@~T(EK
ڀ<Msf/,ZՕ,"'XKՔ
7xRT>sJo# 5	j0l&C? t`lc͊[K\G{d9f	I@q@^[ozw@:MD М:3cUs>Y P JgNܶwmD	l#nHI-DY^|I5'R{b'8%९xZ%b0yϟ[n5 J*i֛<'<26*oudPI
,n|<4ILndigX3i*QkAdcOJ0pÓhcA#GDVJ^\"f \)j	%R.vAm+M5X-mqjgw$vpc]in!S irt
#b&LVsXgWRSo6+VS3R(Kf[m8~j
 8tk#e0~Ťw֏6h9R\&x
֋C4V g@}hKMb^lxWi(X+ȥO&qjm|d熔ђc8d)t~/ ,; A'G#:BNJw^5HiZ+[D0R0ɓ^skL(7'f"lm%"n(RW(h3Mݥκn"rX#1_D
ޜ#[КOQN1ÿq^$#fǧ]Uj7lh}ծ۽%G6z>r4zчm(qyO@FC.;DMDR@[Y02dTS!a^MvyvAH쨢d+(SQuC`mr
j]k:2"s\ybS< TaW~:
O 0>c^ؕHHP|_,;P'|Td➡i8uu&$_AUJVUtJNTz򒻬9E
ZUb>kic7tt$@	lwDJ\5`iUe^.i m`o E6lE5>d%pd[_ILL%[
aR,X
'l[wYN
m/i SP8wK~#g_ž#g-"!?,la`#xrğQR
y2wGgkl]OFdiden	dza_ag?vj;ԥA#H!,-88pͭ:`u ۶;OC7t˛<Gy-)x?"KOB/4ec CT5v"4w䈏,Ars{]V!uBy``xpRE!SbpupٌGN}ejY
=<<9w/ɲJ_P }MlC7ɇ.8Ί:QAfH`¶ݘe˓&C	0"'-Tj5s6WY1EYUc#I9|z4 0@ݟh1+h#ؼG
gX.EKݨYPmTVQCU. g
&m
7f~t$&aЋwa9H)Sg߭8	ZhL|"X|'/OJr x9ZHwW)x@+	_#dDHoAtzBhQgwio)'*@*0BZۯK#0%~YYE|zЛ(/`  ϐh1;2s*[ʐzؚ "h-^H0Y`5m
KS4"(1sV{iP` !׃5ǃi8&%՗߽L/ߞ
"9
[-̒YӋ/0t5uBvIkKu lϮ	{߃ٽToȏ¤ӍUUƊJؔ2y4}ܬ5N>9NwTym͓;sg	!`eH9 5sgx\sʰs'^
XJ)1#T:Z芜7F&H'5pYeq'aBx<Qq[fYk*ۆ27a	W
艀j"o@0abkn7LFYhMWm۴8״/`%Яe|zZz\h?$O"5v<$0jЀE;ۻe9eV$U}d,3P!0FOeaI#UpΪܧמŏr2R1Qggoc06C{+WFZu;+_xܠ>OnJSo͵k_/o?.>E9v~dޝ_4[$p^ӣmh@;࣐E枩i\`1拹mLC|¦0p\焈tz	B}8ZC7Pb d^/5tvsmMm쪼Rߧ{i9(Vغ{4AMn9lPC64@HAr+>G}_$,7M{n9[Tgђա^Fshd> w,o|mAWi5^>:E) 7$UӚئ:  ?
m2GE}ӎ#Js^&}tda^rw5	 p'@sg#>(emhMY 1 /F-=8|5>`γ>';kl^*	잝
ǮV k5];52}c9'psIFx2X|:I[n6?ŷs֜D˛׹/@x5զ(r/6 xeowZm<8vvy"&nv\6D.m`HT7T*yǀI//AkZ}㖖Qџ<b'D 筓U'CBuƾ|?4BʪePy¬[C%L;;w򾰫.t	v:#婅R8>M61Bt;BةXGu'Yak!Pb1{0W)xbYZ{Ea>~72DQ_57 )]R8J^t
v>KED}N]@bۮybnX5 ]|6mn4@LnС\,o/S*S73?Jӕ+@-lAgbvU({ 7od5hN,e8CP`.1YݚqwM]N1lQS
"D㫿\ObDa̠ȡ}7f$<x>~QoGE#1@05tFx?^n+qlQmD	W~YdKҦRw̅LJEVFxL"
-l5tm#D٨0vrҷ5*{y#M\>}^ɼS!Y/Fv\Y4|W}SlYND:]ɐSzj|EzƦYm7#˻k'f-7NfCnب۠Rh9iՅ^W|.O
sAr0yNus{I$u`!E0hZL"F`kL]2@4i=6zov7mK/0uތY*Z;솁YtJ>\
oiA_NB]ٹeZLrr;N%d#1=A4hI~SclڦSg7M==դ?ZCӤoIRb,Ùp}|c=0)0ѫM0_/Ta MG(U_ytdtB-&3ҽv]"fʨ:W,>NM-}vέbBz쥢w&1˩3qed/Mt3?,Q`MY_+ 5&|yq
RR<Ɖ8GxWM.cGY%Khnz\c`6tQDkU~EWajվ:n5Qo
8Yzk%N.oȒaJs/ܝm8$>Q|IN
Ƈ;S
>20>j;"'-gzq_S=h	B@Xz0*<&R5%ج[tkSuC+*g$;bԢ%m(R㞷ؕLDx,),òY,F4hApH3ܫm:QpUꛬo?Y)dhDHVEV
Z }
k*!0#
C5nm*/W k|SFJY
q;1	T,ZX zhʖ5(kBx
hImըR	O a$:*c	7U2v{ONwi6nXbsR]FMg#+q%Ha`+wjRdşҲ[Yۀ-*Njpܒ=e\'AAIӛdb$1;(_3ר-b;:I[F`sBܰ^ŲnV Wƞ%fK谟l 84{ 
S^jBK|txe[D04Ϫ̩vv?nUDaf4p9r&
r,|BG&'>X dDR^o?"Σy{B*د*p8!MYea?|r H3G(ANio놓SdN]#BMF衵Zf;W176;]ܣo9rpfpu8vҒl;׊/ KOP@UÈ'R/DlIغ|f.ų;s^}EԮXcn<pMjѸX;ĿA4;@mfG@wLe-q8{obkE9~eV.0r~\!/Ũ=耞7ٺh M]9c'>V6!gOB>ZB2܅Nţ$@$hxOwlh>im@Z0yLds6k$˓'Y+4ք^q3UPƯ<hURn,)FUEn|Qa.LI*N|'rqoա5}Bvl4w#<䞒ZTڼ&p&.Б |4@1̲%I孲 
UI^zLYntLL}W9{rIz
tQ%v&>i*~$Ha]Ȣ,KM1"YZ:~
˩$CRFgƭ|Q Smy\4ZSajxElNKvEd،_J1Q9{9+j? f5@6u%$Eߋ*BAs5"(-~Daoi
?X/ eSo\'OB˫~NwrGZπRcTy(/`  ~*
BJ?Mgk2 Oc`})zZ[u;!Wkݒ$k-ej>ɖ*
fJFV@D6!
!@ѯd ė{>aG'2
y
z$04۳.G$ԏO399OM1׻4O '1+k<k:8g8V%WwvG?T($6B-ūyysYW+m-u+Mb{;Ӱiۜ@ 9hIYW-v?Q* >5嶭;Nw5.T][zq8keLm- -['ȼt_^\W7ʖaO+~UͤK)( tWuΫ2--5~y^qR`мg>NFKsj+G.eȥ5ُؒFrqK])RiW("fOBT@CLgU5ߏދ3S2&YѳlSBݛ718M$8MGM'JȘ}bRrrݵ8{%GgK@2LAݙkMW6~'|=7r Ii0UOAy/w:`ۭsLj'؋UHQu;%.4ufnD.фxI3mb=-e}*/QD)ZտY.{]c?]I*]£p톯~-߈&y{|k#aa2z[i}ߺDwA9 L3Ͼ۱߉5֛JtE//fuQi%֨׻l
}RJz:E_5g_>q+o;<W9ZlpTHFMϮB-+XXQ\HWE(zZavܚGŕN48ݵO gSn[(jpSxP;'~4b;wNǌbl4!R.IuUU7UHJ
~w:ɊV
=-3ufv7y-0Ž e]`E+iR_

k`SFm2Mzun3Kjt@}s&=*dy6bR*eJDhp$wzhw!Rh=[J+熎X %lXcuB(k`PRjm">*OAq.U>qQR#>_2[U|%5Kk{pEWFZT I=QdB6cN'?AA&d5Ô*bܛ C^0Egdunà, Uvlg+
uoa])_bG@GqCTY4US+oVd#~CW{Sb}ӳQrO3?R0"@U!]b6+ؔiSG\ ~b#I?)m:ZW)نZ)}'uү	.h=@t&xA[3#yKR3ߝrg"ډʈa kMAW0 V L}[$3qJ;FvX@OUl2AlW)PqiO6&IA_)]A6\x[^@@;EiZxPS:rWl (X}1
`r@{(+Xi$n񦊮+ V (j9>(SRgo3>"R M@dxAߨ=pcs7&jN\`QXwU+Vzc+b7TQP6b ۈm˖j%
kJd*4;zq:Z{33*O\ۆYC[+UB\*dx\ ])aj8L679l< O{f}۴If*÷B439q ^ߜoQCTҤ8*
8(@Yb4HH-E&|2N.!tƵ0  q#'	#EJD[4Ylt9roNH?HE?GQ<A	KJDrQ
RR:,AY*5A>]mp;]TEb/h B Q0Ý&]~PW~3w襮c' P-ZIKoE[Fx 3 >~cs!>D036fX|l-Cm't
F@BGA5}T
Ej@fUSxҽW_ =6BMʞ%D%@p=~~6Bhq,8ve0V3&Y?@1W7w9GB`y_)qo]R^-SFL^eoX~jirfE_QG0/5?iI3 ;ˎ{F( fv$QAQ"q5(rYdz,^0ϳ
m9['=He?Q\
DH`~L)$O':9ERARBI1
[VA[੟!(L[\wַ	uEKw=//=ث>i
dB,䊀,Ve~zX*kאwvc1FR2&y)[o9+AJu*,0h%f'&:eEʣ6J'pAHV
%*WբU l]Ǻ#4yfD!sr|؞g-$aHcX~>VZ Y:7SS	zvR$hhxըo5%66e yXXc-:ZdͲ樇s-Vi0zEv;C͉w{3)Xlrc6ȑa ԅ|&'SFyHk;|}0TxNΫߵ+"c6$Ȉ׀͚d4'./PQQrj䝻gb6y}嵽ɿ̠). bd<z`=0%M/O&ǼƒDEy\uqfYFzpBk;|UЃju\zo2aQr!`rw9U[M-3LH j3,,f&:lMBv!V
Z*tV|?M+! hfyI0ѐ[-Pop#H<EɿȮ.(v%32
%0b'v3fk͔"II *fC.0@ ̊{)Sbѕ)$stH̅E@2H^ Oe*$
!!ZHy&cg;Z^uut1{nr _/~?:dip gP۴Ћ,e&)*ԙH_JrKCX Kհc~c~t%ظ'mZZ~Xmo}LSvt~
̫p;x1r KabPa]Eߔ8ٱ=ӓ5	I_nrȭ優7,d;	Zy+ܳiO|s<YP#qrP+IV1h7B5c#z9ٓNw+~nEYz,vo<E|Lk'́S8ؕufϵxz,NBs|ޭz# '(/`  (|3|lZ_]fV,U>~CfWHg-Kφt`40gi3w@ ?66e | 
CS{@<fhDFk"Wٸ,Ie 禝vF&]:,
<Q8]@Uلod
DIL,Ir\UHx}db:	f?(&JQ~bd%^}S洢0>ipvZI@Cx;l	|p	mEN3/%-5z\k9i1	`2,
,,J
q*Ee#
PBDE0˃Bz=3 hӔZAw#i"[܍+*[O0+BVr<Vy<ЭL{֖NB-WB2qbKOvk}{{f{8OU^SQ
RlO*9b	#Pi̧!zgŘ*!Uu&&ubz:άjC澕PB86rI"VAn-s;Ga`vJnP >f`4&iO-$	6ZQT
ƽ96wΎImnkBmuHLy^Rn}}_<ڭy{˞4"GEI)L
8N@DV%o:r3N͙W(ir6!~1pYK>K)=K]r䢣X
NIXb@Ce\qFɲ3祿"L֏5#	)!:q`IL۰-S;0uyBl&@.ic"}~Z>
CE
94UpŞWo#z05G~q'nna=eiy+otyMT[.o/dVRp	lf+`zv!cbʺ,Z(:-bwEްCB[\
8IUE	+\{hqƢ|j
\ޔeTjC`5v3h22fp,۽D
ga	 :A9~ީ\GSz"^vKJŚdvNX^޸0I3-]L"\,nw!ZQϬ[bRJj]dԼ7,]@Mmd@RvX*WUan*Hb.LNA2ЄB>ZhNbbB;%v}@E3gSBfq_Y&b<[
M+\M6š|4yj]Qָ"u4nE3V=̯|F2g> f-4U{]\X0TxK,1"SQ2rSZy%KNVYʶfrAo6Z	E<hN7-.ncd^:aڒGE?'}iMA'ys[+}P4t8Jj-:we2Eǅy}յh?7`{

$̛Ȥ$ňKl{ܢ ǲPVj}589nij{ydLyK~2M-)w2A	p^o,եPbJ,c%_&bw{jDM:ꄴs;;*pNC1f4]cY<fGbXbf?+$vbg[Y{0xyeY砌Z5IaDDES˨`hWS0IpXУj9d7///lH@=ƈR_>"ʖ0se@4ArDVe'ݔZ 
9LZA`Ɍ˞
OMǒ>Ǩ0b9N:
랻յI}}M-Muvwls'#! =iɛ/r{g|t6J0~2L75SYvWhOp\[fHv[7gԅ(Iq9ڑ4(*
uzRyD*F9퍧
vy~AM^:оa₠ZbͲE/fjC0ܞ j~#KySredsyYȸſ
xB>*5JL=1`_QT:^-J23^\ظڨu5
a- L%;32AkipS3gpkg=>38Ml=Ks%GH|.AEM-{
FyUFZ}j2y.}.Pl&$;R?dJ1?\	Gt)9gںr7
MtL+0'悹~3ZJ:3r#G@P]4`I<-xlؤdi8jak BǍ"zC&f԰GS0Cj-"%"QY.<U1Q7['D*5yGl\S܋UNZOls3LvC?B,)^I #K]o@¶`1g97Bŉ]h4, X/j{N[l6jp}\/|]Չ 4R̍nfc2b1oޑUQBP<>BlDx2+4 ({.bz|`ӊa7Y6W)>2xi{+!z	1S}o^HUY>z~ŅLr`#bLШ7wԇstV];+.:t [w*/?'쬷<ܰo8璢&=?x!ZO;(C}'7.Z$~9cR8-<!'qxfj_\v
VV=i	H[G.%pAYiMȠC>[zۦCXhtG[UKbǐBᒌ2#ѩ12	,k	3_g9?^m7.%<'A('A|bTX!jF`ʢ<p+^ݑqLCAޅdc0.1kjKXXWqζ;t-mHE&^g#ǹKaɈ9ejrk3fLStӶ[ArR^2:>yen0XH1ϏnJ?XܼSjyf%_N`H#H@)R<)B܌IBh[7k.( p"	6^%sOu/]Qh V]T2c u~p?R3?T6|wj8J8=+@4ώ0^+SF0rj8aGUGlj棁L;`"U>DхEeypcuQ
٠tYG;%p1 zu:?Q7Z.X3dc
vM]$@S]hDvHAЌ(s`]nnKu;G Ɉ{iv
Wm3/wH&*|Khv-ᤜxLKI6ekSc*` _It38r`nfVv]xъ157
jKpU]w(Zն|e7RsEf^l$_x69< $P4䷞vCfOdG(gɝe䑹sFy[yLl-!jOLWZ<#(._԰@^ p'=)AT^\NrKySTP)OF/ɱZ_z
f4ZD[쎬ܧ-o^=r|oU)aVzP92]PNHHsX(/`  #X7jKK7O@lܨf!E}~Bj1
u~Lִ(iI5Ekj7ô1yh&-[JEy}2ceP#H}_̳Ve;O'23O#\gd?8jQ/(ί8Iq>OΘńtludmpEJLhtY*IE[_NԭK?32>斻`pR6gG. \m8Vޓ1P#45F*ܷ<6Ӿ(j^Ӄ{r5Llir͇pUhe:wA˙~b䕨4DF{0"Ȭq!ӹ5|D[<(ԩKyw>+KE*SԤ6u%$vFFaiq<\E6ʷ6z?ёo{ss'] zA
wwxw =ċsy\=ng pf7̧Flșs-9by|\兂`]c{["c)&Ally,9\o15KQ#f
~qt
|	$vQu\]\;u{^["W8:?[]zU?)1>	
pIsǓ!N]LAXfH2)看KW<fSE6*o|#F\II[jNɮKNr38_-I!)Y(*R]L֏f5-ɥlJWZvhWL/t'=M/p3Oi0Cک;$t
b ta$ L~҉m1YE 68\x&XpO89SB9uG+'J|*bz2P@;~$  :9T+8ꋑ1YVX|!XM&N|)rc_yY".2C^25N
RsvO4f)^C`&-&Y2aZ\&OE$@VH~BSO-,9t,^
6DyÉLѼj2wf
ц8w]cYD,xPEbI%
3dϊ&+*lY{UwrLe(V<cM'yL}4xcSǆ!wyݔbf>)zG!
Bj8R%YR'P DAE"IQD"Xp>9 Gʎ;h(ivܝeQB/K֔A"&[u˜0Re2Y~kN"
&2gyj?ƅMX]PRAwW1<g1Z)Xc}N˜<8.EHkS-hNz,)YZ,dθ
=Ƌ<8+nDWt5꠳n(@fz3,bCι	RZl@r_%̴T; WNypPqfYG\p<8;IWx-NGuU=Oes.\tˬ0.iYs{+'v4XYFdxU6h.~cӣ/[!r8DH)
fhmشeێ]{s2LHQÄR+y#jr#Ej͞sHNFM[nױKߣłkSCJ41aɞ+oa#I2)QAnƫ7r]iߩk}+&Ȉlx GVc0'Ej}:]&pMjۡ9>Q12LHQ#Gjt1g˙g\t(	(RNN1:ruҽW_ s쓿a#Fbd(U51aɞ+oH o0bJb+*zaB_.
[ wk0bBg~ݣkmZޛu755555"7[[țE
ErI%P1Fj̇bK£}4iZ8ي2t-lݎ:;xz42<.,q$;E)NU7 #2,2.S_K5%}͒L}Yl\_>+seiki-u9r.Dִ!3q$oeCNΉǋf;zk}i}f^Q|4eec:&EK11
%61Vo`fn!?o,V7pbP7b=9lC08Bc8<H"S4:bsH,!)%-STf"
TLKGχ.hXm4F|?Z
^g~X?+{' $bρGC	j1R:@+Sr̬Ʀ&
TPɃ1̬@ ȅ>郢|?3/WGLYP9.ۅQ[GKoc )bL)o{>O}K_wY?ǌ!SÓye焷QJrW,)ⵈsA31?a~O
`[+Sny"a)Ȕ!K[ִ#!lCJU0xmaD*V^*ˀzs٠KyS5CϹ6~6w
m<+AtXaQ}
2.1~ܽn)qog7[|<$hie\g>_WXhUTN&G7b_ߒ&=#s3pGe7uGB6 Y6fz*,a7xW1Zo])Rg%x#uowrLǐ;&S"#mhIw
4>ndae
< q0ZyoD"Y<JT"f|2Is4&p+-9ͥ=f {sp}ZlS
L=` S_UU^iNk`_usOkqe =1Ʊd9^x	b lMu=nדn;xmƓeđ[![ܚZٓ\ȫ:]qʜY9_|<P
GFRe4__?T255V'ek5N3i9s_ԭd=Y
k\= K7o{~s;ۺJg.7xpYo괙r Trx3S *ҍߘUf_ni3S}Kg_|fi
Uxױ阼㵃毽ToŞ̎x4_ / PX<|
ܾ.>*&0HoSBRʍeb#ظ/eAsa)Gs.K9N'kY.#KvGbKhed0ٮ݆JC<W.5OT 9JRf9Tt0/0,uqI00y8!0-AiIWx"2lVJ3\䞇[~&VlT	1p5ūj*ς
-[(meŖ7F[՚+:hwhMi4VT+nv.w7fȐ,Uc[3kv96W@<eZ]uպZ[vwzx:ډNvcp\{Z7=l
NGdF2nSE"*Vt˝isr=	 WԼ|#LRGJpK2'w*IUj$٫+QCIƕl|J1TJ3tS0L2lpi(/`Cm( N-tE؉Xkuu.iB"cDlIͥ|\k†@x?qx|_ԋ^S0 @? ޫo쯒 %u&_DO;!0[(Sa\X$E(=.㸒7qq.W?CjIwӲj)=\hexCo)|xʙ\+
~F;?*0Ŷ+绚rbsօ\/-:',BUn2~T7Z*BԲK6
Gi_
>Si8ShcW-ԥyNG|V86G*b0b	R[K)Xakt3EИ2:uQKcw`KgYǼ3#8t8Gg}C]cL q	bYbzx;M>	vA'6~z07q$r?ERcJQ%u6E[WOK$E'/MPNv*	'w;7nЛ@(WQ2,͙RAAKǣ,J%L`Uro_|uW(4ҀF-Μ>rBHyPdآkdl
A)Y
Hi O5،{:A4,BF{K$V= uub
Y23WZ0k#\;Ƀ}ab?Y愭g T]Uhmr-OaLx!d,BL{¬Xyt zv@>u;9oCK<H=\5}OFa{	oZ2aJ'a7HDD'`Wp\*djB\xyQYYVjQ d*nƵpy.2%-^.d^IY}P@Zs%|2KVguo/5 ? ?ej6^_VRӛKK.yŽH1c=gIK0ȶt(#I_ꢂZ0,B㬿>憏;{ڀ&쪠-.r57ID]"JP!Vp1IpI{e$
!5        	   Marianne     Regular              A@@??   
RSRC _k@PK
\(J>o&RSCCտ_{
Hd/l[remap]

importer="font_data_dynamic"
type="FontFile"
uid="uid://cfledwhux3gem"
path="res://.godot/imported/Marianne-Regular.woff2-e239f157ae10b280de4db3f387c7a9b1.fontdata"
 RSCC      ǒ     -
  U  Y  
  ^  f
  s    
  
    `
  	  v    y  E  i  q            (/` D *LPPf
O.ұNx&UP8QV0QkOo}ii_ONfU#DnJ}Q4"e

)Ʌ8o>Pgd
UE`Fx(̈|`OCUQRMKӰiH]aJԤ߲AJU<^ QVVQwa4kY*Sy6D#:ЗE(zK-q=r$k+u൥lF$BLk#+庶r]1Do4Mg5471oSvs]iysvF2nMf+j]h$w*óeCq6X+aY#Z#oY7qLI)1Q3W#/ט&LoY㵠KvO&Y分#i6q-o֟shLkd(d튧Dw%G4~ ~XwMЖx
eb@Rl&Dd@MGNٳ&3$uYjrYߩ%Pny-l 4%X+[;{nu>7Ǻ|[߫e^6o皆WWuچ:=ӥ:-Cچ2βp9IVY&ţَ\qlBᬃm=#-CE9Z4MY9^Xf3ק< 8lJمawcFnb7U)X*V6URjE;M!Ӓ}dZdv@ D^<@FuԼ6Re<9p9{٠4i+݀7ḧ́v\~&lU!'=,dX=;
Q ^-T
*T+)Tj OV
*ֿaER@MF_
_Xu5LtҥH`J1&02
7vHX0$aJRC{Cұ^2Ƽ$	vkgeĮ;]AODS0@ׇCC}W#x{YX-&bՋ*EPME_nlKQħ +=>=;=Y.	g aX:O">/ȗ=MyD/x2o6aO+awʥPcVW,{}0Y+[}]S\OMuu$9ڮ(gzqm|]ip1m)04~j'42		b
qIH3"S󆞗FhimE\K'DX%8<OQΕypxnl<0hi鰂hjjvА|bAb
\5ֺLvuzݯU+h:WZBbWn*?
0IxE؃C8 ,X<X biu,vGNũ)^?هZ돲e3ir+R6=lW$Fb#>b! a aβp
p
pXa	pOy6OGdj:ivzJn$/4lVFऋ4mhg-9@{㠁wͳs\lcs\333̲ژWY*;e_2`2$v֨$6I"n $R(sj()((7bR͈k>J)ʮSdcQY&9tߛkB,nQ[ܔLȽct&#攳,?8$)p1
D'ќ 猤W,leiNucKZWKKh&ɊV:6dfoua|}-dI
#Ьj d_sHb̜v>kҎ
2K3SۓнAyX54mˬ9orM˲&q_0'Uvpf=B$֟L$}!	;E e5M6wV8]#<5_%o1-)xdؙCǉT϶-_zCAռ/IL <ؼԎ-[(/` @ i70.|gVSK_.tKCF`aLHdMR$	fB?4 CM9tN:N<'3rR9EN~|N	g֩d>2w2Ya榙)L&ӂYԙ)TN*AeNɦSZ)Aʵ2/ʸ$+W^eByKDEr"A)tC!H/
	DB=Hd
HR#=HDɑt5GKcјh,4rF6#8eL2}8}G?Ưqa0JƬk̍1SO"'(Il$y9"Q&fLD%"CTkgO!+b(B FD*n
+D!N'd	ZB*0I8$w(d+HZvG֢4ڹц^Vhjtttytlt_tMt=tNn΂.KL\\Zνȁ@r92Vb|7l{}as:k5+*,=`WkJieZsV75̺e.Y<ִmWym#	k
`eWW*)5HQm3E2Q?We
PET9T[B,p3p*p%pp
pXg*~J/CtOz'5VI7R;"R
iT@i[ۡ[[[-ɍmɷ[[y;jB-E 4
EAO#(]ChFh1`8_e{}8?;󢁂FZccƶ]n<<<?~Z3x61븟X?6mvs^ϳ
o׳	s<{}cgyΧ\}9cs|tX线m;P7oosXYXPK0%<ˁmX
뀃p
pX  ^z5^DnyHeݽ	}הurf\,nᦹK
sKmp{sCwU[bj%CmN]Ӷ\*m6f6`ܣyO՟.[+[+}oWz?}߫?O~?]ן՟y4]].mwt525252}La8؝̋梹h.OӒYX{Yg{oo{xܧN̎i>H#keX0?}:p˧9ۃuv]n}<tO74X|nb5z↋25ݷv ^ݷv_zc><,@|{{@q^L1u2"" !)hP(MZ
b9SGש|G&MdA9
:kr]	HE}).D4ԔґZ?$HBMـ;eF0!RhHnc?Om^oUj}IKUx>7y$*IfDN^D̔RK܏zuZ($	*
Xt!0^#a؀Y0аڝ1YR;kq?O>KڱCsMd9i3ۃWcb|ҩ9a!yjDRB93pvBt\ʰ_s͝g*GmDXYB
~eM=`Bq"HW|L6c,@r7y1Dyd>x{+ذ\>'Q@$A?R
-oz%L:`_z5֜24v$>!'>=YqkD§囂N1/W(/` Q "GP$ 脷	SF&GF6B
1҆vV5Qg Id'I2ƉۑLR
a(kkvk6kjV-՚ةڨ:mww!XHY5͑DG!YDQF+=Rn/xmAYW#C4qP?뽍i	BP(
BK
<<<ϓ4ӒW*9#'\E\jiKKYidt%􍾊V_Z˒3k\\YQ`-˟IK@a8(բI)\-=q	LO$є8A":L"^Y{ʝo(17ʝ':x	,βy1+ɴÊVWl.H_WSbo,0Mydph0˒oizjC^,њ
LOQ*݉
c9d9H߈.qӱd9w?SZΝ(:h
%0ѓD8>CIP>rDkJ@'Ĵg7
%7{>v(uw[zֱ~uxթnSzԡKOkX	>"C?;obM11|o`K\mH'$#1$~Ď_^6fċX'bbC\	<,flY`@p+
{Xa6;l:L.I8<p8~n
̆װ0>f.cdx_`{.̅jVa-X4h!ma-ama5Z0;h]
v̚?g
glݳ)=aQ<YY:;gl-alaIX8Rv͖3,ul`#X[Npf}۷^a6edlEn{dl%CVY c}l;VX{cl	쌕lulKض`Y,oljbSlڢٚmْ؊m1F/E4ݢzfѼWt 
@ZNigmeMc-a
(z:DW5U詖ꨆuv7vGG܈q">ąx?܇puxtMtL~-mx
`)It鐮>+$"Ln <8`Fmq[M7
Wn\BͲ.':GC7B'>[xp@s?s>_*<=x~&\K8	.<9\;x9/
38'1\̿˻˷\˳˯[9U.#8C>R^>w~xQ.y;w?w&o_r%Or$wyyxxxxqG1]܀pm,{Ke,[e%XX
 kWx~aMMZ5t
lm54jRȡKŦRHA)Nژ4'i4Ҹ҄@s	1FtY3gp~]Y*SJYUdʐM!kB&؞1/cqc;.1c!%)P[/D$:`PA#}}}+1^r^H̼~uKJ..M\pUqapKǖՖ$6Z1- d
Zde5	.XR`Ea)sj^Zae%<Q{TmURTm&*?TsPT8NɄ#wL(1)>SlLQ265%HjTP
TEQuDj	T /P$5(.DƓS?U%ٙYw?v.v`ݛ\J$)qɩS'2NE''N6։R6etZgut@wr
frvDLi/ݥYK_
JSt#h*
A?SZJuzi(-vq
Ặ{c?iI7ftFn}t&CZHi }t;ZGh}mt	t਑M)HIB)68fNt@0S\Z_]8յ?ܩC_(]̉iJٯ90+/w*@!Ca0#^
"N=ҷߩ=-vժ]"4
Y6H6jM	pYJ~zuC"ȸ=<r`ʘ#7F<)
2W8T+)sۑ[8匐5&f`9>HkJH-8'KoP3ݼFaͽpKVt9H;;jk Y?"Ƽa,CDY|߫-_Swf݀'uS(cH@NC(/` ]r :5I8Fr}GdLu;6D1=mo%D+Ȉ=
	O|evL4dzD̊L>լP5.;wxwmwKw>wv[;!vyvP;vnH#RgnZWVWTǡΑ
@@✐99sTsFsȩ "\979-9%-ZHEBAuG5BP	fWLS{S4:}M	w$/,)C7n-mȍǋ//t^v
F[[[5.kkֵkjV575*ji`r)!MsDև͉{F?;c;:sc63fIf.bJ;j @CjR?)>)=)
)tI#ݖYPF-[QVTlK
2 2&hhQhѧ(Oql. r(V('%AVAXU a[tE [KmxZv
Uőn-J d2J,`+

VXA"rp˂-DMVAT@@E
YSYd= Vᕎ++++VBVMVX"


*$T*
JCT)ٔ)Sb2 5ԙ(0QQKFEqEB J'j
TM :

>A@#@!BB	BBAAun<<9yy\๟T'-''/M884mؘLKK0Ė6,Q*EQ¡BK)II %1I58$Iє'Ņe y$H" 
%GMG1B4Jbh͈(	I'
EKE;E{!B"1 ȋ@|&Lu
Ru)qA	X%
Q	mZ=Hđ"$&0HIAfAPA!f ,P @T @ ub,Ru}䧅vZ7ʿ[7#s8a%?1qucaMb[w?b2~"GO$>:hZ=d/o|oo=qMI߾zήu~NAP;* z?.;g	ΛB_l!_F%IKB#;(ZYs^deJ}7@FAUU *\ ZhgV|L*hEI H9N\Gk<Sk!f1!xr}0p*Y8*ՙbqYvRyK"6ȢX(9|)ŋcOJ[U|Xum@"HZVu={]}\=
 vWdĺXl XD31My4`'/JK<s(<B|:"O
rН㉼ܙHRzDGX8{/kΛmY;Gm</S6@F ."hc%a`lc8AÓi9~+Ñ![S	6d$P-MbYСGu:_J×rNQЁ&x5'<9@qDq"M<xft6w~~? Gk!U#N
.!>@>?>7>|=+{BؓCEY@GJh Af3]ѓjpcFb7KmqF0I7FN##I<M䥼Xc}3ڧGg6+J4J)ZO[EQ?{xΓ$u-~iyzb뼗1=|
c
zׅHӺúk,-hsrmyB1^\YGkǙh~2;'k7QZzabi6W҇u_
${2KH<{0[zrrObc hfIFfFZ
$+3RSRR"2M4KOyIԖ$_>1+
9f"P<_r61h~X	aM	H*=SM/Wn`-LQR*KR$$m(_y,L|E$S0wLx^Lmm /$m̌]0q(5I T2e4N\3{AlMҟzWG|sVicC~s2q{VuW~XI'AnCH~s:	w/xϽaӾ17nr]~$H(Ӆ&K[:MS촮Go8l~{k$gf-ƁvZ_nok}6*:&5 '.dD1n07eϒ&RkxʟYCN-ViNf,iIa4-7ef12kFX[$ǨIX;,/Uv:Iه{EmSDύMNOH?";CwCE~3DJXß@ $뜍k=X;qc-wUkjOcR:nakR?4H3KI4|6$@g5T% SC	9%@uEo Q`~s'^i^谆ʹFo;Z1I.<W`l/dĺmxB'V7
56o$VÌ0o*9b4L+K=f
:'=wV1th"e9FU	F6N;D!N2k^ؔݚiXyOjxNzZ	JKڶEO
h;;#⣟LI1?wǬ#ԇ`esXszX򯱲s^oWXÌA=|$yum3:ƋHur;/t;tmL8gբ>EVK31I71>ssa Vwr ā:@W^xGJ{(N~Z베XutoufE2O^Ͱr@uXElu<"Qc;/똔udd.]Iǹz b/
?C&)F,O
밝Xm 	e.^c@קȤ
n-&G@
%;g#>JQ0C1D@!Ȉ\g0BDjhgp d%rďl-&$/GASQN2N}{0
0hZ4uZ=,| ^q88>#t@De;LZ5?Fb59h) !Rs
١6图+&Pţ?ktLa^%q*J(/` }b j|,K J!YaW!n
^	ԗuN~ekg"!y˗Y&KkAQs[H`#P4r4+.#聜ǳLX"UWO}ӠTW0µ [  WG<i*yC9.A7u{a}_*)JRxIË]xl} W=#/Vjyo밍Zȑ^#L
ưDl}$7Gȑ-enbTݞn+S+E_|up8!~1n=^kSjJۻ_maQpr{&R_/e!hfj\o
|=n:SFL\7<(/gz
z"r"*YԢq(ګ
|S _(\>ƈD yw-hq@ⱰOC`=\pg2+bO
W+[{uvqZt"V{Q 	j{'!|{8b+]%7mЋ6`At4$ZOhlɷ=&X]SgQj9?NxC(J`Ni?D8ș|6"cA㕱ZNeRLP!`á
a/7Uq(zlb6ǕV"GaF> 9آܙ>3X,2Il&щ%<X{!R5!7LeѳT $t0MZȴ;5Ie:m̘24}g<m5
&ϊf\yY6h(]fWyP/ȗE_KUOqo)we|iYėG"ސDXpc}{mF"_۸17W,N(,opX4lk/uZm?02~?B>u3%X**`		
 /#B_?N238f~tQȼ!Cyoi%4f{]fmuIL+댍4(ڟts2{/
f;0d	ob7pM9[*׷ ,RF% ?xĳ:),r.~%'rMO$~闞Ix39%֘
<SxOI¥^>œY)^s]ل^LUwS+^y{gF|E`e0ZPC@iZ	,,Mg5N|pm5{U'<brN(k`0PBԨavC\!p\1iY_AȬhӫ빪6Hu{3ґ覜
8Jt7IA@| <# ŗ1&wbp`X|Ke'{X5xqyatkA)ofPێwSt5%z=ZxW''G8)c!ZYtpkJzxe0?P#?W"S#Aj	O>qѲI7|lX96kwVp<mįlGzkZu5co!t#}#P4r;_(g7♅_d0eL\KLۋ<Lp_2OtZMO4y^N'3Sw_\%`7!ÁmX7Llq9q7L6FYlPYHqL6FJ/`	g\78/%@Z 
@vxbaQ}ZKЬx%%2^G%eBǵ7	"
I<ـ'1x{d{zphJ"\.W8ЇqR
_\B%gq+kñJ5:lFz{ OmUBꋾjZf[pxƕG7KpZVf:<_؟|/F?k(vZ?h({6Uj)
9Uʥ\c|q%gz#LH)%<<أe"D`Ȍ% *A迷35f^!-
2KmR>7,/"6C wy]9	cȜ',o5ۖ~KzȆMMsʼiDJ2
c#ZN,B|mBlKU! [;|h1@C5; B7>.HU)%kV%DSQ~`4#hkૃC4]w
_5@_UĨJMnI-
onssG9*B&r	C2ޥͰS)1<Ii9႖Z\!
A1X*L,K1vP,ÿ324<H&WvHPoCuv3[8]@Qxc«vy@љyČBsʘ@4\Spr!3]s/p9'tģMl^f\2ܲwɓC19%[*y?E,6&%RƝ橁*	9M6hr(_}mX`
6q6F)*$i|*fCNvwE!ԠO;z ~f3_1j\Sàh<wA(BDDFDDFUP"!0bP C$rxT3Å$|eD{!.'(Ȅn0ptFWܛ@E.Ra~ل~{)~۸칔#ceMfȒ6*'/d\A:	e%FCL/"#cφZB
Fb[}CY{Ad<eVldȐo
fC/v񔸃Rظ'^\8
#׻Aa/ETgD:!F o'L|cy@֜flUZ'h6LyCp{UjGH(/` EP ZN Jja/^䙕S](I)u2}k8YG5T7 jq ZF㍕yXM!bȿ5e[QgEȾEdE=.VGXSiMRZ%l֥[ǽ~.O-
$PMA
gǌȞBCQ60?N<AZث'izUړ)QʍTg2KpJ/kbG䀍Zi,,|x: 98j)YWvKzLMQl=1m#wzv#R={~cJ[EQL\Mc#uJ<Wa֯5`a"-i
?@cpkAtRXFX3]^g
RhE05qƱv9vQ6h-.3p@EW+͇+F5S6Ư"dvp(pj8?AN{;6wT|R`~oJ5kC#$,62?S)^VD8[bYkM1_ycԻ6~5J=b:ct@s2vP|l)-TAh&*;bD|`
`Ip~hY	_q
Dr#-d³Ӿ:/e A&j/R4J,V<3ԅZD,FD;i%M ZPW:?&Fne{pde
//V{pzt4*73_30+k&;!b$$[;KZ}?Sf;8&U(妄 {ę
uZ}֩+g}$q%ԅ[s]ZF?C,R R C0mnczVMy@5G 	*i
]Q,;bGӼe/7'.uCVm5!7D7?TxHp`OoRIP}`Q>7qy`3mIM{DfIgY]#cW8o,M6Y=Ϲ-	l(վMF*dM39.yl 3%46!dDE4T)##!0rB9R'9Ò;rjp6#eS3$f!3$ԚnR>j0jʬl?!as	>`T{;nA./15y	3?G2u
65S	M~Zw2-'Rt5?S6]W;d97&l_5=wpX;$%@qqrVO#䔳]yRݩRhh56x-%D<m#qD#:a[*=!8ґMd~۔|*{2!_38eї$]{A֑/R&?CTy頺fl}V~JioZO$q4VYi?Uߊ:abZw՛b<i<ve@ˠ){e3[lm;ݻ|Vem΃SM`pqy8t88\P.堖HJL+no:CZn3쎢j
RV~)xp л!~,5C$ZXZnKAh\dH:cUG A'f?m6'R&Ӫ5[X55F,:6ZlV[")1M)1it7ae~K%ox^H`yy8xWs{Qgzv|HRXˁpRAj
qz$i]bk˓Zyݐ6MGLPV-ۆ) ʶq_8j+LZEEߠ#)s_d`lL:Zh'yљ95sZUq}⨱0$B22$I`B!fT<-J!gDd4Mi
Á7U]'եξmCj*C9&:@y.62㱸vȲ7JjrnC>Nfi<fFܛUdb\Yk26ry_c[W8|m3!JwI	=?}vN5`9@kH_zžRk60+}AGN((jPjT7ِS,p	(%9"/@w %%l~$E'El]'X8jT5/XӮ[ZtEiV&>=SӘQ⋔v!emsyEE`QX=M*O׌rgV5gl+P2ϧR&%n2cȊ>sOd},`LQj)`~%"lzx} Hu	A.ɩ:dUi 0\&*N~fg<~WM]ԩҠ(/` Z &I N,Y3[m.Fζmm=mv_G>eX+6u2VbhdFrFbby6^ꊊlGWzG"NvHk(9)s -bTū|#x@L
H^-\Ӆlw|v:p	,+*2n<KFo4d3GY7C1/F,%W(k+QMbd]/c_Of:mx0m	i2Y9"d,1$Y*μӶЁ8D@\
FkoC}҂Ah
Dݦ&컗?x'KŤRW.F?!%8q.vj.٩?s˦V/:p1S-[KhUw%ZWAĞG	=,f[åԽ{Ҝw)CS|16tk>(_+MZH#yz;DQq Z0tHm6ť'ҧMl1^}>*2Ǜ#3TnZfJ^O塆z>v=Þld;E2mxd%0wIG!.~lsq_2d7J"l
4+̔?- pӞd/)q;(;U<VLW׹4nu^K{7t=--pmN%Cj	qR拄ղ$˗Ia4b$,u-dY8ȲrYkTQԙAQd#OyӆܹB"٩C|!Fmjxę)BLu,-{W./#j''P֣$Khj6DҜ=|`DMH-;76mNJ&xy9Ze攄᫅IͺWBp2
/PЧhRp
C+eݹnpKnOd684C^8{X쓖'_
؄&\Yd4pDqav['OjatL/Gh3l/1S@A5;<o:-OcL$~ï#_7ahZ%.6l)/j	^ƱIh]\2M?oMu[S7_̔N=|]氭7OH<x-*+n\Kgh8;rP)`<֞e؈^xyd~ĥk2rd|֎)%ިEƨ6fAG^Xpuq57K\N$J(Lv,-jEMlGx5=DogeWͫ6f+StƫO-"<r`Kh3Fy5E^΄DrG1ءAvS?t^egW=;_'H˕_C|&+G!~r%;!O?]	wR4r4&E4⍂6htۉ@Ȉag4m5իѲ; AtQΙ<
eX FV
tGl]{?wGQ}7@	0^Hle;}Q_N]<b\x}d(4
>N#[	P?_(ֻ|AQbb9eFM(IsJ
[W A5</VqѵPw?ewm4^ᕩF1aPiHV>5kuUS)\_ʧ*m,Cو`3&ɚ1a@d
=gV̪`db2Êfx]!!COhZWë'II݇hYN@	|a|9¬LhM<!
2渠3BZ_lŵn"zh)G+e8xX?5%r<E>塴I
ljbpvLXc}c҆[<<8©|=j`}EX\6F^	ޙ밀S|g["9a8"f
ar;m*;Ib?7cQԈ2fG''xiG\*FJEZ!
׳4z?4W/I9xuS=Qiӵ}rUC'@xdgbǽ:BHfNt*n渞f^oOdm"ם_m#-kJ@ذJGGJ1-wb4]Bl8^|j}dOnL%%U9(IB2|}im˝"WͲ$| Wme1uH&
HDD$AȌ4F:PBA7 ]fd(%%)mM7IDeS~3`/6Cダ,^?ܮX'c'8v>NG^߈;: vRG{F1hk%&\/R X>য়gYZ;~k#Md +i_h<NߟȦv	eB	74Ўhc JJa,e4%/ȸ{ t
\9O-҃a:ׂ)<t 
h9_T-/|Ho<^/NGS{PכYҲnXŜnzI3zoy~}mR37Pm\q7us@V>PE.(/` R  L ih[}@X1DpJq77ڔyrRkGZѻUpGW+%q+MS{9
^SoL!'v1uvY';q42I;]r-!M%Ljm2\wJp))=[6Kwsmޣ<b;39WF-[~n0 H 1~\_Ac~DFǎ/^^H:W-h%&Kab/Үx3yÌJ@d9 <uCڔ$WL&11
)E!eY=ET{+C\LKyZ$bRKL<#iRgz4=vmY-S_%mvǰ/׊DW{DCCՑ˴rw؈RyǮ?#HoC(C~tYzV.FnfɇLS)d%O˷|`ܿۏf)HP+@'4wGĂ
zY	kʊc9:4(EǎnddV:kIVk(*$?<|bKu*$2a*2+
5]ĈHWZJ:2
{<gtAt:\Qsa*jism	s:<K g=D'TRǀPu&WȚLP6V@l@3׿toJ4(R\IDǼƩ6_,9yڥk@n9mmMc*}0lOe	/ČvZ<]ۯ[sJɀڇԩ%>`vd6a<9Ԓzw<MsҤr>i5gm' -s9[D{Ke߱ܣXjl(&Yϻ?4U|Ӯܙ1qk|&
*V}%woS:tH]OZ-e-թSF|r;k`$UlF[w#0be劎cD^`׸{B_?i\֒gH!}3YGv}Z5(h)5Zl!DdȅI2lUa[MHP4JtY
&eӜMJ(Аk'M'644
_+BFVçt)h[8
	bPPN#I|i՛4fyXkmS
pRK/F9z|Z^g88J̴z	)+	Vq% bpRHt;]Cs)[*%]8X	;-.Lwà~''{OLNyzvtcf&.XZ63T0Fx4$t{
'(X4Wm/3f`1tV~],"$}򺭍-qrT2t>]q!,2Z®1bּOIhmZ~0	B 3khh-PQዕ5lt~(҈E0l1vfNAW|rN1ϔl\NH"q+6=WbNU\Pw8b=v,*.l\ѶxxN
 lgxq	0\ >"^ 
4ӮVB5sBym`lP6-HQ6 ADrCp ~/	I.B÷ؔIBMX(-P9XiÕO_ upӘ;wxEZ|%eB3Gͧ_/%^mɇ"%$Y#pJ*'fN 0mL@_âR.%pwLx)(_$'͕n?pY{ !p0-cas3ռ'N4S~,a?۪2׳zFW2|C\?{/"x% Nl~;30O;ӣK.z}N.:Rz&
RծsSti,"	"I
tPaA#T5$)Ia㣠5Q#BJPZwk^!X0 O84	T|lC&+ƞQISJ **VKy:!ƎW%(v	cGQ	~[H<[Ct![^Ctc&kP/1d+m$SSEH[FȎFm\]TKASBw7k
8q)D)ۅyfXbVZGeMÙA=.Kps?˦5ߌ<w]"3NhwʂEJT|I+& (!4nDPysZVӄ\YʩR>"l%PÝ oK$KlELV[J%vZU}b]6d[h"UT'	ݠ@R@
4!j91uawqhB`|aoV	Ah5(/` MC Jl`>0!(~~(
oȡlWQr4{UvF)j-LW_%ђHutx,a֎9lyWHo5:4z*R~|~3sxhK>wxh!d[0yP۬a"TKQ=E1HO&3)#p &+L	3`<2Ř? 쪔ĚHrSxDO<1VND	Wȍr!=_қ*6Yk`"ڋxV|t4>FlR(uB?'qm8{aYD@$+,&,Ty_9;}&ʀ^/ I804.Up:
.yIVjCvv5:,3|OY)FيCrN1$6j6IC! >ʆdzJ⽅d
#^"!$pO+dv`$r03o;pT'i #ߞIg/|-}
'~"4|+2pGRZ%lOuX)y-K^ZuYM(
֬@߼ŠTo<9Z֣]pPAq~_dd񯏗yaN0=,'^k^fXs"c]_hC|ނ^wys oa^hS1ywۼcqe9çTAN;4k?*cWU0
#
ٸTx!DΟ䑳|+"Š̜-bbѷ8Gnd1ˤ<׾U^&k.k1yݙ]=l׻E^Se]^׻͵{9ϐyDٜ&xY4_07
<d0h,!Yg]Hd$8ƨ~Xo(lĿ٫Dм-˜s&m΃<[fq5Ry
%oF)ao2}Vmc4J?L::ޭ0
H2M^SL-XXN
)r%Ϙ_By_~x\͆y[n6rH恗*2z[PBBW6umfHt5%:&E:K񖃵V|ǳWijlLnJ*V~_R=VfMzMt-m4wvd8mWE[BֳbʼkS;8i7CӒԯΩEk7Nix<ql^R-_w4#!f1Tو?f[^eG1^	||3z 6vU o뀷d10K?dItј)_>zN`_,wcNNLӑw*ڡYN8Ȍ$i:ф)S"PɂeFDDD҂6ϩ8*Ȕװ'|+oBs~J8?`\򛜹9Ƙ&?"yLv^YTR *fNs]FxGЁz
[O<O<ϊ>6ers8!O甉
+
Tױuʞ9PRiDPNDB -0eihSLׯ"@V|@zz`p+$K`F Qhn^a`fCv|ƑE:ŀ2#l(ﯔ~Sג32$Uy`s洕\ύ$5 :.H&0KCꐢ	f,xᔭ<^RS|h=? Ļ-Зi岼t8 d\ҘK4BF`<Rڃ\q7ˇ*I!)xGkDhQ%p` dA$
nr!UCNCw5a$YIH&JR )(/` _ 
)M Ia q='{14ޝ?>Ovk3|-fԜc~dƮ5$
dt;voVee-1t{A9v:b*.b4Zjr*xb
t׬c&a5%
iZt#DĹok npO T劢yYj5郟Ŕ,2R6
rTK"ٖ ҌG@V']xT;Zzw!.-I2!+P["!sn?5#"xgѻX~d! k8n uaIKےyQ1°7c7o%Eg΃Dk1WO'\Z3qZhײ|?HnkN^3	md'Re;Vj.؊䶈҈9n!Qr+OضF|&O2IJ-
	mSi_tW1EK<e\oѩj{H/z SAtQ{~Tj]nWKՃ/zBLĹHIH&+;BH^^TXG~^T Z`S|B_N%]A[bPSr-ME5*~^hz}ʂm`mI3v@d;"VY>ƣj6YH!a*YM|*W$˃ ~dǥ28n_;{uN7׎ZKZ:(#x'AQ6죥~Gd77| vn&9[A%Nm vnâUm85ԏuĴD4!ˣl	R!p"rht8QM)gKmeq5kAyue%K\+#mG6!-"g1vnXT+bUĭ*bd!sKeRSYpOdID>S̘l?MEvHH6p3hnUf*8s:EFEY~]:vBX{1TtY*p,C]s-ĂDbG(?^q˩e2ʺP'O8q&
X(Lk	pϙ껐-;opL>t=H0)nj	H?e=iC&0ʈg<fݚ/JTy,HRZF0ϵQXjL"2!2Ԓ.O-h"D^*fMOHkW1OG[;k)$Cm`md?(81/?)0!9gv@L0Қd1QDH3s̜LjD2!@1P?Aʊ/^q1I¤ĩ(QLiNƆ/]]S
<H4RgYB)J7Bk(As\D8&墋`2 hIokE^+1X.VkܔfcWKkbde)͚imLdHifX
1F5v)(cfoM+"ȎDtC>LΤVdtڐveVnh?]IYV0ͬhf2Ҩ"&jUD6nEb'[Io۞WK1Iw(vOt>
2s>4qwwKZA	j7<g*~Q,͜se.	nXy{ko~@'٨Hh
H:27ǤUx, m!+$pTbUb-S8t]9#+ZG(#r\E@9)~xaiw5nG\jsZC}mE9eE+j$X`)M (YG,E$hh(Tڰ\'
4h* YaST)zjf
E{&1#
3x'\)3ue6R{0rex
^2`a>PPNs*s(sSHk y\,n+_9ip&4
$Bc88m܂!6jqܛ#v]p\ 4|XXN*D뇕h%#	U%\w!6
 x5ꨗ8DW9
n;gQ
2AfCrn)RoUǂ4n(G\HB ꩣtwL  MU7 vӥ
h|@
! a/-|AcѸTh<q( sHV
_O}	g| 4o-Svg£oamyB۶oJt{{_~1x.$hN33g'QPhs48Nu9*'HrskEzRp}<[{e̤V;\QƣV;|5nŋ0}0f+^<QQP"*_ 1nIi5d^9NpǧIGN8N%, E& b(i ]u`I 1bLpPDjFf$I
[k Rn
X=9N5!yQ-7/.5!	hcV%b[$'sѧJŴ	v<QZ[YSb`
]a6^
תּ?Pp![/
;u(dƅ.}
{l~=ёD~?`dz@D
H;CBxo@lgmUR;`Clj>u#ax8s0cOy%Od""%%7CZ·_(b$ZG(/` S %I [i$f@O7t!fYg*(N!+EfK>_>܊#H#DbYB?3ųN0ZOYb!)-%s}t3l6de&u)5YRN>cEWckxzwGz];v/Ѻ׆{296˲뗯(<5r#Gcܩ"ӳ{ǲ"/(ԗBu,%B}{'xt.f%a,/jp/X[(ZyO8]jOZ@	:{_0_0B=%z 9Oqߞx?ǟxLUY6[JS}d{pJ04y՚V
N,㟶L^a`˘EKeYq"Nrh3XXφ+L*Ka4q"[,SolVMbcUtSƾaA2ٲiu*	+8!vU+t!9zf[{M&_=z;;
_Rk-3$*	((ƩuQbA:*e5Bȕ*FAzR%u5*+$
!{fQl6F׳z߹=O|]NR[@f>=yB{4Zu5{56@2@/	w$$-
 p !j&b# &jJ66Ckb)l_6Q;Ő_v`/'iTFq96cxЛ^| O<)S=jhb nl0
1	bK<qIbeMI\3OMiΔ4d@7zd'{Tx+PK8]^
QV/99;pw虫JAwqIElŤ\ǠlV7֣6g$$JU4#\qG*	6L'KnH'(Sr"vi
-	{HՔ+U
;kY"=a&,_:Jr@mitNEfm޽F̘ mYMJbikA@P2ixTkڨԐ?~9!>F:-6])]YAE;g̏IAxJT^utB4h#__l8HO>ţk6*$,5V 73!1܇A3bTV"pA
t2P:|t|g,/w7
_|68t,	}KF֢.b>dC<q;#mߦC|cd%-g\;0~k\/TYH+VS??#w=0^,*2Th+P!ԙ"HRFr&@, ;x_iR3y'ٝ@I24ꜣZdvY"낏`ka"BvfrgPl2"'d%gytz׋ |}\&tr/CHt4lɮwK>Vj=Z'Ŵr<w}BIx6]]qpfcIš{
F6/6R):3vr3_le%!bjVgض\Q6 ;%j<DǟƆ}h]mX%UD*h?Of<k;3_{EcꡲT[WWSVȸ԰̣6&

Lc#{U3#Yú9T:g*kECT44"rH/8))9EPeGРQ1Ú!ѵձ%ᑉhuPiޥg aЏʺZeH6%IFbaUiNAO;#MHWɅU7l
f)MF0G[fBHGLt1t,/WΏy]k^iy[=#D
<;?H*A6(cҥA8`8llFU+N+ o9]#Kn=T\<.F@)|U\dEQE8;lMt>oTK&izQ|V@!
'>_Hgn8q(?50RDZRDk-glsn{cq5q3BNE6Dņ7VvJ~kA$13S4ӶP"aj%'1G	HifC9}2pTth%ort<r\cu}ݿE]RCr㄁5[/R|(0Z%\ 
^pK2$hk701Fhm^vJo V.J![aCu`vsH83St#	PN}-FE]7}SGdIb23ה5"XcĪx_(/` }n 4E0orh}8[8Vr	{>
%C/
D
uCc)<Rq6[*ȤDBR/Pu[7㇎^W4xE62COW&$Ku*YDP&C^ÏM,*} =|9nV!J P"A˾GSZL-V,r/ H'\xFW=l`]/-J8f辄>g<*`રC+rYaÃc̸lWu⅜E7}S="Յpp54ʸ88u_'nNfW2|x6 bw^\̸9ngt5n.+}Y8ABA;iV݄=N~xv[q܍?4|N_ 9ùzň
1hTˉw/}[)ypo
0}nh,t#;N_X AEf"dI!ȅqz@JEzBz`uA'gw=4Xe<1!t^\shk4-*a2xZXYƆKD~hrNKZ
8*h=yJ
-A.4
.lǝ;/_f5KqFBG=fVzE5Dɏ>~i2#Uzi4cO92'Q4pP$V
rVdfYL5Bo {BppF-ZҌ$ĩ]\afJ<JSK:0kGwRt&`dGʻ<~@E:sF
Z|ݜa [
%_QRd*MEI%+υGh>>C$W+.|@%')C9gA#kaX.mY%;2b-+ZX+5F@u6rX
D)B@dDԷ[2YY-1,C0*@iF٧S.@TdKH6L5$ F?fӑ6LR,cɄtX~Bt[troA<77e9#r({zJ<4Ml~~haYF>wJK8Y,ly+)CTt"Bepȡ70wpg/'22[?2""/X^)',z򥠧QE/QP^Y*&I"YHY8z;L_;'}n"F,lL:A.~EQ9S
>S\9 Oeny휰υOVB;&`.-d*|J	ީ2%UX/}o4st~O).jޙqkR
*lXn"dImBxQ]0%o,
h-7ѽ|	;թ__,P>\^d>yq˩)\0NՈ0\}SE|ȯhC||""q8gv}ZlDĭ7Ѹ}JĥTkzw/2[Qqhl	iF
r(.odemn{_"F9b\"\``W]8<;)"e3U\i;EZ/NK3k/[APlTȌh_XxjbkU`cZX3>rAlNDFA7z2mEnU#?i4Lq:>4pƨ02ZhwٰzwqQ[߸0;]JTt0_è?z!?b	z>Aԉoa7575Zʃh
W|Pu,EV:T~7Qzvu0C==}
ۜ
Wҕ1o1(>VODIEA ?nah_+S@2)`-O:$3XѪ2J}Z(:ZЁH	8RR$hsXdqxCMy3Z1>K)eMy͙lo=h|Pl&d(Uaa!i HrzD*Igd@%C#NW`}Υd   )NgZ8ypR:diڄ4ICRS\
s*@
*PBLL~LuLD̘D0.----Xa)iC'J())PTR*~y߼WBM&FIXI$YHj&KǕb,+p\)ׂ?O=39yHjH`H[H&HP Ca
2
((8Q<sw刂#FEA-q*:88p9i8ÜVFu-1af(ɨHPOSyք6ۦlɴx6=kZ6?LG&s"8E(*PT(od5K߲YG'~G~')wv	'6'Ndq4o9zݮQ%{،[yB4!~gxp9GLaC%sJ:ۋ(k((dk棾 $8NW][<q#HB/9ï>詾]v\OLC|4vg=,WEkGG,QfWZeDփ88G/إJd-@3{.Rt=|y%Jު/H/߁d|cq؁Z1
ZW5r-q{]5@q!4/mZ*0p:^4O?]~. G	GO9ï /z^r[
>U,ƋݘnTUKUlj$<Il-禷VFޞ^_7.20|oz<mPB%gty\P]'4yo`S}E\7xBS} <x-\¬
5sQhflD}z<Ub{.Sp4t0>wh-6%e5
[PMqU.mE.S2`W{BTyMﴹF+&NV1
M#v:4M\x+Ap'ONy^|ؽcxM ,M(n:YA\XQ U[Uηo!ίW56>09 0@BXH(
t!}F-+b!S34B
	XdF yo͡Yx>ϸG涰 e+$RN
@Ƌ@t:%K.eF/
Qb0P_X)KԙT"z
'
(/` d z-FPJ%YTZ1ڂ;(A.X2<A Q0rskY  SxJRc"Z ~'Vs<wc`Ya>ZO>r`6|dIcoϊn*`MqpÛkEu ZJ-, _@lZ
eke׺rHkU~A݂gt]1(ݓ͠`	s9
[
n'5iShCi:4^,mmZP<ߠH^qrFi:F9[4p`Z"'HUʊ*8¾L(ՖiO动e)<mρ\`Ѱ},t9ßAyxE^iJ
@DN~w$`kEaz8k(ڿ}Fa=]SE=)E%C",ee":h}&(pcҵX< ַ5`xM6c`MM6[&L&ف^k
sF0MFOh`!<'MM=0bF88F}4jXb*XDQ9dc`ai2euoJ:Ocܧu)_ئ>%w_.Z!U|8[h3Jr@dKFЌ7`sgjO^ڊp%]MmN4lyxw雎5u:IF1#[ld4Y'YKl$۔/nnGǳipfcD=$¬E݊+3!˱ 5HWY%*IsLc
ygi@B^`r˼n]0k]Dx
bz}~)ܕQ	Kӛkɼ ӽ)FN3\=Kx6=?|1$LJB˩^[NIfQ"/7z@=kw
AWcF,{~SKMHf+vsW@ck֥GcoY& 8y*o
oGD^@R25Htѷq.oq9&[D9G TqY ߣ2x6A}k>FASTraC8K8M#Ek^Z	Dhn.=

k|aǡ¬^|/G2SUZ3W
ur{|/53s5aOZuQ=EX0צd&r0wt'00@ƀq1	n'N䉾O9Ss+xk%EaǄ(C˃@Ot
 2yV$YdG1ܘࢽߟ!i(8qD ^4s0&_*GB
 CgWLhY8a>aQc6^Ԯ,N)qfuvqpvCȶ*]yE4=SpR>l)u;q0RjQ4(0	\j~Y?,n([BPBWXWMup9!GzO{\$n긩rll9w94e:vvs;MO[_PC8|i"RԞ$増7h_(dN<D.8>cnuѵ~k@4@|[JdXMX5P.jT<_	b htq.G&W+蜶Z]geUV-XDG>\j>3N}'p@'nn1@osIB	ϣʌ5SHZCIuvtY䃲이Z1t+PǸ o bKda;U:E敬Zi9ܓ))2"gO-*	1iJ}҆wdٕ4
7nЈ) 1;;A<(a'f@F[p[nBw}0&FF_˗W	GQ)Z}
ppOEv(G*1+F\81 eK73:78b&|+{QbE#~Gu o=]f1Q|ÌԏG\8'SG5WUD_OoLUբhNx0~WPp,vc$J1>u|UO<%8\4U	vuSZўyI[ʳf4K}GU\oZ[Y!3/'<+`'g҄(r<T>Ĉ@}S*muma]G,iV!2H	I|MhRא0䐺ԭ+)S
*I<"䋉B}(DAkJ	C)Di.d-, mdZ1`7E¼´.ZDt4 0TD@ >Pu}Gʢ}H@[k`pEW>euvqqv]q(8F<s(C%l7Ap@dQ~ cf$9,
SބxUAV	'd2ψ]Hڂw=EVs?9UÆRƌss1"XWn*w6&ZyBYPG[gJ^(Sc/n6ED5	r%0(+?ʣ@FKaEk_.k/Dۘ N٦_1]> :$>nj?68xM0`KwŃ39ÒUMKrCYǶydd}8;GYk'H\u7=MNwzMA ]0D!Ĉ23x`"4
*H"*ÞX39m,gSPG*@Fq0d^:T*05޳tڣUǟp"PcGKdBP#'E''IU/$vVRԺsD`E'{607:+!i}y\T	
%SFŶtސzvPݍ3u*<]`^{2"
/(
0є(/` R z$J RI_DJP>ژhr6Z!ߨ7#w[ZTj}ߝqq,g*n/i&w
mXO*pP193XuX-G͇jiTMX%|Y$(-6R"mK@JL &AGWJcY; P䕒@vqߖ٦%Ws:5~NKgQ/l_Kiڙw	,:h$e_\e&w&sh"҅;3eh@meezNNW酅ҡ 
8zQ$|K@T晢a8%lZ@ʖqM\4dX/4eXZ\1pv)9Jw]marCU~CPRRYTޞ1jIV4ݦbtr4fSB(C',(1Ҥh;K*cb5^߁SCQUчV
4*vt/`vYnbس7څI*:3L
=tk'&fPspֳfV5?8ZpY:/PN@uʢpI/5
t5dl6lh3t+q*'%TLLoԱ`j۝ZL/M㼘CENMtLͶfpaH|IM׼7\!Z@JYoੂCZўDji:B
vzt+`QѢJ>д=o
-n}i[t!E%=CʰTopNuwܞr;NWbS5`Ϡ'u^ f6<`nM]TjVQ4`ұ3Ki.qء7=?9xX	J1nCP[B֏ojr%dA,Kt}PJRX{%ri>68e8Y#+VWvYX65P*+U`E=zgoe"p56£ff,
!:u7f4`]k4I=,Ncƨc}9]=QcEBtJ<}6tj
peB%̫)^-z6zuo)EZtβvg4Q 5t'DP@c-ta ܉
ʱh[[uڹMOA3cvGB
-+ɷ g/Osg)꤫a+薩$YWh^yXE=CBWT}\J>5Gb"TZ~b
,>Ɖ LJI _O3ddJXcTU=BIEcHT!)	UUMn?Q4G"LB8[x83qrW[Aq0,c'`5WPʥZPT
Z|_a+|x׵OPTF3O?tO|?d<bM	gq[31כ`j=^ewR*)j} D/Vz!j׽psׇy׷S+or&:믮Szy};Lq^=^:^tqso(]YHiᭀ6\5j{m-5[ZplH752*M6=u>j7++ILͽ3-
.qKCMO"h"F#Fc2\dlw s.^iotT	W#?}5
9+9did&mV_':
)q9F	&w*pa>c6pFga1\
_7~؍E8`{.qљh	wx3aa.p!a<Ą<Ȃla@Vhr*F:O"890|a?|_.(^ϟzuJz>tQ_TW0[~C-^-)]`(E@'C#Am4,6fc
+Wy\	m<@dHRծU
GuF}QP%Az>95{.c}5N\Z(^x zx@h( 6$ @O0WZ WqEq)ZuyJITݑ\:K@rTs$-=jrlQU>A3QiJcEK)L\
C}d(|Yٝ'Ӕe,-Γf'kadɈDQAt𢙙RҢ\@I #H|A8)=ԱVs< cx
L̄~^=nL?tڼ#\(l73''O97a>*qf@@#$1Η)D =YONph~iAwjm`{@r=	aӈ>IwiP5_789
UMhU|Q~PS:U;Qt̀UO#0+2'
(/` ]H 
DI RI?U:]g=$?b@"śL~[myKM\T_T"T%lRHٜ9݅˽ǝ*)Yvv,rniG{	?;	rSyNu::ԁӛt^4tt:ۛK1I%۶p2׺xtVHH/z_|~]|1<Hsu&As.1<i| ?>ߠi4R/|p(:s};\s+)t[gi.[g'4[*4Z5:L=Ky]C{ig.-CsڮzkzKki_v庅~~k~Lf.dzL;-s0
qhx	8|ɓUMtx]Ыc|ɗ||C"K/X,+ X@MP5A?X@>dg]RZJUڬ{I8XAAE۹rG=)ʛ|^ z_`便$ 3xK͸JSZJChc
BuX"M5!;lڲ.ނ,*
(
v`&x	V#.`!8`&</^0:t<rpnlHހpր3`0'`	8 C;pLS,Qd'fJ?F#6"&! ld@s0Ż8}<|=<^&l	фeB1/¸-\U²p,|z]V8$y;T.(
BvFST<NST7MUS15Lͫ]j]pUJFbIeRTU+>UQjTeJU_
~AP=Cp(;P0BP9FzFP2
FP%XANQ A%2襓~39Som暉fb旉7&݌nsmZUfO[s2LsǼ1\i4дg#:R#H6R<#02OvurN6&$EI'<"d@VRQI*I$Y$}2HVyEi=MAMJM}4L?|ע'>JBx&$vF{[y\ǧt=G?|=|A}ѿĐ|dBd۔ŇĝaXhYX@sLélWw9iK;NwE3,>A=A=A=e9vo0V


*gnݟh>0,f2'O^iI/TD=#&;ݷ=1_0_혯a2rr6^)#66\#k{85cx42;snkιzms\4s\{wnukʭr}rnݺC;+u];t}{D<bQGt#Ոg1b1O"։s"&h"1(&:GD-1K@!Z:D*1JdD$HAb/~aX=cp,ƚ;X0֋bX9f{fX2fX%XANYa%2
{aN8'MDDD$HARJ1)Ș Ģ2dDRl܌y	7kT.΄$vLxxrN9W,@3!8^5GF)3,QZb2|
4j.H:aT(Q
j=	gsh͏&ۻeaO.	j^j/X?#;303͟Ռ҄.#Ak]v5NF9dwY7:l# -YE-bee`
(D;0m\~GjýfV9"? lǰ>_HIf7bg8ulGw]Mٻ 똓ۇ
}WbYHecz.Yd~u3c}x9ˣnAܖA.AymG`-zǺ!ym? t|RǏCKo/⸮	(/>9`._|,(/` e3 _$EMcSTcCZdnvdpvq!Z䩖WQ.W&ٍB"8RJ)[!?(&%L"4{239w262̴oܚhךZKL
3ѼMms3w՞=SأTC9}ɛ#py@88ѣuw8}5|3<+Nwz73>mW;I=HWnE'/S 0j su3WSuzޭGRTKH**]eWUv]eW<փ!P#t	E@nΓH>%E*X(nΓjOVhT85gYS.5KR԰"ZʣW5FuQUU~PVL5BuPjjTjPUz+4tHhnXh6Ij@AqPmA}AhbNhJ-CM+#3HFd1yxȴ|nE?}_翜jO?0k(?_g_J}>Cl!1ŬS1!у:4MC-O#tiInIEzHiuw2L&e0y,kWX앃YHrVeyE$r!orS2 eY(䞜`88
g.80#B\?W8vUX
P	WL8vplpa|14wxnnXn6Ik@qq\mq}qnbNnK-C}cX5{fX2̂cVb,~Y/Be
+þ+%aCv`d5 9RX
K
w?jΟ7mfͯKX!ZZZX}g3W#}W>{>Hl6aκKM)a),y<.I3	Zk````.r\< WU9$m_/L/z<SofI	Ēf\`pתq85C
ㅱi0*h`ƞ1Xgi{>ͶewY-em%";m;Ǿ1bRÆOflMm컿7MC]h/zƢ(Nh#H>ȩ:ٟFgs#H@D"c,!ڤrS͖\?$h˸TNwZJ6o޹IWD/Cq#n >Kgp+a"8BMNݷ7ߛ'k5DrBo;w=_zWqr+t W,Ⱥp.(^xEw?,2IZ9ǖHJ"oG.X{4"/ ;q=Õ'}}Hj8+si-g~2]z&}ٓֲ >|ѿB OjMDU0uo
N3.F;:FT(/` 0 d<P*4
Qw~BO_C7h,pښzou-1U$'Qd[B jNMtLN-\[m[1oi{Blu,_p#YD=" ߓ֏~1,]Jm{%cƺ.`S&grئf}f)e.Vت:}ڶ,ӢFrD@c.Ѐq}|o'vGL&sβ)r
Nf[lF1q^j?\	a;maGN᥵pwUW9Yv,[!VENa?96YAvX  ;쥽Zi&֑#cj+K='q(j|-GFPoIu̟do,ݐSD#щDDZX	`
~UY^ͫwsULoխNPjZ=BjYQjڢկU?
BP!TzR6U uVIUD
QAC;ơm(-C.TB٨Fhڃ5]Ah	Et"Ţ(=@h*ih.'	8枹7L:nf7L,mM&$2ǜ1_Lyb\0+̬yi+ܿlCIt6t;RkO6ǵ"Zf]fq<N	5&9u
Z@g8f̂.e,:Y5 csl%kZeT{`JF	
x{t{f.6
m*7#lr6
;aP9W2|AGdڭؽU.WSgw81ǽe,6Ld 3~'1p6^i^2.sJo,xr,x$3E ]KBrVηy]w3o}11nq_{
SnԆSNLu/	??߯wݟpOi/djYd:=dM?Y'Gl]:~cg6~Y)Qvl}7|ґtsIGލSqw.kl;mx]⮓o\먋]xa3s"NI!Y(D$I J r""AH$1ps1l_tp$
ܷJM𒭑3k!;k֧:r򜾀JR\I޼kA	<'CIwmЍ\[oo
x^KC# oxKݛ,Ҷ?V׿ۺp+Dg~{_qqKϜHVV=;Ӈٖoܛ@ʂܲyvypmRzBV*o⧶*5ZlWy$"N7CG$EsL1'* q*|Dr%##_(/` }# ? w5*eFmj݆nиKNB쯶T.$Qތ   #I}i1qșwȫW$08|;r^У9EeQE!<>6^@BԔ65U\UA6P	T v PӅBcRh(4RBځ/*EETq`CFsG{62P6^ݰ[*ԝ;&lr;үQ<Ifݽlݛݬoޯe>}ZQ/٣{3EQfحմj%f~ώ={kCsΰ_Zv1~Q6 Oco11'oƥKlruUF]d#j++r5HҭmIŎJL;Mا_n(ԧ;S5N3"SӜߜ-~?;1;Yiq6v;
r]3
8 cgJTґAآ-W#[+nufjoSDINWnͺUo~YzG ";" HU^IZk5<sK1asƜ:aLr1CfDDDA$p"CBT&!H$Ĉ""d!\^!WP#e)^6?J'BbV|/ʣgxrY/&`xqQ&fhG?_G׳<BifWf+MBB vv"NBID{@7Vz/ܴp'[c2-ntYX~Pr%YܓXSzF[AguUtO.Ah==5 j!|x50.`c]Y|ʞPEw?RÈ0s(ߓU_jL-MNw0\NYƄq:ji=,PP?mO(ryXF8w<]M0x97
Ŷ!rv{qMQ79ZGcr9,jɒnM HjdˡO~Qpeg	$(/` ! Fw@j]}]^'	@A P   (
Ah|*6fAۑ}   *\odEH.]3EyE=LL֬4 Mkך:vԯQ߮9SQ{׮[{֫qZsS5kߧQkj75QTL3ݪޙ]1/.
swʪYVY=& 55Yf֩?<	d Q  7j79cgSf2rÖA("(⦚DȺɦ=4gѢIMt2{%LrC2
laLzī[,9t&&f*ڀrѴҭa{-^h9eny{fܩiPV\u̥u&HQ~􇝖3윿s~.wl)z<8î l*(O챛@.2љޛɥaWtPݧOVwTG64K87 mXg@)Ʊ[r_L֛/8ƺj5c(n.KۨA)C̈$)1)@2""H""2""&-ky	_6oeݫݗ4%EpH*7}ioYI.e`Zibr:{5If{4ΘHēe0{/GٖوVneh<l{X5-G,K9AŊx`Y{L/nICpO<Q}_n;Y^nRzvemq烹T͓#0ZQI5!+6mHSdϖVT]
gկxR2>,\[vE5C615[(g?zhiq\e%9qke7yu#Jmf<-M 񘛎3.#YTtvw}Uݻǖӏj?HЄ.`>3.@=1oD_ﯚvAk7O((/`  ƨp=04D\]6ҋ;.v,-=cwlZ_x`07xfW]V(\ ] a \\{bXNfKL:tE66fbV$ߨATMQۨ7,yVc	Уi0Hl
¢66sJG8ڴ<_KeYf+MtͥlaKtȉ'$PE$@QL ?^jkt7jr946alKmKl[,l`atv6ڦO{wk8{ŗ=kls{{-wՍf)Xf/CyģMLbf>ޖ SPAOɈ:^.4AH@G+;vY[𺪏,1fÃԛ+m9P<!uە-¨q9C##"#It t-FR 1(@D"	$&i=.ԕE*O𪺧ҨǮGG[
X]-p
dYG`~/9H講|. |HU͜  @5O#X
ĮL`$ƅص$	 MJ!UaJ͵4Ǭ@V 3xXB}KHFVdaE}Ѭ&(T0L"6k&~N,\i⁤19]ir

VʧS3~
zޜ6'=QG\Qkwuؓ2+Lc=#lL3I~|B)ky||rhE!w08u(/` = g?0m1L&Kxkۈ[ֱ~䱭~徂dB@dgtK_6QR V Y mc=i[g6.wkoC&mtkYpԭ[귈[=xc퐻ӬurxKn;>NqYyƖr[ZasvZF#ϰzē{9+4`%_]vXխU=Y-nvR 4OZkU{Vnۗ
y^*g o,zcCtָ[{$s=qhͧ3ޫee4zt{q$zqΘR􄳖xÛ?S8A1cƬE;g9͘e/qa̕bhEgR6)%\ll*)])Ө-D%2"Is))I
e"D!D@BdD"	$t"s/\CR[6Y`Q3oAp҄*]jpeZkKʪ0TӦdhqr~
lnG8ko
98yź(q3}N}JbAWg鏴oDŪZpܐs/x] R:a@.p.lLf 9^.xp8݌w*uY:$zi˰"D|􍩇<8=g|;,Ju7ޗS{M6
NyֳDx]7QS7(EMj늜Ir3=h!w3{M-'blZS"!oT-8E3J-8rMϑ*bGy-
 =ZWxVL=(y.px (/`  &lzB 8cBF8֕OڷT7_aOn7@q4##z;LM'
BuRd j i XPfPT,5͢sgǱzآmXt֬ޮ7nݽ=;kjY.''VZ%ךwn[h{sj%P6-a\aP+ExޢE7Ѣ-}y|~)Z[HyeԬIn	zu-sxkQܮ[_+֚'ھX_ໞKshdꩧv̱\ʩS_=:44t7w{rm89AA1r=1waqqpsqvM2h!TkqvӉ9yroAl3ͭfjw*Psɥ[9-wl]>-^X{Nrwɩi'ޞεjnn	LyӫOQa_⨑-45#"I5TA8c"""h
 TĤ#+~/R썉*^tv	ο1JY{C]̾t~x\dYx;)6] Ivr{gA)|XYߩa?oejN:#ֆK-]\ÔHGq'ЋT2iMLb6I!y94<D+[Fqd=nTN:-t$?L<pG%´IϜ&8fCu.K
USFo*,iC#v_H-_#O1M|VǝG*nx<tLmYMGta= ͞Wsv_md/V}Y`d'?k~<Cn|BA,:+w(/`  V<@ٶ8B[̲~(Q@hc2'˾CsV׆~9A F E BaRǟIK[Ӿ-FXrabvkڕ⃥CVMjlΕ+2e%4ͥM.9¢76c2vVؙ j٤K."&y}ld7MA<᷶vhn#g_8d5{[nl/^,xqon(g펛IĈ5PX めnk<`1bx!+T)O[S5(MސXغgkk8;{ejFDЂ #%1 F)CA#04ȄѴ`ۮs3M|ʟֻ׭5#
/`W=n[MD45>v5l_YDdǦH4uR8؉cr.`*
z
1eBHH1@ߐ?9د_QI}%IO%j\/\q"Y-roY=QYWvFX*wƗh@vKV`*Jgl_5%QoYWzPG
h5=ԝN$+Jbԑ[y$sCif0OCr0ؒ-+ʂ"
(/` # 8D6㭅kb˄xv`zSást%1[^	*βEKR   $JJ'+U"{K{vvPY1-gWa*Ʀ*~56Oդ*mR0KF<rcX"`:,>V5I}/~bJc:UQ}=-)m]3Ȏ=ks׭AA#YֱQ+[?$f6&ZV;+c:Ӣj3ZK<z6gVuXUP\U'JWb,56LtT
6Xbv-gq.ALf.@X½'Y#o9sls60w>hK;޲c_6owoӽs77e]X|I~?osw>o"YN7
/ݻ7o޻޽ν|[qLUl03s<lO
+0ҭimu'=t &ZF0?`>;XIelx?Nqܸ=cg<2J620,FlϿ6|iv pO:\4ѯ]bݺA)sdD$IJ)n9"cȄ""" Clp0QB[$#BFgl(j3زY*xĤ֥nLXwM47Oo䛱0-VVR<4bӋ7ϕx2)HrB+:
bl}߈Q/Ԕ,l?şaOQ1ԓKTN7џ j˱e)ZFa;n77s^+@#$+کd?ORҽVP?AԮ+<t+trlEju+mTɢ?62~\Ty͚* [|)e,@i/R;)\IL8h
X#yLH	(/` 50 ZRP@p0[5?0`?vu (QE\7\|YS
:
y'ϧffFږ2   Ϙ\1>|n].1lX([m,P=Q74L֯Wb8*nql0;]5asi{wX돰oK'ډ6`uY\OxJp_75S׺_pR.G5v<[WܽMs+{KMbO5	>(31h9QWc9Ӗ7W.zm6Z
I"-ɽ
4m0Lix&XLӳwZ@8P8JޥS.UOyxh1ǐ"BKhVоYFZfl"mJ"Y${H
DѶstl-l[UZijKFJQ[PWT-5Kt~Wi?яf\/OPNq7r2l`slD4u
i8QL.D}|,x ncM:3uZvSި4QMIԧ匼!4߃R~ikST^B12M[e6]+2F
"RM5~-Vj16
dv{,]Fu6f:ͰNvZ5
^lEɆl&7Qcr,T`*N- 6=c%a6ɚɽ1?	fQ$+V0V039M.oJMb-8,&Ei8/!>*DuZZu[R|%a\og/A3_m>|ߙoblL.54CdB,m|ie~g^ۯF{
C:ġYTqhddIT:*Tϒ(DDD$ IAIST/׮k|nLxa(Q[}!F&?nZ1%THy+.ƑnkmڒMr_67;Áǟ'o>;
tlf1" AǸw}x۲\Yew
v~xc;j&xq0zؤeuAN_OOu;ߏO1Cçs,z>V:i&9M?{8a-mz2m8m&ؚg'D07T vzㇿ''VUݺ)휢,-1oRHni?M-ɏgIW)X 1UPH`]nйp`cV9`ADktl1E:~_/C<yGK6%x${0ꅦ0JU֬co>N C(/`} ƖK@ qtVUUUk]ɥI/,Ũ(=U9,
4=R} Ga	r[9 7 8 P 99 E
R
rubh.+޿{]Kp9tx/m&+,qb(ÉNܜBN`:tD҉
Ndpbv9'r:dh]QvvuH3<fi(TlSۗƢm
Nx)ShiXX_2Z>.	>Z p;V$.`cI1_~h>5- :YX8j@(;\V;+wauߞ5ѻp/AX8e63	 	a0߅-fKh-7"/)3RSCC[remap]

importer="font_data_dynamic"
type="FontFile"
uid="uid://btie43xaarp8c"
path="res://.godot/imported/Marianne-Regular.otf-4733b69df74be89ffc504d817ffaecce.fontdata"
 &.[gd_scene load_steps=54 format=3 uid="uid://cn2b7oqcfu71q"]

[ext_resource type="Script" path="res://HelpMenu.gd" id="1_uogj1"]
[ext_resource type="FontFile" uid="uid://btie43xaarp8c" path="res://Marianne-Regular.otf" id="2_fut8e"]
[ext_resource type="Script" path="res://CollectionBar.gd" id="3_ny124"]
[ext_resource type="PackedScene" uid="uid://df7jiecrlx6mi" path="res://Player.tscn" id="4_ic2jx"]
[ext_resource type="Script" path="res://Generator.gd" id="5_o8vke"]
[ext_resource type="ArrayMesh" uid="uid://bmqjucdpdkxga" path="res://tesseract.obj" id="6_33qta"]
[ext_resource type="Shader" uid="uid://bk2kpnx25vkq" path="res://tesseract.tres" id="7_n7c2o"]
[ext_resource type="Script" path="res://MusicPlayer.gd" id="8_6b1fc"]
[ext_resource type="Script" path="res://BottomInfo.gd" id="9_0w7pm"]
[ext_resource type="Script" path="res://ProgressIndicator.gd" id="10_px0lm"]
[ext_resource type="Shader" uid="uid://ch2grb3vopkuh" path="res://ValueCurve.tres" id="11_oat7l"]
[ext_resource type="Script" path="res://AlbumArt.gd" id="11_xl35m"]
[ext_resource type="Script" path="res://ValuesCurve.gd" id="12_yc6s8"]
[ext_resource type="Script" path="res://Path.gd" id="13_ocln8"]
[ext_resource type="Material" uid="uid://dcfrgxqj3bw2x" path="res://invert_tess2.tres" id="14_35ful"]

[sub_resource type="Theme" id="Theme_3ov1u"]

[sub_resource type="LabelSettings" id="LabelSettings_wskrq"]
font = ExtResource("2_fut8e")
font_size = 32

[sub_resource type="CanvasTexture" id="CanvasTexture_hcybg"]

[sub_resource type="RectangleShape2D" id="RectangleShape2D_fb4kt"]
size = Vector2(150, 50)

[sub_resource type="ImageTexture" id="ImageTexture_6o13l"]

[sub_resource type="LabelSettings" id="LabelSettings_2xqox"]
font = ExtResource("2_fut8e")

[sub_resource type="Environment" id="Environment_dojxv"]
ambient_light_color = Color(0.901961, 0.901961, 0.901961, 1)
ambient_light_energy = 0.0

[sub_resource type="ShaderMaterial" id="ShaderMaterial_i0scd"]
render_priority = 0
shader = ExtResource("7_n7c2o")
shader_parameter/audio = Vector4(0.1, 0.1, 0.1, 0.1)

[sub_resource type="BoxMesh" id="BoxMesh_tuyow"]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_wyef1"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(400, 400, 400)]
operator = 2

[sub_resource type="VisualShaderNodeVectorDecompose" id="VisualShaderNodeVectorDecompose_ke8uq"]
default_input_values = [0, Quaternion(0, 0, 0, 0)]
op_type = 2

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_wly56"]
default_input_values = [0, 0.2, 1, 1.0, 2, 0.0]

[sub_resource type="VisualShaderNodeVec4Parameter" id="VisualShaderNodeVec4Parameter_uq5fj"]
parameter_name = "audio"
default_value_enabled = true
default_value = Vector4(0.1, 0.1, 0.1, 0.1)

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_dw6dp"]
input_name = "vertex"

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_nkr04"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(11, 11, 11)]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_iskvi"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(22, 22, 22)]
operator = 3

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_7il6g"]
input_name = "inv_view_matrix"

[sub_resource type="VisualShaderNodeTransformVecMult" id="VisualShaderNodeTransformVecMult_khdse"]

[sub_resource type="VisualShader" id="VisualShader_8dfjw"]
resource_name = "BG"
code = "shader_type spatial;
render_mode blend_mix, depth_draw_opaque, cull_front, diffuse_lambert, specular_disabled, unshaded, world_vertex_coords;

uniform vec4 audio = vec4(0.100000, 0.100000, 0.100000, 0.100000);



void fragment() {
// Input:8
	mat4 n_out8p0 = INV_VIEW_MATRIX;


// Input:3
	vec3 n_out3p0 = VERTEX;


// TransformVectorMult:9
	vec3 n_out9p0 = (n_out8p0 * vec4(n_out3p0, 1.0)).xyz;


// VectorOp:5
	vec3 n_in5p1 = vec3(11.00000, 11.00000, 11.00000);
	vec3 n_out5p0 = n_out9p0 + n_in5p1;


// VectorOp:6
	vec3 n_in6p1 = vec3(22.00000, 22.00000, 22.00000);
	vec3 n_out6p0 = n_out5p0 / n_in6p1;


// Vector4Parameter:18
	vec4 n_out18p0 = audio;


// VectorDecompose:12
	float n_out12p0 = n_out18p0.x;
	float n_out12p1 = n_out18p0.y;
	float n_out12p2 = n_out18p0.z;
	float n_out12p3 = n_out18p0.w;


// VectorCompose:16
	vec3 n_out16p0 = vec3(n_out12p3, n_out12p3, n_out12p3);


// VectorOp:11
	vec3 n_out11p0 = n_out6p0 * n_out16p0;


// Output:0
	ALBEDO = n_out11p0;


}
"
modes/cull = 1
modes/specular = 2
flags/unshaded = true
flags/world_vertex_coords = true
nodes/fragment/0/position = Vector2(560, 140)
nodes/fragment/3/node = SubResource("VisualShaderNodeInput_dw6dp")
nodes/fragment/3/position = Vector2(-1240, 380)
nodes/fragment/5/node = SubResource("VisualShaderNodeVectorOp_nkr04")
nodes/fragment/5/position = Vector2(-560, 240)
nodes/fragment/6/node = SubResource("VisualShaderNodeVectorOp_iskvi")
nodes/fragment/6/position = Vector2(-360, 200)
nodes/fragment/8/node = SubResource("VisualShaderNodeInput_7il6g")
nodes/fragment/8/position = Vector2(-1180, 260)
nodes/fragment/9/node = SubResource("VisualShaderNodeTransformVecMult_khdse")
nodes/fragment/9/position = Vector2(-820, 120)
nodes/fragment/11/node = SubResource("VisualShaderNodeVectorOp_wyef1")
nodes/fragment/11/position = Vector2(60, 460)
nodes/fragment/12/node = SubResource("VisualShaderNodeVectorDecompose_ke8uq")
nodes/fragment/12/position = Vector2(-560, 460)
nodes/fragment/16/node = SubResource("VisualShaderNodeVectorCompose_wly56")
nodes/fragment/16/position = Vector2(-200, 560)
nodes/fragment/18/node = SubResource("VisualShaderNodeVec4Parameter_uq5fj")
nodes/fragment/18/position = Vector2(-900, 500)
nodes/fragment/connections = PackedInt32Array(5, 0, 6, 0, 8, 0, 9, 0, 9, 0, 5, 0, 3, 0, 9, 1, 6, 0, 11, 0, 11, 0, 0, 0, 18, 0, 12, 0, 12, 3, 16, 0, 12, 3, 16, 1, 12, 3, 16, 2, 16, 0, 11, 1)

[sub_resource type="ShaderMaterial" id="ShaderMaterial_vtmak"]
resource_name = "BGShader"
render_priority = 0
shader = SubResource("VisualShader_8dfjw")
shader_parameter/audio = Vector4(0.1, 0.1, 0.1, 0.1)

[sub_resource type="StandardMaterial3D" id="StandardMaterial3D_rwwwj"]
transparency = 1
albedo_color = Color(0, 0, 0, 1)
metallic_specular = 0.0
emission_enabled = true
point_size = 128.0

[sub_resource type="QuadMesh" id="QuadMesh_afvs5"]
material = SubResource("StandardMaterial3D_rwwwj")
size = Vector2(0.9, 0.9)

[sub_resource type="QuadMesh" id="QuadMesh_br0di"]
size = Vector2(0.5, 1)

[sub_resource type="ConcavePolygonShape3D" id="ConcavePolygonShape3D_36kna"]
data = PackedVector3Array(0.25, -0.5, 0, -0.25, -0.5, 0, 0.25, 0.5, 0, -0.25, -0.5, 0, -0.25, 0.5, 0, 0.25, 0.5, 0)

[sub_resource type="ConcavePolygonShape3D" id="ConcavePolygonShape3D_yfgns"]
data = PackedVector3Array(0.25, -0.5, 0, -0.25, -0.5, 0, 0.25, 0.5, 0, -0.25, -0.5, 0, -0.25, 0.5, 0, 0.25, 0.5, 0)

[sub_resource type="ConcavePolygonShape3D" id="ConcavePolygonShape3D_o8nne"]
data = PackedVector3Array(0.25, -0.5, 0, -0.25, -0.5, 0, 0.25, 0.5, 0, -0.25, -0.5, 0, -0.25, 0.5, 0, 0.25, 0.5, 0)

[sub_resource type="ConcavePolygonShape3D" id="ConcavePolygonShape3D_1l8w3"]
data = PackedVector3Array(0.25, -0.5, 0, -0.25, -0.5, 0, 0.25, 0.5, 0, -0.25, -0.5, 0, -0.25, 0.5, 0, 0.25, 0.5, 0)

[sub_resource type="ConcavePolygonShape3D" id="ConcavePolygonShape3D_ts2fw"]
data = PackedVector3Array(0.25, -0.5, 0, -0.25, -0.5, 0, 0.25, 0.5, 0, -0.25, -0.5, 0, -0.25, 0.5, 0, 0.25, 0.5, 0)

[sub_resource type="ConcavePolygonShape3D" id="ConcavePolygonShape3D_iwmgl"]
data = PackedVector3Array(0.25, -0.5, 0, -0.25, -0.5, 0, 0.25, 0.5, 0, -0.25, -0.5, 0, -0.25, 0.5, 0, 0.25, 0.5, 0)

[sub_resource type="FontFile" id="FontFile_gvjk8"]
face_index = null
embolden = null
transform = null
cache/0/64/0/ascent = 0.0
cache/0/64/0/descent = 0.0
cache/0/64/0/underline_position = 0.0
cache/0/64/0/underline_thickness = 0.0
cache/0/64/0/scale = 1.0
cache/0/64/0/kerning_overrides/64/0 = Vector2(0, 0)
cache/0/64/0/kerning_overrides/16/0 = Vector2(0, 0)
cache/0/16/0/ascent = 0.0
cache/0/16/0/descent = 0.0
cache/0/16/0/underline_position = 0.0
cache/0/16/0/underline_thickness = 0.0
cache/0/16/0/scale = 1.0
cache/0/16/0/kerning_overrides/64/0 = Vector2(0, 0)
cache/0/16/0/kerning_overrides/16/0 = Vector2(0, 0)

[sub_resource type="AudioStreamWAV" id="AudioStreamWAV_f0d8j"]
format = 1
stereo = true

[sub_resource type="LabelSettings" id="LabelSettings_1wokp"]
font_size = 24

[sub_resource type="CanvasItemMaterial" id="CanvasItemMaterial_yi7rn"]

[sub_resource type="Curve" id="Curve_g4b0i"]

[sub_resource type="ShaderMaterial" id="ShaderMaterial_wef7w"]
shader = ExtResource("11_oat7l")

[sub_resource type="RibbonTrailMesh" id="RibbonTrailMesh_6slm7"]
material = SubResource("ShaderMaterial_wef7w")
size = 256.0
sections = 114
section_length = 15.7
section_segments = 2
curve = SubResource("Curve_g4b0i")

[sub_resource type="Curve3D" id="Curve3D_q7xac"]

[sub_resource type="CylinderMesh" id="CylinderMesh_faqaq"]

[node name="Node3D" type="Node3D"]

[node name="DatasetControls" type="Control" parent="."]
layout_mode = 3
anchors_preset = 15
anchor_right = 1.0
anchor_bottom = 1.0
grow_horizontal = 2
grow_vertical = 2
mouse_filter = 1

[node name="DatasetList" type="ItemList" parent="DatasetControls"]
custom_minimum_size = Vector2(400, 200)
layout_mode = 1
anchors_preset = 8
anchor_left = 0.5
anchor_top = 0.5
anchor_right = 0.5
anchor_bottom = 0.5
offset_left = -200.0
offset_top = -150.0
offset_right = 200.0
offset_bottom = 150.0
grow_horizontal = 2
grow_vertical = 2
theme = SubResource("Theme_3ov1u")
theme_override_font_sizes/font_size = 28

[node name="HelpMenu" type="Control" parent="."]
visible = false
layout_mode = 3
anchors_preset = 8
anchor_left = 0.5
anchor_top = 0.5
anchor_right = 0.5
anchor_bottom = 0.5
offset_left = -179.0
offset_top = -183.0
offset_right = 301.0
offset_bottom = 297.0
grow_horizontal = 2
grow_vertical = 2
mouse_filter = 2
script = ExtResource("1_uogj1")

[node name="ColorRect" type="ColorRect" parent="HelpMenu"]
layout_mode = 1
anchors_preset = -1
anchor_left = 0.5
anchor_top = 0.5
anchor_right = 0.5
anchor_bottom = 0.5
offset_left = -316.32
offset_top = -303.36
offset_right = 195.68
offset_bottom = 208.64
grow_horizontal = 2
grow_vertical = 2
color = Color(0.0431373, 0.0431373, 0.0431373, 0.623529)

[node name="RichTextLabel" type="RichTextLabel" parent="HelpMenu/ColorRect"]
custom_minimum_size = Vector2(512, 512)
layout_mode = 1
anchors_preset = 8
anchor_left = 0.5
anchor_top = 0.5
anchor_right = 0.5
anchor_bottom = 0.5
offset_left = -241.0
offset_top = -233.0
offset_right = 271.0
offset_bottom = 279.0
grow_horizontal = 2
grow_vertical = 2
text = "GOAL

Move around and explore this music collection. Songs are analyzed into 520 different categories, 3 of which are plotted on the X, Y, and Z axes. Point at an album and press [space] to play. Press H to toggle this menu.

CONTROLS

WASD: movement
U/J: +/- X axis (red)
I/K: +/- Y axis (green)
O/L : +/- Z axis (blue)
9/0: +/- album size
[space] - play selected song
1/2/3: switch segmented song analysis axis
F: fullscreen
H: help menu

Made by Tristan C
v0.6.alpha0
"
scroll_active = false

[node name="UserControls" type="Control" parent="."]
layout_mode = 3
anchors_preset = 0
offset_right = 720.0
offset_bottom = 200.0
size_flags_horizontal = 3
mouse_filter = 1

[node name="Info" type="Label" parent="UserControls"]
visibility_layer = 2
custom_minimum_size = Vector2(300, 200)
layout_mode = 1
offset_top = 32.0
offset_right = 300.0
offset_bottom = 232.0
mouse_filter = 1
label_settings = SubResource("LabelSettings_wskrq")
vertical_alignment = 2

[node name="PanelContainer" type="PanelContainer" parent="UserControls/Info"]
visible = false
visibility_layer = 2
layout_mode = 1
anchors_preset = 15
anchor_right = 1.0
anchor_bottom = 1.0
grow_horizontal = 2
grow_vertical = 2
mouse_filter = 1

[node name="GridContainer" type="GridContainer" parent="UserControls/Info/PanelContainer"]
layout_mode = 2
mouse_filter = 0
columns = 2

[node name="DecX" type="TouchScreenButton" parent="UserControls/Info/PanelContainer/GridContainer"]
top_level = true
position = Vector2(75, 75)
texture_normal = SubResource("CanvasTexture_hcybg")
shape = SubResource("RectangleShape2D_fb4kt")
shape_centered = false
action = "dec_x"

[node name="IncX" type="TouchScreenButton" parent="UserControls/Info/PanelContainer/GridContainer"]
top_level = true
position = Vector2(225, 75)
shape = SubResource("RectangleShape2D_fb4kt")
shape_centered = false
action = "inc_x"

[node name="DecY" type="TouchScreenButton" parent="UserControls/Info/PanelContainer/GridContainer"]
top_level = true
position = Vector2(75, 125)
shape = SubResource("RectangleShape2D_fb4kt")
shape_centered = false
action = "dec_y"

[node name="IncY" type="TouchScreenButton" parent="UserControls/Info/PanelContainer/GridContainer"]
top_level = true
position = Vector2(225, 125)
shape = SubResource("RectangleShape2D_fb4kt")
shape_centered = false
action = "inc_y"

[node name="DecZ" type="TouchScreenButton" parent="UserControls/Info/PanelContainer/GridContainer"]
top_level = true
position = Vector2(75, 175)
shape = SubResource("RectangleShape2D_fb4kt")
shape_centered = false
action = "dec_z"

[node name="IncZ" type="TouchScreenButton" parent="UserControls/Info/PanelContainer/GridContainer"]
top_level = true
position = Vector2(225, 175)
shape = SubResource("RectangleShape2D_fb4kt")
shape_centered = false
action = "inc_z"

[node name="CollectionBar" type="Sprite2D" parent="UserControls"]
top_level = true
texture = SubResource("ImageTexture_6o13l")
centered = false
region_enabled = true
region_rect = Rect2(0, 0, 724, 32)
script = ExtResource("3_ny124")

[node name="Status" type="Label" parent="UserControls"]
layout_mode = 1
anchors_preset = 5
anchor_left = 0.5
anchor_right = 0.5
offset_left = -33.0
offset_right = 33.0
offset_bottom = 44.0
grow_horizontal = 2
label_settings = SubResource("LabelSettings_2xqox")

[node name="Player" parent="." instance=ExtResource("4_ic2jx")]
transform = Transform3D(1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 6)

[node name="Generator" type="Node3D" parent="."]
transform = Transform3D(1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0.321514)
script = ExtResource("5_o8vke")

[node name="HTTPRequest" type="HTTPRequest" parent="Generator"]

[node name="HTTPRequest2" type="HTTPRequest" parent="Generator"]

[node name="HTTPRequest3" type="HTTPRequest" parent="Generator"]

[node name="WorldEnvironment" type="WorldEnvironment" parent="."]
environment = SubResource("Environment_dojxv")

[node name="Tesseract" type="MeshInstance3D" parent="."]
transform = Transform3D(21, 0, 0, 0, 21, 0, 0, 0, 21, 0, 0, 0)
cast_shadow = 0
mesh = ExtResource("6_33qta")
surface_material_override/0 = SubResource("ShaderMaterial_i0scd")

[node name="Walls" type="MeshInstance3D" parent="."]
transform = Transform3D(22, 0, 0, 0, 22, 0, 0, 0, 22, 0, 0, 0)
mesh = SubResource("BoxMesh_tuyow")
surface_material_override/0 = SubResource("ShaderMaterial_vtmak")

[node name="LargeAlbumArt" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(-4.37114e-08, 0, -1, 0, 1, 0, 1, 0, -4.37114e-08, 0.498255, 0, 0)
mesh = SubResource("QuadMesh_afvs5")

[node name="LargeLyrics" type="Label3D" parent="Walls"]
transform = Transform3D(-1, 0, -8.74228e-08, 0, 1, 0, 8.74228e-08, 0, -1, 0, 0, 0.498)
pixel_size = 0.0002
font = ExtResource("2_fut8e")
outline_size = 0
horizontal_alignment = 0

[node name="_IncX" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(1, 0, 0, 0, 1, 0, 0, 0, 1, 0.25, 0, -0.498)
layers = 2
transparency = 1.0
cast_shadow = 0
gi_mode = 0
mesh = SubResource("QuadMesh_br0di")

[node name="StaticBody3D" type="StaticBody3D" parent="Walls/_IncX"]

[node name="CollisionShape3D" type="CollisionShape3D" parent="Walls/_IncX/StaticBody3D"]
shape = SubResource("ConcavePolygonShape3D_36kna")

[node name="_DecX" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(1, 0, 0, 0, 1, 0, 0, 0, 1, -0.25, 0, -0.498)
layers = 2
transparency = 1.0
cast_shadow = 0
gi_mode = 0
mesh = SubResource("QuadMesh_br0di")

[node name="StaticBody3D" type="StaticBody3D" parent="Walls/_DecX"]

[node name="CollisionShape3D" type="CollisionShape3D" parent="Walls/_DecX/StaticBody3D"]
shape = SubResource("ConcavePolygonShape3D_yfgns")

[node name="_IncY" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(1.91069e-15, -4.37114e-08, 1, -1, -4.37114e-08, 0, 4.37114e-08, -1, -4.37114e-08, -0.498, 0.25, 0)
layers = 2
transparency = 1.0
cast_shadow = 0
gi_mode = 0
mesh = SubResource("QuadMesh_br0di")

[node name="StaticBody3D" type="StaticBody3D" parent="Walls/_IncY"]

[node name="CollisionShape3D" type="CollisionShape3D" parent="Walls/_IncY/StaticBody3D"]
shape = SubResource("ConcavePolygonShape3D_o8nne")

[node name="_DecY" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(1.91069e-15, -4.37114e-08, 1, -1, -4.37114e-08, 0, 4.37114e-08, -1, -4.37114e-08, -0.498, -0.25, 0)
layers = 2
transparency = 1.0
cast_shadow = 0
gi_mode = 0
mesh = SubResource("QuadMesh_br0di")

[node name="StaticBody3D" type="StaticBody3D" parent="Walls/_DecY"]

[node name="CollisionShape3D" type="CollisionShape3D" parent="Walls/_DecY/StaticBody3D"]
shape = SubResource("ConcavePolygonShape3D_1l8w3")

[node name="_IncZ" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(-4.37114e-08, -1, -4.37114e-08, 0, -4.37114e-08, 1, -1, 4.37114e-08, 1.91069e-15, 0, -0.498, 0.25)
layers = 2
transparency = 1.0
cast_shadow = 0
gi_mode = 0
mesh = SubResource("QuadMesh_br0di")

[node name="StaticBody3D" type="StaticBody3D" parent="Walls/_IncZ"]

[node name="CollisionShape3D" type="CollisionShape3D" parent="Walls/_IncZ/StaticBody3D"]
shape = SubResource("ConcavePolygonShape3D_ts2fw")

[node name="_DecZ" type="MeshInstance3D" parent="Walls"]
transform = Transform3D(-4.37114e-08, -1, -4.37114e-08, 0, -4.37114e-08, 1, -1, 4.37114e-08, 1.91069e-15, 0, -0.489, -0.25)
layers = 2
transparency = 1.0
cast_shadow = 0
gi_mode = 0
mesh = SubResource("QuadMesh_br0di")

[node name="StaticBody3D" type="StaticBody3D" parent="Walls/_DecZ"]

[node name="CollisionShape3D" type="CollisionShape3D" parent="Walls/_DecZ/StaticBody3D"]
shape = SubResource("ConcavePolygonShape3D_iwmgl")

[node name="Label3D" type="Label3D" parent="."]
transform = Transform3D(5, 0, 0, 0, 4.90082, 0.990938, 0, -0.990938, 4.90082, 0, 0, -12.3922)
visible = false
pixel_size = 0.002
font = SubResource("FontFile_gvjk8")
font_size = 64
outline_size = 0
width = 500.05

[node name="MusicPlayer" type="AudioStreamPlayer3D" parent="."]
stream = SubResource("AudioStreamWAV_f0d8j")
unit_size = 18.6
autoplay = true
panning_strength = 0.6
script = ExtResource("8_6b1fc")

[node name="HTTPRequest" type="HTTPRequest" parent="MusicPlayer"]

[node name="HTTPRequest2" type="HTTPRequest" parent="MusicPlayer"]

[node name="HTTPRequest3" type="HTTPRequest" parent="MusicPlayer"]

[node name="HTTPRequest4" type="HTTPRequest" parent="MusicPlayer"]

[node name="HTTPRequest5" type="HTTPRequest" parent="MusicPlayer"]

[node name="Control" type="Control" parent="."]
layout_mode = 3
anchors_preset = 2
anchor_top = 1.0
anchor_bottom = 1.0
offset_top = -128.0
offset_right = 512.0
grow_vertical = 0
script = ExtResource("9_0w7pm")

[node name="ProgressIndicator" type="Polygon2D" parent="Control"]
position = Vector2(128, 0)
scale = Vector2(1e-05, 1)
color = Color(0.831373, 0.831373, 0.831373, 0.592157)
polygon = PackedVector2Array(0, 0, 1920, 0, 1920, 128, 0, 128)
script = ExtResource("10_px0lm")

[node name="Polygon2D" type="Polygon2D" parent="Control"]
color = Color(0, 0, 0, 0.2)
polygon = PackedVector2Array(0, 0, 3840, 0, 3840, 128, 0, 128)

[node name="AlbumArt" type="Sprite2D" parent="Control/Polygon2D"]
scale = Vector2(0.1, 0.1)
centered = false
script = ExtResource("11_xl35m")

[node name="PlayingInfo" type="Label" parent="Control/Polygon2D"]
offset_left = 128.0
offset_right = 2048.0
offset_bottom = 128.0
label_settings = SubResource("LabelSettings_1wokp")
autowrap_mode = 1

[node name="ValueCurves" type="MeshInstance2D" parent="Control/Polygon2D"]
visible = false
modulate = Color(0.215686, 0, 0, 1)
show_behind_parent = true
material = SubResource("CanvasItemMaterial_yi7rn")
position = Vector2(1024, 128)
rotation = 1.5708
mesh = SubResource("RibbonTrailMesh_6slm7")
script = ExtResource("12_yc6s8")

[node name="PlayCurve" type="Node3D" parent="."]
visible = false

[node name="Path3D" type="Path3D" parent="PlayCurve"]
visible = false
curve = SubResource("Curve3D_q7xac")

[node name="MeshInstance3D" type="MeshInstance3D" parent="PlayCurve"]
visible = false
script = ExtResource("13_ocln8")

[node name="InfoCard" type="Label3D" parent="."]
alpha_scissor_threshold = 0.644
font_size = 48
outline_size = 8
horizontal_alignment = 0

[node name="MeshInstance3D" type="MeshInstance3D" parent="."]
visible = false
layers = 4096
mesh = SubResource("CylinderMesh_faqaq")
surface_material_override/0 = ExtResource("14_35ful")

[connection signal="item_clicked" from="DatasetControls/DatasetList" to="Generator" method="_on_dataset_list_item_clicked"]
[connection signal="item_selected" from="DatasetControls/DatasetList" to="Generator" method="_on_dataset_list_item_selected"]
[connection signal="finished" from="MusicPlayer" to="MusicPlayer" method="_on_finished"]
[connection signal="texture_changed" from="Control/Polygon2D/AlbumArt" to="Control/Polygon2D/AlbumArt" method="_on_album_art_texture_changed"]
d@g{+[gd_resource type="VisualShader" load_steps=22 format=3 uid="uid://cfgerob0u4vib"]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_wybml"]
operator = 2

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_r5i2p"]

[sub_resource type="VisualShaderNodeFloatParameter" id="VisualShaderNodeFloatParameter_mvtvc"]
parameter_name = "bright"
default_value = 1.0

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_w4yk2"]
default_input_values = [0, 0.2, 1, 1.0, 2, 0.0]

[sub_resource type="VisualShaderNodeVec4Parameter" id="VisualShaderNodeVec4Parameter_f5us6"]
parameter_name = "audio"
default_value_enabled = true
default_value = Vector4(0.1, 0.1, 0.1, 0.1)

[sub_resource type="VisualShaderNodeVectorDecompose" id="VisualShaderNodeVectorDecompose_xia1h"]
default_input_values = [0, Quaternion(0, 0, 0, 0)]
op_type = 2

[sub_resource type="VisualShaderNodeVectorFunc" id="VisualShaderNodeVectorFunc_kamyy"]
function = 32

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_jiwko"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(0.5, 0, 0)]

[sub_resource type="VisualShaderNodeColorFunc" id="VisualShaderNodeColorFunc_7qhcv"]
function = 2

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_p3076"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(1, 1, 1)]
operator = 4

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_6tnlg"]

[sub_resource type="VisualShaderNodeColorFunc" id="VisualShaderNodeColorFunc_k65bp"]
function = 1

[sub_resource type="VisualShaderNodeColorConstant" id="VisualShaderNodeColorConstant_fyyag"]

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_gndvj"]
input_name = "color"

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_anql8"]
input_name = "vertex"

[sub_resource type="VisualShaderNodeVectorDecompose" id="VisualShaderNodeVectorDecompose_gfycy"]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_14dmn"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(11, 11, 11)]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_wsrkn"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(22, 22, 22)]
operator = 3

[sub_resource type="VisualShaderNodeColorConstant" id="VisualShaderNodeColorConstant_vb1jr"]
constant = Color(0, 0, 0, 1)

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_no11r"]
input_name = "inv_view_matrix"

[sub_resource type="VisualShaderNodeTransformVecMult" id="VisualShaderNodeTransformVecMult_vgwm7"]

[resource]
code = "shader_type spatial;
render_mode blend_sub, depth_draw_opaque, cull_back, diffuse_lambert, specular_schlick_ggx;




void fragment() {
// ColorConstant:21
	vec4 n_out21p0 = vec4(1.000000, 1.000000, 1.000000, 1.000000);


// Input:22
	vec4 n_out22p0 = COLOR;


// Output:0
	ALBEDO = vec3(n_out21p0.xyz);
	ALPHA = n_out22p0.x;


}
"
modes/blend = 2
nodes/fragment/0/position = Vector2(940, 360)
nodes/fragment/2/node = SubResource("VisualShaderNodeVectorCompose_6tnlg")
nodes/fragment/2/position = Vector2(360, 320)
nodes/fragment/3/node = SubResource("VisualShaderNodeInput_anql8")
nodes/fragment/3/position = Vector2(-1240, 380)
nodes/fragment/4/node = SubResource("VisualShaderNodeVectorDecompose_gfycy")
nodes/fragment/4/position = Vector2(100, 260)
nodes/fragment/5/node = SubResource("VisualShaderNodeVectorOp_14dmn")
nodes/fragment/5/position = Vector2(-460, 280)
nodes/fragment/6/node = SubResource("VisualShaderNodeVectorOp_wsrkn")
nodes/fragment/6/position = Vector2(-200, 280)
nodes/fragment/7/node = SubResource("VisualShaderNodeColorConstant_vb1jr")
nodes/fragment/7/position = Vector2(-1240, 560)
nodes/fragment/8/node = SubResource("VisualShaderNodeInput_no11r")
nodes/fragment/8/position = Vector2(-1200, 480)
nodes/fragment/9/node = SubResource("VisualShaderNodeTransformVecMult_vgwm7")
nodes/fragment/9/position = Vector2(-800, 320)
nodes/fragment/10/node = SubResource("VisualShaderNodeVectorOp_wybml")
nodes/fragment/10/position = Vector2(540, 480)
nodes/fragment/11/node = SubResource("VisualShaderNodeVectorCompose_r5i2p")
nodes/fragment/11/position = Vector2(260, 560)
nodes/fragment/12/node = SubResource("VisualShaderNodeFloatParameter_mvtvc")
nodes/fragment/12/position = Vector2(-60, 680)
nodes/fragment/13/node = SubResource("VisualShaderNodeVectorCompose_w4yk2")
nodes/fragment/13/position = Vector2(-220, 660)
nodes/fragment/14/node = SubResource("VisualShaderNodeVec4Parameter_f5us6")
nodes/fragment/14/position = Vector2(-920, 600)
nodes/fragment/15/node = SubResource("VisualShaderNodeVectorDecompose_xia1h")
nodes/fragment/15/position = Vector2(-580, 560)
nodes/fragment/16/node = SubResource("VisualShaderNodeVectorFunc_kamyy")
nodes/fragment/16/position = Vector2(-240, 500)
nodes/fragment/17/node = SubResource("VisualShaderNodeVectorOp_jiwko")
nodes/fragment/17/position = Vector2(700, 480)
nodes/fragment/18/node = SubResource("VisualShaderNodeColorFunc_7qhcv")
nodes/fragment/18/position = Vector2(636.196, 691.808)
nodes/fragment/19/node = SubResource("VisualShaderNodeVectorOp_p3076")
nodes/fragment/19/position = Vector2(53.1274, 377.561)
nodes/fragment/20/node = SubResource("VisualShaderNodeColorFunc_k65bp")
nodes/fragment/20/position = Vector2(259.927, 466.661)
nodes/fragment/21/node = SubResource("VisualShaderNodeColorConstant_fyyag")
nodes/fragment/21/position = Vector2(660, 380)
nodes/fragment/22/node = SubResource("VisualShaderNodeInput_gndvj")
nodes/fragment/22/position = Vector2(859.738, 493.613)
nodes/fragment/connections = PackedInt32Array(4, 0, 2, 0, 4, 1, 2, 1, 4, 2, 2, 2, 5, 0, 6, 0, 8, 0, 9, 0, 3, 0, 9, 1, 9, 0, 5, 0, 12, 0, 11, 0, 12, 0, 11, 1, 12, 0, 11, 2, 14, 0, 15, 0, 15, 3, 13, 0, 15, 3, 13, 1, 15, 3, 13, 2, 13, 0, 16, 0, 16, 0, 10, 1, 6, 0, 10, 0, 10, 0, 18, 0, 18, 0, 17, 0, 17, 0, 19, 0, 19, 0, 20, 0, 20, 0, 4, 0, 21, 0, 0, 0, 22, 0, 0, 1)
[gd_resource type="ShaderMaterial" load_steps=2 format=3 uid="uid://dcfrgxqj3bw2x"]

[ext_resource type="Shader" uid="uid://cfgerob0u4vib" path="res://invert_tess.tres" id="1_yxaas"]

[resource]
render_priority = 1
shader = ExtResource("1_yxaas")
g转x5H,GST2            
                        $
  RIFF
  WEBPVP8L
  /!"2HlmlHQ/H^޷dg(9$EZߓ'3ضUj$՜ʝI۶c3 [5vɶ=ԮmmGjmm_XVr*snZ'eS]nwZ:G9>BmItR#^6($Ɓm+qh65I'
F"ɹ{p	"+dMq .^>и6aqgDh:LA\D
\=k(_d2WdV#wo	I]q5*$8Ѡ$G9lH]cLXZӞ3֌r22ؽLdl1.u5!]2E`+H&TDި7P&I<ng5O!͙n
ؚѠ:WJ+6ɒHDSz8&kFj7N;YK$R]VٶHm)rh+ɮdQ
]	SU9BfQm]~Zx./2qR,snV{7c,pIkSg[cNP=b74pf)w<:Ŋ7j0{4R_K܅1<߁Vs)jc8LUm% *m/*+ <Sɩa?Fw"`BrV41*F^IKJg`MK!iVem9IN3;#cLn/iq+trʈkJI-RHOܕ2
1&vֳ+Q4蝁U
mcv% J!+v%MZꚺ0NQ29eqäUZL䜁u_(I؛j+0ƖZ}s*]KܙSG+3pEi,n&>lgC!qյ(_e2ic3iڦUjqRsUi)wRt=c,if:2ɛ16I^^UVx*e18%DzR1R'u]Q	rs]"lWa7]o
~PWlZ+>j^c+a4jDNὗ-8'n
?ehҴiAQH)JRD̰oX?ؿi#?gк@e=C{&ށ+ڕ|h\'Ч_GFU^u2TӁQ%e|p k	Veq38  Kw|Ɗoz-Vs "H%* 	zxl4u"HkLPi0H!gƝ&
|bn]4"}"9;Ks"c. 86&N3R"ppI}*G3@`ok}9?"@<
sv ԢQ@,AP82BrX3= n$^ <ܽr"1 ^ia (~dp-VrBeB8]
p ZA$\3U~BO ;-|
{V6oDD0\Rk8!I--</<JhNW1H#2:E(*H{>&!$| ~\#8> H??	E#VYt7> 6"&ZJpC_j	P:aG0 J$M@Q[zi~q1?Ep7i<*,bеZN-
>/.g'ReK)"}KUƹ>#rw߶ȑqFlΟͧe3[䴻oL~ENNU9wGBt~qk-ί#ΞκZu;{ȴ<N~hA+r /~o9>3.3s}^^_8S@s%]K\)BwUc۽Xǧ;M<*)ȝ&~$#%qQ4ytzS]Y9ޡ$-5.S_?O/]7;LZb8Guo[''،E%;#Ɲ&f_1߃fw!EBXv+pDjGj4GWr 37 ("=NY!<l	mr՚Jkmpga;\)6*k'b;	V^ݨmNfSնaϡq[f|#U^jO/9͑Z.ɫ/IDR85+H4NJl'כH%"Z `"̃L>ij~Z,qWXo}{yiGszQ?lZdF?]FXm-rmФ:З:}|x>e{0vGşu{^}hRf"2:=)X\[Ů=QgY&
q6-,P3{vI}f}~rrk8{υO֌ӹ/>}t	|Úq&ݟWᓟwk9c̊lUi̸~fi_jS-|wR<Lծdٞ,98IҮ6 *3ey[ԖkR<
gR~a
ʾiI9u*ۏü<mԤTAmfBĝqiS4yqm-wj̝qc3j˝mqm]P48idu΄ݿXKG.?l<!ZV\8ʡ@mKlp0/$RX	ZB]=Vq RbkUr[ d9-:g I<2OykH8Z<tAi#ӧ0"m:X1XGҖ@nI겦CM@G"fA$toyJ{θxOi-7Fn"eS=ɞAAqV
e↨U3c**44CV:4ĳ%xr2V_)^a]\dZEZC 
*V#	NP\(4^sh8THP_}
[remap]

importer="texture"
type="CompressedTexture2D"
uid="uid://drkaxs2w0aex8"
path="res://.godot/imported/icon.svg-218a8f2b3041327d8a5756f3a245f83b.ctex"
metadata={
"vram_texture": false
}
 0b 3ohя8extends Control

func _input(event):
	if event is InputEventMultiScreenTap:
		if event.fingers == 2:
			self.visible = !self.visible

qextends Node3D
class_name Generator

@export var cols = Vector3i(245, 276, 239)
var facts = Vector3(1, 1, 1)
var pow_scaling = 0.4
var size = 1

var indices = Array()
var planes = Array()
var dims = Array()
var col_names
var song_ids = []
var song_values
var song_filenames
var song_classification = Array()
var lines = Array()
var jpgs = Array()

var fullscreen = false
var help_visible = true
var thread

var requesting = false

var basenames = Array()

var value_curve: ValuesCurve
var axis_modif = Vector3i(0, 0, 0)

var offset := 0
var offset_diff := 60

var zreader: ZIPReader

var total = 0

@export var basename := "merge_2023"
@export var base_url := "http://boite.trido.fr/"

@export var txt_url := ""
@export var csv_filename := "res://songcache_additions.txt"#"my_tracklist_10k_ana_results.csv"
@export var texture_folder_path := "res://"#"res://rating_10k_art"
@export var datasets_url = base_url + "datasets.txt"

@export var dynamic_datasets := true

@onready var info := $"/root/Node3D/UserControls/Info"
@onready var status := $"/root/Node3D/UserControls/Status"
@onready var collection_bar: CollectionBar = $"/root/Node3D/UserControls/CollectionBar"

var zip_url := "http://boite.trido.fr/mateo_divers.zip"
var zip_filename := "user://"

func process_zip(zip_filename):
	zreader = ZIPReader.new()
	zreader.open(zip_filename)
	
	var files = zreader.get_files()
	for f in files:
		print(f)

	#basename = "mateo_divers"
	
	texture_folder_path = basename + "/" + basename + "_art"
	var txt_file = basename + "/" + basename + "_results.txt"
	
	var file_names = zreader.read_file(txt_file).get_string_from_utf8()
	lines = file_names.split("\n")
	
	var res = parse_data(lines)
	self.song_ids = res[0]
	self.song_values = res[1]
	self.song_filenames = res[2]
	self.col_names = res[3]

func _on_request_completed_zip(result, _response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song collection could not be loaded!")
	
	print("Received zip!!")
	#print("body size: " + str(body.size()))
	
	process_zip(zip_filename)
	start_loading_thread()
	#$HTTPRequest2.request(txt_url)

func load_next_group():
	for p in planes:
		#remove_child(p)
		p.free()
	planes = Array()
	offset += offset_diff
	thread.wait_to_finish()
	# check if got to the end of our dataset
	if offset > total:
		offset = 0
		$HTTPRequest.request(datasets_url)
	else:
		start_loading_thread()
	#$HTTPRequest.request(txt_url)

func _input(event):
	if event is InputEventMultiScreenTap:
		if event.fingers == 3:
			load_next_group()
			
	if event.as_text() == "switch_group" or event.as_text() == "7":
		if event.is_pressed():
			load_next_group()

func get_song_from_id(song_id):
	var index = song_ids.find(song_id)
	if index != -1:
		return song_filenames[index]

func parse_data(lines):
	#var file = FileAccess.open("res://my_tracklist_10k_ana_results.csv", FileAccess.READ)

	#var file = FileAccess.open(csv_filename, FileAccess.READ)
	#file.get_line()
	song_ids = Array()
	song_values = Array()
	song_filenames = Array()
	
	var file_names = FileAccess.open("res://col_names.txt", FileAccess.READ)
	col_names = file_names.get_as_text().split("\n")

	print("lines size: " + str(lines.size()))
	
	for li in range(lines.size()):
		var l = lines[li]
		if l.length() > 0:
			#print(l)
			var csv = l.split('\t')
			var song_id = csv[0].split(" ")[0].split("/")[-1]
			var song_filename = csv[0].split("/")[-1]
			var values = Array(csv.duplicate().slice(1))
			song_ids.append(song_id)
			song_filenames.append(song_filename)
			var vv = Array()
			for v in values:
				vv.append(float(v))

			song_values.append(vv)

	#file.close()
	var res = [song_ids, song_values, song_filenames, col_names]
	
	return res
	
func _on_request_completed_datasets(result, _response_code, headers, body: PackedByteArray):
	var file
	
	if result != HTTPRequest.RESULT_SUCCESS:
		print("Datasets could not be loaded!")
		print("Using built-in datasets...")
		file = FileAccess.get_file_as_string("res://datasets.txt")
	else:
		print("Received datasets list!!")
		print("body size: " + str(body.size()))
		file = body.get_string_from_utf8()
	
	lines = file.split("\n")
	
	basenames.clear()
	for l in lines:
		if l.length() > 0:
			basenames.append(l)
			
	print("Got basenames: ")
	print(basenames)
	
	if !dynamic_datasets:		
		basename = "mateo_divers"
		
		texture_folder_path = "res://" + basename + "_art/"
		txt_url = base_url + basename + "_results.txt"
		
		$HTTPRequest2.request(txt_url)
	else:
		get_node("/root/Node3D/DatasetControls").visible = true
		var dataset_list : ItemList = get_node("/root/Node3D/DatasetControls/DatasetList")
		dataset_list.clear()
		
		var idx := 0
		for b in basenames:
			dataset_list.add_item(b)
			
			if FileAccess.file_exists("user://" + b + ".zip"):
				dataset_list.set_item_custom_fg_color(idx, Color.ALICE_BLUE)
				
			idx += 1
			
		


func request_dataset(index):
	basename = basenames[index]
	print("got basename: " + basename)
	zip_filename = "user://" + basename + ".zip"
	zip_url = base_url + basename + ".zip"
	if !FileAccess.file_exists(zip_filename):
		$HTTPRequest3.download_file = zip_filename
		$HTTPRequest3.request(zip_url)
	else:
		process_zip(zip_filename)

		if thread:
			thread.wait_to_finish()
		start_loading_thread()
		

func start_loading_thread():
	var texture_filelist: PackedStringArray
	
	if !zreader:
		texture_filelist = DirAccess.get_files_at(texture_folder_path)
	else:
		var tmp_list = zreader.get_files()
		for t in tmp_list:
			if t.ends_with(".jpg"):
				texture_filelist.append(t)
	
	jpgs = Array()
	for j in texture_filelist:
		jpgs.append(j.split("/")[-1].split(" ")[0])
	
	var callable = Callable(self, "_thread_function")
	callable = callable.bindv([jpgs])
	thread = Thread.new()
	# Third argument is optional userdata, it can be any variable.
	thread.start(callable)
	#_thread_function(jpgs)
	#stream_length = stream.get_length()

func _on_request_completed_results(result, response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song collection could not be loaded!")
	
	print("Received songcache!!")
	print("body size: " + str(body.size()))
	var file = body.get_string_from_utf8()
	lines = file.split("\n")
	
	var res = parse_data(lines)
	self.song_ids = res[0]
	self.song_values = res[1]
	self.song_filenames = res[2]
	self.col_names = res[3]
	
	start_loading_thread()

func scale_coord(val):
	return Vector3((pow(val[0] * facts[0], pow_scaling) * 20) - 10, \
			(pow(val[1] * facts[1], pow_scaling) * 20) - 10, \
			(pow(val[2] * facts[2], pow_scaling) * 20) - 10)

func normalize_scene():	
	var raw_vals = [[], [], []]
	
	if planes.size() > 0:
		for index in range(planes.size()):
			var nindex = indices[index]
			raw_vals[0].append(song_values[nindex][cols[0]])
			raw_vals[1].append(song_values[nindex][cols[1]])
			raw_vals[2].append(song_values[nindex][cols[2]])
		
		var mins = Vector3(raw_vals[0].min(), raw_vals[1].min(), raw_vals[2].min())
		var maxs = Vector3(raw_vals[0].max(), raw_vals[1].max(), raw_vals[2].max())
		
		facts = Vector3(1, 1, 1) / (maxs - mins)
		
		#for index in range(planes.size()):
		#	var nindex = indices[index]
		#	planes[index].position = Vector3((song_values[nindex][cols[0]] * 20) - 10, (song_values[nindex][cols[1]] * 20) - 10, (song_values[nindex][cols[2]] * 20) - 10)

func refresh_label():
	info.text = str(basename + "\n" + "X: " + col_names[cols[0]] + "\nY: " + col_names[cols[1]] + "\nZ: " + col_names[cols[2]])
	#info.text = str("scaling: " + str(pow_scaling) + "\nX: " + col_names[cols[0]] + "\nY: " + col_names[cols[1]] + "\nZ: " + col_names[cols[2]])
	
	
	
func refresh_load_status(now, total):
	if now - (offset + offset_diff) > 0:
		status.text = str("Loading... " + str(now) + " / " + str(total) + "...")
	else:
		status.text = str("Loaded " + str(now) + " / " + str(total))
		
	self.collection_bar.update_texture()

func update_scene(modif, force = false):
	if (modif[0] == 0 and modif[1] == 0 and modif[2] == 0) and force == false:
		return
	
	value_curve = get_parent().find_child("ValueCurves") as ValuesCurve
	
	cols += modif
	if value_curve:
		value_curve.refresh_windowed2(cols)
	print("cols: " + str(cols[0]) + ", " + str(cols[1]) + ", " + str(cols[2]))
	refresh_label()
	
	normalize_scene()
	
	for dim in range(dims.size()):
		dims[dim].text = str(cols[dim]) + "\n" + str(col_names[cols[dim]])
		
	for index in range(planes.size()):
		var nindex = indices[index]
		planes[index].position = scale_coord(Vector3(song_values[nindex][cols[0]], song_values[nindex][cols[1]], song_values[nindex][cols[2]]))

func update_scaling(diff):
	pow_scaling += diff

func update_size(diff):
	size += diff
	for index in range(planes.size()):
		var nindex = indices[index]
		planes[index].scale = Vector3(1, 1, 1) * size
	var player = get_parent().find_child("PlayerNode") as PlayerNode
	player.acceleration = size
	player.speed = size / 5


func _process(delta):
	var modif = Vector3i()
	
	if Input.is_action_just_pressed("inc_x"):
		modif[0] += 1
	if Input.is_action_just_pressed("dec_x"):
		modif[0] -= 1
	if Input.is_action_just_pressed("inc_y"):
		modif[1] += 1
	if Input.is_action_just_pressed("dec_y"):
		modif[1] -= 1
	if Input.is_action_just_pressed("inc_z"):
		modif[2] += 1
	if Input.is_action_just_pressed("dec_z"):
		modif[2] -= 1
	
	var should_update = false
	
	if axis_modif.x != 0 or axis_modif.y != 0 or axis_modif.z != 0:
		print("should update!~")
		
		modif = Vector3i(axis_modif)
		print(axis_modif)
		axis_modif = Vector3i(0, 0, 0)
		#update_scene(modif)
	
	if Input.is_action_just_pressed("scale_up"):
		update_scaling(0.1)
		should_update = true
	if Input.is_action_just_pressed("scale_down"):
		update_scaling(-0.1)
		should_update = true
		
	if Input.is_action_just_pressed("size_up"):
		update_size(0.1)
	if Input.is_action_just_pressed("size_down"):
		update_size(-0.1)
	
	if Input.is_action_just_pressed("normalize") or should_update:
		#normalize_scene()
		update_scene(Vector3i(0, 0, 0), true)
	else:
		update_scene(modif)
		
	if Input.is_action_just_pressed("fullscreen"):
		fullscreen = !fullscreen
		toggle_fullscreen()
		
	if Input.is_action_just_pressed("help_wanted"):
		help_visible = !help_visible
		(get_parent_node_3d().find_child("HelpMenu") as Control).visible = help_visible
		

func toggle_fullscreen():
	if DisplayServer.window_get_mode() == DisplayServer.WINDOW_MODE_MAXIMIZED:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_MAXIMIZED)
	else:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_EXCLUSIVE_FULLSCREEN)
	var camera = (get_parent_node_3d().find_child("Player").find_child("Camera3D") as Camera3D)
	(camera.find_child("CrossUp") as MeshInstance2D).position = get_window().size / 2
	(camera.find_child("CrossDown") as MeshInstance2D).position = get_window().size / 2

func _ready():
	if OS.get_name() == "iOS":
		offset_diff = 100
	else:
		offset_diff = 100
	
	$HTTPRequest.request_completed.connect(_on_request_completed_datasets)
	$HTTPRequest2.request_completed.connect(_on_request_completed_results)
	$HTTPRequest3.request_completed.connect(_on_request_completed_zip)
	
	#$HTTPRequest3.request(zip_url)
	
	$HTTPRequest.request(datasets_url)

	
func _thread_function(jpgs):
	# Get the path to the folder containing the textures
	#var texture_folder_path := "res://songcache_art"
	#var texture_folder_path := "res://rating_10k_art"
	
	if dims.size() == 0:
		for i in range(0, 3):
			var dim = Label3D.new()
			dim.name = "col_" + str(i)
			dim.text = str(cols[i]) + "\n" + str(col_names[cols[i]])
			dim.position[(i+2)%3] -= 10
			dim.font_size = 256
			dims.append(dim)
			self.call_deferred("add_child", dim)
			
		(dims[1] as Label3D).call_deferred("rotate_z", -PI/2.0)
		(dims[1] as Label3D).call_deferred("rotate_y", PI/2.0)
		(dims[2] as Label3D).call_deferred("rotate_z", PI/2.0)
		(dims[2] as Label3D).call_deferred("rotate_x", -PI/2.0)
		
		#dims[1].rotation[1] = PI/2#(i+1)%3
		#dims[1].rotation[2] = -PI/2
		#dims[2].rotation[0] = -PI/2#(i+1)%3
		#dims[2].rotation[2] = PI/2#(i+1)%3
		
		dims[0].modulate = "ff4545"
		dims[1].modulate = "45ff45"
		dims[2].modulate = "4545ff"
	
	var filenames = Array()
	
	print(jpgs)
	
	for f in song_filenames:
		if jpgs.find(f.split("/")[-1].split(" ")[0]) != -1:
			if !((f as String).contains(".part")):
				filenames.append((f as String).replace(".m4a", "")+".jpg")
				
	var now = 0
	
	#filenames = filenames.slice(20, 80)
	total = filenames.size()
	offset = offset % total 
	filenames = filenames.slice(offset, offset+offset_diff)
	
	#if offset+offset_diff > total:
	#	filenames.slice(0, total-(offset+offset_diff))
	
	self.collection_bar.init(total)
	
	for texture_path in filenames:#DirAccess.get_files_at(texture_folder_path):
		print(texture_path)
		var ext_song_id = texture_path.split("/")[-1].split(" ")[0]
		var index = song_ids.find(ext_song_id)
		
		if texture_path.ends_with(".jpg") and index != -1:
			var texture_plane := MeshInstance3D.new()
			texture_plane.name = ext_song_id
			texture_plane.mesh = QuadMesh.new()
			
			var texture: ImageTexture
			
			if !zreader:
				texture = ResourceLoader.load(texture_folder_path + "/" + texture_path)
			else:
				var new_image = Image.new()
				var buff = zreader.read_file(texture_folder_path + "/" + texture_path)
				new_image.load_jpg_from_buffer(buff)
				texture = ImageTexture.create_from_image(new_image)
			
			var texture_material := StandardMaterial3D.new()

			texture_material.albedo_texture = texture
			texture_material.shading_mode = BaseMaterial3D.SHADING_MODE_UNSHADED
			#texture_material.fixed_size = true
			#texture_material.billboard_mode = BaseMaterial3D.BILLBOARD_ENABLED
			#texture_material.billboard_keep_scale = true
			#texture_material.billboard_mode = BaseMaterial3D.BILLBOARD_ENABLED

			texture_plane.mesh.surface_set_material(0, texture_material)
			print(texture_path.split(" ")[0])
			
			if index != -1:
				#print("FOUND INDEX")
				indices.append(index)
				texture_plane.position = scale_coord(Vector3(song_values[index][cols[0]], song_values[index][cols[1]], song_values[index][cols[2]]))
				texture_plane.call_deferred("create_convex_collision")
				planes.append(texture_plane)
				self.collection_bar.song_statuses[(planes.size() - 1)+offset] = self.collection_bar.STATUS.LOADED
				self.call_deferred("add_child", texture_plane)
			else:
				print("COULD NOT FIND INDEX")
			
			if now % 10 == 0:
				self.call_deferred("refresh_load_status", now+offset, total)
			
			if now % 10 == 0:
				self.call_deferred("update_scene", Vector3i(0, 0, 0), true)
				
			now += 1
	
	self.call_deferred("refresh_load_status", now+offset, total)
	self.call_deferred("update_scene", Vector3i(0, 0, 0), true)
	
	#print("Could not find any textures")
	print("Planes len: " + str(self.planes.size()))
	
	requesting = false
	
	

func _exit_tree():
	thread.wait_to_finish()

func _on_dataset_list_item_clicked(index, at_position, mouse_button_index):
	if !requesting:
		request_dataset(index)
		get_node("/root/Node3D/DatasetControls").visible = false
		requesting = true
		ProjectSettings.set_setting("input_devices/pointing/emulate_mouse_from_touch", false)


func _on_dataset_list_item_selected(index):
	if !requesting:
		request_dataset(index)
		get_node("/root/Node3D/DatasetControls").visible = false
		requesting = true
		ProjectSettings.set_setting("input_devices/pointing/emulate_mouse_from_touch", false)
%
ЗE[remap]

importer="texture"
type="CompressedTexture2D"
uid="uid://bxhgk1comk2ut"
metadata={
"imported_formats": ["s3tc_bptc", "etc2_astc"],
"vram_texture": true
}
 w#t?B[gd_resource type="AudioBusLayout" load_steps=2 format=3 uid="uid://b4ki6l4jqnvu7"]

[sub_resource type="AudioEffectSpectrumAnalyzer" id="AudioEffectSpectrumAnalyzer_6tefq"]
resource_name = "SpectrumAnalyzer"
buffer_length = 0.1

[resource]
bus/0/effect/0/effect = SubResource("AudioEffectSpectrumAnalyzer_6tefq")
bus/0/effect/0/enabled = true
ƍ9extends Node3D

@onready var curve: Curve3D

func _ready():
	curve = get_parent().get_parent().get_parent().find_child("Path3D").curve

func _process(delta):
	return
	if Input.is_action_just_pressed("add_point"):
		print("Added " + str(get_parent().position) + " to curve!")
		curve.add_point(get_parent().position)
TCK?extends Sprite2D
class_name CollectionBar

enum STATUS {
	UNLOADED = 0x7f000000,
	LOADED = 0x7fffffff,
	CAT_1 = 0xff00ffff,
	CAT_2 = 0x00ff00ff,
	CAT_3 = 0x0000ffff
}

var song_statuses: PackedInt32Array
var image: Image
var cat_width = 0

var window_width = 720

# Called when the node enters the scene tree for the first time.
func _ready():
	window_width = get_viewport_rect().size.x
	get_parent().size.x = window_width
	region_rect.size.x = window_width
	pass # Replace with function body.

func update_texture():
	self.image = Image.create_from_data(cat_width, 1, false, Image.FORMAT_RGBA8, self.song_statuses.to_byte_array())
	self.image.resize(window_width, 32)
	self.texture.update(self.image)

func init(width):
	self.song_statuses = PackedInt32Array()
	song_statuses.resize(width)
	cat_width = width
	song_statuses.fill(STATUS.UNLOADED)
	
	var new_texture = ImageTexture.new()
	self.image = Image.create_from_data(width, 1, false, Image.FORMAT_RGBA8, self.song_statuses.to_byte_array())

	self.image.resize(window_width, 32)
	self.texture = ImageTexture.create_from_image(self.image)
	print("used rect: " + str(self.image.get_used_rect()))
	#self.texture = new_texture
	#self.draw_texture(new_texture, Vector2(0, 0))

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
}X`extends Control

@export var vheight := 256.0

func _ready():
	$ProgressIndicator.polygon[2].y = vheight
	$ProgressIndicator.polygon[3].y = vheight
dY:9#~1qextends Sprite2D

func _on_album_art_texture_changed():
	self.scale = Vector2(128, 128) / self.texture.get_size()
	return # Replace with function body.
AM0`Ch[gd_resource type="VisualShader" load_steps=2 format=3 uid="uid://ch2grb3vopkuh"]

[sub_resource type="VisualShaderNodeColorConstant" id="VisualShaderNodeColorConstant_vuo1w"]
constant = Color(1, 0, 0.0146151, 1)

[resource]
code = "shader_type canvas_item;
render_mode blend_mix;




void fragment() {
// ColorConstant:2
	vec4 n_out2p0 = vec4(1.000000, 0.000000, 0.014615, 1.000000);


// Output:0
	COLOR.rgb = vec3(n_out2p0.xyz);


}
"
mode = 1
flags/light_only = false
nodes/fragment/2/node = SubResource("VisualShaderNodeColorConstant_vuo1w")
nodes/fragment/2/position = Vector2(100, 180)
nodes/fragment/connections = PackedInt32Array(2, 0, 0, 0)
1ߒjextends MeshInstance2D
class_name ValuesCurve

var xcurve: Curve

var filename_prefix := "res://windowed/windowed_ana_"
var filename: String

var cols: Vector3i
var target = 242

var col = 0

var song_values := Array()
var packed_values := PackedFloat32Array()
var windows = 100
var max = 0

func _ready():
	filename = filename_prefix + "5_2.5.csv"
	position.x = (get_viewport().size.x / 2) + 64
	#filename = "res://windowed_ana.csv"
	#load_windowed()
	
func _input(event):
	var e = event.as_text()
	if e.length() == 1 and e >= '1' and e <= '3':
		col = e[0].to_int() - 1
		refresh_windowed2()

func load_windowed_song(values: PackedFloat32Array):
	if !visible:
		visible = true
	max = 0
	packed_values = values
	
	windows = values.size() / 527
	
	mesh.sections = windows
	refresh_windowed2()

# Called when the node enters the scene tree for the first time.
func load_windowed():
	max = 0
	song_values = Array()
	
	var curve_file = FileAccess.open(filename, FileAccess.READ)
	
	while !curve_file.eof_reached():
		var values = curve_file.get_csv_line('\t')
		if values.size() > 1:
			var vv = Array()
			for v in values:
				vv.append(float(v))
			
			song_values.append(vv)

	mesh.sections = song_values.size()
	refresh_windowed()

func refresh_windowed2(new_cols=Vector3i()):
	if new_cols.length() > 1:
		self.cols = new_cols
	
	self.target = cols[col]
	if col == 0:
		modulate = "#99000099"
	if col == 1:
		modulate = "#00990099"
	if col == 2:
		modulate = "#00009999"
	
	max = 0
	
	if packed_values.size() > 0:
		for i in range(windows):
			if packed_values[i*527+target] > max:
				max = packed_values[i*527+target]
		
		xcurve = mesh.curve
		xcurve.clear_points()
		
		mesh.section_length = get_viewport().size.x / mesh.sections

		for i in range(windows):
			xcurve.add_point(Vector2(float(i)/float(windows), packed_values[i*527+target] / max))
		
		#self.mesh.generate_triangle_mesh()
		print("REFRESHED!!!")
		pass # Replace with function body.
	
func refresh_windowed(new_cols=Vector3i()):
	if new_cols.length() > 1:
		self.cols = new_cols
	
	self.target = cols[col]
	if col == 0:
		modulate = "#33000099"
	if col == 1:
		modulate = "#00330099"
	if col == 2:
		modulate = "#00003399"
	
	max = 0
	
	for i in range(song_values.size()):
		if song_values[i][target] > max:
			max = song_values[i][target]
	
	xcurve = mesh.curve
	xcurve.clear_points()
	
	var len = song_values.size()
	mesh.section_length = get_viewport().size.x / mesh.sections

	for i in range(len):
		xcurve.add_point(Vector2(float(i)/float(len), song_values[i][self.target] / max))
	
	#self.mesh.generate_triangle_mesh()
	#print(xcurve)
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
?B+-)Kextends MeshInstance2D
class_name ValuesCurve

var xcurve: Curve

var filename_prefix := "res://windowed/windowed_ana_"

var cols: Vector3i
var target = 242

var col = 0

var song_values := Array()

func _ready():
	load_windowed(filename_prefix + "10_2.5.csv", target)

# Called when the node enters the scene tree for the first time.
func load_windowed(filename, target):
	xcurve = mesh.curve
	xcurve.clear_points()
	song_values.clear()
	
	var curve_file = FileAccess.open(filename, FileAccess.READ)
	
	var max = 0
	var generator = get_node("/root/Node3D/Generator") as Generator
	cols = generator.cols
	self.target = cols[col]
	
	while !curve_file.eof_reached():
		var values = curve_file.get_csv_line("\t")
		if values.size() > 1:
			var vv = Array()
			for v in values:
				vv.append(float(v))
				
			if vv[target] > max:
				max = vv[target]

			song_values.append(vv)

	for i in range(song_values.size()):
		xcurve.add_point(Vector2(i/song_values.size(), song_values[i][target] / max))
	
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
1KNpt[[gd_resource type="VisualShader" load_steps=16 format=3 uid="uid://bk2kpnx25vkq"]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_wybml"]
operator = 2

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_r5i2p"]

[sub_resource type="VisualShaderNodeFloatParameter" id="VisualShaderNodeFloatParameter_mvtvc"]
parameter_name = "bright"
default_value = 1.0

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_w4yk2"]
default_input_values = [0, 0.2, 1, 1.0, 2, 0.0]

[sub_resource type="VisualShaderNodeVec4Parameter" id="VisualShaderNodeVec4Parameter_f5us6"]
parameter_name = "audio"
default_value_enabled = true
default_value = Vector4(0.1, 0.1, 0.1, 0.1)

[sub_resource type="VisualShaderNodeVectorDecompose" id="VisualShaderNodeVectorDecompose_xia1h"]
default_input_values = [0, Quaternion(0, 0, 0, 0)]
op_type = 2

[sub_resource type="VisualShaderNodeVectorFunc" id="VisualShaderNodeVectorFunc_kamyy"]
function = 32

[sub_resource type="VisualShaderNodeVectorCompose" id="VisualShaderNodeVectorCompose_6tnlg"]

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_anql8"]
input_name = "vertex"

[sub_resource type="VisualShaderNodeVectorDecompose" id="VisualShaderNodeVectorDecompose_gfycy"]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_14dmn"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(11, 11, 11)]

[sub_resource type="VisualShaderNodeVectorOp" id="VisualShaderNodeVectorOp_wsrkn"]
default_input_values = [0, Vector3(0, 0, 0), 1, Vector3(22, 22, 22)]
operator = 3

[sub_resource type="VisualShaderNodeColorConstant" id="VisualShaderNodeColorConstant_vb1jr"]
constant = Color(0, 0, 0, 1)

[sub_resource type="VisualShaderNodeInput" id="VisualShaderNodeInput_no11r"]
input_name = "inv_view_matrix"

[sub_resource type="VisualShaderNodeTransformVecMult" id="VisualShaderNodeTransformVecMult_vgwm7"]

[resource]
code = "shader_type spatial;
render_mode blend_mix, depth_draw_opaque, cull_disabled, diffuse_lambert, specular_schlick_ggx, unshaded, world_vertex_coords;

uniform vec4 audio = vec4(0.100000, 0.100000, 0.100000, 0.100000);



void fragment() {
// Input:8
	mat4 n_out8p0 = INV_VIEW_MATRIX;


// Input:3
	vec3 n_out3p0 = VERTEX;


// TransformVectorMult:9
	vec3 n_out9p0 = (n_out8p0 * vec4(n_out3p0, 1.0)).xyz;


// VectorOp:5
	vec3 n_in5p1 = vec3(11.00000, 11.00000, 11.00000);
	vec3 n_out5p0 = n_out9p0 + n_in5p1;


// VectorOp:6
	vec3 n_in6p1 = vec3(22.00000, 22.00000, 22.00000);
	vec3 n_out6p0 = n_out5p0 / n_in6p1;


// Vector4Parameter:14
	vec4 n_out14p0 = audio;


// VectorDecompose:15
	float n_out15p0 = n_out14p0.x;
	float n_out15p1 = n_out14p0.y;
	float n_out15p2 = n_out14p0.z;
	float n_out15p3 = n_out14p0.w;


// VectorCompose:13
	vec3 n_out13p0 = vec3(n_out15p3, n_out15p3, n_out15p3);


// VectorFunc:16
	vec3 n_out16p0 = vec3(1.0) - n_out13p0;


// VectorOp:10
	vec3 n_out10p0 = n_out6p0 * n_out16p0;


// VectorDecompose:4
	float n_out4p0 = n_out10p0.x;
	float n_out4p1 = n_out10p0.y;
	float n_out4p2 = n_out10p0.z;


// VectorCompose:2
	vec3 n_out2p0 = vec3(n_out4p0, n_out4p1, n_out4p2);


// Output:0
	ALBEDO = n_out2p0;


}
"
modes/cull = 2
flags/unshaded = true
flags/world_vertex_coords = true
nodes/fragment/0/position = Vector2(900, 360)
nodes/fragment/2/node = SubResource("VisualShaderNodeVectorCompose_6tnlg")
nodes/fragment/2/position = Vector2(360, 320)
nodes/fragment/3/node = SubResource("VisualShaderNodeInput_anql8")
nodes/fragment/3/position = Vector2(-1240, 380)
nodes/fragment/4/node = SubResource("VisualShaderNodeVectorDecompose_gfycy")
nodes/fragment/4/position = Vector2(100, 260)
nodes/fragment/5/node = SubResource("VisualShaderNodeVectorOp_14dmn")
nodes/fragment/5/position = Vector2(-460, 280)
nodes/fragment/6/node = SubResource("VisualShaderNodeVectorOp_wsrkn")
nodes/fragment/6/position = Vector2(-200, 280)
nodes/fragment/7/node = SubResource("VisualShaderNodeColorConstant_vb1jr")
nodes/fragment/7/position = Vector2(-1240, 560)
nodes/fragment/8/node = SubResource("VisualShaderNodeInput_no11r")
nodes/fragment/8/position = Vector2(-1200, 480)
nodes/fragment/9/node = SubResource("VisualShaderNodeTransformVecMult_vgwm7")
nodes/fragment/9/position = Vector2(-800, 320)
nodes/fragment/10/node = SubResource("VisualShaderNodeVectorOp_wybml")
nodes/fragment/10/position = Vector2(620, 460)
nodes/fragment/11/node = SubResource("VisualShaderNodeVectorCompose_r5i2p")
nodes/fragment/11/position = Vector2(260, 560)
nodes/fragment/12/node = SubResource("VisualShaderNodeFloatParameter_mvtvc")
nodes/fragment/12/position = Vector2(-20, 540)
nodes/fragment/13/node = SubResource("VisualShaderNodeVectorCompose_w4yk2")
nodes/fragment/13/position = Vector2(-220, 660)
nodes/fragment/14/node = SubResource("VisualShaderNodeVec4Parameter_f5us6")
nodes/fragment/14/position = Vector2(-920, 600)
nodes/fragment/15/node = SubResource("VisualShaderNodeVectorDecompose_xia1h")
nodes/fragment/15/position = Vector2(-580, 560)
nodes/fragment/16/node = SubResource("VisualShaderNodeVectorFunc_kamyy")
nodes/fragment/16/position = Vector2(-240, 500)
nodes/fragment/connections = PackedInt32Array(4, 0, 2, 0, 4, 1, 2, 1, 4, 2, 2, 2, 5, 0, 6, 0, 8, 0, 9, 0, 3, 0, 9, 1, 9, 0, 5, 0, 12, 0, 11, 0, 12, 0, 11, 1, 12, 0, 11, 2, 2, 0, 0, 0, 14, 0, 15, 0, 15, 3, 13, 0, 15, 3, 13, 1, 15, 3, 13, 2, 13, 0, 16, 0, 16, 0, 10, 1, 6, 0, 10, 0, 10, 0, 4, 0)
#=]
^g{RSRC                 
   ArrayMesh                                                        	      resource_local_to_scene    resource_name    lightmap_size_hint    _blend_shape_names 
   _surfaces    blend_shape_mode    custom_aabb    shadow_mesh    script           local://ArrayMesh_w7b21 @      
   ArrayMesh                         format         
   primitive             vertex_data    
  ffff?ff?  ffffff?  ffff?33>  ffff33>  ffff?33>ffff33>33ff?33>33ff33>33ff?33>33ff33>33ff?ff?33ffff?33ff?ff?33ffff?ffff?ff?ffffff?33ff33>  ffff33>  33ffff?  ffffff?  ffff?33>33ff?33>ffff?ff?33ff?ff?ffffff  ff33ff?  ff33ff  ff33ff?ff33ff3333ff?3333ff3333ff?3333ff33ffff33ffff  ffffff  3333ffff33ff33ffffffffffff33ff?3333ff?ff?ffff?  ff?ff33>  ff?ff33>ff3333>ff?3333>ff3333>ff?3333>ff?33ff?ff?33ff?ff?ffff?ff?3333>ff?ff33>ff?33ff?ff?ffff?ff3333>  33>ff3333>ff?33ff?ff33ff?ff?33ff?ff33ff?ff?33ff?ffffff?ff?ffff?ffffff?ff?ff33>ffff33>ff?ff33>ffff  33>ff?ff  33>ff33  33>ff?33  ff?ff?ffff?ff?3333>ff?ff33>ff?33ff?ff33  ff?ffff  33>ff33  33>ffff  33>ff?ff?  33>33>ff  33>33>ff?  33>33>ff  33>33>ff?  ff?33>ff  ff?33>ff?  ff?33>ffff?33>ff?ff?ff?ff?ff?ff?ff?33>ff?ff?ff?33>ff?33>33>ff?ff?ff?ff?33>ff?ff?33>33>ffff?33>ffffff?33ffff?ffffff?ffff33>ffff33>ff  ff?33>33  ff33>33  ff?33>33ff33>33ffff?33ff33>ff  ffff?ff  ff33>33  ffff?33  ff?33>33ff33>ff?  33ff?ff33ff?ff3333>ff?3333>ff3333>ff?  3333>ff  ff33>ff?  33ff?ff3333>ffff33>ff?3333>ff?ff33>33>  ff?33>33>  ff33>33>ff?33>33>ff?ff?33>ff?ff?33>ff?ff?33>ff?33>33>ff33>33>  ffff33  33ff?3333ff3333ff?3333ff33ffff3333ff33  ffff33  33ff?33ff?33ffff?33ffff3333ff?3333ff3333ff?3333ff?33ffff?3333ff3333  33>ffff?  33>ff?33>  33>ff33>  33>ff?33>33>ff33>33>ffff?33>ff33>  33>ffff?  33>ff?33>33>33ff?  33>33ff  33>33ff?33>33ff33>33ff33>33ff?   
   vertex_count             aabb    ffffffff?f?f?      index_data    `                	 
 
 	   
   
                                 !  "   " # $ % & & % ' ( )   ) 
  *   * +  , - - , . / 0   0 1 ( 2   2 3 4 5 6 6 5 7  8   8  9 : ; ; : < = > ? ? > @ A B C C B D E F G G F H I J K K J L M N O O N P F Q R R Q S T U V V U W X Y @ @ Y Z I [ K K [ \ ] ^ _ _ ^ ` a b D D b B J c I I c d B e b b e f V g h h g i j k < < k l m n o o n p @ X > > X q r m     m n  d   d s 
 t u u t v w x y y x g z e { { e f   | |  } y W ~ ~ W             [  _ | | _ ]   Z Z  Y   r r    p  n n   e ' z z ' & t !   !    l l   " #   #  d s c c s   M # # M N ' A % % A             ;  ?   ? =       Q           ,  5 Z Z 5 7 _ 3 ` ` 3  +  * *     \ \  [  E   E    1 1   6  7 7  ? * N   N P   A A  C  2   2 3       index_count            RSRC[remap]

importer="wavefront_obj"
importer_version=1
type="Mesh"
uid="uid://bmqjucdpdkxga"
path="res://.godot/imported/tesseract.obj-85e8805adca942c009bebe3d2cba6e18.mesh"
 yRSRC                    PackedScene                                                        u      resource_local_to_scene    resource_name    render_priority 
   next_pass 
   transparency    blend_mode 
   cull_mode    depth_draw_mode    no_depth_test 
   shading_mode 
   diffuse_mode    specular_mode    disable_ambient_light    vertex_color_use_as_albedo    vertex_color_is_srgb 
   albedo_color    albedo_texture    albedo_texture_force_srgb    albedo_texture_msdf 	   metallic    metallic_specular    metallic_texture    metallic_texture_channel 
   roughness    roughness_texture    roughness_texture_channel    emission_enabled 	   emission    emission_energy_multiplier    emission_operator    emission_on_uv2    emission_texture    normal_enabled 
   normal_scale    normal_texture    rim_enabled    rim 	   rim_tint    rim_texture    clearcoat_enabled 
   clearcoat    clearcoat_roughness    clearcoat_texture    anisotropy_enabled    anisotropy    anisotropy_flowmap    ao_enabled    ao_light_affect    ao_texture 
   ao_on_uv2    ao_texture_channel    heightmap_enabled    heightmap_scale    heightmap_deep_parallax    heightmap_flip_tangent    heightmap_flip_binormal    heightmap_texture    heightmap_flip_texture    subsurf_scatter_enabled    subsurf_scatter_strength    subsurf_scatter_skin_mode    subsurf_scatter_texture &   subsurf_scatter_transmittance_enabled $   subsurf_scatter_transmittance_color &   subsurf_scatter_transmittance_texture $   subsurf_scatter_transmittance_depth $   subsurf_scatter_transmittance_boost    backlight_enabled 
   backlight    backlight_texture    refraction_enabled    refraction_scale    refraction_texture    refraction_texture_channel    detail_enabled    detail_mask    detail_blend_mode    detail_uv_layer    detail_albedo    detail_normal 
   uv1_scale    uv1_offset    uv1_triplanar    uv1_triplanar_sharpness    uv1_world_triplanar 
   uv2_scale    uv2_offset    uv2_triplanar    uv2_triplanar_sharpness    uv2_world_triplanar    texture_filter    texture_repeat    disable_receive_shadows    shadow_to_opacity    billboard_mode    billboard_keep_scale    grow    grow_amount    fixed_size    use_point_size    point_size    use_particle_trails    proximity_fade_enabled    proximity_fade_distance    msdf_pixel_range    msdf_outline_size    distance_fade_mode    distance_fade_min_distance    distance_fade_max_distance    script    lightmap_size_hint    _blend_shape_names 
   _surfaces    blend_shape_mode    custom_aabb    shadow_mesh 	   _bundled        !   local://StandardMaterial3D_wg4w7 
         local://ArrayMesh_shhej ~         local://ArrayMesh_kcan4 X         local://PackedScene_elato +*         StandardMaterial3D          
   Material.001          
                             ?        ?               ???  ?m      
   ArrayMesh    p                     format         
   primitive             vertex_data    T  ff   ff?ff   ?ff?ff   33>ff   ?33>33   ff?33   ?ff?33   33>33   ?33>ff  ffff|ffff{ff?33  ff33|ff33{ff?ff?  ff?ff?  33>ff?|ff?ff?|33>ff{33>23>   ?4343>   23ff?   ?43gf?   2323>   ?gf43>   ffff?   ?gfgf?   ff33>   ?ff?33>  ?ff33>{>ff?33>|>ffff?   ?ff?ff?  ?ffff?{>ff?ff?|>ffff   ?33ff?  ?33ff   ?ffff{>33ff?|>33ff{>ffff|>ff?ff  ?ff?33{>ff33|>ff?33   ?ff33  ?ff?ff?{>33>ff|>33>ff?   ?33>ff  ?33>ff   33ff   ff33   3333   ?3333   ffff?  33ff?  ffff?|33ff{33ff?|ffff{ff33>   ff?33>   33>33>   ?33>ff?   ff?ff?   33>33>  ff33>|ff33>{ff?ff?{ff?   
   vertex_count    G         aabb    ff  gfff? ?f?      index_data    `                                           
    	 
 	 
 
 	  
   
            	   	   
   
 
                  
    
    
                
                                              "   ! " !   " !             !    "   "    #   $ # %   % "   % ( " ( ' " ( & ' & $ ' & # $ % & ( % # & " $   " ' $ ( * ) ( % * % . * % - . - , . - + , + ) , + ( ) % + - % ( + . ) * . , ) ! 0 ) ! / 0 / 2 0 / 1 2 1 * 2 1  *  ) *  ! ) /  1 / !  2 ) 0 2 * ) 3 % # 3 4 % 4 - % 4 7 - 7 6 - 7 5 6 5 # 6 5 3 # 4 5 7 4 3 5 - # % - 6 # 8 4 3 8 9 4 9 = 4 9 < = < ; = < : ; : 3 ; : 8 3 9 : < 9 8 : = 3 4 = ; 3 > @  > ? @ ? 1 @ ? B 1 B  1 B A  A   A >  ? A B ? > A 1  @ 1   C E > C D E D F E D < F < A F < 9 A 9 > A 9 C > D 9 < D C 9 F > E F A >       index_count            name    
   Material.001 q          m      
   ArrayMesh             tesseract_Beam1_001 p            	         format         
   primitive             vertex_data       ff   ff?  ff   ff?  ff   ff?ff   ?ff?  ff   ?ff?ff   ?ff?ff   33>  ff   33>  ff   33>ff   ?33>  ff   ?33>ff   ?33>33   ff?  33   ff?33   ff?33   ?ff?33   ?ff?33   ?ff?33   33>  33   33>33   33>33   ?33>33   ?33>33   ?33>ff  ff  ff  ff  ff  ffff   ff?  ff   ff?  ff   ff?ff|ff  ff|ffff|ffff{ff?  ff{ff?ff{ff?33  ff  33  ff33  ff33   ff?  33   ff?33   ff?33|ff33|ff33|ff33{ff?33{ff?33{ff?ff?  ff?  ff?  ff?ff?  ff?ff   ff?  ff   ff?  ff   ff?ff?  33>  ff?  33>ff?  33>ff   33>  ff   33>  ff   33>ff?|ff?ff?|ff?ff?|ff?ff{ff?  ff{ff?ff{ff?ff?|33>ff?|33>ff?|33>ff{33>  ff{33>ff{33>23>   ?43  23>   ?4323>   ?4343>   23  43>   23  43>   23ff?   ?43ff?   ?43ff?   ?43gf?   23  gf?   23gf?   2323>   ?gf  23>   ?gf23>   ?gf43>   ff  43>   ff  43>   ffff?   ?gfff?   ?gfff?   ?gfgf?   ff  gf?   ffgf?   ff33>   ?ff?  33>   ?ff?33>   ?ff?33>  ?ff  33>  ?ff33>  ?ff33>{>ff?  33>{>ff?  33>{>ff?33>|>ff  33>|>ff  33>|>ffff?   ?ff?ff?   ?ff?ff?   ?ff?ff?  ?ffff?  ?ffff?  ?ffff?{>ff?  ff?{>ff?ff?{>ff?ff?|>ff  ff?|>ffff?|>ffff   ?33  ff   ?33ff   ?33ff?  ?33ff?  ?33ff?  ?33ff   ?ff  ff   ?ffff   ?ffff?  ?ffff?  ?ffff?  ?ffff{>33  ff{>33  ff{>33ff?|>33  ff?|>33ff?|>33ff{>ff  ff{>ff  ff{>ffff?|>ff  ff?|>ffff?|>ffff{>ff  ff{>ff  ff{>ffff|>ff?  ff|>ff?  ff|>ff?ff   ?ff  ff   ?ffff   ?ffff  ?ff?  ff  ?ff?ff  ?ff?33{>ff  33{>ff33{>ff33|>ff?  33|>ff?33|>ff?33   ?ff33   ?ff33   ?ff33  ?ff?33  ?ff?33  ?ff?ff?{>ff?  ff?{>ff?ff?{>ff?ff|>ff?  ff|>ff?  ff|>ff?ff?{>33>  ff?{>33>ff?{>33>ff|>33>  ff|>33>  ff|>33>ff?   ?ff?ff?   ?ff?ff?   ?ff?ff  ?ff?  ff  ?ff?ff  ?ff?ff?   ?33>ff?   ?33>ff?   ?33>ff  ?33>  ff  ?33>ff  ?33>ff   33  ff   33  ff   33ff   ?33  ff   ?33ff   ?33ff   ff  ff   ff  ff   ffff   ?ff  ff   ?ffff   ?ff33   33  33   3333   3333   ?3333   ?3333   ?3333   ff  33   ff33   ff33   ?ff33   ?ff33   ?ffff?  33  ff?  33ff?  33ff   33  ff   33  ff   33ff?  ff  ff?  ffff?  ffff   ff  ff   ff  ff   ffff?|33ff?|33ff?|33ff{33  ff{33ff{33ff?|ffff?|ffff?|ffff{ff  ff{ffff{ff33>   ff?  33>   ff?  33>   ff?33>   ?ff?  33>   ?ff?33>   ?ff?33>   33>  33>   33>  33>   33>33>   ?33>  33>   ?33>33>   ?33>ff?   ff?  ff?   ff?ff?   ff?ff?   ?ff?ff?   ?ff?ff?   ?ff?ff?   33>  ff?   33>ff?   33>ff?   ?33>ff?   ?33>ff?   ?33>33>  ff  33>  ff  33>  ff33>   ff?  33>   ff?  33>   ff?33>|ff  33>|ff33>|ff33>{ff?  33>{ff?33>{ff?ff?  ff  ff?  ffff?  ffff?   ff?  ff?   ff?ff?   ff?ff?|ffff?|ffff?|ffff?{ff?ff?{ff?ff?{ff?   
   vertex_count             aabb    ff  gfff? ?f?      index_data    `    	     	   
          
   
                !    !   . #   + . , ) / , & ) $  ' $    % *   % -  " - (  0 : 4 0 6 : 7 F ; 7 B F C A G C = A < 5 @ < 1 5 8 > D 8 2 > E 3 9 E ? 3 I R M I N R P _ S P \ _ Z Y ^ Z U Y T K W T H K O V [ O J V ] L Q ] X L ` i c ` f i g u j g r u t q w t n q m e p m b e h l s h a l v d k v o d z  | z                {   y { ~   ~ x   }    }                                                                                                                                                                          	


      index_count         	   material                 name    
   Material.001 q          s            m         PackedScene    t      	         names "      
   tesseract    Node3D    Beam1 
   transform    mesh 	   skeleton    MeshInstance3D    	   variants            ?            ff?              ?                                  node_count             nodes                                                                     conn_count              conns               node_paths              editable_instances              version       m      RSRC[remap]

importer="scene"
importer_version=1
type="PackedScene"
uid="uid://cbvmk87q66se7"
path="res://.godot/imported/tesseract.glb-02c38bc0c75f05c5a50fbde9890bb914.scn"
 hFRSRC                 
   ArrayMesh                                                        t      resource_local_to_scene    resource_name    render_priority 
   next_pass 
   transparency    blend_mode 
   cull_mode    depth_draw_mode    no_depth_test 
   shading_mode 
   diffuse_mode    specular_mode    disable_ambient_light    vertex_color_use_as_albedo    vertex_color_is_srgb 
   albedo_color    albedo_texture    albedo_texture_force_srgb    albedo_texture_msdf 	   metallic    metallic_specular    metallic_texture    metallic_texture_channel 
   roughness    roughness_texture    roughness_texture_channel    emission_enabled 	   emission    emission_energy_multiplier    emission_operator    emission_on_uv2    emission_texture    normal_enabled 
   normal_scale    normal_texture    rim_enabled    rim 	   rim_tint    rim_texture    clearcoat_enabled 
   clearcoat    clearcoat_roughness    clearcoat_texture    anisotropy_enabled    anisotropy    anisotropy_flowmap    ao_enabled    ao_light_affect    ao_texture 
   ao_on_uv2    ao_texture_channel    heightmap_enabled    heightmap_scale    heightmap_deep_parallax    heightmap_flip_tangent    heightmap_flip_binormal    heightmap_texture    heightmap_flip_texture    subsurf_scatter_enabled    subsurf_scatter_strength    subsurf_scatter_skin_mode    subsurf_scatter_texture &   subsurf_scatter_transmittance_enabled $   subsurf_scatter_transmittance_color &   subsurf_scatter_transmittance_texture $   subsurf_scatter_transmittance_depth $   subsurf_scatter_transmittance_boost    backlight_enabled 
   backlight    backlight_texture    refraction_enabled    refraction_scale    refraction_texture    refraction_texture_channel    detail_enabled    detail_mask    detail_blend_mode    detail_uv_layer    detail_albedo    detail_normal 
   uv1_scale    uv1_offset    uv1_triplanar    uv1_triplanar_sharpness    uv1_world_triplanar 
   uv2_scale    uv2_offset    uv2_triplanar    uv2_triplanar_sharpness    uv2_world_triplanar    texture_filter    texture_repeat    disable_receive_shadows    shadow_to_opacity    billboard_mode    billboard_keep_scale    grow    grow_amount    fixed_size    use_point_size    point_size    use_particle_trails    proximity_fade_enabled    proximity_fade_distance    msdf_pixel_range    msdf_outline_size    distance_fade_mode    distance_fade_min_distance    distance_fade_max_distance    script    lightmap_size_hint    _blend_shape_names 
   _surfaces    blend_shape_mode    custom_aabb    shadow_mesh        !   local://StandardMaterial3D_g7bma 
         local://ArrayMesh_0dtfu 
         StandardMaterial3D          
   Material.001       L?L?L?  ?         ?m      
   ArrayMesh    p            	         format         
   primitive             vertex_data    
  ffff?ff?  ffffff?  ffff?33>  ffff33>  ffff?33>ffff33>33ff?33>33ff33>33ff?33>33ff33>33ff?ff?33ffff?33ff?ff?33ffff?ffff?ff?ffffff?33ff33>  ffff33>  33ffff?  ffffff?  ffff?33>33ff?33>ffff?ff?33ff?ff?ffffff  ff33ff?  ff33ff  ff33ff?ff33ff3333ff?3333ff3333ff?3333ff33ffff33ffff  ffffff  3333ffff33ff33ffffffffffff33ff?3333ff?ff?ffff?  ff?ff33>  ff?ff33>ff3333>ff?3333>ff3333>ff?3333>ff?33ff?ff?33ff?ff?ffff?ff?3333>ff?ff33>ff?33ff?ff?ffff?ff3333>  33>ff3333>ff?33ff?ff33ff?ff?33ff?ff33ff?ff?33ff?ffffff?ff?ffff?ffffff?ff?ff33>ffff33>ff?ff33>ffff  33>ff?ff  33>ff33  33>ff?33  ff?ff?ffff?ff?3333>ff?ff33>ff?33ff?ff33  ff?ffff  33>ff33  33>ffff  33>ff?ff?  33>33>ff  33>33>ff?  33>33>ff  33>33>ff?  ff?33>ff  ff?33>ff?  ff?33>ffff?33>ff?ff?ff?ff?ff?ff?ff?33>ff?ff?ff?33>ff?33>33>ff?ff?ff?ff?33>ff?ff?33>33>ffff?33>ffffff?33ffff?ffffff?ffff33>ffff33>ff  ff?33>33  ff33>33  ff?33>33ff33>33ffff?33ff33>ff  ffff?ff  ff33>33  ffff?33  ff?33>33ff33>ff?  33ff?ff33ff?ff3333>ff?3333>ff3333>ff?  3333>ff  ff33>ff?  33ff?ff3333>ffff33>ff?3333>ff?ff33>33>  ff?33>33>  ff33>33>ff?33>33>ff?ff?33>ff?ff?33>ff?ff?33>ff?33>33>ff33>33>  ffff33  33ff?3333ff3333ff?3333ff33ffff3333ff33  ffff33  33ff?33ff?33ffff?33ffff3333ff?3333ff3333ff?3333ff?33ffff?3333ff3333  33>ffff?  33>ff?33>  33>ff33>  33>ff?33>33>ff33>33>ffff?33>ff33>  33>ffff?  33>ff?33>33>33ff?  33>33ff  33>33ff?33>33ff33>33ff33>33ff?   
   vertex_count             aabb    ffffffff?f?f?      index_data    `                	 
 
 	   
   
                                 !  "   " # $ % & & % ' ( )   ) 
  *   * +  , - - , . / 0   0 1 ( 2   2 3 4 5 6 6 5 7  8   8  9 : ; ; : < = > ? ? > @ A B C C B D E F G G F H I J K K J L M N O O N P F Q R R Q S T U V V U W X Y @ @ Y Z I [ K K [ \ ] ^ _ _ ^ ` a b D D b B J c I I c d B e b b e f V g h h g i j k < < k l m n o o n p @ X > > X q r m     m n  d   d s 
 t u u t v w x y y x g z e { { e f   | |  } y W ~ ~ W             [  _ | | _ ]   Z Z  Y   r r    p  n n   e ' z z ' & t !   !    l l   " #   #  d s c c s   M # # M N ' A % % A             ;  ?   ? =       Q           ,  5 Z Z 5 7 _ 3 ` ` 3  +  * *     \ \  [  E   E    1 1   6  7 7  ? * N   N P   A A  C  2   2 3       index_count         	   material                 name    	   Material m      RSRC[remap]

importer="wavefront_obj"
importer_version=1
type="Mesh"
uid="uid://c0e5uudwf2b8n"
path="res://.godot/imported/tesseract2.obj-e8cc5647172b9a4fdd0ad7b32faa74a2.mesh"
 efextends "res://CollectionBar.gd"


# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
,f۽gN7extends Polygon2D

var width = 720

# Called when the node enters the scene tree for the first time.
func _ready():
	width = get_viewport_rect().size.x
	self.polygon[1].x = width - 128
	self.polygon[2].x = width - 128
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
U3Cextends MeshInstance2D
class_name ValueCurve

var xcurve: Curve

var filename_prefix := "res://windowed/windowed_ana_"

var cols: Vector3i
var target = 242

var col = 0

var song_values := Array()

func _ready():
	load_windowed(filename_prefix + "10_2.5.csv", target)

# Called when the node enters the scene tree for the first time.
func load_windowed(filename, target):
	xcurve = mesh.curve
	xcurve.clear_points()
	song_values.clear()
	
	var curve_file = FileAccess.open(filename, FileAccess.READ)
	
	var max = 0
	var generator = get_node("/root/Node3D/Generator") as Generator
	cols = generator.cols
	self.target = cols[col]
	
	while !curve_file.eof_reached():
		var values = curve_file.get_csv_line("\t")
		if values.size() > 1:
			var vv = Array()
			for v in values:
				vv.append(float(v))
				
			if vv[target] > max:
				max = vv[target]

			song_values.append(vv)

	for i in range(song_values.size()):
		xcurve.add_point(Vector2(i/song_values.size(), song_values[i][target] / max))
	
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
extends MeshInstance3D

@export var path3d_node_path: NodePath
var cooldown = 0

func _input(event):
	return
	if Input.is_key_label_pressed(KEY_2):
		if cooldown < 0:
			cooldown = 2
			build_path2()

func build_path2():
	var path3d = get_parent().get_child(0)
	var curve: Curve3D = path3d.curve
	var num_segments = 100
	var num_sides = 8
	var radius = 0.1

	var vertices = []
	var normals = []
	var uvs = []
	var indices = []

	for i in range(num_segments):
		var u = float(i) / num_segments
		var pos = curve.sample_baked(u)
		var tilt = curve.sample_baked_with_rotation(u)
		var normal = curve.sample_baked_up_vector(u)
		var binormal = normal.cross(Vector3.UP).normalized()

		for j in range(num_sides):
			var angle = (float(j) / num_sides) * 2 * PI
			var vertex_normal = (binormal * cos(angle) + normal.cross(binormal) * sin(angle)).normalized()
			var vertex_pos = pos + vertex_normal * radius * tilt
			var uv = Vector2(u, float(j) / num_sides)

			vertices.append(vertex_pos)
			normals.append(vertex_normal)
			uvs.append(uv)

	for i in range(num_segments - 1):
		for j in range(num_sides):
			indices.append((i * num_sides) + j)
			indices.append(((i + 1) % num_segments) * num_sides + j)
			indices.append((((i + 1) % num_segments) * num_sides) + ((j + 1) % num_sides))

			indices.append((i * num_sides) + j)
			indices.append((((i + 1) % num_segments) * num_sides) + ((j + 1) % num_sides))
			indices.append((i * num_sides) + ((j + 1) % num_sides))

	var mesh2 = ArrayMesh.new()
	var arrays = []
	arrays.resize(ArrayMesh.ARRAY_MAX)
	arrays[ArrayMesh.ARRAY_VERTEX] = vertices
	arrays[ArrayMesh.ARRAY_NORMAL] = normals
	arrays[ArrayMesh.ARRAY_TEX_UV] = uvs
	arrays[ArrayMesh.ARRAY_INDEX] = indices
	mesh2.add_surface_from_arrays(Mesh.PRIMITIVE_TRIANGLES, arrays)

	self.mesh = mesh2


func build_path():
	var path3d = get_parent().get_child(0)
	var curve: Curve3D = path3d.curve
	var mesh_data = SurfaceTool.new()
	var num_segments = 100
	var num_sides = 8
	var radius = 0.1
	
	mesh_data.begin(Mesh.PRIMITIVE_TRIANGLES)

	for i in range(num_segments):
		var u = float(i) / num_segments
		#curve.get_baked_points()
		var pos = curve.sample_baked(u)
		var tilt = curve.sample_baked_with_rotation(u)
		var normal = curve.sample_baked_up_vector(u)
		var binormal = normal.cross(Vector3.UP).normalized()

		for j in range(num_sides):
			var angle = (float(j) / num_sides) * 2 * PI
			var vertex_normal = (binormal * cos(angle) + normal.cross(binormal) * sin(angle)).normalized()
			var vertex_pos = pos + vertex_normal * radius * tilt
			var uv = Vector2(u, float(j) / num_sides)

			mesh_data.set_normal(vertex_normal)
			mesh_data.set_uv(uv)
			mesh_data.add_vertex(vertex_pos)
			#mesh_data.add_uv(uv)don'

	mesh_data.index()
	"""
	for i in range(num_segments - 1):
		for j in range(num_sides):
			var idx0 = i * num_sides + j
			var idx1 = i * num_sides + (j + 1) % num_sides
			var idx2 = (i + 1) * num_sides + j
			var idx3 = (i + 1) * num_sides + (j + 1) % num_sides

			mesh_data.add_index(idx0)
			mesh_data.add_index(idx1)
			mesh_data.add_index(idx2)
			mesh_data.add_index(idx1)
			mesh_data.add_index(idx3)
			mesh_data.add_index(idx2)
			#mesh_data.add_triangle_fan(PackedVector3Array(Array([idx0, idx1, idx2, idx1, idx3, idx2])))
			#mesh_data.add_triangle_fan()idx0, idx1, idx2)
			#mesh_data.add_triangle(idx1, idx3, idx2)
	"""
			
	for i in range(num_segments - 1):
		for j in range(num_sides):
			mesh_data.add_index(i * num_sides + j)
			mesh_data.add_index(((i + 1) % num_segments) * num_sides + j)
			mesh_data.add_index(((i + 1) % num_segments) * num_sides + (j + 1) % num_sides)
			mesh_data.add_index(i * num_sides + j)
			mesh_data.add_index(((i + 1) % num_segments) * num_sides + (j + 1) % num_sides)
			mesh_data.add_index(i * num_sides + (j + 1) % num_sides)

	var mesh = ArrayMesh.new()
	mesh_data.commit(mesh)
	self.mesh = mesh

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	cooldown -= delta
4&<extends Node3D
class_name PlayerNode

var speed = 0.2
var rotrate = 1

var move_dir: Vector2 # Input direction for movement
var up_down_dir := 0.0
var look_dir: Vector2 # Input direction for look/aim

@export_range(1, 100, 0.1) var acceleration: float = 1 # m/s^2

var walk_vel: Vector3 # Walking velocity 
var mouse_captured: bool = false

var should_hit = false
var repeat_action = false
var repeated_modif = Vector3i(0, 0, 0)
const RAY_LENGTH = 1000

var cooldown = 0.1
var panel_cooldown = 0
var click_cooldown = 0.0
var repeat_cooldown = 0

@export var current_hit: MeshInstance3D
@export var info_hit: MeshInstance3D
@export_range(0.1, 9.25, 0.05, "or_greater") var camera_sens: float = 2

@onready var camera: Camera3D = $Camera3D

@onready var label = $Label
@onready var label2 = $Label2

@onready var finger1: Sprite2D = $Finger1
@onready var finger2: Sprite2D = $Finger2
@onready var finger3: Sprite2D = $Finger3

@onready var panel: PanelContainer = $"/root/Node3D/UserControls/Info/PanelContainer"

@onready var generator_node: Generator = $"/root/Node3D/Generator"

var fingers = Array()
var os: String

# onready var label3 = $Label3
# onready var label4 = $Label4
# onready var label5 = $Label5

func _ready():
	fingers.append(finger1)
	fingers.append(finger2)
	fingers.append(finger3)
	
	os = OS.get_name()
	
	$Camera3D/CrossUp.position = get_viewport().size / 2
	$Camera3D/CrossDown.position = get_viewport().size / 2
	pass

#func display_finger(which, x, y):
#	if which == 0:
#		finger1.visible = true
#		#finger1.position = 

func _input(event):
	if (event is InputEventMouseMotion and os != "iOS") or event is InputEventSingleScreenDrag: look_dir = event.relative * 0.05

	#if event is InputEventAction and event.as_string() == ""
	
	if InputManager.real_raw and os == "iOS" and not event is InputEventMouseMotion and not event is InputEventKey and not event is InputEventMouseButton and not event is InputEventJoypadMotion and not event is InputEventJoypadButton:
		var a = event.as_string().replace('|','\n') 
		var b: RawGesture = InputManager.real_raw
		for i in range(b.drags.size()):
			if b.drags.values()[i]:
				var e = b.drags.values()[i]
				fingers[i].position = e.position
				if !fingers[i].visible:
					fingers[i].visible = true
				print("PRESSED!" + str(e.pressed))
		for i in range(b.releases.size()):
			if b.releases.values()[i]:
				var e = b.releases.values()[i]
				if fingers[i].visible:
					fingers[i].visible = false
				print("RELEASED!" + str(e.pressed))
		

	if (event is InputEventMultiScreenDrag or
		event is InputEventMultiScreenSwipe or
		event is InputEventMultiScreenTap or
		event is InputEventMultiScreenLongPress or
		event is InputEventSingleScreenDrag or
		event is InputEventScreenPinch or
		event is InputEventScreenTwist or
		event is InputEventSingleScreenTap or
		event is InputEventSingleScreenLongPress or
		event is InputEventSingleScreenTouch or
		event is InputEventSingleScreenSwipe or
		event is InputEventScreenCancel):
			label.text = event.as_string().replace('|','\n') 

	if event is InputEventMultiScreenDrag:
		if event.fingers == 2:
			up_down_dir += float(event.relative.y) / 2.0
			move_dir.x -= float(event.relative.x) / 2.0
			
		label2.text = "Multiple finger drag"
	elif event is InputEventMultiScreenSwipe:
		label2.text = "Multiple finger swipe"
	elif event is InputEventMultiScreenTap:
		label2.text = "Multiple finger tap"
	elif event is InputEventMultiScreenLongPress:
		label2.text = "Multiple finger long press"
	elif event is InputEventSingleScreenDrag: 
		label2.text = "Single finger drag"
	elif event is InputEventSingleScreenSwipe:
		label2.text = "Single finger swipe"
	elif event is InputEventScreenPinch:
		move_dir.y -= event.relative
		label2.text = "Pinch"
	elif event is InputEventScreenTwist:
		label2.text = "Twist"
	elif event is InputEventSingleScreenLongPress:
		var loc = Vector2(float(event.position.x) / float(get_viewport().size.x), float(event.position.y) / float(get_viewport().size.y))
		should_hit = true
		repeat_action = event.pressed

		process_hit(loc.x, loc.y)
		label2.text = "Single finger long press\nloc: " + str(loc.x) + ", " + str(loc.y)
	elif event is InputEventSingleScreenTap:
		if event.position.x < panel.size.x and event.position.y < panel.size.y and not panel.visible:
			panel.visible = true
			panel.self_modulate = Color(1, 1, 1, 1)
			panel_cooldown = 5
		else:
			var loc = Vector2(float(event.position.x) / float(get_viewport().size.x), float(event.position.y) / float(get_viewport().size.y))
			should_hit = true
			
			repeated_modif = Vector3i.ZERO
			process_hit(loc.x, loc.y)
			label2.text = "Single finger tap\nloc: " + str(loc.x) + ", " + str(loc.y)
			#label2.text = "Single finger tap"
	elif event is InputEventSingleScreenTouch:
		label2.text = "Single finger touch"
	elif event is InputEventScreenCancel:
		label2.text = "Cancel"

func process_hit(x, y):
	if should_hit:
		var loc = Vector2(x * float(get_viewport().size.x), y * float(get_viewport().size.y))
		var space_state = get_world_3d().direct_space_state
		var to = global_position + camera.project_ray_normal(loc) * RAY_LENGTH
		var query = PhysicsRayQueryParameters3D.create(global_position, to)
		query.exclude = [self]
		var result = space_state.intersect_ray(query)
		
		var obj := (result.get("collider") as StaticBody3D)
		if obj:
			if obj.get_parent():
				var new_hit = obj.get_parent()
				if new_hit != current_hit:
					current_hit = new_hit
					get_parent().get_parent().find_child("MusicPlayer").load_song()
				
				if new_hit.name.begins_with("_") and click_cooldown < 0.0:
					var pname: String = String(new_hit.name)
					var mdiff = 0
					
					if pname.contains("Dec"):
						mdiff = -1
					if pname.contains("Inc"):
						mdiff = 1

					if pname.ends_with("Z"):
						generator_node.axis_modif.z = mdiff
					if pname.ends_with("Y"):
						generator_node.axis_modif.y = mdiff
					if pname.ends_with("X"):
						generator_node.axis_modif.x = mdiff
						
					print("Added to generator node")
					if repeat_action:
						repeated_modif = Vector3i(generator_node.axis_modif)
					click_cooldown = 0.15
						
				print(obj.get_parent())
		else:
			current_hit = null
	
	#print(result)
	should_hit = false

func _physics_process(delta):
	click_cooldown -= delta
	repeat_cooldown -= delta
	if repeat_cooldown < 0.0 and repeat_action:
		repeat_cooldown += 0.1
		generator_node.axis_modif += repeated_modif
			
	
	if panel.visible:
		panel_cooldown -= delta
		if panel_cooldown <= 0:
			panel.visible = false
			panel.self_modulate = Color(1, 1, 1, 0)
	
	if Input.is_key_pressed(KEY_SPACE):
		should_hit = true
		process_hit(0.5, 0.5)
	else:
		cooldown -= delta
		if cooldown < 0:
			cooldown += 0.2
			var space_state = get_world_3d().direct_space_state
			var to = global_position + camera.project_ray_normal(get_viewport().size / 2) * RAY_LENGTH
			var query = PhysicsRayQueryParameters3D.create(global_position, to)
			query.exclude = [self]
			var result = space_state.intersect_ray(query)
			
			var obj := (result.get("collider") as StaticBody3D)
			if obj:
				if obj.get_parent():
					var new_hit = obj.get_parent()
					if new_hit != info_hit:
						info_hit = new_hit
						get_parent().get_parent().find_child("MusicPlayer").load_temp_info()
					#print(obj.get_parent())
			else:
				if info_hit:
					(get_parent().get_parent().find_child("InfoCard") as Label3D).visible = false
				info_hit = null
			
			#print(result)
			#should_hit = false
	
	_rotate_camera(delta)
	position += _walk(delta)

func capture_mouse() -> void:
	Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
	mouse_captured = true

func release_mouse() -> void:
	Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
	mouse_captured = false

func _walk(delta: float) -> Vector3:
	#if !mouse_captured:
	#	capture_mouse()
	move_dir += Input.get_vector("move_left", "move_right", "move_forwards", "move_backwards")
	#var up_down_dir = 1.0 if Input.is_key_pressed(KEY_E) else 0.0
	#if Input.is_key_pressed(KEY_Q):
	#	up_down_dir = -1.0
	
	#move_dir = Input.get_vector(KEY_LEFT, "move_right", "move_forward", "move_backwards")
	var _forward: Vector3 = camera.transform.basis * Vector3(move_dir.x, up_down_dir, move_dir.y)
	var walk_dir: Vector3 = Vector3(_forward.x, _forward.y, _forward.z).normalized()
	walk_vel = walk_vel.move_toward(walk_dir * speed * move_dir.length(), acceleration * delta)
	move_dir = Vector2(0, 0)
	up_down_dir = 0
	return walk_vel

func _rotate_camera(delta: float, sens_mod: float = 1.0) -> void:
	look_dir += Input.get_vector("ui_left","ui_right","ui_up","ui_down")
	camera.rotation.y -= look_dir.x * camera_sens * sens_mod * delta
	camera.rotation.x = clamp(camera.rotation.x - look_dir.y * camera_sens * sens_mod * delta, -1.5, 1.5)
	look_dir = Vector2.ZERO
	
Speech
Male speech, man speaking
Female speech, woman speaking
Child speech, kid speaking
Conversation
Narration, monologue
Babbling
Speech synthesizer
Shout
Bellow
Whoop
Yell
Battle cry
Children shouting
Screaming
Whispering
Laughter
Baby laughter
Giggle
Snicker
Belly laugh
Chuckle, chortle
Crying, sobbing
Baby cry, infant cry
Whimper
Wail, moan
Sigh
Singing
Choir
Yodeling
Chant
Mantra
Male singing
Female singing
Child singing
Synthetic singing
Rapping
Humming
Groan
Grunt
Whistling
Breathing
Wheeze
Snoring
Gasp
Pant
Snort
Cough
Throat clearing
Sneeze
Sniff
Run
Shuffle
Walk, footsteps
Chewing, mastication
Biting
Gargling
Stomach rumble
Burping, eructation
Hiccup
Fart
Hands
Finger snapping
Clapping
Heart sounds, heartbeat
Heart murmur
Cheering
Applause
Chatter
Crowd
Hubbub, speech noise, speech babble
Children playing
Animal
Domestic animals, pets
Dog
Bark
Yip
Howl
Bow-wow
Growling
Whimper (dog)
Cat
Purr
Meow
Hiss
Caterwaul
Livestock, farm animals, working animals
Horse
Clip-clop
Neigh, whinny
Cattle, bovinae
Moo
Cowbell
Pig
Oink
Goat
Bleat
Sheep
Fowl
Chicken, rooster
Cluck
Crowing, cock-a-doodle-doo
Turkey
Gobble
Duck
Quack
Goose
Honk
Wild animals
Roaring cats (lions, tigers)
Roar
Bird
Bird vocalization, bird call, bird song
Chirp, tweet
Squawk
Pigeon, dove
Coo
Crow
Caw
Owl
Hoot
Bird flight, flapping wings
Canidae, dogs, wolves
Rodents, rats, mice
Mouse
Patter
Insect
Cricket
Mosquito
Fly, housefly
Buzz
Bee, wasp, etc.
Frog
Croak
Snake
Rattle
Whale vocalization
Music
Musical instrument
Plucked string instrument
Guitar
Electric guitar
Bass guitar
Acoustic guitar
Steel guitar, slide guitar
Tapping (guitar technique)
Strum
Banjo
Sitar
Mandolin
Zither
Ukulele
Keyboard (musical)
Piano
Electric piano
Organ
Electronic organ
Hammond organ
Synthesizer
Sampler
Harpsichord
Percussion
Drum kit
Drum machine
Drum
Snare drum
Rimshot
Drum roll
Bass drum
Timpani
Tabla
Cymbal
Hi-hat
Wood block
Tambourine
Rattle (instrument)
Maraca
Gong
Tubular bells
Mallet percussion
Marimba, xylophone
Glockenspiel
Vibraphone
Steelpan
Orchestra
Brass instrument
French horn
Trumpet
Trombone
Bowed string instrument
String section
Violin, fiddle
Pizzicato
Cello
Double bass
Wind instrument, woodwind instrument
Flute
Saxophone
Clarinet
Harp
Bell
Church bell
Jingle bell
Bicycle bell
Tuning fork
Chime
Wind chime
Change ringing (campanology)
Harmonica
Accordion
Bagpipes
Didgeridoo
Shofar
Theremin
Singing bowl
Scratching (performance technique)
Pop music
Hip hop music
Beatboxing
Rock music
Heavy metal
Punk rock
Grunge
Progressive rock
Rock and roll
Psychedelic rock
Rhythm and blues
Soul music
Reggae
Country
Swing music
Bluegrass
Funk
Folk music
Middle Eastern music
Jazz
Disco
Classical music
Opera
Electronic music
House music
Techno
Dubstep
Drum and bass
Electronica
Electronic dance music
Ambient music
Trance music
Music of Latin America
Salsa music
Flamenco
Blues
Music for children
New-age music
Vocal music
A capella
Music of Africa
Afrobeat
Christian music
Gospel music
Music of Asia
Carnatic music
Music of Bollywood
Ska
Traditional music
Independent music
Song
Background music
Theme music
Jingle (music)
Soundtrack music
Lullaby
Video game music
Christmas music
Dance music
Wedding music
Happy music
Funny music
Sad music
Tender music
Exciting music
Angry music
Scary music
Wind
Rustling leaves
Wind noise (microphone)
Thunderstorm
Thunder
Water
Rain
Raindrop
Rain on surface
Stream
Waterfall
Ocean
Waves, surf
Steam
Gurgling
Fire
Crackle
Vehicle
Boat, Water vehicle
Sailboat, sailing ship
Rowboat, canoe, kayak
Motorboat, speedboat
Ship
Motor vehicle (road)
Car
Vehicle horn, car horn, honking
Toot
Car alarm
Power windows, electric windows
Skidding
Tire squeal
Car passing by
Race car, auto racing
Truck
Air brake
Air horn, truck horn
Reversing beeps
Ice cream truck, ice cream van
Bus
Emergency vehicle
Police car (siren)
Ambulance (siren)
Fire engine, fire truck (siren)
Motorcycle
Traffic noise, roadway noise
Rail transport
Train
Train whistle
Train horn
Railroad car, train wagon
Train wheels squealing
Subway, metro, underground
Aircraft
Aircraft engine
Jet engine
Propeller, airscrew
Helicopter
Fixed-wing aircraft, airplane
Bicycle
Skateboard
Engine
Light engine (high frequency)
Dental drill, dentist's drill
Lawn mower
Chainsaw
Medium engine (mid frequency)
Heavy engine (low frequency)
Engine knocking
Engine starting
Idling
Accelerating, revving, vroom
Door
Doorbell
Ding-dong
Sliding door
Slam
Knock
Tap
Squeak
Cupboard open or close
Drawer open or close
Dishes, pots, and pans
Cutlery, silverware
Chopping (food)
Frying (food)
Microwave oven
Blender
Water tap, faucet
Sink (filling or washing)
Bathtub (filling or washing)
Hair dryer
Toilet flush
Toothbrush
Electric toothbrush
Vacuum cleaner
Zipper (clothing)
Keys jangling
Coin (dropping)
Scissors
Electric shaver, electric razor
Shuffling cards
Typing
Typewriter
Computer keyboard
Writing
Alarm
Telephone
Telephone bell ringing
Ringtone
Telephone dialing, DTMF
Dial tone
Busy signal
Alarm clock
Siren
Civil defense siren
Buzzer
Smoke detector, smoke alarm
Fire alarm
Foghorn
Whistle
Steam whistle
Mechanisms
Ratchet, pawl
Clock
Tick
Tick-tock
Gears
Pulleys
Sewing machine
Mechanical fan
Air conditioning
Cash register
Printer
Camera
Single-lens reflex camera
Tools
Hammer
Jackhammer
Sawing
Filing (rasp)
Sanding
Power tool
Drill
Explosion
Gunshot, gunfire
Machine gun
Fusillade
Artillery fire
Cap gun
Fireworks
Firecracker
Burst, pop
Eruption
Boom
Wood
Chop
Splinter
Crack
Glass
Chink, clink
Shatter
Liquid
Splash, splatter
Slosh
Squish
Drip
Pour
Trickle, dribble
Gush
Fill (with liquid)
Spray
Pump (liquid)
Stir
Boiling
Sonar
Arrow
Whoosh, swoosh, swish
Thump, thud
Thunk
Electronic tuner
Effects unit
Chorus effect
Basketball bounce
Bang
Slap, smack
Whack, thwack
Smash, crash
Breaking
Bouncing
Whip
Flap
Scratch
Scrape
Rub
Roll
Crushing
Crumpling, crinkling
Tearing
Beep, bleep
Ping
Ding
Clang
Squeal
Creak
Rustle
Whir
Clatter
Sizzle
Clicking
Clickety-clack
Rumble
Plop
Jingle, tinkle
Hum
Zing
Boing
Crunch
Silence
Sine wave
Harmonic
Chirp tone
Sound effect
Pulse
Inside, small room
Inside, large room or hall
Inside, public space
Outside, urban or manmade
Outside, rural or natural
Reverberation
Echo
Noise
Environmental noise
Static
Mains hum
Distortion
Sidetone
Cacophony
White noise
Pink noise
Throbbing
Vibration
Television
Radio
Field recording
pr
>147116100 - Weval - Half Age EP - Out Of The Game	147116100	0.019647	0.000300	0.000153	0.000451	0.000043	0.000123	0.000153	0.000044	0.000173	0.000106	0.000135	0.000085	0.000064	0.000056	0.000299	0.000339	0.000276	0.000215	0.000172	0.000075	0.000168	0.000057	0.000307	0.000264	0.000271	0.000071	0.000419	0.026808	0.000472	0.000084	0.000284	0.000316	0.000656	0.000530	0.000126	0.000404	0.000914	0.000377	0.000218	0.000027	0.000644	0.000566	0.000213	0.000162	0.000280	0.000052	0.000334	0.000341	0.000235	0.000425	0.000183	0.000038	0.000015	0.000066	0.000125	0.000097	0.000010	0.000116	0.000213	0.000142	0.000126	0.000052	0.000083	0.000083	0.002327	0.004527	0.000138	0.000026	0.000019	0.000408	0.000039	0.000014	0.002661	0.001808	0.001117	0.000263	0.000226	0.000378	0.000206	0.000149	0.000181	0.000391	0.000105	0.000194	0.000272	0.000065	0.000283	0.000116	0.000094	0.000052	0.000095	0.000093	0.000347	0.000085	0.000103	0.000117	0.000161	0.000150	0.000622	0.000449	0.000210	0.000500	0.000099	0.000104	0.000093	0.000119	0.000117	0.000105	0.000058	0.000048	0.000129	0.000890	0.000365	0.000275	0.000025	0.000121	0.000103	0.000144	0.000152	0.000458	0.000104	0.000040	0.000339	0.000080	0.000081	0.000061	0.000500	0.000248	0.000138	0.000208	0.000392	0.000102	0.000325	0.000139	0.000058	0.000177	0.000058	0.680530	0.061369	0.003774	0.004816	0.000994	0.002096	0.000729	0.000648	0.000158	0.000414	0.000201	0.000113	0.000195	0.000392	0.000277	0.061569	0.052630	0.093078	0.001527	0.002297	0.000499	0.190980	0.061173	0.000892	0.003661	0.011048	0.082326	0.012111	0.003937	0.002646	0.000963	0.007456	0.000574	0.000098	0.003310	0.002898	0.000348	0.000097	0.000036	0.000048	0.000734	0.000220	0.000903	0.001129	0.001287	0.000332	0.000076	0.000378	0.000803	0.000239	0.000504	0.000245	0.000590	0.000057	0.000552	0.000769	0.000214	0.000197	0.000851	0.000724	0.000275	0.000201	0.000783	0.000577	0.000283	0.000156	0.000130	0.000149	0.000528	0.000266	0.000060	0.000360	0.000149	0.000064	0.000295	0.000238	0.003316	0.001476	0.000278	0.013537	0.010856	0.000200	0.004442	0.001217	0.001276	0.001309	0.002236	0.000835	0.000550	0.010781	0.009407	0.002342	0.000678	0.000642	0.000192	0.004869	0.000409	0.000976	0.002230	0.003314	0.000757	0.000164	0.114518	0.015275	0.010238	0.026855	0.038141	0.040815	0.010546	0.069549	0.017149	0.000537	0.000182	0.000124	0.002903	0.000642	0.009778	0.000948	0.000208	0.001418	0.000978	0.002043	0.002305	0.001456	0.000106	0.000288	0.000527	0.000171	0.010740	0.005497	0.004203	0.002713	0.000944	0.005909	0.001174	0.000740	0.000937	0.003793	0.000320	0.001244	0.000251	0.001215	0.006379	0.002707	0.000401	0.000160	0.000175	0.000131	0.000168	0.000065	0.000082	0.000353	0.000062	0.000044	0.000048	0.000098	0.000062	0.000071	0.000055	0.000252	0.000174	0.000047	0.000061	0.002533	0.000229	0.000048	0.000097	0.000118	0.000028	0.000133	0.000547	0.000657	0.000118	0.000085	0.000011	0.000038	0.000053	0.000058	0.000128	0.000154	0.000035	0.000247	0.000022	0.000051	0.000042	0.000202	0.000188	0.000107	0.000069	0.000212	0.000027	0.000331	0.000449	0.000177	0.000173	0.000303	0.000008	0.000058	0.000247	0.000037	0.000071	0.000069	0.000130	0.000156	0.000278	0.000195	0.000256	0.000017	0.000057	0.000048	0.000063	0.000077	0.000065	0.000017	0.000058	0.000074	0.000169	0.000167	0.000309	0.000938	0.000066	0.000082	0.000081	0.000134	0.000167	0.000019	0.000037	0.000140	0.000096	0.000019	0.000049	0.000111	0.000071	0.000112	0.000086	0.000082	0.000045	0.000057	0.000005	0.000060	0.000072	0.000034	0.000206	0.000062	0.000055	0.000206	0.000019	0.000105	0.000041	0.000141	0.000092	0.001357	0.000559	0.000230	0.002401	0.000194	0.001078	0.000910	0.000804	0.000620	0.000124	0.000623	0.001516	0.003288	0.000073	0.001185	0.000245	0.000115	0.000055	0.000378	0.000371	0.000420	0.000044	0.000013	0.000043	0.000138	0.000026	0.000069	0.000092	0.000076	0.000146	0.000604	0.000076	0.000021	0.000064	0.000065	0.000013	0.000263	0.000326	0.000167	0.000204	0.000061	0.000023	0.000024	0.000199	0.000120	0.000070	0.000292	0.000049	0.000056	0.000203	0.000174	0.000012	0.000028	0.000249	0.000152	0.000033	0.000201	0.000034	0.000042	0.000141	0.000259	0.000023	0.000127	0.000059	0.000067	0.000259	0.000067	0.000024	0.000038	0.000946	0.000125	0.000326	0.000116	0.000064	0.004506	0.013571	0.007332	0.000084	0.000048	0.000167	0.000043	0.000030	0.000056	0.000139	0.000061	0.000054	0.000108	0.000043	0.000147	0.000542	0.000012	0.000046	0.000027	0.001544	0.000464	0.000522	0.000209	0.000018	0.000013	0.000282	0.000029	0.000179	0.000055	0.000228	0.000060	0.000196	0.000159	0.000261	0.009228	0.000804	0.000284	0.000051	0.005710	0.002756	0.003214	0.000873	0.004123	0.001262	0.011117	0.004621	0.000497	0.001407	0.001723	0.005328	0.017659	0.000158	0.000186	0.001968	0.000610	0.004742	0.003796	0.000187	0.000315	0.000057	0.013098	0.000157	0.000236	0.000331	0.000034
147116101 - Weval - Half Age EP - Detian	147116101	0.010539	0.000195	0.000174	0.000282	0.000067	0.000147	0.000067	0.000059	0.000118	0.000056	0.000113	0.000031	0.000050	0.000029	0.000143	0.000231	0.000230	0.000071	0.000113	0.000069	0.000079	0.000068	0.000084	0.000077	0.000075	0.000038	0.000057	0.001084	0.000107	0.000045	0.000044	0.000071	0.000154	0.000174	0.000066	0.000108	0.000209	0.000040	0.000113	0.000014	0.000323	0.000205	0.000034	0.000078	0.000085	0.000044	0.000200	0.000088	0.000064	0.000167	0.000109	0.000051	0.000035	0.000110	0.000272	0.000199	0.000011	0.000108	0.000087	0.000151	0.000182	0.000086	0.000236	0.000169	0.000520	0.000970	0.000102	0.000067	0.000025	0.000355	0.000079	0.000010	0.001576	0.000969	0.000682	0.000212	0.000151	0.000211	0.000184	0.000063	0.000107	0.000239	0.000060	0.000126	0.000447	0.000052	0.000150	0.000079	0.000068	0.000023	0.000038	0.000037	0.000151	0.000044	0.000072	0.000059	0.000093	0.000083	0.000351	0.000195	0.000104	0.000121	0.000078	0.000073	0.000130	0.000147	0.000099	0.000086	0.000040	0.000027	0.000066	0.000740	0.000261	0.000229	0.000020	0.000106	0.000071	0.000136	0.000115	0.000103	0.000036	0.000019	0.000215	0.000109	0.000116	0.000122	0.000527	0.000137	0.000141	0.000214	0.000577	0.000098	0.000263	0.000118	0.000137	0.001311	0.000060	0.827425	0.040761	0.002690	0.003124	0.000640	0.000583	0.000404	0.000147	0.000192	0.000405	0.000313	0.000174	0.000197	0.000214	0.000267	0.012413	0.009752	0.006213	0.001165	0.001287	0.000489	0.078532	0.075335	0.000498	0.002333	0.003514	0.075739	0.006267	0.001052	0.000685	0.000494	0.002567	0.000380	0.000141	0.000733	0.000637	0.000659	0.000125	0.000149	0.000098	0.000426	0.000240	0.000463	0.000735	0.000527	0.000225	0.000095	0.000422	0.000690	0.000282	0.000412	0.000203	0.000476	0.000054	0.000657	0.000407	0.000150	0.000100	0.001658	0.000792	0.000194	0.000248	0.000246	0.000396	0.000211	0.000271	0.000056	0.000163	0.000335	0.000197	0.000057	0.000307	0.000310	0.000144	0.000149	0.000487	0.002140	0.000755	0.000844	0.012115	0.005135	0.000156	0.002092	0.000600	0.000647	0.000426	0.001169	0.000750	0.000208	0.012144	0.004078	0.001831	0.000995	0.000466	0.000338	0.007710	0.000381	0.001484	0.002965	0.023373	0.000809	0.000075	0.249838	0.144394	0.090259	0.017422	0.037453	0.277609	0.063102	0.024514	0.191617	0.000333	0.000163	0.000134	0.003752	0.000275	0.004905	0.000199	0.000047	0.001515	0.001629	0.000487	0.000516	0.000310	0.000109	0.000127	0.000393	0.000409	0.004320	0.000906	0.009511	0.005632	0.001484	0.019815	0.000326	0.002428	0.000447	0.023707	0.000127	0.004022	0.000915	0.000331	0.003187	0.015499	0.000072	0.000167	0.000182	0.000220	0.000165	0.000056	0.000074	0.000373	0.000086	0.000093	0.000074	0.000119	0.000047	0.000104	0.000077	0.000296	0.000278	0.000103	0.000316	0.002602	0.000227	0.000056	0.000105	0.000094	0.000027	0.000220	0.000898	0.000751	0.000194	0.000188	0.000021	0.000059	0.000072	0.000113	0.000118	0.000180	0.000052	0.000347	0.000020	0.000050	0.000056	0.000248	0.000164	0.000114	0.000126	0.000197	0.000056	0.000183	0.000258	0.000133	0.000123	0.000168	0.000004	0.000038	0.000126	0.000024	0.000048	0.000035	0.000057	0.000087	0.000326	0.000106	0.000247	0.000015	0.000031	0.000031	0.000042	0.000104	0.000059	0.000020	0.000110	0.000079	0.000238	0.000228	0.000078	0.000223	0.000127	0.000076	0.000104	0.000258	0.000082	0.000017	0.000068	0.000190	0.000106	0.000042	0.000116	0.000135	0.000033	0.000168	0.000121	0.000063	0.000044	0.000060	0.000026	0.000054	0.000049	0.000219	0.000747	0.000167	0.000120	0.000152	0.000101	0.000275	0.000103	0.000329	0.000115	0.000729	0.000890	0.000222	0.005551	0.000451	0.001065	0.001125	0.000376	0.000961	0.000373	0.000618	0.000629	0.000942	0.000153	0.000837	0.000250	0.000272	0.000109	0.000325	0.000688	0.000734	0.000102	0.000025	0.000040	0.000156	0.000017	0.000068	0.000049	0.000250	0.000623	0.000363	0.000058	0.000011	0.000047	0.000054	0.000017	0.000108	0.000136	0.000232	0.000348	0.000078	0.000015	0.000035	0.000425	0.000140	0.000107	0.000416	0.000095	0.000033	0.000216	0.000183	0.000013	0.000060	0.000261	0.000335	0.000019	0.000490	0.000036	0.000069	0.000987	0.002523	0.000056	0.000165	0.000132	0.000218	0.001611	0.000036	0.000059	0.000045	0.001064	0.000145	0.000598	0.000076	0.000056	0.000384	0.002515	0.000564	0.000040	0.000044	0.000179	0.000034	0.000030	0.000051	0.000070	0.000091	0.000128	0.000225	0.000281	0.000123	0.000794	0.000023	0.000063	0.000037	0.001368	0.000615	0.000327	0.000113	0.000018	0.000030	0.001226	0.000045	0.000651	0.000179	0.000287	0.000036	0.000315	0.000753	0.000305	0.005823	0.000563	0.000245	0.000075	0.003873	0.002497	0.006732	0.000577	0.010949	0.002896	0.005120	0.001395	0.000246	0.000897	0.001144	0.001802	0.009605	0.000150	0.000153	0.008184	0.000366	0.000928	0.001112	0.000209	0.000617	0.000078	0.012495	0.000237	0.000774	0.000678	0.000069
147116102 - Weval - Half Age EP - The Most	147116102	0.020308	0.000283	0.000271	0.000387	0.000047	0.000191	0.000134	0.000044	0.000205	0.000140	0.000294	0.000102	0.000060	0.000036	0.000258	0.000487	0.000292	0.000151	0.000165	0.000069	0.000108	0.000071	0.000192	0.000173	0.000253	0.000090	0.000307	0.026752	0.000396	0.000240	0.000166	0.000288	0.000858	0.001203	0.000253	0.000418	0.000648	0.000400	0.000198	0.000014	0.000772	0.000426	0.000105	0.000161	0.000252	0.000092	0.000377	0.000161	0.000124	0.000218	0.000122	0.000109	0.000158	0.000249	0.000219	0.000225	0.000020	0.000186	0.000092	0.000187	0.000119	0.000075	0.000027	0.000100	0.000583	0.000610	0.000194	0.000128	0.000030	0.000585	0.000114	0.000013	0.003823	0.002668	0.001954	0.000488	0.000495	0.000557	0.000583	0.000125	0.000366	0.000400	0.000156	0.000213	0.000890	0.000074	0.000281	0.000211	0.000193	0.000042	0.000070	0.000068	0.000162	0.000055	0.000114	0.000100	0.000208	0.000181	0.000621	0.000331	0.000151	0.000230	0.000162	0.000144	0.000216	0.000274	0.000121	0.000125	0.000060	0.000036	0.000094	0.001152	0.000515	0.000468	0.000051	0.000163	0.000118	0.000197	0.000178	0.000334	0.000133	0.000029	0.000568	0.000221	0.000191	0.000140	0.000670	0.000338	0.000100	0.000188	0.001709	0.000123	0.000332	0.000111	0.000166	0.001786	0.000072	0.716563	0.053439	0.004248	0.005369	0.000841	0.001327	0.001289	0.000627	0.000115	0.000787	0.000302	0.000120	0.000258	0.000430	0.000378	0.025319	0.022035	0.021279	0.001454	0.001265	0.000517	0.054305	0.054820	0.001280	0.006873	0.012540	0.065016	0.015940	0.006002	0.003465	0.002046	0.009322	0.002087	0.000091	0.003641	0.003618	0.000721	0.000545	0.000340	0.000320	0.001031	0.000269	0.000568	0.000774	0.000679	0.000285	0.000103	0.001222	0.004381	0.000724	0.002534	0.001576	0.000662	0.000081	0.000523	0.000797	0.000281	0.000333	0.003018	0.001553	0.000830	0.000283	0.000360	0.001029	0.000479	0.001940	0.000157	0.000215	0.000436	0.000230	0.000056	0.000466	0.000418	0.000084	0.000362	0.001531	0.003127	0.000655	0.000750	0.034737	0.006819	0.000163	0.003689	0.000925	0.001436	0.001252	0.002188	0.001890	0.000959	0.019008	0.010255	0.002791	0.001465	0.003356	0.000428	0.012569	0.000589	0.001378	0.007306	0.027224	0.001385	0.000285	0.145538	0.102468	0.040287	0.019165	0.018966	0.077870	0.084878	0.012839	0.048660	0.000913	0.000269	0.000219	0.004877	0.001564	0.004269	0.000488	0.000110	0.001734	0.002591	0.002249	0.001947	0.004224	0.000125	0.000363	0.001219	0.000454	0.012685	0.009279	0.006033	0.003976	0.003398	0.010658	0.001459	0.000773	0.002225	0.026954	0.000393	0.004221	0.000906	0.001276	0.008319	0.011695	0.000190	0.000211	0.000295	0.000775	0.000243	0.000105	0.000135	0.000457	0.000226	0.000230	0.000222	0.000438	0.000225	0.000228	0.000188	0.000846	0.000523	0.000112	0.000296	0.005167	0.000588	0.000141	0.000271	0.000232	0.000107	0.000238	0.001109	0.001458	0.000184	0.000151	0.000012	0.000052	0.000083	0.000197	0.000152	0.000250	0.000072	0.000891	0.000017	0.000030	0.000069	0.000243	0.000179	0.000088	0.000125	0.000210	0.000042	0.000462	0.000715	0.000253	0.000243	0.000407	0.000007	0.000053	0.000223	0.000041	0.000078	0.000090	0.000077	0.000156	0.000727	0.000364	0.000403	0.000014	0.000024	0.000040	0.000014	0.000157	0.000137	0.000019	0.000108	0.000127	0.000289	0.000344	0.000176	0.000518	0.000163	0.000166	0.000104	0.000300	0.000420	0.000035	0.000061	0.000125	0.000094	0.000018	0.000160	0.000409	0.000031	0.000125	0.000100	0.000055	0.000042	0.000087	0.000018	0.000026	0.000036	0.000245	0.000576	0.000082	0.000130	0.000125	0.000027	0.000137	0.000064	0.000156	0.000241	0.001468	0.000316	0.000153	0.000990	0.000129	0.000561	0.000382	0.000705	0.001558	0.000664	0.001282	0.001622	0.002226	0.000391	0.004184	0.000849	0.000128	0.000045	0.000446	0.000653	0.000760	0.000037	0.000013	0.000033	0.000225	0.000047	0.000055	0.000104	0.000151	0.000279	0.000270	0.000040	0.000009	0.000030	0.000040	0.000018	0.000093	0.000126	0.000400	0.000275	0.000086	0.000035	0.000107	0.000154	0.000162	0.000089	0.000848	0.000161	0.000046	0.000083	0.000081	0.000003	0.000026	0.000143	0.000228	0.000045	0.000363	0.000047	0.000110	0.000565	0.000972	0.000050	0.000424	0.000121	0.000145	0.001282	0.000085	0.000070	0.000133	0.000965	0.000221	0.001401	0.000154	0.000092	0.001944	0.003789	0.001058	0.000149	0.000156	0.000126	0.000048	0.000035	0.000036	0.000112	0.000130	0.000241	0.000374	0.000325	0.000101	0.001584	0.000006	0.000059	0.000050	0.002012	0.001009	0.000784	0.000187	0.000059	0.000023	0.002629	0.000070	0.001083	0.000287	0.000214	0.000068	0.000318	0.000261	0.000817	0.004673	0.001382	0.000637	0.000065	0.007635	0.004907	0.004394	0.001360	0.012556	0.001313	0.007723	0.004441	0.000831	0.002120	0.002739	0.003905	0.016534	0.000361	0.000366	0.008467	0.000435	0.001849	0.001586	0.000521	0.002766	0.000366	0.007250	0.000435	0.000430	0.000563	0.000170
147116103 - Weval - Half Age EP - Somewhere	147116103	0.013897	0.000227	0.000302	0.000459	0.000041	0.000163	0.000169	0.000074	0.000197	0.000148	0.000258	0.000103	0.000029	0.000041	0.000365	0.000846	0.000255	0.000203	0.000167	0.000124	0.000103	0.000090	0.000250	0.000189	0.000303	0.000047	0.000405	0.022344	0.002376	0.002009	0.000467	0.001331	0.003613	0.006059	0.000710	0.018225	0.000059	0.003204	0.000127	0.000022	0.008485	0.001711	0.000147	0.000930	0.000156	0.000173	0.000870	0.000106	0.000096	0.000240	0.000032	0.000051	0.000242	0.000164	0.000294	0.000146	0.000011	0.000059	0.000025	0.000212	0.000060	0.000076	0.000114	0.000039	0.000094	0.000080	0.000134	0.000039	0.000028	0.000406	0.000071	0.000027	0.014227	0.005613	0.004180	0.000834	0.000824	0.001640	0.000931	0.000167	0.000671	0.001218	0.000211	0.000655	0.005996	0.000228	0.001097	0.000466	0.000295	0.000256	0.000205	0.000189	0.000083	0.000164	0.000196	0.000294	0.000462	0.000604	0.005276	0.001953	0.000904	0.000744	0.002064	0.001663	0.002918	0.003707	0.001358	0.001575	0.000251	0.000055	0.000104	0.005767	0.002016	0.001363	0.000302	0.000369	0.000352	0.002666	0.002739	0.002638	0.000297	0.000087	0.001071	0.000744	0.000722	0.000171	0.001443	0.000881	0.000221	0.000375	0.001518	0.000279	0.003175	0.000815	0.000664	0.001282	0.000227	0.582875	0.029762	0.002505	0.003165	0.000477	0.000402	0.000463	0.000245	0.000086	0.000407	0.000114	0.000121	0.000081	0.000196	0.000427	0.007338	0.006143	0.002652	0.003326	0.003405	0.001249	0.005462	0.001717	0.000669	0.006202	0.000554	0.000349	0.000970	0.000243	0.000110	0.000119	0.000267	0.000278	0.000042	0.000303	0.000207	0.000388	0.000570	0.000436	0.000278	0.000772	0.005598	0.072037	0.101877	0.080818	0.017945	0.000168	0.004251	0.001205	0.000433	0.000330	0.000365	0.001150	0.000252	0.000820	0.000425	0.000475	0.000292	0.002345	0.005406	0.000206	0.000228	0.000823	0.002712	0.000346	0.002371	0.000266	0.001338	0.018413	0.005562	0.000085	0.000170	0.000229	0.000056	0.001071	0.000185	0.026431	0.014824	0.000220	0.001284	0.000249	0.000069	0.000784	0.000414	0.000173	0.000072	0.000356	0.000236	0.000096	0.000525	0.000909	0.000141	0.000394	0.000070	0.000103	0.000093	0.000686	0.000601	0.000777	0.000226	0.005792	0.006316	0.015473	0.001270	0.001778	0.002452	0.000893	0.003018	0.001475	0.011028	0.002455	0.000436	0.000090	0.000101	0.000469	0.000595	0.006849	0.001477	0.000721	0.000150	0.000054	0.005464	0.002367	0.001714	0.000235	0.000068	0.000058	0.001111	0.001429	0.002226	0.002990	0.002958	0.002283	0.004187	0.012014	0.001101	0.005034	0.000517	0.000943	0.000418	0.000428	0.001868	0.005194	0.000655	0.000106	0.000753	0.000151	0.001698	0.000141	0.000071	0.000078	0.000349	0.000269	0.000202	0.000264	0.000180	0.000212	0.000071	0.000053	0.004717	0.000260	0.000163	0.000303	0.004805	0.000214	0.000060	0.000071	0.000130	0.000041	0.000291	0.000936	0.000840	0.000105	0.000430	0.000018	0.000055	0.000100	0.000168	0.000127	0.000479	0.000180	0.000151	0.000145	0.000682	0.000082	0.000585	0.000677	0.000264	0.000239	0.000162	0.000094	0.001219	0.001877	0.001333	0.000527	0.000962	0.000038	0.000100	0.000405	0.000055	0.000329	0.000101	0.000489	0.000174	0.000325	0.000009	0.001097	0.000015	0.000294	0.000047	0.000050	0.000370	0.000335	0.000027	0.000147	0.000248	0.000375	0.000350	0.000363	0.001104	0.000205	0.000094	0.000065	0.000283	0.000175	0.000006	0.000041	0.000093	0.000061	0.000016	0.000202	0.000268	0.000104	0.000187	0.000131	0.000096	0.000104	0.000020	0.000089	0.000140	0.000343	0.000137	0.000421	0.000037	0.000088	0.000329	0.000029	0.000147	0.000051	0.000164	0.000311	0.001073	0.000748	0.000278	0.001806	0.000245	0.000427	0.000202	0.000802	0.001279	0.000295	0.001380	0.000998	0.001252	0.000136	0.044153	0.004884	0.001130	0.000470	0.001552	0.001307	0.002555	0.000258	0.000085	0.000039	0.000384	0.000028	0.000039	0.000472	0.000356	0.000303	0.001419	0.000046	0.000020	0.000300	0.000098	0.000037	0.000599	0.000745	0.000150	0.000142	0.000046	0.000019	0.000051	0.000093	0.000207	0.000059	0.000359	0.000077	0.000022	0.000407	0.000143	0.000006	0.000086	0.001390	0.000616	0.000026	0.000138	0.000027	0.000100	0.000158	0.000252	0.000020	0.000123	0.000118	0.000087	0.000761	0.000101	0.000057	0.000056	0.009203	0.000396	0.002346	0.000079	0.000043	0.000315	0.001173	0.000484	0.000029	0.000091	0.000114	0.000096	0.000199	0.000082	0.000117	0.000300	0.000195	0.000174	0.000198	0.000300	0.000153	0.000016	0.000074	0.000059	0.001935	0.001579	0.001293	0.000176	0.000166	0.000042	0.004096	0.000294	0.001153	0.000411	0.000383	0.000109	0.000162	0.000265	0.002642	0.001248	0.000147	0.000166	0.000059	0.007593	0.009957	0.003352	0.001640	0.006826	0.000678	0.017481	0.014282	0.001484	0.001897	0.004262	0.003953	0.010836	0.000301	0.001042	0.001209	0.000452	0.000503	0.000522	0.000772	0.001433	0.000160	0.000448	0.000498	0.012118	0.003342	0.000134
147116104 - Weval - Half Age EP - Something	147116104	0.024171	0.000353	0.000267	0.000411	0.000080	0.000207	0.000102	0.000064	0.000283	0.000174	0.000322	0.000126	0.000051	0.000063	0.000250	0.000352	0.000233	0.000099	0.000102	0.000083	0.000076	0.000076	0.000126	0.000162	0.000228	0.000040	0.000508	0.015007	0.000304	0.000127	0.000245	0.000599	0.001170	0.000612	0.000146	0.000377	0.001185	0.000480	0.000208	0.000022	0.000578	0.001280	0.000194	0.000209	0.000407	0.000088	0.000742	0.000395	0.000205	0.000252	0.000423	0.000094	0.000134	0.000279	0.000183	0.000160	0.000015	0.000270	0.000119	0.000277	0.000234	0.000075	0.000052	0.000060	0.002705	0.003597	0.000226	0.000028	0.000033	0.000574	0.000143	0.000013	0.002883	0.001521	0.001161	0.000296	0.000286	0.000333	0.000341	0.000107	0.000193	0.000389	0.000134	0.000230	0.001902	0.000081	0.000314	0.000177	0.000145	0.000062	0.000119	0.000122	0.000086	0.000076	0.000141	0.000103	0.000322	0.000250	0.000637	0.000446	0.000203	0.000313	0.000136	0.000129	0.000181	0.000303	0.000115	0.000114	0.000049	0.000035	0.000089	0.000951	0.000341	0.000290	0.000045	0.000113	0.000105	0.000269	0.000254	0.000567	0.000133	0.000028	0.000304	0.000132	0.000181	0.000084	0.000836	0.000364	0.000176	0.000280	0.001934	0.000186	0.000379	0.000158	0.000323	0.001013	0.000053	0.668343	0.041105	0.002299	0.003074	0.000632	0.001134	0.000593	0.000295	0.000117	0.000398	0.000239	0.000134	0.000147	0.000176	0.000254	0.042769	0.039117	0.049251	0.003905	0.002889	0.001561	0.121237	0.079249	0.000651	0.003100	0.005831	0.139965	0.009168	0.002324	0.001445	0.001075	0.005215	0.009618	0.000162	0.001000	0.001018	0.000859	0.000292	0.000179	0.000082	0.000821	0.000157	0.000688	0.000886	0.000847	0.000285	0.000102	0.000754	0.002024	0.000617	0.001148	0.000972	0.000669	0.000109	0.000714	0.000529	0.000397	0.000396	0.002150	0.001570	0.000356	0.000326	0.000248	0.000654	0.000392	0.000763	0.000185	0.000132	0.000317	0.000142	0.000127	0.000895	0.000416	0.000242	0.000672	0.000638	0.002005	0.000468	0.000809	0.018440	0.011165	0.000464	0.002864	0.000756	0.001469	0.001322	0.001497	0.001308	0.000663	0.011502	0.004022	0.002565	0.000816	0.000993	0.000243	0.004712	0.000512	0.001149	0.002692	0.007799	0.001303	0.000170	0.096035	0.038574	0.024449	0.017034	0.017155	0.045680	0.024042	0.019278	0.017360	0.000611	0.000236	0.000068	0.002720	0.001264	0.004050	0.000819	0.000140	0.001442	0.002012	0.001256	0.000755	0.001853	0.000198	0.000475	0.000661	0.000326	0.009738	0.004204	0.007255	0.006656	0.001806	0.013995	0.001597	0.002880	0.001093	0.009614	0.000230	0.001473	0.000913	0.001330	0.005533	0.005630	0.000481	0.001940	0.000267	0.000481	0.000287	0.000121	0.000162	0.000494	0.000094	0.000056	0.000081	0.000192	0.000188	0.000190	0.000162	0.001554	0.000378	0.000061	0.000160	0.004637	0.000457	0.000110	0.000224	0.000204	0.000090	0.000307	0.001295	0.001274	0.000326	0.000209	0.000118	0.000079	0.000115	0.000218	0.000185	0.000251	0.000116	0.000732	0.000035	0.000041	0.000109	0.000285	0.000196	0.000127	0.000126	0.000231	0.000080	0.000923	0.001340	0.000445	0.000443	0.000820	0.000079	0.000205	0.000286	0.000043	0.000187	0.000092	0.000158	0.000168	0.000499	0.000559	0.000615	0.000047	0.000089	0.000054	0.000061	0.000190	0.000168	0.000023	0.000133	0.000155	0.000345	0.000692	0.000226	0.000552	0.000290	0.000302	0.000732	0.000470	0.000173	0.000119	0.000102	0.000224	0.000137	0.000061	0.000095	0.000795	0.000077	0.000133	0.000113	0.000064	0.000118	0.000069	0.000016	0.000102	0.000160	0.000100	0.000473	0.000137	0.000166	0.000602	0.000045	0.000212	0.000084	0.000296	0.000284	0.001266	0.000614	0.000382	0.001647	0.000239	0.000504	0.000662	0.001540	0.000965	0.000264	0.001529	0.001616	0.002557	0.000403	0.001924	0.000846	0.000261	0.000094	0.000599	0.000975	0.000986	0.000068	0.000032	0.000079	0.000390	0.000091	0.000109	0.000251	0.000306	0.000475	0.001407	0.000352	0.000029	0.000173	0.000170	0.000050	0.000526	0.000594	0.000466	0.000320	0.000120	0.000037	0.000082	0.000234	0.000274	0.000107	0.001117	0.000177	0.000061	0.000625	0.000606	0.000020	0.000051	0.000541	0.000528	0.000103	0.000471	0.000039	0.000111	0.000587	0.000854	0.000040	0.000291	0.000208	0.000218	0.003225	0.000184	0.000060	0.000093	0.001620	0.000411	0.001379	0.000387	0.000646	0.002297	0.005948	0.002405	0.000365	0.000415	0.000163	0.000148	0.000075	0.000099	0.000463	0.000081	0.000248	0.000266	0.000228	0.000402	0.001054	0.000016	0.000056	0.000028	0.003159	0.000726	0.000694	0.000170	0.000117	0.000028	0.001353	0.000078	0.000793	0.000166	0.000370	0.000159	0.000501	0.000546	0.000489	0.027998	0.001838	0.000366	0.000072	0.005583	0.002185	0.003837	0.000511	0.013844	0.001717	0.010288	0.004507	0.000961	0.001852	0.002369	0.004623	0.011950	0.000791	0.000316	0.006191	0.003280	0.003131	0.001435	0.001063	0.002784	0.000417	0.047672	0.000641	0.001043	0.000667	0.000104
147116105 - Weval - Half Age EP - Rooftop Paradise	147116105	0.022954	0.000270	0.000325	0.000447	0.000121	0.000224	0.000156	0.000097	0.000102	0.000031	0.000055	0.000024	0.000044	0.000037	0.000159	0.000207	0.000288	0.000093	0.000103	0.000093	0.000107	0.000097	0.000265	0.000228	0.000188	0.000075	0.000052	0.001617	0.000152	0.000155	0.000093	0.000091	0.000198	0.000219	0.000137	0.000120	0.000140	0.000165	0.000109	0.000010	0.000351	0.000155	0.000043	0.000079	0.000041	0.000042	0.000141	0.000090	0.000029	0.000121	0.000035	0.000073	0.000024	0.000070	0.000134	0.000090	0.000030	0.000034	0.000080	0.000109	0.000155	0.000059	0.000047	0.000099	0.000152	0.000612	0.000099	0.000035	0.000067	0.000363	0.000064	0.000029	0.002741	0.002067	0.001797	0.000378	0.000357	0.000845	0.000403	0.000097	0.000271	0.000329	0.000072	0.000171	0.000493	0.000081	0.000247	0.000099	0.000089	0.000028	0.000066	0.000066	0.000187	0.000073	0.000063	0.000110	0.000114	0.000119	0.000552	0.000275	0.000131	0.000195	0.000128	0.000118	0.000176	0.000202	0.000182	0.000159	0.000063	0.000040	0.000064	0.000870	0.000329	0.000264	0.000041	0.000130	0.000095	0.000103	0.000089	0.000154	0.000067	0.000014	0.000606	0.000092	0.000071	0.000064	0.000301	0.000095	0.000145	0.000168	0.000190	0.000070	0.000250	0.000097	0.000051	0.000303	0.000041	0.791172	0.150033	0.006404	0.006914	0.001342	0.000996	0.000777	0.000344	0.000376	0.000675	0.000615	0.000363	0.000318	0.000401	0.000308	0.060690	0.037658	0.034408	0.000820	0.000985	0.000284	0.458147	0.146772	0.001580	0.001716	0.002861	0.123649	0.005203	0.000683	0.000479	0.000236	0.001581	0.000109	0.000119	0.000428	0.000397	0.000298	0.000102	0.000105	0.000089	0.000272	0.000144	0.000645	0.001052	0.000816	0.000433	0.000300	0.001018	0.003774	0.001608	0.001566	0.001246	0.001999	0.000203	0.002660	0.000988	0.000811	0.000352	0.005646	0.001914	0.000761	0.000869	0.000749	0.000323	0.000250	0.000099	0.000023	0.000172	0.000238	0.000173	0.000094	0.000474	0.000438	0.000256	0.000608	0.004976	0.029375	0.001593	0.000325	0.004819	0.002733	0.000146	0.001644	0.000345	0.000410	0.000249	0.000546	0.000597	0.000177	0.004182	0.002003	0.001061	0.001364	0.000359	0.000556	0.003355	0.000517	0.001220	0.002026	0.005785	0.002383	0.000163	0.167664	0.049307	0.052534	0.009184	0.008930	0.101010	0.017788	0.024159	0.054463	0.000404	0.000185	0.000237	0.001853	0.000229	0.003584	0.000228	0.000111	0.001473	0.001674	0.000326	0.000385	0.000362	0.000266	0.000177	0.000340	0.000499	0.002377	0.000364	0.004865	0.002909	0.000478	0.006591	0.000442	0.002396	0.000239	0.005424	0.000253	0.001863	0.000846	0.000488	0.002310	0.004635	0.000014	0.000073	0.000154	0.000090	0.000131	0.000024	0.000030	0.000285	0.000046	0.000039	0.000037	0.000072	0.000034	0.000082	0.000066	0.000461	0.000118	0.000050	0.000076	0.002966	0.000310	0.000060	0.000064	0.000140	0.000068	0.000227	0.000582	0.001068	0.000227	0.000146	0.000009	0.000054	0.000056	0.000069	0.000135	0.000326	0.000065	0.000849	0.000037	0.000047	0.000073	0.000487	0.000309	0.000210	0.000232	0.000182	0.000069	0.000586	0.000750	0.000279	0.000358	0.000529	0.000011	0.000079	0.000152	0.000026	0.000038	0.000053	0.000067	0.000118	0.000202	0.000042	0.000292	0.000013	0.000051	0.000042	0.000065	0.000100	0.000068	0.000018	0.000072	0.000084	0.000156	0.000139	0.000143	0.000218	0.000061	0.000035	0.000066	0.000127	0.000180	0.000015	0.000037	0.000113	0.000074	0.000029	0.000064	0.000079	0.000066	0.000149	0.000116	0.000074	0.000046	0.000047	0.000018	0.000107	0.000058	0.000090	0.000314	0.000054	0.000041	0.000254	0.000036	0.000137	0.000071	0.000171	0.000114	0.001997	0.000673	0.000137	0.002812	0.000415	0.003606	0.002450	0.000576	0.002413	0.000741	0.001475	0.000880	0.001375	0.000547	0.000774	0.000389	0.000196	0.000113	0.000185	0.000289	0.000303	0.000083	0.000021	0.000076	0.000043	0.000015	0.000080	0.000133	0.000132	0.000160	0.000364	0.000044	0.000025	0.000064	0.000100	0.000030	0.000160	0.000159	0.000065	0.000175	0.000060	0.000012	0.000024	0.000102	0.000060	0.000045	0.000118	0.000025	0.000012	0.000208	0.000066	0.000005	0.000019	0.000275	0.000192	0.000017	0.000214	0.000022	0.000034	0.000129	0.000466	0.000034	0.000077	0.000065	0.000103	0.000864	0.000046	0.000035	0.000025	0.000745	0.000032	0.000186	0.000025	0.000029	0.001413	0.011650	0.001040	0.000036	0.000017	0.000105	0.000023	0.000025	0.000026	0.000056	0.000038	0.000038	0.000041	0.000107	0.000199	0.000483	0.000006	0.000044	0.000027	0.002612	0.000210	0.000188	0.000090	0.000014	0.000013	0.000292	0.000038	0.000272	0.000077	0.000102	0.000115	0.000029	0.000348	0.000134	0.001025	0.000097	0.000228	0.000047	0.002844	0.011792	0.008162	0.002707	0.006192	0.001698	0.009343	0.002088	0.000419	0.001190	0.001226	0.002271	0.015691	0.000379	0.000119	0.001450	0.000184	0.003412	0.005736	0.000389	0.000250	0.000048	0.001293	0.000121	0.000520	0.000442	0.000067
147116106 - Weval - Half Age EP - Half Age	147116106	0.016015	0.000222	0.000299	0.000508	0.000079	0.000156	0.000141	0.000077	0.000136	0.000066	0.000140	0.000040	0.000045	0.000056	0.000208	0.000375	0.000382	0.000141	0.000281	0.000153	0.000180	0.000108	0.000241	0.000215	0.000268	0.000088	0.000068	0.001550	0.000145	0.000085	0.000051	0.000051	0.000163	0.000235	0.000098	0.000168	0.000649	0.000063	0.000118	0.000014	0.001781	0.000322	0.000067	0.000079	0.000057	0.000072	0.000189	0.000124	0.000063	0.000253	0.000137	0.000067	0.000019	0.000142	0.000272	0.000256	0.000013	0.000213	0.000108	0.000298	0.000235	0.000095	0.000052	0.000096	0.000425	0.000769	0.000140	0.000053	0.000040	0.000334	0.000068	0.000018	0.003245	0.002659	0.002052	0.000593	0.000428	0.000658	0.000600	0.000121	0.000314	0.000418	0.000127	0.000256	0.000256	0.000063	0.000295	0.000163	0.000125	0.000055	0.000085	0.000085	0.000173	0.000110	0.000147	0.000121	0.000127	0.000112	0.000756	0.000268	0.000134	0.000221	0.000239	0.000239	0.000186	0.000269	0.000223	0.000201	0.000056	0.000037	0.000077	0.001109	0.000412	0.000317	0.000035	0.000148	0.000106	0.000133	0.000116	0.000164	0.000062	0.000023	0.000631	0.000140	0.000078	0.000137	0.000505	0.000156	0.000167	0.000244	0.000551	0.000123	0.000582	0.000231	0.000102	0.000765	0.000025	0.735217	0.084419	0.002239	0.002560	0.000559	0.000628	0.000331	0.000148	0.000159	0.000315	0.000315	0.000172	0.000161	0.000171	0.000168	0.071792	0.051283	0.049548	0.002299	0.002515	0.000712	0.231388	0.154764	0.002118	0.001593	0.003747	0.168370	0.005995	0.001014	0.000734	0.000356	0.002364	0.000157	0.000075	0.000590	0.000555	0.000265	0.000147	0.000161	0.000163	0.000237	0.000212	0.000738	0.001007	0.000958	0.000185	0.000374	0.000576	0.003134	0.000925	0.002444	0.001069	0.000509	0.000054	0.000800	0.000326	0.000194	0.000112	0.003268	0.001247	0.000301	0.000683	0.000287	0.000382	0.000228	0.000240	0.000062	0.000109	0.000436	0.000274	0.000097	0.000515	0.000521	0.000452	0.000456	0.001384	0.004317	0.000379	0.001313	0.007139	0.011001	0.000148	0.001738	0.000367	0.000687	0.000353	0.000757	0.000662	0.000172	0.005365	0.001697	0.002821	0.000538	0.000728	0.000182	0.007626	0.000288	0.000803	0.002245	0.009091	0.001546	0.000102	0.176685	0.056189	0.034458	0.026918	0.088201	0.088427	0.033161	0.008544	0.035332	0.000568	0.000241	0.000069	0.001416	0.000558	0.001293	0.000207	0.000051	0.002036	0.003063	0.000477	0.000497	0.000367	0.000127	0.000111	0.000481	0.000230	0.002544	0.000690	0.003749	0.003262	0.001090	0.007018	0.000365	0.002618	0.000332	0.008088	0.000111	0.001816	0.001372	0.000237	0.001533	0.005455	0.000042	0.000108	0.000233	0.000212	0.000196	0.000037	0.000046	0.000258	0.000072	0.000058	0.000069	0.000108	0.000037	0.000087	0.000068	0.000190	0.000207	0.000110	0.000198	0.003353	0.000367	0.000063	0.000132	0.000145	0.000057	0.000243	0.000827	0.001423	0.000237	0.000358	0.000015	0.000036	0.000051	0.000093	0.000095	0.000262	0.000058	0.000842	0.000041	0.000189	0.000074	0.000623	0.000445	0.000278	0.000237	0.000179	0.000054	0.000281	0.000404	0.000098	0.000136	0.000246	0.000007	0.000053	0.000137	0.000020	0.000045	0.000034	0.000052	0.000094	0.000321	0.000115	0.000228	0.000010	0.000035	0.000039	0.000022	0.000097	0.000066	0.000013	0.000054	0.000071	0.000184	0.000188	0.000149	0.000452	0.000089	0.000071	0.000087	0.000149	0.000235	0.000014	0.000043	0.000071	0.000040	0.000025	0.000082	0.000153	0.000026	0.000106	0.000077	0.000056	0.000028	0.000036	0.000038	0.000054	0.000061	0.000195	0.000483	0.000068	0.000072	0.000284	0.000040	0.000141	0.000031	0.000195	0.000238	0.002552	0.001323	0.000291	0.012498	0.000480	0.002099	0.001359	0.001278	0.002508	0.000766	0.002436	0.002343	0.002698	0.000645	0.001980	0.000156	0.000146	0.000064	0.000388	0.000403	0.000400	0.000049	0.000012	0.000035	0.000116	0.000022	0.000034	0.000098	0.000155	0.000373	0.000306	0.000032	0.000007	0.000050	0.000069	0.000036	0.000097	0.000097	0.000140	0.000165	0.000038	0.000017	0.000019	0.000158	0.000102	0.000085	0.000291	0.000062	0.000020	0.000184	0.000124	0.000011	0.000032	0.000150	0.000234	0.000008	0.000258	0.000030	0.000064	0.000434	0.000538	0.000038	0.000109	0.000086	0.000119	0.000844	0.000041	0.000029	0.000036	0.000554	0.000098	0.000452	0.000042	0.000096	0.001484	0.003816	0.000602	0.000028	0.000043	0.000171	0.000028	0.000017	0.000029	0.000051	0.000056	0.000099	0.000316	0.000215	0.000177	0.000622	0.000024	0.000085	0.000087	0.005082	0.000268	0.000316	0.000091	0.000032	0.000018	0.000875	0.000045	0.000465	0.000134	0.000221	0.000045	0.000151	0.000491	0.000371	0.003971	0.000753	0.000366	0.000136	0.006300	0.006774	0.004001	0.002186	0.007980	0.001733	0.010668	0.002072	0.000385	0.001553	0.001877	0.001212	0.008334	0.000513	0.000218	0.006289	0.000418	0.001463	0.002779	0.000537	0.000535	0.000068	0.004724	0.000202	0.000951	0.000461	0.000059
61695115 - Weval - Weval - Intro	61695115	0.021761	0.000334	0.000367	0.000815	0.000127	0.000201	0.000173	0.000088	0.000126	0.000111	0.000127	0.000057	0.000101	0.000041	0.000383	0.000528	0.000604	0.000181	0.000136	0.000165	0.000190	0.000171	0.000182	0.000237	0.000350	0.000076	0.001002	0.002477	0.000266	0.000122	0.000130	0.000111	0.000132	0.000249	0.000110	0.000195	0.003007	0.000575	0.000257	0.000046	0.000301	0.002360	0.000216	0.000214	0.000218	0.000128	0.000613	0.000422	0.000178	0.000602	0.000105	0.000145	0.000076	0.000634	0.000368	0.000204	0.000102	0.000320	0.000278	0.000709	0.000439	0.000319	0.000088	0.000110	0.005578	0.003413	0.000116	0.000036	0.000098	0.000489	0.000124	0.000031	0.004911	0.003594	0.003239	0.001082	0.000679	0.001408	0.001173	0.000309	0.000419	0.000578	0.000119	0.000273	0.000586	0.000133	0.000434	0.000285	0.000203	0.000093	0.000184	0.000194	0.000073	0.000140	0.000212	0.000239	0.000460	0.000430	0.000501	0.000496	0.000215	0.000314	0.000136	0.000116	0.000062	0.000101	0.000094	0.000094	0.000134	0.000108	0.000402	0.000639	0.000288	0.000214	0.000015	0.000190	0.000148	0.000101	0.000092	0.000397	0.000133	0.000038	0.000793	0.000126	0.000253	0.000114	0.000588	0.000168	0.000221	0.000255	0.000645	0.000152	0.000260	0.000133	0.000302	0.000580	0.001219	0.679842	0.101838	0.003090	0.003756	0.000591	0.001117	0.000508	0.000189	0.000097	0.000331	0.000181	0.000138	0.000135	0.000132	0.000334	0.011642	0.011881	0.006237	0.000756	0.000589	0.000482	0.037627	0.040122	0.000138	0.013091	0.018918	0.063853	0.022580	0.010424	0.005658	0.002785	0.012164	0.013329	0.000121	0.006600	0.006894	0.001940	0.000158	0.000144	0.000184	0.002844	0.000087	0.000647	0.000888	0.000756	0.000578	0.000152	0.004445	0.085118	0.013834	0.029474	0.028841	0.002130	0.000105	0.001349	0.000602	0.000844	0.001024	0.012000	0.001554	0.006837	0.002463	0.000263	0.000337	0.000177	0.000119	0.000149	0.000301	0.000233	0.000083	0.000026	0.001845	0.000471	0.000071	0.005152	0.003074	0.006733	0.001544	0.003835	0.004118	0.025250	0.001425	0.002248	0.000567	0.000517	0.000175	0.000462	0.000411	0.000294	0.002861	0.001415	0.003430	0.000252	0.002317	0.000080	0.005272	0.000115	0.000296	0.011567	0.001979	0.003540	0.000206	0.082305	0.007139	0.004539	0.011889	0.042605	0.008999	0.002456	0.019884	0.002443	0.000416	0.000231	0.000104	0.001422	0.000477	0.000698	0.000539	0.000125	0.001527	0.001642	0.000463	0.000238	0.000699	0.000111	0.000105	0.000428	0.000157	0.001121	0.000550	0.002636	0.001935	0.000451	0.005989	0.000194	0.000748	0.000276	0.001225	0.000080	0.000248	0.000572	0.000190	0.000599	0.001316	0.000329	0.000911	0.000216	0.000178	0.000201	0.000076	0.000116	0.000895	0.000059	0.000052	0.000050	0.000134	0.000054	0.000127	0.000104	0.000330	0.000418	0.000096	0.000308	0.003274	0.000341	0.000093	0.000229	0.000124	0.000070	0.000278	0.001063	0.001461	0.000330	0.000061	0.000132	0.000149	0.000144	0.000210	0.000289	0.000180	0.000055	0.001313	0.000022	0.000032	0.000080	0.000244	0.000189	0.000095	0.000092	0.000218	0.000063	0.000380	0.000524	0.000261	0.000366	0.000312	0.000011	0.000166	0.000230	0.000037	0.000053	0.000070	0.000089	0.000164	0.001425	0.004223	0.000270	0.000012	0.000039	0.000041	0.000050	0.000107	0.000066	0.000015	0.000063	0.000064	0.000226	0.001571	0.000550	0.002149	0.000689	0.000574	0.000731	0.000562	0.000809	0.000243	0.000471	0.000519	0.000215	0.000057	0.000061	0.000281	0.000139	0.000312	0.000259	0.000213	0.000258	0.000296	0.000043	0.000070	0.000141	0.000170	0.000312	0.000233	0.000376	0.000566	0.000183	0.000362	0.000177	0.000503	0.000427	0.001018	0.000701	0.000491	0.001072	0.000381	0.002129	0.001589	0.000882	0.000835	0.000322	0.000996	0.000912	0.001365	0.003649	0.001575	0.000270	0.000226	0.000086	0.000493	0.000802	0.000681	0.000072	0.000017	0.000169	0.000273	0.000023	0.000345	0.000194	0.000293	0.000426	0.000550	0.000105	0.000015	0.000065	0.000167	0.000032	0.000201	0.000194	0.000660	0.000590	0.000229	0.000105	0.000117	0.000350	0.000309	0.000207	0.000671	0.000110	0.000144	0.000405	0.000319	0.000018	0.000095	0.000279	0.000246	0.000165	0.000408	0.000061	0.000104	0.000434	0.000802	0.000028	0.000320	0.000170	0.000141	0.001016	0.000070	0.000035	0.000095	0.105859	0.000909	0.003868	0.000382	0.001072	0.000966	0.002055	0.000696	0.000591	0.000155	0.000471	0.000218	0.000099	0.000135	0.000806	0.000186	0.000118	0.001700	0.000272	0.000391	0.000607	0.000011	0.000118	0.000066	0.002828	0.000669	0.000618	0.000465	0.000033	0.000140	0.000910	0.000073	0.000634	0.000093	0.000637	0.000085	0.001507	0.001202	0.000139	0.018560	0.000123	0.000507	0.000130	0.011996	0.008994	0.001954	0.002551	0.011279	0.005469	0.018269	0.012249	0.001649	0.002323	0.001905	0.002651	0.004489	0.000475	0.000244	0.004447	0.000976	0.000991	0.006421	0.000263	0.000943	0.000106	0.029936	0.000218	0.001252	0.000667	0.000088
61695116 - Weval - Weval - The Battle	61695116	0.017535	0.000264	0.000165	0.000402	0.000052	0.000142	0.000080	0.000056	0.000185	0.000105	0.000118	0.000071	0.000027	0.000048	0.000455	0.000776	0.000227	0.000123	0.000112	0.000064	0.000085	0.000051	0.000244	0.000208	0.000333	0.000136	0.000437	0.029623	0.000220	0.000201	0.000223	0.000439	0.001007	0.000632	0.000182	0.000697	0.003049	0.000484	0.000157	0.000028	0.000714	0.000464	0.000220	0.000190	0.000103	0.000051	0.000177	0.000478	0.000184	0.000398	0.000254	0.000035	0.000021	0.000131	0.000294	0.000146	0.000019	0.000472	0.000274	0.000337	0.000132	0.000057	0.000086	0.000035	0.001372	0.005448	0.000109	0.000010	0.000022	0.000289	0.000053	0.000010	0.004366	0.003274	0.002295	0.000507	0.000341	0.001145	0.000363	0.000203	0.000265	0.000623	0.000140	0.000330	0.000366	0.000105	0.000323	0.000144	0.000114	0.000050	0.000091	0.000089	0.000514	0.000159	0.000191	0.000107	0.000136	0.000117	0.000520	0.000490	0.000245	0.000369	0.000097	0.000092	0.000107	0.000157	0.000082	0.000076	0.000057	0.000042	0.000172	0.001033	0.000342	0.000269	0.000031	0.000141	0.000114	0.000118	0.000104	0.000443	0.000092	0.000033	0.000570	0.000255	0.000257	0.000150	0.000277	0.000133	0.000062	0.000112	0.000245	0.000075	0.000192	0.000084	0.000114	0.000500	0.000076	0.709149	0.043396	0.003153	0.004492	0.000955	0.001928	0.000599	0.000284	0.000121	0.000448	0.000216	0.000118	0.000173	0.000135	0.000342	0.009010	0.006395	0.007241	0.000580	0.000760	0.000270	0.080521	0.104153	0.000159	0.007099	0.016594	0.346034	0.019136	0.006323	0.004955	0.002131	0.012521	0.001406	0.000221	0.003131	0.003082	0.002211	0.000334	0.000273	0.000287	0.000518	0.000187	0.001172	0.001421	0.001624	0.000497	0.000237	0.000750	0.002776	0.000635	0.001378	0.000850	0.000684	0.000072	0.000708	0.000403	0.000231	0.000194	0.002020	0.001649	0.000332	0.000357	0.000195	0.000576	0.000266	0.000700	0.000362	0.000218	0.000638	0.000442	0.000037	0.000523	0.000245	0.000046	0.000591	0.000515	0.002539	0.001051	0.001364	0.035825	0.032350	0.000515	0.008457	0.001416	0.002800	0.002343	0.002972	0.002512	0.000971	0.019088	0.007964	0.019674	0.000725	0.002860	0.000199	0.020909	0.000644	0.001969	0.003247	0.014034	0.000565	0.000100	0.085114	0.027591	0.009978	0.016390	0.038038	0.026231	0.011485	0.005834	0.005651	0.002117	0.000554	0.000080	0.003097	0.001629	0.001122	0.000906	0.000252	0.008876	0.010115	0.001972	0.001048	0.002875	0.000158	0.001335	0.002150	0.000260	0.010645	0.006406	0.002391	0.002268	0.002824	0.006574	0.000602	0.000684	0.001222	0.009986	0.000111	0.001678	0.001292	0.000328	0.001608	0.006086	0.000193	0.000064	0.000124	0.000119	0.000117	0.000065	0.000082	0.000338	0.000064	0.000041	0.000046	0.000082	0.000044	0.000058	0.000049	0.000308	0.000207	0.000064	0.000098	0.001892	0.000207	0.000050	0.000105	0.000087	0.000029	0.000127	0.000524	0.000475	0.000110	0.000120	0.000028	0.000029	0.000046	0.000064	0.000088	0.000104	0.000039	0.000289	0.000019	0.000052	0.000036	0.000230	0.000260	0.000093	0.000068	0.000149	0.000030	0.000248	0.000331	0.000158	0.000171	0.000215	0.000013	0.000045	0.000135	0.000017	0.000053	0.000040	0.000059	0.000079	0.000292	0.000182	0.000226	0.000010	0.000054	0.000040	0.000035	0.000062	0.000039	0.000010	0.000052	0.000041	0.000126	0.000232	0.000345	0.001008	0.000099	0.000063	0.000311	0.000229	0.000898	0.000016	0.000044	0.000117	0.000069	0.000015	0.000039	0.000103	0.000056	0.000111	0.000079	0.000069	0.000021	0.000072	0.000003	0.000035	0.000092	0.000056	0.000497	0.000105	0.000088	0.000131	0.000052	0.000286	0.000078	0.000410	0.000147	0.002195	0.000946	0.000806	0.005485	0.000427	0.002374	0.003972	0.001541	0.000755	0.000112	0.001465	0.003412	0.003539	0.000618	0.002974	0.000271	0.000175	0.000075	0.000584	0.000664	0.000544	0.000053	0.000014	0.000054	0.000103	0.000011	0.000122	0.000123	0.000142	0.000154	0.000422	0.000022	0.000010	0.000037	0.000065	0.000013	0.000163	0.000201	0.000281	0.000158	0.000080	0.000027	0.000022	0.000103	0.000165	0.000086	0.000720	0.000055	0.000045	0.000168	0.000236	0.000007	0.000060	0.000470	0.000445	0.000092	0.000199	0.000026	0.000049	0.000154	0.000321	0.000015	0.000099	0.000085	0.000069	0.000501	0.000038	0.000024	0.000034	0.001046	0.000072	0.000671	0.000069	0.000161	0.001720	0.006778	0.002850	0.000056	0.000106	0.000102	0.000046	0.000033	0.000079	0.000106	0.000042	0.000042	0.000325	0.000086	0.000128	0.001898	0.000016	0.000058	0.000049	0.003910	0.000346	0.001412	0.000367	0.000043	0.000026	0.000407	0.000026	0.000278	0.000043	0.000530	0.000049	0.000122	0.000591	0.000820	0.003183	0.002445	0.000383	0.000077	0.007680	0.006326	0.001458	0.002142	0.006720	0.001428	0.009514	0.004042	0.000633	0.001233	0.001269	0.001905	0.007342	0.000307	0.000135	0.001587	0.000188	0.003081	0.009723	0.000324	0.000303	0.000055	0.006314	0.000127	0.000662	0.000549	0.000029
61695117 - Weval - Weval - I Don't Need It	61695117	0.061161	0.000986	0.000361	0.000617	0.000191	0.000549	0.000171	0.000138	0.000190	0.000141	0.000246	0.000067	0.000022	0.000034	0.000449	0.000566	0.000436	0.000122	0.000179	0.000113	0.000133	0.000125	0.000315	0.000353	0.000499	0.000089	0.000234	0.019125	0.000317	0.000314	0.000329	0.000463	0.001673	0.000325	0.000118	0.000476	0.003320	0.000271	0.000153	0.000021	0.001347	0.000484	0.000095	0.000096	0.000131	0.000087	0.000279	0.000243	0.000132	0.000347	0.000147	0.000129	0.000053	0.000321	0.000211	0.000193	0.000044	0.000586	0.000120	0.000376	0.000209	0.000045	0.000026	0.000046	0.001329	0.001046	0.000127	0.000048	0.000074	0.000605	0.000160	0.000024	0.003616	0.003157	0.002222	0.000467	0.000460	0.001553	0.000556	0.000195	0.000300	0.000497	0.000171	0.000262	0.000301	0.000107	0.000429	0.000218	0.000169	0.000075	0.000129	0.000126	0.000077	0.000115	0.000293	0.000143	0.000322	0.000266	0.000711	0.000411	0.000173	0.000366	0.000146	0.000138	0.000129	0.000208	0.000149	0.000143	0.000064	0.000046	0.000129	0.001022	0.000407	0.000341	0.000047	0.000190	0.000142	0.000051	0.000043	0.000529	0.000182	0.000053	0.000640	0.000285	0.000376	0.000168	0.001082	0.000413	0.000246	0.000432	0.001933	0.000268	0.000408	0.000158	0.000198	0.000852	0.000153	0.697101	0.075848	0.005158	0.006544	0.001070	0.002522	0.000824	0.000497	0.000332	0.000655	0.000518	0.000245	0.000399	0.000166	0.000327	0.041021	0.028115	0.024309	0.002209	0.001871	0.001015	0.135490	0.138317	0.001189	0.003770	0.006964	0.079269	0.007685	0.001988	0.001654	0.000608	0.003759	0.001358	0.000098	0.001161	0.000997	0.000275	0.000424	0.000563	0.000440	0.000396	0.000120	0.000464	0.000663	0.000558	0.000339	0.000275	0.002280	0.005490	0.000934	0.002410	0.001635	0.001711	0.000188	0.002050	0.000593	0.000563	0.000616	0.004829	0.002328	0.001368	0.000717	0.000321	0.000245	0.000097	0.000505	0.000099	0.000171	0.000254	0.000137	0.000030	0.002347	0.001439	0.000333	0.002121	0.000771	0.034693	0.000784	0.001544	0.011544	0.018856	0.000456	0.006261	0.001164	0.001958	0.000851	0.002466	0.002255	0.001902	0.008799	0.006000	0.007071	0.001967	0.002762	0.000687	0.014878	0.000652	0.001438	0.006494	0.013066	0.002303	0.000354	0.106050	0.022034	0.023147	0.014089	0.036617	0.036941	0.007906	0.011633	0.022726	0.001155	0.000458	0.000248	0.004453	0.000705	0.001037	0.000732	0.000098	0.003457	0.002882	0.000988	0.001085	0.001439	0.000249	0.001284	0.001860	0.000384	0.007884	0.004727	0.004181	0.003831	0.002001	0.010929	0.000272	0.003656	0.000726	0.006436	0.000201	0.001327	0.002011	0.000398	0.001655	0.006634	0.000263	0.000845	0.000195	0.000240	0.000175	0.000049	0.000063	0.000321	0.000058	0.000047	0.000054	0.000117	0.000050	0.000081	0.000066	0.000195	0.000247	0.000050	0.000189	0.003136	0.000315	0.000087	0.000132	0.000131	0.000066	0.000239	0.000982	0.001023	0.000171	0.000411	0.000029	0.000037	0.000044	0.000155	0.000110	0.000188	0.000059	0.000799	0.000033	0.000058	0.000077	0.000489	0.000573	0.000197	0.000140	0.000270	0.000051	0.000211	0.000329	0.000079	0.000096	0.000192	0.000013	0.000067	0.000153	0.000016	0.000063	0.000048	0.000074	0.000101	0.000535	0.000601	0.000283	0.000007	0.000046	0.000027	0.000018	0.000098	0.000072	0.000012	0.000061	0.000079	0.000186	0.000797	0.000305	0.000376	0.000310	0.000161	0.000135	0.000187	0.002216	0.000049	0.000073	0.000198	0.000127	0.000027	0.000058	0.000468	0.000024	0.000111	0.000083	0.000065	0.000035	0.000039	0.000016	0.000054	0.000035	0.000217	0.000614	0.000126	0.000073	0.000652	0.000063	0.000173	0.000047	0.000203	0.000512	0.007119	0.000727	0.000421	0.002206	0.000264	0.001534	0.001383	0.001931	0.002778	0.000670	0.004511	0.008457	0.005442	0.001037	0.005678	0.000143	0.000136	0.000049	0.000266	0.000367	0.000344	0.000037	0.000015	0.000046	0.000241	0.000049	0.000077	0.000117	0.000120	0.000246	0.000345	0.000031	0.000005	0.000027	0.000056	0.000011	0.000122	0.000151	0.000214	0.000160	0.000045	0.000025	0.000035	0.000126	0.000127	0.000065	0.000514	0.000071	0.000029	0.000119	0.000085	0.000003	0.000021	0.000213	0.000307	0.000050	0.000269	0.000023	0.000040	0.000237	0.000395	0.000047	0.000149	0.000081	0.000082	0.000723	0.000042	0.000019	0.000117	0.007628	0.000179	0.000952	0.000096	0.000221	0.001080	0.003322	0.000972	0.000116	0.000128	0.000142	0.000050	0.000039	0.000049	0.000074	0.000054	0.000114	0.000346	0.000212	0.000149	0.001626	0.000003	0.000075	0.000066	0.010265	0.000325	0.000419	0.000082	0.000175	0.000027	0.001289	0.000044	0.000635	0.000096	0.000268	0.000040	0.000700	0.000488	0.000375	0.041610	0.000339	0.000370	0.000080	0.007327	0.016332	0.004954	0.003109	0.011735	0.004749	0.016336	0.006840	0.001461	0.001805	0.001472	0.002159	0.005639	0.001779	0.000223	0.015977	0.003628	0.001639	0.005978	0.002297	0.001508	0.000118	0.053398	0.000616	0.001469	0.001686	0.000111
61695118 - Weval - Weval - Square People.part	61695118	0.029012	0.000254	0.000254	0.000549	0.000100	0.000178	0.000172	0.000117	0.000195	0.000074	0.000147	0.000041	0.000016	0.000049	0.000640	0.000369	0.000371	0.000152	0.000148	0.000099	0.000130	0.000072	0.000532	0.000656	0.000388	0.000118	0.000133	0.002906	0.000135	0.000158	0.000133	0.000155	0.000186	0.000166	0.000102	0.000252	0.001111	0.000181	0.000244	0.000016	0.000964	0.000289	0.000096	0.000090	0.000070	0.000031	0.000240	0.000185	0.000078	0.000149	0.000059	0.000104	0.000038	0.000169	0.000317	0.000179	0.000014	0.000136	0.000071	0.000110	0.000082	0.000053	0.000017	0.000032	0.000562	0.000689	0.000106	0.000016	0.000088	0.000542	0.000155	0.000046	0.004918	0.002719	0.001694	0.000399	0.000372	0.001142	0.000371	0.000116	0.000269	0.000639	0.000086	0.000454	0.000537	0.000137	0.000681	0.000222	0.000147	0.000109	0.000139	0.000144	0.000428	0.000106	0.000144	0.000540	0.000838	0.000873	0.000666	0.000506	0.000248	0.000470	0.000186	0.000181	0.000150	0.000226	0.000109	0.000093	0.000122	0.000058	0.000102	0.001617	0.000752	0.000758	0.000079	0.000155	0.000133	0.000151	0.000146	0.000358	0.000088	0.000020	0.000825	0.000187	0.000212	0.000093	0.000899	0.000710	0.000311	0.000248	0.000284	0.000105	0.000659	0.000297	0.000235	0.001611	0.000185	0.729084	0.055671	0.015431	0.021395	0.005111	0.004599	0.001273	0.003140	0.000917	0.001548	0.000696	0.000406	0.000642	0.001011	0.000347	0.009113	0.007281	0.006234	0.002000	0.002930	0.001024	0.046607	0.065749	0.000548	0.003117	0.005782	0.088074	0.007544	0.001707	0.001406	0.000536	0.003441	0.000351	0.000090	0.001081	0.000972	0.000565	0.000599	0.001021	0.001344	0.000309	0.000682	0.001919	0.002038	0.002203	0.000605	0.001554	0.002112	0.003570	0.000962	0.001516	0.001695	0.002027	0.000283	0.001711	0.001083	0.000742	0.000466	0.001932	0.001040	0.000405	0.000491	0.000720	0.001013	0.000436	0.001598	0.000173	0.000121	0.003137	0.001940	0.000063	0.000263	0.000210	0.000095	0.001120	0.000700	0.028735	0.001381	0.005213	0.007173	0.017611	0.000385	0.005726	0.000732	0.001113	0.000827	0.001854	0.001314	0.002095	0.005528	0.004785	0.009875	0.001168	0.003818	0.000391	0.025173	0.000490	0.000925	0.002484	0.032414	0.001544	0.000246	0.109138	0.053567	0.019388	0.004951	0.060884	0.048146	0.011074	0.017394	0.012119	0.000631	0.000360	0.000121	0.003716	0.000395	0.001397	0.000278	0.000073	0.003797	0.005612	0.000319	0.000292	0.000465	0.000174	0.000573	0.001657	0.000328	0.003033	0.001550	0.003206	0.001714	0.001336	0.006986	0.000157	0.001215	0.000289	0.008585	0.000149	0.001189	0.001968	0.000129	0.000854	0.005982	0.000081	0.000118	0.000215	0.000294	0.000188	0.000025	0.000031	0.000342	0.000045	0.000030	0.000037	0.000126	0.000057	0.000089	0.000068	0.000341	0.000222	0.000069	0.000191	0.002495	0.000406	0.000075	0.000194	0.000116	0.000070	0.000170	0.000640	0.000806	0.000189	0.000243	0.000017	0.000025	0.000040	0.000081	0.000070	0.000139	0.000034	0.000465	0.000033	0.000085	0.000039	0.000369	0.000399	0.000194	0.000108	0.000195	0.000066	0.000225	0.000309	0.000102	0.000136	0.000181	0.000008	0.000036	0.000085	0.000012	0.000024	0.000028	0.000058	0.000050	0.000769	0.000150	0.000238	0.000008	0.000038	0.000038	0.000031	0.000089	0.000058	0.000015	0.000036	0.000063	0.000125	0.000336	0.000303	0.001034	0.000179	0.000094	0.000153	0.000160	0.000725	0.000012	0.000042	0.000172	0.000100	0.000034	0.000050	0.000137	0.000020	0.000134	0.000100	0.000080	0.000019	0.000038	0.000060	0.000030	0.000030	0.000105	0.001124	0.000297	0.000146	0.000138	0.000046	0.000203	0.000070	0.000234	0.000271	0.003528	0.000777	0.000528	0.002558	0.000621	0.000637	0.001047	0.002560	0.001095	0.000212	0.004501	0.007460	0.004163	0.002065	0.002414	0.000142	0.000354	0.000192	0.000337	0.000312	0.000384	0.000149	0.000042	0.000042	0.000121	0.000020	0.000082	0.000074	0.000266	0.000618	0.000431	0.000037	0.000019	0.000044	0.000102	0.000021	0.000134	0.000144	0.000187	0.000275	0.000082	0.000043	0.000038	0.000142	0.000060	0.000048	0.000399	0.000044	0.000013	0.000173	0.000104	0.000003	0.000039	0.000726	0.001119	0.000044	0.000267	0.000028	0.000057	0.000319	0.000533	0.000024	0.000138	0.000081	0.000131	0.001400	0.000034	0.000027	0.000043	0.001500	0.000114	0.000665	0.000066	0.000116	0.003666	0.042610	0.009364	0.000085	0.000055	0.000071	0.000034	0.000035	0.000078	0.000054	0.000016	0.000076	0.001062	0.000348	0.000186	0.001097	0.000010	0.000072	0.000053	0.004241	0.000617	0.001553	0.000339	0.000069	0.000018	0.001091	0.000034	0.000552	0.000068	0.000430	0.000033	0.000085	0.000481	0.000925	0.004201	0.000130	0.000411	0.000107	0.007200	0.002294	0.002509	0.000582	0.010328	0.000904	0.017346	0.007414	0.001288	0.001970	0.002340	0.013048	0.041153	0.000296	0.000667	0.005824	0.000194	0.016626	0.003194	0.000422	0.000454	0.000091	0.007312	0.000166	0.002435	0.001238	0.000096
61695119 - Weval - Weval - Madness	61695119	0.062874	0.000810	0.000583	0.001296	0.000300	0.000439	0.000347	0.000244	0.000512	0.000364	0.000527	0.000125	0.000128	0.000108	0.000676	0.000716	0.000723	0.000123	0.000218	0.000207	0.000160	0.000182	0.000368	0.000461	0.000716	0.000202	0.000669	0.009061	0.000527	0.000256	0.000198	0.000238	0.000921	0.000930	0.000571	0.000594	0.001604	0.000304	0.001096	0.000168	0.000443	0.000966	0.000248	0.000270	0.000253	0.000347	0.000529	0.000366	0.000311	0.000354	0.000298	0.000470	0.000130	0.000679	0.000413	0.000715	0.000053	0.000393	0.000351	0.000543	0.000234	0.000323	0.000062	0.000158	0.003839	0.004472	0.000267	0.000078	0.000186	0.001215	0.000523	0.000164	0.030878	0.017094	0.015931	0.003708	0.004485	0.010849	0.007984	0.001969	0.002863	0.001472	0.000403	0.000746	0.001201	0.000307	0.000936	0.000881	0.000550	0.000204	0.000457	0.000424	0.000158	0.000714	0.001152	0.000206	0.000544	0.000475	0.000820	0.000612	0.000260	0.000341	0.000206	0.000180	0.000249	0.000370	0.000180	0.000165	0.001775	0.001258	0.007626	0.001607	0.000697	0.000551	0.000041	0.000375	0.000326	0.000243	0.000177	0.000623	0.000258	0.000059	0.006887	0.000307	0.000621	0.000244	0.001583	0.000883	0.000162	0.000412	0.005723	0.000349	0.000814	0.000402	0.001489	0.004738	0.002803	0.728544	0.071094	0.009793	0.012495	0.001794	0.004452	0.001765	0.001412	0.000457	0.001387	0.000742	0.000941	0.000616	0.000458	0.000682	0.016491	0.014772	0.011500	0.003037	0.002368	0.001766	0.025942	0.055479	0.001293	0.012418	0.021301	0.143125	0.026144	0.008820	0.006121	0.001908	0.014032	0.002150	0.000238	0.005902	0.005246	0.002463	0.001120	0.001198	0.000948	0.000273	0.000254	0.001124	0.001466	0.001297	0.000635	0.000497	0.001190	0.001677	0.000388	0.000478	0.000473	0.002298	0.000221	0.001590	0.001148	0.000600	0.000902	0.005049	0.001732	0.000627	0.000358	0.000753	0.000392	0.000213	0.001302	0.000272	0.000065	0.000405	0.000223	0.000062	0.002804	0.000867	0.000291	0.004172	0.000594	0.005344	0.000490	0.004658	0.007454	0.015621	0.000651	0.013034	0.002809	0.001595	0.000753	0.002573	0.001527	0.001472	0.005374	0.003859	0.004073	0.002093	0.001344	0.000887	0.007791	0.000501	0.000722	0.005761	0.005266	0.001520	0.000163	0.068614	0.011214	0.008276	0.011014	0.031361	0.013518	0.003336	0.005009	0.004026	0.001113	0.000477	0.000364	0.004070	0.001565	0.001035	0.000672	0.000140	0.001236	0.000869	0.001469	0.001241	0.001398	0.000408	0.000202	0.000557	0.000377	0.003706	0.001689	0.002959	0.002426	0.002105	0.005551	0.000502	0.001056	0.001079	0.002469	0.000266	0.001014	0.000808	0.000263	0.001556	0.003164	0.000458	0.000848	0.000886	0.001251	0.000815	0.000271	0.000345	0.001368	0.000314	0.000274	0.000360	0.000524	0.000243	0.000670	0.000575	0.000597	0.001382	0.000399	0.001200	0.026066	0.001920	0.000492	0.000856	0.000753	0.000356	0.002162	0.008163	0.001124	0.000338	0.000333	0.000407	0.000181	0.000416	0.002371	0.001119	0.000838	0.000323	0.000547	0.000155	0.000462	0.000532	0.001115	0.001279	0.000301	0.000284	0.001793	0.000476	0.001045	0.001687	0.000497	0.000505	0.000844	0.000035	0.000391	0.000871	0.000090	0.000305	0.000240	0.000343	0.000599	0.008970	0.004100	0.001071	0.000026	0.000135	0.000100	0.000118	0.000552	0.000277	0.000043	0.000336	0.000188	0.001654	0.001139	0.000512	0.001300	0.000991	0.000354	0.000373	0.000833	0.000431	0.000112	0.000354	0.000345	0.000190	0.000048	0.000226	0.000734	0.000129	0.000415	0.000307	0.000299	0.000187	0.000209	0.000109	0.000281	0.000499	0.000749	0.002363	0.000130	0.000746	0.006618	0.000256	0.000445	0.000309	0.000561	0.000554	0.000894	0.000397	0.000232	0.000695	0.000206	0.000685	0.000899	0.000759	0.004347	0.001413	0.001354	0.000925	0.001195	0.000368	0.000879	0.000286	0.002555	0.001136	0.000621	0.001118	0.000890	0.000800	0.000198	0.000290	0.000450	0.000151	0.000073	0.000630	0.000439	0.001358	0.001067	0.000190	0.000027	0.000167	0.000270	0.000048	0.000355	0.000417	0.001114	0.000332	0.000147	0.000115	0.000121	0.000207	0.000203	0.000158	0.001412	0.000466	0.000281	0.000531	0.000388	0.000022	0.000095	0.000684	0.000862	0.000371	0.000959	0.000094	0.000420	0.001715	0.001109	0.000083	0.000663	0.000616	0.000557	0.003229	0.000164	0.000108	0.000356	0.004247	0.000614	0.008679	0.000518	0.000545	0.001915	0.002553	0.000688	0.000534	0.000151	0.000338	0.000230	0.000138	0.000137	0.000140	0.000126	0.000496	0.002068	0.001357	0.000493	0.001524	0.000023	0.000140	0.000126	0.002419	0.000788	0.000718	0.000144	0.000109	0.000173	0.006475	0.001111	0.003418	0.000484	0.000450	0.000162	0.014388	0.001549	0.001411	0.053442	0.000280	0.000438	0.000201	0.012513	0.001700	0.003175	0.000316	0.025449	0.001647	0.017606	0.013636	0.004086	0.009873	0.008779	0.002837	0.004840	0.002470	0.000676	0.040815	0.006472	0.001311	0.002435	0.000951	0.006172	0.000870	0.053544	0.000923	0.003929	0.001585	0.000687
61695120 - Weval - Weval - Ways To Go	61695120	0.027465	0.000402	0.000218	0.000286	0.000061	0.000173	0.000057	0.000061	0.000191	0.000136	0.000148	0.000066	0.000031	0.000032	0.000184	0.000268	0.000175	0.000053	0.000055	0.000058	0.000055	0.000048	0.000098	0.000097	0.000144	0.000039	0.000520	0.023950	0.000387	0.000261	0.000262	0.000220	0.000653	0.000389	0.000091	0.000202	0.003072	0.000394	0.000139	0.000010	0.000278	0.000446	0.000106	0.000152	0.000105	0.000036	0.000230	0.000141	0.000066	0.000238	0.000116	0.000098	0.000028	0.000186	0.000129	0.000079	0.000008	0.000323	0.000081	0.000146	0.000087	0.000027	0.000017	0.000026	0.003507	0.006002	0.000098	0.000018	0.000058	0.000432	0.000089	0.000022	0.002253	0.001203	0.000876	0.000223	0.000168	0.000407	0.000282	0.000082	0.000121	0.000311	0.000129	0.000152	0.000504	0.000056	0.000330	0.000227	0.000173	0.000098	0.000150	0.000145	0.000198	0.000040	0.000070	0.000112	0.000202	0.000174	0.000368	0.000267	0.000127	0.000187	0.000086	0.000084	0.000069	0.000095	0.000081	0.000074	0.000093	0.000071	0.000164	0.000626	0.000245	0.000182	0.000010	0.000164	0.000135	0.000071	0.000065	0.000265	0.000099	0.000014	0.000231	0.000061	0.000117	0.000046	0.000628	0.000136	0.000148	0.000328	0.000370	0.000212	0.000118	0.000043	0.000160	0.000558	0.000208	0.759265	0.032147	0.002234	0.002920	0.000457	0.000839	0.000413	0.000212	0.000080	0.000237	0.000430	0.000137	0.000252	0.000165	0.000396	0.009187	0.007081	0.006764	0.000927	0.000896	0.000421	0.076730	0.075502	0.000352	0.003521	0.007068	0.244210	0.009310	0.002680	0.002038	0.000808	0.004807	0.001243	0.000107	0.001474	0.001562	0.000816	0.000084	0.000123	0.000280	0.000689	0.000186	0.001298	0.001889	0.001634	0.000629	0.000345	0.001474	0.003677	0.001067	0.001670	0.001513	0.000873	0.000126	0.001262	0.000564	0.000341	0.000228	0.001398	0.001064	0.000435	0.000310	0.000321	0.000334	0.000250	0.000304	0.000047	0.000107	0.000441	0.000233	0.000052	0.000428	0.000607	0.000124	0.000246	0.000355	0.003496	0.001314	0.001260	0.021339	0.036739	0.000153	0.002527	0.000315	0.000875	0.000395	0.000655	0.000803	0.000492	0.013442	0.009372	0.014668	0.000874	0.005303	0.000313	0.017914	0.000449	0.001936	0.003741	0.021990	0.000911	0.000260	0.100260	0.051196	0.017182	0.005891	0.032214	0.046295	0.013725	0.019746	0.010653	0.001827	0.000639	0.000101	0.002657	0.000706	0.002141	0.000544	0.000148	0.009294	0.014835	0.001181	0.001027	0.002224	0.000102	0.000531	0.001525	0.000252	0.005207	0.007657	0.003225	0.002773	0.001978	0.007295	0.000560	0.000980	0.000851	0.010284	0.000159	0.001501	0.001035	0.000390	0.001901	0.004763	0.000042	0.000309	0.000279	0.000273	0.000241	0.000109	0.000130	0.000279	0.000120	0.000077	0.000098	0.000133	0.000088	0.000131	0.000108	0.000371	0.000187	0.000073	0.000077	0.002631	0.000287	0.000088	0.000139	0.000103	0.000060	0.000164	0.000678	0.000417	0.000212	0.000056	0.000034	0.000047	0.000063	0.000078	0.000128	0.000137	0.000041	0.000309	0.000034	0.000054	0.000056	0.000228	0.000167	0.000106	0.000085	0.000171	0.000043	0.000532	0.000702	0.000258	0.000278	0.000441	0.000029	0.000124	0.000237	0.000036	0.000072	0.000043	0.000095	0.000155	0.000440	0.000295	0.000237	0.000015	0.000024	0.000045	0.000033	0.000074	0.000052	0.000016	0.000050	0.000062	0.000145	0.000283	0.000085	0.000575	0.000147	0.000126	0.000177	0.000137	0.000129	0.000022	0.000052	0.000081	0.000043	0.000010	0.000070	0.000102	0.000039	0.000096	0.000071	0.000038	0.000066	0.000064	0.000002	0.000024	0.000082	0.000050	0.000410	0.000032	0.000048	0.000201	0.000026	0.000097	0.000029	0.000139	0.000105	0.000356	0.000341	0.000176	0.002214	0.000151	0.000883	0.001246	0.000327	0.000744	0.000266	0.000434	0.000359	0.000338	0.001199	0.000695	0.000267	0.000095	0.000035	0.000204	0.000315	0.000264	0.000028	0.000008	0.000048	0.000123	0.000036	0.000035	0.000096	0.000112	0.000137	0.000394	0.000044	0.000011	0.000046	0.000056	0.000011	0.000167	0.000149	0.000169	0.000201	0.000061	0.000034	0.000030	0.000079	0.000093	0.000049	0.000398	0.000076	0.000027	0.000207	0.000199	0.000006	0.000026	0.000132	0.000213	0.000034	0.000186	0.000016	0.000049	0.000184	0.000629	0.000017	0.000184	0.000103	0.000088	0.000611	0.000064	0.000028	0.000044	0.004479	0.000161	0.001084	0.000098	0.000148	0.001163	0.003260	0.001150	0.000289	0.000041	0.000122	0.000054	0.000043	0.000026	0.000160	0.000033	0.000055	0.000232	0.000079	0.000134	0.000856	0.000004	0.000041	0.000022	0.001405	0.000473	0.000504	0.000107	0.000015	0.000012	0.000641	0.000035	0.000327	0.000099	0.000205	0.000093	0.000228	0.000343	0.000442	0.015309	0.001036	0.000083	0.000048	0.007843	0.002172	0.001962	0.000573	0.006282	0.002672	0.006827	0.005291	0.001077	0.001583	0.001943	0.001970	0.007508	0.000203	0.000170	0.005585	0.000937	0.001184	0.007846	0.000267	0.000785	0.000164	0.022480	0.000184	0.000957	0.000418	0.000053
61695121 - Weval - Weval - You’re Mine	61695121	0.016321	0.000234	0.000211	0.000323	0.000076	0.000175	0.000068	0.000072	0.000156	0.000071	0.000119	0.000046	0.000050	0.000059	0.000201	0.000159	0.000200	0.000064	0.000079	0.000051	0.000060	0.000045	0.000105	0.000164	0.000161	0.000027	0.000116	0.002098	0.000298	0.000139	0.000201	0.000252	0.000210	0.000216	0.000088	0.000159	0.000793	0.000435	0.000171	0.000016	0.000293	0.000436	0.000064	0.000125	0.000119	0.000039	0.000314	0.000093	0.000070	0.000102	0.000092	0.000130	0.000033	0.000333	0.000156	0.000130	0.000010	0.000091	0.000079	0.000173	0.000118	0.000049	0.000016	0.000023	0.000949	0.000527	0.000135	0.000026	0.000046	0.000505	0.000107	0.000027	0.001966	0.001104	0.000717	0.000192	0.000169	0.000373	0.000247	0.000075	0.000115	0.000318	0.000099	0.000170	0.000917	0.000062	0.000399	0.000136	0.000114	0.000035	0.000197	0.000203	0.000158	0.000064	0.000111	0.000191	0.000606	0.000447	0.000329	0.000242	0.000120	0.000145	0.000105	0.000094	0.000098	0.000145	0.000054	0.000049	0.000090	0.000056	0.000199	0.000898	0.000455	0.000494	0.000016	0.000107	0.000087	0.000078	0.000072	0.000248	0.000073	0.000025	0.000258	0.000138	0.000348	0.000088	0.002006	0.001202	0.000559	0.000526	0.003973	0.000257	0.000370	0.000117	0.000533	0.001886	0.000456	0.677379	0.054031	0.003826	0.004934	0.000829	0.001255	0.000518	0.000352	0.000149	0.000463	0.000207	0.000178	0.000142	0.000106	0.000136	0.018585	0.015911	0.010633	0.003647	0.001948	0.001666	0.055578	0.065211	0.000459	0.006989	0.016729	0.091286	0.018796	0.006225	0.003996	0.001692	0.012228	0.005107	0.000077	0.005078	0.004721	0.000638	0.000330	0.000389	0.000185	0.002317	0.000275	0.001012	0.001335	0.001116	0.000449	0.000122	0.001183	0.001698	0.000501	0.000770	0.000784	0.000995	0.000101	0.000929	0.000246	0.000445	0.000437	0.002312	0.001287	0.000515	0.000317	0.000254	0.000562	0.000269	0.000600	0.000160	0.000318	0.000878	0.000390	0.000052	0.000517	0.000345	0.000293	0.000950	0.001473	0.007133	0.002297	0.001784	0.004179	0.012250	0.000241	0.004367	0.000877	0.000765	0.000466	0.001130	0.000615	0.000980	0.005090	0.003770	0.002620	0.000903	0.001335	0.000255	0.005779	0.000239	0.000472	0.003151	0.004349	0.001442	0.000149	0.115906	0.011740	0.010806	0.018969	0.130759	0.040719	0.004614	0.053101	0.009153	0.000330	0.000241	0.000095	0.001870	0.000385	0.002147	0.000421	0.000137	0.000865	0.000915	0.000607	0.000546	0.000397	0.000145	0.000229	0.000359	0.000168	0.002130	0.000812	0.005434	0.004162	0.001171	0.014524	0.000308	0.003678	0.000395	0.002407	0.000093	0.000575	0.000684	0.000323	0.001609	0.003125	0.000409	0.002855	0.000287	0.000334	0.000254	0.000054	0.000077	0.000600	0.000054	0.000048	0.000051	0.000150	0.000059	0.000196	0.000145	0.000580	0.000399	0.000082	0.000329	0.006661	0.000692	0.000126	0.000275	0.000254	0.000134	0.000535	0.002255	0.001703	0.000501	0.000464	0.000194	0.000062	0.000095	0.000390	0.000211	0.000277	0.000060	0.000856	0.000063	0.000063	0.000130	0.000354	0.000305	0.000208	0.000121	0.000511	0.000180	0.000369	0.000566	0.000255	0.000291	0.000315	0.000015	0.000079	0.000334	0.000053	0.000107	0.000124	0.000219	0.000220	0.001719	0.000597	0.000507	0.000016	0.000064	0.000074	0.000059	0.000200	0.000104	0.000022	0.000131	0.000123	0.000388	0.000761	0.000286	0.001704	0.000539	0.000323	0.000211	0.000238	0.000302	0.000033	0.000108	0.000175	0.000105	0.000022	0.000062	0.000649	0.000031	0.000254	0.000168	0.000068	0.000031	0.000095	0.000039	0.000142	0.000063	0.000208	0.001395	0.000257	0.000186	0.001679	0.000047	0.000193	0.000057	0.000222	0.000219	0.004559	0.000739	0.000464	0.002001	0.000344	0.001049	0.001100	0.001902	0.001735	0.000720	0.008953	0.009488	0.010257	0.001389	0.002129	0.000392	0.000828	0.000375	0.000648	0.000926	0.000861	0.000310	0.000069	0.000078	0.000147	0.000064	0.000136	0.000216	0.000123	0.000592	0.000879	0.000121	0.000024	0.000068	0.000151	0.000034	0.000288	0.000282	0.000538	0.000218	0.000097	0.000044	0.000083	0.000113	0.000160	0.000084	0.000653	0.000108	0.000067	0.000292	0.000174	0.000013	0.000030	0.000508	0.000578	0.000069	0.000755	0.000030	0.000095	0.000954	0.001678	0.000061	0.000399	0.000235	0.000354	0.001678	0.000101	0.000026	0.000104	0.013478	0.000357	0.003423	0.000245	0.000222	0.001284	0.005589	0.002000	0.000444	0.000116	0.000100	0.000094	0.000076	0.000078	0.000086	0.000066	0.000208	0.000832	0.000322	0.000294	0.000718	0.000010	0.000064	0.000031	0.005431	0.000492	0.000931	0.000241	0.000073	0.000076	0.001753	0.000122	0.000997	0.000119	0.000456	0.000060	0.002704	0.000485	0.000554	0.045392	0.000247	0.000190	0.000045	0.009694	0.010656	0.002469	0.002989	0.017365	0.003905	0.010130	0.004691	0.000865	0.002841	0.003223	0.005970	0.010575	0.001486	0.000721	0.016915	0.004254	0.002484	0.001130	0.000745	0.002094	0.000155	0.039686	0.000719	0.001873	0.000590	0.000172
61695122 - Weval - Weval - Days	61695122	0.021478	0.000270	0.000303	0.001096	0.000061	0.000206	0.000251	0.000060	0.000151	0.000130	0.000156	0.000109	0.000066	0.000064	0.000360	0.000932	0.000366	0.000189	0.000224	0.000087	0.000156	0.000069	0.000467	0.000611	0.000593	0.000143	0.000298	0.015444	0.000357	0.000111	0.000630	0.001741	0.000976	0.001508	0.000845	0.000817	0.001712	0.001149	0.000253	0.000020	0.000601	0.000662	0.000147	0.000066	0.000155	0.000047	0.000232	0.000328	0.000125	0.000495	0.000168	0.000069	0.000022	0.000238	0.000445	0.000177	0.000015	0.000321	0.000113	0.000627	0.000115	0.000124	0.000094	0.000047	0.029211	0.022809	0.000163	0.000013	0.000023	0.000382	0.000056	0.000016	0.003912	0.002703	0.002048	0.000442	0.000377	0.001576	0.000390	0.000193	0.000245	0.000303	0.000050	0.000188	0.000426	0.000056	0.000295	0.000137	0.000120	0.000022	0.000078	0.000075	0.000089	0.000080	0.000092	0.000085	0.000168	0.000145	0.000490	0.000428	0.000206	0.000281	0.000131	0.000121	0.000162	0.000249	0.000099	0.000100	0.000064	0.000035	0.000080	0.001077	0.000470	0.000448	0.000048	0.000097	0.000075	0.000139	0.000159	0.000527	0.000171	0.000033	0.000651	0.000179	0.000225	0.000124	0.000827	0.000622	0.000216	0.000262	0.001411	0.000134	0.000392	0.000132	0.000185	0.000549	0.000097	0.577101	0.021649	0.001539	0.002168	0.000411	0.001040	0.000347	0.000092	0.000086	0.000232	0.000091	0.000125	0.000062	0.000042	0.000160	0.004088	0.002419	0.002574	0.000354	0.000296	0.000175	0.043186	0.049957	0.000057	0.001724	0.003226	0.105978	0.005457	0.000947	0.000746	0.000472	0.002452	0.000310	0.000231	0.000559	0.000518	0.000493	0.000280	0.000227	0.000195	0.000417	0.000089	0.000303	0.000341	0.000405	0.000110	0.000034	0.000253	0.000418	0.000118	0.000272	0.000125	0.000316	0.000050	0.000470	0.000139	0.000138	0.000105	0.001436	0.001081	0.000101	0.000084	0.000083	0.000169	0.000046	0.000260	0.000177	0.000249	0.000242	0.000138	0.000011	0.000704	0.000123	0.000129	0.000653	0.000518	0.001751	0.001081	0.000934	0.007649	0.014441	0.001261	0.003678	0.000927	0.002109	0.001472	0.001365	0.001142	0.000684	0.008625	0.004933	0.004494	0.000489	0.000416	0.000132	0.006509	0.000700	0.001465	0.001392	0.004724	0.000400	0.000061	0.078906	0.014993	0.010907	0.014815	0.037528	0.022022	0.005853	0.011545	0.006813	0.000814	0.000289	0.000103	0.001572	0.001550	0.001338	0.002307	0.000739	0.003529	0.003012	0.000953	0.000999	0.001007	0.000376	0.000696	0.000531	0.000367	0.006269	0.006209	0.002141	0.001733	0.001661	0.008164	0.001821	0.001018	0.000694	0.003894	0.000107	0.000935	0.000667	0.000459	0.001523	0.002985	0.000295	0.000212	0.000136	0.000111	0.000140	0.000039	0.000047	0.000551	0.000051	0.000061	0.000051	0.000142	0.000072	0.000064	0.000053	0.000423	0.000314	0.000070	0.000152	0.002757	0.000300	0.000057	0.000196	0.000127	0.000032	0.000277	0.000752	0.000931	0.000234	0.000578	0.000049	0.000029	0.000043	0.000071	0.000087	0.000203	0.000047	0.000641	0.000030	0.000038	0.000050	0.000483	0.000471	0.000238	0.000185	0.000297	0.000062	0.000320	0.000425	0.000141	0.000150	0.000276	0.000015	0.000052	0.000150	0.000019	0.000081	0.000070	0.000141	0.000090	0.000492	0.000260	0.000339	0.000012	0.000131	0.000056	0.000076	0.000105	0.000061	0.000021	0.000064	0.000078	0.000180	0.000251	0.000107	0.000447	0.000110	0.000089	0.000169	0.000226	0.000559	0.000016	0.000026	0.000160	0.000103	0.000025	0.000098	0.000191	0.000072	0.000216	0.000168	0.000126	0.000026	0.000072	0.000013	0.000302	0.000058	0.000083	0.000946	0.000128	0.000330	0.000945	0.000063	0.000356	0.000068	0.000442	0.000307	0.006029	0.000430	0.000314	0.001045	0.000312	0.000667	0.001464	0.001123	0.001840	0.000324	0.004703	0.008703	0.023299	0.000132	0.002410	0.000287	0.000372	0.000202	0.000331	0.000571	0.000429	0.000142	0.000028	0.000065	0.000121	0.000020	0.000088	0.000152	0.000146	0.000287	0.000657	0.000039	0.000015	0.000056	0.000068	0.000021	0.000236	0.000317	0.000161	0.000314	0.000106	0.000030	0.000033	0.000226	0.000062	0.000046	0.000367	0.000037	0.000041	0.000179	0.000180	0.000015	0.000051	0.000283	0.000411	0.000023	0.000386	0.000050	0.000073	0.000308	0.000893	0.000048	0.000204	0.000188	0.000131	0.001097	0.000092	0.000057	0.000061	0.001426	0.000132	0.000429	0.000147	0.000138	0.000706	0.002656	0.000937	0.000090	0.000045	0.000112	0.000074	0.000036	0.000042	0.000044	0.000045	0.000053	0.000226	0.000159	0.000198	0.000953	0.000013	0.000090	0.000069	0.003312	0.000442	0.000453	0.000132	0.000043	0.000035	0.000491	0.000069	0.000390	0.000113	0.000786	0.000077	0.000656	0.000489	0.000299	0.202307	0.000647	0.000156	0.000114	0.003352	0.006285	0.002126	0.001581	0.006420	0.009956	0.010031	0.002867	0.000383	0.001256	0.002295	0.002348	0.006687	0.000573	0.000284	0.011061	0.009017	0.001210	0.003901	0.000485	0.000680	0.000063	0.254847	0.000329	0.000204	0.000349	0.000030
61695123 - Weval - Weval - Just In Case	61695123	0.041453	0.000273	0.000483	0.002032	0.000192	0.000297	0.000399	0.000181	0.000274	0.000094	0.000160	0.000042	0.000065	0.000081	0.000416	0.000814	0.000647	0.000132	0.000210	0.000151	0.000182	0.000107	0.000634	0.000797	0.000785	0.000382	0.000364	0.002375	0.000192	0.000249	0.000080	0.000099	0.000245	0.000291	0.000236	0.000385	0.001505	0.000403	0.000348	0.000027	0.000627	0.000469	0.000202	0.000123	0.000133	0.000066	0.000237	0.000406	0.000183	0.000331	0.000439	0.001245	0.000166	0.005524	0.001123	0.000619	0.000039	0.001203	0.000137	0.000855	0.001922	0.000583	0.000116	0.000332	0.002920	0.002797	0.000240	0.000071	0.000126	0.000579	0.000166	0.000109	0.013562	0.006605	0.004910	0.001359	0.001225	0.002734	0.001781	0.000433	0.000994	0.002104	0.000824	0.001153	0.000450	0.000284	0.000877	0.003395	0.003486	0.000549	0.000339	0.000359	0.000128	0.000346	0.000573	0.000378	0.000800	0.000713	0.001099	0.000578	0.000253	0.000227	0.000381	0.000342	0.000304	0.000576	0.000252	0.000256	0.000560	0.000236	0.000471	0.001399	0.000593	0.000567	0.000044	0.000173	0.000152	0.000121	0.000094	0.000718	0.000278	0.000057	0.001404	0.000514	0.001307	0.000569	0.002418	0.000855	0.001164	0.000991	0.002631	0.000366	0.001025	0.000348	0.000322	0.001406	0.000142	0.691044	0.073326	0.003274	0.003797	0.000811	0.001261	0.000517	0.000426	0.000106	0.000455	0.000310	0.000291	0.000232	0.000146	0.000158	0.008983	0.007199	0.005686	0.001138	0.000717	0.000605	0.048056	0.074510	0.000303	0.009671	0.015256	0.153888	0.024755	0.007634	0.004658	0.003289	0.014007	0.011034	0.000370	0.002310	0.002466	0.003234	0.000879	0.000294	0.000253	0.000387	0.000090	0.000581	0.000711	0.000704	0.000227	0.000195	0.003255	0.025430	0.003615	0.011022	0.010900	0.001539	0.000203	0.001993	0.000377	0.000515	0.000427	0.006167	0.002496	0.001532	0.001125	0.000226	0.000395	0.000204	0.000452	0.000138	0.000049	0.000209	0.000112	0.000067	0.000635	0.000469	0.000550	0.001284	0.002916	0.015954	0.000341	0.001763	0.004201	0.013174	0.000627	0.003623	0.000792	0.000919	0.000572	0.001357	0.001135	0.000764	0.003723	0.001997	0.002135	0.001162	0.002168	0.000390	0.005932	0.000427	0.000689	0.004473	0.002241	0.002562	0.000166	0.043865	0.005740	0.006943	0.005074	0.039551	0.012045	0.002806	0.005854	0.002222	0.000654	0.000314	0.000258	0.001556	0.001287	0.000585	0.000308	0.000090	0.001075	0.001110	0.000518	0.000334	0.000606	0.000313	0.000331	0.000477	0.000524	0.001795	0.000709	0.003375	0.003320	0.001241	0.006670	0.000164	0.003150	0.000408	0.001881	0.000160	0.000759	0.001718	0.000261	0.000969	0.002598	0.000420	0.000542	0.000369	0.000286	0.000353	0.000107	0.000157	0.000678	0.000117	0.000109	0.000105	0.000189	0.000072	0.000105	0.000090	0.000345	0.000548	0.000351	0.000708	0.007098	0.000689	0.000150	0.000622	0.000245	0.000106	0.000465	0.001688	0.001451	0.000396	0.000276	0.000239	0.000059	0.000112	0.000195	0.000183	0.000312	0.000067	0.001007	0.000057	0.000093	0.000141	0.000584	0.000670	0.000190	0.000192	0.000739	0.000082	0.000442	0.000608	0.000215	0.000292	0.000382	0.000017	0.000088	0.000291	0.000039	0.000094	0.000106	0.000358	0.000158	0.004296	0.027084	0.000542	0.000023	0.000071	0.000143	0.000158	0.000194	0.000100	0.000031	0.000143	0.000162	0.000263	0.005039	0.000402	0.000578	0.001733	0.001798	0.003453	0.004000	0.001033	0.000194	0.000459	0.000270	0.000109	0.000341	0.000113	0.000243	0.000153	0.000315	0.000249	0.000151	0.000078	0.000223	0.000049	0.000129	0.000156	0.000254	0.000709	0.000237	0.000514	0.001176	0.000381	0.000476	0.000530	0.000630	0.000693	0.003782	0.001128	0.000590	0.001597	0.000502	0.002104	0.002352	0.001581	0.002763	0.000823	0.003292	0.004047	0.005591	0.008143	0.002806	0.000292	0.000567	0.000271	0.000499	0.001576	0.001082	0.000260	0.000038	0.000124	0.000177	0.000037	0.000189	0.000291	0.000273	0.000897	0.000747	0.000702	0.000041	0.000066	0.000066	0.000015	0.000263	0.000274	0.000595	0.000887	0.000620	0.000203	0.000151	0.000468	0.001064	0.000655	0.000775	0.000178	0.000150	0.000445	0.002101	0.000054	0.000221	0.000330	0.000434	0.000212	0.000636	0.000111	0.000177	0.000429	0.000616	0.000047	0.000799	0.000257	0.000292	0.001718	0.000120	0.000056	0.000133	0.001494	0.001073	0.001229	0.001863	0.009474	0.000593	0.003780	0.000790	0.004716	0.000223	0.000687	0.000994	0.000288	0.000284	0.003029	0.000301	0.000176	0.001048	0.000310	0.000210	0.001761	0.000090	0.000250	0.000198	0.004941	0.000715	0.000512	0.000138	0.000128	0.000118	0.001052	0.000054	0.001270	0.000135	0.000720	0.000102	0.000895	0.002120	0.000344	0.016457	0.000368	0.000883	0.000457	0.014810	0.005138	0.001707	0.000961	0.011434	0.001097	0.016483	0.012157	0.001600	0.006311	0.005701	0.001306	0.004917	0.002419	0.000310	0.005415	0.001355	0.001797	0.007008	0.001279	0.001016	0.000101	0.023920	0.000474	0.001566	0.000582	0.000122
61695124 - Weval - Weval - You Made It (Part I)	61695124	0.046272	0.000715	0.000285	0.000668	0.000109	0.000236	0.000176	0.000101	0.000193	0.000088	0.000125	0.000054	0.000038	0.000047	0.000242	0.000412	0.000434	0.000148	0.000137	0.000111	0.000140	0.000128	0.000276	0.000319	0.000384	0.000085	0.000804	0.008266	0.000617	0.000193	0.000488	0.000821	0.000578	0.000334	0.000134	0.000638	0.000935	0.001233	0.000197	0.000027	0.000559	0.002324	0.000619	0.000201	0.000230	0.000093	0.000691	0.001111	0.000480	0.000877	0.000409	0.000081	0.000034	0.000195	0.000171	0.000133	0.000029	0.000164	0.000230	0.000962	0.000167	0.000076	0.000102	0.000039	0.000495	0.000802	0.000109	0.000019	0.000044	0.000388	0.000103	0.000029	0.003863	0.002735	0.002325	0.000628	0.000448	0.001082	0.000657	0.000167	0.000362	0.000447	0.000063	0.000261	0.000506	0.000064	0.000467	0.000236	0.000199	0.000064	0.000281	0.000297	0.000416	0.000127	0.000147	0.000144	0.000246	0.000261	0.000352	0.000276	0.000140	0.000228	0.000054	0.000050	0.000096	0.000152	0.000105	0.000107	0.000096	0.000060	0.000155	0.000753	0.000277	0.000243	0.000007	0.000138	0.000117	0.000187	0.000179	0.000192	0.000051	0.000014	0.000736	0.000082	0.000180	0.000049	0.000450	0.000187	0.000122	0.000150	0.000511	0.000100	0.000211	0.000100	0.000212	0.000328	0.000349	0.674023	0.149824	0.005357	0.008214	0.000945	0.003596	0.000619	0.000527	0.000175	0.000403	0.000285	0.000308	0.000161	0.000162	0.000282	0.032097	0.024501	0.022623	0.005207	0.003423	0.002813	0.138990	0.038393	0.000487	0.021706	0.041320	0.052565	0.039414	0.018139	0.009784	0.003288	0.020632	0.003326	0.000187	0.024687	0.019853	0.001160	0.000465	0.000258	0.000295	0.002350	0.000165	0.001169	0.001469	0.001436	0.000763	0.000629	0.005081	0.038777	0.011261	0.008519	0.019082	0.003061	0.000210	0.001244	0.000688	0.001793	0.002816	0.006023	0.001605	0.001247	0.002209	0.000669	0.001058	0.000572	0.000343	0.000272	0.000387	0.000590	0.000198	0.000076	0.001661	0.001705	0.000109	0.043575	0.001021	0.027676	0.005312	0.000980	0.004241	0.008997	0.000628	0.007189	0.001386	0.000778	0.000330	0.000872	0.000412	0.000569	0.001594	0.001074	0.001235	0.000453	0.000887	0.000148	0.002310	0.000269	0.000442	0.003673	0.001544	0.004040	0.000332	0.127558	0.007036	0.003962	0.030643	0.100500	0.012209	0.003616	0.038677	0.005256	0.000754	0.000466	0.000080	0.000855	0.000488	0.001572	0.001149	0.000286	0.000703	0.000458	0.001020	0.000545	0.000743	0.000276	0.000175	0.000404	0.000230	0.001957	0.001349	0.001595	0.001017	0.000702	0.003756	0.000444	0.000843	0.000453	0.001044	0.000207	0.000198	0.000356	0.000220	0.000728	0.000999	0.000259	0.000416	0.000196	0.000235	0.000179	0.000049	0.000055	0.000443	0.000050	0.000032	0.000046	0.000091	0.000059	0.000109	0.000081	0.000344	0.000193	0.000088	0.000106	0.002967	0.000326	0.000070	0.000142	0.000105	0.000103	0.000232	0.000865	0.001434	0.000222	0.000090	0.000060	0.000057	0.000083	0.000139	0.000177	0.000205	0.000059	0.000667	0.000039	0.000141	0.000100	0.000227	0.000231	0.000109	0.000085	0.000225	0.000076	0.000394	0.000574	0.000262	0.000250	0.000343	0.000017	0.000111	0.000178	0.000034	0.000059	0.000073	0.000129	0.000117	0.000784	0.000323	0.000288	0.000010	0.000126	0.000042	0.000057	0.000104	0.000080	0.000013	0.000047	0.000073	0.000190	0.000438	0.000553	0.001855	0.000195	0.000146	0.000119	0.000221	0.000245	0.000043	0.000193	0.000148	0.000101	0.000018	0.000035	0.000095	0.000067	0.000188	0.000145	0.000145	0.000136	0.000058	0.000048	0.000121	0.000198	0.000043	0.000475	0.000056	0.000158	0.001226	0.000034	0.000214	0.000080	0.000309	0.000206	0.001359	0.000381	0.000222	0.000706	0.000207	0.001333	0.001295	0.000799	0.000911	0.000334	0.000974	0.000983	0.001469	0.013395	0.001146	0.000217	0.000230	0.000113	0.000374	0.000467	0.000400	0.000090	0.000016	0.000043	0.000261	0.000034	0.000091	0.000171	0.000191	0.000366	0.000689	0.000048	0.000016	0.000083	0.000119	0.000015	0.000315	0.000325	0.000183	0.000136	0.000044	0.000030	0.000019	0.000235	0.000088	0.000075	0.000261	0.000052	0.000049	0.000257	0.000167	0.000012	0.000065	0.000355	0.000191	0.000107	0.000205	0.000037	0.000048	0.000173	0.000215	0.000015	0.000137	0.000125	0.000084	0.000522	0.000067	0.000015	0.000052	0.005794	0.000250	0.001148	0.000087	0.000227	0.004954	0.012829	0.003153	0.000114	0.000076	0.000218	0.000088	0.000051	0.000093	0.000170	0.000089	0.000069	0.000287	0.000067	0.000242	0.000440	0.000012	0.000055	0.000034	0.002646	0.000495	0.000614	0.000359	0.000017	0.000036	0.000561	0.000040	0.000326	0.000045	0.000864	0.000079	0.000292	0.000753	0.000290	0.005773	0.000160	0.000631	0.000079	0.009976	0.007420	0.003580	0.002409	0.005302	0.000961	0.018772	0.016109	0.002284	0.002533	0.002112	0.006750	0.010131	0.000664	0.000224	0.003380	0.001016	0.005220	0.005723	0.000223	0.000474	0.000130	0.004910	0.000235	0.001879	0.000760	0.000057
61695125 - Weval - Weval - You Made It (Part II)	61695125	0.036456	0.000463	0.000346	0.000332	0.000191	0.000324	0.000082	0.000148	0.000182	0.000138	0.000204	0.000081	0.000034	0.000045	0.000236	0.000328	0.000276	0.000054	0.000082	0.000078	0.000066	0.000075	0.000124	0.000142	0.000249	0.000094	0.000456	0.007401	0.000157	0.000410	0.000132	0.000153	0.000462	0.000217	0.000071	0.000183	0.001342	0.000263	0.000186	0.000020	0.000415	0.000304	0.000055	0.000046	0.000127	0.000032	0.000149	0.000149	0.000126	0.000215	0.000152	0.000147	0.000043	0.000332	0.000210	0.000151	0.000010	0.000293	0.000112	0.000383	0.000139	0.000073	0.000037	0.000082	0.001102	0.000895	0.000210	0.000058	0.000081	0.000813	0.000209	0.000013	0.001911	0.001648	0.001211	0.000336	0.000259	0.000443	0.000487	0.000108	0.000179	0.000259	0.000105	0.000151	0.000156	0.000038	0.000161	0.000140	0.000170	0.000036	0.000058	0.000058	0.001172	0.000072	0.000198	0.000086	0.000227	0.000167	0.000311	0.000140	0.000073	0.000085	0.000078	0.000073	0.000108	0.000214	0.000091	0.000096	0.000055	0.000043	0.000103	0.000493	0.000212	0.000193	0.000007	0.000117	0.000085	0.000048	0.000043	0.000089	0.000041	0.000007	0.000361	0.000085	0.000209	0.000111	0.000419	0.000132	0.000126	0.000169	0.000410	0.000084	0.000177	0.000085	0.000088	0.001186	0.000118	0.656780	0.077437	0.004805	0.006413	0.001390	0.001973	0.000999	0.000228	0.000317	0.000936	0.000457	0.000287	0.000299	0.000314	0.000208	0.021604	0.016592	0.012781	0.001739	0.001357	0.000708	0.067134	0.108697	0.001302	0.038339	0.067066	0.145148	0.067023	0.035925	0.029035	0.012683	0.056541	0.019642	0.000293	0.013423	0.013215	0.006145	0.000612	0.000471	0.000751	0.000570	0.000241	0.001047	0.001534	0.001248	0.000859	0.000485	0.005459	0.013763	0.002195	0.006516	0.005624	0.001942	0.000191	0.001620	0.000663	0.000867	0.000927	0.004340	0.001586	0.001881	0.002153	0.000373	0.000481	0.000177	0.000465	0.000200	0.000383	0.000335	0.000160	0.000046	0.001404	0.002021	0.000398	0.001189	0.001100	0.010249	0.001443	0.001499	0.011313	0.009908	0.000448	0.008105	0.001474	0.001734	0.000596	0.001962	0.002493	0.001347	0.006642	0.005485	0.007695	0.001357	0.007760	0.000484	0.030734	0.000861	0.001661	0.007981	0.021051	0.002718	0.000228	0.087807	0.031758	0.018838	0.007658	0.066983	0.036884	0.009079	0.008826	0.007796	0.001697	0.001029	0.000481	0.002896	0.000947	0.001169	0.000411	0.000081	0.006201	0.006755	0.000509	0.000458	0.001225	0.000221	0.001047	0.002692	0.000536	0.003763	0.002059	0.005506	0.004346	0.001689	0.010655	0.000135	0.004042	0.000500	0.008317	0.000154	0.001403	0.003245	0.000268	0.000963	0.008106	0.000222	0.000446	0.000132	0.000151	0.000116	0.000034	0.000045	0.000251	0.000043	0.000042	0.000043	0.000093	0.000030	0.000057	0.000048	0.000109	0.000221	0.000061	0.000161	0.002621	0.000366	0.000067	0.000184	0.000123	0.000081	0.000152	0.000629	0.001092	0.000204	0.000142	0.000018	0.000029	0.000029	0.000101	0.000086	0.000116	0.000028	0.000804	0.000016	0.000052	0.000059	0.000217	0.000192	0.000086	0.000070	0.000160	0.000032	0.000145	0.000214	0.000086	0.000096	0.000128	0.000004	0.000035	0.000151	0.000025	0.000052	0.000044	0.000052	0.000114	0.000643	0.000506	0.000220	0.000005	0.000016	0.000023	0.000020	0.000084	0.000063	0.000011	0.000037	0.000065	0.000161	0.000393	0.000330	0.000735	0.000169	0.000092	0.000243	0.000544	0.000378	0.000016	0.000070	0.000108	0.000051	0.000039	0.000039	0.000089	0.000042	0.000115	0.000087	0.000044	0.000033	0.000042	0.000007	0.000030	0.000041	0.000163	0.000570	0.000073	0.000087	0.000280	0.000086	0.000372	0.000130	0.000409	0.000248	0.002231	0.000696	0.000434	0.002295	0.000214	0.001376	0.001790	0.000718	0.001028	0.000404	0.001738	0.002071	0.001821	0.004850	0.001903	0.000109	0.000181	0.000069	0.000452	0.000879	0.000688	0.000080	0.000014	0.000053	0.000060	0.000012	0.000098	0.000096	0.000120	0.000239	0.000265	0.000049	0.000007	0.000016	0.000029	0.000005	0.000089	0.000109	0.000241	0.000160	0.000056	0.000026	0.000044	0.000107	0.000147	0.000061	0.000480	0.000066	0.000030	0.000080	0.000125	0.000002	0.000033	0.000366	0.000349	0.000071	0.000273	0.000018	0.000034	0.000241	0.000450	0.000035	0.000223	0.000064	0.000106	0.000536	0.000022	0.000019	0.000044	0.003548	0.000175	0.000924	0.000168	0.000407	0.000890	0.002380	0.000741	0.000246	0.000095	0.000110	0.000085	0.000041	0.000057	0.000212	0.000076	0.000044	0.000829	0.000101	0.000075	0.002641	0.000004	0.000086	0.000057	0.004558	0.000444	0.001159	0.000293	0.000028	0.000043	0.000559	0.000050	0.000546	0.000053	0.000480	0.000024	0.000340	0.001197	0.000518	0.005987	0.000184	0.000622	0.000087	0.009034	0.016122	0.002238	0.002812	0.009025	0.001572	0.008289	0.006278	0.001220	0.001798	0.001157	0.001546	0.004500	0.000403	0.000135	0.004126	0.000432	0.001216	0.004394	0.000788	0.000450	0.000047	0.011009	0.000178	0.001351	0.000522	0.000116
61695126 - Weval - Weval - Years To Build	61695126	0.019419	0.000191	0.000271	0.000577	0.000057	0.000139	0.000081	0.000048	0.000207	0.000114	0.000148	0.000080	0.000019	0.000031	0.000229	0.000513	0.000209	0.000071	0.000093	0.000051	0.000064	0.000043	0.000155	0.000137	0.000214	0.000047	0.000191	0.036267	0.000205	0.000385	0.000140	0.000205	0.000727	0.000799	0.000272	0.000572	0.010823	0.000660	0.000132	0.000016	0.000332	0.000380	0.000061	0.000055	0.000142	0.000034	0.000147	0.000330	0.000117	0.000204	0.000114	0.000059	0.000029	0.000187	0.000289	0.000209	0.000014	0.000279	0.000147	0.000285	0.000153	0.000087	0.000076	0.000118	0.000887	0.001424	0.000089	0.000023	0.000025	0.000300	0.000066	0.000010	0.002264	0.001704	0.001314	0.000416	0.000282	0.000440	0.000390	0.000118	0.000177	0.000261	0.000116	0.000169	0.000246	0.000042	0.000176	0.000129	0.000139	0.000032	0.000056	0.000054	0.001093	0.000083	0.000149	0.000068	0.000135	0.000113	0.000389	0.000205	0.000099	0.000151	0.000125	0.000117	0.000094	0.000176	0.000082	0.000081	0.000026	0.000017	0.000061	0.000661	0.000278	0.000253	0.000012	0.000088	0.000067	0.000106	0.000113	0.000246	0.000075	0.000016	0.000400	0.000131	0.000120	0.000093	0.000377	0.000164	0.000146	0.000140	0.000558	0.000052	0.000314	0.000161	0.000054	0.000775	0.000141	0.722177	0.039560	0.002779	0.003599	0.000633	0.001613	0.000528	0.000320	0.000153	0.000311	0.000180	0.000079	0.000130	0.000165	0.000373	0.017194	0.013296	0.015183	0.001203	0.001085	0.000525	0.075875	0.072367	0.000278	0.006432	0.007573	0.130162	0.009969	0.003346	0.002338	0.001649	0.005982	0.002879	0.000171	0.002199	0.002058	0.001899	0.000464	0.000261	0.000655	0.002422	0.000530	0.001663	0.002046	0.002274	0.001143	0.000119	0.000739	0.001657	0.000368	0.000886	0.000485	0.000630	0.000081	0.000584	0.000399	0.000276	0.000231	0.001609	0.001137	0.000290	0.000352	0.000367	0.001489	0.000649	0.000831	0.000424	0.000837	0.001102	0.000701	0.000080	0.000262	0.000186	0.000037	0.001158	0.000509	0.010704	0.004070	0.003006	0.035855	0.059184	0.001995	0.004863	0.000935	0.002388	0.001067	0.001406	0.002061	0.000638	0.016099	0.007812	0.040823	0.000716	0.002561	0.000182	0.019388	0.000504	0.001329	0.002866	0.016785	0.000967	0.000166	0.112577	0.036536	0.012274	0.013224	0.055449	0.019384	0.011677	0.013781	0.006808	0.001681	0.000505	0.000197	0.002554	0.002998	0.001286	0.001587	0.000331	0.009674	0.011254	0.001744	0.001112	0.004299	0.000164	0.001471	0.002761	0.000177	0.009018	0.010937	0.002171	0.002065	0.003090	0.007304	0.000527	0.000579	0.001364	0.012170	0.000110	0.002257	0.001981	0.000460	0.001593	0.006622	0.000139	0.000131	0.000141	0.000114	0.000140	0.000062	0.000082	0.000270	0.000063	0.000062	0.000057	0.000101	0.000057	0.000069	0.000058	0.000239	0.000228	0.000060	0.000176	0.002142	0.000277	0.000059	0.000122	0.000120	0.000042	0.000121	0.000493	0.000542	0.000156	0.000125	0.000008	0.000024	0.000028	0.000072	0.000074	0.000123	0.000033	0.000162	0.000013	0.000032	0.000035	0.000231	0.000233	0.000090	0.000082	0.000159	0.000034	0.000261	0.000372	0.000186	0.000178	0.000236	0.000008	0.000046	0.000218	0.000028	0.000070	0.000076	0.000082	0.000138	0.000417	0.000517	0.000221	0.000009	0.000019	0.000022	0.000025	0.000069	0.000063	0.000012	0.000036	0.000057	0.000120	0.000189	0.000634	0.001478	0.000057	0.000071	0.000146	0.000407	0.000383	0.000013	0.000024	0.000374	0.000233	0.000094	0.000070	0.000146	0.000041	0.000099	0.000067	0.000046	0.000038	0.000031	0.000007	0.000035	0.000036	0.000132	0.000709	0.000433	0.000167	0.000149	0.000069	0.000507	0.000191	0.000607	0.000175	0.001928	0.000487	0.000496	0.001617	0.000267	0.002165	0.002289	0.001130	0.001263	0.000368	0.001321	0.001903	0.003245	0.000273	0.001526	0.000193	0.000220	0.000098	0.000562	0.000724	0.000640	0.000091	0.000024	0.000040	0.000088	0.000009	0.000115	0.000054	0.000185	0.000286	0.000263	0.000075	0.000015	0.000019	0.000029	0.000009	0.000080	0.000088	0.000384	0.000671	0.000267	0.000058	0.000061	0.000495	0.000201	0.000138	0.000879	0.000087	0.000051	0.000103	0.000267	0.000011	0.000093	0.001062	0.000897	0.000217	0.000228	0.000032	0.000043	0.000121	0.000485	0.000048	0.000133	0.000095	0.000069	0.000827	0.000033	0.000069	0.000048	0.005778	0.000142	0.000641	0.000159	0.000362	0.002636	0.005763	0.001902	0.000091	0.000123	0.000115	0.000071	0.000051	0.000226	0.000279	0.000044	0.000053	0.000986	0.000211	0.000065	0.001564	0.000042	0.000124	0.000072	0.003752	0.000611	0.001467	0.000724	0.000019	0.000052	0.000548	0.000043	0.000468	0.000095	0.000273	0.000056	0.000237	0.000524	0.000752	0.006627	0.001046	0.000582	0.000150	0.008599	0.022590	0.001739	0.005319	0.007671	0.002284	0.010180	0.004508	0.000614	0.001218	0.001250	0.003533	0.007430	0.000764	0.000179	0.007601	0.000664	0.002225	0.012234	0.000373	0.000688	0.000117	0.008541	0.000177	0.000471	0.000880	0.000051
136062170 - Headie One - GANG - GANG	136062170	0.055041	0.000971	0.000491	0.000720	0.000159	0.000617	0.000130	0.000263	0.000664	0.000655	0.000629	0.000207	0.000048	0.000060	0.000649	0.000507	0.000395	0.000139	0.000199	0.000219	0.000126	0.000175	0.000492	0.000432	0.000588	0.000185	0.000742	0.045087	0.000646	0.000681	0.000484	0.000577	0.001390	0.000770	0.000191	0.000599	0.325990	0.001110	0.000723	0.000126	0.000925	0.000587	0.000063	0.000187	0.000406	0.000048	0.000176	0.000704	0.000427	0.000272	0.000047	0.000055	0.000048	0.000092	0.000729	0.000308	0.000019	0.000154	0.000233	0.000177	0.000156	0.000091	0.000254	0.000260	0.000777	0.000530	0.000187	0.000049	0.000041	0.000632	0.000138	0.000015	0.003282	0.002595	0.001893	0.000488	0.000387	0.001115	0.000365	0.000245	0.000336	0.000356	0.000069	0.000211	0.000146	0.000069	0.000314	0.000179	0.000129	0.000089	0.000064	0.000065	0.000102	0.000144	0.000259	0.000106	0.000264	0.000228	0.001043	0.000508	0.000246	0.000295	0.000308	0.000279	0.000216	0.000338	0.000286	0.000329	0.000060	0.000045	0.000195	0.001212	0.000536	0.000503	0.000027	0.000107	0.000076	0.000127	0.000116	0.000355	0.000063	0.000017	0.000684	0.000210	0.000182	0.000086	0.000465	0.000188	0.000216	0.000159	0.000403	0.000050	0.000367	0.000126	0.000065	0.000437	0.000260	0.792070	0.012609	0.002076	0.002448	0.000601	0.000633	0.000366	0.000171	0.000181	0.000324	0.000149	0.000116	0.000111	0.000090	0.000164	0.002309	0.001863	0.001217	0.000839	0.000690	0.000355	0.009602	0.020191	0.000116	0.001370	0.001753	0.013680	0.001999	0.000582	0.000515	0.000192	0.001242	0.000260	0.000066	0.000428	0.000355	0.000252	0.000140	0.000116	0.000293	0.000488	0.000136	0.000889	0.001236	0.001077	0.000399	0.000046	0.000832	0.000758	0.000164	0.000449	0.000168	0.000772	0.000128	0.000997	0.000239	0.000362	0.000205	0.002247	0.001255	0.000285	0.000350	0.000197	0.000266	0.000120	0.000111	0.000055	0.000318	0.000414	0.000190	0.000014	0.000789	0.000192	0.000096	0.000585	0.000729	0.007022	0.002542	0.006241	0.034249	0.382801	0.003841	0.003195	0.003200	0.007622	0.001088	0.004440	0.003717	0.000315	0.022951	0.003264	0.022216	0.000514	0.000454	0.000188	0.011968	0.000427	0.001979	0.005009	0.008470	0.001283	0.000447	0.047137	0.012776	0.005386	0.013343	0.014110	0.017462	0.004739	0.006481	0.002754	0.001313	0.000191	0.000096	0.006272	0.000237	0.003993	0.006359	0.000883	0.004142	0.006505	0.000464	0.001047	0.001214	0.000201	0.000190	0.002622	0.000190	0.014599	0.021538	0.004113	0.002178	0.000604	0.012645	0.000340	0.000265	0.000356	0.015614	0.000068	0.001075	0.001675	0.000537	0.002525	0.014928	0.000369	0.000326	0.000093	0.000071	0.000083	0.000027	0.000033	0.000248	0.000046	0.000046	0.000036	0.000068	0.000033	0.000053	0.000040	0.000101	0.000183	0.000056	0.000170	0.001713	0.000166	0.000032	0.000090	0.000079	0.000026	0.000164	0.000616	0.000367	0.000116	0.000226	0.000015	0.000039	0.000043	0.000103	0.000102	0.000113	0.000027	0.000175	0.000015	0.000042	0.000035	0.000289	0.000301	0.000147	0.000088	0.000133	0.000042	0.000153	0.000201	0.000076	0.000100	0.000133	0.000006	0.000033	0.000098	0.000018	0.000027	0.000030	0.000032	0.000068	0.000285	0.000350	0.000170	0.000007	0.000025	0.000027	0.000026	0.000069	0.000039	0.000012	0.000047	0.000048	0.000121	0.000196	0.000202	0.000299	0.000067	0.000090	0.000056	0.000339	0.000819	0.000005	0.000019	0.000118	0.000077	0.000174	0.000038	0.000065	0.000033	0.000090	0.000066	0.000065	0.000027	0.000047	0.000037	0.000047	0.000029	0.000349	0.000519	0.000081	0.000221	0.000141	0.000055	0.000634	0.000103	0.000792	0.000234	0.002195	0.000981	0.000479	0.001463	0.000385	0.002582	0.002236	0.000582	0.000952	0.000189	0.001423	0.002587	0.002750	0.000190	0.002135	0.000081	0.000171	0.000089	0.000377	0.000639	0.000582	0.000091	0.000014	0.000047	0.000048	0.000007	0.000058	0.000061	0.000329	0.000420	0.000190	0.000026	0.000009	0.000027	0.000046	0.000008	0.000071	0.000073	0.000445	0.000473	0.000110	0.000057	0.000046	0.000425	0.000190	0.000120	0.001766	0.000057	0.000105	0.000111	0.000620	0.000007	0.000027	0.000250	0.000126	0.000121	0.000175	0.000041	0.000059	0.000218	0.000622	0.000041	0.000150	0.000049	0.000074	0.000156	0.000015	0.000021	0.000018	0.005716	0.000125	0.000630	0.000136	0.000169	0.000685	0.002144	0.000645	0.000110	0.000870	0.000590	0.000053	0.000029	0.000144	0.000085	0.000038	0.000032	0.001471	0.000533	0.000098	0.001166	0.000022	0.000105	0.000101	0.004169	0.000231	0.000282	0.000085	0.000039	0.000023	0.000733	0.000023	0.000429	0.000053	0.000544	0.000030	0.000349	0.001022	0.000230	0.005195	0.000301	0.000380	0.000244	0.006400	0.022876	0.002332	0.003978	0.010690	0.003045	0.010250	0.004420	0.000723	0.001186	0.001037	0.004077	0.006393	0.000377	0.000169	0.005704	0.000453	0.000804	0.002035	0.000350	0.000271	0.000050	0.004205	0.000169	0.000977	0.002095	0.000052
231814826 - KH - Looking At Your Pager - Looking at Your Pager (Extended)	231814826	0.042770	0.000180	0.000874	0.002345	0.000133	0.000374	0.000286	0.000182	0.000141	0.000058	0.000095	0.000033	0.000022	0.000030	0.000130	0.000756	0.000363	0.000154	0.000155	0.000107	0.000160	0.000083	0.000422	0.000356	0.000215	0.000091	0.000131	0.013377	0.000125	0.000540	0.000062	0.000234	0.000334	0.001305	0.000927	0.000720	0.001475	0.000282	0.000168	0.000021	0.000336	0.000174	0.000035	0.000107	0.000051	0.000031	0.000116	0.000218	0.000074	0.000135	0.000128	0.000085	0.000042	0.000181	0.000752	0.000537	0.000021	0.000102	0.000098	0.000266	0.000260	0.000372	0.000161	0.000266	0.000297	0.000372	0.000102	0.000036	0.000034	0.000320	0.000066	0.000017	0.002871	0.002323	0.001620	0.000479	0.000347	0.000534	0.000517	0.000130	0.000276	0.000458	0.000093	0.000406	0.000122	0.000083	0.000427	0.000171	0.000173	0.000059	0.000143	0.000143	0.003099	0.000148	0.000315	0.000191	0.000271	0.000267	0.001107	0.000518	0.000284	0.000305	0.000367	0.000371	0.000364	0.000519	0.000261	0.000258	0.000035	0.000023	0.000056	0.001535	0.000673	0.000606	0.000044	0.000169	0.000123	0.000169	0.000138	0.000173	0.000056	0.000048	0.000433	0.000223	0.000128	0.000180	0.001296	0.000556	0.000757	0.000674	0.000714	0.000165	0.000724	0.000382	0.000048	0.000960	0.000025	0.710604	0.019146	0.002173	0.002183	0.000467	0.000398	0.000417	0.000300	0.000173	0.000310	0.000519	0.001133	0.000716	0.001441	0.000521	0.005602	0.003869	0.003254	0.000333	0.000319	0.000098	0.029838	0.066661	0.000976	0.002742	0.002582	0.106637	0.003911	0.000887	0.000642	0.000451	0.001992	0.000121	0.000361	0.000725	0.000615	0.001129	0.000367	0.000149	0.000223	0.000279	0.002210	0.013328	0.014662	0.019381	0.001870	0.000137	0.000413	0.000724	0.000195	0.000539	0.000205	0.000949	0.000140	0.001438	0.001201	0.000341	0.000149	0.001941	0.000846	0.000246	0.000396	0.000652	0.001714	0.000515	0.001384	0.000290	0.000497	0.005958	0.003840	0.000062	0.000357	0.000301	0.000121	0.000219	0.001356	0.001615	0.002183	0.001425	0.018932	0.013908	0.000304	0.001384	0.000383	0.000604	0.000421	0.000685	0.000791	0.000135	0.008304	0.001618	0.010604	0.000701	0.000537	0.000307	0.006268	0.000838	0.000991	0.001277	0.027798	0.001040	0.000177	0.215054	0.099129	0.047513	0.035212	0.153613	0.094821	0.049020	0.003167	0.046282	0.000750	0.000272	0.000102	0.002069	0.011523	0.002165	0.000457	0.000109	0.005718	0.010442	0.001150	0.000644	0.001255	0.000563	0.000464	0.000499	0.000657	0.003998	0.005416	0.006049	0.002839	0.003251	0.012924	0.001062	0.001344	0.001359	0.043883	0.000171	0.004611	0.002188	0.000467	0.002124	0.009290	0.000022	0.000072	0.000154	0.000129	0.000134	0.000023	0.000027	0.000340	0.000054	0.000050	0.000047	0.000097	0.000038	0.000072	0.000057	0.000104	0.000234	0.000061	0.000270	0.002816	0.000350	0.000056	0.000175	0.000105	0.000071	0.000207	0.000591	0.000818	0.000155	0.000550	0.000020	0.000018	0.000030	0.000078	0.000065	0.000165	0.000025	0.000470	0.000030	0.000262	0.000053	0.000444	0.000436	0.000285	0.000131	0.000213	0.000055	0.000259	0.000391	0.000103	0.000149	0.000217	0.000005	0.000042	0.000135	0.000021	0.000030	0.000025	0.000060	0.000078	0.000357	0.000137	0.000234	0.000007	0.000014	0.000037	0.000024	0.000087	0.000059	0.000022	0.000052	0.000067	0.000109	0.000306	0.001202	0.004873	0.000096	0.000070	0.000141	0.000450	0.000217	0.000018	0.000038	0.000248	0.000157	0.000121	0.000066	0.000079	0.000032	0.000088	0.000055	0.000125	0.000030	0.000041	0.000112	0.000099	0.000045	0.000502	0.000833	0.000171	0.000446	0.000179	0.000212	0.001172	0.000456	0.001073	0.000454	0.002785	0.000895	0.000442	0.006689	0.000479	0.000673	0.001941	0.000890	0.002870	0.001246	0.002178	0.004095	0.007411	0.000152	0.000579	0.000076	0.000464	0.000215	0.001508	0.001469	0.001674	0.000274	0.000067	0.000108	0.000121	0.000013	0.000096	0.000160	0.000301	0.000396	0.000302	0.000104	0.000019	0.000020	0.000051	0.000019	0.000070	0.000073	0.000132	0.000498	0.000130	0.000058	0.000033	0.000488	0.000132	0.000105	0.000522	0.000038	0.000029	0.000115	0.000190	0.000014	0.000128	0.001283	0.000896	0.000060	0.000251	0.000047	0.000092	0.000360	0.000546	0.000086	0.000107	0.000088	0.000099	0.000607	0.000039	0.000063	0.000024	0.000589	0.000095	0.000394	0.000096	0.000145	0.001199	0.001684	0.000542	0.000085	0.000063	0.000104	0.000057	0.000028	0.000121	0.000179	0.000057	0.000067	0.000637	0.000392	0.000081	0.000748	0.000096	0.000297	0.000322	0.002654	0.001254	0.002867	0.000519	0.000017	0.000066	0.000518	0.000035	0.000492	0.000078	0.000949	0.000044	0.000074	0.000938	0.005196	0.002851	0.003632	0.000923	0.000465	0.004727	0.005331	0.002452	0.002111	0.005712	0.002168	0.014377	0.003169	0.000444	0.001592	0.001325	0.001237	0.004369	0.000209	0.000188	0.005011	0.000407	0.000636	0.001193	0.000518	0.000236	0.000046	0.002521	0.000148	0.000386	0.000323	0.000072
231814828 - KH - Looking At Your Pager - Looking at Your Pager	231814828	0.045060	0.000190	0.001041	0.002438	0.000140	0.000478	0.000244	0.000250	0.000151	0.000070	0.000125	0.000034	0.000025	0.000027	0.000151	0.000709	0.000347	0.000127	0.000154	0.000108	0.000139	0.000088	0.000320	0.000321	0.000204	0.000091	0.000111	0.015929	0.000154	0.000972	0.000066	0.000277	0.000494	0.002259	0.001703	0.001259	0.001659	0.000349	0.000140	0.000025	0.000296	0.000174	0.000021	0.000102	0.000051	0.000029	0.000102	0.000167	0.000056	0.000097	0.000078	0.000094	0.000067	0.000203	0.000750	0.000492	0.000038	0.000157	0.000104	0.000248	0.000231	0.000428	0.000192	0.000386	0.000354	0.000393	0.000103	0.000051	0.000030	0.000347	0.000064	0.000015	0.002612	0.002055	0.001452	0.000398	0.000316	0.000479	0.000461	0.000111	0.000262	0.000455	0.000107	0.000424	0.000113	0.000078	0.000382	0.000202	0.000200	0.000069	0.000115	0.000116	0.002838	0.000146	0.000392	0.000170	0.000296	0.000279	0.001292	0.000535	0.000291	0.000282	0.000479	0.000485	0.000334	0.000481	0.000298	0.000308	0.000036	0.000022	0.000051	0.001413	0.000598	0.000509	0.000043	0.000168	0.000120	0.000131	0.000109	0.000179	0.000061	0.000035	0.000363	0.000227	0.000142	0.000146	0.001163	0.000454	0.000728	0.000609	0.001047	0.000141	0.000749	0.000382	0.000051	0.001258	0.000030	0.760911	0.019280	0.001898	0.001943	0.000424	0.000384	0.000358	0.000198	0.000139	0.000320	0.000346	0.001090	0.000407	0.000642	0.000345	0.003521	0.002366	0.001714	0.000315	0.000273	0.000108	0.018860	0.066051	0.000522	0.003248	0.003078	0.070318	0.004963	0.001062	0.000708	0.000535	0.002366	0.000169	0.000481	0.000840	0.000700	0.001547	0.000660	0.000206	0.000435	0.000284	0.000896	0.002575	0.003233	0.003431	0.000644	0.000100	0.000481	0.000715	0.000174	0.000454	0.000212	0.000793	0.000133	0.001192	0.000573	0.000311	0.000148	0.001638	0.000615	0.000205	0.000300	0.000288	0.001376	0.000414	0.001364	0.000261	0.000321	0.002290	0.001882	0.000053	0.000308	0.000285	0.000098	0.000414	0.000910	0.001137	0.001054	0.001837	0.022067	0.014210	0.000474	0.001590	0.000430	0.000766	0.000485	0.000856	0.001152	0.000164	0.009962	0.001740	0.017348	0.000761	0.000704	0.000296	0.009102	0.001103	0.001241	0.001754	0.043323	0.001072	0.000221	0.235586	0.131666	0.051721	0.035092	0.170841	0.094416	0.066589	0.001970	0.047318	0.000982	0.000315	0.000107	0.002646	0.010202	0.001630	0.000689	0.000154	0.006757	0.014159	0.000927	0.000743	0.001331	0.000720	0.000470	0.000744	0.000689	0.004779	0.008207	0.005193	0.002487	0.003165	0.013861	0.000635	0.001047	0.001168	0.069487	0.000159	0.005068	0.003528	0.000320	0.001708	0.013885	0.000021	0.000073	0.000134	0.000112	0.000125	0.000019	0.000023	0.000318	0.000040	0.000043	0.000036	0.000091	0.000029	0.000066	0.000051	0.000099	0.000246	0.000045	0.000251	0.002684	0.000356	0.000056	0.000176	0.000106	0.000079	0.000183	0.000550	0.001063	0.000175	0.000524	0.000022	0.000018	0.000028	0.000080	0.000055	0.000132	0.000020	0.000561	0.000028	0.000134	0.000045	0.000370	0.000359	0.000221	0.000115	0.000178	0.000045	0.000233	0.000344	0.000110	0.000173	0.000199	0.000004	0.000040	0.000108	0.000016	0.000026	0.000022	0.000056	0.000062	0.000420	0.000146	0.000222	0.000005	0.000014	0.000028	0.000021	0.000090	0.000058	0.000020	0.000043	0.000068	0.000102	0.000327	0.000493	0.001439	0.000113	0.000079	0.000176	0.000590	0.000234	0.000020	0.000040	0.000264	0.000159	0.000143	0.000063	0.000098	0.000033	0.000089	0.000059	0.000119	0.000035	0.000042	0.000137	0.000108	0.000039	0.000602	0.000766	0.000186	0.000483	0.000209	0.000160	0.001303	0.000469	0.001110	0.000501	0.002715	0.000882	0.000530	0.005088	0.000394	0.000542	0.001067	0.000848	0.002532	0.001148	0.002340	0.003750	0.006910	0.000192	0.000699	0.000085	0.000470	0.000246	0.001240	0.001771	0.001949	0.000296	0.000058	0.000122	0.000149	0.000011	0.000106	0.000171	0.000266	0.000466	0.000296	0.000108	0.000018	0.000019	0.000045	0.000016	0.000064	0.000072	0.000118	0.000463	0.000135	0.000053	0.000034	0.000438	0.000118	0.000100	0.000591	0.000035	0.000023	0.000100	0.000181	0.000010	0.000074	0.000918	0.000762	0.000058	0.000285	0.000044	0.000087	0.000390	0.000625	0.000095	0.000116	0.000065	0.000103	0.000583	0.000036	0.000068	0.000024	0.000696	0.000112	0.000439	0.000111	0.000174	0.000509	0.001115	0.000388	0.000084	0.000074	0.000102	0.000046	0.000019	0.000097	0.000251	0.000061	0.000082	0.000723	0.000369	0.000073	0.001028	0.000053	0.000276	0.000282	0.002527	0.001187	0.001425	0.000359	0.000021	0.000078	0.000642	0.000041	0.000624	0.000078	0.001464	0.000039	0.000092	0.001067	0.002299	0.003106	0.001783	0.000917	0.000435	0.005341	0.003367	0.001814	0.000922	0.008465	0.002565	0.012306	0.002914	0.000408	0.001198	0.001060	0.001404	0.003999	0.000143	0.000173	0.005421	0.000430	0.000480	0.000754	0.000423	0.000221	0.000038	0.002745	0.000157	0.000384	0.000362	0.000118
228202865 - KH - Dragon - Intro	228202865	0.070461	0.001721	0.000377	0.000726	0.000250	0.001074	0.000171	0.001437	0.000250	0.000597	0.000581	0.000354	0.000077	0.000065	0.000675	0.005819	0.000261	0.000221	0.000170	0.000113	0.000129	0.000071	0.000397	0.000391	0.000822	0.000228	0.000868	0.017012	0.000264	0.000109	0.000215	0.000354	0.001379	0.000427	0.000155	0.001252	0.140246	0.000219	0.000946	0.000201	0.002712	0.000696	0.000203	0.000208	0.000475	0.000135	0.000256	0.000278	0.000368	0.000607	0.000230	0.000076	0.000119	0.000235	0.001251	0.000667	0.000034	0.000734	0.000438	0.000391	0.000258	0.000176	0.000421	0.000159	0.003268	0.002364	0.000208	0.000084	0.000033	0.000447	0.000080	0.000022	0.006191	0.004534	0.004215	0.001314	0.000810	0.001169	0.001215	0.000426	0.000744	0.000687	0.000132	0.000465	0.000566	0.000115	0.000556	0.000217	0.000142	0.000092	0.000117	0.000112	0.000114	0.000410	0.000766	0.000229	0.000403	0.000420	0.001000	0.000722	0.000336	0.000605	0.000407	0.000344	0.000259	0.000494	0.000229	0.000246	0.000076	0.000071	0.000125	0.001306	0.000667	0.000532	0.000035	0.000236	0.000174	0.000138	0.000166	0.000292	0.000060	0.000044	0.001231	0.000423	0.000317	0.000196	0.000696	0.000327	0.000141	0.000330	0.000327	0.000191	0.000729	0.000415	0.000189	0.000330	0.000061	0.758464	0.015814	0.002431	0.002724	0.000604	0.000757	0.000799	0.000345	0.000072	0.000597	0.000105	0.000064	0.000153	0.000226	0.000423	0.006950	0.007095	0.006341	0.001202	0.000917	0.000523	0.008805	0.018063	0.000356	0.002148	0.002803	0.010474	0.003105	0.000919	0.000803	0.000229	0.001765	0.000263	0.000040	0.000848	0.000844	0.000182	0.000260	0.000120	0.000217	0.000573	0.001203	0.009470	0.011670	0.013111	0.004791	0.000165	0.000430	0.000787	0.000228	0.000539	0.000291	0.000602	0.000060	0.000624	0.000594	0.000261	0.000188	0.001156	0.001471	0.000291	0.000370	0.000594	0.000617	0.000286	0.000313	0.000119	0.001226	0.002907	0.001431	0.000053	0.000351	0.000057	0.000037	0.000403	0.000240	0.000664	0.004206	0.002550	0.020081	0.215282	0.000587	0.002530	0.002482	0.006968	0.001279	0.004168	0.002713	0.000278	0.025866	0.006203	0.004831	0.000617	0.000571	0.000150	0.010924	0.000284	0.002031	0.011237	0.003496	0.001113	0.000156	0.025608	0.006271	0.003980	0.009696	0.003488	0.008841	0.002176	0.005607	0.001633	0.000434	0.000078	0.000076	0.008842	0.000634	0.004731	0.000753	0.000103	0.001779	0.001600	0.001247	0.000995	0.000701	0.000064	0.000088	0.001187	0.000156	0.015047	0.008414	0.007550	0.004809	0.001134	0.015614	0.002437	0.000533	0.001491	0.008086	0.000122	0.001462	0.001636	0.001867	0.006082	0.010435	0.001066	0.000162	0.000135	0.000166	0.000129	0.000053	0.000062	0.000745	0.000103	0.000107	0.000098	0.000154	0.000084	0.000066	0.000054	0.000525	0.000285	0.000070	0.000141	0.002408	0.000333	0.000078	0.000273	0.000098	0.000024	0.000153	0.000497	0.000351	0.000069	0.000257	0.000039	0.000039	0.000042	0.000079	0.000085	0.000155	0.000037	0.000097	0.000048	0.002178	0.000041	0.000464	0.000372	0.000285	0.000109	0.000158	0.000026	0.000260	0.000323	0.000152	0.000139	0.000218	0.000009	0.000045	0.000129	0.000022	0.000027	0.000054	0.000069	0.000077	0.000346	0.000503	0.000258	0.000023	0.000081	0.000064	0.000066	0.000085	0.000055	0.000017	0.000036	0.000064	0.000116	0.000498	0.003883	0.004816	0.000161	0.000191	0.000159	0.000320	0.000644	0.000035	0.000165	0.000315	0.000251	0.000251	0.000259	0.000097	0.000071	0.000334	0.000236	0.000178	0.000091	0.000138	0.000023	0.000076	0.000080	0.000287	0.000516	0.000146	0.000205	0.000261	0.000211	0.000413	0.000100	0.000551	0.000818	0.002224	0.004666	0.001147	0.005231	0.003509	0.018691	0.004704	0.001990	0.000897	0.000158	0.000963	0.001325	0.001219	0.000102	0.002312	0.000337	0.000405	0.000229	0.002096	0.001714	0.001907	0.000201	0.000035	0.000124	0.000079	0.000025	0.000380	0.000131	0.000336	0.000406	0.000670	0.000136	0.000009	0.000159	0.000219	0.000047	0.000246	0.000271	0.000192	0.000354	0.000073	0.000069	0.000045	0.000668	0.000115	0.000134	0.000857	0.000041	0.000054	0.000581	0.000902	0.000028	0.000044	0.000456	0.000513	0.000054	0.000262	0.000045	0.000094	0.000250	0.000511	0.000099	0.000159	0.000083	0.000093	0.000401	0.000040	0.000164	0.000074	0.004323	0.000412	0.000491	0.000122	0.000230	0.001929	0.001154	0.000507	0.000144	0.000386	0.001706	0.000103	0.000047	0.000117	0.000259	0.000142	0.000054	0.001207	0.000318	0.000536	0.000852	0.000050	0.000261	0.000309	0.006472	0.001194	0.001558	0.000369	0.000037	0.000068	0.000584	0.000023	0.000291	0.000306	0.002700	0.000074	0.000178	0.000951	0.001220	0.006360	0.000233	0.000433	0.000640	0.017108	0.006423	0.002775	0.001547	0.006625	0.001912	0.016184	0.001979	0.000323	0.001170	0.001686	0.001601	0.005001	0.000280	0.000370	0.008693	0.000622	0.000563	0.013925	0.000338	0.000488	0.000109	0.006547	0.000165	0.000887	0.003293	0.000047
228202867 - KH - Dragon - Nena	228202867	0.118359	0.001576	0.000295	0.001299	0.000158	0.000800	0.000219	0.000288	0.000280	0.000201	0.000278	0.000064	0.000057	0.000074	0.000689	0.001553	0.000694	0.000431	0.000427	0.000164	0.000405	0.000136	0.000703	0.000581	0.000592	0.000169	0.000283	0.020696	0.000207	0.000032	0.000113	0.000210	0.000668	0.000321	0.000132	0.000382	0.191805	0.000087	0.000257	0.000046	0.001962	0.001187	0.000095	0.000090	0.000571	0.000038	0.000272	0.000572	0.000328	0.000346	0.000059	0.000027	0.000022	0.000060	0.000737	0.000273	0.000027	0.000122	0.000294	0.000437	0.000131	0.000154	0.000410	0.000188	0.001444	0.000820	0.000150	0.000032	0.000029	0.000457	0.000067	0.000021	0.002760	0.002489	0.001927	0.000774	0.000388	0.000731	0.000455	0.000217	0.000230	0.000224	0.000054	0.000103	0.000264	0.000060	0.000183	0.000061	0.000039	0.000029	0.000020	0.000020	0.000097	0.000165	0.000216	0.000080	0.000103	0.000109	0.000736	0.000386	0.000162	0.000295	0.000245	0.000245	0.000060	0.000093	0.000104	0.000115	0.000023	0.000016	0.000038	0.001285	0.000643	0.000652	0.000036	0.000109	0.000074	0.000090	0.000109	0.000146	0.000033	0.000026	0.000719	0.000193	0.000188	0.000069	0.000458	0.000467	0.000094	0.000071	0.000184	0.000025	0.001071	0.000441	0.000100	0.000539	0.000087	0.737708	0.014694	0.002355	0.002725	0.000574	0.000666	0.000398	0.000186	0.000089	0.000412	0.000171	0.000139	0.000144	0.000080	0.000185	0.002394	0.002311	0.001319	0.000661	0.000424	0.000348	0.006963	0.014532	0.000127	0.001657	0.002264	0.006317	0.003034	0.000588	0.000542	0.000125	0.001478	0.000333	0.000063	0.000460	0.000365	0.000262	0.000305	0.000181	0.000319	0.000264	0.000251	0.001410	0.001891	0.001718	0.000436	0.000083	0.000698	0.001045	0.000344	0.000526	0.000230	0.000431	0.000060	0.000776	0.000201	0.000155	0.000085	0.001725	0.001347	0.000225	0.000225	0.000183	0.000295	0.000103	0.000244	0.000091	0.000455	0.001264	0.000663	0.000017	0.000417	0.000114	0.000102	0.000102	0.000572	0.001708	0.001625	0.001011	0.024162	0.291656	0.000248	0.001770	0.003029	0.006336	0.001135	0.006335	0.002395	0.000232	0.062167	0.015606	0.007290	0.000570	0.000276	0.000198	0.015484	0.000327	0.002938	0.009186	0.003799	0.000891	0.000112	0.014339	0.005153	0.001559	0.004093	0.003018	0.014483	0.001193	0.029413	0.001433	0.000470	0.000116	0.000045	0.013528	0.000226	0.014927	0.000515	0.000069	0.002449	0.002309	0.000853	0.001826	0.000447	0.000081	0.000089	0.001203	0.000177	0.022317	0.018401	0.008604	0.003813	0.000468	0.018119	0.000614	0.000215	0.000785	0.008491	0.000101	0.001395	0.000642	0.001639	0.009187	0.014829	0.000395	0.000260	0.000071	0.000064	0.000059	0.000015	0.000020	0.000314	0.000023	0.000031	0.000019	0.000057	0.000018	0.000037	0.000027	0.000217	0.000165	0.000053	0.000103	0.001271	0.000114	0.000018	0.000078	0.000035	0.000013	0.000098	0.000324	0.000323	0.000042	0.001421	0.000006	0.000022	0.000020	0.000047	0.000054	0.000099	0.000010	0.000134	0.000013	0.000095	0.000016	0.000571	0.000643	0.000280	0.000137	0.000063	0.000023	0.000126	0.000164	0.000085	0.000072	0.000111	0.000004	0.000022	0.000078	0.000011	0.000027	0.000023	0.000027	0.000055	0.000229	0.000191	0.000128	0.000004	0.000055	0.000011	0.000019	0.000040	0.000024	0.000005	0.000029	0.000026	0.000081	0.000134	0.000229	0.000241	0.000041	0.000050	0.000064	0.000250	0.000304	0.000003	0.000019	0.000227	0.000158	0.000261	0.000043	0.000065	0.000022	0.000136	0.000095	0.000098	0.000013	0.000027	0.000023	0.000042	0.000020	0.000103	0.000614	0.000162	0.000273	0.000119	0.000058	0.000279	0.000034	0.000374	0.000206	0.020994	0.001772	0.000610	0.001224	0.000843	0.003696	0.001975	0.003572	0.002641	0.000515	0.002792	0.017231	0.023521	0.000048	0.009356	0.000169	0.000196	0.000117	0.001295	0.000852	0.000957	0.000078	0.000015	0.000016	0.000050	0.000005	0.000068	0.000038	0.000184	0.000209	0.000481	0.000056	0.000006	0.000032	0.000057	0.000009	0.000129	0.000155	0.000251	0.000282	0.000043	0.000018	0.000027	0.000503	0.000208	0.000084	0.000834	0.000042	0.000043	0.000199	0.001633	0.000006	0.000026	0.000574	0.000244	0.000073	0.000224	0.000031	0.000033	0.000274	0.001053	0.000036	0.000115	0.000043	0.000066	0.000232	0.000014	0.000035	0.000021	0.004008	0.000201	0.000336	0.000075	0.000090	0.000323	0.001134	0.000507	0.000070	0.000349	0.001029	0.000046	0.000030	0.000093	0.000164	0.000021	0.000023	0.000322	0.000115	0.000152	0.000574	0.000007	0.000126	0.000085	0.005257	0.000315	0.000294	0.000067	0.000157	0.000019	0.000442	0.000022	0.000218	0.000063	0.001901	0.000025	0.000200	0.000743	0.000370	0.004580	0.000145	0.000282	0.000143	0.004975	0.013326	0.001980	0.004244	0.005755	0.012894	0.016658	0.001921	0.000291	0.000716	0.001048	0.001763	0.006401	0.000119	0.000373	0.002672	0.000284	0.000439	0.001240	0.000091	0.000188	0.000025	0.005374	0.000060	0.000439	0.001745	0.000051
228202866 - KH - Dragon - Luxoff	228202866	0.158333	0.002193	0.000356	0.001312	0.000216	0.001249	0.000380	0.001003	0.000161	0.000363	0.000348	0.000131	0.000012	0.000068	0.001249	0.002017	0.000810	0.000545	0.000506	0.000227	0.000445	0.000142	0.001294	0.001451	0.001852	0.000560	0.000614	0.015047	0.000109	0.000031	0.000047	0.000127	0.000988	0.000711	0.000300	0.000222	0.135810	0.000312	0.001746	0.000102	0.001933	0.000848	0.000206	0.000113	0.001089	0.000036	0.000225	0.001428	0.000978	0.000787	0.000033	0.000055	0.000026	0.000056	0.000260	0.000119	0.000016	0.000188	0.000336	0.000434	0.000319	0.000078	0.000075	0.000067	0.002229	0.001352	0.000138	0.000033	0.000038	0.000308	0.000096	0.000020	0.004601	0.003432	0.002658	0.000793	0.000586	0.001294	0.000637	0.000310	0.000495	0.000606	0.000064	0.000355	0.000355	0.000152	0.000482	0.000127	0.000074	0.000063	0.000060	0.000060	0.000032	0.000287	0.000432	0.000191	0.000325	0.000324	0.001069	0.000924	0.000425	0.000831	0.000205	0.000187	0.000183	0.000305	0.000230	0.000247	0.000049	0.000032	0.000061	0.001484	0.000663	0.000617	0.000065	0.000115	0.000084	0.000329	0.000492	0.000582	0.000155	0.000021	0.001048	0.000150	0.000143	0.000042	0.001105	0.000669	0.000507	0.000394	0.000226	0.000112	0.000844	0.000433	0.000163	0.000187	0.000053	0.724441	0.039894	0.002007	0.001909	0.000521	0.000696	0.000654	0.000334	0.000107	0.000485	0.000068	0.000069	0.000087	0.000145	0.000144	0.075619	0.085581	0.085104	0.002057	0.001679	0.001016	0.020908	0.012983	0.001036	0.001463	0.001699	0.003766	0.002392	0.000434	0.000369	0.000082	0.000982	0.000318	0.000044	0.000334	0.000301	0.000061	0.000050	0.000097	0.000051	0.001294	0.000918	0.003734	0.004625	0.005154	0.001459	0.000076	0.000385	0.001322	0.000566	0.000850	0.000228	0.000735	0.000048	0.000988	0.000686	0.000460	0.000308	0.002357	0.001741	0.000410	0.000497	0.001315	0.000142	0.000043	0.000089	0.000076	0.000488	0.002485	0.000898	0.000011	0.000490	0.000051	0.000130	0.000061	0.000709	0.001263	0.004315	0.001088	0.015205	0.185154	0.000554	0.000909	0.000957	0.003113	0.000849	0.002414	0.001309	0.000192	0.047676	0.016671	0.001206	0.000328	0.000231	0.000104	0.006742	0.000252	0.002356	0.009354	0.001433	0.002613	0.000147	0.012812	0.003118	0.001183	0.005464	0.001208	0.005873	0.000595	0.026256	0.000458	0.000173	0.000041	0.000053	0.007322	0.000578	0.021233	0.000528	0.000042	0.000659	0.000519	0.000729	0.001307	0.000854	0.000067	0.000108	0.000489	0.000187	0.025388	0.008200	0.010480	0.003612	0.000462	0.013195	0.007250	0.000328	0.000706	0.004368	0.000506	0.001722	0.000796	0.008791	0.018352	0.006899	0.000239	0.000252	0.000113	0.000126	0.000101	0.000037	0.000045	0.000394	0.000069	0.000075	0.000062	0.000092	0.000040	0.000054	0.000041	0.000227	0.000232	0.000041	0.000050	0.001916	0.000245	0.000047	0.000121	0.000103	0.000015	0.000113	0.000375	0.000307	0.000045	0.000589	0.000016	0.000015	0.000014	0.000066	0.000040	0.000113	0.000019	0.000113	0.000028	0.000601	0.000033	0.000555	0.000485	0.000338	0.000106	0.000103	0.000018	0.000098	0.000132	0.000041	0.000044	0.000085	0.000004	0.000020	0.000084	0.000009	0.000016	0.000039	0.000034	0.000050	0.000236	0.000205	0.000155	0.000005	0.000046	0.000030	0.000013	0.000067	0.000027	0.000004	0.000018	0.000033	0.000087	0.000189	0.000506	0.001403	0.000073	0.000094	0.000065	0.000182	0.000444	0.000006	0.000013	0.000068	0.000042	0.000039	0.000034	0.000048	0.000014	0.000148	0.000110	0.000093	0.000008	0.000037	0.000019	0.000045	0.000022	0.000072	0.000142	0.000020	0.000038	0.000117	0.000022	0.000144	0.000010	0.000192	0.000306	0.006803	0.003499	0.001065	0.002264	0.001343	0.011722	0.006052	0.002594	0.001415	0.000229	0.002138	0.007113	0.007872	0.000137	0.002869	0.000134	0.000062	0.000035	0.000744	0.000489	0.000560	0.000024	0.000005	0.000011	0.000024	0.000008	0.000043	0.000032	0.000183	0.000270	0.000209	0.000017	0.000005	0.000015	0.000029	0.000005	0.000090	0.000122	0.000339	0.000129	0.000024	0.000015	0.000036	0.000074	0.000086	0.000074	0.000760	0.000049	0.000034	0.000066	0.000387	0.000002	0.000009	0.000200	0.000166	0.000043	0.000163	0.000031	0.000070	0.000126	0.000381	0.000021	0.000132	0.000033	0.000045	0.000439	0.000025	0.000014	0.000022	0.002686	0.000182	0.000227	0.000068	0.000229	0.003779	0.001309	0.000433	0.000087	0.000202	0.000564	0.000038	0.000015	0.000041	0.000050	0.000021	0.000025	0.000305	0.000068	0.000077	0.000384	0.000005	0.000057	0.000050	0.008796	0.000309	0.000318	0.000071	0.000102	0.000006	0.000301	0.000015	0.000101	0.000056	0.001677	0.000020	0.000102	0.000627	0.000349	0.002837	0.000174	0.000264	0.000120	0.005494	0.010953	0.004915	0.002657	0.003971	0.000894	0.020171	0.001961	0.000263	0.001152	0.001310	0.001179	0.003748	0.000155	0.000364	0.002003	0.000218	0.000507	0.002760	0.000160	0.000315	0.000037	0.004040	0.000077	0.000461	0.001704	0.000035
228202868 - KH - Dragon - Cash	228202868	0.047802	0.000745	0.000293	0.001360	0.000092	0.000458	0.000323	0.000368	0.000221	0.000533	0.000491	0.000253	0.000041	0.000090	0.001140	0.003224	0.000690	0.000546	0.000448	0.000165	0.000513	0.000098	0.001240	0.001086	0.000987	0.000591	0.001049	0.024154	0.000413	0.000051	0.000119	0.000164	0.000988	0.000826	0.000317	0.000517	0.104986	0.000201	0.000803	0.000101	0.002092	0.001001	0.000249	0.000161	0.001368	0.000049	0.000472	0.000983	0.000658	0.001118	0.000097	0.000028	0.000035	0.000117	0.000447	0.000236	0.000014	0.000363	0.000622	0.000661	0.000319	0.000158	0.000274	0.000131	0.001763	0.001747	0.000163	0.000026	0.000022	0.000341	0.000043	0.000015	0.003567	0.002713	0.002288	0.000869	0.000401	0.000620	0.000599	0.000178	0.000300	0.000479	0.000146	0.000242	0.000351	0.000095	0.000223	0.000103	0.000066	0.000051	0.000026	0.000026	0.000116	0.000199	0.000320	0.000103	0.000167	0.000165	0.000773	0.000668	0.000306	0.000620	0.000235	0.000221	0.000078	0.000180	0.000085	0.000103	0.000027	0.000021	0.000042	0.001124	0.000577	0.000591	0.000019	0.000062	0.000051	0.000228	0.000382	0.000327	0.000046	0.000021	0.000766	0.000156	0.000210	0.000056	0.000757	0.000943	0.000184	0.000144	0.000252	0.000041	0.001492	0.000708	0.000197	0.000453	0.000024	0.797342	0.027163	0.003496	0.003600	0.000871	0.001335	0.000980	0.000394	0.000110	0.000793	0.000369	0.000098	0.000243	0.000177	0.000346	0.012291	0.014083	0.008801	0.001461	0.000915	0.000759	0.013325	0.022984	0.000639	0.001886	0.003681	0.010435	0.004762	0.000791	0.000765	0.000184	0.002230	0.000398	0.000055	0.000579	0.000527	0.000159	0.000213	0.000151	0.000155	0.000477	0.000539	0.002344	0.002899	0.003278	0.000846	0.000128	0.000771	0.001723	0.000737	0.001156	0.000552	0.000948	0.000099	0.001248	0.000903	0.000487	0.000318	0.001760	0.001344	0.000380	0.000524	0.000993	0.000285	0.000081	0.000350	0.000118	0.000462	0.002487	0.001376	0.000033	0.000534	0.000092	0.000139	0.000126	0.000335	0.000554	0.002305	0.001135	0.033625	0.189032	0.000410	0.002990	0.004829	0.010006	0.002122	0.008893	0.005744	0.000372	0.044590	0.012914	0.001730	0.001061	0.000545	0.000456	0.014415	0.000495	0.003411	0.017726	0.003279	0.001697	0.000245	0.017480	0.004954	0.002301	0.005902	0.001678	0.007964	0.001136	0.010437	0.001018	0.000381	0.000099	0.000052	0.016296	0.001181	0.013594	0.000921	0.000169	0.000562	0.000423	0.001501	0.002476	0.000480	0.000063	0.000040	0.001809	0.000259	0.031972	0.018144	0.011290	0.006140	0.001230	0.025623	0.002959	0.000830	0.001677	0.012332	0.000376	0.002775	0.002428	0.004377	0.013218	0.019995	0.000775	0.000296	0.000078	0.000085	0.000068	0.000015	0.000021	0.000249	0.000025	0.000031	0.000021	0.000054	0.000018	0.000025	0.000021	0.000240	0.000134	0.000046	0.000075	0.001186	0.000135	0.000022	0.000089	0.000054	0.000010	0.000077	0.000224	0.000174	0.000038	0.000395	0.000007	0.000014	0.000013	0.000033	0.000034	0.000090	0.000013	0.000063	0.000030	0.000516	0.000019	0.000316	0.000297	0.000170	0.000071	0.000100	0.000012	0.000108	0.000140	0.000056	0.000052	0.000099	0.000003	0.000017	0.000099	0.000013	0.000016	0.000038	0.000075	0.000052	0.000288	0.000126	0.000116	0.000006	0.000077	0.000032	0.000015	0.000037	0.000022	0.000006	0.000017	0.000026	0.000054	0.000156	0.000673	0.001483	0.000044	0.000079	0.000158	0.000261	0.000315	0.000007	0.000015	0.000086	0.000054	0.000113	0.000029	0.000036	0.000016	0.000115	0.000093	0.000085	0.000017	0.000041	0.000025	0.000051	0.000029	0.000113	0.000231	0.000081	0.000194	0.000138	0.000036	0.000188	0.000016	0.000260	0.000451	0.010839	0.003379	0.001396	0.002968	0.001029	0.010292	0.006349	0.003721	0.000761	0.000139	0.001880	0.007050	0.011374	0.000070	0.006234	0.000127	0.000194	0.000123	0.001570	0.000762	0.000847	0.000081	0.000012	0.000016	0.000052	0.000005	0.000046	0.000041	0.000118	0.000274	0.000250	0.000029	0.000010	0.000024	0.000033	0.000012	0.000106	0.000143	0.000259	0.000140	0.000026	0.000017	0.000020	0.000178	0.000142	0.000100	0.001095	0.000041	0.000039	0.000125	0.001245	0.000006	0.000020	0.000287	0.000201	0.000065	0.000157	0.000014	0.000030	0.000196	0.000441	0.000031	0.000091	0.000034	0.000054	0.000280	0.000015	0.000022	0.000022	0.004263	0.000302	0.000303	0.000082	0.000181	0.001704	0.001233	0.000916	0.000047	0.000600	0.001464	0.000050	0.000019	0.000076	0.000206	0.000028	0.000029	0.000269	0.000116	0.000109	0.001280	0.000017	0.000102	0.000134	0.005146	0.000533	0.000461	0.000088	0.000061	0.000017	0.000376	0.000022	0.000202	0.000057	0.003460	0.000027	0.000135	0.001714	0.000811	0.002453	0.000098	0.000475	0.000179	0.015088	0.011112	0.003390	0.004174	0.005312	0.002526	0.011983	0.001588	0.000188	0.000697	0.001362	0.000924	0.002826	0.000151	0.000636	0.002559	0.000295	0.000585	0.002409	0.000188	0.000224	0.000033	0.003319	0.000084	0.000245	0.000754	0.000038
228202870 - KH - Dragon - Dinero y Amor	228202870	0.142116	0.001013	0.000363	0.001507	0.000146	0.000650	0.000449	0.000683	0.000230	0.000220	0.000274	0.000126	0.000028	0.000084	0.001277	0.004123	0.001033	0.000722	0.000672	0.000171	0.000587	0.000158	0.001393	0.001185	0.001446	0.000476	0.000635	0.027560	0.000128	0.000056	0.000053	0.000097	0.000649	0.000829	0.000260	0.000179	0.142621	0.003629	0.000814	0.000084	0.002021	0.000997	0.000101	0.000079	0.000565	0.000070	0.000174	0.000773	0.000414	0.000884	0.000041	0.000044	0.000026	0.000071	0.000566	0.000206	0.000006	0.000247	0.000575	0.001386	0.000266	0.000136	0.000351	0.000128	0.003350	0.002114	0.000154	0.000056	0.000020	0.000263	0.000034	0.000015	0.004165	0.004139	0.003656	0.001099	0.000572	0.001645	0.000611	0.000439	0.000499	0.000363	0.000132	0.000165	0.000260	0.000071	0.000256	0.000096	0.000063	0.000037	0.000039	0.000037	0.000052	0.000263	0.000420	0.000129	0.000201	0.000181	0.000472	0.000337	0.000151	0.000266	0.000140	0.000115	0.000132	0.000247	0.000111	0.000120	0.000036	0.000026	0.000084	0.001030	0.000510	0.000480	0.000072	0.000083	0.000061	0.000145	0.000215	0.000350	0.000064	0.000009	0.001360	0.000172	0.000189	0.000037	0.000412	0.000325	0.000175	0.000133	0.000182	0.000048	0.000809	0.000524	0.000085	0.000389	0.000017	0.746950	0.088019	0.067067	0.077357	0.016918	0.032467	0.014344	0.003948	0.003419	0.012624	0.000258	0.000180	0.000854	0.000376	0.003749	0.007979	0.006598	0.006893	0.001151	0.000921	0.000755	0.018945	0.015435	0.000440	0.001433	0.002707	0.017591	0.003208	0.000682	0.000614	0.000108	0.001563	0.000088	0.000040	0.000482	0.000502	0.000087	0.000091	0.000174	0.000183	0.000095	0.000127	0.000678	0.000805	0.001023	0.000400	0.000036	0.000344	0.000942	0.000319	0.000488	0.000209	0.001908	0.000084	0.000663	0.001139	0.000450	0.000464	0.001555	0.001059	0.000526	0.000379	0.000624	0.000124	0.000052	0.000127	0.000149	0.000170	0.001135	0.000756	0.000017	0.000465	0.000051	0.000070	0.000041	0.000382	0.001036	0.000633	0.002149	0.021659	0.284608	0.001265	0.002846	0.003909	0.005824	0.002436	0.006673	0.002536	0.000424	0.096414	0.011692	0.004642	0.001058	0.000393	0.000341	0.025149	0.000212	0.001553	0.015870	0.001703	0.000922	0.000141	0.006809	0.002726	0.000665	0.001588	0.000334	0.001994	0.000542	0.001371	0.000174	0.000336	0.000059	0.000146	0.023100	0.000431	0.002246	0.001396	0.000281	0.000867	0.001517	0.000421	0.000986	0.000432	0.000082	0.000048	0.000771	0.000089	0.017510	0.009455	0.003391	0.001771	0.000213	0.006980	0.002935	0.000209	0.000496	0.004181	0.000103	0.001773	0.001245	0.001569	0.007687	0.008841	0.000134	0.000050	0.000100	0.000117	0.000093	0.000025	0.000031	0.000323	0.000045	0.000055	0.000043	0.000091	0.000031	0.000027	0.000023	0.000281	0.000148	0.000062	0.000098	0.001660	0.000124	0.000024	0.000088	0.000039	0.000013	0.000133	0.000327	0.000381	0.000050	0.000715	0.000005	0.000013	0.000015	0.000045	0.000033	0.000133	0.000020	0.000131	0.000026	0.000161	0.000023	0.000721	0.000793	0.000477	0.000137	0.000114	0.000020	0.000115	0.000147	0.000064	0.000081	0.000106	0.000004	0.000013	0.000068	0.000009	0.000028	0.000030	0.000050	0.000036	0.000377	0.000066	0.000166	0.000005	0.000099	0.000023	0.000025	0.000058	0.000028	0.000004	0.000031	0.000033	0.000085	0.000098	0.000283	0.000470	0.000036	0.000059	0.000052	0.000115	0.001057	0.000002	0.000007	0.000055	0.000050	0.000019	0.000034	0.000026	0.000028	0.000131	0.000096	0.000110	0.000020	0.000051	0.000064	0.000140	0.000021	0.000075	0.000199	0.000054	0.000258	0.000361	0.000026	0.000319	0.000016	0.000431	0.000486	0.013158	0.003083	0.001741	0.001873	0.000957	0.013522	0.008988	0.003909	0.002386	0.000364	0.002991	0.009257	0.019760	0.000144	0.004618	0.000160	0.000289	0.000197	0.000784	0.000448	0.000423	0.000123	0.000016	0.000009	0.000037	0.000004	0.000046	0.000021	0.000217	0.000348	0.000357	0.000009	0.000007	0.000038	0.000099	0.000014	0.000164	0.000198	0.000412	0.000189	0.000032	0.000027	0.000051	0.000143	0.000101	0.000094	0.000877	0.000097	0.000043	0.000121	0.000160	0.000002	0.000026	0.000152	0.000168	0.000117	0.000116	0.000021	0.000054	0.000099	0.000262	0.000017	0.000101	0.000041	0.000044	0.000348	0.000020	0.000018	0.000018	0.000374	0.000106	0.000250	0.000071	0.000114	0.057788	0.016496	0.006367	0.000037	0.000145	0.000541	0.000027	0.000015	0.000084	0.000067	0.000020	0.000030	0.000563	0.000149	0.000199	0.000487	0.000011	0.000184	0.000196	0.004898	0.000132	0.000203	0.000058	0.000203	0.000009	0.000279	0.000022	0.000131	0.000044	0.004092	0.000026	0.000084	0.000601	0.000303	0.001672	0.000354	0.000453	0.000281	0.007394	0.015889	0.003788	0.004106	0.003716	0.002061	0.056858	0.003031	0.000214	0.001242	0.002131	0.005167	0.003371	0.000212	0.000308	0.002012	0.000159	0.006980	0.003333	0.000215	0.000230	0.000050	0.001512	0.000068	0.000192	0.000610	0.000052
228202869 - KH - Dragon - Judas	228202869	0.153523	0.001988	0.000539	0.001852	0.000269	0.001609	0.000457	0.000662	0.000321	0.000412	0.000482	0.000137	0.000046	0.000126	0.001453	0.002798	0.001120	0.000880	0.000687	0.000327	0.000781	0.000214	0.001331	0.001344	0.001994	0.000504	0.000446	0.022822	0.000207	0.000049	0.000065	0.000146	0.001033	0.000809	0.000303	0.000237	0.154730	0.000315	0.000688	0.000072	0.002889	0.001116	0.000141	0.000100	0.000810	0.000050	0.000320	0.000714	0.000615	0.001063	0.000072	0.000057	0.000019	0.000098	0.000581	0.000208	0.000010	0.000151	0.000399	0.000749	0.000248	0.000288	0.000484	0.000320	0.002214	0.001645	0.000224	0.000074	0.000034	0.000487	0.000106	0.000032	0.004487	0.003589	0.002834	0.001089	0.000569	0.001252	0.000796	0.000247	0.000390	0.000506	0.000103	0.000281	0.000592	0.000132	0.000275	0.000119	0.000082	0.000069	0.000035	0.000036	0.000163	0.000257	0.000320	0.000149	0.000250	0.000242	0.000702	0.000530	0.000260	0.000471	0.000154	0.000138	0.000135	0.000239	0.000152	0.000154	0.000051	0.000034	0.000051	0.001465	0.000764	0.000797	0.000111	0.000131	0.000096	0.000208	0.000351	0.000439	0.000099	0.000063	0.001115	0.000252	0.000401	0.000097	0.000949	0.000760	0.000242	0.000239	0.000341	0.000078	0.000882	0.000391	0.000270	0.000641	0.000036	0.774891	0.033403	0.004810	0.004982	0.000924	0.001327	0.001672	0.000471	0.000180	0.001243	0.000193	0.000196	0.000169	0.000184	0.000616	0.013228	0.013596	0.009976	0.000546	0.000422	0.000294	0.011190	0.022163	0.000475	0.002791	0.006470	0.030267	0.009653	0.001493	0.001659	0.000199	0.004772	0.000119	0.000089	0.000751	0.000740	0.000281	0.000301	0.000221	0.000243	0.000298	0.000570	0.001967	0.002625	0.002644	0.000760	0.000084	0.000461	0.000762	0.000262	0.000458	0.000136	0.000757	0.000060	0.000911	0.000624	0.000324	0.000218	0.001909	0.001571	0.000344	0.000329	0.000941	0.000295	0.000148	0.000191	0.000074	0.000790	0.001278	0.000618	0.000022	0.000466	0.000057	0.000164	0.000044	0.000751	0.000660	0.002042	0.001461	0.018358	0.275018	0.000435	0.001252	0.001493	0.003923	0.001018	0.003974	0.001901	0.000272	0.068954	0.024848	0.002860	0.000724	0.000376	0.000242	0.013175	0.000376	0.002250	0.011118	0.001883	0.001197	0.000152	0.012844	0.003024	0.001407	0.007324	0.001850	0.007834	0.000658	0.006844	0.000405	0.000263	0.000106	0.000079	0.011863	0.000559	0.010820	0.000611	0.000071	0.000772	0.000750	0.000755	0.002095	0.000475	0.000115	0.000081	0.000488	0.000196	0.019494	0.013190	0.006883	0.002825	0.000498	0.009496	0.004835	0.000171	0.000618	0.004664	0.000288	0.001532	0.000668	0.004924	0.017008	0.008312	0.000127	0.000080	0.000101	0.000231	0.000084	0.000021	0.000028	0.000470	0.000078	0.000103	0.000079	0.000128	0.000043	0.000051	0.000039	0.000369	0.000224	0.000068	0.000130	0.001948	0.000203	0.000035	0.000127	0.000062	0.000020	0.000129	0.000358	0.000366	0.000059	0.000733	0.000016	0.000022	0.000021	0.000055	0.000047	0.000107	0.000016	0.000140	0.000027	0.000439	0.000029	0.000702	0.000607	0.000377	0.000157	0.000102	0.000020	0.000155	0.000201	0.000074	0.000063	0.000137	0.000004	0.000016	0.000101	0.000013	0.000032	0.000037	0.000059	0.000056	0.000282	0.000115	0.000171	0.000006	0.000102	0.000035	0.000028	0.000064	0.000039	0.000006	0.000030	0.000038	0.000117	0.000223	0.000868	0.000970	0.000069	0.000115	0.000115	0.000320	0.000518	0.000008	0.000027	0.000254	0.000180	0.000198	0.000059	0.000063	0.000021	0.000166	0.000110	0.000152	0.000021	0.000035	0.000020	0.000129	0.000035	0.000110	0.000631	0.000133	0.000308	0.000311	0.000113	0.000443	0.000029	0.000596	0.000445	0.007089	0.001794	0.000263	0.001348	0.001003	0.004642	0.003342	0.001593	0.002262	0.000456	0.002663	0.008584	0.016200	0.000063	0.005153	0.000200	0.000128	0.000076	0.000642	0.000555	0.000567	0.000049	0.000012	0.000017	0.000046	0.000009	0.000107	0.000053	0.000221	0.000335	0.000592	0.000068	0.000009	0.000052	0.000105	0.000014	0.000169	0.000196	0.000202	0.000283	0.000034	0.000022	0.000038	0.000347	0.000146	0.000118	0.000663	0.000044	0.000037	0.000236	0.001663	0.000010	0.000043	0.000306	0.000483	0.000062	0.000320	0.000041	0.000086	0.000618	0.001116	0.000055	0.000261	0.000076	0.000080	0.000924	0.000033	0.000036	0.000028	0.000289	0.000217	0.000281	0.000096	0.000252	0.004066	0.001081	0.000532	0.000113	0.000215	0.001470	0.000065	0.000021	0.000068	0.000125	0.000037	0.000046	0.000593	0.000144	0.000240	0.000644	0.000016	0.000216	0.000197	0.005032	0.000519	0.000403	0.000109	0.000065	0.000008	0.000564	0.000030	0.000228	0.000101	0.004658	0.000033	0.000112	0.000734	0.000541	0.005645	0.000147	0.000206	0.000156	0.004685	0.010401	0.006191	0.003240	0.004448	0.001919	0.024182	0.001751	0.000250	0.001075	0.001632	0.000934	0.003131	0.000087	0.000421	0.006532	0.000515	0.000404	0.000764	0.000081	0.000373	0.000056	0.004003	0.000071	0.000269	0.000815	0.000038
228202871 - KH - Dragon - Razones	228202871	0.246726	0.002334	0.000276	0.000514	0.000216	0.002505	0.000083	0.003950	0.000259	0.000335	0.000385	0.000089	0.000021	0.000093	0.000483	0.001657	0.000333	0.000196	0.000267	0.000147	0.000234	0.000110	0.000263	0.000421	0.000331	0.000102	0.000187	0.019782	0.000234	0.000077	0.000103	0.000342	0.001302	0.000618	0.000186	0.000269	0.215550	0.000159	0.000285	0.000048	0.001245	0.000309	0.000036	0.000085	0.000437	0.000029	0.000241	0.000209	0.000288	0.000161	0.000034	0.000072	0.000025	0.000098	0.001321	0.000604	0.000004	0.000126	0.000174	0.000133	0.000053	0.000110	0.000214	0.000121	0.001107	0.000864	0.000178	0.000059	0.000016	0.000311	0.000061	0.000012	0.001854	0.001441	0.001017	0.000352	0.000264	0.000508	0.000355	0.000128	0.000169	0.000344	0.000089	0.000233	0.000851	0.000085	0.000262	0.000084	0.000067	0.000034	0.000037	0.000038	0.000557	0.000133	0.000419	0.000096	0.000265	0.000243	0.000910	0.000695	0.000436	0.000497	0.000259	0.000223	0.000117	0.000211	0.000104	0.000121	0.000026	0.000019	0.000028	0.000762	0.000369	0.000351	0.000036	0.000098	0.000065	0.000080	0.000117	0.000132	0.000043	0.000025	0.000463	0.000116	0.000278	0.000087	0.000613	0.000502	0.000237	0.000157	0.000239	0.000039	0.000550	0.000338	0.000164	0.001308	0.000018	0.775584	0.034635	0.008271	0.009257	0.001687	0.005665	0.001654	0.000467	0.000299	0.001584	0.000176	0.000093	0.000325	0.000178	0.000437	0.006097	0.005590	0.003756	0.001295	0.000952	0.000765	0.011196	0.025013	0.000144	0.004276	0.005856	0.021048	0.008268	0.001518	0.001428	0.000278	0.004574	0.000114	0.000137	0.000914	0.000886	0.000891	0.000282	0.000640	0.000508	0.000393	0.000856	0.002724	0.003858	0.003551	0.001402	0.000082	0.000542	0.000857	0.000201	0.000520	0.000136	0.001213	0.000083	0.001265	0.000895	0.000353	0.000317	0.002665	0.002386	0.000458	0.000327	0.000810	0.000434	0.000146	0.000441	0.000129	0.000912	0.002218	0.001439	0.000017	0.000542	0.000153	0.000145	0.000050	0.000917	0.000754	0.004195	0.001937	0.023832	0.243045	0.000853	0.002020	0.002163	0.003848	0.001474	0.005415	0.002346	0.000267	0.074695	0.026450	0.010656	0.001378	0.000780	0.000444	0.039254	0.000579	0.002468	0.016384	0.008533	0.000877	0.000128	0.015099	0.012656	0.002606	0.007024	0.002254	0.021434	0.002533	0.003139	0.000930	0.000537	0.000190	0.000131	0.010589	0.001364	0.008725	0.001105	0.000216	0.002439	0.002938	0.001094	0.002851	0.000412	0.000098	0.000268	0.001005	0.000351	0.022704	0.012674	0.008502	0.002277	0.001745	0.011633	0.001444	0.000246	0.001223	0.014030	0.000189	0.004079	0.002638	0.001544	0.011555	0.015477	0.000146	0.000038	0.000080	0.000122	0.000074	0.000022	0.000028	0.000850	0.000057	0.000101	0.000050	0.000161	0.000070	0.000047	0.000038	0.000902	0.000359	0.000087	0.000281	0.001707	0.000194	0.000038	0.000114	0.000078	0.000017	0.000108	0.000322	0.000310	0.000051	0.000269	0.000022	0.000016	0.000017	0.000044	0.000033	0.000106	0.000023	0.000071	0.000022	0.000189	0.000022	0.000333	0.000289	0.000162	0.000111	0.000113	0.000011	0.000137	0.000166	0.000081	0.000076	0.000129	0.000003	0.000012	0.000067	0.000012	0.000026	0.000031	0.000041	0.000041	0.000274	0.000067	0.000217	0.000010	0.000086	0.000040	0.000042	0.000093	0.000046	0.000009	0.000041	0.000056	0.000102	0.000160	0.000869	0.000605	0.000052	0.000072	0.000057	0.000330	0.000319	0.000006	0.000012	0.000396	0.000340	0.000154	0.000116	0.000030	0.000033	0.000445	0.000275	0.000101	0.000027	0.000063	0.000048	0.000080	0.000052	0.000365	0.001560	0.000145	0.000583	0.000088	0.000134	0.001459	0.000116	0.001765	0.000597	0.003531	0.003640	0.001690	0.003113	0.002054	0.008025	0.004452	0.001476	0.001001	0.000296	0.001000	0.004771	0.004622	0.000041	0.003291	0.000431	0.000375	0.000208	0.002006	0.003752	0.004104	0.000177	0.000031	0.000026	0.000037	0.000010	0.000201	0.000097	0.000828	0.001333	0.000945	0.000066	0.000023	0.000058	0.000116	0.000025	0.000171	0.000215	0.000214	0.000372	0.000065	0.000022	0.000072	0.000343	0.000108	0.000073	0.001001	0.000042	0.000038	0.000174	0.000771	0.000006	0.000051	0.000770	0.001444	0.000133	0.000613	0.000033	0.000161	0.000808	0.002900	0.000116	0.000362	0.000141	0.000272	0.003795	0.000069	0.000126	0.000037	0.000389	0.000092	0.000265	0.000070	0.000141	0.004465	0.003217	0.001435	0.000040	0.000237	0.000366	0.000037	0.000015	0.000144	0.000029	0.000025	0.000051	0.000795	0.000355	0.000225	0.000856	0.000029	0.000458	0.000406	0.004093	0.000485	0.000734	0.000130	0.000038	0.000015	0.000589	0.000030	0.000277	0.000198	0.007319	0.000030	0.000097	0.000605	0.000972	0.001607	0.000078	0.000316	0.000475	0.006529	0.013391	0.008503	0.002380	0.006064	0.000906	0.017894	0.002081	0.000180	0.001052	0.001208	0.002880	0.004349	0.000097	0.000177	0.003502	0.000089	0.001247	0.001997	0.000095	0.000205	0.000038	0.001734	0.000086	0.000291	0.002819	0.000054
228202872 - KH - Dragon - 100-10	228202872	0.061655	0.001012	0.000215	0.000665	0.000121	0.000714	0.000255	0.000437	0.000188	0.000193	0.000290	0.000120	0.000043	0.000074	0.000615	0.001877	0.000520	0.000315	0.000295	0.000110	0.000360	0.000094	0.000568	0.000566	0.000574	0.000215	0.000449	0.030264	0.000436	0.000048	0.000103	0.000121	0.001105	0.000627	0.000223	0.000199	0.185132	0.000340	0.000297	0.000057	0.001704	0.000903	0.000170	0.000102	0.000849	0.000038	0.000335	0.000419	0.000329	0.000507	0.000049	0.000024	0.000021	0.000057	0.000397	0.000160	0.000006	0.000225	0.000251	0.000352	0.000167	0.000102	0.000243	0.000092	0.001617	0.000681	0.000158	0.000035	0.000019	0.000336	0.000044	0.000012	0.003148	0.002850	0.002173	0.000666	0.000337	0.000775	0.000427	0.000183	0.000260	0.000344	0.000116	0.000157	0.000270	0.000074	0.000193	0.000059	0.000037	0.000029	0.000021	0.000020	0.000040	0.000164	0.000212	0.000103	0.000129	0.000140	0.000487	0.000336	0.000159	0.000272	0.000133	0.000128	0.000069	0.000124	0.000085	0.000086	0.000032	0.000022	0.000030	0.001091	0.000543	0.000537	0.000027	0.000127	0.000081	0.000108	0.000159	0.000331	0.000075	0.000020	0.000872	0.000093	0.000108	0.000040	0.000396	0.000394	0.000147	0.000106	0.000118	0.000037	0.000514	0.000310	0.000098	0.000200	0.000016	0.773050	0.050304	0.011343	0.011692	0.002563	0.002277	0.002968	0.001207	0.000351	0.002763	0.000415	0.000166	0.000521	0.000323	0.000953	0.028940	0.036763	0.020199	0.001179	0.000925	0.000641	0.007184	0.011410	0.001070	0.001036	0.001554	0.002787	0.001945	0.000391	0.000371	0.000064	0.000904	0.000099	0.000060	0.000285	0.000262	0.000063	0.000085	0.000079	0.000107	0.000140	0.000348	0.000906	0.001214	0.001200	0.000467	0.000059	0.000706	0.001560	0.000432	0.000927	0.000358	0.001314	0.000101	0.001409	0.000933	0.000486	0.000265	0.002129	0.001045	0.000747	0.000493	0.000910	0.000253	0.000108	0.000150	0.000106	0.000538	0.001084	0.000631	0.000037	0.000554	0.000150	0.000113	0.000030	0.000530	0.001071	0.000986	0.000441	0.029259	0.203525	0.000290	0.001369	0.002157	0.005916	0.001471	0.006818	0.003597	0.000299	0.079673	0.023397	0.004156	0.001418	0.000510	0.000565	0.027185	0.000307	0.002717	0.019919	0.002967	0.002343	0.000307	0.003613	0.002649	0.000630	0.001083	0.000203	0.002784	0.000317	0.002053	0.000186	0.000264	0.000057	0.000080	0.018868	0.000544	0.006901	0.000870	0.000157	0.000771	0.000697	0.001174	0.003651	0.000506	0.000105	0.000046	0.001372	0.000154	0.038742	0.014743	0.007454	0.003081	0.000571	0.014144	0.001748	0.000284	0.001195	0.009178	0.000327	0.003462	0.001691	0.003098	0.016803	0.020362	0.000110	0.000061	0.000059	0.000064	0.000050	0.000009	0.000011	0.000169	0.000017	0.000021	0.000016	0.000046	0.000011	0.000020	0.000016	0.000190	0.000091	0.000031	0.000061	0.001144	0.000110	0.000017	0.000055	0.000045	0.000011	0.000078	0.000203	0.000234	0.000028	0.000549	0.000006	0.000007	0.000007	0.000027	0.000019	0.000086	0.000007	0.000109	0.000014	0.000129	0.000013	0.000479	0.000520	0.000223	0.000111	0.000069	0.000010	0.000079	0.000105	0.000047	0.000041	0.000073	0.000002	0.000009	0.000068	0.000008	0.000021	0.000025	0.000044	0.000040	0.000151	0.000088	0.000099	0.000003	0.000064	0.000015	0.000018	0.000034	0.000018	0.000003	0.000014	0.000021	0.000054	0.000127	0.000743	0.000644	0.000036	0.000052	0.000042	0.000130	0.000417	0.000003	0.000014	0.000068	0.000050	0.000063	0.000019	0.000037	0.000009	0.000080	0.000073	0.000056	0.000009	0.000024	0.000012	0.000060	0.000021	0.000110	0.000182	0.000057	0.000101	0.000159	0.000049	0.000238	0.000019	0.000330	0.000360	0.030021	0.004270	0.001797	0.002424	0.001153	0.010064	0.004852	0.004687	0.002556	0.000598	0.005493	0.027951	0.041967	0.000051	0.005286	0.000133	0.000110	0.000073	0.001199	0.000573	0.000664	0.000053	0.000010	0.000011	0.000020	0.000004	0.000073	0.000032	0.000193	0.000270	0.000251	0.000014	0.000006	0.000020	0.000035	0.000009	0.000091	0.000135	0.000181	0.000151	0.000021	0.000013	0.000030	0.000126	0.000108	0.000069	0.000645	0.000035	0.000028	0.000091	0.000280	0.000003	0.000012	0.000124	0.000109	0.000042	0.000095	0.000014	0.000022	0.000136	0.000246	0.000017	0.000083	0.000017	0.000025	0.000168	0.000010	0.000009	0.000013	0.001204	0.000107	0.000168	0.000049	0.000214	0.004455	0.003204	0.001334	0.000039	0.000426	0.000553	0.000024	0.000012	0.000060	0.000060	0.000013	0.000021	0.000111	0.000082	0.000089	0.000626	0.000007	0.000161	0.000171	0.007000	0.000154	0.000285	0.000077	0.000073	0.000008	0.000270	0.000016	0.000109	0.000029	0.002720	0.000015	0.000075	0.000607	0.000300	0.001009	0.000053	0.000324	0.000158	0.006916	0.017356	0.003477	0.004026	0.002992	0.001261	0.023753	0.002041	0.000170	0.000701	0.001156	0.001525	0.003310	0.000104	0.000315	0.000862	0.000151	0.001359	0.001277	0.000076	0.000113	0.000019	0.001043	0.000045	0.000184	0.000792	0.000035
228202873 - KH - Dragon - Outro	228202873	0.435065	0.003654	0.005196	0.011444	0.001463	0.003402	0.000699	0.001548	0.000374	0.000327	0.000593	0.000098	0.000014	0.000045	0.000595	0.021622	0.001853	0.000818	0.001449	0.000534	0.000710	0.000476	0.002375	0.001116	0.006137	0.000900	0.001058	0.008395	0.000224	0.000179	0.000032	0.000066	0.000988	0.001389	0.000757	0.000874	0.024172	0.000594	0.000951	0.000038	0.001317	0.002027	0.000244	0.000085	0.000645	0.000213	0.000430	0.003031	0.002043	0.002415	0.000063	0.000119	0.000055	0.000263	0.002056	0.000601	0.000116	0.000120	0.000527	0.003368	0.000701	0.001203	0.000304	0.000408	0.001010	0.001457	0.000121	0.000064	0.000078	0.000407	0.000266	0.000086	0.005349	0.003958	0.002649	0.000688	0.000688	0.000659	0.001007	0.000199	0.000573	0.000853	0.000208	0.000482	0.000333	0.000125	0.000267	0.000265	0.000186	0.000124	0.000037	0.000039	0.000283	0.000294	0.000939	0.000215	0.000576	0.000483	0.000952	0.000449	0.000197	0.000251	0.000641	0.000628	0.000195	0.000380	0.000119	0.000116	0.000045	0.000031	0.000096	0.001599	0.000696	0.000567	0.000121	0.000247	0.000188	0.000202	0.000218	0.000362	0.000078	0.000055	0.000559	0.002113	0.001462	0.000850	0.000770	0.000502	0.000146	0.000198	0.000710	0.000111	0.000613	0.000384	0.000314	0.002775	0.000076	0.757245	0.051583	0.003550	0.002517	0.000506	0.000454	0.000627	0.000412	0.000186	0.000511	0.000582	0.000314	0.000478	0.001063	0.000763	0.059995	0.068725	0.044751	0.001575	0.002333	0.000823	0.015161	0.012209	0.002141	0.003560	0.005293	0.049694	0.007923	0.001997	0.001559	0.000451	0.003986	0.000192	0.000131	0.001113	0.001194	0.000415	0.001328	0.001933	0.001316	0.000222	0.001027	0.004761	0.005108	0.006202	0.001484	0.000625	0.000831	0.001494	0.000895	0.000671	0.000268	0.001652	0.000130	0.002139	0.002560	0.000582	0.000428	0.003019	0.003523	0.000657	0.000713	0.003154	0.000561	0.000165	0.000779	0.000292	0.000691	0.002729	0.000918	0.000031	0.000418	0.000106	0.000093	0.000085	0.000824	0.001130	0.001793	0.006430	0.003465	0.098963	0.000557	0.000587	0.000415	0.000662	0.000270	0.000628	0.000568	0.000181	0.009481	0.006404	0.002141	0.000426	0.000585	0.000176	0.002374	0.000463	0.000743	0.003801	0.000770	0.004000	0.000510	0.024922	0.002855	0.002136	0.007164	0.010720	0.005227	0.001189	0.009662	0.000582	0.000519	0.000286	0.000101	0.002885	0.001402	0.006966	0.000463	0.000044	0.001490	0.001636	0.000976	0.001070	0.000639	0.000084	0.000111	0.000197	0.000535	0.004141	0.003240	0.004780	0.002436	0.001507	0.004044	0.007267	0.000398	0.000835	0.001104	0.000722	0.001024	0.000691	0.003670	0.007155	0.001954	0.000157	0.000252	0.000169	0.000623	0.000147	0.000063	0.000085	0.000686	0.000311	0.000376	0.000432	0.000210	0.000051	0.000076	0.000057	0.000169	0.000550	0.000147	0.000406	0.002940	0.000265	0.000078	0.000168	0.000078	0.000020	0.000193	0.000662	0.000678	0.000161	0.000282	0.000022	0.000034	0.000057	0.000116	0.000095	0.000075	0.000055	0.000161	0.000045	0.003711	0.000118	0.000214	0.000184	0.000182	0.000050	0.000101	0.000032	0.000170	0.000269	0.000077	0.000081	0.000142	0.000013	0.000049	0.000133	0.000013	0.000049	0.000027	0.000105	0.000063	0.001071	0.000323	0.000196	0.000007	0.000040	0.000033	0.000013	0.000079	0.000047	0.000014	0.000048	0.000044	0.000121	0.000570	0.002717	0.002969	0.000206	0.000226	0.000329	0.000727	0.001777	0.000023	0.000075	0.000778	0.000531	0.000252	0.000228	0.000263	0.000053	0.000232	0.000149	0.000236	0.000027	0.000040	0.000127	0.000061	0.000049	0.000257	0.001066	0.001005	0.002252	0.000247	0.000538	0.001172	0.000171	0.001414	0.002436	0.005764	0.009597	0.001572	0.008267	0.002214	0.002911	0.006202	0.010911	0.000594	0.000203	0.002776	0.008531	0.003972	0.000193	0.001808	0.000097	0.000439	0.000216	0.003266	0.000997	0.001019	0.000165	0.000045	0.000102	0.000201	0.000019	0.000280	0.000117	0.001451	0.001523	0.000638	0.000065	0.000017	0.000041	0.000122	0.000017	0.000141	0.000155	0.000362	0.000399	0.000082	0.000078	0.000035	0.000675	0.000050	0.000082	0.000832	0.000139	0.000099	0.000215	0.000536	0.000017	0.000290	0.001156	0.002571	0.000192	0.000457	0.000045	0.000171	0.001955	0.001388	0.000092	0.000303	0.000093	0.000133	0.001542	0.000042	0.000145	0.000134	0.001750	0.000272	0.000976	0.000207	0.000920	0.001802	0.000575	0.000293	0.000160	0.000136	0.001547	0.000197	0.000131	0.000302	0.000196	0.000065	0.000133	0.003565	0.000521	0.000253	0.000449	0.000073	0.000483	0.000562	0.010878	0.001463	0.001996	0.000562	0.000201	0.000034	0.001412	0.000043	0.000346	0.000487	0.004215	0.000030	0.000284	0.000988	0.001970	0.003368	0.000323	0.000315	0.000447	0.009050	0.005481	0.006473	0.001211	0.007900	0.000879	0.050570	0.005589	0.000978	0.001922	0.002238	0.001152	0.003052	0.000191	0.000375	0.004165	0.000254	0.000221	0.001932	0.000340	0.001116	0.000126	0.003630	0.000118	0.005377	0.003077	0.000104
274601110 - Fred again - Actual Life (April 14 - December 17 2020) - April 14th 2020	274601110	0.712592	0.018113	0.005874	0.002314	0.002608	0.004758	0.000263	0.000779	0.006966	0.002377	0.003997	0.000977	0.000102	0.000305	0.002143	0.000455	0.006675	0.000145	0.000397	0.002821	0.000351	0.002940	0.000726	0.000610	0.001115	0.000203	0.000908	0.013484	0.000974	0.000687	0.000371	0.000421	0.002938	0.000926	0.000355	0.000200	0.001164	0.000179	0.000666	0.000072	0.000367	0.000964	0.000124	0.000187	0.000745	0.000184	0.000283	0.000492	0.000138	0.000613	0.000132	0.001919	0.000912	0.000854	0.000237	0.000325	0.000034	0.000125	0.000136	0.000520	0.000283	0.000102	0.000036	0.000514	0.000262	0.000270	0.001320	0.000789	0.009100	0.010117	0.010698	0.000381	0.004170	0.002248	0.001497	0.000212	0.000390	0.000166	0.000534	0.000083	0.000369	0.001007	0.000106	0.000511	0.000343	0.000174	0.000590	0.000701	0.000603	0.000124	0.000225	0.000181	0.000018	0.000175	0.000379	0.000240	0.000449	0.000464	0.000697	0.000503	0.000245	0.000262	0.000128	0.000118	0.000378	0.000527	0.000237	0.000216	0.000190	0.000150	0.000201	0.001287	0.000404	0.000296	0.000055	0.000393	0.000280	0.000394	0.000372	0.000095	0.000027	0.000019	0.000319	0.000156	0.000505	0.000101	0.000884	0.000131	0.000200	0.000480	0.001166	0.000361	0.000373	0.000141	0.000422	0.000225	0.001342	0.678419	0.045012	0.005159	0.006825	0.001421	0.002114	0.000982	0.000720	0.000301	0.000899	0.000328	0.000215	0.000162	0.000475	0.000457	0.038038	0.040070	0.017921	0.010181	0.005516	0.005439	0.013468	0.002184	0.001842	0.001836	0.000737	0.000372	0.000943	0.000328	0.000234	0.000193	0.000396	0.002069	0.000098	0.000135	0.000101	0.000326	0.000138	0.000069	0.000144	0.006056	0.001804	0.003570	0.005132	0.004378	0.003398	0.000629	0.003916	0.009671	0.007100	0.001646	0.002636	0.009198	0.001373	0.004922	0.003801	0.011873	0.011477	0.002611	0.001303	0.002107	0.002393	0.002331	0.001077	0.000589	0.000371	0.000049	0.000295	0.000506	0.000127	0.000054	0.000397	0.000849	0.000072	0.003603	0.000403	0.013209	0.016851	0.000371	0.002326	0.002180	0.000429	0.001332	0.000498	0.000642	0.000328	0.000443	0.001215	0.000332	0.001402	0.001375	0.000512	0.001352	0.000328	0.000573	0.000606	0.000443	0.000756	0.003947	0.000638	0.008931	0.001553	0.009659	0.002235	0.001362	0.001184	0.001125	0.003660	0.001029	0.068068	0.001382	0.000985	0.000294	0.000334	0.001999	0.000528	0.012300	0.000851	0.000171	0.000474	0.000273	0.001278	0.001404	0.001270	0.000198	0.000142	0.000189	0.000503	0.002547	0.002324	0.004284	0.001814	0.000510	0.004042	0.001975	0.000453	0.000720	0.001194	0.002518	0.000672	0.001098	0.003039	0.005753	0.001187	0.000148	0.003482	0.000686	0.001033	0.000577	0.000121	0.000124	0.000766	0.000192	0.000103	0.000192	0.000280	0.000194	0.000967	0.000618	0.000148	0.000569	0.000152	0.000211	0.006552	0.001226	0.000376	0.000399	0.000337	0.000479	0.000393	0.001975	0.000925	0.000398	0.000055	0.000048	0.000233	0.000244	0.000658	0.000829	0.000205	0.000121	0.000752	0.000054	0.000067	0.000370	0.000155	0.000115	0.000123	0.000038	0.000347	0.000219	0.000840	0.001207	0.000224	0.000520	0.000685	0.000040	0.000711	0.000435	0.000103	0.000074	0.000113	0.000126	0.000342	0.002092	0.001344	0.000303	0.000022	0.000039	0.000045	0.000026	0.000129	0.000077	0.000028	0.000097	0.000091	0.000193	0.001368	0.000190	0.000673	0.000528	0.000898	0.000238	0.001335	0.000088	0.000138	0.000100	0.000213	0.000082	0.000042	0.000121	0.000334	0.000244	0.000162	0.000123	0.000128	0.000069	0.000145	0.000235	0.000039	0.000178	0.000206	0.000284	0.000056	0.000244	0.000341	0.000067	0.000116	0.000076	0.000142	0.000480	0.000225	0.000283	0.000182	0.000146	0.000131	0.000407	0.000556	0.000106	0.000425	0.000147	0.000259	0.000226	0.000117	0.033015	0.000158	0.000135	0.000258	0.000061	0.000187	0.000475	0.000529	0.000070	0.000009	0.000100	0.000326	0.000111	0.000038	0.000169	0.000530	0.001803	0.000359	0.000073	0.000023	0.000054	0.000063	0.000019	0.000139	0.000170	0.000419	0.000417	0.000129	0.000135	0.000095	0.000135	0.000207	0.000188	0.000704	0.000423	0.000173	0.000259	0.000269	0.000010	0.000083	0.000291	0.000659	0.000175	0.000357	0.000220	0.000461	0.000479	0.000234	0.000043	0.000376	0.000129	0.000131	0.000340	0.000041	0.000077	0.000091	0.002354	0.000732	0.001277	0.000640	0.000593	0.003437	0.005219	0.000761	0.001326	0.000477	0.000941	0.000245	0.000258	0.000088	0.000099	0.000186	0.000203	0.000232	0.000148	0.000161	0.000655	0.000013	0.000052	0.000051	0.000884	0.002868	0.000680	0.000180	0.000066	0.000089	0.001004	0.000018	0.000339	0.000156	0.000149	0.000207	0.001134	0.000616	0.000355	0.001584	0.000096	0.000316	0.000153	0.005985	0.001015	0.012788	0.000454	0.003795	0.000186	0.018823	0.091732	0.084165	0.015122	0.004597	0.009650	0.017315	0.000078	0.000186	0.000521	0.000341	0.002062	0.000452	0.000355	0.000434	0.000241	0.001025	0.000134	0.003886	0.001050	0.000529
274601111 - Fred again - Actual Life (April 14 - December 17 2020) - Kyle (i found you)	274601111	0.388876	0.007037	0.001889	0.002304	0.000608	0.003314	0.000128	0.000359	0.001500	0.000727	0.001619	0.000263	0.000138	0.000106	0.001066	0.000492	0.001016	0.000148	0.000369	0.000458	0.000216	0.000608	0.000367	0.000334	0.000663	0.000198	0.000490	0.027947	0.000429	0.000385	0.000286	0.000627	0.003216	0.001077	0.000401	0.000749	0.016090	0.000286	0.000408	0.000046	0.000809	0.000965	0.000084	0.000190	0.000603	0.000148	0.000471	0.000514	0.000256	0.000419	0.000126	0.000457	0.001393	0.000582	0.000303	0.000435	0.000060	0.000243	0.000189	0.000297	0.000217	0.000129	0.000296	0.000713	0.002004	0.003143	0.000508	0.000224	0.000290	0.002335	0.001723	0.000142	0.005625	0.003906	0.003049	0.000682	0.000633	0.001291	0.000892	0.000178	0.000519	0.000532	0.000065	0.000419	0.000898	0.000098	0.000434	0.000297	0.000260	0.000076	0.000125	0.000110	0.000188	0.000105	0.000266	0.000154	0.000386	0.000325	0.000923	0.000673	0.000344	0.000418	0.000214	0.000196	0.000231	0.000347	0.000211	0.000249	0.000078	0.000060	0.000159	0.001420	0.000621	0.000548	0.000074	0.000310	0.000262	0.000179	0.000179	0.000680	0.000216	0.000034	0.000947	0.000289	0.000777	0.000107	0.000657	0.000331	0.000110	0.000162	0.001932	0.000107	0.000231	0.000073	0.000471	0.001402	0.000311	0.798013	0.019107	0.001996	0.002363	0.000498	0.000493	0.000483	0.000190	0.000117	0.000360	0.000341	0.000379	0.000213	0.000125	0.000356	0.003718	0.003011	0.002252	0.000696	0.000510	0.000317	0.020099	0.027465	0.000193	0.002887	0.002859	0.046192	0.004675	0.001064	0.000846	0.000324	0.002378	0.000467	0.000292	0.000719	0.000624	0.001232	0.000633	0.000254	0.000482	0.000659	0.000364	0.001291	0.001918	0.001609	0.000591	0.000194	0.000680	0.000788	0.000241	0.000404	0.000197	0.000605	0.000134	0.000848	0.000403	0.000203	0.000144	0.001646	0.001584	0.000301	0.000248	0.000229	0.000453	0.000222	0.000513	0.000091	0.000263	0.000293	0.000113	0.000031	0.000700	0.000391	0.000134	0.000409	0.000306	0.000993	0.001230	0.002087	0.026239	0.057001	0.001015	0.001919	0.000997	0.002069	0.000734	0.001574	0.001740	0.000288	0.024946	0.004966	0.006909	0.001255	0.000688	0.000507	0.008008	0.000795	0.002440	0.006395	0.019090	0.000818	0.000185	0.106554	0.087896	0.031168	0.022273	0.014382	0.100248	0.040648	0.013608	0.020030	0.001556	0.000378	0.000138	0.005914	0.001331	0.005688	0.001391	0.000307	0.007190	0.009878	0.001008	0.001342	0.002609	0.000295	0.000488	0.001045	0.000585	0.009772	0.013874	0.005443	0.002398	0.001742	0.014323	0.001660	0.000389	0.000966	0.036011	0.000232	0.003543	0.001281	0.000910	0.004482	0.011353	0.000132	0.000274	0.000154	0.000216	0.000150	0.000078	0.000091	0.000638	0.000092	0.000109	0.000088	0.000182	0.000116	0.000128	0.000089	0.000493	0.000528	0.000089	0.000291	0.004052	0.000326	0.000093	0.000230	0.000119	0.000047	0.000373	0.001582	0.000663	0.000226	0.000224	0.000127	0.000084	0.000110	0.000336	0.000239	0.000178	0.000108	0.000373	0.000034	0.000245	0.000150	0.000290	0.000261	0.000136	0.000098	0.000164	0.000088	0.000489	0.000700	0.000217	0.000212	0.000403	0.000034	0.000225	0.000196	0.000028	0.000091	0.000048	0.000086	0.000132	0.001254	0.001109	0.000374	0.000018	0.000034	0.000035	0.000031	0.000136	0.000090	0.000030	0.000094	0.000090	0.000228	0.001579	0.000333	0.000967	0.000745	0.000572	0.000568	0.001584	0.000838	0.000051	0.000131	0.000285	0.000150	0.000100	0.000114	0.000334	0.000091	0.000218	0.000174	0.000152	0.000085	0.000181	0.000023	0.000064	0.000165	0.000580	0.001196	0.000110	0.000351	0.000585	0.000121	0.000253	0.000102	0.000329	0.000494	0.000753	0.000500	0.000312	0.002986	0.000262	0.000808	0.001015	0.000432	0.000776	0.000191	0.001038	0.002304	0.001409	0.000126	0.002215	0.000313	0.000395	0.000154	0.000513	0.001627	0.001262	0.000148	0.000028	0.000106	0.000167	0.000067	0.000111	0.000277	0.000276	0.000771	0.000550	0.000109	0.000008	0.000082	0.000135	0.000037	0.000178	0.000261	0.000576	0.000420	0.000108	0.000053	0.000074	0.000370	0.000420	0.000210	0.002067	0.000100	0.000106	0.000452	0.001382	0.000024	0.000067	0.000279	0.000452	0.000097	0.000711	0.000094	0.000233	0.000946	0.002822	0.000065	0.000578	0.000168	0.000254	0.001537	0.000075	0.000092	0.000108	0.005578	0.000575	0.002220	0.000486	0.000195	0.000741	0.001249	0.000334	0.001443	0.000452	0.001068	0.000142	0.000060	0.000080	0.000334	0.000167	0.000185	0.001010	0.000450	0.000265	0.001275	0.000006	0.000065	0.000046	0.003435	0.003756	0.000961	0.000211	0.000132	0.000089	0.001611	0.000053	0.000853	0.000203	0.000468	0.000081	0.001023	0.001876	0.000673	0.022440	0.000729	0.000212	0.000130	0.009202	0.002510	0.004395	0.000631	0.015058	0.013977	0.011889	0.011740	0.004273	0.003321	0.002433	0.006381	0.011028	0.000214	0.000393	0.016940	0.001353	0.000520	0.002144	0.000520	0.001071	0.000149	0.024806	0.000312	0.001273	0.001247	0.000235
274601112 - Fred again - Actual Life (April 14 - December 17 2020) - Dermot (see yourself in my eyes)	274601112	0.332172	0.002446	0.001143	0.001605	0.000405	0.000904	0.000277	0.000358	0.000620	0.000384	0.000552	0.000145	0.000022	0.000033	0.000523	0.000478	0.000798	0.000258	0.000340	0.000266	0.000261	0.000249	0.000604	0.000531	0.000484	0.000144	0.000422	0.059922	0.000525	0.002386	0.000119	0.000229	0.005622	0.002836	0.000912	0.002628	0.003070	0.000234	0.000425	0.000021	0.000578	0.000474	0.000073	0.000100	0.000190	0.000053	0.000168	0.000365	0.000150	0.000275	0.000129	0.000205	0.000092	0.000196	0.000253	0.000266	0.000038	0.000297	0.000125	0.000318	0.000262	0.000065	0.000055	0.000133	0.002656	0.002505	0.000147	0.000056	0.000206	0.000938	0.000434	0.000066	0.003720	0.002889	0.001669	0.000339	0.000420	0.000512	0.000555	0.000123	0.000327	0.000706	0.000105	0.000639	0.000272	0.000132	0.000385	0.000231	0.000203	0.000100	0.000131	0.000117	0.000669	0.000086	0.000173	0.000161	0.000377	0.000327	0.000694	0.000433	0.000222	0.000273	0.000177	0.000182	0.000182	0.000262	0.000177	0.000164	0.000073	0.000052	0.000141	0.001597	0.000701	0.000647	0.000075	0.000323	0.000238	0.000236	0.000227	0.000630	0.000215	0.000037	0.000465	0.000194	0.000276	0.000099	0.000632	0.000478	0.000148	0.000198	0.001190	0.000137	0.000368	0.000175	0.000194	0.001070	0.000206	0.739704	0.039181	0.007141	0.006981	0.000842	0.000813	0.001434	0.000905	0.000506	0.000886	0.004353	0.001850	0.002922	0.003251	0.003104	0.020536	0.020885	0.015525	0.002181	0.002852	0.000834	0.028783	0.030704	0.002284	0.003176	0.003163	0.025504	0.004674	0.001201	0.000914	0.000507	0.002003	0.000598	0.000657	0.000660	0.000500	0.000691	0.000623	0.001935	0.001978	0.000789	0.000559	0.001786	0.002390	0.002260	0.000929	0.001409	0.001539	0.001441	0.000670	0.000583	0.000400	0.002695	0.000515	0.002041	0.003787	0.000874	0.000665	0.001446	0.000919	0.000453	0.000613	0.004787	0.001022	0.000477	0.001315	0.000271	0.000278	0.000612	0.000344	0.000106	0.000660	0.000884	0.000119	0.000844	0.000211	0.003632	0.001835	0.001874	0.029625	0.019398	0.000214	0.002126	0.000439	0.000922	0.000426	0.000722	0.001638	0.000384	0.010428	0.004346	0.008443	0.004061	0.001680	0.002802	0.006674	0.002110	0.003424	0.004071	0.026958	0.002856	0.000934	0.135643	0.080374	0.021372	0.017114	0.113976	0.046035	0.030724	0.012967	0.027688	0.006620	0.002367	0.001318	0.005299	0.001718	0.003811	0.000734	0.000178	0.015268	0.020882	0.002465	0.002531	0.004769	0.000446	0.001125	0.001286	0.001071	0.008222	0.019077	0.003934	0.002278	0.003439	0.008588	0.001330	0.000602	0.001536	0.028755	0.001005	0.004984	0.002106	0.000718	0.003363	0.010238	0.000068	0.000263	0.000207	0.000268	0.000187	0.000062	0.000069	0.000446	0.000097	0.000066	0.000116	0.000142	0.000090	0.000131	0.000097	0.000186	0.000289	0.000070	0.000162	0.003081	0.000291	0.000071	0.000162	0.000111	0.000050	0.000217	0.001034	0.000965	0.000251	0.000146	0.000015	0.000069	0.000085	0.000223	0.000228	0.000133	0.000041	0.000563	0.000023	0.000189	0.000110	0.000263	0.000240	0.000116	0.000064	0.000165	0.000072	0.000320	0.000486	0.000157	0.000162	0.000265	0.000012	0.000164	0.000257	0.000030	0.000073	0.000059	0.000127	0.000173	0.000868	0.000422	0.000231	0.000009	0.000023	0.000030	0.000019	0.000090	0.000057	0.000018	0.000054	0.000060	0.000151	0.000429	0.000838	0.000890	0.000173	0.000137	0.000181	0.000381	0.000386	0.000016	0.000037	0.000295	0.000151	0.000078	0.000088	0.000123	0.000095	0.000164	0.000106	0.000124	0.000065	0.000038	0.000087	0.000074	0.000072	0.000195	0.000611	0.000249	0.000176	0.000433	0.000099	0.000446	0.000140	0.000467	0.000484	0.001626	0.001100	0.000452	0.002006	0.000420	0.001050	0.002601	0.000919	0.000881	0.000254	0.001929	0.001972	0.002156	0.000605	0.000683	0.000086	0.000323	0.000141	0.000391	0.000501	0.000489	0.000147	0.000046	0.000121	0.000296	0.000041	0.000069	0.000069	0.000346	0.000713	0.000429	0.000034	0.000017	0.000021	0.000050	0.000012	0.000153	0.000183	0.000542	0.000305	0.000189	0.000076	0.000045	0.000201	0.000142	0.000097	0.001333	0.000167	0.000073	0.000128	0.000145	0.000006	0.000055	0.000318	0.000383	0.000204	0.000380	0.000057	0.000081	0.000246	0.000483	0.000043	0.000185	0.000088	0.000123	0.000628	0.000044	0.000050	0.000102	0.002961	0.000236	0.001612	0.000086	0.000232	0.001366	0.001906	0.000557	0.000256	0.000290	0.000173	0.000069	0.000056	0.000099	0.000118	0.000050	0.000071	0.000922	0.000180	0.000098	0.001402	0.000006	0.000064	0.000054	0.003033	0.000932	0.000887	0.000310	0.000075	0.000042	0.000651	0.000043	0.000374	0.000134	0.000563	0.000061	0.000404	0.001035	0.000924	0.019995	0.001929	0.000699	0.000199	0.006360	0.004514	0.003520	0.001064	0.006959	0.004071	0.020709	0.013108	0.003241	0.002446	0.002031	0.002568	0.006090	0.000281	0.000504	0.007875	0.001867	0.000748	0.007634	0.000522	0.001068	0.000230	0.020926	0.000162	0.002731	0.003507	0.000247
274601113 - Fred again - Actual Life (April 14 - December 17 2020) - Yasminah (see your face again)	274601113	0.039031	0.000530	0.000206	0.000491	0.000101	0.000309	0.000081	0.000115	0.000220	0.000181	0.000225	0.000131	0.000047	0.000075	0.000281	0.000145	0.000362	0.000114	0.000118	0.000114	0.000108	0.000074	0.000164	0.000194	0.000126	0.000055	0.000117	0.020656	0.000162	0.000339	0.000160	0.000381	0.000651	0.000340	0.000116	0.000245	0.001849	0.000255	0.000144	0.000014	0.000381	0.000372	0.000069	0.000043	0.000153	0.000039	0.000300	0.000117	0.000054	0.000264	0.000148	0.000225	0.000082	0.000411	0.000213	0.000171	0.000005	0.001082	0.000058	0.000120	0.000074	0.000022	0.000015	0.000050	0.016115	0.005915	0.000167	0.000045	0.000055	0.000602	0.000162	0.000042	0.002784	0.001335	0.000906	0.000261	0.000213	0.000401	0.000311	0.000073	0.000142	0.000287	0.000074	0.000170	0.000401	0.000056	0.000361	0.000423	0.000359	0.000116	0.000117	0.000107	0.000077	0.000070	0.000113	0.000147	0.000283	0.000277	0.000716	0.000321	0.000166	0.000231	0.000157	0.000153	0.000143	0.000210	0.000258	0.000261	0.000128	0.000086	0.000131	0.000777	0.000326	0.000258	0.000023	0.000191	0.000144	0.000122	0.000124	0.000214	0.000120	0.000032	0.000285	0.000106	0.000165	0.000084	0.000495	0.000193	0.000119	0.000157	0.000417	0.000075	0.000144	0.000052	0.000113	0.000382	0.000817	0.649592	0.028487	0.007901	0.010606	0.001777	0.004924	0.001153	0.000829	0.000211	0.000963	0.000437	0.000297	0.000258	0.000288	0.000297	0.005507	0.004146	0.003168	0.001491	0.000856	0.000858	0.026481	0.036215	0.000161	0.002976	0.005856	0.014870	0.007286	0.002194	0.001968	0.000513	0.004252	0.000852	0.000100	0.001142	0.000990	0.000214	0.000154	0.000176	0.000256	0.001887	0.000158	0.000690	0.000904	0.000775	0.000423	0.000102	0.000755	0.001156	0.000328	0.000484	0.000363	0.001233	0.000083	0.000925	0.000804	0.000419	0.000423	0.001471	0.000957	0.000350	0.000272	0.000543	0.000165	0.000108	0.000212	0.000021	0.001004	0.000421	0.000179	0.000008	0.000833	0.000267	0.000097	0.000497	0.000618	0.007518	0.013401	0.000694	0.013864	0.009277	0.000202	0.007603	0.001136	0.002770	0.002739	0.003277	0.002963	0.002696	0.010586	0.014923	0.005564	0.002656	0.002793	0.000776	0.028624	0.000519	0.001149	0.003996	0.027800	0.000700	0.000192	0.075745	0.039091	0.014457	0.005185	0.035115	0.051712	0.010027	0.083619	0.012156	0.000703	0.000291	0.000250	0.005785	0.000495	0.005980	0.000417	0.000102	0.003145	0.003376	0.000657	0.000748	0.000839	0.000121	0.001338	0.001309	0.000252	0.006618	0.011628	0.003000	0.002197	0.000757	0.008623	0.000568	0.000308	0.000542	0.016131	0.000202	0.001857	0.001018	0.000701	0.002909	0.005722	0.000268	0.000357	0.000527	0.000304	0.000501	0.000370	0.000480	0.000413	0.000307	0.000252	0.000236	0.000221	0.000140	0.000221	0.000169	0.000345	0.000507	0.000152	0.000222	0.004862	0.000538	0.000162	0.000403	0.000148	0.000105	0.000305	0.001189	0.001186	0.000496	0.000332	0.000024	0.000058	0.000059	0.000118	0.000134	0.000242	0.000046	0.000547	0.000046	0.000033	0.000056	0.000393	0.000321	0.000199	0.000154	0.000413	0.000067	0.000323	0.000415	0.000143	0.000162	0.000293	0.000015	0.000052	0.000271	0.000045	0.000104	0.000052	0.000098	0.000168	0.000484	0.000696	0.000418	0.000023	0.000058	0.000078	0.000034	0.000131	0.000085	0.000015	0.000089	0.000101	0.000238	0.000404	0.000049	0.000246	0.000214	0.000167	0.000050	0.000186	0.000107	0.000018	0.000069	0.000099	0.000058	0.000012	0.000098	0.000055	0.000030	0.000141	0.000109	0.000061	0.000040	0.000062	0.000011	0.000024	0.000035	0.000111	0.000740	0.000059	0.000098	0.000178	0.000091	0.000129	0.000045	0.000117	0.000142	0.000708	0.000411	0.000173	0.000321	0.000221	0.001020	0.002382	0.000155	0.001660	0.000640	0.000649	0.000620	0.000962	0.001718	0.000849	0.000276	0.000105	0.000038	0.000132	0.000293	0.000275	0.000036	0.000007	0.000035	0.000140	0.000028	0.000065	0.000089	0.000158	0.000576	0.000431	0.000041	0.000007	0.000064	0.000053	0.000023	0.000162	0.000188	0.000533	0.000504	0.000116	0.000076	0.000080	0.000210	0.000260	0.000151	0.000726	0.000151	0.000066	0.000167	0.000107	0.000010	0.000048	0.000147	0.000171	0.000044	0.000310	0.000065	0.000110	0.000377	0.000994	0.000034	0.000273	0.000133	0.000107	0.000599	0.000062	0.000033	0.000063	0.006130	0.000430	0.000717	0.000274	0.000101	0.002220	0.008193	0.001701	0.000175	0.000069	0.000139	0.000073	0.000040	0.000056	0.000095	0.000130	0.000136	0.000382	0.000165	0.000191	0.001804	0.000009	0.000076	0.000056	0.001761	0.000244	0.000215	0.000076	0.000022	0.000012	0.000711	0.000027	0.000392	0.000104	0.000238	0.000064	0.001224	0.000309	0.000119	0.103776	0.000186	0.000175	0.000103	0.006946	0.027103	0.003831	0.005114	0.005413	0.003005	0.007803	0.004885	0.000784	0.002205	0.002766	0.003763	0.013419	0.000601	0.000208	0.025375	0.002327	0.003485	0.010748	0.000201	0.000870	0.000101	0.111512	0.000240	0.000392	0.000612	0.000110
274601114 - Fred again - Actual Life (April 14 - December 17 2020) - Hackney (interlude)	274601114	0.751311	0.003711	0.000345	0.001037	0.000275	0.001124	0.000083	0.000407	0.000996	0.000656	0.000953	0.000185	0.000198	0.000198	0.001028	0.000224	0.000933	0.000136	0.000244	0.000741	0.000223	0.000397	0.000195	0.000480	0.000685	0.000121	0.000150	0.001716	0.000328	0.000054	0.000111	0.000262	0.000737	0.000543	0.000333	0.000267	0.000071	0.000088	0.000303	0.000123	0.000468	0.000363	0.000051	0.000067	0.000188	0.000215	0.000199	0.000155	0.000228	0.000216	0.000235	0.003981	0.002985	0.004995	0.000313	0.001152	0.000062	0.000303	0.000288	0.000630	0.000315	0.000130	0.000072	0.000370	0.000244	0.000183	0.001044	0.000656	0.000270	0.003621	0.001339	0.000234	0.014208	0.007112	0.004339	0.000373	0.001048	0.000583	0.001371	0.000182	0.000814	0.002454	0.000198	0.001795	0.000442	0.000462	0.001213	0.001111	0.000946	0.000227	0.000554	0.000451	0.000347	0.000299	0.001617	0.000189	0.000526	0.000502	0.002197	0.002001	0.001156	0.000753	0.000245	0.000220	0.001991	0.002663	0.000477	0.000678	0.000093	0.000073	0.000133	0.007434	0.001580	0.000814	0.000187	0.004984	0.002944	0.001970	0.001479	0.000488	0.000215	0.000169	0.000787	0.000353	0.000809	0.000466	0.001332	0.000172	0.000055	0.000695	0.001714	0.000755	0.000696	0.000225	0.000831	0.001943	0.000586	0.311671	0.011667	0.003660	0.004626	0.001171	0.000460	0.000969	0.000144	0.000275	0.001374	0.000312	0.000497	0.000168	0.000140	0.000567	0.001520	0.001461	0.000648	0.000313	0.000189	0.000127	0.001125	0.000717	0.000393	0.002187	0.000600	0.000331	0.001465	0.000394	0.000204	0.000307	0.000427	0.000199	0.000497	0.000143	0.000102	0.000915	0.000173	0.000190	0.000103	0.001015	0.001067	0.001048	0.001732	0.001151	0.000552	0.000270	0.000789	0.001198	0.000338	0.000479	0.000262	0.000814	0.000229	0.001561	0.000314	0.000323	0.000108	0.001149	0.000342	0.000297	0.000204	0.000159	0.001390	0.000884	0.000246	0.000084	0.000186	0.000881	0.000758	0.000726	0.000339	0.000443	0.000770	0.000335	0.000202	0.000309	0.000530	0.000394	0.000416	0.000224	0.000394	0.000689	0.000448	0.000175	0.000094	0.000177	0.000531	0.000059	0.000291	0.000170	0.000112	0.000546	0.000070	0.000294	0.000175	0.000236	0.000313	0.000291	0.000196	0.000843	0.000127	0.002886	0.000485	0.000791	0.000574	0.000201	0.001047	0.000279	0.000931	0.000305	0.000361	0.000300	0.000253	0.000342	0.000294	0.000469	0.000316	0.000090	0.000185	0.000118	0.000334	0.000304	0.000261	0.000316	0.000094	0.000070	0.000347	0.000333	0.000210	0.000726	0.000556	0.000223	0.000684	0.000211	0.000338	0.000248	0.000405	0.000151	0.000288	0.000409	0.000219	0.000701	0.000401	0.000071	0.000219	0.004675	0.004759	0.003924	0.000225	0.000205	0.003857	0.001325	0.000808	0.001423	0.002885	0.001822	0.002843	0.001860	0.000286	0.005666	0.001132	0.004053	0.163173	0.014068	0.003995	0.002205	0.005612	0.004258	0.009896	0.051967	0.020273	0.004781	0.001118	0.009175	0.000729	0.000568	0.014634	0.001794	0.003999	0.000945	0.002586	0.000707	0.002811	0.012501	0.001772	0.001065	0.000787	0.000849	0.001520	0.009887	0.008828	0.019389	0.000972	0.003630	0.006326	0.000237	0.006306	0.001830	0.000207	0.000353	0.000227	0.000402	0.001036	0.005807	0.001218	0.011009	0.000108	0.000036	0.000587	0.000173	0.004603	0.002799	0.000358	0.001242	0.003128	0.002967	0.033277	0.000186	0.000146	0.042647	0.002652	0.004801	0.008739	0.000298	0.000473	0.000177	0.000694	0.000243	0.000091	0.000334	0.019842	0.000458	0.000285	0.000175	0.000498	0.000150	0.000670	0.000040	0.000081	0.001713	0.000770	0.001414	0.000142	0.000177	0.000497	0.000080	0.000582	0.000509	0.000488	0.000313	0.000164	0.000199	0.000044	0.000343	0.000127	0.000078	0.000095	0.000024	0.006044	0.003658	0.000814	0.000339	0.000129	0.001777	0.000212	0.000848	0.004395	0.000764	0.000384	0.003240	0.004168	0.000680	0.000209	0.000295	0.031620	0.021508	0.000099	0.010600	0.000253	0.001838	0.001521	0.000644	0.000057	0.000122	0.000076	0.000016	0.000367	0.000199	0.001934	0.001274	0.000307	0.000123	0.001086	0.000217	0.001732	0.000721	0.001922	0.001642	0.000141	0.000688	0.001136	0.000144	0.000819	0.000706	0.001772	0.000054	0.003425	0.000710	0.001925	0.001010	0.000766	0.000214	0.001784	0.000911	0.000630	0.002440	0.001573	0.000199	0.001205	0.000070	0.000949	0.001240	0.000882	0.000578	0.000163	0.000810	0.000074	0.002166	0.000178	0.001792	0.003095	0.001819	0.000477	0.000318	0.000544	0.001502	0.000253	0.001477	0.000150	0.000289	0.000040	0.000105	0.000046	0.001579	0.002462	0.000468	0.000188	0.000870	0.001755	0.005194	0.000620	0.002697	0.000295	0.000536	0.000977	0.000353	0.000217	0.000189	0.002197	0.000045	0.000088	0.000163	0.001960	0.000310	0.000866	0.000128	0.001750	0.000159	0.016549	0.010323	0.011212	0.061734	0.012480	0.000688	0.001228	0.001220	0.000152	0.001385	0.001305	0.000445	0.000061	0.002255	0.010443	0.000774	0.000447	0.001688	0.014854	0.001762	0.013044
274601116 - Fred again - Actual Life (April 14 - December 17 2020) - Julia (deep diving)	274601116	0.075293	0.000561	0.000994	0.001723	0.000170	0.000352	0.000343	0.000170	0.000543	0.000347	0.000415	0.000169	0.000039	0.000059	0.000648	0.000939	0.000508	0.000262	0.000217	0.000142	0.000186	0.000099	0.000619	0.000485	0.000443	0.000240	0.000347	0.057605	0.000518	0.000700	0.000076	0.000164	0.001964	0.004789	0.001671	0.002174	0.010591	0.000678	0.000440	0.000018	0.001085	0.000493	0.000089	0.000064	0.000229	0.000054	0.000168	0.000289	0.000123	0.000454	0.000097	0.000045	0.000082	0.000087	0.000195	0.000130	0.000009	0.000224	0.000077	0.000389	0.000137	0.000189	0.000092	0.000124	0.002490	0.001959	0.000168	0.000018	0.000056	0.000686	0.000126	0.000022	0.002072	0.001804	0.001280	0.000324	0.000246	0.000575	0.000295	0.000088	0.000194	0.000373	0.000064	0.000287	0.000305	0.000063	0.000209	0.000087	0.000071	0.000031	0.000051	0.000046	0.000104	0.000069	0.000128	0.000121	0.000204	0.000179	0.000429	0.000238	0.000117	0.000175	0.000097	0.000096	0.000163	0.000243	0.000152	0.000135	0.000022	0.000015	0.000063	0.000838	0.000320	0.000274	0.000046	0.000107	0.000067	0.000211	0.000221	0.000343	0.000098	0.000011	0.000450	0.000117	0.000107	0.000049	0.000323	0.000216	0.000124	0.000121	0.000363	0.000053	0.000240	0.000143	0.000073	0.000394	0.000094	0.707138	0.036969	0.005406	0.005742	0.000860	0.000761	0.001287	0.000615	0.000457	0.000806	0.001327	0.000392	0.001804	0.003736	0.001609	0.030128	0.030971	0.018735	0.006371	0.006724	0.002396	0.032983	0.015297	0.002915	0.001552	0.001336	0.009481	0.001782	0.000443	0.000344	0.000175	0.000810	0.000198	0.000129	0.000254	0.000199	0.000157	0.000097	0.000438	0.000458	0.000901	0.000610	0.001821	0.002621	0.002284	0.001398	0.000495	0.001248	0.001339	0.000865	0.000559	0.000310	0.001759	0.000395	0.001867	0.003722	0.000634	0.000412	0.002715	0.001922	0.000470	0.000740	0.004273	0.000594	0.000371	0.000266	0.000117	0.000864	0.000381	0.000206	0.000067	0.000531	0.000792	0.000097	0.000257	0.001042	0.011773	0.009846	0.001642	0.051716	0.040613	0.000289	0.001984	0.000694	0.001639	0.000727	0.001135	0.001309	0.000247	0.023156	0.004026	0.004646	0.001399	0.000534	0.000819	0.005732	0.000992	0.003287	0.002802	0.020438	0.003416	0.000824	0.096470	0.051987	0.017793	0.015777	0.016787	0.032548	0.021260	0.030914	0.014075	0.001786	0.000365	0.000573	0.004195	0.001394	0.006081	0.000683	0.000170	0.007446	0.012136	0.001278	0.001629	0.005150	0.000120	0.000533	0.001020	0.000778	0.011416	0.011794	0.003796	0.002812	0.001714	0.009284	0.002048	0.000436	0.000681	0.026645	0.000661	0.005522	0.002086	0.000961	0.005362	0.013946	0.000109	0.000168	0.000076	0.000130	0.000071	0.000021	0.000024	0.000203	0.000041	0.000034	0.000042	0.000058	0.000039	0.000042	0.000034	0.000238	0.000092	0.000040	0.000076	0.001575	0.000126	0.000030	0.000066	0.000052	0.000025	0.000108	0.000456	0.001126	0.000138	0.000157	0.000012	0.000021	0.000031	0.000064	0.000072	0.000104	0.000022	0.000651	0.000011	0.000069	0.000057	0.000299	0.000286	0.000151	0.000090	0.000085	0.000035	0.000142	0.000200	0.000095	0.000082	0.000122	0.000003	0.000030	0.000100	0.000015	0.000028	0.000034	0.000025	0.000067	0.000177	0.000121	0.000135	0.000006	0.000016	0.000019	0.000013	0.000057	0.000038	0.000007	0.000024	0.000033	0.000096	0.000208	0.000482	0.000368	0.000065	0.000045	0.000119	0.000253	0.000482	0.000008	0.000028	0.000084	0.000046	0.000052	0.000053	0.000039	0.000029	0.000085	0.000059	0.000087	0.000027	0.000027	0.000027	0.000035	0.000040	0.000156	0.000208	0.000066	0.000085	0.000105	0.000035	0.000330	0.000056	0.000406	0.000481	0.002649	0.001759	0.000735	0.002169	0.000755	0.007042	0.016656	0.000530	0.001725	0.000539	0.002512	0.003455	0.003220	0.000865	0.001242	0.000144	0.000073	0.000036	0.000220	0.000322	0.000289	0.000033	0.000013	0.000019	0.000053	0.000009	0.000032	0.000035	0.000200	0.000305	0.000195	0.000013	0.000007	0.000017	0.000023	0.000017	0.000092	0.000099	0.000249	0.000202	0.000041	0.000017	0.000027	0.000131	0.000074	0.000058	0.000867	0.000043	0.000029	0.000067	0.000081	0.000002	0.000025	0.000154	0.000097	0.000062	0.000127	0.000024	0.000027	0.000155	0.000236	0.000014	0.000067	0.000037	0.000052	0.000470	0.000017	0.000024	0.000022	0.001497	0.000098	0.000359	0.000050	0.000175	0.003379	0.004299	0.001581	0.000045	0.000297	0.000136	0.000032	0.000015	0.000051	0.000048	0.000020	0.000041	0.000447	0.000142	0.000065	0.000720	0.000010	0.000039	0.000044	0.005038	0.000156	0.000255	0.000127	0.000058	0.000012	0.000427	0.000020	0.000213	0.000073	0.000583	0.000030	0.000143	0.000535	0.000194	0.007038	0.003297	0.000557	0.000140	0.007489	0.071739	0.004903	0.013579	0.004976	0.001796	0.024630	0.009059	0.001333	0.001511	0.001272	0.005173	0.008212	0.000380	0.000179	0.004633	0.000293	0.001448	0.008950	0.000458	0.000693	0.000098	0.008734	0.000125	0.001095	0.001812	0.000049
274601117 - Fred again - Actual Life (April 14 - December 17 2020) - Adam (interlude)	274601117	0.502415	0.005760	0.002520	0.002663	0.000699	0.001346	0.000198	0.000593	0.001915	0.001291	0.001426	0.000757	0.000019	0.000040	0.000828	0.002032	0.001389	0.000155	0.000210	0.000366	0.000181	0.000465	0.000534	0.000283	0.000731	0.000295	0.002184	0.121516	0.002348	0.002968	0.000620	0.001033	0.020011	0.009916	0.001928	0.005936	0.000839	0.003734	0.000944	0.000190	0.000358	0.001882	0.000206	0.000247	0.001031	0.000485	0.000554	0.000377	0.000249	0.000910	0.000147	0.000424	0.000175	0.000471	0.000398	0.000234	0.000119	0.000990	0.000207	0.000508	0.000288	0.000121	0.000283	0.000234	0.001372	0.001828	0.000247	0.000150	0.000264	0.001308	0.000760	0.000045	0.003489	0.002011	0.001224	0.000234	0.000249	0.000278	0.000319	0.000183	0.000265	0.000800	0.000155	0.000445	0.000613	0.000120	0.000564	0.000393	0.000319	0.000079	0.000156	0.000124	0.000036	0.000285	0.000400	0.000277	0.000378	0.000403	0.000749	0.000685	0.000301	0.000432	0.000149	0.000140	0.000247	0.000319	0.000217	0.000198	0.000120	0.000105	0.000411	0.001355	0.000454	0.000311	0.000022	0.000403	0.000245	0.000238	0.000216	0.000086	0.000024	0.000034	0.000323	0.000189	0.000310	0.000122	0.000515	0.000133	0.000095	0.000262	0.000637	0.000232	0.000182	0.000085	0.000384	0.000194	0.001481	0.691977	0.063333	0.003871	0.005780	0.000729	0.001309	0.000932	0.000748	0.000337	0.000587	0.000464	0.000339	0.000277	0.000502	0.000837	0.063640	0.056720	0.029231	0.026216	0.027451	0.012557	0.017866	0.003494	0.002010	0.003502	0.001355	0.000571	0.001688	0.000491	0.000331	0.000218	0.000528	0.000915	0.000146	0.000309	0.000200	0.000248	0.000088	0.000066	0.000151	0.002980	0.001547	0.004340	0.005895	0.005115	0.006219	0.001463	0.002788	0.013554	0.008650	0.002210	0.003416	0.003862	0.000832	0.001883	0.001608	0.002920	0.004137	0.003284	0.002142	0.002395	0.002980	0.001057	0.000829	0.000396	0.000142	0.000044	0.000621	0.001008	0.000346	0.000063	0.000821	0.001652	0.000019	0.008369	0.000321	0.021107	0.017818	0.000679	0.004232	0.001926	0.000742	0.002208	0.000716	0.000760	0.000277	0.000510	0.000905	0.000281	0.001435	0.001841	0.000680	0.001272	0.000384	0.000497	0.000467	0.000728	0.001400	0.005688	0.000513	0.007542	0.003650	0.010598	0.001987	0.001245	0.001881	0.001242	0.002314	0.000792	0.018528	0.001823	0.001557	0.000269	0.000291	0.002952	0.000901	0.005304	0.004245	0.000917	0.000523	0.000245	0.002552	0.003340	0.003055	0.000390	0.000194	0.000226	0.000658	0.005028	0.010926	0.001740	0.001386	0.000910	0.002125	0.010719	0.000467	0.001145	0.000743	0.001458	0.000498	0.001062	0.001928	0.004729	0.000842	0.000251	0.000690	0.000535	0.001181	0.000534	0.000375	0.000359	0.000565	0.000477	0.000307	0.000444	0.000179	0.000144	0.000265	0.000182	0.000321	0.000370	0.000243	0.000224	0.003368	0.000445	0.000146	0.000200	0.000098	0.000139	0.000206	0.000985	0.000855	0.000270	0.000035	0.000060	0.000088	0.000140	0.000221	0.000329	0.000175	0.000073	0.000514	0.000062	0.000363	0.000121	0.000102	0.000087	0.000085	0.000025	0.000157	0.000055	0.000744	0.001049	0.000266	0.000411	0.000622	0.000028	0.000253	0.000375	0.000087	0.000075	0.000075	0.000114	0.000293	0.000960	0.000506	0.000286	0.000019	0.000040	0.000041	0.000032	0.000107	0.000076	0.000039	0.000077	0.000084	0.000157	0.001244	0.000410	0.000816	0.000429	0.000417	0.000276	0.000899	0.000091	0.000184	0.000172	0.000232	0.000109	0.000017	0.000135	0.000189	0.000170	0.000219	0.000169	0.000136	0.000100	0.000116	0.000096	0.000061	0.000128	0.000105	0.000207	0.000042	0.000278	0.000571	0.000042	0.000376	0.000078	0.000470	0.000944	0.000181	0.000504	0.000167	0.000211	0.000305	0.000719	0.001143	0.000250	0.000308	0.000155	0.000178	0.000141	0.000097	0.008211	0.000204	0.000171	0.000211	0.000071	0.000345	0.000459	0.000544	0.000062	0.000017	0.000079	0.000504	0.000050	0.000077	0.000122	0.000326	0.000426	0.000616	0.000049	0.000015	0.000049	0.000069	0.000014	0.000275	0.000292	0.000841	0.000630	0.000141	0.000131	0.000136	0.000307	0.000188	0.000280	0.001468	0.000308	0.000165	0.000294	0.000111	0.000010	0.000094	0.000393	0.000394	0.000334	0.000299	0.000072	0.000207	0.000277	0.000278	0.000058	0.000215	0.000111	0.000101	0.000275	0.000043	0.000064	0.000161	0.004790	0.001406	0.001627	0.000366	0.001758	0.002761	0.001652	0.000535	0.000268	0.000414	0.000772	0.000426	0.000278	0.000184	0.000169	0.000192	0.000165	0.000487	0.000167	0.000211	0.000434	0.000010	0.000056	0.000077	0.001414	0.001082	0.000493	0.000267	0.000040	0.000055	0.001436	0.000032	0.000362	0.000197	0.001111	0.000148	0.001251	0.000535	0.000366	0.007567	0.000163	0.000278	0.000131	0.010741	0.002503	0.016918	0.000686	0.004053	0.000450	0.047934	0.059653	0.009184	0.004565	0.003635	0.006159	0.006989	0.000386	0.000381	0.002467	0.001216	0.000699	0.002878	0.000679	0.001550	0.000461	0.004562	0.000269	0.006400	0.004276	0.000209
274601118 - Fred again - Actual Life (April 14 - December 17 2020) - Me (heavy)	274601118	0.088558	0.000852	0.000694	0.001357	0.000155	0.000325	0.000272	0.000171	0.000546	0.000314	0.000364	0.000233	0.000056	0.000042	0.000397	0.001041	0.000928	0.000273	0.000266	0.000287	0.000277	0.000285	0.000383	0.000323	0.000511	0.000175	0.001613	0.129144	0.001574	0.004937	0.001469	0.001750	0.010209	0.003264	0.000828	0.003182	0.002686	0.005843	0.000383	0.000087	0.001484	0.001541	0.000353	0.000170	0.000883	0.000990	0.000353	0.000988	0.000410	0.002303	0.000443	0.000112	0.000207	0.000300	0.000302	0.000182	0.000024	0.000215	0.000258	0.000641	0.000380	0.000150	0.000113	0.000113	0.002219	0.003696	0.000131	0.000040	0.000067	0.000813	0.000147	0.000033	0.004450	0.004034	0.003345	0.000741	0.000536	0.000670	0.000726	0.000162	0.000410	0.000806	0.000108	0.000497	0.000305	0.000127	0.000422	0.000163	0.000152	0.000055	0.000114	0.000117	0.000062	0.000187	0.000222	0.000271	0.000546	0.000434	0.000502	0.000542	0.000279	0.000427	0.000063	0.000063	0.000403	0.000730	0.000152	0.000157	0.000053	0.000043	0.000125	0.000984	0.000348	0.000317	0.000061	0.000178	0.000137	0.000128	0.000121	0.000662	0.000123	0.000027	0.000702	0.000128	0.000239	0.000116	0.000379	0.000125	0.000166	0.000197	0.000380	0.000096	0.000823	0.000503	0.000129	0.000282	0.000209	0.749599	0.050093	0.018247	0.027215	0.004432	0.016267	0.002740	0.003130	0.000928	0.001750	0.000654	0.000138	0.000419	0.000479	0.001702	0.005647	0.003714	0.004887	0.002232	0.002624	0.001349	0.053578	0.024285	0.000159	0.002025	0.002079	0.025232	0.002624	0.000874	0.000722	0.000343	0.001150	0.000501	0.000140	0.000306	0.000273	0.000425	0.000179	0.000257	0.000617	0.000598	0.000139	0.000816	0.001117	0.001043	0.000869	0.000205	0.001696	0.002290	0.000384	0.000948	0.000956	0.003649	0.000457	0.001949	0.001742	0.001473	0.002234	0.003040	0.001426	0.001177	0.000609	0.000484	0.000341	0.000209	0.000914	0.000265	0.000235	0.000196	0.000112	0.000051	0.004404	0.003781	0.000107	0.020151	0.000373	0.020686	0.002665	0.007894	0.014072	0.010745	0.004032	0.014090	0.001349	0.002549	0.002659	0.003245	0.003644	0.009980	0.005610	0.017688	0.012196	0.009001	0.009085	0.002121	0.006805	0.001964	0.002124	0.003609	0.002751	0.000595	0.000517	0.034304	0.007919	0.003153	0.004960	0.003601	0.004906	0.002054	0.009765	0.002577	0.006765	0.001899	0.000871	0.007430	0.002225	0.001897	0.007954	0.002024	0.001310	0.000827	0.005338	0.003749	0.002425	0.000183	0.001141	0.004279	0.000592	0.014357	0.024617	0.001628	0.002021	0.005635	0.002657	0.001712	0.000350	0.004531	0.001627	0.000714	0.002156	0.001471	0.000912	0.003793	0.001642	0.000194	0.000201	0.000122	0.000168	0.000120	0.000060	0.000070	0.000452	0.000074	0.000051	0.000063	0.000115	0.000102	0.000076	0.000070	0.000225	0.000201	0.000066	0.000108	0.002606	0.000191	0.000058	0.000092	0.000088	0.000069	0.000178	0.000709	0.000656	0.000307	0.000069	0.000033	0.000049	0.000072	0.000102	0.000163	0.000197	0.000058	0.000205	0.000030	0.000068	0.000088	0.000218	0.000191	0.000095	0.000066	0.000156	0.000053	0.000583	0.000750	0.000281	0.000414	0.000508	0.000018	0.000143	0.000260	0.000059	0.000071	0.000078	0.000093	0.000159	0.000398	0.000796	0.000215	0.000019	0.000033	0.000044	0.000035	0.000069	0.000066	0.000021	0.000049	0.000063	0.000185	0.000353	0.000528	0.000975	0.000142	0.000088	0.000174	0.000457	0.000399	0.000090	0.000092	0.000171	0.000090	0.000047	0.000046	0.000163	0.000225	0.000158	0.000096	0.000309	0.000106	0.000116	0.000146	0.000064	0.000163	0.000112	0.000278	0.000149	0.000205	0.000444	0.000092	0.000214	0.000111	0.000316	0.000708	0.001064	0.000589	0.000542	0.000895	0.000201	0.002566	0.005407	0.000400	0.000510	0.000092	0.000498	0.001007	0.001663	0.000240	0.001852	0.000249	0.000074	0.000036	0.000205	0.000392	0.000350	0.000033	0.000006	0.000055	0.000206	0.000018	0.000103	0.000131	0.000176	0.000402	0.000365	0.000016	0.000015	0.000077	0.000177	0.000070	0.000185	0.000191	0.000185	0.000201	0.000098	0.000038	0.000040	0.000173	0.000125	0.000091	0.000363	0.000070	0.000071	0.000205	0.000077	0.000004	0.000075	0.000172	0.000253	0.000123	0.000144	0.000087	0.000067	0.000157	0.000140	0.000014	0.000171	0.000149	0.000070	0.000342	0.000039	0.000024	0.000030	0.003040	0.000144	0.000515	0.000157	0.000319	0.008960	0.050204	0.016467	0.000108	0.000082	0.000304	0.000099	0.000031	0.000072	0.000161	0.000058	0.000060	0.004875	0.000255	0.000456	0.002287	0.000008	0.000096	0.000158	0.002126	0.000243	0.000788	0.000156	0.000024	0.000027	0.000424	0.000028	0.000305	0.000051	0.000496	0.000172	0.000219	0.001149	0.000484	0.008134	0.000129	0.001647	0.000248	0.007552	0.009580	0.010553	0.002383	0.006615	0.000475	0.025812	0.020031	0.002773	0.002721	0.001563	0.011754	0.018482	0.000411	0.000104	0.002035	0.000758	0.030838	0.026171	0.000418	0.000349	0.000090	0.011370	0.000177	0.000735	0.002133	0.000109
274601119 - Fred again - Actual Life (April 14 - December 17 2020) - Big Hen (steal my joy)	274601119	0.281442	0.002444	0.002917	0.004410	0.000676	0.001275	0.000758	0.000386	0.000652	0.000398	0.000448	0.000142	0.000051	0.000050	0.000756	0.002014	0.001680	0.000594	0.000714	0.000434	0.000598	0.000397	0.002003	0.001022	0.002541	0.000955	0.001281	0.044068	0.000351	0.001239	0.000285	0.000649	0.002930	0.001660	0.000637	0.001437	0.054786	0.002252	0.001274	0.000078	0.001802	0.001497	0.000225	0.000187	0.000974	0.000081	0.000335	0.001417	0.000526	0.001063	0.000226	0.000093	0.000043	0.000193	0.000425	0.000186	0.000067	0.000306	0.000568	0.002815	0.000457	0.000169	0.000309	0.000224	0.001229	0.000928	0.000156	0.000030	0.000155	0.000445	0.000254	0.000061	0.005532	0.005307	0.004209	0.001389	0.000835	0.002712	0.001142	0.000391	0.000705	0.000625	0.000139	0.000339	0.000269	0.000098	0.000166	0.000164	0.000152	0.000055	0.000050	0.000047	0.000136	0.000181	0.000297	0.000096	0.000216	0.000185	0.000464	0.000256	0.000120	0.000180	0.000181	0.000179	0.000167	0.000276	0.000146	0.000151	0.000063	0.000045	0.000163	0.001286	0.000568	0.000566	0.000085	0.000148	0.000110	0.000204	0.000203	0.000729	0.000216	0.000015	0.001442	0.000281	0.000423	0.000079	0.000453	0.000454	0.000085	0.000090	0.000893	0.000045	0.000454	0.000212	0.000148	0.000598	0.000284	0.742399	0.013058	0.002675	0.003187	0.000618	0.000599	0.000723	0.000397	0.000191	0.000509	0.000423	0.000286	0.000274	0.000275	0.000537	0.004090	0.003565	0.003111	0.002546	0.001729	0.001042	0.010484	0.014554	0.000318	0.001695	0.002558	0.011517	0.002973	0.001038	0.000880	0.000391	0.002046	0.000374	0.000124	0.000616	0.000500	0.000310	0.000427	0.000265	0.000709	0.000365	0.000255	0.001590	0.002007	0.002110	0.000911	0.000166	0.000610	0.001107	0.000446	0.000528	0.000280	0.000613	0.000127	0.000662	0.000428	0.000268	0.000199	0.002419	0.003630	0.000368	0.000403	0.000525	0.000406	0.000229	0.000369	0.000167	0.000803	0.000474	0.000210	0.000028	0.000610	0.000274	0.000096	0.000411	0.000804	0.005189	0.005522	0.001362	0.034375	0.129377	0.000787	0.002318	0.001043	0.003200	0.001029	0.001666	0.001837	0.000376	0.042588	0.008247	0.020386	0.001246	0.000725	0.000411	0.010728	0.000765	0.002921	0.005242	0.007764	0.001115	0.000354	0.063234	0.014963	0.005508	0.013466	0.112983	0.018067	0.006241	0.019305	0.004402	0.001813	0.000464	0.000202	0.006999	0.001120	0.008412	0.001875	0.000389	0.027259	0.048817	0.001531	0.002440	0.002590	0.000235	0.000791	0.001063	0.000348	0.012515	0.027006	0.004791	0.003115	0.001395	0.010652	0.002804	0.000419	0.000995	0.015428	0.000307	0.003157	0.001591	0.001432	0.005575	0.010354	0.000202	0.000375	0.000132	0.000178	0.000114	0.000049	0.000062	0.000496	0.000084	0.000080	0.000080	0.000123	0.000085	0.000104	0.000077	0.000206	0.000307	0.000063	0.000099	0.003011	0.000224	0.000049	0.000160	0.000068	0.000040	0.000199	0.000703	0.001148	0.000294	0.000338	0.000016	0.000034	0.000055	0.000116	0.000126	0.000133	0.000034	0.000584	0.000025	0.000340	0.000083	0.000360	0.000368	0.000203	0.000088	0.000216	0.000065	0.000303	0.000421	0.000158	0.000163	0.000254	0.000013	0.000102	0.000198	0.000027	0.000068	0.000063	0.000093	0.000130	0.000655	0.000766	0.000173	0.000009	0.000022	0.000039	0.000020	0.000054	0.000038	0.000012	0.000031	0.000035	0.000117	0.000370	0.001401	0.000968	0.000139	0.000139	0.000115	0.000388	0.001634	0.000011	0.000036	0.000194	0.000110	0.000185	0.000061	0.000103	0.000077	0.000138	0.000090	0.000223	0.000044	0.000028	0.000043	0.000061	0.000052	0.000185	0.000472	0.000094	0.000208	0.000398	0.000136	0.000397	0.000071	0.000420	0.000566	0.005011	0.001908	0.000956	0.001714	0.000921	0.003216	0.005756	0.001939	0.001415	0.000314	0.004130	0.008801	0.007303	0.000897	0.005744	0.000120	0.000143	0.000062	0.000578	0.000372	0.000347	0.000055	0.000014	0.000067	0.000118	0.000023	0.000110	0.000047	0.000264	0.000390	0.000335	0.000030	0.000012	0.000021	0.000052	0.000009	0.000144	0.000156	0.000387	0.000321	0.000102	0.000064	0.000046	0.000334	0.000226	0.000110	0.001183	0.000096	0.000101	0.000097	0.000381	0.000004	0.000047	0.000261	0.000306	0.000141	0.000244	0.000080	0.000119	0.000237	0.000675	0.000052	0.000243	0.000085	0.000074	0.000347	0.000023	0.000027	0.000063	0.002923	0.000187	0.000825	0.000139	0.000274	0.001049	0.001665	0.000658	0.000453	0.000242	0.000409	0.000086	0.000055	0.000106	0.000369	0.000040	0.000041	0.001190	0.000162	0.000091	0.000833	0.000009	0.000079	0.000079	0.006316	0.000386	0.000485	0.000149	0.000087	0.000027	0.000568	0.000022	0.000226	0.000092	0.001185	0.000068	0.000330	0.001432	0.000387	0.008354	0.003759	0.000346	0.000188	0.007203	0.012404	0.002468	0.002750	0.004709	0.004492	0.023841	0.007897	0.001425	0.002178	0.002219	0.002088	0.005539	0.000386	0.000427	0.006948	0.000575	0.000631	0.004688	0.000317	0.000666	0.000148	0.006010	0.000129	0.001312	0.001577	0.000120
274601120 - Fred again - Actual Life (April 14 - December 17 2020) - Marnie (wish i had u)	274601120	0.026895	0.000394	0.000288	0.000679	0.000124	0.000226	0.000173	0.000068	0.000191	0.000100	0.000162	0.000152	0.000031	0.000039	0.000329	0.000373	0.000335	0.000176	0.000117	0.000109	0.000119	0.000087	0.000198	0.000211	0.000132	0.000072	0.000280	0.010617	0.000152	0.000162	0.000076	0.000161	0.000910	0.000924	0.000318	0.000676	0.000645	0.000052	0.000160	0.000014	0.000358	0.000302	0.000067	0.000065	0.000120	0.000038	0.000109	0.000109	0.000059	0.000216	0.000046	0.000068	0.000044	0.000106	0.000220	0.000112	0.000003	0.000065	0.000036	0.000094	0.000053	0.000048	0.000045	0.000036	0.051175	0.035672	0.000108	0.000014	0.000043	0.000492	0.000119	0.000022	0.001815	0.001409	0.000801	0.000224	0.000141	0.000168	0.000180	0.000090	0.000115	0.000382	0.000031	0.000260	0.000176	0.000081	0.000291	0.000101	0.000076	0.000043	0.000091	0.000084	0.000062	0.000072	0.000065	0.000115	0.000160	0.000175	0.000551	0.000451	0.000246	0.000266	0.000082	0.000078	0.000143	0.000137	0.000145	0.000117	0.000062	0.000053	0.000136	0.001043	0.000448	0.000421	0.000074	0.000141	0.000086	0.000119	0.000107	0.000265	0.000059	0.000066	0.000205	0.000167	0.000130	0.000127	0.000283	0.000136	0.000060	0.000123	0.000337	0.000084	0.000085	0.000044	0.000039	0.000307	0.000049	0.465110	0.011591	0.001316	0.001693	0.000374	0.000644	0.000210	0.000078	0.000098	0.000189	0.000068	0.000044	0.000053	0.000068	0.000145	0.003046	0.002222	0.001753	0.000514	0.000504	0.000209	0.011888	0.025954	0.000106	0.000807	0.001080	0.016505	0.001632	0.000437	0.000337	0.000200	0.000823	0.000788	0.000089	0.000248	0.000227	0.000086	0.000043	0.000132	0.000069	0.000325	0.000116	0.000560	0.000747	0.000685	0.000141	0.000045	0.000309	0.000251	0.000082	0.000137	0.000084	0.000319	0.000035	0.000480	0.000195	0.000142	0.000096	0.000367	0.000337	0.000051	0.000073	0.000175	0.000181	0.000071	0.000170	0.000035	0.000145	0.000348	0.000198	0.000015	0.000129	0.000137	0.000042	0.000192	0.000068	0.000553	0.000567	0.000703	0.008068	0.005172	0.000289	0.001785	0.000542	0.000842	0.000526	0.000631	0.000773	0.000247	0.002972	0.001139	0.001612	0.000397	0.000212	0.000126	0.001405	0.000261	0.000791	0.000680	0.008812	0.000314	0.000120	0.114944	0.028110	0.026812	0.011327	0.025891	0.022142	0.012581	0.009329	0.029121	0.000507	0.000178	0.000074	0.001241	0.000353	0.000809	0.000523	0.000135	0.000851	0.000519	0.000453	0.000295	0.001123	0.000064	0.000490	0.000269	0.000132	0.002284	0.003914	0.001541	0.001063	0.000577	0.005471	0.000434	0.000270	0.000283	0.007179	0.000084	0.000560	0.000279	0.000314	0.000726	0.003218	0.000170	0.000148	0.000197	0.000085	0.000190	0.000093	0.000110	0.000302	0.000095	0.000078	0.000082	0.000070	0.000040	0.000082	0.000063	0.000145	0.000127	0.000058	0.000135	0.002679	0.000191	0.000057	0.000080	0.000073	0.000035	0.000212	0.000866	0.000421	0.000168	0.000177	0.000012	0.000074	0.000078	0.000102	0.000198	0.000168	0.000039	0.000210	0.000023	0.000079	0.000054	0.000195	0.000177	0.000112	0.000066	0.000220	0.000052	0.000205	0.000293	0.000090	0.000117	0.000181	0.000007	0.000038	0.000134	0.000021	0.000043	0.000027	0.000045	0.000092	0.000149	0.000093	0.000222	0.000018	0.000019	0.000037	0.000059	0.000085	0.000055	0.000024	0.000052	0.000065	0.000186	0.000305	0.000117	0.000308	0.000126	0.000059	0.000098	0.000122	0.000080	0.000019	0.000044	0.000280	0.000155	0.000031	0.000081	0.000099	0.000059	0.000139	0.000087	0.000126	0.000030	0.000029	0.000013	0.000060	0.000026	0.000090	0.000304	0.000204	0.000102	0.000222	0.000093	0.000207	0.000097	0.000201	0.000192	0.000536	0.000442	0.000123	0.000455	0.000265	0.000491	0.001560	0.000186	0.000405	0.000097	0.000424	0.000396	0.000741	0.000110	0.000439	0.000143	0.000162	0.000068	0.000126	0.000284	0.000296	0.000067	0.000020	0.000056	0.000066	0.000014	0.000083	0.000055	0.000053	0.000097	0.000420	0.000061	0.000009	0.000062	0.000075	0.000018	0.000148	0.000152	0.000207	0.000225	0.000064	0.000028	0.000032	0.000109	0.000077	0.000039	0.000346	0.000058	0.000040	0.000238	0.000064	0.000007	0.000049	0.000201	0.000146	0.000029	0.000171	0.000034	0.000043	0.000127	0.000503	0.000031	0.000079	0.000068	0.000058	0.000163	0.000035	0.000044	0.000022	0.001057	0.000063	0.000472	0.000078	0.000099	0.000284	0.001276	0.000628	0.000080	0.000093	0.000069	0.000053	0.000042	0.000048	0.000093	0.000022	0.000078	0.000214	0.000120	0.000216	0.000631	0.000013	0.000080	0.000030	0.001093	0.000220	0.000419	0.000130	0.000011	0.000017	0.000405	0.000027	0.000309	0.000073	0.000178	0.000047	0.000627	0.000141	0.000122	0.324571	0.000784	0.000147	0.000081	0.002310	0.003636	0.000693	0.000857	0.006926	0.005244	0.007053	0.002822	0.000504	0.001304	0.001273	0.001792	0.005098	0.000153	0.000146	0.005445	0.009937	0.000600	0.004833	0.000238	0.000374	0.000035	0.456538	0.000256	0.000325	0.000477	0.000055
274601121 - Fred again - Actual Life (April 14 - December 17 2020) - Sabrina (i am a party)	274601121	0.367403	0.005299	0.006164	0.009383	0.001639	0.002651	0.000684	0.000260	0.001974	0.000900	0.001726	0.000348	0.000481	0.000177	0.002216	0.000355	0.007309	0.000632	0.002260	0.004925	0.001845	0.003661	0.001850	0.002110	0.002290	0.001030	0.000293	0.011536	0.000494	0.001015	0.000364	0.000373	0.001511	0.000978	0.000755	0.000801	0.003669	0.000209	0.000729	0.000036	0.000593	0.000483	0.000078	0.000071	0.000376	0.000060	0.000196	0.000571	0.000252	0.000358	0.000111	0.000776	0.000112	0.000359	0.000291	0.000307	0.000124	0.000094	0.000408	0.000517	0.000332	0.000454	0.000056	0.000673	0.000425	0.000774	0.000571	0.000213	0.004118	0.003752	0.002157	0.001152	0.003942	0.003245	0.002546	0.000581	0.000761	0.001480	0.000975	0.000193	0.000538	0.000514	0.000051	0.000376	0.000255	0.000136	0.000296	0.000342	0.000361	0.000135	0.000098	0.000100	0.000302	0.000090	0.000272	0.000183	0.000396	0.000346	0.001003	0.000476	0.000255	0.000242	0.000318	0.000330	0.000198	0.000335	0.000266	0.000266	0.000067	0.000054	0.000167	0.000932	0.000359	0.000344	0.000059	0.000184	0.000157	0.000140	0.000120	0.000340	0.000125	0.000019	0.000892	0.000204	0.000365	0.000107	0.000395	0.000139	0.000114	0.000155	0.001104	0.000087	0.000265	0.000109	0.000084	0.001274	0.000175	0.731651	0.024227	0.002336	0.002498	0.000478	0.000439	0.000439	0.000193	0.000118	0.000312	0.000587	0.000365	0.000267	0.000209	0.000334	0.003683	0.002712	0.002250	0.000371	0.000261	0.000176	0.035515	0.075384	0.000144	0.001702	0.002970	0.136837	0.004851	0.000994	0.000742	0.000321	0.002198	0.000237	0.000212	0.000620	0.000582	0.000611	0.000176	0.000132	0.000180	0.000628	0.000173	0.000738	0.001043	0.000989	0.000323	0.000124	0.000637	0.001109	0.000342	0.000631	0.000384	0.000658	0.000105	0.000769	0.000375	0.000234	0.000153	0.002620	0.001101	0.000317	0.000403	0.000269	0.000341	0.000164	0.000254	0.000047	0.000222	0.000306	0.000128	0.000030	0.000435	0.000377	0.000219	0.000467	0.001403	0.003327	0.001157	0.001752	0.010669	0.023752	0.000376	0.002016	0.000480	0.000905	0.000525	0.000623	0.001155	0.000242	0.005905	0.001747	0.003672	0.001052	0.000648	0.000504	0.006518	0.000466	0.000986	0.001970	0.015808	0.000852	0.000379	0.121998	0.062632	0.021539	0.015317	0.070493	0.072708	0.022059	0.010833	0.017761	0.000644	0.000280	0.000134	0.001793	0.000891	0.001595	0.000712	0.000177	0.003919	0.006184	0.000521	0.000557	0.001017	0.000373	0.000175	0.000423	0.000241	0.003259	0.005601	0.002338	0.001479	0.000905	0.005360	0.000408	0.000357	0.000373	0.017416	0.000094	0.001150	0.000838	0.000231	0.001097	0.005879	0.000076	0.000104	0.000198	0.000122	0.000178	0.000082	0.000099	0.000449	0.000127	0.000114	0.000126	0.000219	0.000075	0.000124	0.000089	0.000200	0.000414	0.000107	0.000241	0.005008	0.000597	0.000135	0.000364	0.000190	0.000114	0.000370	0.001327	0.001454	0.000410	0.000189	0.000026	0.000110	0.000127	0.000268	0.000268	0.000303	0.000096	0.001240	0.000027	0.000117	0.000187	0.000556	0.000512	0.000234	0.000188	0.000271	0.000076	0.000468	0.000688	0.000178	0.000210	0.000361	0.000015	0.000156	0.000175	0.000026	0.000089	0.000055	0.000089	0.000123	0.001483	0.002573	0.000330	0.000018	0.000019	0.000068	0.000044	0.000105	0.000078	0.000032	0.000071	0.000080	0.000209	0.000799	0.000382	0.000820	0.000288	0.000628	0.000200	0.000622	0.000318	0.000022	0.000071	0.000394	0.000183	0.000097	0.000076	0.000211	0.000164	0.000139	0.000104	0.000186	0.000190	0.000061	0.000034	0.000048	0.000126	0.000299	0.000450	0.000111	0.000254	0.000506	0.000069	0.000167	0.000099	0.000189	0.000222	0.001002	0.000730	0.000246	0.001539	0.000508	0.001565	0.001873	0.000394	0.002641	0.001164	0.001702	0.001093	0.001479	0.001149	0.001297	0.000248	0.000293	0.000123	0.000197	0.000480	0.000385	0.000127	0.000032	0.000145	0.000091	0.000029	0.000079	0.000113	0.000177	0.000463	0.000489	0.000077	0.000016	0.000049	0.000114	0.000015	0.000162	0.000152	0.000378	0.000389	0.000162	0.000067	0.000079	0.000246	0.000252	0.000143	0.000924	0.000144	0.000067	0.000246	0.000709	0.000021	0.000052	0.000276	0.000500	0.000055	0.000460	0.000221	0.000206	0.000521	0.001260	0.000057	0.000500	0.000113	0.000215	0.000952	0.000067	0.000051	0.000064	0.001728	0.000095	0.001092	0.000266	0.000179	0.000619	0.002292	0.000383	0.002296	0.000128	0.000708	0.000141	0.000076	0.000074	0.000463	0.000071	0.000117	0.001512	0.000503	0.000168	0.001015	0.000009	0.000082	0.000048	0.002134	0.001265	0.000563	0.000157	0.000026	0.000041	0.000701	0.000035	0.000854	0.000100	0.000238	0.000094	0.000151	0.000714	0.000349	0.008847	0.000310	0.000536	0.000146	0.005903	0.003765	0.002572	0.000925	0.008423	0.004170	0.013366	0.016385	0.008996	0.006501	0.002731	0.001897	0.011623	0.000251	0.000144	0.010594	0.000859	0.000897	0.003978	0.000597	0.000602	0.000080	0.008929	0.000279	0.000966	0.000529	0.000117
274601122 - Fred again - Actual Life (April 14 - December 17 2020) - Lydia (please make it better)	274601122	0.108921	0.000809	0.000637	0.001843	0.000171	0.000329	0.000578	0.000161	0.000802	0.000506	0.000463	0.000352	0.000051	0.000065	0.001254	0.000896	0.000496	0.000455	0.000317	0.000115	0.000196	0.000109	0.000620	0.000664	0.000727	0.000685	0.001351	0.067767	0.000464	0.000811	0.000584	0.001231	0.008235	0.005282	0.001746	0.003640	0.010496	0.003117	0.001230	0.000063	0.001151	0.000920	0.000143	0.000137	0.000483	0.000058	0.000219	0.000378	0.000227	0.000724	0.000077	0.000049	0.000056	0.000121	0.000253	0.000151	0.000021	0.000205	0.000182	0.000396	0.000176	0.000065	0.000245	0.000069	0.002561	0.004229	0.000160	0.000017	0.000034	0.000724	0.000174	0.000019	0.003709	0.003059	0.002164	0.000450	0.000428	0.001327	0.000395	0.000298	0.000313	0.000625	0.000081	0.000520	0.000404	0.000143	0.000240	0.000139	0.000119	0.000087	0.000073	0.000067	0.000150	0.000093	0.000141	0.000110	0.000339	0.000232	0.000475	0.000322	0.000136	0.000263	0.000085	0.000078	0.000167	0.000273	0.000163	0.000155	0.000052	0.000044	0.000198	0.001207	0.000456	0.000410	0.000198	0.000124	0.000096	0.000403	0.000458	0.000658	0.000139	0.000020	0.000777	0.000172	0.000310	0.000058	0.000285	0.000241	0.000087	0.000079	0.000359	0.000042	0.000218	0.000107	0.000139	0.000728	0.000161	0.709400	0.030415	0.003800	0.004750	0.000797	0.001222	0.000978	0.000990	0.000471	0.000529	0.000294	0.000309	0.000307	0.000398	0.000479	0.016321	0.011118	0.012864	0.004846	0.006379	0.001991	0.077923	0.033431	0.000713	0.002342	0.003125	0.054236	0.004351	0.001253	0.000941	0.000425	0.002315	0.000688	0.000130	0.000705	0.000603	0.000312	0.000271	0.000747	0.000784	0.001866	0.000422	0.001357	0.001787	0.001757	0.000952	0.000612	0.000914	0.001980	0.000832	0.001209	0.000548	0.000887	0.000206	0.000963	0.000590	0.000371	0.000302	0.003812	0.002778	0.000443	0.000701	0.000584	0.000753	0.000434	0.000328	0.000133	0.000616	0.000398	0.000167	0.000062	0.001730	0.000826	0.000347	0.001016	0.001555	0.012421	0.007195	0.002431	0.026603	0.047594	0.000858	0.004024	0.000915	0.002604	0.001199	0.001781	0.001769	0.001029	0.018957	0.008967	0.005737	0.001542	0.001024	0.000448	0.005706	0.001510	0.003984	0.002573	0.008102	0.001245	0.000451	0.062466	0.022481	0.009052	0.015771	0.008530	0.020802	0.008659	0.029310	0.005806	0.002288	0.000426	0.000208	0.004975	0.001521	0.006201	0.002374	0.000556	0.006064	0.005746	0.001694	0.001939	0.004379	0.000281	0.000921	0.001018	0.000887	0.018271	0.013462	0.003338	0.002921	0.002147	0.007483	0.004431	0.000760	0.001081	0.007281	0.000586	0.001545	0.001556	0.002074	0.004855	0.005139	0.000119	0.000303	0.000101	0.000165	0.000101	0.000057	0.000068	0.000366	0.000080	0.000059	0.000071	0.000079	0.000056	0.000056	0.000049	0.000324	0.000139	0.000046	0.000094	0.001784	0.000147	0.000046	0.000083	0.000054	0.000032	0.000160	0.000566	0.001203	0.000298	0.000166	0.000017	0.000045	0.000065	0.000078	0.000136	0.000142	0.000036	0.001213	0.000021	0.000074	0.000058	0.000358	0.000255	0.000179	0.000117	0.000133	0.000060	0.000296	0.000382	0.000211	0.000213	0.000262	0.000015	0.000052	0.000139	0.000026	0.000055	0.000048	0.000043	0.000091	0.000259	0.000160	0.000194	0.000012	0.000045	0.000026	0.000034	0.000078	0.000060	0.000011	0.000044	0.000057	0.000162	0.000252	0.000288	0.000535	0.000093	0.000079	0.000198	0.000284	0.001656	0.000014	0.000030	0.000129	0.000084	0.000034	0.000065	0.000095	0.000063	0.000157	0.000111	0.000206	0.000032	0.000034	0.000030	0.000088	0.000036	0.000166	0.000477	0.000142	0.000159	0.000220	0.000062	0.000616	0.000067	0.000832	0.000380	0.002196	0.000749	0.000600	0.002198	0.000294	0.002247	0.006437	0.000686	0.001245	0.000320	0.002362	0.002341	0.003330	0.000769	0.002388	0.000208	0.000135	0.000069	0.000115	0.000194	0.000182	0.000054	0.000022	0.000044	0.000108	0.000014	0.000077	0.000059	0.000196	0.000277	0.000367	0.000015	0.000014	0.000037	0.000077	0.000025	0.000174	0.000208	0.000291	0.000344	0.000093	0.000049	0.000043	0.000211	0.000108	0.000076	0.000819	0.000051	0.000066	0.000153	0.000104	0.000005	0.000074	0.000212	0.000219	0.000169	0.000188	0.000031	0.000047	0.000191	0.000446	0.000019	0.000116	0.000068	0.000081	0.000542	0.000032	0.000033	0.000040	0.002485	0.000144	0.000744	0.000111	0.000328	0.004332	0.004179	0.001923	0.000153	0.000345	0.000222	0.000086	0.000055	0.000072	0.000122	0.000046	0.000052	0.000914	0.000192	0.000175	0.001244	0.000011	0.000063	0.000063	0.005749	0.000403	0.000563	0.000222	0.000083	0.000022	0.000538	0.000036	0.000382	0.000088	0.001772	0.000059	0.000240	0.000501	0.000309	0.008259	0.001157	0.000451	0.000160	0.006738	0.022028	0.006259	0.004312	0.007750	0.003575	0.026594	0.008450	0.001447	0.001434	0.001232	0.006734	0.008194	0.000322	0.000197	0.002655	0.000567	0.001555	0.006105	0.000515	0.000760	0.000116	0.011697	0.000193	0.001694	0.001457	0.000081
274601125 - Fred again - Actual Life (April 14 - December 17 2020) - Carlos (make it thru)	274601125	0.495626	0.007607	0.003339	0.001963	0.001159	0.003415	0.000257	0.000907	0.003872	0.001738	0.002116	0.000915	0.000022	0.000088	0.001363	0.001453	0.002312	0.000224	0.000411	0.000925	0.000253	0.000875	0.000564	0.000402	0.001120	0.000261	0.001780	0.119178	0.000911	0.004273	0.000640	0.001775	0.018008	0.004631	0.001051	0.001516	0.002155	0.003895	0.001617	0.000108	0.000966	0.001229	0.000189	0.000374	0.001539	0.000372	0.000511	0.000382	0.000292	0.000731	0.000262	0.001087	0.000172	0.000823	0.000716	0.000652	0.000037	0.000641	0.000227	0.000665	0.000331	0.000126	0.000251	0.000548	0.000827	0.000704	0.000429	0.000481	0.000312	0.001926	0.001058	0.000097	0.006229	0.003062	0.001911	0.000308	0.000446	0.000437	0.000531	0.000202	0.000439	0.001067	0.000279	0.000684	0.000854	0.000238	0.000766	0.000827	0.000830	0.000203	0.000233	0.000196	0.000212	0.000324	0.000564	0.000345	0.000671	0.000582	0.001124	0.000773	0.000353	0.000421	0.000295	0.000261	0.000443	0.000766	0.000359	0.000343	0.000177	0.000112	0.000263	0.001943	0.000637	0.000419	0.000149	0.000600	0.000359	0.000559	0.000568	0.000282	0.000092	0.000092	0.000532	0.000495	0.001033	0.000545	0.000740	0.000403	0.000373	0.000262	0.001174	0.000156	0.000423	0.000191	0.000798	0.000640	0.002481	0.731938	0.039299	0.011230	0.014817	0.002011	0.004374	0.003286	0.002661	0.000781	0.001805	0.000764	0.000890	0.000659	0.002006	0.001276	0.008189	0.007261	0.006315	0.002257	0.002585	0.001148	0.008683	0.003153	0.000865	0.006332	0.002942	0.001499	0.004226	0.001185	0.000890	0.000544	0.001598	0.001222	0.000691	0.000696	0.000494	0.001317	0.000723	0.001082	0.001688	0.012734	0.001605	0.003397	0.005046	0.004071	0.006966	0.001085	0.001532	0.001470	0.000341	0.000522	0.000259	0.005206	0.000897	0.002639	0.007596	0.002341	0.003226	0.002248	0.002228	0.001169	0.000841	0.005553	0.000704	0.000354	0.000471	0.000118	0.003602	0.000512	0.000180	0.000034	0.000836	0.000660	0.000075	0.002070	0.000606	0.020613	0.060232	0.000625	0.008485	0.003676	0.001023	0.004335	0.001514	0.002051	0.000892	0.001990	0.002490	0.001271	0.004859	0.007430	0.001754	0.006889	0.001336	0.001890	0.001690	0.002790	0.003543	0.007397	0.000948	0.002398	0.001160	0.009045	0.002482	0.001606	0.001455	0.001659	0.003853	0.000981	0.032049	0.001562	0.007016	0.002849	0.004944	0.006615	0.001653	0.013999	0.004055	0.000665	0.002210	0.001003	0.002690	0.004868	0.003254	0.000592	0.001282	0.000874	0.001955	0.010441	0.016857	0.004034	0.002014	0.002069	0.005885	0.005361	0.000517	0.001734	0.001983	0.002788	0.001996	0.001608	0.004463	0.010414	0.001952	0.000487	0.001178	0.000186	0.000635	0.000175	0.000147	0.000148	0.000725	0.000393	0.000397	0.000467	0.000238	0.000154	0.000146	0.000106	0.000364	0.000485	0.000373	0.000506	0.003211	0.000393	0.000111	0.000249	0.000137	0.000054	0.000218	0.001020	0.000693	0.000145	0.000052	0.000095	0.000086	0.000086	0.000229	0.000227	0.000158	0.000092	0.000375	0.000036	0.000093	0.000133	0.000126	0.000111	0.000046	0.000050	0.000254	0.000039	0.000365	0.000529	0.000148	0.000172	0.000320	0.000018	0.000094	0.000303	0.000060	0.000096	0.000098	0.000126	0.000201	0.001557	0.000829	0.000308	0.000019	0.000055	0.000064	0.000038	0.000119	0.000087	0.000022	0.000107	0.000098	0.000203	0.001086	0.000616	0.001341	0.000380	0.000257	0.000313	0.001927	0.000599	0.000066	0.000075	0.000288	0.000166	0.000147	0.000192	0.000235	0.000157	0.000236	0.000142	0.000128	0.000035	0.000121	0.000355	0.000070	0.000100	0.000493	0.000909	0.000236	0.000653	0.000267	0.000229	0.001224	0.000606	0.001343	0.001390	0.000344	0.000893	0.000492	0.000562	0.000447	0.002020	0.003266	0.000198	0.000588	0.000321	0.000475	0.000731	0.000394	0.000754	0.000485	0.000209	0.000244	0.000104	0.000286	0.001074	0.000936	0.000130	0.000035	0.000158	0.000316	0.000027	0.000134	0.000235	0.002123	0.002992	0.000428	0.000050	0.000029	0.000070	0.000148	0.000036	0.000161	0.000194	0.000840	0.000772	0.000376	0.000235	0.000154	0.000412	0.000274	0.000325	0.001248	0.000245	0.000330	0.000301	0.000259	0.000043	0.000238	0.000544	0.000888	0.000948	0.000386	0.000109	0.000279	0.000865	0.000594	0.000096	0.000468	0.000244	0.000167	0.001045	0.000048	0.000090	0.000150	0.008959	0.001106	0.001052	0.000461	0.001137	0.007698	0.003816	0.000821	0.000289	0.000725	0.000601	0.000266	0.000219	0.000350	0.000047	0.000343	0.000158	0.000988	0.000308	0.000377	0.001242	0.000032	0.000181	0.000280	0.002616	0.001437	0.000793	0.000382	0.000099	0.000051	0.001005	0.000026	0.000560	0.000305	0.001365	0.000086	0.001774	0.000961	0.000603	0.005967	0.000164	0.000663	0.000445	0.015486	0.021101	0.031891	0.005824	0.004449	0.000441	0.022570	0.046196	0.007924	0.006783	0.005054	0.006382	0.015164	0.000456	0.000518	0.002729	0.000815	0.001419	0.001270	0.000879	0.001312	0.000216	0.002733	0.000239	0.003132	0.003287	0.000143
274601126 - Fred again - Actual Life (April 14 - December 17 2020) - Angie (interlude)	274601126	0.231890	0.001989	0.001543	0.003119	0.000267	0.001112	0.000483	0.000323	0.000355	0.000216	0.000334	0.000187	0.000046	0.000032	0.000718	0.000547	0.002073	0.000953	0.001159	0.000639	0.000705	0.000476	0.000847	0.000859	0.000940	0.000498	0.000468	0.033835	0.000362	0.000652	0.001079	0.003600	0.004436	0.002737	0.000820	0.001789	0.002359	0.001199	0.000771	0.000068	0.000847	0.001404	0.000316	0.000173	0.001068	0.000226	0.000690	0.000766	0.000443	0.001270	0.000107	0.000096	0.000097	0.000265	0.000231	0.000160	0.000058	0.000131	0.000363	0.000555	0.000298	0.000046	0.000046	0.000086	0.008618	0.006231	0.000091	0.000029	0.000050	0.000575	0.000244	0.000049	0.005107	0.003733	0.002372	0.000598	0.000523	0.000302	0.000511	0.000259	0.000450	0.000561	0.000050	0.000421	0.000548	0.000113	0.000637	0.000190	0.000164	0.000077	0.000112	0.000097	0.000041	0.000235	0.000332	0.000404	0.000916	0.000714	0.001470	0.000643	0.000342	0.000649	0.000231	0.000234	0.000418	0.000542	0.000614	0.000623	0.000076	0.000050	0.000087	0.002052	0.000771	0.000610	0.000174	0.000180	0.000132	0.000470	0.000424	0.000965	0.000205	0.000048	0.000560	0.000206	0.000283	0.000088	0.000988	0.000632	0.000285	0.000298	0.000790	0.000165	0.000484	0.000201	0.000351	0.000448	0.000510	0.621317	0.028048	0.003334	0.005237	0.000652	0.001607	0.000498	0.000438	0.000209	0.000382	0.000098	0.000108	0.000070	0.000131	0.000121	0.013514	0.007954	0.006411	0.005845	0.005045	0.003510	0.053695	0.010027	0.000247	0.001324	0.001323	0.001806	0.001552	0.000550	0.000381	0.000229	0.000855	0.000148	0.000031	0.000469	0.000327	0.000090	0.000190	0.000360	0.000433	0.007713	0.000489	0.000756	0.000994	0.000912	0.000418	0.000101	0.000476	0.000627	0.000156	0.000241	0.000143	0.000592	0.000109	0.000368	0.000196	0.000258	0.000287	0.001498	0.000484	0.000273	0.000146	0.000187	0.000351	0.000122	0.000174	0.000043	0.000892	0.000253	0.000088	0.000010	0.000942	0.000674	0.000077	0.004724	0.000431	0.014911	0.063004	0.000587	0.004139	0.004250	0.000844	0.002577	0.000872	0.001356	0.000763	0.001233	0.000864	0.000870	0.002907	0.004841	0.002911	0.001349	0.000264	0.000287	0.001265	0.000589	0.001272	0.001270	0.001504	0.000488	0.000213	0.056161	0.007990	0.004807	0.009487	0.007211	0.017892	0.003565	0.204609	0.010879	0.000577	0.000103	0.000086	0.002368	0.001099	0.021496	0.002435	0.000437	0.001109	0.000494	0.001230	0.001718	0.000772	0.000118	0.000304	0.000567	0.000504	0.007844	0.013595	0.002397	0.001270	0.001021	0.007102	0.002457	0.000344	0.000955	0.001716	0.000264	0.000648	0.000762	0.001215	0.003321	0.001355	0.000237	0.000451	0.000200	0.000216	0.000199	0.000078	0.000082	0.000818	0.000110	0.000101	0.000097	0.000164	0.000110	0.000141	0.000100	0.000422	0.000308	0.000094	0.000162	0.003331	0.000358	0.000081	0.000163	0.000111	0.000079	0.000237	0.001131	0.000944	0.000330	0.000228	0.000038	0.000047	0.000050	0.000106	0.000136	0.000211	0.000064	0.000469	0.000025	0.000026	0.000077	0.000181	0.000172	0.000091	0.000063	0.000202	0.000062	0.000339	0.000426	0.000130	0.000135	0.000295	0.000016	0.000058	0.000184	0.000038	0.000060	0.000056	0.000080	0.000115	0.000525	0.000155	0.000381	0.000017	0.000141	0.000079	0.000074	0.000141	0.000095	0.000036	0.000117	0.000128	0.000254	0.000403	0.000121	0.000343	0.000144	0.000085	0.000115	0.000198	0.000535	0.000024	0.000037	0.000333	0.000205	0.000059	0.000189	0.000110	0.000158	0.000341	0.000285	0.000247	0.000058	0.000084	0.000177	0.000413	0.000102	0.000269	0.000688	0.000288	0.000166	0.000683	0.000091	0.000235	0.000091	0.000251	0.000519	0.001105	0.000776	0.000464	0.000538	0.000334	0.000622	0.000771	0.000219	0.000628	0.000128	0.000723	0.000619	0.001185	0.000272	0.000697	0.000181	0.000314	0.000221	0.000092	0.000256	0.000279	0.000165	0.000075	0.000134	0.000175	0.000023	0.000118	0.000192	0.000181	0.000416	0.001003	0.000035	0.000041	0.000182	0.000667	0.000180	0.000447	0.000548	0.000408	0.000732	0.000364	0.000093	0.000049	0.000335	0.000128	0.000119	0.000633	0.000066	0.000113	0.000486	0.000090	0.000027	0.000110	0.000371	0.000261	0.000115	0.000260	0.000173	0.000146	0.000224	0.000342	0.000032	0.000138	0.000104	0.000101	0.000653	0.000058	0.000128	0.000035	0.005842	0.000148	0.000392	0.000143	0.000107	0.001583	0.006609	0.003910	0.000058	0.000138	0.000250	0.000105	0.000075	0.000174	0.000038	0.000075	0.000083	0.000573	0.000350	0.001251	0.000510	0.000016	0.000109	0.000093	0.001304	0.000353	0.000361	0.000173	0.000112	0.000037	0.000564	0.000036	0.000358	0.000232	0.000651	0.000077	0.000900	0.000312	0.000099	0.072671	0.000062	0.000356	0.000131	0.002779	0.006112	0.012193	0.002108	0.008861	0.004290	0.015339	0.007590	0.001082	0.001956	0.002534	0.020103	0.035180	0.000221	0.000256	0.003278	0.004997	0.002128	0.002364	0.000333	0.000438	0.000089	0.057215	0.000315	0.000710	0.001127	0.000103
274601127 - Fred again - Actual Life (April 14 - December 17 2020) - Angie (i’ve been lost) [feat. Angie McMahon]	274601127	0.058527	0.000666	0.000619	0.000782	0.000171	0.000358	0.000234	0.000121	0.000291	0.000295	0.000466	0.000223	0.000034	0.000033	0.000408	0.000752	0.000615	0.000211	0.000325	0.000130	0.000168	0.000125	0.000331	0.000264	0.000295	0.000217	0.000283	0.069251	0.000405	0.002375	0.000241	0.000397	0.005567	0.001924	0.000500	0.000927	0.001649	0.000567	0.000481	0.000036	0.000885	0.000428	0.000081	0.000074	0.000287	0.000042	0.000166	0.000261	0.000152	0.000475	0.000145	0.000043	0.000034	0.000120	0.000266	0.000236	0.000015	0.000448	0.000195	0.000314	0.000081	0.000028	0.000047	0.000062	0.004087	0.001976	0.000133	0.000034	0.000045	0.000719	0.000130	0.000009	0.002053	0.001850	0.001179	0.000374	0.000226	0.000379	0.000324	0.000150	0.000147	0.000349	0.000102	0.000230	0.000207	0.000071	0.000223	0.000082	0.000082	0.000024	0.000048	0.000045	0.001772	0.000074	0.000135	0.000099	0.000189	0.000156	0.000609	0.000307	0.000150	0.000202	0.000163	0.000154	0.000145	0.000230	0.000158	0.000156	0.000066	0.000057	0.000126	0.000806	0.000352	0.000317	0.000039	0.000110	0.000077	0.000103	0.000106	0.000243	0.000075	0.000017	0.000400	0.000102	0.000103	0.000055	0.000352	0.000290	0.000080	0.000093	0.000226	0.000040	0.000430	0.000255	0.000076	0.000889	0.000115	0.636304	0.040085	0.006589	0.009098	0.000925	0.002922	0.001422	0.000894	0.000485	0.000966	0.001055	0.000132	0.000526	0.000752	0.000722	0.009421	0.007005	0.005414	0.005087	0.005267	0.002476	0.025508	0.025879	0.000480	0.014744	0.024176	0.027642	0.024654	0.010904	0.010524	0.003526	0.017488	0.001454	0.000112	0.004470	0.003489	0.000938	0.000322	0.001047	0.001639	0.001238	0.000966	0.001623	0.002291	0.001848	0.001044	0.001037	0.001499	0.000769	0.000169	0.000406	0.000225	0.001546	0.000146	0.000857	0.001437	0.000541	0.000723	0.001404	0.000777	0.000330	0.000349	0.000832	0.000502	0.000172	0.001055	0.000153	0.001524	0.000464	0.000225	0.000024	0.000947	0.000889	0.000088	0.000260	0.000341	0.005419	0.007181	0.001162	0.022487	0.007017	0.000384	0.009941	0.001107	0.003357	0.001652	0.002617	0.005647	0.003502	0.015674	0.014521	0.013479	0.007994	0.006191	0.002647	0.028653	0.001707	0.002540	0.007842	0.039926	0.000815	0.000374	0.076138	0.063499	0.024009	0.005506	0.019870	0.036096	0.015452	0.010903	0.020920	0.001947	0.000500	0.000702	0.012006	0.001646	0.002967	0.001004	0.000252	0.005840	0.004696	0.001701	0.002376	0.001647	0.000090	0.001179	0.008164	0.000478	0.019254	0.019165	0.003245	0.002128	0.003788	0.009651	0.000815	0.000668	0.001591	0.023066	0.000346	0.005464	0.003388	0.000542	0.002278	0.014067	0.000097	0.000164	0.000090	0.000095	0.000080	0.000057	0.000073	0.000212	0.000056	0.000049	0.000046	0.000066	0.000027	0.000045	0.000037	0.000180	0.000139	0.000037	0.000147	0.002179	0.000148	0.000036	0.000106	0.000054	0.000023	0.000141	0.000638	0.001053	0.000184	0.000317	0.000007	0.000034	0.000033	0.000081	0.000091	0.000130	0.000022	0.000533	0.000015	0.000045	0.000043	0.000327	0.000362	0.000144	0.000103	0.000130	0.000026	0.000154	0.000218	0.000101	0.000074	0.000135	0.000003	0.000026	0.000107	0.000021	0.000053	0.000024	0.000039	0.000082	0.000248	0.000265	0.000165	0.000005	0.000028	0.000014	0.000009	0.000058	0.000044	0.000009	0.000048	0.000047	0.000152	0.000137	0.000426	0.000425	0.000064	0.000040	0.000047	0.000131	0.000250	0.000013	0.000027	0.000132	0.000080	0.000014	0.000059	0.000051	0.000028	0.000113	0.000087	0.000064	0.000025	0.000040	0.000014	0.000030	0.000025	0.000149	0.000597	0.000088	0.000070	0.000072	0.000036	0.000237	0.000048	0.000233	0.000237	0.004262	0.001212	0.000642	0.001473	0.000448	0.002556	0.006030	0.001020	0.001539	0.000443	0.001898	0.004192	0.007391	0.000328	0.001670	0.000131	0.000132	0.000068	0.000479	0.000447	0.000465	0.000064	0.000022	0.000019	0.000057	0.000008	0.000039	0.000050	0.000138	0.000230	0.000210	0.000018	0.000008	0.000014	0.000030	0.000009	0.000086	0.000130	0.000351	0.000277	0.000063	0.000023	0.000054	0.000173	0.000127	0.000088	0.000852	0.000081	0.000037	0.000056	0.000030	0.000002	0.000021	0.000184	0.000238	0.000060	0.000140	0.000029	0.000030	0.000161	0.000350	0.000022	0.000076	0.000036	0.000061	0.000270	0.000011	0.000030	0.000024	0.002738	0.000129	0.000451	0.000083	0.000099	0.001415	0.001551	0.000605	0.000026	0.000144	0.000086	0.000043	0.000017	0.000047	0.000046	0.000053	0.000043	0.000636	0.000198	0.000081	0.004132	0.000007	0.000045	0.000060	0.004697	0.000282	0.000973	0.000329	0.000037	0.000021	0.000560	0.000035	0.000389	0.000081	0.000448	0.000033	0.000574	0.000472	0.000462	0.010535	0.000193	0.000771	0.000111	0.005560	0.057106	0.005100	0.009095	0.005638	0.002728	0.013903	0.006145	0.000849	0.001576	0.001364	0.002108	0.004162	0.000145	0.000212	0.004991	0.000323	0.000707	0.010461	0.000281	0.000289	0.000044	0.023003	0.000131	0.000708	0.001355	0.000148
252712047 - Adam Hinden - Butterflies (feat. waitjk) [Remix] - Butterflies (feat. waitjk) (Remix)	252712047	0.027614	0.000435	0.000381	0.000897	0.000104	0.000344	0.000212	0.000117	0.000184	0.000107	0.000147	0.000051	0.000034	0.000036	0.000149	0.000479	0.000396	0.000183	0.000182	0.000095	0.000219	0.000072	0.000302	0.000332	0.000213	0.000155	0.000119	0.039018	0.000305	0.000740	0.000264	0.000714	0.001473	0.001491	0.000456	0.001114	0.025988	0.000664	0.000178	0.000016	0.000345	0.000317	0.000066	0.000232	0.000139	0.000031	0.000160	0.000231	0.000110	0.000115	0.000155	0.000114	0.000017	0.000154	0.000738	0.000246	0.000013	0.000368	0.000139	0.000398	0.000306	0.000182	0.000124	0.000203	0.000598	0.000560	0.000104	0.000024	0.000102	0.000421	0.000118	0.000041	0.002709	0.001706	0.001071	0.000369	0.000214	0.000364	0.000329	0.000104	0.000216	0.000484	0.000183	0.000217	0.000245	0.000066	0.000352	0.000377	0.000438	0.000097	0.000106	0.000100	0.000673	0.000089	0.000171	0.000138	0.000217	0.000205	0.000548	0.000342	0.000176	0.000187	0.000125	0.000123	0.000159	0.000208	0.000188	0.000191	0.000033	0.000022	0.000068	0.001088	0.000489	0.000459	0.000016	0.000197	0.000111	0.000067	0.000073	0.000237	0.000079	0.000055	0.000260	0.000240	0.000336	0.000141	0.001222	0.000754	0.000344	0.000367	0.001729	0.000203	0.000495	0.000158	0.000127	0.001526	0.000069	0.832833	0.033256	0.004460	0.004229	0.000902	0.000808	0.000771	0.000223	0.000167	0.000786	0.000743	0.000645	0.000416	0.000310	0.000348	0.002509	0.002143	0.001523	0.000867	0.000449	0.000323	0.005781	0.021364	0.000313	0.005701	0.015048	0.015519	0.021026	0.004179	0.003469	0.001930	0.010876	0.000387	0.000605	0.002156	0.001786	0.000493	0.000673	0.000610	0.000842	0.000076	0.000136	0.000635	0.000783	0.000847	0.000182	0.000064	0.000763	0.001268	0.000391	0.000571	0.000387	0.001089	0.000140	0.001212	0.000587	0.000397	0.000317	0.001626	0.000981	0.000411	0.000352	0.000666	0.000382	0.000126	0.000595	0.000135	0.000104	0.001021	0.000793	0.000054	0.000322	0.000340	0.000374	0.000481	0.000457	0.000853	0.000525	0.001116	0.031471	0.106388	0.000420	0.003712	0.002236	0.003710	0.001117	0.002485	0.002816	0.000478	0.050268	0.006882	0.017018	0.001565	0.000648	0.000640	0.006391	0.001702	0.006994	0.006270	0.003943	0.001220	0.000267	0.119325	0.004387	0.003900	0.021149	0.493198	0.009611	0.003685	0.005650	0.003409	0.001227	0.000571	0.000127	0.007483	0.000677	0.004625	0.001350	0.000219	0.008146	0.014159	0.001692	0.001976	0.002272	0.000466	0.001003	0.001057	0.000573	0.009792	0.061977	0.004108	0.004149	0.001588	0.015023	0.001549	0.000952	0.001271	0.008453	0.000342	0.002781	0.001540	0.001374	0.004189	0.014479	0.000356	0.000219	0.000185	0.000127	0.000171	0.000030	0.000038	0.000323	0.000047	0.000049	0.000047	0.000092	0.000027	0.000094	0.000067	0.000206	0.000232	0.000057	0.000146	0.002800	0.000331	0.000057	0.000203	0.000130	0.000055	0.000160	0.000585	0.000527	0.000163	0.000244	0.000021	0.000015	0.000037	0.000080	0.000091	0.000102	0.000019	0.000202	0.000017	0.000151	0.000044	0.000208	0.000161	0.000112	0.000069	0.000339	0.000044	0.000196	0.000255	0.000085	0.000090	0.000166	0.000007	0.000036	0.000166	0.000016	0.000041	0.000055	0.000151	0.000077	0.000958	0.000936	0.000232	0.000006	0.000032	0.000055	0.000058	0.000079	0.000053	0.000019	0.000057	0.000058	0.000139	0.000238	0.000317	0.000602	0.000109	0.000095	0.000124	0.000258	0.000266	0.000007	0.000042	0.000178	0.000105	0.000372	0.000074	0.000069	0.000024	0.000117	0.000078	0.000078	0.000015	0.000034	0.000063	0.000051	0.000029	0.000130	0.001091	0.000163	0.000185	0.000405	0.000091	0.000580	0.000173	0.000565	0.000268	0.002187	0.001063	0.000351	0.001546	0.000387	0.001428	0.001050	0.001622	0.000721	0.000187	0.001485	0.003444	0.003792	0.000460	0.001948	0.000117	0.000304	0.000175	0.000875	0.000572	0.000603	0.000155	0.000028	0.000099	0.000179	0.000010	0.000107	0.000055	0.000154	0.000315	0.000318	0.000037	0.000031	0.000027	0.000043	0.000005	0.000121	0.000122	0.000193	0.000210	0.000147	0.000055	0.000029	0.000160	0.000189	0.000072	0.000792	0.000072	0.000040	0.000122	0.001545	0.000010	0.000017	0.000198	0.000225	0.000046	0.000207	0.000043	0.000064	0.000145	0.000334	0.000056	0.000167	0.000061	0.000055	0.000252	0.000022	0.000041	0.000035	0.000506	0.000120	0.000521	0.000112	0.000077	0.000378	0.001290	0.000924	0.000244	0.000118	0.000164	0.000049	0.000031	0.000066	0.000498	0.000033	0.000085	0.001139	0.000138	0.000078	0.001246	0.000029	0.000144	0.000105	0.002500	0.000297	0.000323	0.000076	0.000031	0.000045	0.000768	0.000036	0.000620	0.000109	0.000890	0.000053	0.000307	0.000551	0.000539	0.005148	0.007546	0.000264	0.000191	0.007728	0.003245	0.000735	0.000548	0.005633	0.000811	0.006874	0.002229	0.000506	0.001188	0.001379	0.000911	0.002924	0.000286	0.000285	0.006031	0.000782	0.000597	0.000396	0.000185	0.000273	0.000033	0.003451	0.000161	0.000259	0.000333	0.000198
259311431 - Gorillaz - New Gold (feat. Tame Impala and Bootie Brown) [Dom Dolla Remix] - New Gold (feat. Tame Impala and Bootie Brown) [Dom Dolla Remix]	259311431	0.089038	0.001629	0.001166	0.001120	0.000481	0.001097	0.000181	0.000268	0.000185	0.000238	0.000341	0.000090	0.000128	0.000022	0.000458	0.000596	0.000725	0.000131	0.000273	0.000309	0.000201	0.000308	0.000462	0.000325	0.000488	0.000227	0.000226	0.009057	0.000293	0.000374	0.000296	0.000360	0.001151	0.000371	0.000196	0.000625	0.002080	0.000449	0.000271	0.000030	0.000507	0.000281	0.000068	0.000067	0.000109	0.000029	0.000132	0.000404	0.000279	0.000382	0.000082	0.000039	0.000135	0.000079	0.000334	0.000202	0.000024	0.000131	0.000227	0.000360	0.000305	0.000169	0.000137	0.000213	0.000515	0.000438	0.000111	0.000040	0.000056	0.000586	0.000090	0.000012	0.002732	0.002543	0.002179	0.001011	0.000494	0.000705	0.000864	0.000161	0.000322	0.000245	0.000057	0.000139	0.000165	0.000050	0.000190	0.000097	0.000076	0.000032	0.000041	0.000040	0.000100	0.000070	0.000111	0.000087	0.000163	0.000147	0.000497	0.000288	0.000128	0.000173	0.000106	0.000106	0.000100	0.000128	0.000124	0.000115	0.000035	0.000026	0.000052	0.000717	0.000262	0.000204	0.000009	0.000126	0.000086	0.000070	0.000053	0.000150	0.000055	0.000007	0.000670	0.000064	0.000089	0.000048	0.000406	0.000088	0.000114	0.000180	0.001549	0.000085	0.000159	0.000072	0.000062	0.000497	0.000020	0.811638	0.015541	0.001298	0.001427	0.000258	0.000247	0.000254	0.000087	0.000063	0.000215	0.000277	0.000178	0.000125	0.000084	0.000293	0.001822	0.001401	0.000819	0.000159	0.000116	0.000073	0.008414	0.030577	0.000125	0.001405	0.002175	0.025522	0.003333	0.000800	0.000500	0.000335	0.001489	0.000147	0.000077	0.000567	0.000512	0.000213	0.000159	0.000090	0.000261	0.000121	0.000099	0.000328	0.000467	0.000410	0.000131	0.000023	0.000455	0.000687	0.000151	0.000318	0.000296	0.000319	0.000056	0.000392	0.000167	0.000114	0.000057	0.001094	0.000549	0.000128	0.000137	0.000113	0.000267	0.000087	0.000428	0.000135	0.000401	0.000285	0.000157	0.000017	0.000400	0.000232	0.000069	0.000128	0.000229	0.000607	0.000568	0.001396	0.021428	0.017319	0.000342	0.002550	0.000725	0.001473	0.000580	0.001116	0.001267	0.000129	0.010599	0.001302	0.002264	0.000618	0.000705	0.000216	0.011455	0.000341	0.000995	0.002291	0.074460	0.000602	0.000228	0.280563	0.345790	0.091631	0.019768	0.056939	0.137707	0.247766	0.001090	0.126494	0.000790	0.000176	0.000059	0.002364	0.000502	0.000721	0.001156	0.000243	0.001893	0.003119	0.000647	0.000434	0.000700	0.000235	0.000095	0.000910	0.000199	0.004000	0.010424	0.003336	0.001545	0.001303	0.012256	0.000267	0.000247	0.000721	0.096077	0.000065	0.002643	0.000960	0.000135	0.000717	0.018643	0.000071	0.000063	0.000072	0.000073	0.000067	0.000017	0.000019	0.000187	0.000023	0.000022	0.000021	0.000052	0.000020	0.000033	0.000024	0.000103	0.000113	0.000032	0.000081	0.001466	0.000127	0.000025	0.000082	0.000051	0.000018	0.000121	0.000347	0.000378	0.000051	0.000074	0.000009	0.000021	0.000028	0.000058	0.000068	0.000104	0.000022	0.000372	0.000008	0.000054	0.000026	0.000211	0.000209	0.000101	0.000079	0.000118	0.000018	0.000122	0.000164	0.000054	0.000052	0.000106	0.000004	0.000033	0.000081	0.000016	0.000037	0.000025	0.000045	0.000051	0.000089	0.000059	0.000110	0.000007	0.000016	0.000023	0.000014	0.000040	0.000028	0.000005	0.000020	0.000028	0.000084	0.000209	0.000542	0.000554	0.000077	0.000082	0.000052	0.000167	0.000079	0.000010	0.000054	0.000193	0.000117	0.000041	0.000042	0.000062	0.000035	0.000068	0.000058	0.000061	0.000049	0.000039	0.000009	0.000042	0.000045	0.000189	0.000326	0.000082	0.000093	0.000165	0.000079	0.000141	0.000041	0.000152	0.000230	0.001421	0.001276	0.000515	0.001047	0.000464	0.002923	0.003771	0.000381	0.001084	0.000383	0.000958	0.001360	0.003187	0.000297	0.000933	0.000091	0.000084	0.000032	0.000238	0.000275	0.000274	0.000035	0.000016	0.000027	0.000061	0.000009	0.000062	0.000038	0.000082	0.000143	0.000196	0.000031	0.000003	0.000019	0.000056	0.000010	0.000065	0.000073	0.000119	0.000250	0.000050	0.000015	0.000028	0.000305	0.000076	0.000060	0.000511	0.000028	0.000014	0.000102	0.000071	0.000003	0.000024	0.000128	0.000119	0.000020	0.000142	0.000021	0.000036	0.000280	0.000560	0.000026	0.000102	0.000022	0.000045	0.000333	0.000015	0.000028	0.000019	0.000524	0.000047	0.000289	0.000061	0.000111	0.000219	0.000529	0.000103	0.000068	0.000066	0.000228	0.000025	0.000012	0.000045	0.000087	0.000052	0.000040	0.000108	0.000210	0.000105	0.001108	0.000007	0.000048	0.000065	0.001508	0.000639	0.000556	0.000197	0.000005	0.000014	0.000581	0.000013	0.000266	0.000068	0.000493	0.000024	0.000059	0.000650	0.000406	0.004024	0.000932	0.000330	0.000142	0.004019	0.003191	0.001804	0.000436	0.005623	0.001221	0.009102	0.003135	0.000430	0.000695	0.000867	0.000951	0.003884	0.000095	0.000104	0.017010	0.000295	0.000286	0.005312	0.000470	0.000412	0.000047	0.007961	0.000177	0.000802	0.001194	0.000051
176049747 - DE-TÜ - Off My Chest - Off My Chest	176049747	0.269117	0.001375	0.000577	0.002509	0.000238	0.001210	0.000190	0.000868	0.000214	0.000166	0.000232	0.000060	0.000071	0.000066	0.000429	0.000488	0.000685	0.000287	0.000245	0.000291	0.000324	0.000182	0.000473	0.000663	0.000446	0.000082	0.000137	0.004889	0.000136	0.000184	0.000062	0.000165	0.000342	0.000445	0.000407	0.000245	0.042655	0.000195	0.000279	0.000031	0.001755	0.000253	0.000034	0.000061	0.000097	0.000037	0.000111	0.000235	0.000127	0.000151	0.000060	0.000110	0.000034	0.000118	0.000421	0.000209	0.000056	0.000097	0.000097	0.000113	0.000207	0.000278	0.000054	0.000157	0.001909	0.002693	0.000149	0.000073	0.000088	0.000408	0.000125	0.000084	0.003671	0.002687	0.001655	0.000329	0.000414	0.001903	0.000422	0.000091	0.000347	0.000578	0.000039	0.000461	0.000367	0.000208	0.000433	0.000139	0.000093	0.000050	0.000098	0.000096	0.000152	0.000117	0.000241	0.000237	0.000588	0.000528	0.000945	0.000589	0.000331	0.000434	0.000325	0.000333	0.000155	0.000239	0.000175	0.000185	0.000063	0.000043	0.000061	0.001325	0.000800	0.000728	0.000036	0.000164	0.000147	0.000189	0.000210	0.000547	0.000114	0.000033	0.000785	0.000223	0.000443	0.000111	0.000880	0.000562	0.000241	0.000271	0.000306	0.000100	0.000851	0.000262	0.000202	0.000608	0.000634	0.740563	0.032825	0.002103	0.002331	0.000481	0.000435	0.000516	0.000216	0.000131	0.000383	0.000174	0.000280	0.000156	0.000233	0.000265	0.008543	0.007118	0.004142	0.000556	0.000439	0.000294	0.041003	0.018384	0.000125	0.006733	0.003959	0.029316	0.006824	0.001219	0.000997	0.000283	0.002752	0.000235	0.000166	0.000789	0.000711	0.000939	0.000250	0.000252	0.000132	0.000857	0.001687	0.045212	0.057320	0.058043	0.015782	0.000230	0.000496	0.000827	0.000243	0.000473	0.000113	0.000604	0.000086	0.000844	0.000418	0.000174	0.000122	0.003368	0.002717	0.000607	0.000650	0.000517	0.000364	0.000105	0.000431	0.000130	0.001042	0.004786	0.001138	0.000011	0.001576	0.000197	0.000123	0.000197	0.000889	0.003990	0.008374	0.003614	0.003774	0.108882	0.000445	0.001011	0.000560	0.000593	0.000254	0.000624	0.000442	0.000134	0.004405	0.002376	0.003438	0.000366	0.000229	0.000116	0.002100	0.000305	0.000662	0.002589	0.000810	0.001001	0.000087	0.082401	0.004185	0.003083	0.029259	0.011406	0.016415	0.001743	0.053191	0.001798	0.000243	0.000126	0.000097	0.002032	0.001304	0.006843	0.000305	0.000040	0.001205	0.000900	0.000888	0.000358	0.000438	0.000144	0.000118	0.000226	0.000275	0.003176	0.001743	0.004299	0.001623	0.001255	0.006352	0.002086	0.000368	0.000940	0.001510	0.000104	0.000422	0.000446	0.000639	0.002284	0.001467	0.000195	0.000131	0.000214	0.000200	0.000204	0.000061	0.000075	0.000896	0.000108	0.000113	0.000089	0.000249	0.000099	0.000154	0.000111	0.000224	0.000525	0.000099	0.000198	0.004007	0.000483	0.000092	0.000311	0.000106	0.000035	0.000355	0.000858	0.000986	0.000265	0.002245	0.000093	0.000071	0.000049	0.000130	0.000149	0.000260	0.000045	0.000429	0.000052	0.001032	0.000084	0.002644	0.001500	0.001509	0.000522	0.000228	0.000092	0.000295	0.000390	0.000124	0.000166	0.000231	0.000008	0.000072	0.000120	0.000018	0.000024	0.000045	0.000061	0.000080	0.001055	0.000930	0.000253	0.000014	0.000038	0.000065	0.000034	0.000087	0.000048	0.000020	0.000043	0.000052	0.000125	0.000875	0.001396	0.008349	0.000270	0.000190	0.000306	0.000408	0.000193	0.000020	0.000056	0.000390	0.000217	0.000061	0.000065	0.000148	0.000086	0.000249	0.000138	0.000257	0.000041	0.000078	0.000046	0.000120	0.000109	0.000140	0.000947	0.000285	0.000536	0.000462	0.000124	0.000504	0.000113	0.000639	0.000243	0.006985	0.002668	0.000814	0.010724	0.002042	0.005719	0.003821	0.001575	0.004443	0.000547	0.003578	0.005779	0.005441	0.000068	0.001961	0.000154	0.000510	0.000279	0.001743	0.001975	0.001671	0.000239	0.000042	0.000116	0.000147	0.000026	0.000414	0.000254	0.001052	0.001795	0.000893	0.000125	0.000011	0.000052	0.000068	0.000020	0.000254	0.000239	0.000380	0.000539	0.000163	0.000057	0.000059	0.000538	0.000262	0.000181	0.000588	0.000055	0.000058	0.000297	0.000816	0.000030	0.000077	0.001608	0.001396	0.000111	0.000688	0.000138	0.000205	0.000652	0.001587	0.000097	0.000339	0.000223	0.000215	0.001383	0.000055	0.000052	0.000037	0.106526	0.000423	0.000673	0.000185	0.000151	0.000993	0.001793	0.000543	0.000364	0.000118	0.000620	0.000082	0.000036	0.000087	0.000135	0.000036	0.000070	0.002044	0.000224	0.000157	0.000363	0.000011	0.000135	0.000049	0.006437	0.002069	0.001582	0.000265	0.000034	0.000044	0.000418	0.000027	0.000278	0.000085	0.002000	0.000061	0.000149	0.000904	0.002251	0.009525	0.000059	0.000164	0.000159	0.010938	0.005939	0.004252	0.004155	0.005799	0.005219	0.020776	0.002921	0.000490	0.001846	0.001682	0.001383	0.004542	0.000178	0.000290	0.003715	0.000488	0.000542	0.005661	0.000170	0.000507	0.000098	0.011346	0.000110	0.000472	0.001916	0.000032
176049748 - DE-TÜ - Off My Chest - Shallow Waters	176049748	0.013371	0.000212	0.000217	0.000529	0.000071	0.000145	0.000105	0.000047	0.000216	0.000086	0.000146	0.000044	0.000079	0.000054	0.000186	0.000118	0.000150	0.000046	0.000071	0.000044	0.000043	0.000040	0.000136	0.000233	0.000236	0.000054	0.000106	0.004115	0.000215	0.000146	0.000134	0.000231	0.000307	0.000547	0.000232	0.000414	0.003534	0.000596	0.000212	0.000012	0.000189	0.000288	0.000079	0.000142	0.000103	0.000054	0.000236	0.000092	0.000092	0.000137	0.000081	0.000086	0.000054	0.000161	0.000212	0.000154	0.000012	0.000060	0.000055	0.000110	0.000092	0.000118	0.000033	0.000059	0.000854	0.001128	0.000131	0.000022	0.000072	0.000529	0.000142	0.000050	0.002194	0.001215	0.000853	0.000157	0.000230	0.000637	0.000251	0.000086	0.000180	0.000280	0.000046	0.000190	0.001156	0.000055	0.000297	0.000110	0.000081	0.000024	0.000110	0.000102	0.000114	0.000033	0.000102	0.000105	0.000285	0.000252	0.000248	0.000236	0.000100	0.000156	0.000057	0.000049	0.000057	0.000090	0.000045	0.000045	0.000030	0.000021	0.000074	0.000595	0.000291	0.000226	0.000004	0.000147	0.000115	0.000093	0.000110	0.000145	0.000045	0.000015	0.000283	0.000161	0.000416	0.000097	0.000824	0.000385	0.000168	0.000245	0.000724	0.000172	0.000185	0.000048	0.000633	0.001952	0.001415	0.757513	0.052514	0.006845	0.007863	0.001405	0.001929	0.001077	0.000475	0.000232	0.000866	0.000130	0.000166	0.000132	0.000401	0.000247	0.008295	0.006472	0.004854	0.001041	0.000825	0.000597	0.050026	0.022921	0.000142	0.005614	0.007532	0.072032	0.013207	0.002218	0.001581	0.000684	0.005191	0.001256	0.000174	0.001606	0.001328	0.000800	0.000396	0.000648	0.000329	0.010834	0.000827	0.004166	0.004779	0.004903	0.001392	0.000270	0.000649	0.000898	0.000325	0.000292	0.000276	0.001007	0.000093	0.000937	0.000932	0.000290	0.000299	0.001317	0.001220	0.000322	0.000231	0.001168	0.000643	0.000236	0.000469	0.000123	0.000665	0.002235	0.000672	0.000046	0.000291	0.000139	0.000103	0.000620	0.000430	0.009051	0.008512	0.004210	0.003215	0.046426	0.000159	0.001769	0.000722	0.000500	0.000211	0.000592	0.000338	0.000299	0.005864	0.003412	0.002675	0.000341	0.000311	0.000104	0.001672	0.000391	0.000907	0.002002	0.001032	0.000954	0.000104	0.160505	0.006573	0.003749	0.037518	0.046530	0.017348	0.003684	0.154107	0.002114	0.000327	0.000153	0.000107	0.001749	0.000254	0.003200	0.000205	0.000063	0.000985	0.000790	0.000660	0.000366	0.000649	0.000150	0.000186	0.000137	0.000387	0.001870	0.001908	0.002462	0.001376	0.000610	0.006508	0.001778	0.000355	0.000567	0.001182	0.000140	0.000361	0.000197	0.000594	0.002124	0.001221	0.000205	0.000432	0.000172	0.000249	0.000154	0.000063	0.000074	0.000665	0.000096	0.000111	0.000096	0.000177	0.000108	0.000134	0.000091	0.000709	0.000356	0.000146	0.000296	0.002644	0.000289	0.000069	0.000131	0.000116	0.000040	0.000271	0.001056	0.000429	0.000122	0.000077	0.000059	0.000048	0.000085	0.000183	0.000219	0.000164	0.000069	0.000143	0.000029	0.000320	0.000073	0.000292	0.000177	0.000130	0.000106	0.000120	0.000097	0.000404	0.000539	0.000211	0.000238	0.000338	0.000024	0.000090	0.000226	0.000044	0.000087	0.000066	0.000099	0.000165	0.000924	0.000751	0.000368	0.000026	0.000040	0.000066	0.000074	0.000118	0.000083	0.000040	0.000079	0.000094	0.000196	0.000588	0.000131	0.001711	0.000333	0.000283	0.000264	0.000350	0.000183	0.000025	0.000136	0.000354	0.000182	0.000065	0.000209	0.000286	0.000065	0.000425	0.000259	0.000101	0.000068	0.000160	0.000016	0.000054	0.000187	0.000116	0.001955	0.000343	0.000665	0.000436	0.000054	0.000128	0.000097	0.000173	0.000204	0.000577	0.000304	0.000148	0.001430	0.000148	0.001168	0.001029	0.000675	0.001015	0.000292	0.000793	0.000833	0.000360	0.000148	0.000584	0.000372	0.000441	0.000261	0.002037	0.003506	0.002937	0.000203	0.000041	0.000103	0.000121	0.000049	0.000072	0.000243	0.000223	0.000370	0.000890	0.000369	0.000031	0.000109	0.000116	0.000072	0.000278	0.000217	0.000448	0.000399	0.000197	0.000059	0.000054	0.000299	0.000153	0.000132	0.000546	0.000071	0.000048	0.000519	0.002057	0.000057	0.000042	0.001064	0.001255	0.000112	0.000621	0.000049	0.000100	0.000885	0.001722	0.000041	0.000350	0.000457	0.000365	0.002587	0.000129	0.000139	0.000111	0.033394	0.000792	0.001462	0.000163	0.000175	0.002857	0.009521	0.002524	0.000532	0.000066	0.000291	0.000165	0.000106	0.000117	0.000121	0.000082	0.000085	0.001721	0.000262	0.000323	0.000369	0.000014	0.000078	0.000031	0.001230	0.001548	0.000954	0.000278	0.000035	0.000039	0.000994	0.000035	0.000599	0.000273	0.000420	0.000078	0.000595	0.000256	0.000763	0.021607	0.000212	0.000082	0.000059	0.013594	0.010776	0.004013	0.004149	0.008542	0.003569	0.011853	0.004616	0.000955	0.001572	0.001731	0.011910	0.012943	0.001223	0.000266	0.011767	0.001450	0.002568	0.001833	0.000426	0.002553	0.000203	0.016444	0.000413	0.000993	0.001610	0.000061
176049749 - DE-TÜ - Off My Chest - When Will We	176049749	0.011212	0.000312	0.000146	0.000229	0.000068	0.000211	0.000049	0.000095	0.000144	0.000076	0.000081	0.000034	0.000058	0.000032	0.000121	0.000112	0.000168	0.000038	0.000053	0.000069	0.000038	0.000048	0.000097	0.000137	0.000176	0.000026	0.000086	0.001296	0.000162	0.000095	0.000077	0.000161	0.000134	0.000189	0.000055	0.000097	0.001652	0.000261	0.000190	0.000034	0.000154	0.000245	0.000092	0.000201	0.000101	0.000026	0.000224	0.000143	0.000096	0.000139	0.000137	0.000061	0.000017	0.000136	0.000320	0.000128	0.000006	0.000099	0.000152	0.000129	0.000165	0.000061	0.000040	0.000158	0.000542	0.001852	0.000089	0.000039	0.000031	0.000320	0.000049	0.000016	0.002197	0.000992	0.000727	0.000194	0.000222	0.000500	0.000230	0.000107	0.000192	0.000237	0.000091	0.000128	0.000391	0.000051	0.000172	0.000126	0.000105	0.000034	0.000056	0.000049	0.000066	0.000053	0.000097	0.000104	0.000230	0.000185	0.000566	0.000266	0.000130	0.000127	0.000191	0.000167	0.000141	0.000145	0.000168	0.000168	0.000068	0.000041	0.000106	0.000960	0.000394	0.000320	0.000005	0.000118	0.000096	0.000226	0.000215	0.000166	0.000058	0.000009	0.000217	0.000123	0.000251	0.000069	0.000505	0.000177	0.000148	0.000173	0.000895	0.000090	0.000619	0.000156	0.000183	0.001246	0.000120	0.840742	0.081736	0.002418	0.002848	0.000510	0.000684	0.000464	0.000115	0.000111	0.000400	0.000116	0.000111	0.000138	0.000135	0.000087	0.005435	0.003729	0.001752	0.000452	0.000263	0.000247	0.046409	0.090294	0.000105	0.003692	0.009892	0.293589	0.020437	0.002280	0.001859	0.000631	0.007902	0.000157	0.000129	0.000993	0.000917	0.000546	0.000095	0.000062	0.000047	0.000249	0.000073	0.000297	0.000509	0.000359	0.000184	0.000020	0.000507	0.001264	0.000589	0.000536	0.000206	0.000881	0.000077	0.001677	0.000421	0.000354	0.000235	0.005458	0.005903	0.000383	0.000839	0.000237	0.000139	0.000128	0.000051	0.000016	0.000147	0.000203	0.000129	0.000024	0.000311	0.000103	0.000113	0.000851	0.001900	0.003695	0.001392	0.008181	0.003578	0.053507	0.000482	0.002033	0.000656	0.000567	0.000198	0.000530	0.000478	0.000144	0.004202	0.001567	0.001542	0.000261	0.000147	0.000092	0.002856	0.000328	0.000902	0.001605	0.003462	0.001401	0.000164	0.289815	0.019148	0.017505	0.070242	0.168926	0.049575	0.010132	0.009985	0.005700	0.000170	0.000061	0.000059	0.001216	0.000065	0.000980	0.000310	0.000058	0.000514	0.000863	0.000213	0.000252	0.000185	0.000196	0.000105	0.000087	0.000337	0.000907	0.001010	0.001363	0.001520	0.000211	0.003633	0.000708	0.000246	0.000124	0.002388	0.000078	0.000237	0.000181	0.000458	0.001035	0.001924	0.000066	0.000079	0.000172	0.000105	0.000159	0.000035	0.000043	0.000446	0.000074	0.000095	0.000068	0.000124	0.000046	0.000075	0.000054	0.000213	0.000259	0.000119	0.000225	0.002267	0.000264	0.000045	0.000144	0.000094	0.000034	0.000269	0.000788	0.000444	0.000159	0.000140	0.000034	0.000062	0.000090	0.000120	0.000151	0.000199	0.000054	0.000213	0.000036	0.000041	0.000047	0.000480	0.000250	0.000241	0.000173	0.000198	0.000066	0.000190	0.000228	0.000114	0.000100	0.000168	0.000007	0.000030	0.000168	0.000030	0.000045	0.000062	0.000079	0.000108	0.000258	0.000127	0.000219	0.000023	0.000027	0.000068	0.000084	0.000078	0.000051	0.000016	0.000077	0.000055	0.000161	0.000267	0.000051	0.000171	0.000152	0.000156	0.000111	0.000232	0.000060	0.000006	0.000059	0.000165	0.000081	0.000071	0.000109	0.000054	0.000046	0.000199	0.000138	0.000051	0.000034	0.000065	0.000017	0.000072	0.000054	0.000113	0.000457	0.000108	0.000165	0.000658	0.000066	0.000170	0.000063	0.000245	0.000115	0.000393	0.000678	0.000190	0.002084	0.000547	0.002807	0.002170	0.000258	0.001490	0.000349	0.000845	0.000433	0.000561	0.000254	0.001276	0.000134	0.000206	0.000104	0.000368	0.000793	0.000580	0.000078	0.000016	0.000045	0.000050	0.000011	0.000052	0.000083	0.000146	0.000347	0.000411	0.000065	0.000014	0.000053	0.000062	0.000014	0.000135	0.000091	0.000310	0.000460	0.000169	0.000044	0.000041	0.000458	0.000128	0.000081	0.000464	0.000048	0.000039	0.000363	0.003043	0.000032	0.000102	0.000335	0.000253	0.000047	0.000607	0.000031	0.000108	0.000474	0.002340	0.000062	0.000232	0.000157	0.000248	0.000883	0.000071	0.000052	0.000044	0.001868	0.000203	0.000535	0.000080	0.000065	0.000939	0.002728	0.000881	0.000152	0.000049	0.000265	0.000081	0.000045	0.000097	0.000218	0.000051	0.000087	0.001237	0.000430	0.000144	0.000767	0.000039	0.000067	0.000040	0.000659	0.000291	0.000102	0.000060	0.000008	0.000015	0.000611	0.000031	0.000514	0.000120	0.000470	0.000046	0.000139	0.000344	0.000072	0.011549	0.000337	0.000084	0.000102	0.005602	0.003677	0.001785	0.001282	0.009986	0.014350	0.007312	0.002155	0.000337	0.000943	0.001815	0.001571	0.005822	0.000263	0.000170	0.014765	0.001032	0.000827	0.002070	0.000260	0.000506	0.000051	0.008272	0.000184	0.000369	0.000562	0.000038
176049750 - DE-TÜ - Off My Chest - Tides	176049750	0.013598	0.000320	0.000361	0.000666	0.000135	0.000286	0.000101	0.000124	0.000103	0.000055	0.000092	0.000028	0.000051	0.000034	0.000186	0.000419	0.000425	0.000130	0.000183	0.000141	0.000131	0.000137	0.000130	0.000136	0.000185	0.000058	0.000069	0.001542	0.000151	0.000068	0.000042	0.000059	0.000155	0.000240	0.000115	0.000111	0.001360	0.000056	0.000120	0.000021	0.000189	0.000237	0.000032	0.000092	0.000078	0.000083	0.000176	0.000129	0.000111	0.000186	0.000083	0.000059	0.000036	0.000106	0.000643	0.000458	0.000050	0.000189	0.000267	0.000156	0.000252	0.000240	0.000100	0.000233	0.000425	0.000874	0.000076	0.000045	0.000069	0.000349	0.000109	0.000047	0.002040	0.001420	0.001023	0.000294	0.000237	0.000272	0.000389	0.000095	0.000194	0.000441	0.000137	0.000295	0.000298	0.000084	0.000247	0.000165	0.000154	0.000050	0.000078	0.000077	0.001348	0.000120	0.000315	0.000110	0.000168	0.000154	0.000498	0.000389	0.000210	0.000336	0.000123	0.000117	0.000094	0.000149	0.000072	0.000069	0.000058	0.000055	0.000132	0.000854	0.000403	0.000378	0.000013	0.000173	0.000131	0.000071	0.000071	0.000150	0.000075	0.000046	0.000265	0.000131	0.000206	0.000211	0.000928	0.000347	0.000210	0.000359	0.000477	0.000168	0.000395	0.000210	0.000135	0.002173	0.000082	0.807882	0.104770	0.004108	0.004250	0.000852	0.000944	0.000593	0.000153	0.000157	0.000510	0.000247	0.000203	0.000311	0.000317	0.000277	0.034216	0.030779	0.019951	0.001527	0.001242	0.000570	0.149290	0.086977	0.000745	0.012613	0.013971	0.220758	0.026059	0.004360	0.002749	0.001307	0.009919	0.000514	0.000431	0.002573	0.002292	0.003493	0.000215	0.000420	0.000285	0.001515	0.001678	0.005989	0.008800	0.007952	0.002008	0.000456	0.000701	0.000867	0.000285	0.000610	0.000217	0.001120	0.000079	0.001398	0.001060	0.000289	0.000198	0.001260	0.000756	0.000379	0.000622	0.001667	0.000505	0.000230	0.000310	0.000093	0.000161	0.001735	0.001074	0.000088	0.000482	0.000481	0.000193	0.000250	0.000226	0.001249	0.001848	0.003692	0.005720	0.029360	0.000447	0.002036	0.000640	0.000495	0.000191	0.000596	0.000405	0.000138	0.005545	0.002186	0.003305	0.000578	0.000517	0.000208	0.004437	0.000358	0.000875	0.003001	0.003540	0.001619	0.000095	0.221037	0.026253	0.018530	0.071179	0.107183	0.072707	0.013988	0.019271	0.010173	0.000488	0.000373	0.000111	0.001537	0.000899	0.002444	0.000313	0.000065	0.002051	0.002303	0.000744	0.000634	0.000428	0.000124	0.000154	0.000255	0.000335	0.001927	0.000661	0.004491	0.003190	0.001387	0.009019	0.000621	0.002641	0.000480	0.003715	0.000138	0.001267	0.001273	0.000418	0.002168	0.003769	0.000059	0.000130	0.000189	0.000121	0.000159	0.000086	0.000109	0.000749	0.000116	0.000119	0.000091	0.000127	0.000050	0.000111	0.000089	0.000219	0.000487	0.000106	0.000396	0.002706	0.000344	0.000075	0.000144	0.000159	0.000031	0.000223	0.000977	0.000544	0.000179	0.000196	0.000041	0.000043	0.000062	0.000132	0.000132	0.000181	0.000065	0.000162	0.000029	0.000315	0.000074	0.000277	0.000226	0.000135	0.000088	0.000222	0.000075	0.000266	0.000361	0.000141	0.000138	0.000239	0.000007	0.000051	0.000116	0.000021	0.000031	0.000044	0.000051	0.000081	0.000435	0.000218	0.000309	0.000012	0.000018	0.000053	0.000062	0.000136	0.000081	0.000025	0.000116	0.000094	0.000240	0.000267	0.000195	0.002131	0.000152	0.000116	0.000219	0.000364	0.000176	0.000020	0.000113	0.000555	0.000259	0.000133	0.000137	0.000126	0.000071	0.000351	0.000259	0.000166	0.000040	0.000160	0.000074	0.000055	0.000131	0.000350	0.001224	0.000211	0.000303	0.000320	0.000240	0.000403	0.000154	0.000550	0.000260	0.000785	0.001111	0.000333	0.028180	0.000367	0.001372	0.001152	0.000977	0.000578	0.000095	0.000708	0.000617	0.000381	0.000054	0.000434	0.000157	0.000696	0.000336	0.001104	0.001616	0.001536	0.000359	0.000045	0.000112	0.000091	0.000028	0.000122	0.000267	0.000357	0.000744	0.000430	0.000119	0.000030	0.000066	0.000133	0.000084	0.000108	0.000103	0.000225	0.000225	0.000110	0.000041	0.000027	0.000197	0.000201	0.000111	0.000424	0.000075	0.000052	0.000386	0.000827	0.000062	0.000084	0.001471	0.001368	0.000067	0.000904	0.000061	0.000145	0.001516	0.003345	0.000106	0.000261	0.000214	0.000452	0.001998	0.000079	0.000174	0.000055	0.001474	0.000088	0.000613	0.000093	0.000084	0.001571	0.005257	0.001373	0.000125	0.000049	0.000340	0.000086	0.000075	0.000132	0.000089	0.000124	0.000088	0.001332	0.000404	0.000271	0.000644	0.000103	0.000367	0.000165	0.001168	0.000605	0.000557	0.000174	0.000015	0.000062	0.000859	0.000053	0.000703	0.000168	0.000412	0.000079	0.000175	0.001145	0.000972	0.003833	0.000697	0.000237	0.000382	0.008392	0.002040	0.004189	0.001264	0.009614	0.002154	0.007433	0.002009	0.000400	0.001186	0.000868	0.002139	0.005162	0.000190	0.000140	0.003967	0.000415	0.001512	0.000622	0.000544	0.000383	0.000081	0.003749	0.000202	0.000630	0.000184	0.000044
58080501 - Jamie xx - In Colour - Gosh	58080501	0.119381	0.000843	0.000628	0.002162	0.000231	0.000446	0.000312	0.000102	0.000479	0.000476	0.000708	0.000255	0.000161	0.000090	0.001370	0.000361	0.003056	0.000546	0.000677	0.001008	0.000829	0.000522	0.000712	0.000719	0.000877	0.000174	0.000173	0.005235	0.000271	0.000240	0.000149	0.000182	0.000280	0.000387	0.000289	0.000463	0.006691	0.000191	0.000390	0.000044	0.000690	0.000965	0.000114	0.000107	0.000268	0.000321	0.000212	0.000708	0.000344	0.000537	0.000141	0.000490	0.000335	0.000659	0.000518	0.000443	0.000068	0.000220	0.000170	0.000468	0.000298	0.000192	0.000027	0.000214	0.001333	0.000678	0.000324	0.000109	0.000338	0.001645	0.000350	0.000167	0.011195	0.009268	0.007495	0.003162	0.001728	0.002120	0.003617	0.000661	0.001067	0.001347	0.000187	0.000802	0.000521	0.000251	0.001573	0.000564	0.000418	0.000276	0.000316	0.000309	0.000202	0.000332	0.000608	0.000439	0.000734	0.000667	0.003694	0.002504	0.001200	0.001281	0.000466	0.000442	0.000882	0.001325	0.001441	0.001429	0.000190	0.000144	0.000296	0.002629	0.000857	0.000499	0.000280	0.000511	0.000352	0.000406	0.000397	0.000571	0.000332	0.000065	0.002205	0.000226	0.000192	0.000164	0.000940	0.000242	0.000157	0.000475	0.001006	0.000367	0.000500	0.000230	0.000120	0.001981	0.000410	0.624234	0.023635	0.002527	0.002647	0.000887	0.000598	0.000456	0.000308	0.000179	0.000595	0.000229	0.000343	0.000183	0.000255	0.000320	0.004669	0.003439	0.002481	0.001422	0.000942	0.000653	0.008276	0.038866	0.000448	0.010931	0.015671	0.031949	0.020452	0.008502	0.007931	0.003753	0.015990	0.019334	0.000227	0.002774	0.002748	0.002290	0.000688	0.000564	0.000818	0.001089	0.000243	0.000620	0.000956	0.000659	0.000567	0.000240	0.002142	0.002772	0.000837	0.001235	0.000748	0.001061	0.000208	0.001964	0.000508	0.000475	0.000418	0.007132	0.006891	0.000762	0.000796	0.000197	0.000311	0.000159	0.000571	0.000023	0.000039	0.000116	0.000042	0.000029	0.000825	0.000475	0.000628	0.003447	0.001318	0.007839	0.000430	0.013568	0.007338	0.039348	0.001805	0.006357	0.002310	0.002682	0.001606	0.004385	0.003245	0.003004	0.006126	0.004397	0.006688	0.000722	0.002629	0.000241	0.010374	0.000916	0.001293	0.004343	0.007485	0.001560	0.000383	0.067231	0.014767	0.014523	0.009223	0.050441	0.026999	0.007832	0.021083	0.004525	0.000609	0.000353	0.000153	0.003569	0.000550	0.002499	0.000708	0.000091	0.001460	0.001618	0.000438	0.000358	0.001341	0.000192	0.001091	0.001115	0.000671	0.004348	0.003017	0.007067	0.008791	0.001464	0.015232	0.000262	0.002181	0.000486	0.005263	0.000138	0.000944	0.001864	0.000851	0.001964	0.005956	0.002451	0.002949	0.000281	0.000333	0.000259	0.000170	0.000242	0.000667	0.000310	0.000244	0.000287	0.000320	0.000137	0.000246	0.000185	0.000471	0.000513	0.000132	0.000321	0.005638	0.000733	0.000191	0.000356	0.000244	0.000209	0.000337	0.001701	0.000982	0.000435	0.000137	0.000052	0.000152	0.000144	0.000286	0.000339	0.000327	0.000095	0.000384	0.000058	0.000097	0.000161	0.000381	0.000323	0.000195	0.000111	0.000254	0.000099	0.000690	0.000924	0.000274	0.000270	0.000544	0.000018	0.000125	0.000257	0.000059	0.000058	0.000057	0.000106	0.000190	0.001423	0.003216	0.000452	0.000028	0.000021	0.000072	0.000024	0.000162	0.000128	0.000061	0.000104	0.000153	0.000249	0.000938	0.000139	0.000268	0.000397	0.000365	0.000212	0.000777	0.000350	0.000087	0.000134	0.000433	0.000207	0.000044	0.000202	0.000428	0.000104	0.000303	0.000204	0.000291	0.000111	0.000166	0.000082	0.000079	0.000103	0.000485	0.000825	0.000121	0.000185	0.000715	0.000119	0.000191	0.000194	0.000186	0.000261	0.000356	0.000471	0.000174	0.000811	0.000211	0.000203	0.000238	0.000346	0.001280	0.000414	0.000676	0.000282	0.000346	0.000547	0.002786	0.000437	0.000474	0.000184	0.000440	0.001078	0.001191	0.000143	0.000032	0.000173	0.000203	0.000037	0.000082	0.000303	0.000190	0.000339	0.000566	0.000180	0.000022	0.000090	0.000256	0.000023	0.000203	0.000258	0.000335	0.000743	0.000247	0.000178	0.000181	0.000303	0.000208	0.000113	0.000858	0.000160	0.000076	0.000264	0.000281	0.000011	0.000020	0.000146	0.000153	0.000050	0.000396	0.000225	0.000165	0.000432	0.000704	0.000058	0.000473	0.000147	0.000162	0.001551	0.000084	0.000123	0.000065	0.000879	0.000321	0.001137	0.001049	0.000214	0.000169	0.000530	0.000126	0.000635	0.000257	0.000400	0.000170	0.000083	0.000044	0.000480	0.000227	0.000105	0.011592	0.000460	0.000355	0.002970	0.000013	0.000122	0.000076	0.001226	0.000744	0.000273	0.000095	0.000094	0.000118	0.001717	0.000091	0.001200	0.000265	0.000109	0.000126	0.000964	0.000129	0.000268	0.040818	0.000132	0.000159	0.000211	0.003573	0.000396	0.001213	0.000083	0.014148	0.002124	0.010639	0.008883	0.002037	0.003130	0.002894	0.001116	0.003830	0.000205	0.000231	0.013407	0.004037	0.000271	0.000730	0.001045	0.001377	0.000186	0.070768	0.000408	0.001995	0.001235	0.000381
58080502 - Jamie xx - In Colour - Sleep Sound	58080502	0.042537	0.000567	0.000446	0.000620	0.000154	0.000416	0.000113	0.000181	0.000240	0.000133	0.000217	0.000092	0.000047	0.000023	0.000155	0.000197	0.000332	0.000104	0.000110	0.000146	0.000100	0.000113	0.000119	0.000175	0.000172	0.000072	0.000170	0.007056	0.000440	0.000244	0.000420	0.000553	0.000657	0.000562	0.000286	0.000356	0.004310	0.000404	0.000329	0.000025	0.000115	0.000252	0.000045	0.000114	0.000185	0.000093	0.000268	0.000262	0.000245	0.000161	0.000121	0.000168	0.000107	0.000230	0.000231	0.000144	0.000066	0.000137	0.000115	0.000146	0.000098	0.000141	0.000067	0.000138	0.000984	0.001685	0.000096	0.000028	0.000092	0.000442	0.000135	0.000030	0.003377	0.002187	0.001505	0.000305	0.000383	0.000309	0.000530	0.000122	0.000344	0.000588	0.000085	0.000333	0.000204	0.000125	0.000423	0.000225	0.000217	0.000071	0.000151	0.000140	0.000497	0.000082	0.000255	0.000155	0.000447	0.000351	0.000533	0.000392	0.000236	0.000207	0.000152	0.000154	0.000249	0.000420	0.000107	0.000096	0.000100	0.000090	0.000176	0.000891	0.000384	0.000418	0.000021	0.000202	0.000179	0.000103	0.000083	0.000174	0.000089	0.000017	0.000379	0.000195	0.000328	0.000145	0.000568	0.000215	0.000070	0.000225	0.000295	0.000190	0.000160	0.000067	0.000122	0.000523	0.000445	0.711718	0.041928	0.004033	0.005225	0.000902	0.001161	0.000610	0.000295	0.000189	0.000503	0.000387	0.000276	0.000336	0.000504	0.000410	0.018703	0.014293	0.011483	0.001786	0.002227	0.000719	0.111851	0.058426	0.000903	0.008276	0.006084	0.118889	0.009826	0.002517	0.001842	0.000892	0.003970	0.001220	0.000186	0.001179	0.001091	0.002086	0.000099	0.000142	0.000163	0.007173	0.002928	0.018869	0.026581	0.022157	0.009264	0.000524	0.000671	0.000523	0.000208	0.000162	0.000181	0.000767	0.000086	0.000546	0.001029	0.000258	0.000214	0.000586	0.000515	0.000238	0.000166	0.000921	0.000609	0.000223	0.000277	0.000052	0.000283	0.002378	0.000751	0.000037	0.000177	0.000208	0.000027	0.000897	0.000136	0.007324	0.012306	0.007320	0.006274	0.034663	0.001011	0.002073	0.000433	0.000713	0.000414	0.000717	0.000761	0.000429	0.004431	0.002908	0.005184	0.000897	0.000581	0.000346	0.005298	0.000294	0.000736	0.001858	0.003685	0.000786	0.000152	0.096702	0.018916	0.015102	0.008157	0.012998	0.043003	0.005530	0.093361	0.007741	0.000473	0.000178	0.000130	0.001520	0.001093	0.007767	0.001043	0.000270	0.002353	0.003542	0.000525	0.000467	0.000740	0.000126	0.000301	0.000408	0.000239	0.003389	0.001661	0.004129	0.002002	0.001153	0.007622	0.000990	0.001527	0.000435	0.002699	0.000087	0.000925	0.001118	0.000283	0.002304	0.002271	0.000092	0.000399	0.000213	0.000255	0.000195	0.000099	0.000117	0.000403	0.000126	0.000136	0.000116	0.000180	0.000095	0.000131	0.000102	0.000138	0.000479	0.000073	0.000194	0.003061	0.000414	0.000097	0.000223	0.000155	0.000080	0.000188	0.000944	0.000466	0.000170	0.000066	0.000036	0.000074	0.000093	0.000121	0.000167	0.000171	0.000048	0.000180	0.000034	0.000159	0.000112	0.000178	0.000154	0.000101	0.000072	0.000220	0.000069	0.000355	0.000527	0.000123	0.000202	0.000308	0.000014	0.000133	0.000188	0.000042	0.000048	0.000045	0.000071	0.000132	0.000706	0.000747	0.000288	0.000037	0.000011	0.000061	0.000046	0.000122	0.000074	0.000022	0.000085	0.000101	0.000219	0.000447	0.000520	0.003704	0.000215	0.000189	0.000156	0.000316	0.000079	0.000035	0.000054	0.000254	0.000117	0.000039	0.000082	0.000224	0.000098	0.000164	0.000131	0.000121	0.000075	0.000124	0.000037	0.000063	0.000082	0.000155	0.000473	0.000041	0.000111	0.000445	0.000107	0.000281	0.000118	0.000364	0.000239	0.000428	0.000912	0.000364	0.008291	0.000448	0.000882	0.001061	0.000380	0.000590	0.000174	0.000690	0.000383	0.000144	0.000242	0.000130	0.000099	0.000183	0.000076	0.000353	0.001058	0.001092	0.000072	0.000014	0.000110	0.000136	0.000075	0.000104	0.000260	0.000253	0.000409	0.000406	0.000091	0.000018	0.000059	0.000084	0.000026	0.000133	0.000122	0.000267	0.000282	0.000104	0.000049	0.000039	0.000150	0.000062	0.000052	0.000568	0.000085	0.000042	0.000217	0.000336	0.000013	0.000048	0.000560	0.001044	0.000039	0.000484	0.000051	0.000088	0.000762	0.001183	0.000038	0.000303	0.000139	0.000220	0.000684	0.000088	0.000061	0.000057	0.004820	0.000166	0.000584	0.000174	0.000160	0.001140	0.008612	0.002427	0.000670	0.000082	0.000307	0.000119	0.000072	0.000047	0.000166	0.000049	0.000080	0.003985	0.000360	0.000187	0.000726	0.000011	0.000071	0.000032	0.001054	0.001756	0.000919	0.000189	0.000022	0.000016	0.000601	0.000028	0.000476	0.000095	0.000194	0.000074	0.000264	0.000524	0.001238	0.013032	0.000237	0.000293	0.000097	0.004073	0.001512	0.009195	0.000744	0.010519	0.000391	0.010894	0.005780	0.001136	0.002330	0.002150	0.004272	0.014122	0.000157	0.000138	0.004340	0.001322	0.002117	0.005249	0.000645	0.000524	0.000092	0.015139	0.000240	0.000765	0.000528	0.000060
58080505 - Jamie xx - In Colour - Just Saying	58080505	0.033979	0.000375	0.000252	0.000536	0.000048	0.000208	0.000088	0.000099	0.000044	0.000052	0.000054	0.000029	0.000075	0.000014	0.000060	0.000389	0.000266	0.000111	0.000065	0.000091	0.000093	0.000087	0.000119	0.000133	0.000099	0.000043	0.000121	0.002512	0.001444	0.000021	0.000781	0.001777	0.000175	0.000365	0.000204	0.000119	0.000130	0.000133	0.000144	0.000026	0.000467	0.000737	0.000128	0.000366	0.000155	0.000079	0.000701	0.000098	0.000092	0.000555	0.000164	0.000069	0.000169	0.000204	0.000141	0.000091	0.000015	0.000095	0.000100	0.000278	0.000267	0.000206	0.000110	0.000112	0.000145	0.000108	0.000046	0.000067	0.000029	0.000237	0.000070	0.000025	0.003276	0.002011	0.001325	0.000281	0.000308	0.000141	0.000387	0.000143	0.000283	0.000557	0.000092	0.000293	0.000933	0.000093	0.000420	0.000155	0.000161	0.000047	0.000143	0.000146	0.000022	0.000059	0.000101	0.000180	0.000261	0.000306	0.000416	0.000369	0.000188	0.000171	0.000100	0.000086	0.000220	0.000266	0.000081	0.000094	0.000110	0.000103	0.000125	0.001075	0.000457	0.000450	0.000028	0.000259	0.000199	0.000296	0.000251	0.000183	0.000083	0.000037	0.000295	0.000203	0.000187	0.000114	0.000657	0.000217	0.000170	0.000284	0.000144	0.000189	0.000193	0.000106	0.000566	0.000155	0.001283	0.633723	0.045829	0.002563	0.004506	0.000622	0.000511	0.000528	0.000172	0.000047	0.000403	0.000024	0.000057	0.000044	0.000164	0.000093	0.016786	0.014538	0.004626	0.002064	0.001057	0.000749	0.022252	0.002951	0.000490	0.003752	0.000826	0.000234	0.001185	0.000281	0.000153	0.000152	0.000318	0.001189	0.000027	0.000371	0.000192	0.000189	0.000096	0.000045	0.000080	0.095680	0.004046	0.002770	0.003676	0.002910	0.001160	0.000283	0.002754	0.001448	0.000379	0.000281	0.000460	0.000898	0.000080	0.000660	0.000325	0.000579	0.000369	0.001005	0.001118	0.000384	0.000454	0.000973	0.001853	0.000793	0.000136	0.000027	0.002444	0.000831	0.000128	0.000025	0.000334	0.000328	0.000014	0.001197	0.000296	0.007938	0.125742	0.000207	0.000522	0.000524	0.000256	0.000730	0.000409	0.000167	0.000129	0.000373	0.000139	0.000183	0.000438	0.000789	0.000095	0.000141	0.000107	0.000032	0.000190	0.000115	0.000196	0.000654	0.000201	0.004238	0.000261	0.063253	0.001109	0.001743	0.001300	0.001744	0.006102	0.000717	0.394909	0.004910	0.000145	0.000040	0.000097	0.000332	0.000185	0.028491	0.000783	0.000219	0.000151	0.000085	0.000767	0.000454	0.000353	0.000077	0.000043	0.000054	0.000227	0.000887	0.000383	0.005290	0.001473	0.000320	0.021376	0.001594	0.001519	0.000438	0.000268	0.000326	0.000231	0.000133	0.001279	0.002455	0.000356	0.000282	0.004994	0.000332	0.000594	0.000293	0.000140	0.000185	0.000517	0.000152	0.000072	0.000119	0.000107	0.000123	0.000385	0.000246	0.000508	0.000260	0.000109	0.000205	0.002389	0.000256	0.000083	0.000079	0.000080	0.000066	0.000133	0.000646	0.000934	0.000188	0.000062	0.000030	0.000085	0.000087	0.000150	0.000189	0.000131	0.000056	0.000214	0.000021	0.000027	0.000059	0.000096	0.000059	0.000042	0.000039	0.000119	0.000106	0.000339	0.000491	0.000211	0.000230	0.000299	0.000008	0.000134	0.000227	0.000066	0.000024	0.000052	0.000069	0.000144	0.000283	0.000185	0.000214	0.000029	0.000013	0.000026	0.000035	0.000086	0.000064	0.000013	0.000060	0.000065	0.000211	0.000598	0.000100	0.000853	0.000343	0.000326	0.000064	0.000232	0.000228	0.000069	0.000266	0.000336	0.000143	0.000035	0.000106	0.000155	0.000057	0.000109	0.000079	0.000099	0.000074	0.000104	0.000042	0.000033	0.000084	0.000140	0.000310	0.000088	0.000136	0.000149	0.000168	0.000101	0.000049	0.000108	0.000279	0.000122	0.000194	0.000079	0.000163	0.000150	0.000115	0.000155	0.000074	0.000317	0.000113	0.000137	0.000107	0.000081	0.000335	0.000376	0.000351	0.000184	0.000084	0.000185	0.000531	0.000664	0.000065	0.000021	0.000065	0.000277	0.000061	0.000074	0.000120	0.000126	0.000268	0.000402	0.000168	0.000009	0.000067	0.000184	0.000165	0.000120	0.000114	0.000508	0.000606	0.000188	0.000138	0.000134	0.000339	0.000115	0.000134	0.000383	0.000168	0.000097	0.000324	0.000063	0.000010	0.000100	0.000649	0.000327	0.000027	0.000203	0.000053	0.000084	0.000179	0.000185	0.000012	0.000080	0.000080	0.000069	0.000446	0.000020	0.000061	0.000036	0.009646	0.000481	0.001185	0.000254	0.000128	0.000923	0.006873	0.001113	0.000136	0.000070	0.000342	0.000183	0.000139	0.000092	0.000098	0.000453	0.000112	0.000195	0.000300	0.000514	0.000083	0.000018	0.000054	0.000045	0.000297	0.002342	0.000417	0.000343	0.000014	0.000049	0.000665	0.000025	0.000259	0.000158	0.000318	0.000076	0.000298	0.000294	0.000140	0.002337	0.000046	0.000099	0.000073	0.002886	0.000682	0.006106	0.001551	0.005633	0.000099	0.008921	0.005352	0.000823	0.001176	0.001661	0.024851	0.014448	0.000125	0.000193	0.000629	0.000309	0.002018	0.000545	0.000171	0.000608	0.000142	0.000748	0.000117	0.000377	0.000364	0.000106
58080504 - Jamie xx - In Colour - Obvs	58080504	0.020861	0.000297	0.000379	0.000698	0.000128	0.000250	0.000120	0.000043	0.000135	0.000040	0.000087	0.000027	0.000049	0.000034	0.000042	0.000135	0.000316	0.000061	0.000091	0.000108	0.000090	0.000111	0.000073	0.000117	0.000087	0.000015	0.000028	0.001614	0.000336	0.000096	0.000107	0.000177	0.000152	0.000339	0.000216	0.000078	0.000498	0.000052	0.000062	0.000013	0.000123	0.000139	0.000026	0.000099	0.000096	0.000059	0.000188	0.000098	0.000071	0.000091	0.000074	0.000393	0.000038	0.000288	0.000179	0.000144	0.000031	0.000025	0.000070	0.000072	0.000171	0.000127	0.000056	0.000150	0.000433	0.000568	0.000099	0.000045	0.000149	0.000482	0.000151	0.000119	0.002791	0.001591	0.000962	0.000201	0.000269	0.000127	0.000455	0.000079	0.000237	0.000582	0.000171	0.000305	0.000168	0.000081	0.000449	0.000297	0.000261	0.000071	0.000154	0.000153	0.000135	0.000068	0.000224	0.000165	0.000381	0.000340	0.000533	0.000325	0.000204	0.000152	0.000165	0.000173	0.000163	0.000218	0.000103	0.000103	0.000135	0.000140	0.000179	0.000965	0.000361	0.000282	0.000021	0.000270	0.000205	0.000152	0.000132	0.000143	0.000060	0.000027	0.000210	0.000102	0.000108	0.000118	0.001112	0.000098	0.000128	0.000879	0.000341	0.000797	0.000138	0.000049	0.000088	0.000430	0.000121	0.704094	0.059019	0.003742	0.004502	0.000819	0.000675	0.000562	0.000605	0.000239	0.000527	0.000360	0.000241	0.000421	0.000800	0.000476	0.023259	0.018687	0.013735	0.012130	0.017639	0.004733	0.092805	0.020038	0.000890	0.021660	0.008379	0.014476	0.021064	0.001905	0.001177	0.000558	0.003544	0.002295	0.000353	0.000639	0.000493	0.003329	0.000043	0.000028	0.000058	0.003016	0.002926	0.018454	0.028962	0.020242	0.024620	0.071370	0.002691	0.000769	0.000341	0.000251	0.000321	0.001585	0.000256	0.001883	0.001843	0.000567	0.000362	0.001021	0.000780	0.000597	0.000739	0.001555	0.000708	0.000266	0.000282	0.000010	0.000060	0.000535	0.000109	0.000086	0.000612	0.000916	0.000087	0.000990	0.000080	0.005346	0.003094	0.000179	0.001908	0.004094	0.000229	0.001211	0.000362	0.000308	0.000473	0.001084	0.000396	0.000537	0.002702	0.002930	0.001179	0.001382	0.000583	0.000577	0.001163	0.000635	0.001044	0.002996	0.000359	0.002032	0.000157	0.064320	0.003455	0.005786	0.017007	0.006486	0.050103	0.002974	0.156345	0.006026	0.000400	0.000257	0.000209	0.002260	0.000680	0.016331	0.000334	0.000116	0.000526	0.000376	0.000757	0.000519	0.000499	0.000134	0.000134	0.000159	0.001068	0.003845	0.000424	0.016112	0.005008	0.001010	0.011511	0.001630	0.008713	0.000977	0.001056	0.000877	0.001021	0.000975	0.000638	0.005373	0.001702	0.000102	0.000490	0.000502	0.000324	0.000415	0.000150	0.000178	0.000557	0.000246	0.000193	0.000219	0.000364	0.000176	0.000471	0.000366	0.000113	0.000428	0.000161	0.000191	0.005743	0.000936	0.000216	0.000372	0.000315	0.000225	0.000491	0.001663	0.000542	0.000334	0.000070	0.000047	0.000096	0.000191	0.000200	0.000300	0.000490	0.000097	0.000174	0.000094	0.000296	0.000186	0.000301	0.000150	0.000140	0.000142	0.000725	0.000237	0.000701	0.000907	0.000151	0.000408	0.000635	0.000035	0.000170	0.000268	0.000080	0.000059	0.000092	0.000187	0.000180	0.001435	0.001692	0.000453	0.000074	0.000018	0.000138	0.000223	0.000182	0.000107	0.000055	0.000068	0.000183	0.000296	0.000384	0.000031	0.000649	0.000137	0.000304	0.000091	0.000353	0.000014	0.000055	0.000073	0.000360	0.000116	0.000036	0.000124	0.000358	0.000155	0.000168	0.000118	0.000111	0.000099	0.000119	0.000012	0.000044	0.000224	0.000167	0.000355	0.000020	0.000094	0.000273	0.000054	0.000075	0.000034	0.000100	0.000112	0.000084	0.000276	0.000055	0.002453	0.000110	0.000097	0.000154	0.000066	0.000569	0.000146	0.000173	0.000097	0.000038	0.000108	0.000063	0.000075	0.000155	0.000075	0.000172	0.000500	0.000665	0.000061	0.000013	0.000105	0.000273	0.000251	0.000026	0.000264	0.000116	0.000287	0.000785	0.000314	0.000022	0.000098	0.000103	0.000016	0.000232	0.000128	0.000151	0.000108	0.000049	0.000049	0.000033	0.000043	0.000101	0.000058	0.000251	0.000106	0.000053	0.000512	0.000712	0.000055	0.000039	0.001303	0.001593	0.000015	0.000674	0.000129	0.000117	0.001945	0.001338	0.000043	0.000470	0.000154	0.000415	0.000911	0.000174	0.000107	0.000080	0.000740	0.000165	0.000319	0.000271	0.000184	0.000283	0.003748	0.000762	0.001053	0.000047	0.000200	0.000183	0.000102	0.000040	0.000098	0.000047	0.000098	0.000227	0.000142	0.000202	0.000392	0.000008	0.000066	0.000015	0.000337	0.005120	0.000382	0.000039	0.000005	0.000012	0.000394	0.000043	0.000513	0.000142	0.000051	0.000174	0.000163	0.000124	0.000896	0.006926	0.000220	0.000032	0.000066	0.001062	0.000082	0.009023	0.000050	0.005493	0.000273	0.005925	0.004379	0.001303	0.003018	0.001892	0.003311	0.010716	0.000067	0.000086	0.000974	0.000952	0.000986	0.000384	0.000261	0.000359	0.000161	0.009197	0.000226	0.000288	0.000241	0.000081
58080507 - Jamie xx - In Colour - Hold Tight	58080507	0.183059	0.000891	0.001052	0.003928	0.000289	0.000393	0.000243	0.000051	0.000513	0.000107	0.000339	0.000093	0.000064	0.000171	0.000254	0.000204	0.001655	0.000214	0.000273	0.000538	0.000378	0.000437	0.000404	0.000669	0.000341	0.000040	0.000042	0.001760	0.000193	0.000090	0.000093	0.000127	0.000207	0.000283	0.000182	0.000131	0.000394	0.000078	0.000088	0.000012	0.000421	0.000258	0.000034	0.000071	0.000122	0.000039	0.000105	0.000193	0.000101	0.000291	0.000054	0.000859	0.000099	0.000301	0.000153	0.000100	0.000050	0.000094	0.000069	0.000260	0.000142	0.000122	0.000057	0.000144	0.000637	0.000488	0.000402	0.000146	0.001337	0.002649	0.001371	0.000631	0.003700	0.002562	0.001849	0.000307	0.000367	0.000584	0.000543	0.000066	0.000318	0.000673	0.000055	0.000454	0.000438	0.000168	0.000665	0.000193	0.000176	0.000040	0.000189	0.000191	0.000113	0.000098	0.000163	0.000296	0.000338	0.000351	0.000681	0.000414	0.000261	0.000236	0.000180	0.000183	0.000230	0.000253	0.000213	0.000179	0.000115	0.000067	0.000082	0.001202	0.000497	0.000527	0.000040	0.000205	0.000178	0.000107	0.000099	0.000313	0.000146	0.000043	0.000479	0.000171	0.000323	0.000118	0.000898	0.000232	0.000183	0.000473	0.001594	0.000387	0.000254	0.000100	0.000169	0.000215	0.000312	0.627913	0.011866	0.001022	0.001272	0.000264	0.000325	0.000169	0.000065	0.000047	0.000140	0.000104	0.000155	0.000076	0.000130	0.000081	0.004424	0.003196	0.002215	0.000825	0.000662	0.000369	0.022037	0.027852	0.000169	0.002628	0.002397	0.014681	0.003939	0.001056	0.000696	0.000769	0.002019	0.004549	0.000196	0.000488	0.000436	0.000556	0.000068	0.000043	0.000044	0.008867	0.000556	0.000888	0.001203	0.000999	0.000508	0.000212	0.000620	0.000480	0.000198	0.000169	0.000171	0.000354	0.000086	0.000539	0.000238	0.000179	0.000125	0.001132	0.000620	0.000125	0.000183	0.000167	0.000631	0.000370	0.000154	0.000019	0.000186	0.000407	0.000221	0.000075	0.000092	0.000256	0.000158	0.000652	0.000462	0.007421	0.003690	0.000638	0.002917	0.003650	0.000151	0.001646	0.000593	0.000415	0.000206	0.000583	0.000439	0.000226	0.001316	0.000513	0.000486	0.000401	0.000108	0.000132	0.001226	0.000167	0.000434	0.000782	0.003005	0.000570	0.000127	0.162793	0.016448	0.046636	0.013256	0.125220	0.068226	0.014725	0.062302	0.106275	0.000227	0.000102	0.000124	0.000594	0.000188	0.001715	0.000190	0.000056	0.000328	0.000184	0.000237	0.000159	0.000677	0.000172	0.000229	0.000133	0.000163	0.001047	0.000616	0.004373	0.003206	0.000408	0.014074	0.000107	0.003619	0.000143	0.002886	0.000054	0.000358	0.000446	0.000187	0.000693	0.002680	0.001492	0.001645	0.000305	0.000162	0.000277	0.000098	0.000122	0.000670	0.000132	0.000099	0.000107	0.000202	0.000130	0.000208	0.000142	0.000252	0.000343	0.000183	0.000169	0.008204	0.000856	0.000148	0.000192	0.000291	0.000316	0.000525	0.002386	0.001687	0.000717	0.000169	0.000029	0.000142	0.000153	0.000266	0.000446	0.000448	0.000138	0.000688	0.000040	0.000081	0.000228	0.000427	0.000416	0.000242	0.000156	0.000400	0.000154	0.000377	0.000568	0.000166	0.000290	0.000316	0.000009	0.000088	0.000319	0.000054	0.000081	0.000081	0.000158	0.000249	0.000749	0.001196	0.000417	0.000024	0.000020	0.000086	0.000052	0.000167	0.000092	0.000052	0.000121	0.000147	0.000289	0.000830	0.000154	0.000503	0.000306	0.000303	0.000134	0.000298	0.000119	0.000039	0.000057	0.000385	0.000157	0.000025	0.000102	0.000519	0.000138	0.000163	0.000114	0.000190	0.000082	0.000098	0.000036	0.000102	0.000158	0.000075	0.000269	0.000168	0.000067	0.000561	0.000083	0.000184	0.000111	0.000210	0.000135	0.000538	0.000531	0.000241	0.000923	0.000485	0.000399	0.000651	0.000127	0.001427	0.000653	0.000954	0.000480	0.000636	0.000909	0.000621	0.000254	0.000218	0.000083	0.000195	0.000645	0.000674	0.000091	0.000022	0.000089	0.000084	0.000030	0.000054	0.000139	0.000136	0.000319	0.000436	0.000119	0.000016	0.000057	0.000061	0.000013	0.000173	0.000198	0.000411	0.000398	0.000161	0.000047	0.000072	0.000182	0.000165	0.000107	0.000546	0.000094	0.000088	0.000244	0.000066	0.000039	0.000043	0.000180	0.000269	0.000022	0.000322	0.000268	0.000192	0.000210	0.000334	0.000036	0.000197	0.000104	0.000132	0.000699	0.000071	0.000068	0.000028	0.002413	0.000289	0.000612	0.000290	0.000094	0.000259	0.001453	0.000379	0.000724	0.000190	0.000225	0.000090	0.000080	0.000085	0.000067	0.000064	0.000073	0.000566	0.000099	0.000163	0.000508	0.000014	0.000048	0.000025	0.000987	0.000498	0.000283	0.000059	0.000025	0.000042	0.000605	0.000028	0.000427	0.000121	0.000125	0.000076	0.001697	0.000111	0.000137	0.094989	0.000245	0.000164	0.000052	0.004995	0.001784	0.001787	0.000550	0.009332	0.001490	0.006560	0.008985	0.004473	0.007002	0.003329	0.001737	0.005371	0.000216	0.000313	0.007957	0.007176	0.000542	0.001513	0.001072	0.000778	0.000133	0.162757	0.000433	0.000628	0.000287	0.000097
58080509 - Jamie xx - In Colour - I Know There's Gonna Be (Good Times)	58080509	0.198129	0.001939	0.000933	0.002749	0.000349	0.000951	0.000635	0.000276	0.000735	0.001021	0.001222	0.000357	0.000131	0.000048	0.001445	0.000883	0.001753	0.000642	0.001333	0.000708	0.000742	0.000565	0.001019	0.000982	0.001163	0.001002	0.000811	0.053286	0.000658	0.001404	0.000411	0.000321	0.003768	0.001272	0.000369	0.000758	0.167225	0.000615	0.001009	0.000065	0.003116	0.000678	0.000092	0.000075	0.000464	0.000079	0.000130	0.000759	0.000416	0.000811	0.000069	0.000095	0.000061	0.000177	0.000328	0.000229	0.000058	0.000149	0.000264	0.000880	0.000291	0.000251	0.000577	0.000438	0.001272	0.000900	0.000206	0.000066	0.000102	0.000807	0.000216	0.000030	0.004929	0.004306	0.003169	0.000884	0.000590	0.001459	0.000771	0.000258	0.000452	0.000559	0.000070	0.000420	0.000089	0.000117	0.000309	0.000148	0.000124	0.000060	0.000058	0.000053	0.000168	0.000138	0.000285	0.000203	0.000447	0.000356	0.000784	0.000490	0.000226	0.000336	0.000222	0.000215	0.000177	0.000338	0.000190	0.000207	0.000052	0.000052	0.000141	0.001108	0.000451	0.000404	0.000063	0.000131	0.000094	0.000155	0.000166	0.000328	0.000120	0.000018	0.001284	0.000117	0.000182	0.000063	0.000515	0.000191	0.000334	0.000231	0.000305	0.000072	0.000342	0.000158	0.000043	0.000393	0.000042	0.727296	0.014071	0.001878	0.002435	0.000438	0.000759	0.000416	0.000163	0.000162	0.000325	0.000346	0.000158	0.000202	0.000169	0.000326	0.003536	0.002785	0.002250	0.000735	0.000650	0.000337	0.010743	0.011586	0.000288	0.002708	0.002135	0.010821	0.002756	0.000902	0.000718	0.000337	0.001637	0.000847	0.000112	0.000402	0.000343	0.000792	0.000122	0.000217	0.000767	0.000289	0.000585	0.007261	0.009812	0.009906	0.001632	0.000144	0.000926	0.000886	0.000195	0.000539	0.000269	0.000524	0.000064	0.000550	0.000367	0.000208	0.000138	0.002177	0.002126	0.000255	0.000257	0.000176	0.000439	0.000084	0.000785	0.000597	0.000786	0.001449	0.000499	0.000013	0.000812	0.000402	0.000095	0.000204	0.000371	0.003476	0.001045	0.001102	0.056863	0.238066	0.001051	0.002470	0.001095	0.006628	0.002169	0.003869	0.005064	0.000536	0.094950	0.014307	0.063787	0.001731	0.001451	0.000561	0.032946	0.001247	0.004148	0.006480	0.006935	0.000864	0.000417	0.012516	0.007350	0.001902	0.002608	0.001126	0.006371	0.003015	0.002978	0.000706	0.001964	0.000304	0.000120	0.008487	0.005280	0.002649	0.002503	0.000673	0.024691	0.034843	0.002655	0.003874	0.003706	0.000189	0.000356	0.004680	0.000449	0.028177	0.020113	0.005101	0.002675	0.004703	0.011099	0.000659	0.000510	0.002429	0.015443	0.000177	0.005861	0.005889	0.000602	0.003970	0.022446	0.000062	0.000137	0.000088	0.000100	0.000079	0.000037	0.000045	0.000262	0.000044	0.000039	0.000032	0.000099	0.000036	0.000049	0.000038	0.000073	0.000201	0.000043	0.000132	0.001940	0.000128	0.000032	0.000102	0.000051	0.000020	0.000127	0.000455	0.000783	0.000145	0.000431	0.000012	0.000034	0.000031	0.000076	0.000072	0.000138	0.000022	0.000492	0.000022	0.000212	0.000057	0.000522	0.000563	0.000215	0.000134	0.000148	0.000030	0.000132	0.000190	0.000068	0.000083	0.000116	0.000003	0.000041	0.000090	0.000016	0.000038	0.000029	0.000031	0.000065	0.000426	0.000737	0.000150	0.000006	0.000018	0.000021	0.000008	0.000050	0.000037	0.000007	0.000030	0.000039	0.000094	0.000262	0.001633	0.003001	0.000087	0.000125	0.000092	0.000295	0.000572	0.000016	0.000021	0.000098	0.000057	0.000079	0.000024	0.000140	0.000047	0.000080	0.000056	0.000148	0.000026	0.000043	0.000030	0.000057	0.000030	0.000245	0.000294	0.000152	0.000199	0.000198	0.000070	0.000224	0.000048	0.000287	0.000281	0.004468	0.002076	0.002111	0.007447	0.000740	0.004151	0.003692	0.001304	0.001464	0.000269	0.003547	0.010000	0.006163	0.000194	0.004501	0.000084	0.000088	0.000039	0.000284	0.000339	0.000335	0.000037	0.000010	0.000045	0.000086	0.000019	0.000136	0.000063	0.000470	0.000805	0.000185	0.000025	0.000005	0.000015	0.000027	0.000005	0.000067	0.000087	0.000446	0.000554	0.000111	0.000036	0.000073	0.000669	0.000196	0.000120	0.001587	0.000094	0.000066	0.000068	0.000181	0.000003	0.000053	0.000244	0.000500	0.000063	0.000208	0.000062	0.000067	0.000312	0.000582	0.000025	0.000195	0.000032	0.000066	0.000234	0.000016	0.000014	0.000023	0.001482	0.000186	0.000369	0.000147	0.000271	0.000519	0.001290	0.000539	0.000306	0.000323	0.001186	0.000057	0.000032	0.000096	0.000104	0.000136	0.000041	0.000589	0.000157	0.000057	0.001813	0.000011	0.000058	0.000072	0.008563	0.000898	0.004299	0.000668	0.000039	0.000015	0.000262	0.000017	0.000256	0.000030	0.000522	0.000031	0.000195	0.001834	0.002477	0.001598	0.002091	0.002381	0.000235	0.005152	0.009306	0.001821	0.002534	0.004234	0.001816	0.018733	0.006473	0.001031	0.002428	0.002266	0.001441	0.004835	0.000050	0.000173	0.000810	0.000135	0.000544	0.002923	0.000205	0.000121	0.000033	0.002138	0.000084	0.000451	0.000979	0.000085
58080510 - Jamie xx - In Colour - The Rest Is Noise.part	58080510	0.009888	0.000144	0.000159	0.000256	0.000052	0.000116	0.000063	0.000033	0.000087	0.000034	0.000076	0.000027	0.000018	0.000026	0.000044	0.000088	0.000160	0.000047	0.000052	0.000053	0.000073	0.000040	0.000060	0.000068	0.000059	0.000014	0.000055	0.000944	0.000155	0.000042	0.000079	0.000099	0.000065	0.000103	0.000043	0.000018	0.000277	0.000115	0.000086	0.000008	0.000073	0.000169	0.000027	0.000088	0.000043	0.000024	0.000120	0.000064	0.000038	0.000083	0.000061	0.000110	0.000011	0.000127	0.000121	0.000079	0.000003	0.000053	0.000026	0.000072	0.000053	0.000052	0.000016	0.000080	0.000490	0.000609	0.000099	0.000036	0.000074	0.000296	0.000066	0.000022	0.001536	0.001087	0.000734	0.000204	0.000137	0.000161	0.000236	0.000069	0.000115	0.000320	0.000083	0.000151	0.000188	0.000049	0.000239	0.000117	0.000115	0.000028	0.000073	0.000075	0.000169	0.000035	0.000052	0.000071	0.000083	0.000069	0.000360	0.000255	0.000142	0.000126	0.000089	0.000089	0.000108	0.000126	0.000082	0.000069	0.000082	0.000059	0.000079	0.000655	0.000263	0.000219	0.000009	0.000153	0.000120	0.000052	0.000041	0.000135	0.000076	0.000023	0.000248	0.000055	0.000065	0.000060	0.000464	0.000143	0.000080	0.000241	0.000214	0.000159	0.000077	0.000027	0.000038	0.000341	0.000197	0.746232	0.044244	0.003207	0.004184	0.000981	0.000473	0.000744	0.000377	0.000154	0.000621	0.000335	0.000175	0.000361	0.000717	0.000332	0.057277	0.051025	0.047313	0.002456	0.003196	0.000679	0.129861	0.068631	0.003194	0.002947	0.005218	0.058001	0.007614	0.001713	0.001469	0.000691	0.004222	0.000954	0.000061	0.000733	0.000751	0.000525	0.000071	0.000025	0.000058	0.001561	0.001390	0.004101	0.005225	0.004825	0.001832	0.000309	0.001086	0.001058	0.000501	0.000454	0.000486	0.001048	0.000131	0.001754	0.001157	0.000499	0.000244	0.001028	0.000551	0.000260	0.000484	0.001145	0.000685	0.000476	0.000310	0.000053	0.000232	0.001259	0.000445	0.000106	0.000254	0.000227	0.000143	0.000225	0.000301	0.009715	0.005751	0.000566	0.004280	0.006117	0.000073	0.002480	0.000744	0.000731	0.000529	0.001248	0.000778	0.000379	0.004418	0.003051	0.000923	0.000877	0.000646	0.000294	0.003772	0.000242	0.000574	0.001828	0.003199	0.001545	0.000146	0.120945	0.019697	0.028932	0.008976	0.061659	0.101338	0.010482	0.186108	0.027210	0.000195	0.000090	0.000158	0.002019	0.000237	0.024306	0.000127	0.000059	0.000651	0.000943	0.000355	0.000268	0.000452	0.000089	0.000255	0.000292	0.000155	0.002775	0.000309	0.018018	0.007253	0.000725	0.014342	0.000594	0.007074	0.000327	0.003262	0.000176	0.001550	0.000711	0.001209	0.004829	0.004425	0.000254	0.001707	0.000243	0.000236	0.000214	0.000123	0.000174	0.000287	0.000148	0.000105	0.000119	0.000114	0.000075	0.000167	0.000123	0.000148	0.000217	0.000059	0.000094	0.004273	0.000469	0.000092	0.000167	0.000166	0.000125	0.000168	0.000921	0.000507	0.000234	0.000110	0.000014	0.000046	0.000073	0.000082	0.000150	0.000204	0.000037	0.000198	0.000052	0.000053	0.000073	0.000205	0.000226	0.000128	0.000073	0.000227	0.000065	0.000584	0.000891	0.000135	0.000259	0.000511	0.000021	0.000135	0.000294	0.000065	0.000066	0.000073	0.000099	0.000238	0.000308	0.000185	0.000299	0.000024	0.000006	0.000071	0.000024	0.000102	0.000081	0.000039	0.000086	0.000111	0.000194	0.000233	0.000311	0.001735	0.000145	0.000078	0.000049	0.000186	0.000037	0.000022	0.000034	0.000101	0.000044	0.000009	0.000052	0.000171	0.000043	0.000120	0.000093	0.000057	0.000023	0.000070	0.000005	0.000020	0.000068	0.000030	0.000370	0.000032	0.000027	0.000090	0.000034	0.000114	0.000061	0.000149	0.000059	0.000725	0.000496	0.000173	0.002766	0.000252	0.000422	0.001041	0.000479	0.000709	0.000252	0.000747	0.000394	0.000343	0.000642	0.000103	0.000097	0.000102	0.000041	0.000459	0.000628	0.000763	0.000034	0.000006	0.000058	0.000091	0.000058	0.000044	0.000139	0.000076	0.000173	0.000273	0.000139	0.000010	0.000022	0.000031	0.000006	0.000091	0.000076	0.000178	0.000220	0.000081	0.000049	0.000031	0.000098	0.000061	0.000036	0.000252	0.000059	0.000034	0.000088	0.000079	0.000005	0.000017	0.000271	0.000439	0.000015	0.000259	0.000039	0.000046	0.000263	0.000466	0.000022	0.000137	0.000119	0.000172	0.000394	0.000074	0.000025	0.000029	0.001567	0.000085	0.000298	0.000201	0.000107	0.001397	0.006476	0.001131	0.000088	0.000061	0.000058	0.000052	0.000049	0.000028	0.000061	0.000030	0.000043	0.000174	0.000079	0.000060	0.000683	0.000008	0.000041	0.000015	0.001606	0.000499	0.000555	0.000095	0.000008	0.000007	0.000439	0.000024	0.000342	0.000068	0.000084	0.000103	0.000217	0.000127	0.000568	0.007820	0.000379	0.000065	0.000034	0.003575	0.001413	0.004929	0.000537	0.006747	0.000655	0.008310	0.003580	0.000614	0.001894	0.001904	0.001874	0.013444	0.000215	0.000137	0.002575	0.000510	0.002017	0.001482	0.000491	0.000457	0.000062	0.013800	0.000227	0.000474	0.000197	0.000072
58080511 - Jamie xx - In Colour - Girl	58080511	0.066398	0.000455	0.000311	0.000961	0.000081	0.000204	0.000133	0.000076	0.000452	0.000306	0.000621	0.000169	0.000097	0.000080	0.000351	0.000213	0.000353	0.000107	0.000171	0.000141	0.000107	0.000126	0.000219	0.000454	0.000339	0.000116	0.000223	0.039223	0.002277	0.003332	0.000319	0.000397	0.002556	0.007566	0.001944	0.002108	0.001688	0.001444	0.000178	0.000013	0.000269	0.000437	0.000068	0.000106	0.000256	0.000133	0.000303	0.000078	0.000093	0.000189	0.000046	0.000438	0.000112	0.000267	0.000127	0.000104	0.000033	0.000153	0.000042	0.000112	0.000047	0.000119	0.000030	0.000244	0.010094	0.006559	0.000253	0.000105	0.000111	0.001687	0.000215	0.000081	0.003913	0.002545	0.001461	0.000216	0.000316	0.000941	0.000430	0.000071	0.000247	0.000822	0.000146	0.000660	0.000357	0.000118	0.000406	0.000263	0.000239	0.000100	0.000120	0.000101	0.000256	0.000035	0.000112	0.000285	0.000906	0.000605	0.000383	0.000287	0.000148	0.000173	0.000073	0.000075	0.000104	0.000157	0.000102	0.000112	0.000097	0.000088	0.000261	0.000686	0.000320	0.000261	0.000020	0.000194	0.000175	0.000078	0.000076	0.000623	0.000304	0.000016	0.000426	0.000115	0.000205	0.000072	0.000644	0.000146	0.000173	0.000328	0.000790	0.000210	0.000168	0.000064	0.000239	0.001005	0.000802	0.647218	0.026113	0.002762	0.003647	0.000614	0.000793	0.000538	0.000276	0.000170	0.000471	0.000144	0.000245	0.000171	0.000365	0.000197	0.004287	0.003482	0.002265	0.001768	0.001357	0.000878	0.016596	0.032086	0.000215	0.006589	0.006826	0.037880	0.010643	0.002678	0.002297	0.000917	0.005539	0.002508	0.000174	0.001099	0.000846	0.000881	0.000709	0.000271	0.000377	0.002582	0.000482	0.001456	0.002106	0.001654	0.000689	0.000550	0.002296	0.001054	0.000573	0.000315	0.000397	0.000826	0.000175	0.000934	0.000456	0.000362	0.000313	0.001817	0.001982	0.000257	0.000195	0.000362	0.000723	0.000248	0.001400	0.000194	0.000704	0.000613	0.000278	0.000028	0.000481	0.000714	0.000117	0.000858	0.000412	0.006013	0.002537	0.002844	0.016142	0.015262	0.000392	0.002415	0.000571	0.000642	0.000513	0.000998	0.001536	0.000585	0.006939	0.006718	0.002475	0.000736	0.000766	0.000280	0.007010	0.000743	0.001167	0.001835	0.008833	0.001508	0.001482	0.114613	0.011394	0.006477	0.051925	0.033745	0.023788	0.006807	0.029565	0.005215	0.001442	0.000312	0.000327	0.002079	0.001071	0.002211	0.001353	0.000562	0.000932	0.000615	0.002721	0.001970	0.005725	0.000260	0.000419	0.000423	0.000672	0.004884	0.007212	0.002419	0.002455	0.003067	0.004879	0.001367	0.000638	0.001803	0.004651	0.000342	0.001040	0.000700	0.000388	0.001891	0.003939	0.000208	0.000671	0.000256	0.000222	0.000232	0.000076	0.000093	0.000421	0.000105	0.000084	0.000097	0.000163	0.000079	0.000143	0.000109	0.000210	0.000285	0.000087	0.000169	0.003886	0.000380	0.000100	0.000201	0.000151	0.000100	0.000239	0.001182	0.000428	0.000275	0.000085	0.000041	0.000062	0.000084	0.000195	0.000208	0.000302	0.000071	0.000107	0.000107	0.000155	0.000196	0.000385	0.000310	0.000131	0.000116	0.000192	0.000134	0.000307	0.000448	0.000134	0.000132	0.000257	0.000015	0.000110	0.000235	0.000048	0.000074	0.000048	0.000196	0.000151	0.001165	0.001127	0.000439	0.000020	0.000017	0.000042	0.000014	0.000136	0.000119	0.000045	0.000064	0.000144	0.000241	0.000431	0.000127	0.000981	0.000260	0.000305	0.000190	0.000334	0.000121	0.000017	0.000063	0.000382	0.000196	0.000029	0.000104	0.000244	0.000073	0.000148	0.000099	0.000077	0.000032	0.000111	0.000055	0.000059	0.000062	0.000130	0.000739	0.000454	0.000201	0.000414	0.000032	0.000100	0.000027	0.000122	0.000422	0.000348	0.000380	0.000206	0.001232	0.000118	0.000397	0.001753	0.000445	0.000919	0.000264	0.000724	0.000723	0.000469	0.000211	0.000671	0.000125	0.000267	0.000113	0.000244	0.000678	0.000624	0.000094	0.000024	0.000177	0.000214	0.000040	0.000057	0.000288	0.000084	0.000396	0.000695	0.000180	0.000023	0.000083	0.000211	0.000034	0.000168	0.000194	0.000414	0.000274	0.000121	0.000108	0.000067	0.000114	0.000156	0.000090	0.001202	0.000086	0.000118	0.000249	0.000299	0.000011	0.000018	0.000665	0.001210	0.000139	0.000463	0.000085	0.000084	0.000376	0.000610	0.000032	0.000389	0.000158	0.000240	0.000585	0.000074	0.000071	0.000066	0.009652	0.000374	0.001854	0.000534	0.000252	0.000424	0.001775	0.001012	0.000571	0.000246	0.000468	0.000145	0.000092	0.000076	0.000044	0.000292	0.000119	0.003885	0.000204	0.000472	0.001501	0.000003	0.000030	0.000022	0.002775	0.002068	0.002778	0.000708	0.000019	0.000057	0.000792	0.000047	0.000516	0.000132	0.000228	0.000057	0.000991	0.000384	0.001159	0.088925	0.000295	0.000186	0.000040	0.005535	0.005113	0.001374	0.001436	0.010526	0.005864	0.007807	0.009516	0.002611	0.002693	0.001596	0.003127	0.007520	0.000105	0.000162	0.008955	0.002793	0.000732	0.002277	0.000318	0.000635	0.000093	0.095865	0.000380	0.001048	0.000822	0.000221
37270824 - Caribou - Our Love - Can't Do Without You	37270824	0.036938	0.000983	0.000947	0.000801	0.000205	0.000858	0.000128	0.000281	0.000465	0.000451	0.000458	0.000355	0.000021	0.000024	0.000277	0.000645	0.000373	0.000069	0.000113	0.000137	0.000077	0.000119	0.000186	0.000204	0.000576	0.000157	0.000361	0.036415	0.000300	0.000608	0.000302	0.000430	0.001898	0.001062	0.000373	0.000976	0.003251	0.000836	0.000252	0.000058	0.000177	0.000355	0.000080	0.000053	0.000396	0.000058	0.000140	0.000313	0.000220	0.000259	0.000116	0.000132	0.000177	0.000239	0.000228	0.000158	0.000066	0.000176	0.000152	0.000301	0.000090	0.000097	0.000067	0.000111	0.002141	0.002712	0.000107	0.000058	0.000088	0.000434	0.000114	0.000038	0.003356	0.002659	0.002076	0.000909	0.000553	0.000939	0.000905	0.000170	0.000384	0.000533	0.000080	0.000369	0.000126	0.000100	0.000372	0.000130	0.000121	0.000028	0.000147	0.000141	0.000024	0.000109	0.000183	0.000091	0.000207	0.000157	0.000567	0.000466	0.000190	0.000285	0.000158	0.000146	0.000148	0.000207	0.000145	0.000138	0.000096	0.000060	0.000156	0.001037	0.000409	0.000353	0.000043	0.000169	0.000155	0.000128	0.000113	0.000492	0.000136	0.000015	0.000568	0.000115	0.000146	0.000061	0.000995	0.000315	0.000145	0.000439	0.001168	0.000284	0.000275	0.000103	0.000064	0.000453	0.000299	0.749593	0.044266	0.009059	0.016565	0.003454	0.004319	0.001167	0.000808	0.000298	0.001507	0.000248	0.000104	0.000131	0.000110	0.000271	0.006507	0.005154	0.004002	0.001152	0.000715	0.000519	0.019575	0.046107	0.000198	0.005426	0.017073	0.020466	0.015810	0.005725	0.004535	0.001077	0.008605	0.001794	0.000040	0.003131	0.002406	0.000201	0.000137	0.000138	0.000122	0.002209	0.000106	0.000322	0.000428	0.000417	0.000223	0.000094	0.000832	0.000757	0.000205	0.000264	0.000382	0.000879	0.000128	0.000698	0.000210	0.000339	0.000328	0.000448	0.000216	0.000195	0.000071	0.000111	0.000218	0.000154	0.000352	0.000041	0.000101	0.000110	0.000051	0.000040	0.000185	0.000167	0.000044	0.001115	0.000092	0.003759	0.000766	0.001051	0.025394	0.013932	0.000456	0.072692	0.017865	0.033645	0.054156	0.027881	0.016211	0.019862	0.011375	0.004566	0.003916	0.002702	0.001048	0.000656	0.013295	0.000270	0.000838	0.004221	0.006708	0.000554	0.000351	0.057509	0.013758	0.008714	0.006920	0.017761	0.013465	0.007467	0.018466	0.006900	0.000429	0.000121	0.000104	0.008002	0.000410	0.000965	0.001077	0.000210	0.000553	0.000593	0.000776	0.000488	0.001176	0.000086	0.000263	0.005204	0.000074	0.023415	0.010002	0.003100	0.003507	0.001183	0.010403	0.000305	0.001078	0.000476	0.007514	0.000074	0.001306	0.001307	0.000348	0.001408	0.010507	0.006170	0.001387	0.000211	0.000148	0.000208	0.000196	0.000255	0.000352	0.000140	0.000117	0.000103	0.000164	0.000099	0.000129	0.000105	0.000084	0.000290	0.000044	0.000165	0.006204	0.000636	0.000121	0.000236	0.000240	0.000151	0.000333	0.001565	0.000690	0.000211	0.000133	0.000052	0.000053	0.000096	0.000216	0.000241	0.000324	0.000072	0.000208	0.000041	0.000054	0.000183	0.000314	0.000328	0.000131	0.000110	0.000455	0.000107	0.000442	0.000631	0.000124	0.000195	0.000377	0.000019	0.000175	0.000298	0.000063	0.000078	0.000091	0.000108	0.000193	0.000529	0.001917	0.000469	0.000053	0.000020	0.000089	0.000049	0.000168	0.000127	0.000026	0.000118	0.000142	0.000313	0.000479	0.000335	0.000746	0.000227	0.000179	0.000181	0.000254	0.000101	0.000033	0.000062	0.000214	0.000126	0.000072	0.000088	0.000607	0.000151	0.000149	0.000104	0.000109	0.000126	0.000082	0.000008	0.000034	0.000125	0.000064	0.000524	0.000111	0.000194	0.000609	0.000084	0.000149	0.000074	0.000195	0.000238	0.000712	0.000544	0.000162	0.000656	0.000351	0.000842	0.001539	0.000401	0.001084	0.000369	0.000729	0.000400	0.000577	0.000334	0.000241	0.000073	0.000131	0.000047	0.000327	0.000897	0.000664	0.000039	0.000011	0.000072	0.000230	0.000078	0.000085	0.000136	0.000208	0.000365	0.000402	0.000056	0.000010	0.000039	0.000068	0.000014	0.000180	0.000165	0.000277	0.000353	0.000115	0.000058	0.000072	0.000350	0.000115	0.000094	0.000752	0.000065	0.000061	0.000145	0.000194	0.000014	0.000038	0.000096	0.000189	0.000052	0.000217	0.000059	0.000060	0.000188	0.000317	0.000030	0.000204	0.000126	0.000072	0.000414	0.000088	0.000045	0.000050	0.005875	0.000423	0.000847	0.000216	0.000216	0.001190	0.012068	0.004185	0.000272	0.000263	0.000241	0.000071	0.000028	0.000071	0.000192	0.000074	0.000131	0.000374	0.000303	0.000139	0.007052	0.000012	0.000061	0.000058	0.001696	0.000463	0.000245	0.000093	0.000011	0.000026	0.001241	0.000054	0.000747	0.000103	0.000645	0.000097	0.000647	0.000559	0.000139	0.028728	0.000219	0.000135	0.000106	0.010606	0.000873	0.001549	0.000266	0.012036	0.002409	0.012716	0.005145	0.001176	0.002203	0.001943	0.005062	0.018746	0.001301	0.000197	0.015794	0.002910	0.007204	0.012360	0.001610	0.001413	0.000248	0.032247	0.000628	0.000690	0.001421	0.000262
37270825 - Caribou - Our Love - Silver	37270825	0.040233	0.000812	0.000574	0.000812	0.000234	0.000663	0.000107	0.000341	0.000179	0.000112	0.000151	0.000059	0.000054	0.000050	0.000279	0.000326	0.000345	0.000104	0.000135	0.000131	0.000101	0.000093	0.000233	0.000225	0.000360	0.000080	0.000235	0.019622	0.000205	0.000291	0.000158	0.000405	0.000811	0.000824	0.000201	0.000378	0.013890	0.000837	0.000298	0.000028	0.000315	0.000216	0.000024	0.000030	0.000129	0.000066	0.000112	0.000152	0.000111	0.000201	0.000051	0.000107	0.000018	0.000122	0.000158	0.000062	0.000014	0.000087	0.000114	0.000204	0.000146	0.000041	0.000028	0.000067	0.002127	0.002996	0.000132	0.000036	0.000096	0.000441	0.000112	0.000024	0.002576	0.001714	0.001267	0.000392	0.000257	0.000699	0.000433	0.000126	0.000192	0.000329	0.000059	0.000216	0.000114	0.000061	0.000180	0.000151	0.000141	0.000042	0.000046	0.000044	0.000054	0.000069	0.000178	0.000086	0.000196	0.000143	0.000491	0.000237	0.000116	0.000161	0.000103	0.000096	0.000192	0.000322	0.000127	0.000138	0.000068	0.000059	0.000139	0.000708	0.000311	0.000253	0.000016	0.000114	0.000080	0.000062	0.000069	0.000182	0.000061	0.000012	0.000327	0.000086	0.000176	0.000042	0.000341	0.000098	0.000146	0.000171	0.000542	0.000064	0.000314	0.000132	0.000050	0.000260	0.000071	0.759640	0.028908	0.002068	0.002440	0.000580	0.000830	0.000436	0.000157	0.000121	0.000381	0.000148	0.000156	0.000166	0.000116	0.000156	0.011266	0.006499	0.006353	0.001527	0.001147	0.000579	0.092098	0.087506	0.000352	0.001219	0.002525	0.125192	0.004093	0.000693	0.000605	0.000182	0.001968	0.000477	0.000090	0.000289	0.000276	0.000148	0.000063	0.000030	0.000055	0.000150	0.000086	0.000468	0.000736	0.000585	0.000319	0.000047	0.000908	0.000980	0.000464	0.000411	0.000266	0.000724	0.000136	0.001669	0.000292	0.000351	0.000191	0.001941	0.001287	0.000367	0.000259	0.000176	0.000188	0.000108	0.000141	0.000048	0.000086	0.000124	0.000073	0.000022	0.000900	0.000401	0.000256	0.000728	0.000531	0.005320	0.000848	0.001793	0.019257	0.083356	0.000482	0.002243	0.000744	0.001225	0.000822	0.001488	0.000963	0.000435	0.034039	0.013279	0.005981	0.000905	0.000412	0.000285	0.008103	0.000738	0.002801	0.002770	0.003341	0.001063	0.000301	0.134402	0.008643	0.008632	0.087762	0.032543	0.038740	0.003910	0.026380	0.006453	0.000765	0.000248	0.000147	0.004153	0.000699	0.004780	0.000783	0.000217	0.003665	0.003790	0.000949	0.001095	0.002138	0.000187	0.001282	0.000395	0.000315	0.007175	0.007576	0.005164	0.007307	0.001291	0.009046	0.000907	0.001693	0.000731	0.003702	0.000242	0.001325	0.000796	0.001715	0.005299	0.005326	0.000103	0.000488	0.000118	0.000074	0.000109	0.000040	0.000050	0.000252	0.000052	0.000056	0.000044	0.000073	0.000030	0.000067	0.000054	0.000066	0.000157	0.000040	0.000087	0.002859	0.000226	0.000054	0.000122	0.000073	0.000051	0.000207	0.000793	0.000908	0.000304	0.000425	0.000023	0.000043	0.000064	0.000101	0.000139	0.000216	0.000043	0.000563	0.000029	0.000046	0.000098	0.000508	0.000421	0.000254	0.000148	0.000228	0.000070	0.000207	0.000273	0.000080	0.000137	0.000189	0.000009	0.000047	0.000138	0.000021	0.000043	0.000043	0.000048	0.000097	0.000233	0.000301	0.000178	0.000012	0.000009	0.000030	0.000020	0.000064	0.000051	0.000012	0.000036	0.000048	0.000159	0.000300	0.000114	0.000279	0.000105	0.000122	0.000164	0.000150	0.000144	0.000014	0.000025	0.000132	0.000077	0.000098	0.000051	0.000127	0.000055	0.000084	0.000058	0.000065	0.000013	0.000032	0.000004	0.000032	0.000029	0.000089	0.000317	0.000040	0.000067	0.000336	0.000035	0.000121	0.000020	0.000155	0.000172	0.002350	0.000697	0.000291	0.002710	0.000250	0.003493	0.002578	0.000382	0.001529	0.000294	0.001642	0.003022	0.003623	0.000293	0.000751	0.000059	0.000078	0.000028	0.000206	0.000529	0.000380	0.000025	0.000004	0.000030	0.000030	0.000013	0.000042	0.000078	0.000080	0.000206	0.000231	0.000039	0.000006	0.000018	0.000026	0.000005	0.000084	0.000089	0.000323	0.000194	0.000071	0.000033	0.000059	0.000072	0.000134	0.000066	0.000814	0.000063	0.000050	0.000087	0.000490	0.000004	0.000016	0.000157	0.000224	0.000050	0.000290	0.000042	0.000058	0.000231	0.000809	0.000032	0.000153	0.000060	0.000086	0.000370	0.000026	0.000022	0.000024	0.001319	0.000095	0.000473	0.000117	0.000134	0.000497	0.002316	0.001574	0.000196	0.000114	0.000211	0.000068	0.000051	0.000037	0.000071	0.000041	0.000049	0.000583	0.000062	0.000067	0.000589	0.000002	0.000034	0.000016	0.004273	0.000149	0.000309	0.000077	0.000017	0.000009	0.000294	0.000028	0.000299	0.000053	0.000339	0.000048	0.000185	0.000883	0.000229	0.025088	0.005539	0.000370	0.000044	0.004192	0.006004	0.002689	0.001823	0.008047	0.004218	0.007588	0.002388	0.000532	0.001547	0.001061	0.001202	0.005543	0.000195	0.000085	0.008339	0.001142	0.000811	0.004312	0.000390	0.000395	0.000045	0.028183	0.000152	0.000399	0.000644	0.000051
37270849 - Caribou - Our Love - Julia Brightly	37270849	0.028554	0.000347	0.000299	0.000860	0.000079	0.000295	0.000146	0.000204	0.000157	0.000093	0.000153	0.000081	0.000029	0.000049	0.000329	0.000419	0.000305	0.000092	0.000140	0.000076	0.000117	0.000066	0.000157	0.000226	0.000240	0.000053	0.000142	0.011962	0.000203	0.000294	0.000089	0.000229	0.000730	0.000958	0.000321	0.000656	0.000967	0.000337	0.000255	0.000023	0.000674	0.000106	0.000026	0.000039	0.000103	0.000015	0.000083	0.000070	0.000035	0.000128	0.000051	0.000149	0.000013	0.000149	0.000300	0.000171	0.000006	0.000096	0.000078	0.000112	0.000099	0.000053	0.000043	0.000081	0.000422	0.001000	0.000149	0.000035	0.000063	0.000407	0.000110	0.000037	0.002161	0.001449	0.001099	0.000402	0.000298	0.000634	0.000387	0.000119	0.000184	0.000339	0.000048	0.000333	0.000106	0.000062	0.000234	0.000206	0.000250	0.000071	0.000052	0.000053	0.000109	0.000054	0.000090	0.000089	0.000183	0.000147	0.000760	0.000294	0.000155	0.000235	0.000233	0.000220	0.000178	0.000272	0.000186	0.000189	0.000038	0.000025	0.000075	0.000853	0.000358	0.000327	0.000015	0.000102	0.000080	0.000100	0.000097	0.000125	0.000045	0.000015	0.000425	0.000105	0.000157	0.000111	0.000257	0.000107	0.000153	0.000125	0.000565	0.000042	0.000126	0.000055	0.000044	0.000599	0.000031	0.769089	0.057829	0.003459	0.004415	0.000988	0.001550	0.000539	0.000191	0.000098	0.000547	0.000174	0.000169	0.000164	0.000115	0.000104	0.026652	0.018521	0.013872	0.002149	0.001227	0.000704	0.112524	0.230692	0.000861	0.001789	0.005554	0.192549	0.007713	0.001440	0.001037	0.000430	0.004131	0.000221	0.000099	0.000781	0.000662	0.000228	0.000073	0.000109	0.000090	0.000235	0.000196	0.000809	0.001071	0.001086	0.000298	0.000042	0.001041	0.001253	0.000616	0.000730	0.000404	0.001077	0.000140	0.001696	0.000320	0.000608	0.000327	0.001442	0.000695	0.000199	0.000311	0.000285	0.000224	0.000128	0.000191	0.000107	0.000170	0.000548	0.000425	0.000030	0.000284	0.000165	0.000134	0.000799	0.000732	0.008629	0.001129	0.002191	0.029985	0.013153	0.000254	0.005544	0.001548	0.002189	0.002193	0.003206	0.002702	0.000683	0.018836	0.009359	0.001526	0.001651	0.000577	0.000585	0.022697	0.000293	0.001130	0.003767	0.028985	0.002357	0.001497	0.120649	0.045787	0.028404	0.015739	0.062370	0.095103	0.011186	0.013145	0.027812	0.000554	0.000216	0.000157	0.003538	0.000689	0.002968	0.000527	0.000177	0.001528	0.003099	0.000916	0.001286	0.001180	0.000196	0.000370	0.000528	0.000133	0.007767	0.005493	0.010219	0.010383	0.001676	0.019778	0.000724	0.006992	0.000646	0.017300	0.000343	0.003724	0.002804	0.001027	0.004237	0.019164	0.000162	0.000306	0.000178	0.000070	0.000156	0.000032	0.000036	0.000294	0.000061	0.000077	0.000058	0.000100	0.000031	0.000071	0.000058	0.000072	0.000237	0.000140	0.000448	0.003470	0.000392	0.000069	0.000142	0.000158	0.000091	0.000209	0.000915	0.001140	0.000461	0.000646	0.000021	0.000034	0.000050	0.000128	0.000105	0.000382	0.000076	0.000520	0.000061	0.000035	0.000073	0.000767	0.000687	0.000310	0.000260	0.000250	0.000079	0.000192	0.000271	0.000108	0.000171	0.000180	0.000006	0.000026	0.000141	0.000023	0.000032	0.000049	0.000036	0.000100	0.000253	0.000221	0.000259	0.000008	0.000021	0.000064	0.000021	0.000118	0.000077	0.000013	0.000075	0.000083	0.000190	0.000185	0.000161	0.000339	0.000105	0.000084	0.000079	0.000238	0.000110	0.000006	0.000031	0.000134	0.000100	0.000074	0.000072	0.000175	0.000045	0.000110	0.000063	0.000068	0.000024	0.000034	0.000018	0.000035	0.000030	0.000202	0.001034	0.000213	0.000169	0.000272	0.000064	0.000403	0.000123	0.000508	0.000162	0.001785	0.000911	0.000311	0.002692	0.000589	0.002980	0.003974	0.000464	0.002364	0.000569	0.002823	0.002969	0.002071	0.000666	0.000718	0.000069	0.000293	0.000101	0.000349	0.000683	0.000530	0.000112	0.000025	0.000035	0.000038	0.000017	0.000094	0.000091	0.000301	0.001180	0.000247	0.000025	0.000009	0.000014	0.000039	0.000009	0.000078	0.000075	0.000259	0.000491	0.000153	0.000074	0.000113	0.000276	0.000250	0.000166	0.000829	0.000054	0.000040	0.000079	0.000184	0.000007	0.000089	0.000282	0.000522	0.000055	0.000397	0.000047	0.000095	0.000327	0.001335	0.000048	0.000172	0.000085	0.000207	0.001056	0.000040	0.000031	0.000029	0.000689	0.000090	0.000513	0.000079	0.000102	0.001341	0.004348	0.001636	0.000148	0.000052	0.000106	0.000058	0.000077	0.000089	0.000049	0.000053	0.000084	0.000910	0.000429	0.000084	0.001466	0.000042	0.000124	0.000170	0.006464	0.000199	0.000464	0.000112	0.000011	0.000025	0.000560	0.000046	0.000540	0.000095	0.000467	0.000043	0.000179	0.001239	0.000329	0.008129	0.001963	0.000731	0.000195	0.007030	0.008681	0.004193	0.002592	0.011851	0.002354	0.008703	0.001805	0.000480	0.001904	0.001459	0.001338	0.010369	0.000606	0.000153	0.016751	0.000622	0.001820	0.004742	0.000618	0.000280	0.000043	0.006072	0.000193	0.000917	0.000889	0.000072
37270853 - Caribou - Our Love - Mars	37270853	0.105325	0.000355	0.000346	0.000755	0.000079	0.000238	0.000128	0.000227	0.000093	0.000058	0.000121	0.000045	0.000029	0.000025	0.000361	0.000492	0.000602	0.000255	0.000250	0.000188	0.000175	0.000129	0.000378	0.000289	0.000363	0.000074	0.000062	0.004698	0.000227	0.000317	0.000199	0.000287	0.000649	0.000496	0.000179	0.000412	0.000952	0.000153	0.000227	0.000017	0.002422	0.000120	0.000037	0.000058	0.000033	0.000035	0.000077	0.000154	0.000031	0.000214	0.000061	0.000113	0.000033	0.000122	0.000147	0.000075	0.000017	0.000040	0.000056	0.000222	0.000070	0.000047	0.000040	0.000051	0.000448	0.001396	0.000102	0.000017	0.000101	0.000601	0.000217	0.000037	0.006054	0.005096	0.004792	0.000934	0.000919	0.001662	0.001045	0.000182	0.000733	0.000302	0.000083	0.000200	0.000207	0.000072	0.000348	0.000150	0.000136	0.000039	0.000051	0.000051	0.001615	0.000176	0.000128	0.000149	0.000185	0.000198	0.001551	0.000430	0.000290	0.000258	0.000805	0.000816	0.000365	0.000437	0.000505	0.000591	0.000130	0.000057	0.000068	0.001379	0.000667	0.000677	0.000090	0.000138	0.000116	0.000090	0.000070	0.000268	0.000124	0.000030	0.001154	0.000275	0.000136	0.000095	0.000883	0.000390	0.000267	0.000371	0.000141	0.000177	0.000505	0.000151	0.000106	0.000591	0.000045	0.744948	0.070797	0.001564	0.001974	0.000465	0.000485	0.000320	0.000047	0.000188	0.000351	0.000111	0.000114	0.000084	0.000083	0.000084	0.006536	0.004233	0.002255	0.000241	0.000202	0.000089	0.076985	0.099718	0.000406	0.011181	0.011625	0.196787	0.026315	0.003209	0.002348	0.001237	0.008566	0.000469	0.000326	0.001266	0.001041	0.005899	0.000836	0.000790	0.001179	0.000259	0.000173	0.000621	0.001059	0.000733	0.000297	0.000587	0.000971	0.000834	0.000199	0.000415	0.000165	0.000658	0.000089	0.000910	0.000315	0.000283	0.000152	0.007003	0.012189	0.000194	0.000513	0.000230	0.000227	0.000056	0.000298	0.000085	0.000303	0.000202	0.000121	0.000016	0.000396	0.000123	0.000185	0.000324	0.001263	0.012164	0.001530	0.002042	0.009480	0.011191	0.000739	0.002510	0.000756	0.000933	0.000348	0.001028	0.001197	0.000207	0.008312	0.003032	0.002396	0.000410	0.000318	0.000125	0.014477	0.001993	0.002452	0.002970	0.032826	0.001531	0.000449	0.219345	0.149747	0.098223	0.011334	0.025505	0.116868	0.029865	0.004263	0.044196	0.001909	0.000662	0.000287	0.001682	0.000439	0.001493	0.000570	0.000087	0.017038	0.021046	0.000541	0.000598	0.000550	0.000350	0.000582	0.000658	0.002334	0.004755	0.001979	0.004289	0.002535	0.001103	0.012725	0.000481	0.002217	0.000388	0.025128	0.000290	0.002604	0.001780	0.000329	0.000976	0.010321	0.000055	0.000203	0.000169	0.000072	0.000151	0.000039	0.000050	0.000308	0.000064	0.000052	0.000049	0.000092	0.000038	0.000083	0.000066	0.000154	0.000159	0.000121	0.000106	0.002853	0.000398	0.000070	0.000131	0.000185	0.000072	0.000281	0.000765	0.000487	0.000128	0.002397	0.000014	0.000049	0.000032	0.000111	0.000104	0.000278	0.000043	0.000236	0.000042	0.000065	0.000118	0.001585	0.001425	0.001112	0.000502	0.000214	0.000104	0.000164	0.000229	0.000050	0.000057	0.000140	0.000008	0.000044	0.000170	0.000028	0.000054	0.000042	0.000084	0.000124	0.000231	0.000036	0.000327	0.000012	0.000032	0.000037	0.000015	0.000131	0.000074	0.000013	0.000044	0.000093	0.000158	0.000147	0.000134	0.000167	0.000046	0.000047	0.000082	0.000133	0.001321	0.000009	0.000016	0.000138	0.000075	0.000027	0.000077	0.000147	0.000029	0.000155	0.000116	0.000067	0.000023	0.000034	0.000014	0.000048	0.000042	0.000066	0.000429	0.000022	0.000063	0.000115	0.000044	0.000168	0.000056	0.000171	0.000138	0.016493	0.000711	0.000360	0.005687	0.001044	0.002521	0.002536	0.002392	0.005276	0.000910	0.007028	0.017097	0.023179	0.000130	0.007626	0.000103	0.000216	0.000119	0.000267	0.000537	0.000380	0.000103	0.000017	0.000028	0.000036	0.000013	0.000054	0.000128	0.000192	0.000163	0.000216	0.000047	0.000008	0.000021	0.000042	0.000016	0.000078	0.000069	0.000212	0.000219	0.000069	0.000014	0.000044	0.000129	0.000112	0.000078	0.000502	0.000046	0.000022	0.000086	0.000073	0.000003	0.000024	0.000286	0.000217	0.000018	0.000217	0.000044	0.000062	0.000080	0.000549	0.000034	0.000091	0.000041	0.000101	0.000430	0.000033	0.000041	0.000035	0.001155	0.000079	0.000339	0.000054	0.000049	0.000312	0.001095	0.000153	0.000035	0.000042	0.000167	0.000045	0.000014	0.000031	0.000039	0.000039	0.000033	0.000413	0.000090	0.000108	0.001503	0.000002	0.000041	0.000035	0.009090	0.000342	0.000331	0.000124	0.000090	0.000014	0.000461	0.000039	0.000321	0.000085	0.000132	0.000032	0.000101	0.000968	0.000261	0.002297	0.000229	0.000245	0.000035	0.002419	0.015502	0.007028	0.003287	0.009218	0.004091	0.009626	0.002595	0.000612	0.002189	0.001906	0.000972	0.003974	0.000202	0.000256	0.004611	0.000187	0.000363	0.004728	0.000995	0.000246	0.000055	0.005178	0.000126	0.000207	0.000566	0.000086
37270864 - Caribou - Our Love - Back Home	37270864	0.027774	0.000361	0.000586	0.002482	0.000136	0.000308	0.000254	0.000101	0.000176	0.000100	0.000128	0.000091	0.000019	0.000021	0.000170	0.000528	0.000256	0.000085	0.000124	0.000071	0.000106	0.000061	0.000325	0.000316	0.000598	0.000125	0.000271	0.032790	0.000194	0.000323	0.000169	0.000333	0.000940	0.001775	0.001392	0.001293	0.002444	0.001012	0.000152	0.000017	0.000171	0.000446	0.000079	0.000055	0.000077	0.000063	0.000110	0.000312	0.000122	0.000396	0.000104	0.000092	0.000029	0.000182	0.000123	0.000098	0.000027	0.000324	0.000093	0.000266	0.000304	0.000127	0.000034	0.000056	0.002619	0.005019	0.000059	0.000014	0.000051	0.000263	0.000087	0.000048	0.002464	0.001771	0.001242	0.000299	0.000208	0.000393	0.000301	0.000075	0.000177	0.000514	0.000086	0.000372	0.000203	0.000077	0.000342	0.000133	0.000126	0.000025	0.000139	0.000136	0.000070	0.000086	0.000156	0.000112	0.000201	0.000170	0.000425	0.000257	0.000110	0.000166	0.000093	0.000094	0.000107	0.000184	0.000124	0.000130	0.000049	0.000034	0.000064	0.000727	0.000230	0.000164	0.000018	0.000134	0.000102	0.000114	0.000119	0.000329	0.000094	0.000017	0.000275	0.000103	0.000130	0.000080	0.000564	0.000099	0.000232	0.000379	0.000651	0.000226	0.000110	0.000047	0.000079	0.000181	0.000113	0.684414	0.030726	0.003109	0.004279	0.001116	0.002363	0.000455	0.000288	0.000190	0.000347	0.000220	0.000235	0.000146	0.000182	0.000334	0.022694	0.014158	0.018527	0.001109	0.001012	0.000399	0.184466	0.081040	0.000359	0.001909	0.003063	0.038509	0.003508	0.001003	0.000781	0.000410	0.001939	0.005172	0.000191	0.000563	0.000480	0.000208	0.000091	0.000101	0.000082	0.001884	0.000109	0.000614	0.000761	0.000898	0.000435	0.000140	0.000991	0.002193	0.000958	0.000766	0.000991	0.000991	0.000147	0.001103	0.000480	0.000503	0.000458	0.000718	0.000362	0.000263	0.000174	0.000269	0.000282	0.000200	0.000344	0.000071	0.000138	0.000148	0.000059	0.000029	0.000546	0.000323	0.000039	0.001524	0.000306	0.006133	0.002298	0.000431	0.019073	0.010773	0.000315	0.006470	0.001239	0.002778	0.003212	0.002337	0.002756	0.001822	0.004963	0.003106	0.003525	0.000897	0.001505	0.000234	0.004418	0.000541	0.001647	0.001776	0.003688	0.001072	0.000201	0.131358	0.011427	0.013072	0.028714	0.051045	0.026167	0.010857	0.078640	0.015121	0.000869	0.000383	0.000086	0.002258	0.002839	0.002113	0.000773	0.000192	0.001891	0.001263	0.001044	0.000430	0.004379	0.000258	0.001033	0.001545	0.000170	0.009208	0.006346	0.004355	0.005249	0.002468	0.010543	0.001004	0.003635	0.000720	0.004284	0.000136	0.000823	0.001518	0.000687	0.001764	0.004023	0.000875	0.001069	0.000179	0.000170	0.000178	0.000137	0.000190	0.000416	0.000130	0.000069	0.000094	0.000101	0.000083	0.000105	0.000081	0.000151	0.000194	0.000053	0.000091	0.003547	0.000298	0.000084	0.000111	0.000103	0.000067	0.000207	0.001131	0.001031	0.000363	0.000077	0.000040	0.000070	0.000090	0.000146	0.000233	0.000135	0.000053	0.000461	0.000029	0.000036	0.000117	0.000113	0.000110	0.000051	0.000037	0.000286	0.000062	0.000401	0.000554	0.000164	0.000228	0.000363	0.000020	0.000105	0.000169	0.000028	0.000042	0.000043	0.000068	0.000111	0.000366	0.000714	0.000255	0.000013	0.000021	0.000033	0.000049	0.000085	0.000061	0.000017	0.000053	0.000065	0.000203	0.000374	0.000143	0.000928	0.000117	0.000114	0.000206	0.000184	0.000133	0.000030	0.000036	0.000177	0.000101	0.000045	0.000076	0.000180	0.000111	0.000125	0.000090	0.000177	0.000035	0.000048	0.000008	0.000036	0.000075	0.000075	0.000269	0.000109	0.000105	0.000302	0.000061	0.000117	0.000079	0.000142	0.000190	0.000673	0.000394	0.000187	0.001747	0.000245	0.000769	0.002409	0.000433	0.000379	0.000112	0.000534	0.000682	0.000544	0.000920	0.000233	0.000111	0.000120	0.000044	0.000176	0.000369	0.000295	0.000037	0.000009	0.000065	0.000137	0.000019	0.000072	0.000120	0.000148	0.000359	0.000335	0.000044	0.000014	0.000035	0.000041	0.000016	0.000135	0.000141	0.000291	0.000370	0.000163	0.000081	0.000068	0.000203	0.000226	0.000159	0.000599	0.000083	0.000087	0.000140	0.000138	0.000012	0.000044	0.000211	0.000208	0.000056	0.000172	0.000061	0.000077	0.000119	0.000214	0.000015	0.000111	0.000105	0.000058	0.000455	0.000036	0.000050	0.000031	0.005439	0.000178	0.000553	0.000140	0.000175	0.001903	0.013555	0.007415	0.000124	0.000179	0.000157	0.000068	0.000064	0.000063	0.000101	0.000073	0.000061	0.000119	0.000082	0.000127	0.001472	0.000015	0.000063	0.000039	0.002853	0.000347	0.000465	0.000218	0.000012	0.000033	0.000410	0.000034	0.000257	0.000094	0.000286	0.000098	0.000452	0.000310	0.000216	0.034943	0.001691	0.000273	0.000072	0.007753	0.002668	0.001799	0.000967	0.006317	0.001232	0.009538	0.003518	0.000763	0.001789	0.001495	0.004310	0.014012	0.000727	0.000091	0.002548	0.002208	0.006489	0.005774	0.000623	0.000793	0.000170	0.054933	0.000207	0.000627	0.000516	0.000061
37270848 - Caribou - Our Love - Second Chance	37270848	0.013056	0.000185	0.000331	0.000780	0.000046	0.000154	0.000100	0.000134	0.000571	0.000346	0.000445	0.000248	0.000011	0.000019	0.000215	0.000472	0.000137	0.000089	0.000133	0.000029	0.000059	0.000037	0.000132	0.000178	0.000358	0.000067	0.000646	0.092847	0.000474	0.001183	0.000106	0.000394	0.004060	0.018780	0.002993	0.001597	0.000280	0.002875	0.000252	0.000028	0.001483	0.000164	0.000024	0.000064	0.000204	0.000012	0.000098	0.000191	0.000105	0.000197	0.000032	0.000041	0.000022	0.000092	0.000076	0.000069	0.000014	0.000224	0.000081	0.000264	0.000088	0.000046	0.000016	0.000065	0.000592	0.001088	0.000098	0.000020	0.000012	0.000405	0.000042	0.000009	0.003178	0.002429	0.001770	0.000612	0.000442	0.000844	0.000579	0.000089	0.000280	0.000395	0.000150	0.000342	0.000107	0.000069	0.000196	0.000081	0.000087	0.000030	0.000052	0.000049	0.000133	0.000063	0.000168	0.000058	0.000144	0.000099	0.000370	0.000237	0.000091	0.000140	0.000111	0.000101	0.000076	0.000144	0.000052	0.000059	0.000056	0.000030	0.000060	0.000722	0.000251	0.000194	0.000047	0.000095	0.000083	0.000159	0.000152	0.000731	0.000238	0.000012	0.000503	0.000114	0.000107	0.000053	0.000465	0.000099	0.000205	0.000204	0.000882	0.000065	0.000188	0.000103	0.000050	0.000338	0.000062	0.820563	0.046962	0.007783	0.012390	0.001344	0.003031	0.003128	0.000716	0.000392	0.001680	0.000253	0.000080	0.000135	0.000113	0.000286	0.012553	0.010835	0.007967	0.000759	0.000656	0.000252	0.070724	0.030485	0.001446	0.005480	0.007538	0.026209	0.008922	0.002621	0.001792	0.001164	0.004252	0.004306	0.000064	0.000760	0.000657	0.000412	0.000097	0.000122	0.000101	0.000205	0.000091	0.000332	0.000559	0.000423	0.000285	0.000112	0.002574	0.001659	0.000782	0.000836	0.000590	0.001380	0.000225	0.001243	0.000584	0.000777	0.000626	0.001765	0.001410	0.000312	0.000286	0.000247	0.000176	0.000061	0.000831	0.000102	0.000156	0.000076	0.000030	0.000016	0.001010	0.000342	0.000059	0.000182	0.000429	0.007303	0.000639	0.000231	0.057228	0.001986	0.000220	0.009133	0.001224	0.002435	0.004186	0.004283	0.008435	0.003878	0.019055	0.012487	0.000877	0.010925	0.001106	0.001873	0.005666	0.000814	0.002028	0.005345	0.004466	0.002074	0.001045	0.079093	0.018637	0.013879	0.010532	0.003419	0.016572	0.013217	0.006172	0.015052	0.002467	0.000539	0.000341	0.009559	0.014966	0.004499	0.001923	0.000296	0.000669	0.000605	0.007367	0.004538	0.011004	0.000169	0.000111	0.003092	0.000480	0.073003	0.020521	0.012556	0.013874	0.009173	0.021394	0.022333	0.008210	0.009355	0.009052	0.001599	0.010205	0.002181	0.005065	0.019074	0.016292	0.000059	0.000451	0.000067	0.000184	0.000066	0.000033	0.000046	0.000118	0.000044	0.000044	0.000041	0.000042	0.000017	0.000033	0.000027	0.000050	0.000097	0.000026	0.000081	0.001273	0.000118	0.000029	0.000047	0.000048	0.000029	0.000087	0.000328	0.000436	0.000089	0.000192	0.000004	0.000018	0.000024	0.000064	0.000054	0.000107	0.000020	0.000400	0.000015	0.000024	0.000029	0.000208	0.000178	0.000083	0.000078	0.000100	0.000021	0.000067	0.000102	0.000031	0.000031	0.000067	0.000002	0.000015	0.000101	0.000012	0.000024	0.000027	0.000048	0.000064	0.000141	0.000067	0.000111	0.000002	0.000013	0.000008	0.000006	0.000043	0.000044	0.000004	0.000020	0.000039	0.000111	0.000138	0.000133	0.000319	0.000039	0.000048	0.000124	0.000187	0.000275	0.000003	0.000012	0.000033	0.000019	0.000014	0.000028	0.000083	0.000010	0.000035	0.000026	0.000036	0.000003	0.000022	0.000003	0.000015	0.000008	0.000078	0.000098	0.000027	0.000052	0.000078	0.000006	0.000077	0.000018	0.000091	0.000088	0.001726	0.000275	0.000114	0.000902	0.000063	0.000635	0.004108	0.000448	0.001150	0.000319	0.000929	0.002296	0.002962	0.000276	0.002858	0.000049	0.000051	0.000019	0.000091	0.000240	0.000209	0.000016	0.000007	0.000007	0.000036	0.000005	0.000009	0.000032	0.000083	0.000327	0.000072	0.000021	0.000002	0.000005	0.000006	0.000001	0.000026	0.000039	0.000207	0.000128	0.000033	0.000018	0.000042	0.000067	0.000093	0.000056	0.000762	0.000049	0.000029	0.000023	0.000032	0.000000	0.000018	0.000051	0.000105	0.000025	0.000082	0.000014	0.000026	0.000118	0.000177	0.000013	0.000057	0.000018	0.000033	0.000269	0.000007	0.000014	0.000012	0.001334	0.000103	0.000461	0.000095	0.000318	0.001374	0.001845	0.001234	0.000017	0.000376	0.000127	0.000073	0.000033	0.000025	0.000078	0.000045	0.000081	0.000055	0.000049	0.000019	0.004416	0.000004	0.000021	0.000017	0.003962	0.000278	0.000552	0.000141	0.000019	0.000007	0.000603	0.000031	0.000299	0.000058	0.000365	0.000012	0.000199	0.000880	0.000503	0.002250	0.002174	0.000802	0.000037	0.006697	0.017561	0.004005	0.004593	0.006407	0.000717	0.006428	0.004326	0.000707	0.001017	0.000775	0.001815	0.008711	0.000424	0.000082	0.000646	0.000337	0.001232	0.001346	0.000551	0.000401	0.000042	0.003112	0.000117	0.000392	0.000212	0.000139
37270840 - Caribou - Our Love - Dive	37270840	0.021818	0.000408	0.000235	0.000385	0.000086	0.000242	0.000077	0.000137	0.000112	0.000076	0.000117	0.000045	0.000022	0.000022	0.000077	0.000123	0.000273	0.000080	0.000110	0.000127	0.000087	0.000097	0.000166	0.000180	0.000347	0.000021	0.000144	0.005014	0.000165	0.000089	0.000136	0.000253	0.000193	0.000269	0.000115	0.000250	0.011013	0.000289	0.000084	0.000022	0.000174	0.000268	0.000052	0.000078	0.000101	0.000050	0.000125	0.000206	0.000118	0.000188	0.000095	0.000087	0.000085	0.000132	0.000042	0.000059	0.000031	0.000171	0.000097	0.000256	0.000132	0.000046	0.000018	0.000027	0.001290	0.002248	0.000059	0.000016	0.000051	0.000249	0.000082	0.000026	0.002328	0.001370	0.001027	0.000209	0.000254	0.000243	0.000345	0.000079	0.000252	0.000366	0.000061	0.000211	0.000150	0.000070	0.000210	0.000139	0.000107	0.000037	0.000081	0.000078	0.000019	0.000045	0.000129	0.000076	0.000160	0.000151	0.000637	0.000297	0.000147	0.000189	0.000266	0.000276	0.000147	0.000197	0.000100	0.000098	0.000074	0.000061	0.000121	0.000729	0.000272	0.000192	0.000011	0.000123	0.000117	0.000131	0.000112	0.000351	0.000082	0.000009	0.000206	0.000072	0.000122	0.000039	0.000594	0.000099	0.000147	0.000350	0.000844	0.000283	0.000382	0.000134	0.000062	0.000221	0.000126	0.753244	0.037406	0.002662	0.003085	0.000699	0.001737	0.000308	0.000136	0.000133	0.000237	0.000102	0.000253	0.000084	0.000120	0.000098	0.025047	0.016104	0.018106	0.001949	0.001467	0.000738	0.134747	0.063030	0.000484	0.001091	0.001748	0.043804	0.002859	0.000473	0.000340	0.000201	0.001156	0.000642	0.000117	0.000303	0.000265	0.000170	0.000037	0.000049	0.000049	0.002192	0.000099	0.000647	0.000945	0.000886	0.000430	0.000075	0.000386	0.000698	0.000208	0.000261	0.000240	0.000774	0.000103	0.000899	0.000350	0.000338	0.000283	0.001122	0.001018	0.000213	0.000184	0.000354	0.000253	0.000212	0.000109	0.000040	0.000107	0.000276	0.000127	0.000041	0.000257	0.000181	0.000083	0.006580	0.000208	0.008215	0.002348	0.005698	0.007558	0.071861	0.001119	0.002949	0.000953	0.000941	0.000529	0.000944	0.000506	0.000441	0.004171	0.001675	0.002397	0.000278	0.000309	0.000091	0.002644	0.000362	0.001106	0.001522	0.001816	0.000854	0.000159	0.196181	0.012875	0.009388	0.056368	0.076613	0.032401	0.011890	0.075979	0.008718	0.000522	0.000247	0.000085	0.001117	0.000250	0.002657	0.000707	0.000077	0.001595	0.001469	0.000477	0.000394	0.001033	0.000220	0.000440	0.000332	0.000220	0.002483	0.001729	0.002852	0.002771	0.000582	0.006676	0.000406	0.001379	0.000276	0.002610	0.000116	0.000302	0.000465	0.000584	0.001595	0.001863	0.000502	0.001027	0.000374	0.000177	0.000347	0.000140	0.000158	0.000339	0.000123	0.000081	0.000086	0.000121	0.000076	0.000207	0.000155	0.000096	0.000219	0.000070	0.000078	0.004454	0.000520	0.000131	0.000174	0.000185	0.000118	0.000383	0.001679	0.000317	0.000176	0.000158	0.000051	0.000109	0.000187	0.000182	0.000317	0.000288	0.000071	0.000089	0.000056	0.000090	0.000114	0.000330	0.000240	0.000158	0.000103	0.000431	0.000163	0.000387	0.000486	0.000119	0.000201	0.000364	0.000023	0.000092	0.000241	0.000047	0.000031	0.000107	0.000084	0.000151	0.000353	0.000880	0.000308	0.000031	0.000008	0.000081	0.000047	0.000155	0.000082	0.000018	0.000074	0.000100	0.000330	0.000385	0.000076	0.000539	0.000173	0.000218	0.000095	0.000120	0.000038	0.000033	0.000043	0.000115	0.000050	0.000042	0.000075	0.000403	0.000058	0.000082	0.000053	0.000078	0.000043	0.000047	0.000007	0.000033	0.000117	0.000073	0.000117	0.000037	0.000026	0.000480	0.000036	0.000049	0.000028	0.000068	0.000111	0.000247	0.000362	0.000180	0.003564	0.000304	0.001128	0.000774	0.000203	0.000699	0.000210	0.000362	0.000293	0.000130	0.000207	0.000286	0.000086	0.000140	0.000039	0.000147	0.000395	0.000364	0.000031	0.000005	0.000053	0.000229	0.000075	0.000055	0.000168	0.000090	0.000290	0.000311	0.000060	0.000009	0.000052	0.000069	0.000014	0.000121	0.000084	0.000224	0.000132	0.000083	0.000039	0.000034	0.000054	0.000126	0.000054	0.000449	0.000068	0.000079	0.000249	0.000494	0.000012	0.000020	0.000089	0.000140	0.000019	0.000218	0.000040	0.000073	0.000212	0.000492	0.000018	0.000194	0.000112	0.000080	0.000380	0.000096	0.000037	0.000033	0.006330	0.000204	0.000968	0.000133	0.000045	0.001130	0.008603	0.002865	0.000389	0.000058	0.000172	0.000054	0.000038	0.000017	0.000217	0.000045	0.000142	0.000808	0.000120	0.000150	0.000381	0.000008	0.000016	0.000008	0.000999	0.000419	0.000156	0.000033	0.000012	0.000016	0.000493	0.000031	0.000287	0.000088	0.000103	0.000120	0.000527	0.000384	0.000188	0.037135	0.001277	0.000114	0.000030	0.006153	0.000782	0.001706	0.000307	0.007085	0.007509	0.006054	0.002571	0.000540	0.001887	0.001393	0.003147	0.006918	0.000303	0.000101	0.003686	0.003420	0.003188	0.003507	0.000583	0.000708	0.000191	0.039215	0.000314	0.000400	0.000509	0.000055
37270876 - Caribou - Our Love - Your Love Will Set You Free	37270876	0.023827	0.000374	0.000254	0.000350	0.000088	0.000228	0.000074	0.000051	0.000109	0.000085	0.000135	0.000038	0.000014	0.000017	0.000095	0.000119	0.000169	0.000051	0.000076	0.000062	0.000047	0.000086	0.000062	0.000076	0.000085	0.000036	0.000092	0.006661	0.000232	0.000145	0.000094	0.000164	0.000540	0.000383	0.000142	0.000201	0.001154	0.000128	0.000126	0.000016	0.000087	0.000100	0.000012	0.000056	0.000056	0.000029	0.000073	0.000054	0.000043	0.000105	0.000029	0.000053	0.000032	0.000075	0.000050	0.000060	0.000008	0.000072	0.000041	0.000070	0.000073	0.000060	0.000064	0.000065	0.000362	0.000963	0.000055	0.000027	0.000036	0.000243	0.000073	0.000013	0.001265	0.000818	0.000654	0.000101	0.000143	0.000260	0.000211	0.000058	0.000106	0.000182	0.000054	0.000150	0.000136	0.000034	0.000123	0.000092	0.000088	0.000030	0.000048	0.000047	0.000059	0.000025	0.000067	0.000044	0.000121	0.000098	0.000240	0.000146	0.000085	0.000105	0.000055	0.000048	0.000061	0.000117	0.000040	0.000039	0.000071	0.000065	0.000168	0.000400	0.000162	0.000139	0.000005	0.000105	0.000076	0.000040	0.000039	0.000042	0.000017	0.000012	0.000161	0.000029	0.000078	0.000033	0.000321	0.000077	0.000130	0.000194	0.000597	0.000097	0.000065	0.000030	0.000094	0.000462	0.000047	0.861389	0.092075	0.005033	0.005173	0.000852	0.001690	0.000501	0.000186	0.000393	0.000413	0.000529	0.000297	0.000579	0.000215	0.000582	0.043135	0.024937	0.022294	0.001750	0.002472	0.000631	0.382216	0.168959	0.000843	0.002062	0.001819	0.184932	0.003847	0.000417	0.000275	0.000187	0.000915	0.000252	0.000236	0.000312	0.000283	0.000734	0.000071	0.000542	0.000266	0.000162	0.000129	0.000892	0.001646	0.001132	0.000636	0.000375	0.000672	0.000773	0.000173	0.000437	0.000216	0.001620	0.000118	0.001523	0.001125	0.000328	0.000274	0.001528	0.000552	0.000268	0.000400	0.000852	0.000123	0.000060	0.000211	0.000032	0.000040	0.000202	0.000100	0.000030	0.000424	0.000499	0.000234	0.000671	0.000159	0.009043	0.000362	0.002573	0.008561	0.015318	0.000164	0.002364	0.000460	0.000423	0.000225	0.000741	0.000501	0.000328	0.003887	0.002259	0.005911	0.001271	0.000996	0.000529	0.007291	0.000720	0.001583	0.002496	0.009560	0.001015	0.000134	0.284118	0.072755	0.053115	0.032361	0.026624	0.084656	0.027140	0.006420	0.048421	0.001948	0.000946	0.000296	0.001629	0.001828	0.001019	0.000466	0.000156	0.003986	0.002556	0.000763	0.000748	0.001188	0.000212	0.000369	0.000635	0.000507	0.003200	0.001808	0.005258	0.004587	0.002810	0.014376	0.000418	0.010485	0.000607	0.006608	0.000150	0.001704	0.005844	0.000190	0.001365	0.004756	0.000051	0.000294	0.000135	0.000107	0.000133	0.000059	0.000072	0.000238	0.000066	0.000060	0.000063	0.000057	0.000026	0.000059	0.000048	0.000074	0.000147	0.000042	0.000122	0.002194	0.000181	0.000059	0.000068	0.000079	0.000025	0.000195	0.000681	0.000341	0.000088	0.000160	0.000018	0.000037	0.000041	0.000078	0.000097	0.000221	0.000054	0.000383	0.000031	0.000052	0.000072	0.000489	0.000382	0.000151	0.000202	0.000148	0.000048	0.000201	0.000279	0.000066	0.000123	0.000190	0.000010	0.000056	0.000189	0.000033	0.000059	0.000060	0.000121	0.000131	0.000332	0.000155	0.000180	0.000009	0.000019	0.000032	0.000024	0.000090	0.000049	0.000017	0.000058	0.000067	0.000181	0.000207	0.000086	0.000609	0.000118	0.000061	0.000075	0.000163	0.000038	0.000010	0.000035	0.000088	0.000046	0.000023	0.000071	0.000067	0.000061	0.000134	0.000103	0.000061	0.000030	0.000064	0.000011	0.000036	0.000081	0.000095	0.000290	0.000040	0.000040	0.000226	0.000035	0.000127	0.000041	0.000207	0.000102	0.000979	0.000479	0.000199	0.009264	0.000225	0.001158	0.001212	0.000282	0.001605	0.000293	0.000527	0.000632	0.000413	0.000077	0.000148	0.000054	0.000133	0.000059	0.000085	0.000342	0.000241	0.000053	0.000011	0.000039	0.000091	0.000026	0.000035	0.000076	0.000089	0.000164	0.000170	0.000013	0.000007	0.000017	0.000027	0.000011	0.000057	0.000076	0.000196	0.000151	0.000069	0.000025	0.000034	0.000049	0.000059	0.000030	0.000393	0.000076	0.000055	0.000110	0.000086	0.000005	0.000023	0.000115	0.000319	0.000034	0.000260	0.000012	0.000029	0.000322	0.000622	0.000019	0.000087	0.000072	0.000110	0.000302	0.000031	0.000038	0.000040	0.001515	0.000054	0.000618	0.000053	0.000094	0.000963	0.004020	0.000953	0.000034	0.000044	0.000101	0.000037	0.000047	0.000035	0.000018	0.000034	0.000053	0.000218	0.000136	0.000073	0.000572	0.000003	0.000039	0.000024	0.002252	0.000623	0.000320	0.000033	0.000014	0.000007	0.000493	0.000053	0.000333	0.000095	0.000115	0.000048	0.000509	0.000440	0.000598	0.007355	0.001044	0.000276	0.000028	0.003480	0.002280	0.004970	0.000530	0.012488	0.001160	0.009952	0.003467	0.000577	0.001210	0.001067	0.001550	0.007169	0.000410	0.000074	0.003570	0.000758	0.001214	0.005411	0.002163	0.000410	0.000042	0.015365	0.000199	0.000718	0.000624	0.000034
37270832 - Caribou - Our Love - Our Love	37270832	0.022328	0.000257	0.000200	0.000421	0.000062	0.000162	0.000106	0.000088	0.000133	0.000070	0.000105	0.000066	0.000010	0.000035	0.000181	0.000171	0.000194	0.000073	0.000085	0.000058	0.000064	0.000038	0.000192	0.000201	0.000128	0.000031	0.000212	0.007594	0.000147	0.000106	0.000091	0.000167	0.000334	0.000319	0.000086	0.000129	0.000546	0.000227	0.000221	0.000016	0.000311	0.000123	0.000045	0.000132	0.000045	0.000016	0.000082	0.000088	0.000036	0.000134	0.000063	0.000056	0.000006	0.000089	0.000126	0.000068	0.000002	0.000098	0.000064	0.000092	0.000120	0.000013	0.000013	0.000014	0.001275	0.003959	0.000082	0.000008	0.000030	0.000271	0.000053	0.000019	0.002202	0.001377	0.000971	0.000218	0.000177	0.000447	0.000208	0.000116	0.000150	0.000288	0.000080	0.000204	0.000116	0.000058	0.000302	0.000113	0.000084	0.000052	0.000094	0.000098	0.000089	0.000044	0.000047	0.000126	0.000178	0.000156	0.000604	0.000436	0.000228	0.000292	0.000138	0.000130	0.000144	0.000166	0.000126	0.000110	0.000066	0.000046	0.000118	0.001026	0.000448	0.000444	0.000016	0.000090	0.000077	0.000107	0.000103	0.000168	0.000044	0.000025	0.000293	0.000094	0.000133	0.000057	0.000895	0.000323	0.000389	0.000498	0.000429	0.000203	0.000218	0.000071	0.000068	0.000353	0.000024	0.781154	0.034441	0.001712	0.002251	0.000445	0.001118	0.000270	0.000092	0.000069	0.000203	0.000094	0.000059	0.000088	0.000059	0.000090	0.007133	0.004336	0.004202	0.000331	0.000242	0.000131	0.076145	0.226130	0.000123	0.000966	0.003082	0.386967	0.004700	0.000792	0.000580	0.000300	0.002429	0.000426	0.000058	0.000482	0.000491	0.000104	0.000062	0.000046	0.000037	0.000201	0.000112	0.000504	0.000644	0.000671	0.000147	0.000019	0.000426	0.000647	0.000184	0.000357	0.000197	0.000508	0.000048	0.000731	0.000220	0.000247	0.000179	0.000889	0.000656	0.000085	0.000204	0.000166	0.000456	0.000259	0.000170	0.000113	0.000153	0.000681	0.000552	0.000048	0.000130	0.000056	0.000075	0.000198	0.000265	0.001555	0.000774	0.002332	0.016466	0.017275	0.000140	0.003253	0.000565	0.001007	0.000557	0.000814	0.000963	0.000343	0.006503	0.002310	0.002445	0.000374	0.000649	0.000123	0.010680	0.000270	0.000821	0.001265	0.035920	0.000650	0.000234	0.292399	0.114065	0.064288	0.030249	0.118510	0.079717	0.027623	0.003507	0.044538	0.000441	0.000081	0.000060	0.001365	0.000376	0.000571	0.000410	0.000109	0.001236	0.001526	0.000509	0.000445	0.000939	0.000157	0.000426	0.000383	0.000121	0.002602	0.003661	0.002305	0.002059	0.000656	0.007147	0.000299	0.000946	0.000331	0.017193	0.000074	0.000800	0.000676	0.000213	0.000738	0.005812	0.000046	0.000123	0.000202	0.000068	0.000181	0.000048	0.000053	0.000259	0.000048	0.000037	0.000038	0.000057	0.000025	0.000053	0.000042	0.000079	0.000111	0.000056	0.000074	0.002914	0.000244	0.000044	0.000110	0.000101	0.000044	0.000235	0.000949	0.000261	0.000131	0.000334	0.000036	0.000034	0.000044	0.000084	0.000099	0.000197	0.000044	0.000169	0.000050	0.000038	0.000068	0.000459	0.000515	0.000237	0.000154	0.000232	0.000061	0.000178	0.000262	0.000073	0.000097	0.000172	0.000009	0.000028	0.000143	0.000025	0.000040	0.000038	0.000059	0.000101	0.000191	0.000049	0.000192	0.000011	0.000026	0.000048	0.000029	0.000074	0.000044	0.000013	0.000072	0.000058	0.000159	0.000191	0.000146	0.000491	0.000096	0.000072	0.000061	0.000070	0.000102	0.000013	0.000023	0.000091	0.000061	0.000011	0.000044	0.000139	0.000026	0.000097	0.000073	0.000038	0.000014	0.000034	0.000004	0.000039	0.000029	0.000041	0.000527	0.000088	0.000051	0.000158	0.000024	0.000164	0.000033	0.000203	0.000098	0.002452	0.000469	0.000310	0.001414	0.000256	0.001557	0.001923	0.000811	0.001497	0.000345	0.001509	0.003035	0.003295	0.000126	0.000705	0.000059	0.000156	0.000065	0.000322	0.000339	0.000281	0.000062	0.000020	0.000026	0.000051	0.000018	0.000055	0.000051	0.000068	0.000113	0.000257	0.000024	0.000008	0.000017	0.000032	0.000005	0.000084	0.000093	0.000221	0.000207	0.000068	0.000039	0.000037	0.000093	0.000066	0.000043	0.000514	0.000052	0.000039	0.000098	0.000091	0.000004	0.000024	0.000358	0.000267	0.000063	0.000255	0.000023	0.000048	0.000086	0.000505	0.000035	0.000084	0.000055	0.000104	0.000197	0.000032	0.000017	0.000023	0.000550	0.000095	0.000495	0.000072	0.000097	0.000933	0.003157	0.001193	0.000085	0.000034	0.000050	0.000041	0.000029	0.000070	0.000038	0.000019	0.000038	0.000218	0.000086	0.000068	0.000901	0.000007	0.000044	0.000035	0.003230	0.000151	0.000478	0.000118	0.000013	0.000016	0.000326	0.000028	0.000226	0.000050	0.000371	0.000031	0.000267	0.000286	0.000226	0.016019	0.001251	0.000225	0.000046	0.003608	0.006209	0.001181	0.001697	0.007294	0.003498	0.007343	0.002135	0.000323	0.001482	0.001672	0.000997	0.005183	0.000342	0.000249	0.005212	0.000735	0.001385	0.006333	0.000402	0.000254	0.000032	0.028963	0.000207	0.000268	0.000274	0.000035
37270826 - Caribou - Our Love - All I Ever Need	37270826	0.029051	0.000365	0.000520	0.000633	0.000135	0.000331	0.000118	0.000093	0.000286	0.000150	0.000236	0.000114	0.000066	0.000065	0.000408	0.000235	0.000252	0.000085	0.000096	0.000094	0.000060	0.000100	0.000164	0.000153	0.000205	0.000058	0.000267	0.027822	0.000219	0.000168	0.000144	0.000199	0.000841	0.000963	0.000225	0.000222	0.002313	0.000413	0.000277	0.000018	0.000199	0.000117	0.000023	0.000061	0.000086	0.000044	0.000079	0.000109	0.000046	0.000154	0.000028	0.000071	0.000018	0.000097	0.000097	0.000049	0.000014	0.000052	0.000095	0.000095	0.000144	0.000030	0.000026	0.000048	0.001039	0.003202	0.000196	0.000031	0.000048	0.000636	0.000078	0.000024	0.002628	0.001749	0.001360	0.000267	0.000247	0.000770	0.000309	0.000107	0.000197	0.000265	0.000084	0.000151	0.000160	0.000053	0.000180	0.000110	0.000094	0.000038	0.000056	0.000054	0.000098	0.000049	0.000072	0.000082	0.000203	0.000144	0.000396	0.000263	0.000136	0.000196	0.000095	0.000086	0.000121	0.000178	0.000086	0.000082	0.000059	0.000043	0.000127	0.000812	0.000331	0.000306	0.000033	0.000085	0.000072	0.000125	0.000118	0.000283	0.000061	0.000012	0.000330	0.000147	0.000233	0.000057	0.000400	0.000129	0.000122	0.000202	0.000448	0.000115	0.000220	0.000064	0.000056	0.000376	0.000026	0.789289	0.044641	0.002329	0.002954	0.000535	0.000992	0.000561	0.000095	0.000132	0.000365	0.000113	0.000131	0.000104	0.000133	0.000188	0.007135	0.004670	0.004929	0.000244	0.000179	0.000099	0.161198	0.136679	0.000212	0.002158	0.005099	0.524267	0.007873	0.001204	0.000918	0.000316	0.003391	0.000469	0.000079	0.000655	0.000647	0.000418	0.000080	0.000047	0.000049	0.000167	0.000124	0.000811	0.001223	0.001181	0.000359	0.000061	0.000407	0.000605	0.000212	0.000386	0.000163	0.000583	0.000051	0.000585	0.000443	0.000205	0.000163	0.001224	0.000755	0.000267	0.000263	0.000248	0.000228	0.000129	0.000154	0.000119	0.000127	0.000268	0.000183	0.000039	0.000267	0.000081	0.000172	0.000065	0.000449	0.001478	0.000346	0.000672	0.032375	0.034597	0.000135	0.001689	0.000436	0.001145	0.000500	0.000616	0.000914	0.000184	0.032001	0.005986	0.008092	0.000418	0.000604	0.000145	0.012393	0.000436	0.002288	0.003762	0.014091	0.000609	0.000138	0.118325	0.051440	0.023925	0.023400	0.010986	0.053781	0.015587	0.003734	0.009949	0.000993	0.000225	0.000134	0.003380	0.000893	0.001003	0.000500	0.000147	0.007164	0.013899	0.000767	0.000915	0.003021	0.000188	0.000385	0.000485	0.000232	0.006185	0.006016	0.002346	0.002429	0.000872	0.006648	0.001402	0.000486	0.000571	0.017653	0.000104	0.001811	0.000630	0.000441	0.002615	0.007372	0.000026	0.000078	0.000133	0.000107	0.000117	0.000048	0.000059	0.000293	0.000069	0.000059	0.000056	0.000073	0.000039	0.000062	0.000053	0.000123	0.000153	0.000053	0.000079	0.003216	0.000202	0.000049	0.000070	0.000095	0.000037	0.000309	0.001008	0.000548	0.000127	0.000361	0.000030	0.000067	0.000072	0.000140	0.000175	0.000307	0.000104	0.000454	0.000046	0.000049	0.000118	0.001000	0.000628	0.000429	0.000341	0.000151	0.000071	0.000301	0.000412	0.000111	0.000178	0.000262	0.000017	0.000072	0.000201	0.000030	0.000086	0.000043	0.000101	0.000130	0.000330	0.000162	0.000261	0.000015	0.000044	0.000036	0.000027	0.000082	0.000053	0.000012	0.000071	0.000052	0.000196	0.000288	0.000158	0.000800	0.000144	0.000139	0.000142	0.000130	0.000299	0.000011	0.000021	0.000126	0.000086	0.000014	0.000041	0.000203	0.000073	0.000086	0.000057	0.000062	0.000055	0.000060	0.000004	0.000074	0.000088	0.000076	0.000340	0.000045	0.000070	0.000224	0.000015	0.000081	0.000020	0.000104	0.000094	0.003364	0.000456	0.000351	0.006862	0.000201	0.002050	0.001436	0.000732	0.002588	0.000341	0.003552	0.005942	0.006407	0.000063	0.000717	0.000104	0.000149	0.000064	0.000197	0.000344	0.000231	0.000049	0.000016	0.000028	0.000027	0.000022	0.000044	0.000090	0.000087	0.000109	0.000344	0.000029	0.000008	0.000035	0.000044	0.000009	0.000157	0.000175	0.000359	0.000235	0.000077	0.000024	0.000066	0.000062	0.000174	0.000088	0.000861	0.000074	0.000066	0.000156	0.000239	0.000005	0.000026	0.000320	0.000400	0.000070	0.000329	0.000025	0.000067	0.000173	0.000976	0.000031	0.000163	0.000064	0.000117	0.000459	0.000041	0.000018	0.000036	0.000589	0.000071	0.000557	0.000077	0.000054	0.001763	0.003063	0.001056	0.000301	0.000081	0.000188	0.000043	0.000050	0.000053	0.000064	0.000033	0.000040	0.000106	0.000089	0.000098	0.000704	0.000003	0.000026	0.000013	0.003236	0.000420	0.000738	0.000201	0.000037	0.000020	0.000273	0.000044	0.000237	0.000045	0.000180	0.000054	0.000124	0.000378	0.000329	0.004260	0.003883	0.000191	0.000028	0.003357	0.005920	0.003332	0.002216	0.007128	0.006340	0.008077	0.002910	0.000602	0.001466	0.001237	0.001375	0.007217	0.000206	0.000111	0.003192	0.000362	0.001003	0.002603	0.000354	0.000433	0.000059	0.005543	0.000144	0.000274	0.000196	0.000026
121423026 - Caribou - Suddenly - Sister	121423026	0.075799	0.000439	0.000343	0.001171	0.000081	0.000179	0.000154	0.000076	0.000184	0.000107	0.000137	0.000150	0.000011	0.000024	0.000677	0.000385	0.000232	0.000135	0.000115	0.000071	0.000084	0.000080	0.000514	0.000363	0.000425	0.000054	0.000171	0.036556	0.000126	0.000270	0.000069	0.000223	0.001700	0.001533	0.000432	0.000367	0.000824	0.001391	0.000347	0.000034	0.000315	0.000190	0.000043	0.000077	0.000067	0.000028	0.000065	0.000334	0.000088	0.000318	0.000050	0.000022	0.000009	0.000039	0.000054	0.000068	0.000005	0.000041	0.000142	0.000135	0.000105	0.000020	0.000015	0.000031	0.000057	0.000282	0.000069	0.000013	0.000022	0.000256	0.000062	0.000014	0.004700	0.003496	0.002602	0.000324	0.000506	0.001546	0.000337	0.000166	0.000349	0.000442	0.000076	0.000284	0.000173	0.000104	0.000350	0.000060	0.000052	0.000024	0.000059	0.000057	0.000074	0.000080	0.000081	0.000164	0.000179	0.000158	0.000739	0.000527	0.000202	0.000783	0.000100	0.000080	0.000103	0.000140	0.000119	0.000113	0.000038	0.000029	0.000090	0.000967	0.000378	0.000272	0.000024	0.000093	0.000078	0.000187	0.000191	0.000193	0.000046	0.000017	0.001010	0.000108	0.000104	0.000044	0.000257	0.000135	0.000055	0.000104	0.000212	0.000068	0.000100	0.000037	0.000074	0.000094	0.000023	0.786615	0.163248	0.003829	0.004626	0.000668	0.001963	0.000842	0.000397	0.000314	0.000356	0.000086	0.000033	0.000110	0.000099	0.000537	0.178450	0.118493	0.175512	0.001500	0.002360	0.000384	0.704208	0.040714	0.000523	0.001007	0.000488	0.011097	0.000871	0.000160	0.000110	0.000053	0.000267	0.000041	0.000019	0.000140	0.000127	0.000055	0.000029	0.000066	0.000030	0.000336	0.000181	0.001523	0.002369	0.002533	0.000945	0.000080	0.000214	0.000536	0.000204	0.000270	0.000091	0.000906	0.000071	0.000569	0.000582	0.000210	0.000157	0.001134	0.001179	0.000310	0.000485	0.001098	0.000196	0.000051	0.000039	0.000030	0.000102	0.000220	0.000111	0.000010	0.000359	0.000167	0.000050	0.000077	0.000211	0.017499	0.003636	0.000160	0.002554	0.003537	0.000128	0.000806	0.000279	0.000379	0.000192	0.000237	0.000218	0.000064	0.001691	0.001285	0.000520	0.000439	0.000068	0.000111	0.000349	0.000448	0.000598	0.001098	0.000269	0.001149	0.000086	0.051303	0.004787	0.002471	0.007527	0.000919	0.004112	0.001877	0.010832	0.002087	0.000238	0.000051	0.000045	0.001118	0.002212	0.003208	0.000884	0.000152	0.000534	0.000257	0.000601	0.000717	0.001076	0.000089	0.000065	0.000109	0.000340	0.005407	0.003116	0.001566	0.002076	0.000427	0.003209	0.008502	0.001020	0.000427	0.000589	0.000338	0.000539	0.000565	0.001623	0.003310	0.000420	0.000024	0.000041	0.000070	0.000118	0.000069	0.000041	0.000049	0.000243	0.000072	0.000045	0.000055	0.000065	0.000057	0.000030	0.000025	0.000109	0.000093	0.000034	0.000037	0.001274	0.000094	0.000027	0.000033	0.000040	0.000008	0.000115	0.000397	0.000224	0.000034	0.000042	0.000006	0.000019	0.000019	0.000049	0.000074	0.000150	0.000048	0.000150	0.000014	0.000091	0.000065	0.000289	0.000165	0.000121	0.000096	0.000056	0.000023	0.000193	0.000268	0.000052	0.000052	0.000183	0.000006	0.000031	0.000133	0.000020	0.000031	0.000034	0.000044	0.000091	0.000070	0.000027	0.000189	0.000011	0.000037	0.000027	0.000018	0.000063	0.000052	0.000008	0.000020	0.000052	0.000122	0.000155	0.000189	0.000484	0.000045	0.000037	0.000069	0.000064	0.000421	0.000011	0.000017	0.000055	0.000039	0.000006	0.000040	0.000034	0.000018	0.000058	0.000040	0.000074	0.000012	0.000017	0.000002	0.000017	0.000023	0.000043	0.000084	0.000020	0.000029	0.000049	0.000007	0.000104	0.000009	0.000157	0.000133	0.000986	0.000421	0.000231	0.002995	0.000131	0.008831	0.004888	0.000236	0.000737	0.000069	0.000297	0.000454	0.000462	0.000026	0.000358	0.000060	0.000076	0.000043	0.000087	0.000139	0.000122	0.000030	0.000012	0.000017	0.000029	0.000008	0.000021	0.000042	0.000063	0.000081	0.000176	0.000008	0.000004	0.000020	0.000028	0.000008	0.000085	0.000093	0.000185	0.000107	0.000031	0.000019	0.000023	0.000039	0.000060	0.000044	0.000310	0.000035	0.000031	0.000136	0.000035	0.000003	0.000012	0.000233	0.000128	0.000070	0.000097	0.000019	0.000040	0.000034	0.000070	0.000014	0.000037	0.000032	0.000030	0.000150	0.000017	0.000023	0.000023	0.001221	0.000038	0.000179	0.000026	0.000039	0.022285	0.007066	0.000985	0.000016	0.000040	0.000075	0.000035	0.000020	0.000049	0.000028	0.000018	0.000038	0.000037	0.000067	0.000092	0.000127	0.000005	0.000033	0.000031	0.004320	0.000412	0.000252	0.000108	0.000031	0.000004	0.000298	0.000021	0.000124	0.000065	0.000188	0.000032	0.000045	0.000185	0.000189	0.000344	0.000098	0.000147	0.000045	0.004972	0.035098	0.012870	0.005824	0.004287	0.000185	0.023781	0.003936	0.000430	0.001334	0.001233	0.003177	0.002529	0.001146	0.000162	0.000282	0.000084	0.001915	0.005365	0.001077	0.000776	0.000070	0.000176	0.000140	0.000253	0.000249	0.000025
121423030 - Caribou - Suddenly - Home	121423030	0.043229	0.000477	0.000507	0.001743	0.000136	0.000352	0.000199	0.000125	0.000353	0.000262	0.000324	0.000269	0.000029	0.000079	0.000974	0.000627	0.000560	0.000239	0.000301	0.000170	0.000260	0.000121	0.000651	0.000834	0.000975	0.000251	0.000495	0.070138	0.000139	0.000584	0.000100	0.000199	0.001472	0.000926	0.000368	0.000864	0.023356	0.000536	0.000674	0.000049	0.001606	0.000447	0.000146	0.000084	0.000449	0.000047	0.000176	0.000630	0.000433	0.000543	0.000258	0.000157	0.000026	0.000192	0.000304	0.000219	0.000016	0.000559	0.000152	0.000606	0.000136	0.000125	0.000059	0.000132	0.003707	0.002012	0.000182	0.000024	0.000076	0.000568	0.000142	0.000072	0.005995	0.004462	0.003362	0.000850	0.000877	0.001209	0.001290	0.000188	0.000684	0.000663	0.000124	0.000471	0.000155	0.000162	0.000510	0.000365	0.000318	0.000140	0.000140	0.000130	0.001953	0.000241	0.000480	0.000229	0.000496	0.000417	0.001122	0.000659	0.000333	0.000493	0.000335	0.000303	0.000234	0.000519	0.000282	0.000323	0.000076	0.000053	0.000111	0.001332	0.000556	0.000473	0.000043	0.000216	0.000180	0.000174	0.000217	0.000651	0.000184	0.000020	0.000897	0.000253	0.000349	0.000119	0.000744	0.000317	0.000461	0.000323	0.000453	0.000081	0.000649	0.000296	0.000081	0.000458	0.000198	0.634687	0.029473	0.008114	0.010801	0.003552	0.004790	0.002314	0.002524	0.001197	0.001855	0.000939	0.000682	0.000945	0.002115	0.000629	0.003211	0.002973	0.003152	0.000583	0.000544	0.000280	0.010518	0.022431	0.000434	0.023264	0.033653	0.027422	0.034011	0.022371	0.019316	0.005574	0.029974	0.005999	0.000479	0.006486	0.005223	0.003166	0.000171	0.000185	0.000265	0.000462	0.000569	0.003608	0.004206	0.004601	0.001519	0.000207	0.001398	0.001318	0.000272	0.001059	0.000384	0.002732	0.000216	0.003012	0.003644	0.000838	0.000895	0.003847	0.002765	0.000785	0.000907	0.000967	0.000454	0.000160	0.000890	0.000437	0.000444	0.001115	0.000483	0.000032	0.002098	0.000518	0.000415	0.000324	0.001214	0.005370	0.001049	0.001292	0.039071	0.050947	0.000641	0.011562	0.003097	0.008781	0.009396	0.010342	0.008603	0.008074	0.057868	0.030392	0.016761	0.006196	0.003814	0.002350	0.037929	0.002686	0.004661	0.008962	0.003713	0.001158	0.000277	0.013108	0.003038	0.001634	0.003424	0.005860	0.004756	0.001440	0.007402	0.000579	0.000775	0.000536	0.000342	0.018511	0.002830	0.002610	0.000614	0.000114	0.003700	0.003947	0.000928	0.001331	0.003880	0.000460	0.006593	0.003860	0.000802	0.036052	0.020595	0.004480	0.002878	0.002099	0.009634	0.001024	0.000473	0.001060	0.007322	0.000373	0.004869	0.003259	0.001653	0.006469	0.012234	0.000260	0.000220	0.000148	0.000147	0.000147	0.000078	0.000107	0.000324	0.000075	0.000074	0.000062	0.000124	0.000050	0.000069	0.000057	0.000097	0.000408	0.000089	0.000217	0.003372	0.000306	0.000073	0.000258	0.000094	0.000044	0.000199	0.000787	0.001256	0.000285	0.001077	0.000030	0.000034	0.000037	0.000132	0.000099	0.000201	0.000058	0.000448	0.000049	0.000292	0.000089	0.000664	0.000744	0.000324	0.000179	0.000284	0.000045	0.000177	0.000237	0.000068	0.000096	0.000156	0.000010	0.000043	0.000191	0.000027	0.000080	0.000045	0.000081	0.000123	0.001053	0.002632	0.000241	0.000010	0.000041	0.000035	0.000018	0.000079	0.000055	0.000012	0.000050	0.000055	0.000156	0.000363	0.000665	0.001691	0.000154	0.000104	0.000119	0.000330	0.000475	0.000009	0.000032	0.000122	0.000074	0.000067	0.000040	0.000118	0.000040	0.000062	0.000043	0.000074	0.000014	0.000046	0.000018	0.000063	0.000037	0.000216	0.000590	0.000128	0.000183	0.000218	0.000067	0.000182	0.000068	0.000190	0.000184	0.004575	0.000844	0.000658	0.003613	0.000422	0.001475	0.003001	0.002069	0.002182	0.000534	0.003024	0.010880	0.007814	0.000239	0.003966	0.000104	0.000310	0.000122	0.000895	0.001080	0.000930	0.000121	0.000023	0.000052	0.000074	0.000011	0.000100	0.000150	0.000606	0.001392	0.000236	0.000060	0.000011	0.000021	0.000033	0.000004	0.000089	0.000126	0.000770	0.000685	0.000234	0.000078	0.000188	0.000422	0.000367	0.000211	0.001822	0.000151	0.000093	0.000095	0.000384	0.000010	0.000084	0.000290	0.000662	0.000238	0.000184	0.000108	0.000112	0.000280	0.000417	0.000022	0.000170	0.000062	0.000065	0.000365	0.000020	0.000022	0.000023	0.002950	0.000456	0.000966	0.000254	0.000234	0.003862	0.011041	0.004363	0.000248	0.000415	0.000246	0.000143	0.000089	0.000149	0.000115	0.000185	0.000073	0.002470	0.000196	0.000070	0.004093	0.000024	0.000053	0.000070	0.008704	0.000594	0.002293	0.000772	0.000119	0.000058	0.000393	0.000049	0.000466	0.000047	0.000436	0.000040	0.000248	0.000993	0.001202	0.006847	0.001749	0.001595	0.000226	0.009204	0.016118	0.001887	0.004079	0.004953	0.001328	0.009769	0.005298	0.001027	0.002788	0.002138	0.002561	0.009367	0.000410	0.000235	0.003759	0.000642	0.005338	0.006128	0.000732	0.000370	0.000032	0.007768	0.000132	0.000510	0.001362	0.000110
121423029 - Caribou - Suddenly - New Jade	121423029	0.042142	0.000389	0.000555	0.001890	0.000110	0.000330	0.000191	0.000230	0.000181	0.000137	0.000181	0.000064	0.000016	0.000053	0.000303	0.001012	0.000403	0.000182	0.000264	0.000116	0.000196	0.000101	0.000704	0.000758	0.000740	0.000178	0.000404	0.028612	0.000265	0.000332	0.000101	0.000269	0.000711	0.001351	0.000457	0.000554	0.017160	0.000320	0.000510	0.000047	0.000420	0.000191	0.000060	0.000111	0.000206	0.000026	0.000161	0.000300	0.000215	0.000256	0.000069	0.000067	0.000011	0.000088	0.000382	0.000135	0.000027	0.000275	0.000319	0.000344	0.000385	0.000088	0.000037	0.000081	0.000716	0.001334	0.000131	0.000019	0.000069	0.000398	0.000079	0.000033	0.002569	0.002111	0.001409	0.000302	0.000305	0.001131	0.000353	0.000141	0.000277	0.000502	0.000137	0.000373	0.000115	0.000096	0.000283	0.000176	0.000147	0.000082	0.000083	0.000080	0.001045	0.000159	0.000460	0.000152	0.000274	0.000233	0.000655	0.000376	0.000217	0.000313	0.000169	0.000173	0.000149	0.000254	0.000137	0.000144	0.000039	0.000032	0.000106	0.000967	0.000392	0.000356	0.000010	0.000104	0.000073	0.000108	0.000116	0.000169	0.000051	0.000015	0.000456	0.000153	0.000154	0.000077	0.000696	0.000309	0.000609	0.000400	0.000488	0.000117	0.000478	0.000280	0.000054	0.000449	0.000074	0.803884	0.036761	0.003835	0.003938	0.000904	0.001063	0.000809	0.000238	0.000295	0.000618	0.000890	0.000626	0.000700	0.000826	0.000379	0.007726	0.007097	0.005338	0.001105	0.000654	0.000394	0.038587	0.050063	0.001123	0.005069	0.007685	0.061219	0.010832	0.002009	0.001408	0.000953	0.004993	0.000733	0.000303	0.001300	0.000993	0.000681	0.000215	0.000109	0.000221	0.000312	0.001396	0.006155	0.007254	0.009097	0.001469	0.000260	0.001152	0.001420	0.000702	0.000944	0.000450	0.001339	0.000170	0.001837	0.001591	0.000479	0.000279	0.001742	0.001241	0.000372	0.000568	0.002030	0.000907	0.000263	0.000620	0.000337	0.000241	0.003503	0.002545	0.000131	0.000449	0.000346	0.000444	0.000261	0.000534	0.002306	0.001981	0.001303	0.040195	0.094173	0.000315	0.002604	0.001426	0.002218	0.000865	0.001878	0.001780	0.000204	0.046513	0.005628	0.009031	0.001234	0.000444	0.000739	0.009290	0.001200	0.003567	0.005409	0.007453	0.002204	0.000534	0.132188	0.015557	0.010115	0.041483	0.162809	0.038181	0.009316	0.011519	0.010534	0.002013	0.000693	0.000260	0.005291	0.003040	0.006324	0.000774	0.000160	0.013287	0.026082	0.001671	0.002334	0.002091	0.000441	0.000674	0.000922	0.000792	0.009587	0.019121	0.008386	0.005255	0.002219	0.021729	0.001995	0.003320	0.001500	0.016999	0.000427	0.005408	0.003419	0.001230	0.005384	0.018148	0.000149	0.000233	0.000161	0.000096	0.000151	0.000046	0.000055	0.000278	0.000058	0.000049	0.000045	0.000077	0.000035	0.000086	0.000065	0.000090	0.000214	0.000044	0.000112	0.001979	0.000219	0.000046	0.000111	0.000097	0.000033	0.000168	0.000603	0.000384	0.000089	0.000207	0.000012	0.000026	0.000035	0.000092	0.000100	0.000182	0.000032	0.000209	0.000023	0.000292	0.000046	0.000737	0.000744	0.000314	0.000221	0.000207	0.000046	0.000196	0.000256	0.000069	0.000103	0.000176	0.000006	0.000042	0.000151	0.000020	0.000044	0.000044	0.000078	0.000084	0.000296	0.000226	0.000194	0.000006	0.000021	0.000040	0.000037	0.000075	0.000043	0.000012	0.000041	0.000044	0.000149	0.000232	0.000465	0.001870	0.000091	0.000071	0.000129	0.000181	0.000245	0.000006	0.000021	0.000175	0.000115	0.000144	0.000041	0.000064	0.000067	0.000085	0.000054	0.000071	0.000026	0.000032	0.000030	0.000045	0.000041	0.000195	0.000487	0.000144	0.000114	0.000226	0.000052	0.000201	0.000057	0.000217	0.000232	0.001297	0.000732	0.000567	0.003857	0.000250	0.001981	0.001460	0.000719	0.002528	0.000826	0.000567	0.002029	0.002184	0.000175	0.000710	0.000070	0.000201	0.000084	0.000531	0.000475	0.000479	0.000092	0.000018	0.000055	0.000061	0.000013	0.000086	0.000057	0.000135	0.000386	0.000256	0.000036	0.000017	0.000015	0.000028	0.000006	0.000093	0.000096	0.000485	0.000230	0.000117	0.000054	0.000050	0.000110	0.000223	0.000133	0.001643	0.000084	0.000055	0.000089	0.000415	0.000007	0.000045	0.000686	0.000794	0.000122	0.000222	0.000041	0.000079	0.000168	0.000444	0.000043	0.000084	0.000044	0.000082	0.000328	0.000019	0.000037	0.000022	0.000811	0.000085	0.000449	0.000070	0.000143	0.000853	0.002932	0.001556	0.000071	0.000186	0.000128	0.000053	0.000058	0.000141	0.000085	0.000021	0.000040	0.000570	0.000153	0.000058	0.000797	0.000023	0.000069	0.000069	0.001968	0.000423	0.001211	0.000244	0.000027	0.000030	0.000335	0.000028	0.000298	0.000060	0.000515	0.000065	0.000122	0.001019	0.002591	0.004609	0.017552	0.000721	0.000203	0.005011	0.004700	0.001825	0.001755	0.005240	0.002606	0.006693	0.001890	0.000366	0.001094	0.000904	0.001196	0.005978	0.000211	0.000182	0.003644	0.000500	0.001058	0.001091	0.000479	0.000213	0.000041	0.003988	0.000100	0.000353	0.000354	0.000058
121423027 - Caribou - Suddenly - You and I	121423027	0.036087	0.000418	0.000423	0.001474	0.000172	0.000350	0.000448	0.000234	0.000155	0.000166	0.000220	0.000084	0.000021	0.000049	0.000871	0.000712	0.000685	0.000410	0.000436	0.000218	0.000249	0.000173	0.000567	0.000715	0.000517	0.000390	0.000303	0.035882	0.000109	0.001168	0.000037	0.000107	0.001124	0.001571	0.000453	0.000588	0.002809	0.000292	0.000583	0.000032	0.001689	0.000171	0.000060	0.000047	0.000199	0.000064	0.000091	0.000260	0.000156	0.000561	0.000121	0.000053	0.000013	0.000086	0.000306	0.000115	0.000008	0.000105	0.000120	0.000460	0.000112	0.000087	0.000203	0.000114	0.000673	0.000621	0.000136	0.000014	0.000040	0.000282	0.000061	0.000015	0.003364	0.002753	0.002155	0.000813	0.000453	0.000478	0.000796	0.000224	0.000302	0.000409	0.000095	0.000358	0.000094	0.000065	0.000222	0.000193	0.000174	0.000105	0.000041	0.000042	0.000175	0.000109	0.000176	0.000114	0.000251	0.000206	0.001013	0.000364	0.000207	0.000268	0.000261	0.000249	0.000230	0.000429	0.000305	0.000308	0.000040	0.000035	0.000100	0.001097	0.000442	0.000411	0.000040	0.000118	0.000083	0.000149	0.000177	0.000122	0.000048	0.000019	0.000591	0.000203	0.000258	0.000142	0.000572	0.000232	0.000404	0.000260	0.000223	0.000053	0.000263	0.000125	0.000040	0.000525	0.000012	0.751012	0.022247	0.003735	0.005022	0.000979	0.001307	0.001139	0.000747	0.000203	0.001028	0.000460	0.000293	0.000503	0.000402	0.000367	0.006994	0.005809	0.004984	0.000645	0.000802	0.000295	0.022861	0.058744	0.000762	0.002317	0.005485	0.095078	0.006811	0.001612	0.001392	0.000402	0.004202	0.000314	0.000093	0.000707	0.000622	0.000483	0.000099	0.000106	0.000250	0.000091	0.000129	0.001601	0.002435	0.002225	0.000557	0.000107	0.001131	0.002127	0.000597	0.001758	0.000609	0.001223	0.000122	0.002088	0.000954	0.000505	0.000301	0.003862	0.001634	0.001030	0.000629	0.000373	0.000139	0.000067	0.000476	0.000163	0.000497	0.000620	0.000372	0.000012	0.001949	0.000517	0.000335	0.000053	0.002255	0.001214	0.000555	0.001113	0.060081	0.022029	0.000197	0.005196	0.000957	0.001868	0.002481	0.004141	0.005598	0.001051	0.080216	0.070916	0.012031	0.003673	0.007793	0.001259	0.102698	0.001149	0.002896	0.007721	0.045738	0.001014	0.000305	0.054394	0.034539	0.007863	0.016280	0.008678	0.036802	0.008398	0.003045	0.003965	0.001113	0.000401	0.000285	0.010818	0.009719	0.004298	0.000326	0.000100	0.005042	0.005936	0.001794	0.002712	0.002207	0.000163	0.000970	0.001898	0.000689	0.020595	0.013466	0.008710	0.006758	0.005065	0.011171	0.001227	0.001393	0.001925	0.028011	0.000544	0.013518	0.005486	0.001547	0.008644	0.021259	0.000024	0.000063	0.000097	0.000079	0.000084	0.000030	0.000034	0.000173	0.000039	0.000043	0.000031	0.000064	0.000020	0.000039	0.000032	0.000074	0.000151	0.000065	0.000102	0.001820	0.000168	0.000037	0.000113	0.000053	0.000028	0.000126	0.000379	0.001069	0.000242	0.000786	0.000018	0.000015	0.000021	0.000039	0.000036	0.000142	0.000023	0.000610	0.000029	0.000067	0.000064	0.000519	0.000510	0.000269	0.000145	0.000204	0.000029	0.000114	0.000146	0.000042	0.000070	0.000105	0.000004	0.000022	0.000092	0.000017	0.000047	0.000024	0.000034	0.000056	0.000198	0.000110	0.000199	0.000010	0.000022	0.000044	0.000022	0.000067	0.000039	0.000009	0.000047	0.000049	0.000121	0.000195	0.000305	0.001040	0.000091	0.000063	0.000092	0.000277	0.000170	0.000007	0.000030	0.000098	0.000066	0.000036	0.000026	0.000074	0.000029	0.000075	0.000052	0.000066	0.000010	0.000038	0.000013	0.000035	0.000020	0.000178	0.000422	0.000059	0.000205	0.000090	0.000046	0.000494	0.000085	0.000536	0.000292	0.004067	0.002810	0.000989	0.009525	0.001077	0.005105	0.007886	0.000732	0.001502	0.000291	0.002907	0.010466	0.009272	0.000360	0.001780	0.000066	0.000120	0.000048	0.000235	0.000577	0.000439	0.000047	0.000013	0.000040	0.000039	0.000009	0.000099	0.000065	0.000215	0.000291	0.000271	0.000032	0.000011	0.000015	0.000035	0.000005	0.000077	0.000091	0.000221	0.000401	0.000082	0.000022	0.000048	0.000290	0.000057	0.000047	0.000771	0.000039	0.000022	0.000059	0.000201	0.000001	0.000026	0.000222	0.000460	0.000053	0.000193	0.000035	0.000034	0.000392	0.000788	0.000018	0.000097	0.000039	0.000079	0.000602	0.000022	0.000015	0.000019	0.000227	0.000077	0.000172	0.000064	0.000183	0.000795	0.001221	0.000366	0.000046	0.000070	0.000332	0.000061	0.000026	0.000044	0.000035	0.000073	0.000041	0.000956	0.000068	0.000065	0.002574	0.000004	0.000044	0.000057	0.008392	0.000327	0.002195	0.000273	0.000030	0.000009	0.000214	0.000042	0.000245	0.000034	0.001587	0.000023	0.000082	0.001404	0.001851	0.001684	0.002884	0.001277	0.000093	0.003635	0.022303	0.002195	0.003433	0.004684	0.001100	0.007278	0.001835	0.000295	0.001269	0.001344	0.000348	0.003391	0.000087	0.000136	0.002461	0.000119	0.000569	0.003122	0.000177	0.000114	0.000015	0.002039	0.000091	0.000537	0.000523	0.000042
121423028 - Caribou - Suddenly - Sunny's Time	121423028	0.046526	0.000525	0.000293	0.000501	0.000116	0.000276	0.000151	0.000151	0.000429	0.000306	0.000395	0.000192	0.000012	0.000087	0.000267	0.000850	0.000195	0.000075	0.000073	0.000071	0.000081	0.000057	0.000354	0.000325	0.000356	0.000058	0.000532	0.047741	0.000252	0.000157	0.000048	0.000045	0.001180	0.000712	0.000217	0.000266	0.066223	0.000459	0.000368	0.000018	0.000604	0.000228	0.000070	0.000057	0.000119	0.000033	0.000077	0.000165	0.000115	0.000165	0.000035	0.000092	0.000037	0.000123	0.000172	0.000184	0.000013	0.000172	0.000034	0.000114	0.000172	0.000080	0.000034	0.000062	0.000479	0.001126	0.000183	0.000026	0.000047	0.000474	0.000081	0.000025	0.004585	0.002803	0.002089	0.000406	0.000532	0.000716	0.000609	0.000122	0.000483	0.000511	0.000098	0.000265	0.000368	0.000086	0.000390	0.000201	0.000162	0.000063	0.000141	0.000142	0.000032	0.000109	0.000121	0.000181	0.000309	0.000333	0.000528	0.000294	0.000123	0.000239	0.000168	0.000150	0.000184	0.000249	0.000161	0.000133	0.000072	0.000049	0.000084	0.001537	0.000930	0.000894	0.000077	0.000170	0.000136	0.000190	0.000231	0.000791	0.000145	0.000028	0.000759	0.000193	0.000290	0.000135	0.001254	0.000672	0.000549	0.000453	0.000494	0.000196	0.000526	0.000219	0.000161	0.000168	0.000055	0.718685	0.078891	0.004082	0.004853	0.001378	0.002239	0.000705	0.002667	0.000398	0.000396	0.000381	0.000115	0.000316	0.000469	0.000272	0.230327	0.235626	0.491850	0.005057	0.009353	0.001640	0.236301	0.025459	0.003619	0.001229	0.001260	0.009090	0.001432	0.000391	0.000311	0.000135	0.000724	0.000327	0.000074	0.000276	0.000280	0.000073	0.000055	0.000169	0.000126	0.000288	0.000214	0.002567	0.002862	0.004138	0.001160	0.000104	0.000361	0.001582	0.000381	0.001018	0.000430	0.000990	0.000090	0.000977	0.001052	0.000324	0.000329	0.001927	0.000939	0.001069	0.000507	0.001501	0.000225	0.000147	0.000150	0.000067	0.000109	0.000804	0.000328	0.000034	0.000697	0.000189	0.000063	0.000105	0.001171	0.009287	0.001379	0.001997	0.018657	0.122229	0.000268	0.001505	0.000620	0.001082	0.000606	0.001299	0.000774	0.000265	0.014182	0.004753	0.003152	0.001182	0.001187	0.000408	0.003942	0.000380	0.001212	0.006928	0.001211	0.002498	0.000129	0.030068	0.005794	0.002177	0.007443	0.004516	0.005691	0.002338	0.020164	0.001257	0.000832	0.000301	0.000124	0.004490	0.001513	0.005121	0.000761	0.000112	0.001922	0.001255	0.000983	0.001774	0.004053	0.000113	0.000237	0.000885	0.000183	0.012183	0.005671	0.004591	0.002938	0.000896	0.005419	0.001225	0.000962	0.000663	0.003002	0.000579	0.001636	0.000968	0.001584	0.006258	0.003128	0.000199	0.000110	0.000146	0.000233	0.000131	0.000065	0.000076	0.000322	0.000092	0.000074	0.000079	0.000096	0.000045	0.000049	0.000040	0.000244	0.000202	0.000067	0.000061	0.002816	0.000197	0.000050	0.000110	0.000078	0.000017	0.000169	0.000607	0.000393	0.000098	0.000116	0.000014	0.000031	0.000043	0.000073	0.000114	0.000139	0.000042	0.000233	0.000025	0.000366	0.000093	0.000362	0.000343	0.000179	0.000090	0.000190	0.000039	0.000378	0.000518	0.000132	0.000155	0.000345	0.000010	0.000065	0.000121	0.000019	0.000031	0.000036	0.000082	0.000079	0.000442	0.000567	0.000187	0.000015	0.000058	0.000027	0.000030	0.000065	0.000045	0.000007	0.000025	0.000045	0.000105	0.000220	0.000683	0.002906	0.000061	0.000109	0.000070	0.000221	0.000374	0.000011	0.000017	0.000069	0.000050	0.000113	0.000046	0.000042	0.000026	0.000102	0.000065	0.000077	0.000025	0.000047	0.000059	0.000051	0.000055	0.000088	0.000192	0.000045	0.000101	0.000268	0.000037	0.000169	0.000032	0.000244	0.000326	0.001543	0.000524	0.000306	0.002228	0.000278	0.004386	0.004837	0.000537	0.001282	0.000323	0.000519	0.001877	0.001496	0.000095	0.000648	0.000148	0.000093	0.000047	0.000203	0.000234	0.000203	0.000037	0.000011	0.000031	0.000071	0.000018	0.000043	0.000045	0.000357	0.000638	0.000227	0.000033	0.000006	0.000023	0.000031	0.000011	0.000095	0.000155	0.000209	0.000161	0.000066	0.000045	0.000021	0.000111	0.000074	0.000062	0.000509	0.000071	0.000083	0.000108	0.000169	0.000005	0.000035	0.000151	0.000162	0.000162	0.000180	0.000021	0.000043	0.000121	0.000143	0.000021	0.000180	0.000052	0.000053	0.000370	0.000032	0.000024	0.000041	0.002818	0.000159	0.000618	0.000091	0.000244	0.017677	0.014855	0.003716	0.000270	0.000338	0.000187	0.000054	0.000052	0.000086	0.000063	0.000035	0.000063	0.000398	0.000097	0.000086	0.000344	0.000021	0.000062	0.000057	0.002877	0.000240	0.000476	0.000200	0.000029	0.000008	0.000311	0.000012	0.000152	0.000073	0.000417	0.000067	0.000210	0.000498	0.000479	0.000856	0.000564	0.000931	0.000146	0.012695	0.012639	0.002319	0.003233	0.003343	0.000075	0.019727	0.010149	0.001095	0.003120	0.003530	0.003207	0.005999	0.000655	0.000795	0.000906	0.000124	0.004466	0.004596	0.000461	0.000457	0.000115	0.000971	0.000111	0.000387	0.000553	0.000051
121423031 - Caribou - Suddenly - Lime	121423031	0.053411	0.001012	0.000924	0.000781	0.000287	0.000825	0.000193	0.000219	0.000334	0.000142	0.000204	0.000072	0.000036	0.000037	0.000291	0.000643	0.000328	0.000096	0.000148	0.000116	0.000083	0.000147	0.000192	0.000245	0.000355	0.000085	0.000402	0.032631	0.000591	0.000585	0.000561	0.001116	0.002608	0.001593	0.000506	0.000996	0.001644	0.000642	0.000255	0.000016	0.000545	0.000678	0.000094	0.000106	0.000376	0.000087	0.000282	0.000398	0.000167	0.000225	0.000112	0.000273	0.000175	0.000362	0.000162	0.000166	0.000056	0.000423	0.000101	0.000529	0.000100	0.000056	0.000081	0.000089	0.005277	0.003800	0.000141	0.000041	0.000093	0.000565	0.000213	0.000040	0.003822	0.002262	0.001412	0.000272	0.000354	0.000353	0.000486	0.000102	0.000278	0.000548	0.000074	0.000345	0.000323	0.000077	0.000521	0.000328	0.000288	0.000077	0.000176	0.000180	0.000209	0.000062	0.000159	0.000273	0.001118	0.000915	0.000513	0.000406	0.000188	0.000302	0.000138	0.000114	0.000215	0.000313	0.000100	0.000092	0.000093	0.000072	0.000198	0.001712	0.000754	0.000764	0.000071	0.000387	0.000272	0.000150	0.000142	0.000314	0.000103	0.000040	0.000292	0.000228	0.000710	0.000121	0.000922	0.000279	0.000167	0.000435	0.002279	0.000384	0.000171	0.000069	0.000287	0.000952	0.000321	0.722854	0.071949	0.021166	0.025309	0.004341	0.009289	0.005273	0.001704	0.001680	0.003624	0.001475	0.000667	0.001756	0.001284	0.001280	0.022709	0.017575	0.017053	0.002179	0.001992	0.001036	0.085774	0.063356	0.001154	0.005077	0.007139	0.072321	0.008649	0.002729	0.001853	0.000980	0.004722	0.005049	0.000280	0.001774	0.001598	0.001800	0.000296	0.000743	0.000341	0.001804	0.000215	0.001143	0.001802	0.001389	0.000911	0.000421	0.000984	0.001950	0.000384	0.000868	0.000432	0.002478	0.000164	0.001236	0.002479	0.000674	0.001004	0.002468	0.001666	0.001501	0.000693	0.001498	0.000222	0.000121	0.000271	0.000063	0.000127	0.000333	0.000199	0.000035	0.000681	0.000365	0.000132	0.001093	0.000386	0.006346	0.001085	0.001382	0.013534	0.009911	0.000437	0.003753	0.000740	0.001187	0.000466	0.001417	0.001774	0.001483	0.016474	0.014996	0.005772	0.006280	0.002789	0.002224	0.014311	0.001704	0.003208	0.011759	0.007217	0.001453	0.000204	0.043179	0.014666	0.011194	0.004906	0.009147	0.021156	0.003730	0.019660	0.005678	0.002432	0.000929	0.002765	0.008621	0.003716	0.002126	0.001059	0.000239	0.007256	0.005125	0.001447	0.002815	0.003136	0.000381	0.002383	0.000825	0.000928	0.008242	0.006258	0.005319	0.004676	0.002617	0.012787	0.001479	0.002394	0.001406	0.005410	0.000348	0.003981	0.002687	0.000792	0.005134	0.004639	0.000168	0.000632	0.000677	0.000530	0.000601	0.000173	0.000221	0.000519	0.000109	0.000074	0.000097	0.000251	0.000158	0.000364	0.000323	0.000200	0.000803	0.000108	0.000320	0.009125	0.000867	0.000226	0.000373	0.000335	0.000246	0.000647	0.002760	0.001889	0.000339	0.000400	0.000045	0.000108	0.000132	0.000602	0.000427	0.000339	0.000097	0.000776	0.000079	0.000187	0.000286	0.000493	0.000364	0.000193	0.000163	0.000455	0.000174	0.000744	0.001187	0.000192	0.000365	0.000633	0.000020	0.000382	0.000943	0.000149	0.000199	0.000199	0.000172	0.000754	0.001028	0.001804	0.000418	0.000035	0.000039	0.000052	0.000037	0.000216	0.000123	0.000014	0.000092	0.000109	0.000468	0.000663	0.000515	0.000893	0.000431	0.000308	0.000189	0.000456	0.000935	0.000035	0.000081	0.000163	0.000091	0.000049	0.000077	0.000647	0.000075	0.000150	0.000104	0.000108	0.000086	0.000072	0.000040	0.000099	0.000080	0.000124	0.000466	0.000120	0.000134	0.001301	0.000079	0.000431	0.000086	0.000494	0.000484	0.001674	0.000861	0.000234	0.004815	0.000622	0.001603	0.002314	0.000641	0.001538	0.000426	0.004155	0.004282	0.001930	0.000388	0.001364	0.000168	0.000131	0.000048	0.000170	0.000542	0.000399	0.000045	0.000013	0.000067	0.000335	0.000187	0.000195	0.000174	0.000198	0.000624	0.000281	0.000036	0.000005	0.000024	0.000034	0.000016	0.000117	0.000112	0.000823	0.000223	0.000100	0.000049	0.000140	0.000056	0.000158	0.000096	0.000911	0.000431	0.000116	0.000112	0.000125	0.000003	0.000040	0.000282	0.000688	0.000088	0.000584	0.000050	0.000111	0.000792	0.001032	0.000037	0.000456	0.000211	0.000186	0.000976	0.000080	0.000035	0.000172	0.008525	0.000336	0.002338	0.000253	0.000226	0.006800	0.007717	0.002098	0.001080	0.000075	0.000112	0.000085	0.000094	0.000074	0.000123	0.000037	0.000228	0.001528	0.000229	0.000104	0.001295	0.000005	0.000099	0.000052	0.009199	0.001022	0.000700	0.000144	0.000053	0.000027	0.001182	0.000096	0.000769	0.000119	0.000701	0.000133	0.006295	0.001199	0.000476	0.023386	0.000463	0.001178	0.000098	0.007849	0.010649	0.008296	0.001938	0.013616	0.005629	0.017931	0.011153	0.002696	0.004776	0.004014	0.006653	0.011855	0.000824	0.000320	0.006933	0.001715	0.003509	0.007284	0.001092	0.001512	0.000143	0.024164	0.000293	0.001670	0.002569	0.000608
121423032 - Caribou - Suddenly - Never Come Back	121423032	0.027047	0.000327	0.000597	0.002280	0.000094	0.000506	0.000275	0.000310	0.000122	0.000123	0.000164	0.000051	0.000008	0.000026	0.000441	0.000549	0.000463	0.000238	0.000239	0.000105	0.000175	0.000127	0.000591	0.000576	0.000526	0.000242	0.000380	0.030994	0.000195	0.001032	0.000018	0.000051	0.000725	0.004189	0.001871	0.001372	0.000235	0.000555	0.000267	0.000041	0.000387	0.000243	0.000047	0.000078	0.000164	0.000031	0.000107	0.000406	0.000106	0.000405	0.000076	0.000029	0.000051	0.000044	0.000118	0.000062	0.000011	0.000292	0.000109	0.000400	0.000169	0.000146	0.000024	0.000091	0.000526	0.000841	0.000068	0.000012	0.000027	0.000204	0.000043	0.000029	0.003090	0.002762	0.002197	0.000899	0.000377	0.000498	0.000542	0.000140	0.000325	0.000560	0.000127	0.000558	0.000119	0.000096	0.000250	0.000111	0.000090	0.000038	0.000049	0.000053	0.000367	0.000076	0.000140	0.000215	0.000298	0.000237	0.000649	0.000321	0.000174	0.000208	0.000192	0.000195	0.000099	0.000185	0.000161	0.000156	0.000056	0.000042	0.000076	0.000763	0.000284	0.000244	0.000012	0.000118	0.000084	0.000085	0.000088	0.000198	0.000083	0.000008	0.000619	0.000092	0.000071	0.000085	0.000850	0.000215	0.000820	0.000470	0.000340	0.000093	0.000268	0.000146	0.000047	0.000379	0.000018	0.819322	0.045943	0.005715	0.006587	0.001241	0.002594	0.001127	0.000309	0.000210	0.001030	0.000863	0.000151	0.000699	0.000471	0.000919	0.019396	0.018898	0.013331	0.000994	0.000804	0.000390	0.046038	0.061172	0.000637	0.002371	0.003387	0.057765	0.004445	0.000845	0.000553	0.000232	0.001948	0.000196	0.000096	0.000695	0.000588	0.000644	0.000084	0.000093	0.000246	0.000127	0.000164	0.001226	0.001885	0.001834	0.000622	0.000186	0.000881	0.001169	0.000262	0.000758	0.000304	0.001854	0.000124	0.001758	0.001990	0.000735	0.000391	0.001145	0.000792	0.000510	0.000381	0.001732	0.000272	0.000115	0.000613	0.000275	0.000224	0.000545	0.000388	0.000041	0.000222	0.000164	0.000058	0.000040	0.000345	0.000923	0.000761	0.000635	0.082518	0.003764	0.000175	0.002670	0.000605	0.001022	0.000818	0.001321	0.002987	0.000179	0.028007	0.011510	0.001872	0.001610	0.004685	0.000726	0.063190	0.000615	0.001374	0.007336	0.170057	0.001776	0.000981	0.133501	0.256090	0.027436	0.010200	0.011198	0.073638	0.060617	0.001530	0.022459	0.001131	0.000682	0.000220	0.005231	0.034303	0.002279	0.000438	0.000177	0.002684	0.005413	0.002198	0.002517	0.002386	0.000126	0.000265	0.001278	0.000418	0.010535	0.010975	0.008117	0.005868	0.007524	0.018567	0.001705	0.001937	0.002695	0.145696	0.000378	0.021310	0.014044	0.000492	0.004151	0.042819	0.000017	0.000053	0.000082	0.000058	0.000079	0.000017	0.000020	0.000167	0.000019	0.000014	0.000014	0.000040	0.000018	0.000029	0.000023	0.000083	0.000110	0.000027	0.000059	0.001364	0.000119	0.000025	0.000073	0.000051	0.000016	0.000092	0.000351	0.000384	0.000052	0.000165	0.000013	0.000015	0.000016	0.000037	0.000032	0.000087	0.000017	0.000150	0.000014	0.000146	0.000040	0.000258	0.000276	0.000142	0.000073	0.000093	0.000018	0.000098	0.000138	0.000034	0.000032	0.000086	0.000002	0.000024	0.000078	0.000017	0.000025	0.000023	0.000033	0.000048	0.000075	0.000031	0.000138	0.000008	0.000013	0.000029	0.000008	0.000050	0.000029	0.000004	0.000022	0.000031	0.000087	0.000153	0.000314	0.000934	0.000069	0.000055	0.000075	0.000196	0.000099	0.000006	0.000022	0.000042	0.000025	0.000011	0.000015	0.000047	0.000028	0.000054	0.000042	0.000080	0.000023	0.000049	0.000013	0.000028	0.000038	0.000101	0.000172	0.000030	0.000070	0.000088	0.000033	0.000141	0.000040	0.000203	0.000466	0.001403	0.001295	0.000822	0.010558	0.000512	0.001838	0.004638	0.000317	0.000726	0.000136	0.000828	0.002035	0.003380	0.000099	0.000857	0.000058	0.000068	0.000026	0.000279	0.000410	0.000360	0.000032	0.000007	0.000027	0.000041	0.000010	0.000075	0.000078	0.000181	0.000356	0.000119	0.000014	0.000004	0.000007	0.000022	0.000005	0.000044	0.000060	0.000163	0.000154	0.000058	0.000017	0.000032	0.000064	0.000087	0.000051	0.000795	0.000025	0.000014	0.000042	0.000028	0.000001	0.000025	0.000114	0.000161	0.000053	0.000126	0.000035	0.000034	0.000229	0.000286	0.000008	0.000067	0.000022	0.000054	0.000522	0.000018	0.000012	0.000009	0.000425	0.000041	0.000227	0.000044	0.000079	0.002708	0.003877	0.001549	0.000015	0.000037	0.000055	0.000025	0.000013	0.000034	0.000044	0.000025	0.000044	0.000168	0.000103	0.000044	0.001775	0.000005	0.000044	0.000070	0.001605	0.000177	0.000947	0.000176	0.000012	0.000008	0.000251	0.000023	0.000170	0.000025	0.001174	0.000019	0.000045	0.002142	0.001441	0.000773	0.002779	0.001435	0.000124	0.006624	0.003559	0.002113	0.001024	0.004482	0.001131	0.010540	0.002147	0.000272	0.000855	0.000847	0.000975	0.004657	0.000116	0.000096	0.001930	0.000091	0.002320	0.001769	0.000450	0.000152	0.000022	0.000987	0.000078	0.000344	0.000281	0.000033
121423033 - Caribou - Suddenly - Filtered Grand Piano	121423033	0.006089	0.000141	0.000078	0.000265	0.000025	0.000075	0.000033	0.000014	0.000195	0.000073	0.000112	0.000062	0.000006	0.000059	0.000114	0.000049	0.000089	0.000022	0.000050	0.000042	0.000033	0.000039	0.000086	0.000218	0.000098	0.000028	0.000010	0.000701	0.000126	0.000023	0.000030	0.000100	0.000109	0.000207	0.000138	0.000045	0.000078	0.000022	0.000044	0.000004	0.000249	0.000063	0.000016	0.000052	0.000036	0.000008	0.000046	0.000025	0.000007	0.000078	0.000015	0.000032	0.000039	0.000036	0.000021	0.000024	0.000003	0.000014	0.000015	0.000035	0.000023	0.000047	0.000010	0.000025	0.000033	0.000040	0.000104	0.000029	0.000025	0.000273	0.000031	0.000024	0.001521	0.001175	0.000506	0.000038	0.000108	0.000546	0.000072	0.000032	0.000083	0.000328	0.000011	0.000194	0.000487	0.000048	0.000419	0.000029	0.000021	0.000012	0.000109	0.000092	0.000056	0.000014	0.000024	0.000051	0.000064	0.000073	0.000277	0.000177	0.000086	0.000142	0.000036	0.000031	0.000077	0.000065	0.000089	0.000093	0.000010	0.000006	0.000014	0.000539	0.000186	0.000165	0.000039	0.000081	0.000067	0.000099	0.000096	0.000085	0.000031	0.000007	0.000216	0.000044	0.000036	0.000034	0.000246	0.000050	0.000123	0.000128	0.000056	0.000086	0.000059	0.000034	0.000065	0.000030	0.000576	0.289595	0.032906	0.001792	0.001701	0.000368	0.000306	0.000269	0.000110	0.000068	0.000232	0.000018	0.000162	0.000031	0.000069	0.000104	0.014249	0.013524	0.004431	0.000438	0.000198	0.000158	0.031741	0.001678	0.000443	0.002582	0.000507	0.000177	0.001049	0.000134	0.000064	0.000049	0.000155	0.000229	0.000075	0.000263	0.000125	0.000091	0.000015	0.000049	0.000036	0.640628	0.000554	0.000594	0.000857	0.000638	0.000353	0.000354	0.000513	0.000887	0.000451	0.000358	0.000265	0.000930	0.000044	0.000913	0.000555	0.000385	0.000250	0.003079	0.002768	0.000132	0.000587	0.002898	0.000277	0.000097	0.000018	0.000001	0.000484	0.000134	0.000036	0.000046	0.000312	0.000178	0.000079	0.001109	0.001857	0.008993	0.015833	0.000076	0.000224	0.000327	0.000142	0.000365	0.000141	0.000075	0.000079	0.000159	0.000080	0.000080	0.000253	0.000373	0.000087	0.000096	0.000060	0.000032	0.000093	0.000186	0.000123	0.000401	0.000078	0.002407	0.000049	0.026685	0.000568	0.000766	0.001011	0.000475	0.002129	0.000423	0.108700	0.001191	0.000121	0.000081	0.000042	0.000244	0.000145	0.002180	0.000165	0.000040	0.000097	0.000046	0.000120	0.000094	0.000244	0.000150	0.000046	0.000030	0.000288	0.000550	0.000120	0.001606	0.000329	0.000094	0.005660	0.000851	0.000590	0.000082	0.000134	0.000347	0.000171	0.000097	0.000579	0.001065	0.000141	0.000025	0.000395	0.000117	0.000108	0.000095	0.000029	0.000037	0.000129	0.000034	0.000016	0.000024	0.000031	0.000033	0.000086	0.000053	0.000381	0.000049	0.000027	0.000026	0.002050	0.000153	0.000028	0.000015	0.000075	0.000064	0.000138	0.000452	0.000587	0.000111	0.000038	0.000004	0.000051	0.000039	0.000083	0.000129	0.000206	0.000039	0.000296	0.000035	0.000059	0.000062	0.000311	0.000213	0.000122	0.000194	0.000081	0.000064	0.000581	0.000760	0.000261	0.000434	0.000522	0.000013	0.000061	0.000185	0.000033	0.000015	0.000039	0.000032	0.000121	0.000035	0.000013	0.000191	0.000021	0.000018	0.000023	0.000047	0.000072	0.000050	0.000011	0.000017	0.000051	0.000156	0.000092	0.000003	0.000036	0.000063	0.000021	0.000014	0.000053	0.000326	0.000008	0.000015	0.000033	0.000013	0.000003	0.000034	0.000031	0.000010	0.000049	0.000025	0.000046	0.000021	0.000013	0.000021	0.000039	0.000102	0.000027	0.000030	0.000006	0.000014	0.000102	0.000011	0.000009	0.000004	0.000012	0.000077	0.000070	0.000039	0.000012	0.000139	0.000025	0.000117	0.000076	0.000064	0.002690	0.001555	0.000047	0.000018	0.000015	0.000298	0.000184	0.000354	0.000031	0.000013	0.000027	0.000086	0.000091	0.000008	0.000001	0.000012	0.000026	0.000017	0.000004	0.000050	0.000022	0.000039	0.000174	0.000011	0.000004	0.000016	0.000029	0.000023	0.000088	0.000055	0.000062	0.000026	0.000008	0.000007	0.000006	0.000008	0.000041	0.000020	0.000046	0.000016	0.000012	0.000098	0.000010	0.000003	0.000002	0.000083	0.000024	0.000002	0.000037	0.000027	0.000020	0.000017	0.000043	0.000003	0.000025	0.000030	0.000015	0.000203	0.000016	0.000022	0.000006	0.001022	0.000037	0.000101	0.000014	0.000009	0.000448	0.001555	0.000070	0.000015	0.000010	0.000030	0.000009	0.000009	0.000004	0.000009	0.000009	0.000026	0.000027	0.000016	0.000109	0.000043	0.000005	0.000011	0.000010	0.000384	0.000263	0.000021	0.000008	0.000014	0.000005	0.000153	0.000009	0.000086	0.000047	0.000013	0.000094	0.000054	0.000049	0.000042	0.000729	0.000005	0.000018	0.000011	0.002336	0.003894	0.004097	0.006013	0.002291	0.000225	0.003508	0.001971	0.000431	0.000846	0.000952	0.002575	0.002993	0.000194	0.000076	0.000106	0.000121	0.000662	0.000347	0.000191	0.000178	0.000023	0.000223	0.000113	0.000124	0.000227	0.000028
121423034 - Caribou - Suddenly - Like I Loved You	121423034	0.028506	0.000383	0.000464	0.001165	0.000114	0.000298	0.000224	0.000162	0.000244	0.000123	0.000148	0.000084	0.000031	0.000045	0.000496	0.000569	0.000390	0.000211	0.000180	0.000133	0.000178	0.000094	0.000513	0.000452	0.000649	0.000215	0.000340	0.040878	0.000198	0.000162	0.000116	0.000309	0.000860	0.001721	0.000538	0.000823	0.008514	0.000731	0.000408	0.000024	0.000608	0.000249	0.000056	0.000053	0.000198	0.000057	0.000096	0.000348	0.000171	0.000317	0.000091	0.000071	0.000033	0.000083	0.000144	0.000070	0.000020	0.000122	0.000197	0.000553	0.000125	0.000088	0.000092	0.000096	0.001244	0.003486	0.000118	0.000018	0.000045	0.000305	0.000063	0.000027	0.004864	0.003861	0.002865	0.000763	0.000570	0.001806	0.000678	0.000220	0.000482	0.000529	0.000068	0.000395	0.000149	0.000108	0.000288	0.000142	0.000117	0.000044	0.000062	0.000058	0.000254	0.000091	0.000145	0.000129	0.000209	0.000170	0.000600	0.000430	0.000202	0.000402	0.000122	0.000107	0.000261	0.000393	0.000157	0.000147	0.000043	0.000032	0.000098	0.001126	0.000462	0.000409	0.000055	0.000137	0.000103	0.000187	0.000208	0.000279	0.000077	0.000014	0.000896	0.000159	0.000193	0.000073	0.000298	0.000137	0.000091	0.000145	0.000163	0.000082	0.000258	0.000128	0.000039	0.000287	0.000034	0.783697	0.040216	0.006040	0.006546	0.002052	0.002792	0.001317	0.000575	0.000763	0.000958	0.000287	0.000326	0.000822	0.001318	0.000642	0.023544	0.018306	0.026315	0.001297	0.001564	0.000432	0.127586	0.075804	0.001958	0.001601	0.002732	0.224767	0.004102	0.000759	0.000662	0.000258	0.001935	0.000243	0.000145	0.000381	0.000363	0.000365	0.000060	0.000069	0.000080	0.000112	0.000338	0.002637	0.003313	0.003977	0.001504	0.000277	0.000385	0.000886	0.000411	0.000707	0.000207	0.001133	0.000118	0.001477	0.002996	0.000312	0.000209	0.002764	0.003402	0.000569	0.000810	0.002527	0.000304	0.000162	0.000184	0.000083	0.000066	0.000592	0.000393	0.000063	0.000436	0.000167	0.000184	0.000087	0.000917	0.004946	0.000934	0.001530	0.042526	0.070579	0.000494	0.002416	0.000830	0.002499	0.001196	0.001863	0.001554	0.000370	0.077833	0.015477	0.008003	0.001016	0.000549	0.000395	0.015835	0.001429	0.005617	0.005946	0.007143	0.001163	0.000181	0.049439	0.017400	0.011520	0.008805	0.007325	0.029307	0.005160	0.007835	0.003672	0.001275	0.000355	0.000328	0.006946	0.002951	0.004543	0.000863	0.000218	0.014725	0.024465	0.001349	0.002458	0.004018	0.000248	0.002637	0.000584	0.000950	0.015142	0.008447	0.007002	0.006598	0.001740	0.014801	0.004195	0.002187	0.001091	0.011767	0.000419	0.008041	0.003059	0.001860	0.010362	0.010536	0.000063	0.000055	0.000124	0.000108	0.000118	0.000050	0.000058	0.000325	0.000083	0.000081	0.000069	0.000088	0.000062	0.000058	0.000051	0.000132	0.000226	0.000046	0.000066	0.002226	0.000202	0.000050	0.000100	0.000084	0.000032	0.000160	0.000569	0.000629	0.000105	0.000186	0.000015	0.000025	0.000036	0.000062	0.000078	0.000154	0.000029	0.000257	0.000024	0.000488	0.000057	0.000563	0.000414	0.000283	0.000170	0.000146	0.000040	0.000239	0.000311	0.000115	0.000149	0.000209	0.000006	0.000042	0.000122	0.000022	0.000034	0.000032	0.000041	0.000077	0.000201	0.000121	0.000204	0.000017	0.000012	0.000035	0.000024	0.000078	0.000046	0.000009	0.000041	0.000049	0.000135	0.000166	0.000422	0.001002	0.000068	0.000060	0.000153	0.000206	0.000492	0.000008	0.000016	0.000090	0.000064	0.000030	0.000042	0.000087	0.000080	0.000087	0.000053	0.000128	0.000029	0.000046	0.000009	0.000037	0.000051	0.000061	0.000403	0.000041	0.000044	0.000142	0.000044	0.000182	0.000047	0.000237	0.000140	0.001162	0.000733	0.000410	0.013749	0.000491	0.002929	0.002479	0.000565	0.001510	0.000271	0.001043	0.001289	0.001369	0.000109	0.000920	0.000121	0.000095	0.000039	0.000306	0.000407	0.000372	0.000036	0.000006	0.000026	0.000044	0.000025	0.000076	0.000091	0.000123	0.000200	0.000204	0.000018	0.000005	0.000025	0.000035	0.000011	0.000087	0.000089	0.000234	0.000178	0.000063	0.000022	0.000042	0.000061	0.000081	0.000071	0.000837	0.000047	0.000022	0.000115	0.000249	0.000004	0.000032	0.000250	0.000399	0.000041	0.000224	0.000036	0.000070	0.000118	0.000462	0.000020	0.000135	0.000066	0.000091	0.000319	0.000039	0.000027	0.000034	0.000219	0.000060	0.000280	0.000065	0.000080	0.006935	0.010273	0.004243	0.000150	0.000046	0.000190	0.000036	0.000034	0.000046	0.000109	0.000028	0.000036	0.000565	0.000077	0.000076	0.000687	0.000011	0.000038	0.000025	0.002450	0.000464	0.000524	0.000105	0.000024	0.000009	0.000247	0.000018	0.000202	0.000046	0.000388	0.000058	0.000068	0.000896	0.000886	0.002783	0.013747	0.000290	0.000077	0.004672	0.001516	0.004378	0.000524	0.004425	0.000951	0.011278	0.002711	0.000467	0.001485	0.001392	0.002645	0.007501	0.000214	0.000136	0.002767	0.000217	0.003068	0.004638	0.000771	0.000348	0.000063	0.002776	0.000098	0.000442	0.000662	0.000037
121423037 - Caribou - Suddenly - Magpie	121423037	0.030976	0.000339	0.000519	0.002252	0.000161	0.000273	0.000489	0.000225	0.000205	0.000108	0.000146	0.000078	0.000037	0.000040	0.000300	0.001556	0.000308	0.000266	0.000222	0.000111	0.000202	0.000084	0.000515	0.000565	0.000494	0.000333	0.000501	0.036668	0.000358	0.000157	0.000160	0.000323	0.001408	0.002981	0.001349	0.001078	0.003132	0.000336	0.000540	0.000025	0.000589	0.000331	0.000073	0.000056	0.000215	0.000045	0.000179	0.000358	0.000186	0.000277	0.000085	0.000069	0.000027	0.000164	0.000245	0.000164	0.000027	0.000176	0.000123	0.000384	0.000177	0.000245	0.000147	0.000196	0.002270	0.006203	0.000114	0.000020	0.000037	0.000294	0.000068	0.000018	0.004014	0.002654	0.002004	0.000555	0.000409	0.000832	0.000568	0.000197	0.000291	0.000631	0.000118	0.000513	0.000121	0.000103	0.000268	0.000153	0.000144	0.000048	0.000061	0.000064	0.000143	0.000139	0.000323	0.000119	0.000193	0.000165	0.000648	0.000381	0.000172	0.000391	0.000131	0.000125	0.000178	0.000320	0.000145	0.000138	0.000045	0.000044	0.000138	0.000917	0.000360	0.000271	0.000029	0.000139	0.000102	0.000154	0.000183	0.000259	0.000079	0.000027	0.000626	0.000131	0.000124	0.000106	0.000449	0.000203	0.000185	0.000200	0.000297	0.000082	0.000426	0.000229	0.000055	0.000260	0.000024	0.723784	0.049436	0.002748	0.003556	0.000900	0.001157	0.000685	0.000580	0.000178	0.000461	0.000162	0.000066	0.000222	0.000334	0.000269	0.069622	0.058441	0.078594	0.004997	0.007383	0.001577	0.213658	0.054285	0.001206	0.002078	0.003959	0.092104	0.005518	0.001345	0.001002	0.000441	0.002824	0.000314	0.000094	0.000541	0.000536	0.000314	0.000115	0.000100	0.000081	0.000416	0.000449	0.002627	0.003206	0.003993	0.001025	0.000471	0.000534	0.002247	0.001508	0.001387	0.000770	0.000625	0.000092	0.000808	0.000722	0.000325	0.000208	0.001012	0.000649	0.000341	0.000407	0.000751	0.000409	0.000181	0.000226	0.000091	0.000097	0.000493	0.000245	0.000052	0.000245	0.000139	0.000038	0.000328	0.000455	0.004124	0.001672	0.000416	0.015612	0.017036	0.000233	0.002408	0.000591	0.001395	0.001256	0.001391	0.001214	0.000364	0.017028	0.007864	0.002431	0.001217	0.000551	0.000294	0.003890	0.000496	0.001819	0.002556	0.002114	0.001314	0.000190	0.059405	0.008650	0.008634	0.015529	0.010709	0.025335	0.003423	0.044855	0.007012	0.000851	0.000269	0.000155	0.003473	0.007306	0.007641	0.000648	0.000177	0.003401	0.002254	0.002460	0.001897	0.001960	0.000086	0.000326	0.000571	0.000238	0.017649	0.005977	0.006561	0.005095	0.002617	0.008460	0.006104	0.002460	0.001629	0.003643	0.000547	0.003840	0.001439	0.001664	0.008272	0.003947	0.000107	0.000076	0.000120	0.000125	0.000111	0.000049	0.000063	0.000243	0.000083	0.000065	0.000074	0.000088	0.000051	0.000056	0.000050	0.000082	0.000157	0.000034	0.000074	0.001798	0.000172	0.000049	0.000078	0.000080	0.000025	0.000112	0.000436	0.000972	0.000139	0.000062	0.000007	0.000025	0.000040	0.000062	0.000098	0.000123	0.000028	0.000354	0.000018	0.000147	0.000059	0.000248	0.000199	0.000112	0.000073	0.000139	0.000031	0.000211	0.000285	0.000086	0.000156	0.000195	0.000006	0.000047	0.000127	0.000019	0.000029	0.000034	0.000041	0.000089	0.000197	0.000143	0.000174	0.000014	0.000012	0.000033	0.000031	0.000066	0.000053	0.000011	0.000022	0.000050	0.000131	0.000166	0.000408	0.001255	0.000060	0.000054	0.000236	0.000364	0.000391	0.000013	0.000026	0.000087	0.000050	0.000054	0.000039	0.000051	0.000037	0.000072	0.000044	0.000170	0.000014	0.000022	0.000008	0.000016	0.000044	0.000108	0.000235	0.000062	0.000124	0.000089	0.000048	0.000302	0.000075	0.000434	0.000299	0.000823	0.000931	0.000254	0.005049	0.000397	0.004445	0.005373	0.000385	0.000666	0.000139	0.000540	0.001163	0.000852	0.000579	0.000357	0.000061	0.000069	0.000030	0.000181	0.000293	0.000257	0.000025	0.000008	0.000031	0.000075	0.000011	0.000047	0.000042	0.000123	0.000240	0.000236	0.000027	0.000011	0.000024	0.000033	0.000013	0.000095	0.000087	0.000120	0.000179	0.000062	0.000031	0.000022	0.000089	0.000052	0.000049	0.000328	0.000036	0.000033	0.000097	0.000144	0.000003	0.000030	0.000181	0.000322	0.000018	0.000128	0.000031	0.000043	0.000127	0.000202	0.000014	0.000087	0.000068	0.000053	0.000367	0.000026	0.000022	0.000017	0.000542	0.000044	0.000218	0.000065	0.000176	0.003070	0.006635	0.005122	0.000104	0.000042	0.000271	0.000057	0.000030	0.000030	0.000146	0.000019	0.000054	0.000276	0.000067	0.000094	0.000743	0.000014	0.000096	0.000092	0.003826	0.000872	0.000815	0.000162	0.000011	0.000009	0.000315	0.000029	0.000301	0.000051	0.000688	0.000052	0.000125	0.000951	0.000668	0.003474	0.001105	0.000547	0.000146	0.007455	0.007505	0.006122	0.001568	0.005539	0.000395	0.012348	0.003174	0.000538	0.001470	0.001243	0.002622	0.010542	0.000155	0.000106	0.001725	0.000175	0.002217	0.009520	0.000249	0.000208	0.000037	0.005113	0.000093	0.000502	0.000442	0.000052
121423038 - Caribou - Suddenly - Ravi	121423038	0.024536	0.000248	0.000428	0.000685	0.000072	0.000201	0.000084	0.000113	0.000118	0.000064	0.000094	0.000033	0.000008	0.000018	0.000177	0.000240	0.000241	0.000063	0.000100	0.000074	0.000076	0.000054	0.000213	0.000254	0.000146	0.000054	0.000108	0.013341	0.000196	0.000502	0.000056	0.000124	0.000711	0.001068	0.000317	0.000304	0.000449	0.000138	0.000160	0.000009	0.000246	0.000069	0.000020	0.000035	0.000038	0.000017	0.000038	0.000113	0.000043	0.000110	0.000037	0.000051	0.000010	0.000057	0.000141	0.000080	0.000011	0.000139	0.000065	0.000092	0.000133	0.000035	0.000022	0.000039	0.000608	0.002503	0.000044	0.000008	0.000045	0.000218	0.000050	0.000028	0.002157	0.001603	0.001067	0.000338	0.000223	0.000378	0.000303	0.000086	0.000186	0.000362	0.000039	0.000336	0.000074	0.000068	0.000322	0.000121	0.000092	0.000041	0.000066	0.000072	0.000407	0.000051	0.000063	0.000151	0.000204	0.000181	0.000844	0.000504	0.000271	0.000331	0.000206	0.000206	0.000205	0.000278	0.000259	0.000229	0.000027	0.000020	0.000058	0.000891	0.000315	0.000272	0.000029	0.000097	0.000078	0.000119	0.000101	0.000109	0.000029	0.000013	0.000285	0.000075	0.000060	0.000042	0.000376	0.000069	0.000265	0.000253	0.000355	0.000091	0.000221	0.000116	0.000024	0.000323	0.000027	0.837504	0.027054	0.002063	0.002536	0.000448	0.000711	0.000353	0.000099	0.000076	0.000266	0.000206	0.000079	0.000205	0.000127	0.000235	0.004470	0.003283	0.002897	0.000274	0.000216	0.000100	0.060459	0.194748	0.000168	0.001345	0.002965	0.257675	0.004598	0.000891	0.000598	0.000388	0.002048	0.000347	0.000062	0.000528	0.000492	0.000223	0.000061	0.000071	0.000115	0.000280	0.000120	0.000475	0.000634	0.000668	0.000202	0.000060	0.000533	0.000801	0.000196	0.000421	0.000273	0.000606	0.000065	0.000738	0.000387	0.000229	0.000134	0.000835	0.000406	0.000128	0.000260	0.000517	0.000170	0.000119	0.000170	0.000032	0.000040	0.000272	0.000237	0.000028	0.000124	0.000119	0.000062	0.000095	0.000230	0.001666	0.000540	0.003096	0.028212	0.011479	0.000163	0.002617	0.000442	0.001049	0.000417	0.000749	0.001235	0.000214	0.009252	0.002355	0.003088	0.000770	0.000985	0.000268	0.012938	0.000402	0.001105	0.002026	0.075339	0.000729	0.000273	0.334250	0.253234	0.078340	0.017532	0.194834	0.121419	0.052319	0.003313	0.093516	0.000740	0.000170	0.000148	0.001838	0.000994	0.000599	0.000565	0.000158	0.002706	0.004814	0.000647	0.000643	0.001147	0.000120	0.000238	0.000650	0.000151	0.004061	0.006563	0.003199	0.002266	0.001215	0.010837	0.000314	0.000852	0.000443	0.048391	0.000115	0.002799	0.001959	0.000176	0.000830	0.014084	0.000022	0.000050	0.000166	0.000044	0.000151	0.000046	0.000050	0.000250	0.000042	0.000028	0.000031	0.000048	0.000030	0.000052	0.000041	0.000070	0.000145	0.000057	0.000074	0.002398	0.000213	0.000040	0.000081	0.000099	0.000034	0.000164	0.000777	0.000375	0.000109	0.000170	0.000010	0.000032	0.000039	0.000083	0.000108	0.000174	0.000031	0.000196	0.000021	0.000037	0.000059	0.000494	0.000565	0.000246	0.000172	0.000178	0.000046	0.000185	0.000257	0.000061	0.000082	0.000157	0.000005	0.000044	0.000108	0.000019	0.000032	0.000024	0.000042	0.000072	0.000137	0.000098	0.000173	0.000009	0.000018	0.000036	0.000014	0.000063	0.000039	0.000009	0.000051	0.000044	0.000125	0.000155	0.000083	0.000291	0.000083	0.000041	0.000077	0.000082	0.000214	0.000009	0.000031	0.000176	0.000102	0.000020	0.000050	0.000078	0.000059	0.000081	0.000058	0.000062	0.000027	0.000036	0.000012	0.000021	0.000033	0.000054	0.000425	0.000095	0.000035	0.000084	0.000033	0.000128	0.000046	0.000151	0.000102	0.000757	0.000300	0.000139	0.001508	0.000185	0.001228	0.002008	0.000246	0.001436	0.000282	0.000446	0.000675	0.001001	0.000177	0.000367	0.000050	0.000099	0.000043	0.000141	0.000203	0.000183	0.000044	0.000010	0.000036	0.000059	0.000015	0.000042	0.000049	0.000070	0.000169	0.000161	0.000023	0.000005	0.000010	0.000032	0.000010	0.000052	0.000062	0.000219	0.000191	0.000082	0.000038	0.000030	0.000094	0.000079	0.000076	0.000568	0.000056	0.000024	0.000076	0.000059	0.000003	0.000041	0.000272	0.000326	0.000056	0.000215	0.000034	0.000063	0.000085	0.000410	0.000026	0.000064	0.000049	0.000096	0.000261	0.000025	0.000042	0.000018	0.000379	0.000044	0.000371	0.000030	0.000090	0.000657	0.002298	0.000596	0.000039	0.000022	0.000070	0.000023	0.000023	0.000078	0.000075	0.000020	0.000033	0.000532	0.000114	0.000067	0.001027	0.000021	0.000053	0.000061	0.001186	0.000144	0.000232	0.000078	0.000008	0.000010	0.000304	0.000014	0.000204	0.000057	0.000320	0.000045	0.000127	0.000755	0.000193	0.004463	0.001937	0.000758	0.000099	0.006031	0.002248	0.001133	0.000720	0.007174	0.003664	0.006466	0.002380	0.000430	0.001411	0.001114	0.000735	0.005168	0.000211	0.000094	0.008252	0.000221	0.000953	0.007763	0.000393	0.000176	0.000037	0.005929	0.000118	0.000353	0.000296	0.000037
121423039 - Caribou - Suddenly - Cloud Song.part	121423039	0.040744	0.000519	0.000528	0.001216	0.000111	0.000348	0.000214	0.000173	0.000118	0.000059	0.000084	0.000052	0.000013	0.000010	0.000299	0.000594	0.000309	0.000185	0.000155	0.000073	0.000132	0.000089	0.000333	0.000210	0.000331	0.000125	0.000560	0.028977	0.000163	0.000144	0.000171	0.000649	0.002055	0.001439	0.000461	0.000255	0.000565	0.000763	0.000348	0.000063	0.000451	0.000238	0.000074	0.000193	0.000099	0.000060	0.000107	0.000513	0.000168	0.000672	0.000089	0.000034	0.000017	0.000057	0.000139	0.000091	0.000033	0.000063	0.000366	0.000241	0.000163	0.000038	0.000049	0.000057	0.000113	0.000869	0.000042	0.000014	0.000032	0.000227	0.000046	0.000012	0.003119	0.002525	0.001950	0.000466	0.000340	0.000595	0.000356	0.000217	0.000273	0.000412	0.000136	0.000264	0.000076	0.000077	0.000263	0.000064	0.000065	0.000023	0.000070	0.000070	0.000261	0.000066	0.000106	0.000131	0.000158	0.000123	0.000637	0.000347	0.000160	0.000432	0.000141	0.000125	0.000113	0.000160	0.000115	0.000125	0.000067	0.000066	0.000164	0.000954	0.000443	0.000381	0.000029	0.000123	0.000108	0.000136	0.000134	0.000270	0.000056	0.000026	0.000454	0.000115	0.000101	0.000061	0.000470	0.000227	0.000115	0.000214	0.000181	0.000125	0.000186	0.000090	0.000059	0.000156	0.000016	0.832505	0.146889	0.004391	0.005660	0.001002	0.002195	0.001147	0.000292	0.000244	0.000674	0.000155	0.000090	0.000187	0.000163	0.000531	0.111670	0.068964	0.086270	0.000692	0.000825	0.000198	0.663105	0.133250	0.000638	0.001332	0.001281	0.177149	0.002606	0.000346	0.000242	0.000115	0.000705	0.000056	0.000079	0.000225	0.000212	0.000349	0.000058	0.000043	0.000031	0.000196	0.000155	0.000978	0.001483	0.001530	0.000345	0.000090	0.000422	0.001217	0.000385	0.000617	0.000327	0.001105	0.000102	0.000789	0.000826	0.000413	0.000261	0.001093	0.000505	0.000480	0.000312	0.000605	0.000300	0.000103	0.000087	0.000119	0.000091	0.000194	0.000130	0.000017	0.000419	0.000249	0.000034	0.000204	0.000196	0.002843	0.000767	0.000170	0.007078	0.004510	0.000239	0.001104	0.000299	0.000515	0.000308	0.000433	0.000527	0.000115	0.007059	0.003421	0.001680	0.000736	0.000226	0.000219	0.002198	0.000674	0.001811	0.002602	0.001930	0.001067	0.000134	0.130560	0.035287	0.024065	0.018288	0.001664	0.036641	0.012358	0.005850	0.020072	0.000740	0.000192	0.000107	0.003065	0.004701	0.003768	0.000987	0.000187	0.003011	0.002655	0.000955	0.001261	0.001226	0.000268	0.000203	0.000286	0.000474	0.009475	0.004703	0.003799	0.003698	0.000867	0.007446	0.006386	0.001850	0.000873	0.004290	0.000356	0.002000	0.001245	0.001960	0.006316	0.002142	0.000012	0.000068	0.000059	0.000077	0.000056	0.000019	0.000024	0.000236	0.000030	0.000027	0.000024	0.000051	0.000020	0.000030	0.000023	0.000035	0.000102	0.000021	0.000043	0.001365	0.000122	0.000030	0.000049	0.000047	0.000014	0.000094	0.000332	0.000335	0.000036	0.000051	0.000007	0.000017	0.000019	0.000047	0.000056	0.000133	0.000045	0.000204	0.000016	0.000040	0.000068	0.000120	0.000099	0.000054	0.000046	0.000080	0.000016	0.000132	0.000190	0.000030	0.000055	0.000127	0.000004	0.000038	0.000114	0.000017	0.000020	0.000029	0.000044	0.000086	0.000124	0.000036	0.000133	0.000010	0.000015	0.000032	0.000013	0.000047	0.000038	0.000009	0.000028	0.000043	0.000088	0.000145	0.000211	0.000607	0.000048	0.000042	0.000100	0.000093	0.000334	0.000017	0.000027	0.000115	0.000082	0.000013	0.000027	0.000091	0.000029	0.000067	0.000053	0.000061	0.000008	0.000047	0.000002	0.000018	0.000023	0.000043	0.000145	0.000051	0.000083	0.000050	0.000017	0.000130	0.000021	0.000195	0.000169	0.001527	0.000586	0.000328	0.007203	0.000227	0.002987	0.001752	0.000446	0.000360	0.000037	0.000410	0.001545	0.001608	0.000031	0.000434	0.000021	0.000084	0.000040	0.000211	0.000409	0.000335	0.000034	0.000014	0.000055	0.000041	0.000012	0.000068	0.000104	0.000126	0.000085	0.000198	0.000027	0.000006	0.000012	0.000046	0.000007	0.000057	0.000075	0.000139	0.000231	0.000054	0.000017	0.000038	0.000162	0.000068	0.000054	0.000387	0.000028	0.000023	0.000109	0.000079	0.000002	0.000014	0.000264	0.000276	0.000039	0.000160	0.000021	0.000030	0.000073	0.000207	0.000024	0.000059	0.000037	0.000051	0.000152	0.000023	0.000021	0.000029	0.000672	0.000062	0.000241	0.000039	0.000059	0.006804	0.007731	0.002037	0.000020	0.000029	0.000120	0.000034	0.000018	0.000044	0.000054	0.000035	0.000035	0.000030	0.000072	0.000089	0.000354	0.000003	0.000044	0.000042	0.003319	0.000769	0.001170	0.000460	0.000017	0.000010	0.000241	0.000020	0.000184	0.000039	0.000415	0.000022	0.000029	0.000933	0.000445	0.000534	0.000537	0.000745	0.000057	0.004833	0.003768	0.012070	0.001936	0.008579	0.000659	0.013047	0.002350	0.000390	0.001172	0.001173	0.002907	0.006988	0.000102	0.000123	0.000322	0.000125	0.002691	0.004819	0.001044	0.000174	0.000021	0.000508	0.000120	0.000178	0.000181	0.000044
213181249 - Flume - Palaces - Say Nothing (feat. MAY-A)	213181249	0.050583	0.000631	0.000565	0.001842	0.000115	0.000331	0.000420	0.000086	0.001267	0.000832	0.000835	0.000530	0.000129	0.000149	0.002291	0.000404	0.000799	0.000251	0.000311	0.000198	0.000228	0.000150	0.001227	0.001490	0.001375	0.000385	0.000456	0.070465	0.000511	0.000566	0.000272	0.000326	0.001346	0.003195	0.000853	0.001654	0.009015	0.001247	0.000761	0.000055	0.000962	0.000649	0.000113	0.000254	0.000375	0.000097	0.000144	0.000518	0.000244	0.000291	0.000245	0.000147	0.000067	0.000201	0.000173	0.000116	0.000066	0.000338	0.000307	0.000946	0.000550	0.000234	0.000117	0.000152	0.001402	0.000899	0.000310	0.000029	0.000083	0.000853	0.000083	0.000066	0.006958	0.005448	0.004335	0.000981	0.000907	0.001617	0.001123	0.000401	0.000802	0.001096	0.000356	0.000736	0.000313	0.000244	0.000449	0.000323	0.000268	0.000111	0.000149	0.000135	0.000112	0.000202	0.000375	0.000376	0.000665	0.000532	0.001100	0.000672	0.000321	0.000377	0.000360	0.000307	0.000186	0.000292	0.000301	0.000302	0.000097	0.000086	0.000302	0.001613	0.000670	0.000559	0.000057	0.000252	0.000175	0.000271	0.000287	0.000950	0.000256	0.000034	0.001116	0.000260	0.000716	0.000110	0.000886	0.000418	0.000344	0.000373	0.002146	0.000187	0.000483	0.000150	0.000118	0.000651	0.000086	0.734431	0.014679	0.002300	0.003142	0.000571	0.001237	0.000581	0.000094	0.000169	0.000397	0.000265	0.000155	0.000273	0.000152	0.000304	0.003105	0.002358	0.002122	0.001210	0.000802	0.000485	0.012428	0.018904	0.000218	0.001887	0.002604	0.008382	0.003114	0.001069	0.000773	0.000479	0.001790	0.001796	0.000238	0.000598	0.000506	0.000546	0.000146	0.000236	0.000720	0.000349	0.000091	0.000761	0.001070	0.001145	0.000330	0.000051	0.000823	0.001744	0.000271	0.001250	0.000500	0.000760	0.000146	0.001277	0.000419	0.000394	0.000355	0.003564	0.004104	0.000552	0.000490	0.000217	0.000473	0.000207	0.000493	0.000303	0.000271	0.000467	0.000371	0.000054	0.000909	0.000950	0.000523	0.000565	0.000960	0.002141	0.000702	0.000597	0.156229	0.061901	0.000594	0.004297	0.002036	0.003551	0.002220	0.002580	0.001982	0.000406	0.068507	0.006945	0.013700	0.000783	0.001361	0.000297	0.013526	0.001821	0.005512	0.005079	0.008488	0.000738	0.000325	0.042655	0.012083	0.003932	0.007599	0.021549	0.007255	0.013074	0.005108	0.002763	0.004207	0.000793	0.000278	0.004635	0.002559	0.001781	0.002166	0.000688	0.012344	0.027524	0.004419	0.003404	0.047964	0.000326	0.003585	0.001176	0.000699	0.011457	0.018964	0.003875	0.006811	0.006281	0.012472	0.000722	0.001135	0.002224	0.020545	0.000326	0.005748	0.003221	0.000797	0.003695	0.017353	0.000567	0.000627	0.000157	0.000180	0.000147	0.000059	0.000078	0.000546	0.000081	0.000078	0.000063	0.000159	0.000081	0.000092	0.000074	0.000274	0.000323	0.000059	0.000161	0.003383	0.000318	0.000075	0.000187	0.000117	0.000048	0.000282	0.001191	0.001523	0.000254	0.000930	0.000057	0.000098	0.000115	0.000206	0.000229	0.000231	0.000059	0.000869	0.000040	0.000235	0.000130	0.000839	0.000687	0.000425	0.000206	0.000337	0.000065	0.000297	0.000425	0.000187	0.000169	0.000262	0.000007	0.000061	0.000200	0.000035	0.000060	0.000084	0.000074	0.000128	0.000669	0.000650	0.000276	0.000013	0.000027	0.000051	0.000039	0.000099	0.000061	0.000010	0.000077	0.000067	0.000176	0.000467	0.000746	0.001405	0.000207	0.000163	0.000377	0.000397	0.001181	0.000015	0.000043	0.000143	0.000089	0.000053	0.000049	0.000325	0.000064	0.000189	0.000122	0.000229	0.000066	0.000129	0.000055	0.000054	0.000052	0.000134	0.000315	0.000105	0.000239	0.000521	0.000058	0.000509	0.000174	0.000672	0.000332	0.006189	0.002376	0.002564	0.007224	0.001713	0.004944	0.005715	0.005036	0.002064	0.000335	0.008232	0.010754	0.005009	0.000425	0.005549	0.000368	0.000224	0.000100	0.001207	0.001435	0.001151	0.000084	0.000016	0.000055	0.000142	0.000018	0.000190	0.000104	0.000373	0.000476	0.000278	0.000019	0.000011	0.000029	0.000044	0.000011	0.000156	0.000173	0.000738	0.000448	0.000225	0.000072	0.000099	0.000239	0.000261	0.000139	0.002428	0.000132	0.000124	0.000139	0.000372	0.000007	0.000067	0.000214	0.000281	0.000293	0.000340	0.000119	0.000116	0.000185	0.000741	0.000053	0.000276	0.000076	0.000101	0.000399	0.000042	0.000031	0.000055	0.003049	0.000299	0.000780	0.000188	0.000316	0.000814	0.001801	0.001126	0.000455	0.000566	0.000364	0.000067	0.000063	0.000094	0.000380	0.000067	0.000069	0.000348	0.000142	0.000088	0.000957	0.000014	0.000058	0.000037	0.017805	0.000422	0.000666	0.000149	0.000101	0.000040	0.000430	0.000036	0.000490	0.000053	0.000891	0.000067	0.000410	0.000344	0.000566	0.006498	0.062821	0.000653	0.000110	0.009149	0.010104	0.000630	0.003250	0.005252	0.004660	0.018206	0.007385	0.001423	0.002962	0.002686	0.001083	0.004063	0.000584	0.000239	0.002581	0.001337	0.000995	0.002488	0.001144	0.000807	0.000185	0.003584	0.000164	0.000987	0.001089	0.000066
213181255 - Flume - Palaces - Only Fans (feat. Virgen Maria)	213181255	0.253880	0.001455	0.002601	0.005246	0.000426	0.000738	0.000430	0.000221	0.000395	0.000636	0.000709	0.000228	0.000133	0.000096	0.001972	0.006335	0.001017	0.000308	0.000626	0.000350	0.000297	0.000399	0.000725	0.000427	0.000756	0.000905	0.002024	0.016797	0.000316	0.000136	0.000158	0.000178	0.001135	0.000686	0.000238	0.000333	0.005284	0.000172	0.001347	0.000213	0.001950	0.000804	0.000178	0.000161	0.000488	0.000059	0.000391	0.000903	0.000542	0.003267	0.000263	0.000054	0.000086	0.000169	0.001243	0.000571	0.000069	0.000321	0.002832	0.001439	0.003970	0.000392	0.001296	0.000488	0.001377	0.003464	0.000284	0.000091	0.000034	0.000651	0.000117	0.000018	0.003734	0.003786	0.002832	0.000863	0.000533	0.000666	0.000623	0.000460	0.000440	0.000579	0.000150	0.000455	0.000241	0.000087	0.000182	0.000165	0.000122	0.000122	0.000036	0.000037	0.000058	0.000255	0.000578	0.000117	0.000274	0.000220	0.000479	0.000290	0.000152	0.000223	0.000112	0.000102	0.000173	0.000284	0.000137	0.000133	0.000040	0.000043	0.000246	0.001179	0.000488	0.000498	0.000071	0.000093	0.000076	0.000103	0.000089	0.000253	0.000061	0.000027	0.000703	0.000311	0.000209	0.000199	0.000538	0.000158	0.000240	0.000289	0.001561	0.000097	0.000544	0.000262	0.000064	0.001096	0.000021	0.792885	0.019002	0.001377	0.001741	0.000328	0.000404	0.000312	0.000071	0.000078	0.000244	0.000170	0.000095	0.000130	0.000085	0.000223	0.002296	0.001543	0.001045	0.000132	0.000148	0.000060	0.019429	0.092014	0.000079	0.001407	0.002459	0.132624	0.003711	0.000827	0.000614	0.000308	0.001780	0.000126	0.000108	0.000406	0.000388	0.000432	0.000309	0.000257	0.000234	0.000113	0.000046	0.000406	0.000582	0.000544	0.000089	0.000077	0.000499	0.000967	0.000141	0.000732	0.000320	0.000413	0.000074	0.000729	0.000253	0.000120	0.000062	0.001465	0.000710	0.000190	0.000357	0.000123	0.000445	0.000124	0.000541	0.000601	0.000121	0.000235	0.000181	0.000026	0.000745	0.000270	0.000144	0.000176	0.000197	0.000551	0.000206	0.001528	0.051533	0.034247	0.001069	0.003337	0.001295	0.001991	0.000984	0.001958	0.001947	0.000134	0.010806	0.000981	0.003339	0.000428	0.000696	0.000176	0.012909	0.000384	0.000881	0.002376	0.046258	0.000496	0.000151	0.192295	0.122254	0.039411	0.052537	0.029657	0.065363	0.104921	0.000504	0.035716	0.001357	0.000214	0.000082	0.002264	0.002430	0.000580	0.001492	0.000226	0.003262	0.004678	0.000890	0.000605	0.003062	0.000143	0.000103	0.000768	0.000299	0.004361	0.006978	0.002410	0.001911	0.002585	0.008301	0.000221	0.000340	0.000821	0.057444	0.000101	0.001871	0.001367	0.000122	0.000650	0.014385	0.000208	0.000069	0.000127	0.000108	0.000119	0.000066	0.000071	0.000668	0.000106	0.000078	0.000078	0.000144	0.000072	0.000050	0.000047	0.000173	0.000276	0.000056	0.000186	0.001934	0.000161	0.000035	0.000091	0.000073	0.000016	0.000191	0.000510	0.001134	0.000239	0.000232	0.000007	0.000037	0.000045	0.000060	0.000094	0.000170	0.000055	0.002560	0.000012	0.000049	0.000057	0.000488	0.000429	0.000169	0.000159	0.000184	0.000036	0.000206	0.000266	0.000109	0.000166	0.000188	0.000011	0.000056	0.000117	0.000023	0.000071	0.000047	0.000042	0.000073	0.000319	0.000157	0.000206	0.000012	0.000024	0.000041	0.000040	0.000067	0.000053	0.000018	0.000038	0.000060	0.000129	0.000347	0.000191	0.000345	0.000081	0.000101	0.000401	0.000549	0.000662	0.000012	0.000037	0.000275	0.000158	0.000067	0.000098	0.000100	0.000080	0.000212	0.000158	0.000293	0.000084	0.000081	0.000014	0.000088	0.000069	0.000537	0.000284	0.000248	0.000379	0.000208	0.000333	0.000470	0.000078	0.000696	0.000666	0.002269	0.001010	0.000877	0.002643	0.000320	0.001881	0.002666	0.000668	0.001424	0.000175	0.001242	0.002151	0.004566	0.000159	0.002700	0.000128	0.000195	0.000099	0.000125	0.000231	0.000170	0.000084	0.000024	0.000062	0.000106	0.000014	0.000064	0.000018	0.000156	0.000281	0.000327	0.000035	0.000011	0.000027	0.000059	0.000019	0.000153	0.000156	0.000393	0.000408	0.000105	0.000049	0.000023	0.000774	0.000220	0.000204	0.001830	0.000058	0.000122	0.000151	0.000194	0.000010	0.000245	0.000213	0.000387	0.000120	0.000514	0.000068	0.000126	0.000595	0.001390	0.000074	0.000199	0.000098	0.000147	0.000840	0.000045	0.000060	0.000081	0.000284	0.000064	0.000631	0.000110	0.000428	0.000227	0.000594	0.000173	0.000089	0.000517	0.001030	0.000126	0.000039	0.000182	0.000157	0.000065	0.000058	0.000320	0.000290	0.000123	0.001589	0.000017	0.000196	0.000312	0.003501	0.000707	0.001504	0.000339	0.000053	0.000018	0.000491	0.000031	0.000403	0.000114	0.001061	0.000054	0.000085	0.004914	0.000721	0.003438	0.006051	0.003944	0.000533	0.004190	0.003526	0.001228	0.001409	0.010422	0.001690	0.021081	0.003937	0.000612	0.001427	0.001224	0.000836	0.002269	0.000190	0.000183	0.006042	0.000215	0.000309	0.004163	0.001349	0.000541	0.000106	0.006361	0.000224	0.000394	0.000430	0.000042
213181257 - Flume - Palaces - Love Light	213181257	0.042271	0.000758	0.000600	0.001614	0.000199	0.000663	0.000216	0.000285	0.000997	0.000594	0.000640	0.000228	0.000371	0.000105	0.001062	0.000546	0.000318	0.000135	0.000161	0.000171	0.000114	0.000152	0.000441	0.000789	0.000996	0.000494	0.000204	0.046047	0.001807	0.001789	0.000594	0.001432	0.010423	0.019116	0.010089	0.010628	0.005758	0.000850	0.000375	0.000039	0.000375	0.000214	0.000047	0.000072	0.000149	0.000041	0.000101	0.000183	0.000152	0.000151	0.000127	0.000166	0.000111	0.000306	0.000740	0.000408	0.000102	0.000093	0.000415	0.000222	0.000174	0.000627	0.000101	0.000682	0.000722	0.001291	0.000388	0.000123	0.000149	0.001548	0.000322	0.000061	0.003655	0.002612	0.001735	0.000537	0.000593	0.001715	0.000704	0.000160	0.000375	0.000626	0.000101	0.000417	0.000263	0.000187	0.000363	0.000239	0.000215	0.000085	0.000081	0.000077	0.000229	0.000104	0.000285	0.000169	0.000443	0.000303	0.000701	0.000719	0.000286	0.000616	0.000177	0.000148	0.000129	0.000244	0.000098	0.000103	0.000032	0.000026	0.000117	0.001181	0.000482	0.000390	0.000050	0.000185	0.000140	0.000127	0.000121	0.000471	0.000081	0.000041	0.000521	0.000541	0.000862	0.000223	0.000532	0.000339	0.000095	0.000162	0.001602	0.000111	0.000405	0.000145	0.000143	0.002644	0.000063	0.782746	0.065339	0.004869	0.006181	0.000855	0.000670	0.001473	0.000498	0.000199	0.001310	0.000559	0.000471	0.000374	0.000339	0.000471	0.005858	0.004527	0.002592	0.000896	0.000663	0.000426	0.033475	0.060283	0.000312	0.005948	0.016439	0.262044	0.026067	0.004935	0.004207	0.001000	0.012841	0.000386	0.000318	0.001820	0.001712	0.000841	0.000714	0.000450	0.000238	0.000374	0.000308	0.001028	0.001496	0.001353	0.000230	0.000129	0.001548	0.002695	0.000656	0.001513	0.000690	0.001240	0.000284	0.001821	0.000525	0.000355	0.000257	0.006884	0.001853	0.001349	0.000644	0.000284	0.000593	0.000306	0.000534	0.000196	0.000126	0.000592	0.000325	0.000108	0.002199	0.001499	0.001840	0.000336	0.002748	0.000922	0.000303	0.001598	0.015242	0.054528	0.000462	0.003584	0.001329	0.002750	0.001445	0.001960	0.002368	0.000585	0.028392	0.006322	0.003841	0.001866	0.000675	0.000690	0.004196	0.001636	0.002536	0.005200	0.002652	0.001483	0.000351	0.060545	0.008206	0.005091	0.027422	0.016414	0.015300	0.004319	0.004631	0.001691	0.001091	0.000217	0.000152	0.006048	0.001174	0.001658	0.001825	0.000566	0.001651	0.002918	0.002172	0.001920	0.001358	0.000517	0.000166	0.000441	0.001062	0.010534	0.010078	0.002345	0.002943	0.001913	0.006123	0.004905	0.000588	0.001459	0.004591	0.000349	0.001305	0.001137	0.001362	0.005691	0.005481	0.000126	0.000250	0.000234	0.000218	0.000212	0.000085	0.000102	0.000432	0.000143	0.000118	0.000123	0.000196	0.000064	0.000143	0.000124	0.000202	0.000382	0.000136	0.000519	0.004193	0.000444	0.000119	0.000175	0.000195	0.000114	0.000424	0.001115	0.001474	0.000433	0.000725	0.000065	0.000063	0.000091	0.000221	0.000183	0.000423	0.000107	0.000801	0.000104	0.000467	0.000297	0.001375	0.000580	0.000612	0.000435	0.000204	0.000130	0.000510	0.000691	0.000183	0.000276	0.000397	0.000032	0.000140	0.000213	0.000027	0.000098	0.000072	0.000159	0.000114	0.000620	0.001491	0.000361	0.000039	0.000058	0.000079	0.000042	0.000126	0.000098	0.000024	0.000090	0.000088	0.000249	0.000428	0.000396	0.000578	0.000242	0.000349	0.000456	0.000673	0.000422	0.000031	0.000057	0.000314	0.000190	0.000073	0.000085	0.000506	0.000078	0.000165	0.000095	0.000175	0.000072	0.000102	0.000036	0.000079	0.000108	0.000334	0.000763	0.000398	0.000590	0.000643	0.000081	0.000270	0.000100	0.000351	0.000273	0.004740	0.003912	0.001147	0.006578	0.001883	0.005198	0.006561	0.005159	0.003501	0.000651	0.010321	0.006600	0.007014	0.000311	0.001066	0.000215	0.000469	0.000266	0.001281	0.001692	0.001428	0.000185	0.000058	0.000093	0.000105	0.000050	0.000110	0.000287	0.000289	0.000526	0.000752	0.000163	0.000026	0.000062	0.000135	0.000026	0.000258	0.000279	0.000519	0.000313	0.000171	0.000106	0.000092	0.000165	0.000441	0.000230	0.001411	0.000177	0.000148	0.000329	0.002647	0.000047	0.000088	0.000474	0.000710	0.000123	0.000482	0.000096	0.000140	0.000858	0.001105	0.000081	0.000363	0.000147	0.000213	0.001243	0.000114	0.000048	0.000074	0.000854	0.000094	0.001198	0.000262	0.000176	0.001222	0.001919	0.001387	0.001149	0.000352	0.000568	0.000192	0.000115	0.000124	0.000510	0.000133	0.000134	0.001057	0.000792	0.000240	0.001624	0.000069	0.000119	0.000107	0.007237	0.001552	0.000724	0.000178	0.000053	0.000053	0.001458	0.000065	0.001431	0.000115	0.000940	0.000094	0.000208	0.000528	0.000659	0.007346	0.001623	0.000153	0.000324	0.006537	0.004436	0.003543	0.001287	0.015724	0.005567	0.012794	0.003832	0.001527	0.001845	0.001212	0.003103	0.007447	0.001186	0.000105	0.015071	0.001203	0.000799	0.002095	0.000975	0.001657	0.000213	0.005215	0.000396	0.001136	0.001745	0.000158
213181258 - Flume - Palaces - Sirens (feat. Caroline Polachek)	213181258	0.021494	0.000216	0.000339	0.001421	0.000042	0.000178	0.000171	0.000072	0.000257	0.000189	0.000235	0.000093	0.000116	0.000078	0.000278	0.000256	0.000330	0.000189	0.000182	0.000088	0.000141	0.000068	0.000463	0.000628	0.000505	0.000071	0.000159	0.014665	0.000395	0.000803	0.000111	0.000313	0.000282	0.002069	0.000879	0.001303	0.002512	0.001394	0.000190	0.000026	0.000596	0.000237	0.000058	0.000176	0.000173	0.000053	0.000175	0.000176	0.000104	0.000216	0.000132	0.000079	0.000030	0.000119	0.000268	0.000158	0.000042	0.000055	0.000115	0.000197	0.000107	0.000146	0.000044	0.000164	0.000330	0.000344	0.000201	0.000048	0.000049	0.000602	0.000053	0.000035	0.003032	0.002633	0.001900	0.000362	0.000382	0.002169	0.000414	0.000111	0.000334	0.000539	0.000141	0.000384	0.000241	0.000077	0.000263	0.000160	0.000122	0.000051	0.000083	0.000076	0.000101	0.000064	0.000138	0.000131	0.000238	0.000186	0.000661	0.000488	0.000216	0.000293	0.000230	0.000240	0.000111	0.000165	0.000116	0.000132	0.000049	0.000033	0.000125	0.001013	0.000413	0.000315	0.000024	0.000138	0.000115	0.000147	0.000130	0.000339	0.000080	0.000024	0.000449	0.000196	0.000163	0.000077	0.000421	0.000149	0.000140	0.000189	0.001052	0.000087	0.000232	0.000083	0.000062	0.000648	0.000215	0.801668	0.028081	0.001885	0.002253	0.000427	0.000321	0.000444	0.000189	0.000190	0.000318	0.000157	0.000274	0.000180	0.000232	0.000175	0.003134	0.002386	0.001537	0.000583	0.000424	0.000207	0.014062	0.027746	0.000185	0.001592	0.002926	0.028314	0.004542	0.001101	0.000721	0.000465	0.002297	0.000695	0.000150	0.000689	0.000590	0.000391	0.000134	0.000074	0.000077	0.000305	0.000109	0.000751	0.000904	0.000940	0.000164	0.000063	0.000726	0.003951	0.000989	0.002705	0.000646	0.000816	0.000126	0.002213	0.000359	0.000231	0.000147	0.036644	0.026956	0.001464	0.002151	0.000150	0.000400	0.000227	0.000217	0.000115	0.000165	0.000462	0.000192	0.000062	0.007261	0.001121	0.001165	0.000466	0.012509	0.004458	0.000695	0.002055	0.015691	0.036244	0.000430	0.001724	0.000772	0.000571	0.000375	0.000703	0.000610	0.000138	0.008788	0.001720	0.002265	0.000268	0.000369	0.000092	0.002511	0.000628	0.000895	0.002114	0.003149	0.001299	0.000495	0.307641	0.012948	0.007809	0.214994	0.243253	0.028560	0.023581	0.009533	0.008938	0.000569	0.000219	0.000067	0.001680	0.000941	0.001680	0.000744	0.000220	0.001216	0.001904	0.000727	0.000534	0.003022	0.000544	0.000622	0.000213	0.000706	0.002270	0.006061	0.002821	0.004486	0.001086	0.006715	0.001579	0.000702	0.000587	0.005553	0.000114	0.000706	0.000498	0.000727	0.002190	0.003175	0.000479	0.000649	0.000133	0.000131	0.000131	0.000055	0.000075	0.000336	0.000071	0.000053	0.000053	0.000075	0.000044	0.000084	0.000061	0.000219	0.000181	0.000060	0.000165	0.003543	0.000267	0.000058	0.000112	0.000099	0.000063	0.000293	0.001051	0.001787	0.000569	0.000544	0.000042	0.000050	0.000104	0.000128	0.000184	0.000350	0.000061	0.001159	0.000055	0.000172	0.000097	0.000902	0.000650	0.000602	0.000326	0.000292	0.000089	0.000461	0.000631	0.000232	0.000266	0.000359	0.000012	0.000090	0.000149	0.000029	0.000059	0.000043	0.000102	0.000091	0.000494	0.000302	0.000314	0.000025	0.000022	0.000066	0.000032	0.000104	0.000065	0.000031	0.000087	0.000075	0.000164	0.000520	0.000255	0.000908	0.000198	0.000170	0.000133	0.000253	0.000467	0.000017	0.000071	0.000243	0.000139	0.000035	0.000056	0.000273	0.000064	0.000110	0.000074	0.000089	0.000042	0.000074	0.000022	0.000048	0.000080	0.000114	0.000510	0.000125	0.000340	0.000348	0.000040	0.000241	0.000084	0.000271	0.000190	0.001615	0.000514	0.000330	0.003296	0.000285	0.000475	0.000609	0.001500	0.003798	0.001287	0.001900	0.001631	0.002580	0.000145	0.004076	0.000304	0.000387	0.000172	0.000902	0.001373	0.001220	0.000143	0.000031	0.000117	0.000175	0.000027	0.000132	0.000310	0.000266	0.000445	0.000543	0.000079	0.000013	0.000039	0.000081	0.000015	0.000163	0.000160	0.000401	0.000394	0.000116	0.000092	0.000059	0.000324	0.000179	0.000104	0.001197	0.000065	0.000103	0.000181	0.000431	0.000019	0.000037	0.000328	0.000229	0.000113	0.000262	0.000064	0.000078	0.000365	0.000679	0.000035	0.000112	0.000077	0.000115	0.000403	0.000049	0.000046	0.000037	0.002960	0.000200	0.000906	0.000304	0.000202	0.000576	0.001712	0.000617	0.000136	0.000165	0.000131	0.000070	0.000078	0.000106	0.000140	0.000091	0.000077	0.001303	0.000121	0.000123	0.000472	0.000015	0.000060	0.000028	0.003555	0.000388	0.000440	0.000175	0.000028	0.000055	0.000576	0.000028	0.000392	0.000083	0.000439	0.000069	0.000159	0.000175	0.000326	0.009042	0.012539	0.000210	0.000096	0.005022	0.002453	0.000711	0.001005	0.006764	0.002382	0.012942	0.004492	0.000756	0.001630	0.001295	0.001801	0.007620	0.000352	0.000136	0.004001	0.000969	0.000688	0.000366	0.000682	0.000683	0.000072	0.007448	0.000266	0.000325	0.000398	0.000047
274376169 - Flume - Things Don't Always Go The Way You Plan - Counting Sheep (V2) [2018 Export Wav]	274376169	0.331973	0.002708	0.000654	0.001849	0.000343	0.001884	0.000207	0.007597	0.000241	0.000312	0.000330	0.000064	0.000101	0.000068	0.000396	0.000924	0.000740	0.000368	0.000414	0.000444	0.000363	0.000309	0.000813	0.000930	0.000731	0.000140	0.000639	0.017692	0.000403	0.000222	0.000193	0.000251	0.000640	0.000598	0.000433	0.000544	0.158942	0.000136	0.000701	0.000140	0.000911	0.000485	0.000087	0.000132	0.000191	0.000040	0.000203	0.001157	0.000578	0.000457	0.000105	0.000106	0.000091	0.000093	0.000290	0.000250	0.000021	0.000226	0.000153	0.000297	0.000189	0.000133	0.000184	0.000233	0.005776	0.010108	0.000172	0.000053	0.000080	0.000709	0.000201	0.000048	0.004134	0.002751	0.001691	0.000521	0.000476	0.000414	0.000727	0.000139	0.000428	0.000817	0.000079	0.000560	0.000455	0.000189	0.000319	0.000197	0.000122	0.000059	0.000080	0.000076	0.000060	0.000294	0.000603	0.000152	0.000240	0.000212	0.000900	0.000500	0.000265	0.000276	0.000348	0.000320	0.000265	0.000403	0.000206	0.000219	0.000148	0.000098	0.000139	0.001470	0.000898	0.000952	0.000049	0.000242	0.000201	0.000153	0.000151	0.000557	0.000245	0.000042	0.000467	0.000242	0.000410	0.000088	0.001354	0.000666	0.000530	0.000481	0.001225	0.000160	0.000824	0.000231	0.000365	0.000748	0.000086	0.801437	0.018158	0.001536	0.001605	0.000345	0.000489	0.000291	0.000077	0.000069	0.000223	0.000180	0.000293	0.000155	0.000054	0.000143	0.003322	0.002263	0.001420	0.000154	0.000095	0.000058	0.029995	0.053905	0.000130	0.000984	0.001516	0.041994	0.002227	0.000408	0.000305	0.000168	0.000890	0.000138	0.000104	0.000407	0.000350	0.000132	0.000206	0.000207	0.000181	0.000110	0.000061	0.000361	0.000453	0.000480	0.000091	0.000042	0.000493	0.000774	0.000159	0.000477	0.000177	0.000466	0.000097	0.000754	0.000130	0.000159	0.000084	0.001303	0.000599	0.000259	0.000198	0.000108	0.000188	0.000090	0.000295	0.000070	0.000094	0.000357	0.000248	0.000019	0.000901	0.000305	0.000124	0.000198	0.000303	0.000483	0.000290	0.034298	0.011749	0.275483	0.006905	0.001595	0.001480	0.001139	0.000186	0.001065	0.000829	0.000071	0.003800	0.000598	0.003138	0.000364	0.000277	0.000149	0.006356	0.000230	0.000624	0.002789	0.007493	0.000676	0.000164	0.175953	0.031841	0.013455	0.046266	0.015752	0.019086	0.013097	0.001334	0.009280	0.000635	0.000138	0.000059	0.001096	0.000535	0.000628	0.004052	0.000313	0.001377	0.001146	0.000831	0.000624	0.000845	0.000260	0.000068	0.000571	0.000174	0.003754	0.007592	0.001695	0.001012	0.001233	0.004089	0.000200	0.000210	0.000624	0.007308	0.000054	0.000422	0.001010	0.000129	0.000528	0.004479	0.000219	0.000115	0.000208	0.000097	0.000208	0.000078	0.000095	0.000687	0.000072	0.000062	0.000053	0.000117	0.000039	0.000098	0.000074	0.000219	0.000286	0.000116	0.000186	0.002568	0.000239	0.000060	0.000114	0.000112	0.000040	0.000230	0.000627	0.000454	0.000159	0.000227	0.000019	0.000033	0.000023	0.000120	0.000120	0.000183	0.000037	0.000260	0.000043	0.000086	0.000094	0.000281	0.000197	0.000199	0.000100	0.000294	0.000053	0.000243	0.000338	0.000098	0.000152	0.000221	0.000009	0.000085	0.000245	0.000048	0.000062	0.000053	0.000109	0.000178	0.000366	0.000235	0.000222	0.000015	0.000070	0.000028	0.000019	0.000093	0.000056	0.000013	0.000040	0.000062	0.000149	0.000358	0.000085	0.000257	0.000117	0.000185	0.000086	0.000238	0.000233	0.000014	0.000032	0.000167	0.000102	0.000047	0.000081	0.000057	0.000026	0.000214	0.000157	0.000163	0.000034	0.000111	0.000062	0.000225	0.000065	0.000324	0.000355	0.000059	0.000199	0.001060	0.000059	0.000394	0.000089	0.000465	0.000472	0.001925	0.001455	0.000462	0.001372	0.001053	0.003874	0.007545	0.000562	0.000691	0.000274	0.001415	0.003754	0.002824	0.000045	0.000879	0.000102	0.000222	0.000111	0.000411	0.001427	0.000865	0.000091	0.000011	0.000050	0.000127	0.000019	0.000133	0.000137	0.000496	0.001207	0.000419	0.000103	0.000008	0.000036	0.000094	0.000023	0.000115	0.000198	0.000804	0.000522	0.000111	0.000083	0.000111	0.000398	0.000183	0.000170	0.001942	0.000133	0.000143	0.000137	0.000242	0.000005	0.000068	0.000192	0.000191	0.000196	0.000321	0.000088	0.000179	0.000176	0.000606	0.000087	0.000243	0.000105	0.000093	0.000620	0.000034	0.000040	0.000042	0.003586	0.000379	0.002609	0.000214	0.000078	0.000335	0.000909	0.000234	0.000195	0.000413	0.001294	0.000083	0.000030	0.000087	0.000083	0.000155	0.000113	0.003391	0.000426	0.000189	0.000467	0.000010	0.000081	0.000048	0.006223	0.000271	0.000287	0.000117	0.000019	0.000014	0.000766	0.000042	0.000514	0.000116	0.002050	0.000055	0.000890	0.001945	0.000473	0.020415	0.000182	0.000762	0.000122	0.008854	0.006293	0.000681	0.001304	0.011451	0.005971	0.016684	0.003877	0.000551	0.001887	0.001832	0.001937	0.002267	0.001037	0.000413	0.010260	0.001198	0.000394	0.034756	0.001300	0.001193	0.000101	0.027113	0.000260	0.000935	0.004403	0.000098
274376170 - Flume - Things Don't Always Go The Way You Plan - Nice 2 Know U 1.5.3 [2020 Export Wav]	274376170	0.022529	0.000363	0.000441	0.000712	0.000074	0.000309	0.000082	0.000121	0.000345	0.000329	0.000450	0.000098	0.000063	0.000031	0.000425	0.000205	0.000314	0.000097	0.000213	0.000146	0.000075	0.000136	0.000213	0.000275	0.000866	0.000143	0.000180	0.007766	0.000229	0.000278	0.000081	0.000099	0.000403	0.000680	0.000245	0.000733	0.007440	0.000191	0.000196	0.000042	0.000311	0.000157	0.000026	0.000085	0.000096	0.000050	0.000105	0.000258	0.000186	0.000162	0.000047	0.000042	0.000214	0.000111	0.000145	0.000125	0.000119	0.000051	0.000215	0.000242	0.000111	0.000099	0.000059	0.000193	0.000146	0.000732	0.000095	0.000024	0.000042	0.000374	0.000065	0.000025	0.005903	0.004974	0.004887	0.001106	0.001386	0.001807	0.001675	0.000298	0.001134	0.000447	0.000093	0.000309	0.000155	0.000105	0.000183	0.000155	0.000113	0.000068	0.000043	0.000041	0.000093	0.000080	0.000252	0.000077	0.000254	0.000172	0.000552	0.000288	0.000133	0.000204	0.000216	0.000180	0.000091	0.000172	0.000077	0.000088	0.000060	0.000050	0.000227	0.000690	0.000274	0.000253	0.000014	0.000092	0.000090	0.000069	0.000060	0.000243	0.000061	0.000007	0.000807	0.000175	0.000387	0.000053	0.000230	0.000068	0.000061	0.000104	0.000645	0.000073	0.000108	0.000038	0.000071	0.000642	0.000019	0.860842	0.085627	0.002438	0.002424	0.000500	0.000477	0.000415	0.000171	0.000119	0.000325	0.000209	0.000187	0.000241	0.000260	0.000155	0.018135	0.011536	0.008146	0.000608	0.000627	0.000204	0.166772	0.123602	0.000701	0.002718	0.005410	0.444330	0.010239	0.001639	0.001042	0.000538	0.003724	0.000492	0.000111	0.000828	0.000835	0.000961	0.000145	0.000060	0.000099	0.000162	0.000117	0.000588	0.000995	0.000829	0.000250	0.000075	0.000825	0.001439	0.000282	0.000897	0.000392	0.000777	0.000107	0.001305	0.000624	0.000166	0.000100	0.002439	0.002571	0.000433	0.000454	0.000230	0.000348	0.000208	0.000143	0.000026	0.000034	0.000257	0.000132	0.000085	0.000394	0.000457	0.000177	0.000234	0.000280	0.003887	0.000206	0.009206	0.029114	0.127984	0.000612	0.001549	0.000795	0.000953	0.000211	0.000924	0.000953	0.000107	0.015672	0.001577	0.004381	0.000373	0.000436	0.000156	0.006783	0.000578	0.001765	0.003354	0.009181	0.001396	0.000416	0.175973	0.053813	0.025289	0.049243	0.010540	0.040871	0.049227	0.002519	0.007228	0.000993	0.000215	0.000091	0.001957	0.000653	0.000771	0.000549	0.000080	0.003926	0.011490	0.000392	0.000493	0.001964	0.000260	0.000327	0.000344	0.000664	0.002452	0.002914	0.002771	0.003628	0.001038	0.008271	0.000400	0.001478	0.000376	0.012435	0.000092	0.001105	0.002359	0.000321	0.001859	0.007018	0.000058	0.000137	0.000090	0.000104	0.000097	0.000035	0.000047	0.000223	0.000039	0.000040	0.000028	0.000050	0.000022	0.000041	0.000034	0.000081	0.000178	0.000023	0.000111	0.001381	0.000112	0.000037	0.000062	0.000051	0.000020	0.000124	0.000521	0.000337	0.000070	0.000115	0.000014	0.000060	0.000074	0.000102	0.000114	0.000131	0.000048	0.000182	0.000012	0.000052	0.000063	0.000361	0.000275	0.000156	0.000118	0.000089	0.000038	0.000150	0.000207	0.000072	0.000074	0.000134	0.000007	0.000051	0.000113	0.000025	0.000035	0.000032	0.000040	0.000071	0.000162	0.000185	0.000163	0.000016	0.000011	0.000031	0.000016	0.000074	0.000051	0.000008	0.000065	0.000049	0.000130	0.000584	0.000206	0.000770	0.000206	0.000318	0.000486	0.000551	0.000519	0.000013	0.000069	0.000159	0.000092	0.000114	0.000058	0.000191	0.000039	0.000085	0.000078	0.000055	0.000074	0.000101	0.000004	0.000028	0.000058	0.000096	0.000173	0.000032	0.000154	0.000217	0.000016	0.000181	0.000049	0.000314	0.000151	0.000479	0.000386	0.000162	0.011836	0.000172	0.001342	0.000634	0.000609	0.000829	0.000112	0.000679	0.000567	0.000253	0.000042	0.000969	0.000074	0.000123	0.000039	0.000542	0.002167	0.001403	0.000034	0.000009	0.000038	0.000038	0.000016	0.000096	0.000143	0.000124	0.000173	0.000229	0.000049	0.000004	0.000037	0.000068	0.000015	0.000081	0.000080	0.000390	0.000274	0.000092	0.000039	0.000043	0.000163	0.000100	0.000075	0.001265	0.000041	0.000043	0.000238	0.001595	0.000008	0.000022	0.000110	0.000168	0.000061	0.000208	0.000025	0.000057	0.000270	0.001071	0.000014	0.000130	0.000039	0.000072	0.000359	0.000034	0.000048	0.000028	0.000694	0.000099	0.000969	0.000158	0.000199	0.000749	0.004055	0.001890	0.000297	0.000312	0.000497	0.000103	0.000078	0.000040	0.000356	0.000122	0.000075	0.000824	0.000157	0.000126	0.000954	0.000007	0.000034	0.000013	0.003170	0.000598	0.000310	0.000070	0.000031	0.000010	0.000573	0.000023	0.000526	0.000080	0.000620	0.000039	0.000045	0.000964	0.000408	0.001021	0.012988	0.000517	0.000045	0.007611	0.001286	0.002011	0.000492	0.014039	0.004443	0.011079	0.003256	0.000631	0.000896	0.000771	0.002187	0.005489	0.000181	0.000082	0.001962	0.000187	0.001277	0.000968	0.002752	0.000675	0.000055	0.001065	0.000225	0.000596	0.000453	0.000041
274376171 - Flume - Things Don't Always Go The Way You Plan - Why 1.3 [2012 Export Wav]	274376171	0.068153	0.000826	0.000428	0.001148	0.000152	0.000434	0.000230	0.000212	0.000276	0.000176	0.000300	0.000110	0.000407	0.000070	0.000552	0.000350	0.000585	0.000228	0.000246	0.000228	0.000186	0.000202	0.000527	0.000626	0.000539	0.000166	0.000184	0.022109	0.001236	0.001674	0.000687	0.000545	0.001597	0.002223	0.000634	0.001963	0.003999	0.001152	0.000480	0.000047	0.001235	0.000306	0.000043	0.000076	0.000174	0.000052	0.000191	0.000232	0.000159	0.000411	0.000091	0.000076	0.000050	0.000134	0.000309	0.000167	0.000049	0.000063	0.000169	0.000216	0.000159	0.000306	0.000105	0.000337	0.001672	0.001940	0.000221	0.000066	0.000137	0.000888	0.000123	0.000041	0.003089	0.002470	0.001933	0.000582	0.000462	0.001609	0.000509	0.000167	0.000308	0.000399	0.000057	0.000274	0.000180	0.000122	0.000223	0.000110	0.000089	0.000047	0.000046	0.000041	0.000016	0.000107	0.000123	0.000133	0.000201	0.000160	0.000557	0.000360	0.000166	0.000322	0.000128	0.000133	0.000099	0.000151	0.000132	0.000125	0.000057	0.000044	0.000129	0.000769	0.000304	0.000228	0.000013	0.000140	0.000103	0.000090	0.000084	0.000226	0.000072	0.000011	0.000753	0.000102	0.000152	0.000058	0.000578	0.000147	0.000209	0.000280	0.000601	0.000121	0.000133	0.000053	0.000094	0.000367	0.000066	0.709723	0.028223	0.001725	0.002283	0.000411	0.000352	0.000332	0.000140	0.000126	0.000265	0.000155	0.000179	0.000196	0.000182	0.000277	0.006432	0.003989	0.003394	0.002088	0.001953	0.000729	0.066411	0.061253	0.000284	0.000929	0.002410	0.072432	0.003403	0.000703	0.000561	0.000214	0.001701	0.000275	0.000079	0.000399	0.000347	0.000091	0.000091	0.000042	0.000063	0.000216	0.000096	0.000557	0.000787	0.000734	0.000227	0.000052	0.000879	0.001021	0.000393	0.000606	0.000306	0.000563	0.000109	0.001027	0.000254	0.000213	0.000124	0.004565	0.002801	0.000330	0.000463	0.000112	0.000243	0.000123	0.000207	0.000115	0.000289	0.000268	0.000134	0.000030	0.002370	0.001153	0.000544	0.000507	0.001345	0.007329	0.000715	0.001806	0.018545	0.037124	0.000293	0.002122	0.000760	0.000971	0.000519	0.000910	0.000977	0.000182	0.013267	0.003644	0.002990	0.000485	0.000416	0.000160	0.006382	0.000477	0.001444	0.002142	0.008473	0.001118	0.001080	0.183295	0.034769	0.021321	0.049993	0.044862	0.060669	0.020557	0.017466	0.020551	0.000548	0.000094	0.000090	0.002159	0.000390	0.001512	0.001391	0.000865	0.002020	0.002621	0.001248	0.001341	0.001697	0.000383	0.000318	0.000345	0.000304	0.003094	0.006727	0.002002	0.002433	0.000854	0.005534	0.000930	0.000679	0.000733	0.009974	0.000079	0.000820	0.000705	0.000374	0.001657	0.004789	0.000151	0.000321	0.000162	0.000081	0.000144	0.000056	0.000071	0.000319	0.000072	0.000064	0.000060	0.000086	0.000039	0.000078	0.000057	0.000136	0.000152	0.000086	0.000176	0.002986	0.000234	0.000053	0.000110	0.000091	0.000051	0.000250	0.000867	0.001143	0.000298	0.000495	0.000021	0.000067	0.000071	0.000123	0.000201	0.000262	0.000036	0.000616	0.000032	0.000152	0.000083	0.000866	0.000514	0.000471	0.000271	0.000167	0.000082	0.000277	0.000389	0.000162	0.000182	0.000222	0.000007	0.000093	0.000164	0.000034	0.000053	0.000044	0.000048	0.000127	0.000350	0.000370	0.000234	0.000013	0.000014	0.000034	0.000018	0.000077	0.000056	0.000014	0.000049	0.000054	0.000150	0.000312	0.000324	0.000729	0.000131	0.000127	0.000076	0.000199	0.000144	0.000024	0.000065	0.000181	0.000114	0.000025	0.000055	0.000177	0.000073	0.000151	0.000111	0.000153	0.000063	0.000074	0.000018	0.000057	0.000037	0.000188	0.000484	0.000118	0.000171	0.000396	0.000042	0.000174	0.000054	0.000223	0.000224	0.004034	0.001892	0.000765	0.003999	0.001629	0.005039	0.007574	0.001439	0.002599	0.000535	0.004012	0.003860	0.005048	0.000233	0.001688	0.000145	0.000165	0.000073	0.000458	0.000608	0.000525	0.000064	0.000017	0.000057	0.000075	0.000021	0.000127	0.000084	0.000289	0.000408	0.000426	0.000048	0.000006	0.000042	0.000131	0.000033	0.000133	0.000143	0.000315	0.000470	0.000106	0.000053	0.000053	0.000452	0.000213	0.000161	0.000684	0.000074	0.000062	0.000166	0.000258	0.000005	0.000026	0.000172	0.000131	0.000031	0.000266	0.000054	0.000062	0.000308	0.000760	0.000033	0.000131	0.000069	0.000122	0.000472	0.000037	0.000024	0.000040	0.003617	0.000183	0.000498	0.000170	0.000128	0.000621	0.002727	0.001279	0.000155	0.000137	0.000427	0.000069	0.000033	0.000052	0.000066	0.000085	0.000047	0.000893	0.000251	0.000241	0.000666	0.000006	0.000063	0.000061	0.009254	0.000354	0.000313	0.000091	0.000021	0.000020	0.000533	0.000041	0.000318	0.000068	0.000363	0.000057	0.000223	0.000384	0.000243	0.027926	0.003224	0.000182	0.000133	0.005469	0.008724	0.002275	0.001707	0.008968	0.011488	0.012000	0.003636	0.000757	0.001536	0.001308	0.002568	0.007541	0.000608	0.000124	0.021479	0.001295	0.000923	0.006193	0.000755	0.000815	0.000094	0.032216	0.000196	0.000379	0.001470	0.000076
274376172 - Flume - Things Don't Always Go The Way You Plan - Rhinestone 1.7.2 [2018 Export Wav]	274376172	0.032869	0.000598	0.000403	0.001432	0.000136	0.000402	0.000177	0.000145	0.000588	0.000258	0.000310	0.000140	0.000139	0.000143	0.000711	0.000543	0.000393	0.000204	0.000170	0.000134	0.000157	0.000112	0.000335	0.000470	0.000402	0.000116	0.000257	0.060194	0.000675	0.000096	0.000234	0.000426	0.000941	0.003251	0.000623	0.001540	0.006159	0.000842	0.000199	0.000019	0.000461	0.000498	0.000038	0.000110	0.000368	0.000048	0.000172	0.000329	0.000194	0.000329	0.000100	0.000075	0.000030	0.000142	0.000251	0.000122	0.000023	0.000148	0.000146	0.000427	0.000335	0.000202	0.000304	0.000240	0.004482	0.003537	0.000263	0.000072	0.000077	0.000747	0.000074	0.000072	0.005240	0.003537	0.002762	0.001023	0.000561	0.001388	0.000792	0.000215	0.000381	0.000599	0.000142	0.000337	0.000313	0.000150	0.000276	0.000167	0.000139	0.000048	0.000078	0.000074	0.000069	0.000081	0.000122	0.000164	0.000205	0.000193	0.000653	0.000400	0.000174	0.000284	0.000183	0.000158	0.000115	0.000166	0.000135	0.000134	0.000062	0.000045	0.000133	0.001287	0.000575	0.000460	0.000041	0.000150	0.000105	0.000187	0.000228	0.000477	0.000151	0.000025	0.000769	0.000257	0.000536	0.000088	0.000733	0.000329	0.000229	0.000286	0.001125	0.000154	0.000412	0.000118	0.000137	0.000345	0.000052	0.730124	0.022931	0.002206	0.003054	0.000533	0.001058	0.000590	0.000141	0.000104	0.000418	0.000150	0.000152	0.000147	0.000122	0.000163	0.004768	0.003736	0.003170	0.001206	0.000740	0.000461	0.022438	0.026589	0.000257	0.002081	0.004328	0.035521	0.005446	0.001165	0.000957	0.000276	0.002915	0.001410	0.000117	0.000715	0.000614	0.000301	0.000106	0.000037	0.000050	0.000440	0.000177	0.000917	0.001379	0.001300	0.000300	0.000041	0.001189	0.001548	0.000573	0.000674	0.000429	0.000728	0.000144	0.001366	0.000342	0.000364	0.000222	0.001435	0.001136	0.000375	0.000312	0.000210	0.000717	0.000350	0.000375	0.000273	0.000294	0.000703	0.000530	0.000069	0.000604	0.000310	0.000272	0.000282	0.000544	0.001924	0.000949	0.000378	0.080039	0.063490	0.000221	0.003130	0.002041	0.002414	0.001845	0.002548	0.000930	0.000300	0.152708	0.017015	0.001422	0.000513	0.000220	0.000197	0.007067	0.000488	0.002933	0.003937	0.002845	0.001050	0.000386	0.037273	0.004956	0.002424	0.014185	0.005087	0.009160	0.003030	0.019279	0.002357	0.000547	0.000080	0.000079	0.005890	0.001279	0.003996	0.001038	0.000503	0.001318	0.001392	0.005271	0.003146	0.014037	0.000191	0.000844	0.000214	0.000329	0.013252	0.016241	0.003750	0.005666	0.002018	0.010023	0.002418	0.000353	0.002619	0.005691	0.000328	0.002279	0.000439	0.002713	0.010524	0.008438	0.000261	0.000454	0.000160	0.000156	0.000141	0.000052	0.000066	0.000390	0.000075	0.000091	0.000059	0.000112	0.000052	0.000091	0.000073	0.000210	0.000180	0.000057	0.000121	0.002894	0.000244	0.000061	0.000128	0.000089	0.000046	0.000226	0.000797	0.000670	0.000140	0.000462	0.000050	0.000077	0.000104	0.000131	0.000217	0.000199	0.000058	0.000219	0.000024	0.000114	0.000076	0.000637	0.000476	0.000288	0.000181	0.000269	0.000058	0.000266	0.000368	0.000181	0.000160	0.000230	0.000012	0.000064	0.000172	0.000023	0.000063	0.000065	0.000059	0.000110	0.000469	0.000305	0.000275	0.000012	0.000020	0.000031	0.000048	0.000089	0.000065	0.000010	0.000055	0.000056	0.000198	0.000385	0.000224	0.000666	0.000173	0.000195	0.000282	0.000299	0.000373	0.000023	0.000060	0.000153	0.000115	0.000069	0.000052	0.000187	0.000050	0.000128	0.000073	0.000125	0.000032	0.000079	0.000009	0.000040	0.000053	0.000119	0.000352	0.000096	0.000210	0.000589	0.000043	0.000241	0.000044	0.000339	0.000279	0.001765	0.001570	0.000680	0.002943	0.000897	0.003695	0.003673	0.001019	0.001487	0.000320	0.002166	0.003209	0.002771	0.000453	0.001464	0.000227	0.000212	0.000092	0.000678	0.001353	0.001008	0.000065	0.000015	0.000037	0.000093	0.000016	0.000089	0.000069	0.000277	0.000422	0.000369	0.000050	0.000009	0.000036	0.000050	0.000005	0.000183	0.000183	0.000417	0.000341	0.000093	0.000031	0.000067	0.000279	0.000217	0.000101	0.001252	0.000081	0.000070	0.000196	0.001689	0.000010	0.000050	0.000247	0.000311	0.000182	0.000410	0.000077	0.000072	0.000270	0.001532	0.000044	0.000210	0.000067	0.000110	0.000502	0.000043	0.000030	0.000043	0.001690	0.000356	0.000684	0.000171	0.000159	0.001076	0.002028	0.002110	0.000463	0.000224	0.000482	0.000071	0.000050	0.000077	0.000315	0.000118	0.000066	0.000184	0.000073	0.000091	0.000417	0.000009	0.000052	0.000024	0.004229	0.000574	0.000700	0.000159	0.000039	0.000026	0.000382	0.000045	0.000355	0.000052	0.001119	0.000050	0.000201	0.000644	0.000487	0.024598	0.043841	0.000342	0.000108	0.008798	0.008548	0.001643	0.003825	0.004702	0.008885	0.009592	0.004331	0.000864	0.001358	0.001341	0.001219	0.006188	0.000322	0.000234	0.006546	0.002638	0.000887	0.003135	0.000226	0.000651	0.000095	0.016500	0.000151	0.000620	0.000742	0.000039
274376173 - Flume - Things Don't Always Go The Way You Plan - Dream 1.2.2 [2016 Export Wav]	274376173	0.016983	0.000296	0.000187	0.000272	0.000055	0.000165	0.000050	0.000154	0.000224	0.000195	0.000296	0.000169	0.000042	0.000041	0.000479	0.000042	0.000191	0.000030	0.000057	0.000111	0.000054	0.000068	0.000147	0.000140	0.000288	0.000064	0.000051	0.001980	0.000205	0.000183	0.000724	0.000859	0.000223	0.000156	0.000071	0.000194	0.000232	0.000526	0.000596	0.000309	0.000047	0.000090	0.000019	0.000074	0.000038	0.000021	0.000075	0.000086	0.000046	0.000050	0.000014	0.000110	0.000040	0.000118	0.000074	0.000125	0.000016	0.000007	0.000768	0.000047	0.000323	0.000034	0.000003	0.000030	0.000038	0.000111	0.000202	0.000043	0.000077	0.000901	0.000210	0.000023	0.001582	0.000735	0.000616	0.000107	0.000175	0.000382	0.000181	0.000122	0.000132	0.000151	0.000042	0.000072	0.000175	0.000029	0.000288	0.000072	0.000073	0.000024	0.000102	0.000093	0.000025	0.000094	0.000289	0.000060	0.000189	0.000152	0.000315	0.000303	0.000154	0.000195	0.000047	0.000039	0.000053	0.000081	0.000042	0.000049	0.000090	0.000064	0.000203	0.000403	0.000152	0.000136	0.000004	0.000055	0.000044	0.000050	0.000034	0.000033	0.000008	0.000006	0.000222	0.000025	0.000047	0.000015	0.001016	0.000341	0.000118	0.000337	0.000521	0.000268	0.000203	0.000091	0.000058	0.000352	0.001341	0.789533	0.067994	0.004017	0.006285	0.001096	0.001591	0.000311	0.000186	0.000085	0.000356	0.000076	0.000137	0.000053	0.000079	0.000049	0.033942	0.016933	0.011208	0.001093	0.000538	0.000342	0.260535	0.030082	0.000312	0.001052	0.000694	0.001959	0.001199	0.000199	0.000104	0.000080	0.000321	0.000122	0.000043	0.000206	0.000155	0.000070	0.000049	0.000047	0.000027	0.002229	0.000311	0.001115	0.001327	0.001336	0.000246	0.000019	0.000617	0.000510	0.000092	0.000157	0.000233	0.000599	0.000109	0.000445	0.000144	0.000318	0.000275	0.000656	0.000492	0.000122	0.000126	0.000235	0.000234	0.000055	0.000140	0.000013	0.000028	0.000338	0.000091	0.000020	0.000076	0.000102	0.000034	0.008656	0.000069	0.134770	0.007009	0.000327	0.000769	0.001017	0.000330	0.002128	0.001508	0.000458	0.000446	0.000648	0.000319	0.000233	0.000314	0.000409	0.000139	0.000258	0.000061	0.000073	0.000212	0.000249	0.000469	0.000372	0.000350	0.001135	0.000174	0.183007	0.003624	0.004297	0.006264	0.012124	0.010752	0.002888	0.368333	0.013246	0.000111	0.000074	0.000023	0.000269	0.000104	0.006811	0.001193	0.000106	0.000127	0.000090	0.000303	0.000148	0.000361	0.000364	0.000125	0.000077	0.000203	0.000717	0.000474	0.004771	0.001760	0.000274	0.014233	0.000387	0.002760	0.000238	0.000340	0.000097	0.000123	0.000176	0.001013	0.000996	0.000348	0.000967	0.012820	0.000226	0.000200	0.000220	0.000054	0.000065	0.000296	0.000118	0.000100	0.000124	0.000126	0.000101	0.000143	0.000106	0.000217	0.000195	0.000103	0.000278	0.023161	0.001150	0.000204	0.000066	0.001061	0.000111	0.002471	0.012578	0.000278	0.000129	0.000040	0.000046	0.001819	0.002101	0.002570	0.005327	0.000989	0.000357	0.000229	0.000133	0.000146	0.000329	0.000223	0.000283	0.000150	0.000093	0.004420	0.000308	0.000634	0.000924	0.000138	0.000111	0.000536	0.000048	0.000163	0.000337	0.000087	0.000057	0.000176	0.000289	0.000209	0.001046	0.000310	0.001615	0.000179	0.000047	0.000582	0.002442	0.000913	0.000439	0.000111	0.000306	0.000495	0.002085	0.000256	0.000051	0.000413	0.000107	0.000110	0.000052	0.000076	0.000043	0.000006	0.000006	0.000152	0.000076	0.000029	0.000141	0.000513	0.000245	0.000103	0.000060	0.000053	0.000150	0.000041	0.000006	0.000046	0.000201	0.000237	0.000302	0.000033	0.000071	0.000169	0.000014	0.000042	0.000019	0.000056	0.000055	0.000244	0.000061	0.000045	0.000119	0.000015	0.000161	0.000080	0.000239	0.000999	0.000348	0.000172	0.000091	0.000066	0.000080	0.000211	0.000193	0.000448	0.000191	0.000315	0.000382	0.000585	0.000117	0.000025	0.000147	0.000123	0.000133	0.000012	0.000158	0.000058	0.000090	0.001837	0.000058	0.000197	0.000139	0.000203	0.000020	0.001184	0.000527	0.000292	0.000139	0.000084	0.000086	0.000037	0.000036	0.000105	0.000052	0.000279	0.000120	0.000118	0.000492	0.000094	0.000043	0.000028	0.000345	0.000105	0.000038	0.000132	0.000030	0.000060	0.000076	0.000116	0.000023	0.000077	0.000095	0.000054	0.000159	0.000156	0.000069	0.000044	0.018206	0.000033	0.000625	0.000074	0.000026	0.000325	0.027797	0.004998	0.000199	0.000106	0.000105	0.000049	0.000058	0.000061	0.000043	0.000008	0.000240	0.000059	0.001716	0.000345	0.000179	0.000013	0.000028	0.000019	0.000511	0.000230	0.000040	0.000014	0.000153	0.000039	0.002680	0.000193	0.001533	0.000236	0.000076	0.000113	0.000526	0.000079	0.000121	0.007829	0.000029	0.000034	0.000044	0.005995	0.000368	0.005607	0.000209	0.012881	0.000669	0.008765	0.003013	0.001034	0.004973	0.002861	0.009446	0.010592	0.006588	0.000107	0.001092	0.001431	0.009382	0.000467	0.003861	0.001174	0.000163	0.003100	0.001464	0.000245	0.000427	0.000128
274376174 - Flume - Things Don't Always Go The Way You Plan - beat 58 1.1 [2020 Export Wav]	274376174	0.013292	0.000386	0.000287	0.000532	0.000128	0.000275	0.000064	0.000132	0.000220	0.000140	0.000221	0.000075	0.000089	0.000099	0.000462	0.000102	0.000400	0.000137	0.000106	0.000193	0.000138	0.000145	0.000109	0.000128	0.000125	0.000117	0.000148	0.002974	0.000174	0.000090	0.000038	0.000064	0.000244	0.000313	0.000125	0.000265	0.005183	0.000046	0.000317	0.000031	0.000230	0.000156	0.000038	0.000076	0.000085	0.000039	0.000071	0.000283	0.000144	0.000428	0.000107	0.000071	0.000063	0.000102	0.000128	0.000065	0.000013	0.000067	0.000122	0.000132	0.000222	0.000253	0.000067	0.001009	0.000497	0.001980	0.000224	0.000345	0.000050	0.000528	0.000097	0.000023	0.002994	0.001727	0.001095	0.000285	0.000248	0.000252	0.000349	0.000076	0.000192	0.000409	0.000055	0.000395	0.000317	0.000077	0.000271	0.000175	0.000165	0.000086	0.000073	0.000068	0.002472	0.000077	0.000128	0.000220	0.000309	0.000270	0.000430	0.000357	0.000204	0.000257	0.000075	0.000070	0.000145	0.000297	0.000114	0.000107	0.000068	0.000059	0.000126	0.000788	0.000368	0.000312	0.000013	0.000123	0.000109	0.000103	0.000111	0.000207	0.000068	0.000036	0.000304	0.000136	0.000133	0.000115	0.000538	0.000173	0.000264	0.000280	0.000174	0.000074	0.000593	0.000288	0.000114	0.000412	0.000018	0.758024	0.098668	0.011319	0.006705	0.001069	0.001740	0.001402	0.000256	0.000353	0.000939	0.002775	0.000527	0.010818	0.008459	0.007255	0.029315	0.024283	0.016533	0.000987	0.001142	0.000393	0.114695	0.085694	0.004631	0.004185	0.009862	0.368756	0.014863	0.002569	0.001952	0.000534	0.006775	0.000184	0.000246	0.001955	0.001935	0.001145	0.000117	0.000144	0.000095	0.000193	0.000422	0.004242	0.006117	0.005438	0.000625	0.000457	0.000640	0.000694	0.000199	0.000547	0.000214	0.004146	0.000165	0.004339	0.029259	0.000538	0.000310	0.001462	0.000809	0.000234	0.000325	0.026544	0.000490	0.000176	0.000331	0.000287	0.000021	0.000766	0.000629	0.000286	0.001003	0.000993	0.000530	0.000101	0.000145	0.000336	0.000132	0.005125	0.009485	0.080976	0.000653	0.001797	0.000812	0.000621	0.000280	0.001027	0.000602	0.000160	0.013755	0.002807	0.004401	0.001235	0.000476	0.000991	0.007525	0.000839	0.000993	0.001716	0.003565	0.001611	0.000085	0.119695	0.014054	0.010282	0.050200	0.008264	0.021598	0.007466	0.002155	0.002708	0.000818	0.000371	0.000507	0.002135	0.003179	0.001602	0.000364	0.000070	0.001598	0.001929	0.000900	0.000683	0.001128	0.000098	0.000224	0.000261	0.001907	0.001897	0.000708	0.005662	0.003175	0.001819	0.007807	0.000746	0.003436	0.000658	0.002709	0.000291	0.002414	0.003176	0.000396	0.003106	0.003800	0.000047	0.000076	0.000161	0.000123	0.000155	0.000046	0.000052	0.000448	0.000078	0.000071	0.000069	0.000113	0.000061	0.000061	0.000057	0.000221	0.000197	0.000046	0.000112	0.001998	0.000180	0.000051	0.000108	0.000073	0.000026	0.000164	0.000616	0.000772	0.000187	0.000190	0.000020	0.000053	0.000055	0.000060	0.000093	0.000163	0.000040	0.000702	0.000026	0.000178	0.000081	0.000476	0.000264	0.000258	0.000152	0.000175	0.000042	0.000300	0.000390	0.000160	0.000240	0.000271	0.000008	0.000038	0.000148	0.000033	0.000051	0.000046	0.000049	0.000097	0.000324	0.000140	0.000258	0.000017	0.000026	0.000048	0.000061	0.000104	0.000073	0.000018	0.000085	0.000092	0.000143	0.000222	0.000174	0.000960	0.000087	0.000118	0.000423	0.000281	0.000104	0.000020	0.000038	0.000189	0.000105	0.000049	0.000086	0.000057	0.000091	0.000234	0.000155	0.000129	0.000067	0.000277	0.000009	0.000080	0.000073	0.000042	0.000235	0.000120	0.000039	0.000297	0.000034	0.000144	0.000047	0.000245	0.000079	0.001231	0.000979	0.000451	0.036106	0.000220	0.004921	0.001722	0.000678	0.001082	0.000136	0.000501	0.000442	0.000795	0.000043	0.000322	0.000211	0.000194	0.000116	0.000267	0.000384	0.000302	0.000098	0.000010	0.000061	0.000059	0.000015	0.000063	0.000080	0.000151	0.000241	0.000407	0.000102	0.000033	0.000064	0.000065	0.000024	0.000169	0.000190	0.000191	0.000298	0.000164	0.000028	0.000032	0.000161	0.000090	0.000094	0.000481	0.000053	0.000040	0.000260	0.000480	0.000017	0.000041	0.000285	0.000925	0.000074	0.000291	0.000074	0.000060	0.000142	0.000399	0.000028	0.000111	0.000097	0.000160	0.000408	0.000059	0.000058	0.000026	0.000280	0.000056	0.000334	0.000097	0.000218	0.001486	0.002929	0.000773	0.000095	0.000078	0.001210	0.000215	0.000068	0.000112	0.000095	0.000193	0.000060	0.000659	0.000097	0.000154	0.000501	0.000012	0.000067	0.000027	0.002592	0.001375	0.001762	0.000401	0.000014	0.000008	0.000298	0.000027	0.000447	0.000072	0.000132	0.000065	0.000077	0.004946	0.003558	0.001248	0.006171	0.001241	0.000066	0.005034	0.001979	0.002313	0.000779	0.007618	0.000460	0.010098	0.002130	0.000475	0.001465	0.001420	0.000532	0.001262	0.000226	0.000091	0.001878	0.000189	0.001125	0.004000	0.001456	0.000334	0.000052	0.001337	0.000121	0.000297	0.000814	0.000041
274376175 - Flume - Things Don't Always Go The Way You Plan - Close 1.2 [2016 Export Wav]	274376175	0.039594	0.000444	0.000534	0.002828	0.000104	0.000218	0.000639	0.000061	0.001682	0.001342	0.000987	0.000801	0.000197	0.000283	0.001762	0.000090	0.000382	0.000120	0.000098	0.000148	0.000129	0.000154	0.000534	0.000894	0.000549	0.000172	0.000308	0.020497	0.003161	0.000203	0.002196	0.002506	0.002390	0.003350	0.001989	0.000937	0.000239	0.000593	0.000530	0.000106	0.000234	0.000487	0.000093	0.000150	0.000261	0.000051	0.000270	0.000103	0.000032	0.000497	0.000098	0.000144	0.000108	0.000110	0.000064	0.000044	0.000007	0.000049	0.000059	0.000147	0.000149	0.000054	0.000010	0.000049	0.000291	0.000667	0.000643	0.000029	0.000261	0.004214	0.000500	0.000248	0.003567	0.002178	0.001318	0.000222	0.000211	0.000960	0.000187	0.000140	0.000219	0.000685	0.000074	0.000524	0.000572	0.000175	0.000633	0.000094	0.000077	0.000043	0.000284	0.000259	0.000007	0.000068	0.000112	0.000330	0.000614	0.000470	0.000356	0.000329	0.000145	0.000257	0.000026	0.000023	0.000054	0.000066	0.000103	0.000115	0.000210	0.000174	0.000247	0.000775	0.000277	0.000166	0.000010	0.000151	0.000110	0.000185	0.000166	0.000310	0.000085	0.000012	0.000523	0.000028	0.000062	0.000018	0.000575	0.000107	0.000245	0.000310	0.000647	0.000165	0.000166	0.000061	0.000340	0.000166	0.004532	0.844950	0.049498	0.005094	0.007524	0.001648	0.001803	0.000611	0.000095	0.000433	0.000726	0.000116	0.000178	0.000079	0.000049	0.000128	0.020111	0.011695	0.006180	0.004253	0.001880	0.001594	0.090640	0.019369	0.000729	0.000763	0.001006	0.000866	0.001098	0.000191	0.000131	0.000104	0.000405	0.001038	0.000051	0.000190	0.000122	0.000073	0.000041	0.000062	0.000031	0.000625	0.000057	0.000182	0.000238	0.000211	0.000084	0.000065	0.004084	0.002543	0.000745	0.001242	0.000757	0.001732	0.000432	0.002288	0.000138	0.001119	0.000593	0.005546	0.001521	0.000361	0.000677	0.000174	0.000168	0.000076	0.000040	0.000015	0.000025	0.000046	0.000023	0.000045	0.001926	0.001192	0.001518	0.002632	0.001574	0.057009	0.002527	0.000191	0.004354	0.001181	0.000178	0.010541	0.005753	0.001600	0.000720	0.002144	0.001459	0.000832	0.001343	0.001189	0.000260	0.000384	0.000098	0.000141	0.000673	0.000351	0.001282	0.000792	0.002427	0.004016	0.002158	0.163495	0.009870	0.009531	0.011013	0.010231	0.019965	0.005182	0.150486	0.034418	0.000649	0.000200	0.000055	0.001056	0.000438	0.008181	0.002570	0.000626	0.000225	0.000102	0.001041	0.000878	0.001991	0.000345	0.000216	0.000399	0.000468	0.002785	0.002547	0.009891	0.013566	0.000567	0.030275	0.000615	0.008977	0.000467	0.001390	0.000312	0.000346	0.000612	0.002313	0.001961	0.001886	0.002910	0.121117	0.000193	0.000167	0.000183	0.000043	0.000050	0.000331	0.000041	0.000021	0.000027	0.000106	0.000080	0.000119	0.000082	0.000171	0.000146	0.000065	0.000083	0.005150	0.000300	0.000067	0.000056	0.000122	0.000126	0.000451	0.001193	0.001425	0.000516	0.000080	0.000023	0.000120	0.000098	0.000168	0.000304	0.000618	0.000121	0.002055	0.000028	0.000034	0.000175	0.000833	0.000462	0.000393	0.000424	0.000350	0.000163	0.000823	0.001106	0.000339	0.000467	0.000714	0.000032	0.000232	0.000172	0.000039	0.000026	0.000063	0.000072	0.000116	0.000163	0.000068	0.000270	0.000015	0.000011	0.000036	0.000037	0.000139	0.000104	0.000010	0.000032	0.000090	0.000253	0.000243	0.000032	0.000091	0.000064	0.000114	0.000060	0.000146	0.000127	0.000011	0.000013	0.000035	0.000015	0.000008	0.000032	0.000118	0.000017	0.000072	0.000040	0.000235	0.000019	0.000024	0.000004	0.000022	0.000039	0.000097	0.000058	0.000025	0.000026	0.000213	0.000013	0.000069	0.000008	0.000094	0.000128	0.000382	0.000091	0.000067	0.000204	0.000035	0.000163	0.000387	0.000058	0.003483	0.001673	0.000286	0.000193	0.000621	0.000578	0.000599	0.000115	0.000050	0.000014	0.000020	0.000074	0.000073	0.000010	0.000004	0.000013	0.000083	0.000014	0.000009	0.000040	0.000059	0.000093	0.000122	0.000007	0.000003	0.000018	0.000023	0.000007	0.000063	0.000060	0.000313	0.000144	0.000034	0.000023	0.000072	0.000038	0.000208	0.000069	0.000725	0.000049	0.000068	0.000068	0.000043	0.000002	0.000022	0.000087	0.000055	0.000077	0.000124	0.000060	0.000075	0.000072	0.000107	0.000018	0.000103	0.000047	0.000041	0.000238	0.000016	0.000012	0.000017	0.013044	0.000104	0.001010	0.000239	0.000081	0.000538	0.004841	0.001772	0.000075	0.000408	0.000097	0.000057	0.000072	0.000092	0.000041	0.000039	0.000073	0.000037	0.000126	0.000069	0.000703	0.000001	0.000020	0.000015	0.000953	0.000087	0.000053	0.000016	0.000019	0.000017	0.000905	0.000053	0.000375	0.000058	0.000285	0.000086	0.001327	0.000254	0.000033	0.005635	0.000145	0.000119	0.000035	0.004720	0.001565	0.004515	0.000325	0.015526	0.002649	0.009173	0.015006	0.005959	0.003601	0.002103	0.007372	0.007113	0.001563	0.000171	0.001169	0.000575	0.002510	0.000471	0.002282	0.000754	0.000128	0.007675	0.000273	0.001127	0.000332	0.000135
274376176 - Flume - Things Don't Always Go The Way You Plan - One Step Closer 1.4 [2021 Export Wav]	274376176	0.017340	0.000388	0.000260	0.000836	0.000135	0.000261	0.000260	0.000093	0.000266	0.000155	0.000175	0.000096	0.000091	0.000092	0.000395	0.000181	0.000360	0.000195	0.000170	0.000090	0.000147	0.000078	0.000303	0.000400	0.000287	0.000158	0.000103	0.063541	0.000507	0.000254	0.000534	0.001439	0.004013	0.003471	0.000800	0.001263	0.001143	0.000344	0.000190	0.000012	0.001212	0.000237	0.000037	0.000048	0.000272	0.000037	0.000118	0.000174	0.000100	0.000232	0.000066	0.000036	0.000031	0.000084	0.000049	0.000040	0.000007	0.000036	0.000049	0.000199	0.000093	0.000093	0.000045	0.000106	0.001469	0.000958	0.000179	0.000033	0.000035	0.000432	0.000073	0.000021	0.003552	0.002545	0.001947	0.000718	0.000505	0.000460	0.000604	0.000186	0.000306	0.000407	0.000050	0.000299	0.000358	0.000113	0.000313	0.000107	0.000098	0.000049	0.000070	0.000071	0.000080	0.000083	0.000090	0.000134	0.000219	0.000189	0.000619	0.000379	0.000169	0.000326	0.000109	0.000105	0.000126	0.000193	0.000147	0.000145	0.000039	0.000029	0.000053	0.001051	0.000400	0.000306	0.000102	0.000105	0.000069	0.000252	0.000306	0.000871	0.000201	0.000020	0.000562	0.000118	0.000090	0.000070	0.000696	0.000371	0.000239	0.000201	0.000203	0.000079	0.000487	0.000181	0.000108	0.000211	0.000028	0.646311	0.033808	0.004606	0.007041	0.001159	0.001974	0.001514	0.002403	0.000309	0.000916	0.000159	0.000046	0.000118	0.000296	0.000152	0.042714	0.041036	0.054914	0.007187	0.009266	0.002828	0.048964	0.016617	0.000811	0.004177	0.005894	0.007907	0.008649	0.002554	0.001821	0.000949	0.005094	0.018015	0.000097	0.000876	0.000705	0.000531	0.000151	0.000095	0.000099	0.004652	0.000409	0.000648	0.000870	0.000783	0.000309	0.000253	0.000875	0.001051	0.000308	0.000731	0.000305	0.000601	0.000103	0.000874	0.000538	0.000294	0.000253	0.001471	0.000997	0.000506	0.000237	0.000392	0.000521	0.000292	0.000347	0.000090	0.000250	0.000192	0.000050	0.000055	0.002034	0.000789	0.000238	0.000084	0.000590	0.003072	0.001421	0.000100	0.016741	0.004895	0.000280	0.003175	0.000504	0.001130	0.002043	0.002583	0.001229	0.001934	0.026397	0.048584	0.001604	0.002955	0.000981	0.000470	0.003770	0.001275	0.003072	0.003156	0.001456	0.000880	0.000252	0.017437	0.004137	0.002389	0.003019	0.001348	0.008942	0.001608	0.076397	0.001783	0.001132	0.000223	0.000264	0.007815	0.003999	0.017326	0.001442	0.000280	0.001035	0.000512	0.007149	0.005863	0.003124	0.000081	0.001279	0.000807	0.000830	0.046023	0.015086	0.009642	0.006657	0.003321	0.010643	0.004374	0.001114	0.006075	0.002620	0.001856	0.004796	0.000705	0.007458	0.022943	0.003210	0.000108	0.000518	0.000098	0.000136	0.000090	0.000089	0.000122	0.000234	0.000098	0.000061	0.000071	0.000088	0.000061	0.000066	0.000055	0.000310	0.000115	0.000030	0.000062	0.001898	0.000138	0.000045	0.000054	0.000066	0.000024	0.000146	0.000556	0.001336	0.000259	0.000868	0.000009	0.000030	0.000036	0.000071	0.000079	0.000150	0.000027	0.000427	0.000017	0.000028	0.000083	0.000465	0.000359	0.000205	0.000156	0.000127	0.000052	0.000212	0.000272	0.000113	0.000099	0.000196	0.000011	0.000038	0.000106	0.000020	0.000056	0.000035	0.000045	0.000066	0.000110	0.000096	0.000247	0.000018	0.000021	0.000020	0.000027	0.000093	0.000067	0.000012	0.000033	0.000087	0.000173	0.000169	0.000141	0.000333	0.000053	0.000088	0.000257	0.000189	0.000340	0.000014	0.000019	0.000083	0.000043	0.000048	0.000058	0.000090	0.000020	0.000082	0.000055	0.000077	0.000010	0.000025	0.000007	0.000026	0.000022	0.000060	0.000171	0.000043	0.000033	0.000075	0.000021	0.000073	0.000021	0.000093	0.000150	0.004904	0.000625	0.000357	0.001956	0.000188	0.001509	0.001232	0.000696	0.001293	0.000159	0.003124	0.005713	0.011350	0.000136	0.002508	0.000286	0.000052	0.000026	0.000169	0.000466	0.000421	0.000022	0.000008	0.000015	0.000026	0.000008	0.000017	0.000027	0.000045	0.000087	0.000184	0.000042	0.000016	0.000023	0.000032	0.000018	0.000097	0.000104	0.000265	0.000190	0.000058	0.000011	0.000043	0.000087	0.000189	0.000096	0.000345	0.000048	0.000028	0.000069	0.000112	0.000002	0.000016	0.000123	0.000124	0.000035	0.000129	0.000059	0.000023	0.000074	0.000196	0.000010	0.000133	0.000058	0.000042	0.000491	0.000029	0.000030	0.000023	0.000909	0.000133	0.000155	0.000180	0.000225	0.005097	0.007113	0.007004	0.000120	0.000095	0.000180	0.000045	0.000011	0.000037	0.000130	0.000033	0.000030	0.000083	0.000025	0.000085	0.000795	0.000003	0.000035	0.000015	0.003547	0.000531	0.000623	0.000154	0.000194	0.000006	0.000201	0.000022	0.000204	0.000057	0.000117	0.000042	0.000080	0.000298	0.000255	0.002926	0.000488	0.000380	0.000032	0.002682	0.005469	0.007934	0.001124	0.003849	0.000232	0.008024	0.003446	0.000512	0.000937	0.000921	0.005913	0.016287	0.000110	0.000111	0.000517	0.000251	0.002312	0.000895	0.000130	0.000264	0.000047	0.003832	0.000108	0.000310	0.000448	0.000052
274376177 - Flume - Things Don't Always Go The Way You Plan - SPOKE 2 ALIENS FINALLY 1.3 [2020 Export Wav]	274376177	0.037029	0.000649	0.000569	0.001534	0.000165	0.000684	0.000161	0.000386	0.000222	0.000120	0.000200	0.000051	0.000149	0.000094	0.000382	0.000222	0.001033	0.000195	0.000276	0.000364	0.000286	0.000193	0.000322	0.000485	0.000595	0.000074	0.000035	0.004903	0.000262	0.000672	0.000194	0.000427	0.000333	0.000874	0.000345	0.000810	0.002828	0.001702	0.000193	0.000064	0.001254	0.000313	0.000055	0.000115	0.000166	0.000105	0.000159	0.000170	0.000120	0.000191	0.000109	0.000304	0.000033	0.000159	0.000186	0.000122	0.000043	0.000162	0.000181	0.000243	0.000215	0.000187	0.000035	0.000290	0.003356	0.001821	0.000268	0.000173	0.000164	0.000620	0.000173	0.000090	0.004024	0.002502	0.001731	0.000404	0.000423	0.000621	0.000528	0.000124	0.000443	0.000510	0.000090	0.000368	0.000160	0.000080	0.000415	0.000343	0.000306	0.000109	0.000127	0.000114	0.000079	0.000271	0.000628	0.000230	0.000454	0.000362	0.001913	0.000443	0.000271	0.000199	0.000491	0.000478	0.000537	0.000684	0.000838	0.000897	0.000161	0.000101	0.000250	0.001337	0.000620	0.000396	0.000021	0.000344	0.000183	0.000054	0.000045	0.000404	0.000163	0.000063	0.000381	0.000148	0.000217	0.000104	0.000806	0.000249	0.000302	0.000400	0.000499	0.000234	0.000366	0.000181	0.000111	0.000443	0.000739	0.682173	0.025200	0.002221	0.002604	0.000691	0.000736	0.000392	0.000159	0.000164	0.000395	0.000094	0.000327	0.000239	0.000242	0.000152	0.011293	0.006887	0.005485	0.006356	0.004649	0.002814	0.038383	0.032047	0.000382	0.001872	0.002458	0.013919	0.004308	0.001102	0.000779	0.000501	0.002094	0.000352	0.000373	0.000513	0.000442	0.000375	0.000122	0.000140	0.000139	0.001043	0.000071	0.000388	0.000587	0.000449	0.000254	0.000047	0.000579	0.000820	0.000296	0.000304	0.000183	0.000905	0.000204	0.002404	0.000370	0.000399	0.000247	0.003712	0.004319	0.000394	0.000744	0.000233	0.000150	0.000092	0.000080	0.000045	0.000232	0.000174	0.000079	0.000028	0.000752	0.000886	0.000276	0.004471	0.000826	0.073244	0.003742	0.002221	0.004864	0.018391	0.000924	0.002484	0.001379	0.000571	0.000316	0.001265	0.000490	0.000252	0.003960	0.002097	0.000999	0.000306	0.000215	0.000107	0.001975	0.001100	0.001685	0.001145	0.001143	0.000919	0.000596	0.113596	0.004449	0.005954	0.029839	0.117150	0.026162	0.003132	0.094750	0.005310	0.000526	0.000226	0.000262	0.001171	0.000233	0.005925	0.000704	0.000183	0.001010	0.001425	0.000437	0.000535	0.000809	0.000497	0.002130	0.000130	0.000590	0.001030	0.002348	0.004134	0.004936	0.000381	0.007855	0.000327	0.001834	0.000219	0.001486	0.000173	0.000415	0.000873	0.001167	0.001900	0.002019	0.001391	0.001977	0.000355	0.000150	0.000344	0.000133	0.000159	0.000774	0.000219	0.000191	0.000199	0.000233	0.000096	0.000204	0.000153	0.000139	0.000451	0.000211	0.000291	0.005805	0.000630	0.000143	0.000371	0.000211	0.000096	0.000431	0.001987	0.000659	0.000307	0.000376	0.000067	0.000181	0.000243	0.000272	0.000423	0.000272	0.000071	0.000151	0.000036	0.000040	0.000136	0.000447	0.000531	0.000223	0.000100	0.000411	0.000107	0.000274	0.000338	0.000104	0.000160	0.000244	0.000013	0.000050	0.000180	0.000033	0.000056	0.000072	0.000070	0.000126	0.001140	0.002285	0.000393	0.000026	0.000025	0.000192	0.000148	0.000146	0.000097	0.000049	0.000109	0.000130	0.000265	0.000427	0.000036	0.000120	0.000205	0.000151	0.000182	0.000290	0.000209	0.000019	0.000071	0.000259	0.000113	0.000188	0.000193	0.000172	0.000273	0.000311	0.000192	0.000259	0.000056	0.000140	0.000065	0.000074	0.000123	0.000130	0.000294	0.000257	0.000090	0.000306	0.000183	0.000271	0.000307	0.000273	0.000236	0.001239	0.000611	0.000381	0.001545	0.000512	0.001767	0.001357	0.000535	0.000999	0.000181	0.001229	0.001517	0.001118	0.000555	0.002978	0.000220	0.000390	0.000235	0.000215	0.000585	0.000544	0.000238	0.000030	0.000329	0.000078	0.000017	0.000222	0.000245	0.000224	0.000558	0.000791	0.000111	0.000046	0.000122	0.000163	0.000030	0.000286	0.000252	0.000611	0.000730	0.000567	0.000137	0.000119	0.000260	0.000368	0.000224	0.000695	0.000127	0.000200	0.000587	0.000621	0.000135	0.000103	0.000293	0.000219	0.000093	0.000487	0.000404	0.000192	0.000313	0.000659	0.000064	0.000376	0.000249	0.000228	0.000413	0.000093	0.000081	0.000042	0.007935	0.000257	0.000444	0.000251	0.000126	0.000408	0.002959	0.001579	0.000229	0.000089	0.000234	0.000119	0.000065	0.000124	0.000145	0.000044	0.000088	0.001835	0.000168	0.000362	0.000348	0.000048	0.000175	0.000077	0.002504	0.000127	0.000115	0.000035	0.000099	0.000029	0.000575	0.000038	0.000442	0.000148	0.000200	0.000103	0.000479	0.000395	0.000119	0.066202	0.001515	0.000333	0.000127	0.003332	0.008482	0.001489	0.002325	0.007784	0.003993	0.007563	0.002692	0.000606	0.002630	0.002236	0.001185	0.002826	0.000437	0.000132	0.008183	0.003940	0.001045	0.001427	0.001673	0.000616	0.000085	0.050933	0.000307	0.000393	0.001008	0.000056
274376178 - Flume - Things Don't Always Go The Way You Plan - Things Don't Always Go The Way You Plan 1.2 [2020 Export Wav]	274376178	0.023258	0.000475	0.000334	0.000524	0.000194	0.000313	0.000174	0.000145	0.000242	0.000155	0.000192	0.000065	0.000156	0.000117	0.000395	0.000379	0.000349	0.000134	0.000199	0.000139	0.000160	0.000104	0.000304	0.000414	0.000465	0.000115	0.000177	0.002305	0.000394	0.000096	0.000196	0.000169	0.000374	0.000305	0.000155	0.000254	0.001443	0.000152	0.000247	0.000024	0.000899	0.000368	0.000097	0.000092	0.000115	0.000027	0.000222	0.000114	0.000109	0.000442	0.000119	0.000151	0.000059	0.000241	0.000233	0.000147	0.000017	0.000097	0.000119	0.000317	0.000194	0.000152	0.000086	0.000147	0.001755	0.002355	0.000313	0.000101	0.000130	0.000789	0.000157	0.000049	0.004678	0.003470	0.002337	0.000630	0.000609	0.001771	0.000888	0.000147	0.000405	0.001004	0.000133	0.000601	0.000469	0.000243	0.000391	0.000252	0.000186	0.000093	0.000124	0.000125	0.000036	0.000081	0.000152	0.000126	0.000335	0.000242	0.000598	0.000380	0.000164	0.000251	0.000135	0.000121	0.000200	0.000330	0.000119	0.000112	0.000080	0.000052	0.000209	0.000916	0.000369	0.000296	0.000070	0.000177	0.000153	0.000087	0.000082	0.000181	0.000067	0.000032	0.000823	0.000249	0.000408	0.000143	0.000744	0.000127	0.000189	0.000375	0.001797	0.000222	0.000229	0.000105	0.000173	0.000451	0.000067	0.712734	0.071700	0.004410	0.004807	0.001139	0.000976	0.000955	0.000283	0.000125	0.000868	0.000326	0.000279	0.000540	0.000303	0.000362	0.014745	0.011189	0.007560	0.000651	0.000438	0.000234	0.065939	0.179435	0.001742	0.003408	0.009310	0.236992	0.014128	0.002854	0.002293	0.000641	0.007210	0.005624	0.000094	0.000754	0.000768	0.000183	0.000084	0.000088	0.000037	0.000657	0.000121	0.000673	0.001150	0.000761	0.000333	0.000159	0.005240	0.005274	0.002422	0.002221	0.001756	0.003181	0.000378	0.011092	0.001472	0.001031	0.000484	0.005638	0.003852	0.000761	0.001328	0.000672	0.000489	0.000375	0.000220	0.000086	0.000165	0.000158	0.000081	0.000138	0.001258	0.000685	0.001042	0.000205	0.001807	0.005002	0.000531	0.000945	0.007095	0.023427	0.000104	0.002868	0.001034	0.001120	0.000926	0.002347	0.001295	0.000621	0.008873	0.003547	0.000697	0.001251	0.000865	0.000486	0.005664	0.000404	0.000896	0.003486	0.003128	0.004615	0.000409	0.081065	0.008697	0.015109	0.030840	0.021330	0.044026	0.008080	0.010810	0.005907	0.000343	0.000173	0.000102	0.002462	0.000229	0.001262	0.000170	0.000083	0.000634	0.000764	0.000562	0.000471	0.000758	0.000188	0.000224	0.000136	0.000526	0.003118	0.000932	0.007729	0.011332	0.000860	0.010927	0.000544	0.005001	0.000432	0.002720	0.000279	0.000830	0.000744	0.001138	0.003293	0.006363	0.000709	0.001199	0.000219	0.000432	0.000189	0.000140	0.000232	0.000437	0.000229	0.000177	0.000216	0.000128	0.000082	0.000151	0.000127	0.000297	0.000300	0.000133	0.000207	0.006589	0.000383	0.000091	0.000122	0.000265	0.000107	0.000436	0.002074	0.001149	0.000186	0.000174	0.000021	0.000216	0.000257	0.000572	0.000502	0.000364	0.000141	0.000716	0.000068	0.000121	0.000183	0.000973	0.000871	0.000306	0.000319	0.000367	0.000080	0.000418	0.000646	0.000214	0.000256	0.000376	0.000015	0.000144	0.000419	0.000054	0.000182	0.000098	0.000115	0.000288	0.000600	0.000741	0.000419	0.000027	0.000048	0.000054	0.000039	0.000171	0.000142	0.000014	0.000066	0.000097	0.000496	0.000440	0.000181	0.000274	0.000277	0.000352	0.000134	0.000249	0.000387	0.000046	0.000105	0.000160	0.000081	0.000023	0.000112	0.000583	0.000095	0.000178	0.000127	0.000103	0.000065	0.000085	0.000012	0.000068	0.000240	0.000163	0.000257	0.000055	0.000094	0.000585	0.000077	0.000076	0.000030	0.000099	0.000233	0.001252	0.000794	0.000219	0.002140	0.000216	0.003561	0.002645	0.000696	0.003774	0.001133	0.001837	0.002296	0.002467	0.000937	0.001977	0.000312	0.000133	0.000052	0.000238	0.000583	0.000556	0.000030	0.000007	0.000048	0.000125	0.000048	0.000025	0.000245	0.000112	0.000369	0.000434	0.000184	0.000010	0.000065	0.000069	0.000025	0.000188	0.000195	0.000649	0.000189	0.000044	0.000054	0.000097	0.000111	0.000266	0.000117	0.000951	0.000213	0.000089	0.000192	0.000372	0.000005	0.000019	0.000138	0.000264	0.000025	0.000460	0.000050	0.000132	0.000990	0.001203	0.000049	0.000311	0.000164	0.000194	0.002411	0.000081	0.000030	0.000080	0.000655	0.000216	0.001937	0.000165	0.000218	0.000644	0.002029	0.000814	0.000413	0.000206	0.000675	0.000136	0.000103	0.000032	0.000166	0.000465	0.000152	0.000368	0.000170	0.000201	0.001007	0.000005	0.000058	0.000042	0.005451	0.000592	0.000298	0.000071	0.000028	0.000011	0.001107	0.000094	0.000672	0.000176	0.000207	0.000074	0.000516	0.000537	0.000262	0.022514	0.002042	0.000381	0.000080	0.009570	0.014680	0.003667	0.003279	0.014744	0.002941	0.007626	0.003405	0.001082	0.002181	0.001670	0.000886	0.005869	0.000770	0.000175	0.022154	0.001443	0.001045	0.004026	0.000971	0.002498	0.000196	0.025107	0.000302	0.002254	0.000681	0.000060
4489174 - Mark Ronson - Record Collection - Bang Bang Bang (feat. MNDR)	4489174	0.037313	0.000512	0.000700	0.003362	0.000177	0.000542	0.000953	0.000352	0.000452	0.000643	0.000582	0.000415	0.000031	0.000078	0.001010	0.000549	0.000584	0.000343	0.000250	0.000148	0.000233	0.000106	0.001051	0.001348	0.000641	0.000491	0.000196	0.049690	0.000407	0.000238	0.000153	0.000232	0.001675	0.002118	0.002220	0.001584	0.055145	0.000060	0.000408	0.000022	0.001788	0.000217	0.000058	0.000066	0.000118	0.000016	0.000077	0.000303	0.000150	0.000195	0.000072	0.000050	0.000033	0.000099	0.000254	0.000096	0.000009	0.000317	0.000175	0.000973	0.000253	0.000321	0.000054	0.000117	0.000932	0.000732	0.000133	0.000010	0.000033	0.000329	0.000069	0.000059	0.003453	0.002654	0.001786	0.000543	0.000387	0.000441	0.000551	0.000132	0.000316	0.001008	0.000058	0.000794	0.000113	0.000163	0.000319	0.000191	0.000141	0.000078	0.000080	0.000072	0.000118	0.000143	0.000284	0.000204	0.000410	0.000326	0.000455	0.000269	0.000147	0.000159	0.000104	0.000091	0.000231	0.000482	0.000173	0.000166	0.000040	0.000027	0.000047	0.000916	0.000356	0.000344	0.000032	0.000105	0.000065	0.000140	0.000144	0.000238	0.000042	0.000016	0.000462	0.000147	0.000269	0.000079	0.000370	0.000128	0.000228	0.000190	0.000432	0.000048	0.000267	0.000110	0.000080	0.000300	0.000023	0.826282	0.011826	0.001411	0.002034	0.000384	0.000648	0.000448	0.000050	0.000079	0.000391	0.000198	0.000175	0.000114	0.000086	0.000117	0.001323	0.001085	0.000832	0.000203	0.000152	0.000084	0.002079	0.014878	0.000286	0.001790	0.004804	0.005480	0.004565	0.001607	0.001339	0.000467	0.003145	0.000270	0.000099	0.000901	0.000746	0.000114	0.000078	0.000140	0.000904	0.000068	0.000038	0.000291	0.000399	0.000396	0.000045	0.000016	0.000714	0.000854	0.000121	0.000607	0.000220	0.000315	0.000051	0.000483	0.000157	0.000133	0.000068	0.001812	0.000782	0.000292	0.000167	0.000083	0.000109	0.000034	0.000718	0.000059	0.000039	0.000240	0.000202	0.000015	0.001178	0.000632	0.000356	0.000042	0.000557	0.000305	0.000152	0.000722	0.074640	0.112207	0.000368	0.006600	0.002473	0.016153	0.004134	0.007419	0.014768	0.000714	0.057174	0.008858	0.068729	0.002201	0.002851	0.000624	0.048846	0.001400	0.005018	0.007557	0.015710	0.000510	0.000104	0.011696	0.003958	0.001957	0.001233	0.004016	0.003285	0.001952	0.000397	0.000451	0.005354	0.000749	0.000118	0.008560	0.017977	0.001678	0.001199	0.000227	0.023336	0.039888	0.004580	0.004121	0.004100	0.000144	0.000348	0.010494	0.000443	0.026390	0.021879	0.005725	0.009526	0.023445	0.019032	0.000274	0.001684	0.004222	0.022846	0.000355	0.017378	0.039368	0.000246	0.002789	0.063131	0.000150	0.000107	0.000109	0.000084	0.000114	0.000019	0.000023	0.000253	0.000024	0.000020	0.000019	0.000067	0.000026	0.000045	0.000037	0.000066	0.000154	0.000038	0.000069	0.002129	0.000248	0.000047	0.000127	0.000098	0.000038	0.000129	0.000487	0.000726	0.000167	0.000543	0.000013	0.000025	0.000026	0.000058	0.000056	0.000131	0.000014	0.000907	0.000019	0.000065	0.000041	0.000453	0.000378	0.000269	0.000131	0.000183	0.000027	0.000095	0.000132	0.000054	0.000066	0.000086	0.000002	0.000016	0.000091	0.000015	0.000042	0.000026	0.000037	0.000055	0.000209	0.000163	0.000140	0.000005	0.000017	0.000020	0.000014	0.000054	0.000031	0.000005	0.000016	0.000037	0.000099	0.000161	0.000096	0.000161	0.000056	0.000064	0.000095	0.000133	0.000322	0.000009	0.000015	0.000046	0.000026	0.000056	0.000022	0.000058	0.000012	0.000053	0.000040	0.000133	0.000012	0.000026	0.000035	0.000056	0.000019	0.000183	0.000301	0.000026	0.000090	0.000262	0.000024	0.000187	0.000022	0.000193	0.000260	0.003663	0.000670	0.000536	0.001835	0.000245	0.001418	0.000635	0.000271	0.001716	0.000564	0.004137	0.007244	0.007330	0.000160	0.003034	0.000073	0.000046	0.000020	0.000092	0.000235	0.000210	0.000017	0.000006	0.000009	0.000033	0.000006	0.000017	0.000032	0.000067	0.000334	0.000107	0.000010	0.000003	0.000011	0.000011	0.000004	0.000046	0.000041	0.000197	0.000130	0.000028	0.000021	0.000047	0.000057	0.000065	0.000046	0.001847	0.000040	0.000025	0.000033	0.000072	0.000001	0.000011	0.000098	0.000115	0.000018	0.000161	0.000056	0.000081	0.000117	0.000149	0.000032	0.000122	0.000033	0.000041	0.000215	0.000011	0.000009	0.000012	0.000126	0.000096	0.000199	0.000055	0.000128	0.000344	0.000446	0.000257	0.000100	0.000141	0.000325	0.000048	0.000024	0.000031	0.000180	0.000035	0.000043	0.000286	0.000112	0.000038	0.005073	0.000011	0.000041	0.000057	0.005004	0.000164	0.000189	0.000046	0.000037	0.000009	0.000376	0.000014	0.000215	0.000036	0.000951	0.000019	0.000147	0.000716	0.000959	0.000891	0.001755	0.000476	0.000145	0.004036	0.002499	0.000904	0.000411	0.003249	0.000140	0.007568	0.002042	0.000336	0.001168	0.001325	0.000377	0.000939	0.000177	0.000124	0.002186	0.000142	0.000232	0.000657	0.000449	0.000217	0.000031	0.000607	0.000069	0.000469	0.000584	0.000074
65246012 - TiMO ODV - Origins (EP) - Dancing Again	65246012	0.031035	0.000516	0.000383	0.000832	0.000103	0.000339	0.000088	0.000164	0.000146	0.000121	0.000176	0.000106	0.000110	0.000036	0.000329	0.000652	0.000366	0.000210	0.000173	0.000142	0.000115	0.000117	0.000212	0.000180	0.000306	0.000092	0.000631	0.019910	0.000221	0.000105	0.000323	0.000604	0.000781	0.000542	0.000143	0.000400	0.002407	0.000578	0.000340	0.000055	0.000394	0.000605	0.000112	0.000163	0.000213	0.000129	0.000303	0.000454	0.000216	0.000559	0.000154	0.000065	0.000105	0.000211	0.000414	0.000205	0.000032	0.000241	0.000438	0.000353	0.000318	0.000073	0.000077	0.000073	0.007847	0.010090	0.000158	0.000049	0.000032	0.000484	0.000067	0.000019	0.003843	0.002826	0.002255	0.000936	0.000420	0.000457	0.000689	0.000289	0.000285	0.000252	0.000125	0.000138	0.000273	0.000045	0.000232	0.000144	0.000120	0.000051	0.000057	0.000055	0.000066	0.000142	0.000206	0.000115	0.000192	0.000176	0.000644	0.000396	0.000204	0.000241	0.000185	0.000169	0.000214	0.000287	0.000177	0.000169	0.000077	0.000070	0.000202	0.000956	0.000430	0.000383	0.000038	0.000151	0.000135	0.000103	0.000097	0.000283	0.000074	0.000021	0.000519	0.000215	0.000175	0.000103	0.000530	0.000171	0.000084	0.000207	0.000483	0.000119	0.000587	0.000234	0.000065	0.000677	0.000073	0.751038	0.011847	0.001230	0.001811	0.000293	0.000441	0.000320	0.000062	0.000043	0.000217	0.000084	0.000063	0.000078	0.000062	0.000236	0.002143	0.001482	0.001147	0.000201	0.000180	0.000094	0.020283	0.070749	0.000070	0.001402	0.002274	0.137486	0.003733	0.000902	0.000726	0.000343	0.001861	0.000263	0.000071	0.000460	0.000481	0.000327	0.000138	0.000060	0.000089	0.000243	0.000098	0.000570	0.000750	0.000758	0.000220	0.000032	0.000280	0.000414	0.000093	0.000208	0.000153	0.000298	0.000054	0.000281	0.000181	0.000146	0.000102	0.000593	0.000611	0.000112	0.000126	0.000057	0.000260	0.000084	0.000373	0.000182	0.000252	0.000380	0.000228	0.000014	0.000278	0.000106	0.000021	0.000278	0.000083	0.000555	0.000707	0.002208	0.028077	0.027816	0.001086	0.003380	0.000818	0.002044	0.001228	0.001193	0.001437	0.000284	0.016120	0.002543	0.004140	0.000369	0.000648	0.000104	0.009518	0.000300	0.001033	0.002069	0.022822	0.000283	0.000105	0.141589	0.120898	0.034077	0.016153	0.018744	0.060024	0.052686	0.003819	0.023961	0.000626	0.000072	0.000048	0.002659	0.000747	0.000861	0.001507	0.000297	0.003028	0.005860	0.000679	0.000395	0.002430	0.000123	0.000356	0.000454	0.000152	0.005987	0.006749	0.002391	0.001834	0.000879	0.007770	0.000733	0.000185	0.000673	0.031642	0.000062	0.001240	0.000449	0.000364	0.001466	0.006496	0.000150	0.000086	0.000137	0.000089	0.000131	0.000083	0.000090	0.000608	0.000093	0.000105	0.000077	0.000152	0.000065	0.000062	0.000055	0.000284	0.000274	0.000051	0.000170	0.002694	0.000269	0.000066	0.000185	0.000106	0.000032	0.000216	0.000792	0.000300	0.000106	0.000254	0.000030	0.000125	0.000133	0.000101	0.000250	0.000174	0.000056	0.000179	0.000034	0.000051	0.000036	0.000259	0.000273	0.000136	0.000105	0.000263	0.000038	0.000319	0.000424	0.000170	0.000144	0.000271	0.000024	0.000081	0.000176	0.000042	0.000072	0.000060	0.000079	0.000115	0.000315	0.000182	0.000334	0.000030	0.000039	0.000073	0.000062	0.000101	0.000066	0.000022	0.000126	0.000090	0.000221	0.000350	0.000280	0.000888	0.000171	0.000098	0.000226	0.000240	0.000191	0.000022	0.000053	0.000257	0.000167	0.000027	0.000110	0.000171	0.000132	0.000253	0.000211	0.000135	0.000073	0.000250	0.000008	0.000062	0.000066	0.000173	0.000672	0.000146	0.000140	0.000317	0.000079	0.000174	0.000078	0.000236	0.000269	0.001604	0.001136	0.000920	0.001780	0.000759	0.003108	0.005136	0.001111	0.000717	0.000115	0.001352	0.001112	0.002433	0.000100	0.001209	0.000311	0.000287	0.000128	0.000427	0.000841	0.000629	0.000103	0.000019	0.000091	0.000071	0.000016	0.000183	0.000118	0.000193	0.000183	0.000586	0.000075	0.000011	0.000127	0.000215	0.000051	0.000228	0.000253	0.000288	0.000464	0.000137	0.000055	0.000038	0.000338	0.000144	0.000084	0.000828	0.000059	0.000083	0.000427	0.000301	0.000017	0.000083	0.000210	0.000287	0.000066	0.000408	0.000074	0.000081	0.000327	0.002293	0.000095	0.000235	0.000114	0.000146	0.000401	0.000084	0.000094	0.000043	0.002111	0.000096	0.000639	0.000219	0.000190	0.000408	0.001214	0.000352	0.000145	0.000171	0.000256	0.000087	0.000041	0.000062	0.000199	0.000043	0.000075	0.000412	0.000357	0.000435	0.001163	0.000009	0.000109	0.000070	0.003176	0.000616	0.001033	0.000238	0.000046	0.000026	0.000602	0.000039	0.000468	0.000105	0.000354	0.000082	0.000223	0.000556	0.000412	0.044805	0.003816	0.000328	0.000152	0.003869	0.003891	0.001457	0.001112	0.010259	0.014400	0.007960	0.002667	0.000478	0.001357	0.001468	0.001709	0.005741	0.000171	0.000149	0.013508	0.002036	0.000623	0.023095	0.000574	0.000437	0.000061	0.073907	0.000313	0.000301	0.000624	0.000035
69637475 - Phlegmatic Dogs - Keepmastik - Keepmastik	69637475	0.076630	0.000723	0.000272	0.000531	0.000110	0.000354	0.000046	0.000227	0.000134	0.000147	0.000253	0.000054	0.000106	0.000035	0.000281	0.000153	0.000289	0.000038	0.000077	0.000174	0.000066	0.000102	0.000132	0.000133	0.000153	0.000035	0.000072	0.003700	0.000172	0.000129	0.000087	0.000168	0.000332	0.000139	0.000061	0.000109	0.003437	0.000045	0.000226	0.000059	0.000188	0.000112	0.000044	0.000095	0.000018	0.000040	0.000055	0.000239	0.000101	0.000110	0.000163	0.000187	0.000098	0.000168	0.000187	0.000159	0.000013	0.000490	0.000237	0.000122	0.000234	0.000082	0.000026	0.000242	0.001087	0.001545	0.000194	0.000123	0.000055	0.000785	0.000200	0.000026	0.004366	0.002537	0.002159	0.000732	0.000546	0.000491	0.000960	0.000195	0.000407	0.000272	0.000105	0.000136	0.000154	0.000042	0.000292	0.000337	0.000280	0.000067	0.000068	0.000062	0.000207	0.000243	0.000313	0.000128	0.000156	0.000171	0.001082	0.000407	0.000219	0.000155	0.000423	0.000408	0.000315	0.000361	0.000443	0.000443	0.000174	0.000146	0.000208	0.000883	0.000323	0.000235	0.000006	0.000174	0.000125	0.000072	0.000050	0.000117	0.000052	0.000015	0.000576	0.000127	0.000062	0.000099	0.000540	0.000092	0.000081	0.000284	0.001060	0.000215	0.000728	0.000263	0.000066	0.000604	0.000065	0.835232	0.020148	0.001292	0.001482	0.000339	0.000325	0.000203	0.000062	0.000049	0.000213	0.000127	0.000131	0.000093	0.000052	0.000087	0.002868	0.002044	0.001071	0.000211	0.000116	0.000105	0.019215	0.110410	0.000086	0.001782	0.002372	0.098335	0.004289	0.000870	0.000644	0.000315	0.001784	0.000186	0.000124	0.000431	0.000426	0.000431	0.000099	0.000047	0.000110	0.000150	0.000073	0.000382	0.000644	0.000457	0.000166	0.000032	0.000471	0.000650	0.000147	0.000292	0.000311	0.000378	0.000045	0.000374	0.000149	0.000179	0.000107	0.000919	0.000437	0.000113	0.000242	0.000108	0.000164	0.000073	0.000163	0.000091	0.000127	0.000282	0.000225	0.000017	0.000167	0.000114	0.000059	0.000586	0.000178	0.000554	0.000312	0.011111	0.010088	0.035695	0.000551	0.002142	0.000638	0.000844	0.000249	0.000696	0.000801	0.000094	0.004411	0.000636	0.003740	0.000309	0.000321	0.000112	0.008042	0.000267	0.000543	0.001761	0.028560	0.000609	0.000089	0.352235	0.244453	0.071028	0.037895	0.143673	0.103479	0.150330	0.000975	0.043986	0.000576	0.000100	0.000085	0.001137	0.000204	0.000407	0.000576	0.000045	0.001911	0.004331	0.000304	0.000244	0.000396	0.000199	0.000069	0.000401	0.000150	0.001560	0.004061	0.001967	0.001148	0.000471	0.005482	0.000100	0.000168	0.000246	0.034944	0.000055	0.000966	0.000586	0.000090	0.000375	0.007431	0.000110	0.000058	0.000468	0.000123	0.000436	0.000113	0.000118	0.000425	0.000132	0.000084	0.000108	0.000165	0.000071	0.000158	0.000124	0.000132	0.000322	0.000271	0.000240	0.005576	0.000652	0.000121	0.000376	0.000207	0.000116	0.000548	0.001461	0.001020	0.000276	0.000592	0.000034	0.000052	0.000061	0.000184	0.000162	0.000435	0.000055	0.000696	0.000046	0.000145	0.000115	0.000837	0.000636	0.000438	0.000259	0.000411	0.000139	0.000266	0.000351	0.000091	0.000121	0.000219	0.000010	0.000052	0.000200	0.000034	0.000059	0.000052	0.000092	0.000136	0.000458	0.000844	0.000334	0.000022	0.000017	0.000099	0.000039	0.000121	0.000065	0.000020	0.000090	0.000082	0.000197	0.000284	0.000129	0.000198	0.000107	0.000134	0.000082	0.000202	0.000027	0.000018	0.000051	0.000163	0.000080	0.000033	0.000111	0.000119	0.000060	0.000116	0.000090	0.000050	0.000054	0.000093	0.000006	0.000041	0.000089	0.000114	0.000496	0.000054	0.000055	0.000252	0.000054	0.000121	0.000070	0.000132	0.000073	0.001484	0.000705	0.000302	0.000850	0.000671	0.003118	0.001906	0.000291	0.002793	0.000615	0.001228	0.000867	0.001664	0.000416	0.000480	0.000127	0.000189	0.000078	0.000266	0.000379	0.000322	0.000084	0.000010	0.000048	0.000124	0.000025	0.000046	0.000064	0.000143	0.000243	0.000379	0.000172	0.000009	0.000038	0.000056	0.000008	0.000110	0.000101	0.000455	0.000546	0.000177	0.000077	0.000099	0.000390	0.000439	0.000351	0.001054	0.000158	0.000073	0.000239	0.000358	0.000031	0.000043	0.000211	0.000150	0.000046	0.000280	0.000143	0.000177	0.000130	0.000412	0.000056	0.000204	0.000087	0.000129	0.000255	0.000060	0.000064	0.000034	0.000819	0.000131	0.000578	0.000143	0.000101	0.000212	0.000937	0.000076	0.000285	0.000104	0.000313	0.000088	0.000027	0.000090	0.000192	0.000069	0.000098	0.001069	0.000415	0.000121	0.000783	0.000025	0.000061	0.000055	0.001801	0.000417	0.000383	0.000167	0.000014	0.000026	0.000608	0.000020	0.000497	0.000126	0.000134	0.000055	0.000198	0.000685	0.000331	0.013009	0.000550	0.000284	0.000092	0.003433	0.004041	0.001434	0.000745	0.009778	0.004270	0.004645	0.002053	0.000481	0.002687	0.002212	0.000613	0.002316	0.000550	0.000122	0.027327	0.000931	0.000447	0.017412	0.001521	0.000720	0.000082	0.019186	0.000294	0.000267	0.001209	0.000092
51725440 - Stavroz - The Ginning - The Finishing	51725440	0.017722	0.000202	0.000096	0.000219	0.000054	0.000135	0.000087	0.000098	0.000069	0.000038	0.000090	0.000023	0.000022	0.000022	0.000210	0.000275	0.000231	0.000086	0.000083	0.000062	0.000062	0.000060	0.000085	0.000102	0.000087	0.000020	0.000085	0.000888	0.000084	0.000016	0.000023	0.000053	0.000105	0.000120	0.000039	0.000023	0.000376	0.000034	0.000086	0.000014	0.000125	0.000181	0.000036	0.000063	0.000058	0.000040	0.000063	0.000178	0.000078	0.000133	0.000045	0.000128	0.000088	0.000211	0.000224	0.000239	0.000008	0.000192	0.000110	0.000130	0.000106	0.000046	0.000028	0.000091	0.001304	0.001241	0.000095	0.000043	0.000036	0.000521	0.000227	0.000024	0.001643	0.001080	0.000717	0.000211	0.000198	0.000106	0.000303	0.000066	0.000151	0.000159	0.000044	0.000076	0.000157	0.000031	0.000143	0.000108	0.000112	0.000020	0.000042	0.000041	0.000329	0.000032	0.000069	0.000108	0.000132	0.000139	0.000582	0.000219	0.000134	0.000153	0.000356	0.000302	0.000096	0.000098	0.000113	0.000113	0.000045	0.000033	0.000043	0.001246	0.000787	0.000742	0.000046	0.000245	0.000161	0.000077	0.000085	0.000285	0.000095	0.000057	0.000135	0.000293	0.000278	0.000217	0.000275	0.000309	0.000076	0.000075	0.000133	0.000041	0.000267	0.000129	0.000101	0.000569	0.000039	0.766301	0.265316	0.008755	0.011253	0.001507	0.002631	0.002021	0.000370	0.000181	0.001359	0.000330	0.000225	0.000401	0.000402	0.000302	0.016988	0.025142	0.006897	0.000531	0.000289	0.000700	0.023771	0.020638	0.000162	0.003426	0.004970	0.017045	0.005959	0.000921	0.000733	0.000249	0.001987	0.000098	0.000076	0.000964	0.000828	0.000546	0.000176	0.000069	0.000091	0.000556	0.000232	0.000477	0.001004	0.000587	0.000586	0.000023	0.002721	0.181884	0.000674	0.010311	0.003203	0.004011	0.000132	0.001381	0.003192	0.000987	0.001863	0.222400	0.000748	0.637379	0.006688	0.001444	0.000294	0.000094	0.000123	0.000084	0.000191	0.000435	0.000474	0.000019	0.002377	0.000637	0.000732	0.000648	0.005120	0.001025	0.001289	0.000495	0.004066	0.005559	0.000312	0.001414	0.000620	0.000583	0.000227	0.000837	0.000389	0.000143	0.009173	0.005522	0.001014	0.000746	0.004893	0.000397	0.008437	0.000274	0.000677	0.218986	0.006644	0.003427	0.000017	0.039688	0.037464	0.014579	0.004499	0.003130	0.032483	0.013876	0.007465	0.009123	0.000332	0.000093	0.000500	0.005084	0.000300	0.005262	0.000144	0.000025	0.002155	0.003270	0.000813	0.001280	0.000329	0.000083	0.000111	0.000404	0.000821	0.002244	0.000238	0.004026	0.001680	0.000352	0.004850	0.000437	0.000417	0.000428	0.011060	0.000915	0.002559	0.001000	0.001022	0.006100	0.004660	0.000066	0.000072	0.000163	0.000181	0.000146	0.000035	0.000039	0.000344	0.000072	0.000092	0.000064	0.000133	0.000042	0.000076	0.000058	0.000103	0.000309	0.000090	0.000230	0.003635	0.000363	0.000067	0.000199	0.000123	0.000066	0.000398	0.001369	0.002352	0.000290	0.000438	0.000019	0.000039	0.000046	0.000144	0.000105	0.000182	0.000062	0.000496	0.000016	0.000027	0.000189	0.000489	0.000510	0.000209	0.000149	0.000251	0.000093	0.000162	0.000215	0.000055	0.000110	0.000148	0.000005	0.000043	0.000087	0.000014	0.000020	0.000049	0.000027	0.000070	0.000559	0.000160	0.000183	0.000006	0.000059	0.000041	0.000036	0.000087	0.000042	0.000006	0.000057	0.000043	0.000190	0.000219	0.000091	0.000115	0.000091	0.000063	0.000070	0.000220	0.000347	0.000011	0.000014	0.000140	0.000100	0.000039	0.000079	0.000134	0.000024	0.000146	0.000129	0.000029	0.000021	0.000081	0.000037	0.000040	0.000025	0.000214	0.000386	0.000138	0.000121	0.000094	0.000094	0.000198	0.000043	0.000266	0.000327	0.003491	0.000594	0.000261	0.002856	0.000615	0.000916	0.000685	0.000839	0.001232	0.000140	0.002635	0.004859	0.005896	0.000174	0.001206	0.000097	0.000283	0.000143	0.000421	0.000721	0.000794	0.000122	0.000036	0.000035	0.000046	0.000011	0.000062	0.000069	0.000404	0.000547	0.000268	0.000069	0.000012	0.000024	0.000061	0.000008	0.000092	0.000112	0.000178	0.000375	0.000144	0.000038	0.000055	0.000200	0.000138	0.000080	0.000354	0.000037	0.000066	0.000101	0.000314	0.000006	0.000033	0.000485	0.000469	0.000051	0.000374	0.000036	0.000066	0.000269	0.000876	0.000044	0.000213	0.000036	0.000088	0.000513	0.000040	0.000060	0.000041	0.000574	0.000144	0.000271	0.000075	0.000031	0.003009	0.003629	0.000587	0.000070	0.000038	0.000075	0.000042	0.000029	0.000077	0.000046	0.000064	0.000153	0.000152	0.000469	0.000084	0.000449	0.000010	0.000087	0.000115	0.001301	0.000440	0.000204	0.000107	0.000039	0.000056	0.000616	0.000052	0.000425	0.000109	0.000376	0.000032	0.000669	0.000425	0.000196	0.002661	0.000107	0.000282	0.000131	0.004490	0.005298	0.006426	0.001541	0.004959	0.004785	0.021157	0.005101	0.000624	0.003379	0.002794	0.002518	0.007504	0.000094	0.000297	0.001108	0.000210	0.001812	0.000400	0.000097	0.000167	0.000045	0.004754	0.000099	0.000131	0.000445	0.000072
155112891 - Joji - Nectar - Your Man	155112891	0.034085	0.000683	0.000237	0.000586	0.000102	0.000458	0.000115	0.000257	0.000184	0.000117	0.000206	0.000076	0.000039	0.000032	0.000302	0.000494	0.000326	0.000208	0.000144	0.000106	0.000128	0.000076	0.000185	0.000200	0.000239	0.000109	0.000367	0.024786	0.000237	0.000215	0.000428	0.001104	0.002188	0.000696	0.000155	0.000975	0.005673	0.000188	0.000350	0.000031	0.000530	0.000439	0.000056	0.000061	0.000222	0.000082	0.000161	0.000440	0.000235	0.000291	0.000115	0.000073	0.000051	0.000212	0.000352	0.000248	0.000034	0.000831	0.000109	0.000183	0.000135	0.000024	0.000132	0.000038	0.003019	0.003360	0.000087	0.000019	0.000033	0.000361	0.000098	0.000013	0.004370	0.002956	0.002328	0.000908	0.000456	0.000595	0.000706	0.000216	0.000307	0.000388	0.000102	0.000279	0.000249	0.000072	0.000354	0.000161	0.000161	0.000049	0.000100	0.000104	0.000325	0.000135	0.000194	0.000119	0.000247	0.000219	0.001337	0.000456	0.000245	0.000303	0.000403	0.000400	0.000365	0.000541	0.000507	0.000506	0.000091	0.000060	0.000119	0.001584	0.000587	0.000469	0.000116	0.000168	0.000115	0.000357	0.000370	0.000470	0.000225	0.000051	0.000683	0.000268	0.000255	0.000133	0.000604	0.000312	0.000195	0.000203	0.000695	0.000100	0.000400	0.000155	0.000114	0.000560	0.000054	0.671121	0.018899	0.002120	0.002640	0.000562	0.001139	0.000403	0.000167	0.000156	0.000309	0.000308	0.000180	0.000163	0.000163	0.000170	0.012766	0.009576	0.010482	0.002111	0.002029	0.000847	0.070219	0.071235	0.000550	0.001176	0.002141	0.051895	0.002737	0.000652	0.000506	0.000231	0.001478	0.001137	0.000123	0.000472	0.000416	0.000193	0.000258	0.000191	0.000233	0.000584	0.000254	0.000591	0.000728	0.000749	0.000276	0.000160	0.000587	0.001426	0.000482	0.000687	0.000500	0.000412	0.000071	0.000498	0.000324	0.000239	0.000189	0.001287	0.000436	0.000195	0.000187	0.000180	0.000520	0.000274	0.000936	0.000143	0.000343	0.000345	0.000203	0.000040	0.000590	0.000279	0.000107	0.000843	0.000557	0.002147	0.001116	0.001003	0.029966	0.028919	0.000401	0.003619	0.001221	0.003241	0.001757	0.002531	0.001943	0.000681	0.025704	0.006653	0.004629	0.000881	0.001061	0.000311	0.009804	0.000948	0.003953	0.003476	0.023111	0.000777	0.000245	0.125121	0.072040	0.041795	0.022777	0.025310	0.092761	0.027890	0.027812	0.052725	0.001024	0.000242	0.000097	0.005184	0.001018	0.005041	0.000838	0.000156	0.004766	0.005565	0.001454	0.001362	0.002238	0.000201	0.002362	0.001546	0.000409	0.013696	0.012329	0.005228	0.004592	0.002325	0.014711	0.000836	0.001374	0.001009	0.028578	0.000196	0.002160	0.001637	0.001074	0.003694	0.012149	0.000192	0.000510	0.000160	0.000162	0.000154	0.000084	0.000105	0.000389	0.000102	0.000103	0.000090	0.000121	0.000055	0.000098	0.000075	0.000201	0.000301	0.000065	0.000133	0.002722	0.000269	0.000084	0.000162	0.000089	0.000057	0.000198	0.000851	0.001455	0.000311	0.000378	0.000025	0.000037	0.000049	0.000091	0.000104	0.000136	0.000031	0.000525	0.000018	0.000052	0.000071	0.000237	0.000200	0.000163	0.000083	0.000209	0.000051	0.000268	0.000372	0.000118	0.000162	0.000239	0.000011	0.000049	0.000119	0.000019	0.000045	0.000049	0.000052	0.000072	0.000339	0.000298	0.000254	0.000012	0.000022	0.000035	0.000025	0.000087	0.000072	0.000016	0.000052	0.000077	0.000164	0.000334	0.000285	0.000586	0.000125	0.000086	0.000110	0.000149	0.000584	0.000030	0.000037	0.000254	0.000176	0.000045	0.000068	0.000219	0.000027	0.000128	0.000093	0.000106	0.000017	0.000038	0.000016	0.000037	0.000021	0.000119	0.000703	0.000154	0.000092	0.000210	0.000076	0.000593	0.000091	0.000591	0.000210	0.003270	0.000898	0.000526	0.004194	0.000744	0.001415	0.002213	0.000587	0.000778	0.000181	0.002511	0.005248	0.005858	0.000873	0.001223	0.000111	0.000133	0.000056	0.000184	0.000428	0.000444	0.000048	0.000015	0.000028	0.000190	0.000032	0.000110	0.000071	0.000252	0.000501	0.000295	0.000043	0.000013	0.000018	0.000030	0.000007	0.000105	0.000126	0.000348	0.000626	0.000149	0.000038	0.000078	0.000532	0.000107	0.000081	0.000899	0.000104	0.000050	0.000083	0.000160	0.000004	0.000083	0.000229	0.000444	0.000068	0.000407	0.000046	0.000068	0.000399	0.001098	0.000059	0.000156	0.000076	0.000104	0.000854	0.000049	0.000035	0.000093	0.000995	0.000214	0.000411	0.000081	0.000156	0.001264	0.003211	0.001511	0.000068	0.000248	0.000246	0.000054	0.000035	0.000067	0.000060	0.000064	0.000098	0.000263	0.000153	0.000064	0.001014	0.000017	0.000053	0.000031	0.005100	0.000399	0.001102	0.000420	0.000038	0.000023	0.000524	0.000031	0.000391	0.000088	0.000856	0.000053	0.000505	0.000599	0.000490	0.041321	0.003568	0.000599	0.000133	0.004096	0.005851	0.003719	0.000996	0.007755	0.003431	0.009146	0.002423	0.000441	0.001236	0.001610	0.002583	0.008747	0.000173	0.000225	0.007699	0.002350	0.001468	0.004178	0.000306	0.000519	0.000090	0.056844	0.000280	0.000481	0.000690	0.000052
60176368 - Fakear - Animal - La Lune Rousse	60176368	0.031459	0.000345	0.000464	0.001209	0.000100	0.000271	0.000230	0.000121	0.000181	0.000083	0.000175	0.000047	0.000067	0.000057	0.000283	0.000569	0.000406	0.000183	0.000150	0.000103	0.000127	0.000105	0.000219	0.000226	0.000200	0.000154	0.000166	0.046847	0.000271	0.000154	0.000226	0.001064	0.001320	0.001446	0.000445	0.000579	0.005946	0.001168	0.000225	0.000020	0.000511	0.000233	0.000034	0.000104	0.000114	0.000037	0.000125	0.000240	0.000090	0.000308	0.000120	0.000071	0.000112	0.000151	0.000379	0.000239	0.000035	0.000140	0.000191	0.000320	0.000146	0.000261	0.000471	0.000430	0.002629	0.002053	0.000222	0.000168	0.000045	0.000631	0.000100	0.000037	0.003042	0.002360	0.001764	0.000522	0.000318	0.000914	0.000394	0.000130	0.000284	0.000344	0.000098	0.000215	0.000238	0.000069	0.000313	0.000163	0.000142	0.000034	0.000092	0.000086	0.001046	0.000092	0.000107	0.000125	0.000187	0.000199	0.000554	0.000317	0.000148	0.000215	0.000108	0.000091	0.000255	0.000326	0.000205	0.000193	0.000041	0.000033	0.000090	0.001065	0.000405	0.000391	0.000077	0.000144	0.000099	0.000073	0.000075	0.000237	0.000070	0.000025	0.000686	0.000155	0.000167	0.000098	0.000532	0.000380	0.000169	0.000219	0.000689	0.000094	0.000333	0.000159	0.000070	0.000360	0.000045	0.758336	0.047272	0.031647	0.028157	0.002402	0.003041	0.014360	0.002589	0.001036	0.006353	0.021822	0.005378	0.035688	0.036493	0.009452	0.006377	0.004835	0.005394	0.000757	0.000575	0.000319	0.024113	0.025097	0.005275	0.001823	0.002770	0.053567	0.004000	0.000887	0.000735	0.000272	0.002223	0.000135	0.000355	0.000449	0.000411	0.000680	0.000258	0.000199	0.000295	0.000166	0.000431	0.003162	0.004251	0.004496	0.000720	0.000202	0.000554	0.000685	0.000282	0.000412	0.000270	0.003301	0.000271	0.001516	0.024139	0.000655	0.000418	0.001298	0.000697	0.000286	0.000301	0.010154	0.000423	0.000189	0.000325	0.000452	0.000301	0.001552	0.001158	0.000056	0.000724	0.000312	0.000486	0.000115	0.000463	0.002005	0.001124	0.000577	0.034702	0.037067	0.000381	0.002061	0.000837	0.002618	0.002199	0.001892	0.001618	0.000423	0.108457	0.013653	0.004903	0.009553	0.000506	0.007982	0.013863	0.002894	0.005852	0.004476	0.008595	0.001606	0.000099	0.041776	0.037614	0.010736	0.009645	0.005012	0.031711	0.017529	0.005266	0.005082	0.001388	0.000380	0.002986	0.013105	0.002501	0.007829	0.000962	0.000282	0.010698	0.020803	0.001349	0.002553	0.002261	0.000575	0.000697	0.000864	0.002762	0.021766	0.010423	0.005986	0.002979	0.001243	0.012903	0.005866	0.000538	0.001270	0.022567	0.000664	0.021365	0.001376	0.002380	0.015388	0.012023	0.000042	0.000060	0.000153	0.000165	0.000137	0.000047	0.000053	0.000594	0.000098	0.000135	0.000087	0.000266	0.000138	0.000076	0.000067	0.000236	0.000362	0.000084	0.000161	0.002509	0.000265	0.000062	0.000199	0.000105	0.000046	0.000177	0.000500	0.000599	0.000094	0.000491	0.000014	0.000019	0.000040	0.000059	0.000071	0.000169	0.000020	0.000353	0.000024	0.000137	0.000061	0.000544	0.000484	0.000249	0.000213	0.000213	0.000050	0.000269	0.000351	0.000095	0.000149	0.000235	0.000008	0.000052	0.000165	0.000030	0.000073	0.000066	0.000075	0.000099	0.000469	0.000277	0.000313	0.000011	0.000053	0.000037	0.000055	0.000110	0.000067	0.000015	0.000079	0.000087	0.000188	0.000191	0.000493	0.000988	0.000090	0.000066	0.000156	0.000310	0.000361	0.000017	0.000029	0.000126	0.000105	0.000059	0.000114	0.000096	0.000070	0.000182	0.000128	0.000165	0.000081	0.000137	0.000062	0.000142	0.000045	0.000144	0.000281	0.000053	0.000199	0.000569	0.000052	0.000235	0.000089	0.000265	0.000225	0.005473	0.000980	0.000774	0.012089	0.000478	0.002680	0.003111	0.001921	0.002514	0.000635	0.003972	0.004906	0.008391	0.000271	0.000640	0.000172	0.000137	0.000093	0.000829	0.001015	0.000870	0.000087	0.000012	0.000041	0.000074	0.000025	0.000075	0.000069	0.000324	0.000542	0.000247	0.000045	0.000022	0.000056	0.000067	0.000041	0.000122	0.000166	0.000199	0.000268	0.000083	0.000022	0.000037	0.000246	0.000179	0.000118	0.000634	0.000049	0.000033	0.000131	0.000260	0.000006	0.000031	0.000194	0.000487	0.000039	0.000411	0.000100	0.000126	0.000367	0.000970	0.000071	0.000273	0.000118	0.000200	0.000585	0.000064	0.000084	0.000053	0.000611	0.000109	0.000284	0.000114	0.000130	0.007486	0.003983	0.001022	0.000134	0.000135	0.000438	0.000046	0.000016	0.000056	0.000082	0.000104	0.000066	0.000191	0.000171	0.000162	0.000668	0.000021	0.000074	0.000074	0.003995	0.000785	0.001103	0.000206	0.000038	0.000010	0.000336	0.000033	0.000317	0.000117	0.000446	0.000068	0.000130	0.002417	0.001221	0.004677	0.013706	0.000621	0.000197	0.006736	0.012855	0.006120	0.004787	0.004826	0.003914	0.008873	0.001902	0.000425	0.001533	0.001881	0.001361	0.003363	0.000296	0.000141	0.007310	0.000599	0.001349	0.003416	0.000302	0.000295	0.000098	0.003858	0.000124	0.000220	0.000389	0.000057
242840945 - Night Club - Requiem for Romance - Show It 2 Me	242840945	0.025244	0.000513	0.000379	0.001775	0.000123	0.000341	0.000330	0.000181	0.000260	0.000200	0.000214	0.000132	0.000174	0.000108	0.000922	0.000864	0.000653	0.000449	0.000396	0.000179	0.000273	0.000145	0.000566	0.000459	0.000316	0.000144	0.000298	0.031431	0.000266	0.000053	0.000149	0.000212	0.000526	0.000899	0.000348	0.000686	0.003770	0.000065	0.000230	0.000026	0.001315	0.000429	0.000066	0.000107	0.000144	0.000045	0.000177	0.000351	0.000109	0.000591	0.000090	0.000035	0.000032	0.000087	0.000321	0.000158	0.000010	0.000158	0.000221	0.000380	0.000193	0.000082	0.000166	0.000081	0.001873	0.002924	0.000165	0.000013	0.000035	0.000513	0.000046	0.000048	0.005662	0.003731	0.002943	0.001328	0.000444	0.000530	0.000671	0.000289	0.000322	0.000402	0.000098	0.000265	0.000408	0.000076	0.000274	0.000114	0.000086	0.000039	0.000049	0.000050	0.000031	0.000227	0.000161	0.000174	0.000151	0.000144	0.000882	0.000367	0.000188	0.000313	0.000237	0.000205	0.000189	0.000221	0.000339	0.000305	0.000058	0.000041	0.000092	0.002155	0.000887	0.000731	0.000105	0.000158	0.000111	0.000292	0.000323	0.000370	0.000120	0.000033	0.000729	0.000437	0.000360	0.000160	0.000803	0.000364	0.000219	0.000327	0.000531	0.000168	0.000426	0.000118	0.000133	0.000394	0.000008	0.795617	0.017480	0.001908	0.002702	0.000517	0.000999	0.000507	0.000065	0.000092	0.000388	0.000116	0.000095	0.000106	0.000088	0.000112	0.002325	0.001613	0.001463	0.000140	0.000119	0.000059	0.022932	0.080969	0.000116	0.001087	0.003392	0.077417	0.004309	0.000827	0.000640	0.000189	0.002345	0.000174	0.000057	0.000552	0.000478	0.000121	0.000118	0.000057	0.000067	0.000086	0.000051	0.000385	0.000546	0.000598	0.000119	0.000021	0.000468	0.000943	0.000297	0.000505	0.000232	0.000517	0.000056	0.000943	0.000294	0.000231	0.000137	0.001266	0.000553	0.000238	0.000225	0.000105	0.000208	0.000091	0.000352	0.000082	0.000293	0.000328	0.000266	0.000015	0.000612	0.000127	0.000155	0.000111	0.000328	0.000218	0.000468	0.000538	0.098512	0.033039	0.000172	0.003763	0.001905	0.003741	0.002364	0.003794	0.003501	0.000175	0.058821	0.005701	0.002344	0.000427	0.000667	0.000196	0.030664	0.000405	0.002563	0.004804	0.070797	0.000500	0.000129	0.150498	0.113263	0.025565	0.047386	0.013244	0.083000	0.057788	0.002153	0.024525	0.000854	0.000101	0.000059	0.005748	0.001815	0.001532	0.000523	0.000131	0.003228	0.004393	0.002256	0.001413	0.005079	0.000114	0.000227	0.000585	0.000230	0.008249	0.012609	0.003495	0.004267	0.001963	0.012810	0.000546	0.000210	0.002093	0.112607	0.000139	0.003123	0.000975	0.000406	0.002463	0.026676	0.000065	0.000045	0.000136	0.000104	0.000120	0.000040	0.000044	0.000453	0.000061	0.000062	0.000044	0.000104	0.000045	0.000069	0.000059	0.000302	0.000133	0.000051	0.000060	0.002324	0.000178	0.000039	0.000099	0.000073	0.000030	0.000196	0.000553	0.000693	0.000111	0.000191	0.000011	0.000030	0.000045	0.000065	0.000100	0.000168	0.000042	0.000312	0.000014	0.000026	0.000067	0.000416	0.000304	0.000201	0.000136	0.000244	0.000038	0.000261	0.000315	0.000118	0.000120	0.000234	0.000012	0.000053	0.000162	0.000026	0.000064	0.000050	0.000050	0.000103	0.000138	0.000036	0.000311	0.000013	0.000082	0.000041	0.000045	0.000093	0.000059	0.000013	0.000044	0.000061	0.000182	0.000142	0.000059	0.000255	0.000045	0.000084	0.000082	0.000120	0.000438	0.000013	0.000030	0.000116	0.000083	0.000025	0.000052	0.000054	0.000025	0.000187	0.000150	0.000128	0.000018	0.000055	0.000011	0.000069	0.000054	0.000104	0.000284	0.000037	0.000102	0.000196	0.000028	0.000118	0.000020	0.000146	0.000216	0.001577	0.000779	0.000329	0.002276	0.000416	0.002761	0.002303	0.000357	0.001074	0.000201	0.000855	0.003298	0.003515	0.000164	0.002782	0.000149	0.000151	0.000071	0.000187	0.000287	0.000233	0.000051	0.000014	0.000026	0.000060	0.000009	0.000030	0.000027	0.000112	0.000135	0.000370	0.000033	0.000010	0.000048	0.000073	0.000015	0.000149	0.000172	0.000198	0.000304	0.000050	0.000017	0.000033	0.000210	0.000213	0.000135	0.001175	0.000031	0.000041	0.000177	0.000262	0.000003	0.000028	0.000263	0.000155	0.000050	0.000365	0.000071	0.000066	0.000279	0.001643	0.000047	0.000146	0.000055	0.000075	0.000678	0.000043	0.000030	0.000033	0.000116	0.000110	0.000304	0.000062	0.000047	0.000686	0.001248	0.000616	0.000083	0.000066	0.000304	0.000035	0.000018	0.000040	0.000067	0.000074	0.000045	0.000058	0.000063	0.000168	0.001483	0.000005	0.000034	0.000035	0.002120	0.000155	0.000470	0.000111	0.000027	0.000014	0.000265	0.000041	0.000188	0.000057	0.000656	0.000048	0.000056	0.000568	0.000366	0.004406	0.012297	0.000449	0.000109	0.003253	0.009288	0.001360	0.002326	0.003386	0.006432	0.007264	0.001962	0.000327	0.001108	0.001505	0.000690	0.004004	0.000110	0.000267	0.005516	0.000269	0.000652	0.003063	0.000104	0.000250	0.000049	0.004967	0.000141	0.000240	0.000306	0.000026
121308034 - Filv - Clandestina (Cocaina Remix) - Clandestina (Cocaina Remix)	121308034	0.064404	0.001196	0.000771	0.001288	0.000164	0.000782	0.000194	0.000135	0.000367	0.000257	0.000486	0.000086	0.000111	0.000051	0.000492	0.000506	0.000567	0.000180	0.000200	0.000165	0.000154	0.000198	0.000356	0.000342	0.000405	0.000156	0.000150	0.043486	0.000647	0.000868	0.000224	0.000458	0.004490	0.002208	0.000511	0.000904	0.007389	0.000315	0.000176	0.000020	0.001412	0.000403	0.000072	0.000162	0.000149	0.000094	0.000185	0.000146	0.000069	0.000431	0.000169	0.000090	0.000225	0.000196	0.000282	0.000269	0.000016	0.000166	0.000133	0.000389	0.000152	0.000208	0.000540	0.000282	0.002049	0.001778	0.000181	0.000087	0.000082	0.000703	0.000167	0.000051	0.003389	0.003173	0.002420	0.000640	0.000452	0.000632	0.000607	0.000140	0.000397	0.000377	0.000082	0.000253	0.000502	0.000094	0.000338	0.000131	0.000131	0.000032	0.000099	0.000091	0.000229	0.000089	0.000115	0.000176	0.000309	0.000297	0.000720	0.000401	0.000197	0.000309	0.000191	0.000177	0.000098	0.000142	0.000211	0.000235	0.000030	0.000024	0.000054	0.001250	0.000557	0.000499	0.000087	0.000209	0.000139	0.000101	0.000103	0.000429	0.000148	0.000029	0.000682	0.000137	0.000199	0.000085	0.000746	0.000497	0.000289	0.000246	0.000433	0.000111	0.000434	0.000195	0.000167	0.000893	0.000013	0.784554	0.017265	0.004097	0.004878	0.000736	0.000657	0.001091	0.000228	0.000206	0.000811	0.001331	0.000391	0.000851	0.000569	0.002133	0.003034	0.003059	0.001910	0.000510	0.000429	0.000221	0.010850	0.010428	0.000306	0.001504	0.001484	0.011804	0.002155	0.000475	0.000397	0.000136	0.000998	0.000082	0.000214	0.000278	0.000258	0.000661	0.000287	0.000535	0.001417	0.000081	0.000193	0.001356	0.002187	0.001785	0.000592	0.000197	0.000893	0.000849	0.000272	0.000580	0.000251	0.001198	0.000145	0.001442	0.001407	0.000328	0.000178	0.001703	0.001055	0.000473	0.000296	0.000777	0.000180	0.000088	0.000642	0.000211	0.000264	0.000460	0.000298	0.000030	0.000888	0.000855	0.000217	0.000033	0.000423	0.000490	0.000387	0.000237	0.041839	0.036816	0.000117	0.001261	0.000523	0.002131	0.001112	0.001491	0.001594	0.000180	0.085267	0.014235	0.020690	0.002859	0.001847	0.001573	0.019867	0.002058	0.006513	0.011176	0.023772	0.001017	0.000420	0.042465	0.097784	0.007125	0.008057	0.003947	0.039340	0.032131	0.002928	0.006366	0.003444	0.001280	0.000324	0.012225	0.001761	0.006031	0.000916	0.000369	0.055123	0.118182	0.002279	0.006321	0.001822	0.000158	0.000649	0.001668	0.001440	0.014342	0.019632	0.007525	0.003911	0.002389	0.014532	0.002436	0.000363	0.001945	0.081301	0.000831	0.014276	0.002857	0.001832	0.011906	0.020975	0.000027	0.000073	0.000090	0.000184	0.000081	0.000026	0.000031	0.000449	0.000055	0.000071	0.000052	0.000158	0.000091	0.000063	0.000052	0.000409	0.000253	0.000085	0.000197	0.002305	0.000133	0.000036	0.000101	0.000051	0.000018	0.000184	0.000642	0.000945	0.000145	0.000499	0.000027	0.000033	0.000045	0.000098	0.000071	0.000135	0.000032	0.000400	0.000019	0.000208	0.000087	0.000479	0.000384	0.000233	0.000146	0.000116	0.000037	0.000229	0.000286	0.000124	0.000112	0.000195	0.000007	0.000074	0.000072	0.000014	0.000030	0.000026	0.000041	0.000042	0.000368	0.000142	0.000246	0.000014	0.000046	0.000034	0.000035	0.000092	0.000050	0.000015	0.000053	0.000060	0.000126	0.000257	0.000226	0.000407	0.000121	0.000120	0.000125	0.000424	0.000443	0.000014	0.000045	0.000160	0.000121	0.000067	0.000105	0.000082	0.000074	0.000219	0.000161	0.000135	0.000093	0.000095	0.000063	0.000074	0.000078	0.000315	0.000500	0.000120	0.000323	0.000180	0.000129	0.000255	0.000104	0.000342	0.000429	0.003998	0.003734	0.001684	0.022143	0.001514	0.005377	0.006205	0.001752	0.001444	0.000246	0.002950	0.005219	0.005764	0.000090	0.003151	0.000274	0.000275	0.000153	0.000593	0.000899	0.000712	0.000159	0.000027	0.000055	0.000101	0.000018	0.000089	0.000066	0.000851	0.000813	0.000352	0.000025	0.000014	0.000063	0.000097	0.000048	0.000145	0.000197	0.000319	0.000341	0.000072	0.000011	0.000037	0.000482	0.000296	0.000125	0.001162	0.000062	0.000027	0.000205	0.000342	0.000006	0.000052	0.000144	0.000368	0.000058	0.000247	0.000057	0.000083	0.000574	0.001381	0.000035	0.000188	0.000062	0.000098	0.001064	0.000037	0.000083	0.000042	0.000635	0.000169	0.000399	0.000064	0.000064	0.000724	0.001268	0.000292	0.000106	0.000104	0.000530	0.000027	0.000015	0.000080	0.000063	0.000128	0.000077	0.000104	0.000221	0.000218	0.000733	0.000012	0.000080	0.000107	0.004623	0.000592	0.000570	0.000100	0.000091	0.000035	0.000541	0.000039	0.000367	0.000161	0.000696	0.000044	0.000093	0.001163	0.000535	0.003295	0.002176	0.000150	0.000211	0.006998	0.005577	0.003336	0.001261	0.005065	0.011813	0.011308	0.003655	0.000793	0.001613	0.002234	0.001501	0.005515	0.000083	0.000312	0.002978	0.000237	0.000555	0.002120	0.000118	0.000284	0.000076	0.003162	0.000112	0.000569	0.000673	0.000073
138004901 - Moody Good - Satoshi Nakamoto - Satoshi Nakamoto	138004901	0.167543	0.001162	0.002105	0.016173	0.000540	0.000933	0.001034	0.000181	0.000654	0.000239	0.000513	0.000105	0.000051	0.000091	0.000846	0.000265	0.001627	0.000472	0.000845	0.000705	0.000685	0.000576	0.001288	0.001869	0.001237	0.000159	0.000117	0.011000	0.000399	0.000303	0.000068	0.000127	0.000850	0.001782	0.002396	0.001100	0.009700	0.000207	0.000270	0.000021	0.000423	0.000407	0.000038	0.000065	0.000099	0.000137	0.000118	0.000280	0.000223	0.000209	0.000109	0.000312	0.000061	0.000324	0.000370	0.000253	0.000051	0.000131	0.000161	0.000358	0.000422	0.000571	0.000074	0.000482	0.001139	0.001926	0.000212	0.000126	0.000312	0.000953	0.000518	0.001228	0.003370	0.002367	0.001573	0.000326	0.000376	0.000521	0.000522	0.000109	0.000353	0.000646	0.000047	0.000498	0.000390	0.000131	0.000318	0.000399	0.000325	0.000113	0.000067	0.000064	0.000129	0.000112	0.000427	0.000223	0.000413	0.000331	0.000573	0.000500	0.000262	0.000233	0.000140	0.000129	0.000238	0.000381	0.000137	0.000126	0.000047	0.000042	0.000123	0.001066	0.000470	0.000436	0.000020	0.000180	0.000136	0.000082	0.000078	0.000174	0.000043	0.000026	0.000349	0.000472	0.000691	0.000263	0.000472	0.000214	0.000103	0.000176	0.000859	0.000121	0.000262	0.000095	0.000335	0.001433	0.000330	0.780448	0.071596	0.005568	0.006465	0.001049	0.001786	0.000705	0.000241	0.000246	0.000637	0.000247	0.000284	0.000148	0.000152	0.000272	0.018951	0.013315	0.009029	0.001579	0.000961	0.000778	0.076709	0.064489	0.000275	0.006091	0.007451	0.184680	0.014310	0.002517	0.001888	0.001093	0.005296	0.000580	0.000305	0.001184	0.001015	0.000923	0.000286	0.000364	0.000208	0.001584	0.000588	0.002023	0.002755	0.002461	0.000607	0.000171	0.000822	0.000596	0.000181	0.000210	0.000144	0.001029	0.000108	0.000763	0.000407	0.000265	0.000304	0.001160	0.000735	0.000287	0.000248	0.000571	0.000423	0.000213	0.000217	0.000039	0.000161	0.000784	0.000374	0.000050	0.000358	0.000303	0.000172	0.000696	0.000297	0.002625	0.001571	0.016662	0.004622	0.067015	0.000907	0.002392	0.000880	0.000667	0.000210	0.000675	0.000653	0.000259	0.003477	0.001541	0.003723	0.000572	0.000244	0.000259	0.001965	0.000360	0.000570	0.001677	0.002061	0.001075	0.000161	0.150570	0.011150	0.008653	0.037368	0.054050	0.021335	0.005262	0.030441	0.006246	0.000374	0.000186	0.000112	0.001383	0.000711	0.002051	0.000566	0.000079	0.001053	0.000930	0.000532	0.000488	0.000728	0.000156	0.000156	0.000241	0.000226	0.002060	0.003280	0.001809	0.001456	0.000786	0.003941	0.000558	0.000379	0.000373	0.001968	0.000108	0.000387	0.000565	0.000364	0.001620	0.002074	0.000191	0.000219	0.000207	0.000240	0.000177	0.000093	0.000108	0.001470	0.000275	0.000312	0.000278	0.000388	0.000135	0.000169	0.000123	0.000241	0.000763	0.000172	0.000371	0.004832	0.000474	0.000108	0.000262	0.000165	0.000064	0.000369	0.001410	0.000966	0.000300	0.000160	0.000053	0.000061	0.000090	0.000239	0.000224	0.000226	0.000108	0.000271	0.000022	0.000574	0.000259	0.000344	0.000274	0.000165	0.000105	0.000254	0.000105	0.000368	0.000554	0.000142	0.000195	0.000296	0.000012	0.000098	0.000179	0.000024	0.000051	0.000045	0.000110	0.000110	0.001539	0.002622	0.000299	0.000020	0.000030	0.000085	0.000033	0.000123	0.000070	0.000036	0.000111	0.000079	0.000220	0.000879	0.000280	0.000709	0.000368	0.000382	0.000612	0.000840	0.000096	0.000031	0.000099	0.000628	0.000286	0.000192	0.000307	0.000286	0.000178	0.000461	0.000276	0.000629	0.000120	0.000179	0.000088	0.000097	0.000194	0.000376	0.000641	0.000242	0.000395	0.000593	0.000078	0.000222	0.000102	0.000307	0.000396	0.000405	0.000662	0.000140	0.001263	0.000312	0.001143	0.001066	0.000297	0.000977	0.000266	0.000591	0.000544	0.000391	0.000157	0.000496	0.000173	0.000384	0.000172	0.000631	0.002265	0.001901	0.000157	0.000023	0.000161	0.000165	0.000032	0.000072	0.000178	0.000149	0.000337	0.000617	0.000117	0.000029	0.000065	0.000071	0.000024	0.000188	0.000206	0.000434	0.000366	0.000183	0.000072	0.000097	0.000199	0.000262	0.000157	0.000883	0.000101	0.000107	0.000389	0.002492	0.000089	0.000068	0.000623	0.000647	0.000157	0.001219	0.000418	0.000476	0.000773	0.001848	0.000187	0.000814	0.000287	0.000459	0.001009	0.000115	0.000190	0.000145	0.002474	0.000275	0.001306	0.000341	0.000143	0.001561	0.006873	0.001700	0.001270	0.000121	0.000664	0.000244	0.000163	0.000149	0.000483	0.000089	0.000130	0.008161	0.000393	0.000172	0.000650	0.000035	0.000117	0.000038	0.001020	0.000714	0.000374	0.000100	0.000041	0.000049	0.001347	0.000045	0.000847	0.000349	0.000481	0.000076	0.000446	0.000732	0.000381	0.030264	0.000244	0.000365	0.000129	0.008237	0.003046	0.003600	0.000874	0.012533	0.002256	0.025498	0.008660	0.002157	0.004188	0.002638	0.003717	0.007807	0.000521	0.000297	0.013605	0.002798	0.001996	0.002577	0.000562	0.001408	0.000244	0.029758	0.000321	0.002502	0.001530	0.000071
62865100 - Crystal Castles - Crystal Castles - Untrust Us	62865100	0.046246	0.000784	0.001038	0.011178	0.000211	0.000649	0.003962	0.000192	0.000274	0.000132	0.000244	0.000106	0.000118	0.000065	0.002235	0.000298	0.002781	0.001655	0.001273	0.000639	0.001381	0.000819	0.005047	0.005399	0.002656	0.000510	0.000095	0.025060	0.000447	0.000414	0.000207	0.000741	0.003317	0.007892	0.013662	0.002088	0.001057	0.000243	0.000711	0.000075	0.000414	0.000261	0.000056	0.000098	0.000124	0.000039	0.000151	0.000229	0.000099	0.000320	0.000107	0.000162	0.000054	0.000112	0.000224	0.000140	0.000071	0.000130	0.000417	0.000472	0.000351	0.000741	0.000129	0.000627	0.001432	0.001785	0.000185	0.000055	0.000187	0.000593	0.000186	0.000556	0.006147	0.004806	0.002899	0.000691	0.000799	0.001484	0.000714	0.000310	0.000654	0.001198	0.000122	0.000963	0.000219	0.000332	0.000294	0.000137	0.000110	0.000055	0.000050	0.000042	0.000104	0.000221	0.000314	0.000390	0.000406	0.000403	0.000863	0.000377	0.000185	0.000312	0.000251	0.000219	0.000393	0.000418	0.000338	0.000308	0.000103	0.000073	0.000172	0.002115	0.000715	0.000619	0.000151	0.000237	0.000161	0.000327	0.000288	0.000214	0.000049	0.000034	0.000956	0.000433	0.000327	0.000212	0.000576	0.000235	0.000184	0.000269	0.000567	0.000134	0.000476	0.000194	0.000115	0.000831	0.000055	0.768746	0.013069	0.001978	0.002702	0.000575	0.000618	0.000600	0.000106	0.000239	0.000523	0.000205	0.000238	0.000394	0.000251	0.000413	0.001889	0.001328	0.000842	0.000243	0.000139	0.000099	0.020758	0.105843	0.000210	0.000803	0.001699	0.046421	0.002431	0.000481	0.000375	0.000157	0.001312	0.000085	0.000112	0.000283	0.000226	0.000160	0.000082	0.000129	0.000058	0.000114	0.000156	0.000707	0.001086	0.000899	0.000212	0.000042	0.000337	0.000583	0.000222	0.000300	0.000106	0.000645	0.000100	0.001136	0.000619	0.000255	0.000147	0.001044	0.000703	0.000361	0.000424	0.000429	0.000185	0.000070	0.000181	0.000085	0.000077	0.000265	0.000239	0.000019	0.000323	0.000145	0.000128	0.000099	0.000387	0.000588	0.000470	0.000444	0.033321	0.010003	0.000263	0.002590	0.001221	0.002592	0.002394	0.001990	0.002299	0.000213	0.033261	0.003674	0.001033	0.001234	0.000266	0.000594	0.011078	0.000879	0.002428	0.004194	0.031320	0.000665	0.000231	0.153589	0.113375	0.060592	0.030376	0.012831	0.148740	0.045821	0.002778	0.072107	0.000681	0.000155	0.000203	0.005869	0.003499	0.002064	0.000775	0.000257	0.004754	0.008329	0.001749	0.002297	0.001336	0.000372	0.000458	0.000267	0.000600	0.009849	0.009551	0.005608	0.004450	0.001437	0.016415	0.005085	0.000971	0.001337	0.079273	0.000298	0.006305	0.001948	0.000804	0.003755	0.020646	0.000066	0.000102	0.000227	0.000145	0.000219	0.000059	0.000059	0.000702	0.000134	0.000154	0.000127	0.000149	0.000074	0.000091	0.000072	0.000158	0.000282	0.000172	0.000217	0.004868	0.000337	0.000083	0.000138	0.000146	0.000058	0.000369	0.001213	0.000749	0.000147	0.000147	0.000031	0.000069	0.000089	0.000147	0.000222	0.000278	0.000118	0.000393	0.000032	0.000095	0.000355	0.000391	0.000316	0.000196	0.000124	0.000375	0.000088	0.000409	0.000563	0.000100	0.000149	0.000356	0.000020	0.000098	0.000180	0.000043	0.000056	0.000051	0.000043	0.000152	0.000595	0.000192	0.000300	0.000020	0.000035	0.000057	0.000108	0.000116	0.000066	0.000021	0.000054	0.000085	0.000195	0.000210	0.000083	0.000161	0.000101	0.000067	0.000076	0.000323	0.000147	0.000019	0.000029	0.000183	0.000121	0.000014	0.000098	0.000103	0.000091	0.000284	0.000166	0.000884	0.000041	0.000055	0.000071	0.000103	0.000081	0.000416	0.000513	0.000151	0.000129	0.000232	0.000101	0.000256	0.000094	0.000260	0.000176	0.000563	0.000449	0.000225	0.002309	0.000302	0.000787	0.000561	0.000171	0.000869	0.000164	0.000700	0.001217	0.001445	0.000092	0.000605	0.000073	0.000288	0.000165	0.000126	0.000186	0.000179	0.000130	0.000022	0.000031	0.000090	0.000030	0.000057	0.000083	0.000261	0.000356	0.000505	0.000047	0.000021	0.000050	0.000097	0.000032	0.000177	0.000211	0.000309	0.000339	0.000080	0.000044	0.000104	0.000178	0.000254	0.000199	0.001076	0.000091	0.000098	0.000201	0.000124	0.000006	0.000040	0.000373	0.000385	0.000058	0.000469	0.000256	0.000148	0.000346	0.001581	0.000109	0.000193	0.000167	0.000315	0.000936	0.000078	0.000058	0.000048	0.000140	0.000085	0.000296	0.000115	0.000041	0.000318	0.000686	0.000213	0.000144	0.000042	0.000357	0.000065	0.000050	0.000045	0.000070	0.000050	0.000085	0.000187	0.000385	0.000214	0.001144	0.000017	0.000110	0.000080	0.001124	0.000500	0.000273	0.000059	0.000035	0.000041	0.000473	0.000043	0.000438	0.000095	0.000271	0.000089	0.000136	0.000295	0.000414	0.011358	0.006817	0.000209	0.000190	0.001250	0.001116	0.002926	0.000591	0.004745	0.008991	0.008785	0.001839	0.000595	0.002265	0.002016	0.000518	0.002905	0.000237	0.000155	0.015533	0.000570	0.000362	0.001206	0.000667	0.000396	0.000062	0.013548	0.000195	0.000267	0.000527	0.000091
197107589 - Ellen Allien - Rosen - Rosen	197107589	0.191562	0.001565	0.001842	0.002176	0.000653	0.001170	0.000257	0.000548	0.000262	0.000132	0.000264	0.000080	0.000036	0.000044	0.000350	0.001464	0.000524	0.000126	0.000243	0.000196	0.000196	0.000179	0.000496	0.000479	0.000289	0.000121	0.000263	0.003126	0.000248	0.000079	0.000125	0.000189	0.000389	0.000286	0.000206	0.000261	0.000892	0.000072	0.000208	0.000026	0.000965	0.000318	0.000047	0.000078	0.000121	0.000071	0.000170	0.000164	0.000101	0.000407	0.000153	0.000196	0.000111	0.000191	0.000511	0.000347	0.000041	0.000285	0.000111	0.000367	0.000246	0.000168	0.000228	0.000149	0.000907	0.001448	0.000177	0.000055	0.000182	0.001008	0.000305	0.000052	0.003151	0.002483	0.001499	0.000355	0.000277	0.000609	0.000429	0.000135	0.000250	0.000653	0.000116	0.000472	0.000161	0.000120	0.000463	0.000176	0.000144	0.000056	0.000100	0.000101	0.000085	0.000078	0.000175	0.000169	0.000248	0.000218	0.000838	0.000544	0.000269	0.000337	0.000233	0.000235	0.000234	0.000298	0.000145	0.000131	0.000055	0.000050	0.000128	0.001382	0.000568	0.000540	0.000040	0.000221	0.000172	0.000084	0.000069	0.000198	0.000062	0.000031	0.000445	0.000272	0.000334	0.000189	0.001823	0.000271	0.000431	0.001089	0.001883	0.000662	0.000362	0.000189	0.000135	0.000575	0.000082	0.743439	0.018146	0.002058	0.002412	0.000606	0.000435	0.000352	0.000091	0.000135	0.000367	0.000194	0.000199	0.000208	0.000121	0.000170	0.002915	0.001920	0.001238	0.000398	0.000359	0.000155	0.021619	0.091463	0.000214	0.001195	0.001566	0.053624	0.002529	0.000534	0.000383	0.000361	0.001160	0.000448	0.000098	0.000297	0.000276	0.000247	0.000086	0.000048	0.000041	0.000155	0.000141	0.000413	0.000560	0.000472	0.000148	0.000114	0.001081	0.000899	0.000308	0.000404	0.000309	0.000687	0.000153	0.001329	0.000254	0.000246	0.000129	0.002628	0.001214	0.000180	0.000386	0.000164	0.000457	0.000171	0.000207	0.000109	0.000143	0.000429	0.000295	0.000052	0.000496	0.000396	0.000316	0.000426	0.000502	0.002116	0.000373	0.002991	0.006430	0.009050	0.000359	0.002486	0.000993	0.000805	0.000279	0.001109	0.000975	0.000241	0.002613	0.000557	0.000919	0.000672	0.000175	0.000225	0.003140	0.000247	0.000550	0.001319	0.015263	0.000924	0.000163	0.263151	0.050751	0.126012	0.031060	0.076529	0.093672	0.032048	0.002417	0.209802	0.000296	0.000077	0.000099	0.001463	0.000449	0.000513	0.000402	0.000083	0.000670	0.000450	0.000253	0.000214	0.000830	0.000213	0.000117	0.000296	0.000200	0.002111	0.001440	0.003884	0.002937	0.001084	0.014325	0.000109	0.002951	0.000292	0.010638	0.000063	0.000936	0.000902	0.000094	0.000467	0.008072	0.000460	0.000275	0.000253	0.000141	0.000238	0.000043	0.000047	0.000434	0.000052	0.000040	0.000041	0.000120	0.000038	0.000090	0.000066	0.000079	0.000262	0.000065	0.000242	0.004400	0.000488	0.000101	0.000209	0.000167	0.000102	0.000336	0.001173	0.001369	0.000298	0.000309	0.000021	0.000062	0.000059	0.000171	0.000189	0.000254	0.000063	0.001082	0.000046	0.000166	0.000118	0.000385	0.000403	0.000216	0.000140	0.000329	0.000100	0.000269	0.000438	0.000118	0.000184	0.000225	0.000008	0.000094	0.000138	0.000020	0.000044	0.000041	0.000094	0.000100	0.000624	0.000259	0.000238	0.000016	0.000014	0.000039	0.000026	0.000091	0.000060	0.000023	0.000062	0.000076	0.000166	0.000650	0.000341	0.000225	0.000229	0.000151	0.000151	0.000261	0.000336	0.000034	0.000113	0.000448	0.000251	0.000065	0.000058	0.000459	0.000063	0.000131	0.000096	0.000115	0.000035	0.000064	0.000019	0.000074	0.000045	0.000343	0.000735	0.000427	0.000198	0.000471	0.000167	0.000450	0.000098	0.000462	0.000699	0.002682	0.001767	0.000416	0.001222	0.001183	0.001273	0.003478	0.000709	0.001622	0.000698	0.002401	0.005240	0.004258	0.000371	0.001223	0.000083	0.000358	0.000123	0.000322	0.000633	0.000568	0.000125	0.000048	0.000101	0.000249	0.000044	0.000171	0.000130	0.000336	0.000762	0.000524	0.000082	0.000007	0.000022	0.000074	0.000010	0.000125	0.000152	0.000215	0.000280	0.000080	0.000052	0.000053	0.000399	0.000089	0.000070	0.000767	0.000078	0.000041	0.000159	0.000092	0.000006	0.000055	0.000433	0.000577	0.000030	0.000542	0.000040	0.000079	0.000417	0.000701	0.000100	0.000164	0.000102	0.000174	0.000484	0.000034	0.000032	0.000077	0.001215	0.000220	0.000822	0.000141	0.000145	0.000173	0.000934	0.000199	0.000231	0.000139	0.000298	0.000111	0.000104	0.000135	0.000125	0.000069	0.000094	0.001179	0.000450	0.000130	0.000909	0.000010	0.000109	0.000106	0.008379	0.000668	0.000648	0.000135	0.000021	0.000055	0.001131	0.000029	0.000526	0.000082	0.001426	0.000041	0.000436	0.001757	0.000263	0.031703	0.000462	0.000641	0.000180	0.007566	0.002828	0.001442	0.000442	0.013099	0.002477	0.014641	0.005779	0.001839	0.002397	0.001541	0.001490	0.004138	0.000667	0.000241	0.018518	0.002075	0.000442	0.005297	0.005040	0.000853	0.000086	0.079027	0.000452	0.002301	0.001798	0.000151
197107592 - Ellen Allien - Rosen - Kckc	197107592	0.056692	0.000710	0.000490	0.001032	0.000230	0.000533	0.000253	0.000181	0.000105	0.000061	0.000146	0.000049	0.000084	0.000027	0.000477	0.000375	0.000523	0.000135	0.000150	0.000154	0.000119	0.000161	0.000250	0.000262	0.000188	0.000150	0.000072	0.001263	0.000243	0.000028	0.000181	0.000355	0.000253	0.000158	0.000100	0.000262	0.000153	0.000038	0.000177	0.000056	0.000976	0.000218	0.000088	0.000095	0.000131	0.000071	0.000175	0.000156	0.000086	0.000218	0.000195	0.000131	0.000909	0.000299	0.000268	0.000185	0.000015	0.000048	0.000158	0.000209	0.000169	0.000092	0.000111	0.000143	0.001710	0.002558	0.000142	0.000049	0.000092	0.001413	0.000421	0.000056	0.004632	0.002920	0.001993	0.000515	0.000388	0.000421	0.000460	0.000243	0.000315	0.000388	0.000050	0.000250	0.000170	0.000086	0.000465	0.000269	0.000207	0.000053	0.000094	0.000082	0.000031	0.000129	0.000205	0.000145	0.000146	0.000158	0.000958	0.000654	0.000323	0.000318	0.000246	0.000221	0.000202	0.000176	0.000171	0.000157	0.000146	0.000092	0.000191	0.003226	0.001955	0.002629	0.000066	0.000362	0.000280	0.000176	0.000131	0.000200	0.000063	0.000232	0.000671	0.000309	0.000346	0.000159	0.002049	0.001926	0.000156	0.000419	0.003181	0.000344	0.000883	0.000305	0.000114	0.000862	0.000106	0.807444	0.024617	0.001504	0.001792	0.000458	0.000410	0.000316	0.000051	0.000078	0.000366	0.000125	0.000201	0.000088	0.000075	0.000107	0.003795	0.002240	0.001169	0.000230	0.000145	0.000105	0.018103	0.028537	0.000158	0.001747	0.002266	0.010467	0.004314	0.000590	0.000348	0.000238	0.001694	0.000762	0.000089	0.000314	0.000233	0.000331	0.000153	0.000074	0.000057	0.000209	0.000112	0.000249	0.000395	0.000285	0.000103	0.000073	0.000937	0.000506	0.000132	0.000206	0.000178	0.000572	0.000113	0.000978	0.000200	0.000270	0.000158	0.001452	0.000542	0.000082	0.000138	0.000184	0.000372	0.000130	0.000307	0.000062	0.000257	0.000284	0.000179	0.000036	0.000352	0.000128	0.000179	0.001061	0.000359	0.003420	0.000653	0.000489	0.003358	0.001950	0.000221	0.002488	0.001161	0.000564	0.000167	0.000884	0.000563	0.000164	0.003226	0.000629	0.000291	0.000489	0.000058	0.000156	0.001316	0.000189	0.000307	0.001026	0.009074	0.000898	0.000156	0.363476	0.033286	0.197889	0.015120	0.020868	0.077691	0.026689	0.005525	0.321259	0.000207	0.000057	0.000102	0.001327	0.000228	0.000872	0.000296	0.000057	0.000213	0.000088	0.000272	0.000218	0.000147	0.000140	0.000044	0.000205	0.000279	0.001485	0.000788	0.004055	0.002164	0.000660	0.018580	0.000175	0.001322	0.000365	0.006194	0.000091	0.000858	0.000387	0.000201	0.000735	0.006372	0.000268	0.000707	0.000240	0.000119	0.000203	0.000055	0.000062	0.000327	0.000058	0.000056	0.000039	0.000097	0.000015	0.000082	0.000055	0.000080	0.000190	0.000069	0.000255	0.003240	0.000417	0.000075	0.000192	0.000149	0.000074	0.000368	0.000945	0.001131	0.000222	0.000729	0.000015	0.000029	0.000035	0.000121	0.000119	0.000344	0.000049	0.001176	0.000036	0.000044	0.000061	0.000305	0.000247	0.000161	0.000129	0.000305	0.000085	0.000257	0.000371	0.000144	0.000182	0.000224	0.000008	0.000035	0.000137	0.000028	0.000044	0.000041	0.000077	0.000105	0.000318	0.000172	0.000295	0.000016	0.000010	0.000044	0.000026	0.000120	0.000080	0.000022	0.000063	0.000101	0.000206	0.000697	0.000205	0.000108	0.000166	0.000161	0.000259	0.000506	0.000217	0.000025	0.000090	0.000185	0.000092	0.000058	0.000037	0.000292	0.000021	0.000158	0.000103	0.000151	0.000006	0.000040	0.000007	0.000036	0.000035	0.000186	0.000437	0.000176	0.000125	0.000216	0.000059	0.000207	0.000098	0.000215	0.000322	0.003696	0.000667	0.000192	0.000358	0.000456	0.000988	0.001649	0.000308	0.001573	0.000588	0.002358	0.003470	0.005905	0.000134	0.002500	0.000115	0.000162	0.000062	0.000240	0.001044	0.000969	0.000070	0.000025	0.000022	0.000112	0.000022	0.000043	0.000068	0.000064	0.000117	0.000280	0.000166	0.000004	0.000028	0.000039	0.000007	0.000099	0.000063	0.000181	0.000229	0.000066	0.000015	0.000066	0.000207	0.000249	0.000080	0.000344	0.000035	0.000027	0.000193	0.000291	0.000009	0.000033	0.000363	0.000138	0.000016	0.000569	0.000038	0.000038	0.000229	0.001045	0.000133	0.000268	0.000057	0.000147	0.000175	0.000039	0.000024	0.000047	0.003620	0.000277	0.000868	0.000278	0.000098	0.000171	0.000712	0.000166	0.000347	0.000209	0.000189	0.000148	0.000066	0.000056	0.000426	0.000031	0.000182	0.000143	0.000477	0.000112	0.000762	0.000004	0.000029	0.000024	0.002748	0.001457	0.000270	0.000065	0.000072	0.000021	0.001520	0.000033	0.001100	0.000047	0.000371	0.000056	0.001211	0.000427	0.000222	0.057205	0.000058	0.000207	0.000036	0.001938	0.003950	0.008168	0.001080	0.024787	0.013069	0.005768	0.003099	0.000841	0.001874	0.002426	0.003906	0.003634	0.001224	0.001050	0.028046	0.003319	0.000368	0.003624	0.005965	0.000980	0.000034	0.212070	0.001011	0.000738	0.000752	0.000240
197107590 - Ellen Allien - Rosen - N2020	197107590	0.023292	0.000280	0.000247	0.000547	0.000086	0.000208	0.000110	0.000065	0.000097	0.000035	0.000113	0.000035	0.000109	0.000039	0.000359	0.000414	0.000227	0.000084	0.000097	0.000080	0.000073	0.000080	0.000143	0.000214	0.000123	0.000069	0.000057	0.001406	0.000355	0.000027	0.000175	0.000359	0.000224	0.000136	0.000086	0.000112	0.000087	0.000028	0.000135	0.000031	0.000640	0.000087	0.000044	0.000098	0.000057	0.000021	0.000093	0.000108	0.000061	0.000167	0.000087	0.000083	0.000362	0.000166	0.000400	0.000344	0.000022	0.000052	0.000142	0.000099	0.000152	0.000083	0.000109	0.000176	0.000738	0.002294	0.000182	0.000068	0.000056	0.001125	0.000200	0.000026	0.002532	0.002006	0.001218	0.000353	0.000297	0.000457	0.000310	0.000137	0.000200	0.000276	0.000042	0.000172	0.000082	0.000060	0.000331	0.000145	0.000117	0.000031	0.000062	0.000059	0.000049	0.000082	0.000118	0.000082	0.000080	0.000088	0.000879	0.000675	0.000311	0.000344	0.000182	0.000174	0.000159	0.000113	0.000177	0.000153	0.000036	0.000021	0.000092	0.002054	0.001018	0.001112	0.000072	0.000227	0.000189	0.000096	0.000058	0.000202	0.000040	0.000168	0.000344	0.000368	0.000202	0.000191	0.000505	0.000259	0.000074	0.000159	0.001356	0.000105	0.000238	0.000083	0.000051	0.001083	0.000062	0.848211	0.030356	0.002066	0.002363	0.000513	0.000342	0.000391	0.000096	0.000105	0.000395	0.000148	0.000215	0.000159	0.000139	0.000158	0.003515	0.002157	0.001028	0.000202	0.000144	0.000093	0.020090	0.034515	0.000118	0.002206	0.002282	0.017599	0.004232	0.000783	0.000408	0.000411	0.001620	0.000639	0.000133	0.000513	0.000370	0.000438	0.000090	0.000071	0.000021	0.000284	0.000113	0.000323	0.000495	0.000363	0.000129	0.000043	0.001116	0.001177	0.000404	0.000586	0.000398	0.000736	0.000134	0.001036	0.000271	0.000251	0.000141	0.002966	0.000923	0.000167	0.000275	0.000191	0.000475	0.000270	0.000135	0.000071	0.000125	0.000249	0.000141	0.000088	0.000604	0.000123	0.000188	0.000349	0.001096	0.002041	0.000293	0.000628	0.002866	0.001774	0.000269	0.002419	0.000996	0.000430	0.000176	0.000679	0.000384	0.000128	0.001935	0.000447	0.000376	0.000378	0.000037	0.000124	0.000947	0.000130	0.000175	0.000949	0.005348	0.001429	0.000125	0.416297	0.023521	0.186195	0.016823	0.014203	0.073245	0.026420	0.004954	0.413093	0.000147	0.000064	0.000111	0.001159	0.000118	0.000757	0.000372	0.000085	0.000194	0.000054	0.000212	0.000196	0.000125	0.000217	0.000030	0.000185	0.000221	0.001245	0.000556	0.002887	0.001322	0.000434	0.010340	0.000156	0.000577	0.000220	0.003713	0.000080	0.000503	0.000162	0.000192	0.000663	0.003978	0.000144	0.000319	0.000334	0.000081	0.000301	0.000072	0.000081	0.000395	0.000078	0.000087	0.000053	0.000110	0.000019	0.000102	0.000072	0.000057	0.000257	0.000091	0.000550	0.004447	0.000451	0.000104	0.000130	0.000183	0.000095	0.000482	0.001182	0.002320	0.000446	0.000900	0.000008	0.000052	0.000052	0.000137	0.000171	0.000411	0.000063	0.002103	0.000046	0.000052	0.000086	0.000576	0.000454	0.000389	0.000278	0.000548	0.000133	0.000366	0.000562	0.000173	0.000340	0.000328	0.000012	0.000077	0.000145	0.000030	0.000038	0.000031	0.000125	0.000101	0.000441	0.000113	0.000379	0.000029	0.000009	0.000044	0.000065	0.000148	0.000086	0.000052	0.000136	0.000151	0.000234	0.000372	0.000157	0.000140	0.000129	0.000073	0.000106	0.000300	0.000157	0.000014	0.000047	0.000274	0.000157	0.000016	0.000031	0.000264	0.000032	0.000154	0.000087	0.000116	0.000011	0.000081	0.000006	0.000040	0.000030	0.000323	0.000412	0.000557	0.000111	0.000148	0.000082	0.000221	0.000085	0.000235	0.000100	0.005855	0.000827	0.000208	0.000442	0.000510	0.000696	0.002274	0.000475	0.003538	0.001293	0.002052	0.003570	0.007266	0.000171	0.001192	0.000127	0.000349	0.000141	0.000275	0.000898	0.000869	0.000168	0.000050	0.000049	0.000189	0.000030	0.000043	0.000062	0.000099	0.000129	0.000282	0.000118	0.000017	0.000024	0.000059	0.000008	0.000091	0.000068	0.000252	0.000284	0.000148	0.000026	0.000041	0.000412	0.000464	0.000221	0.000389	0.000075	0.000064	0.000155	0.000092	0.000016	0.000078	0.000352	0.000164	0.000013	0.000655	0.000052	0.000048	0.000199	0.001238	0.000129	0.000169	0.000071	0.000180	0.000125	0.000071	0.000020	0.000069	0.003044	0.000138	0.000778	0.000239	0.000047	0.000155	0.001159	0.000160	0.000123	0.000265	0.000171	0.000082	0.000042	0.000106	0.000139	0.000037	0.000172	0.000182	0.001137	0.000109	0.000556	0.000015	0.000046	0.000048	0.002992	0.001193	0.000298	0.000072	0.000050	0.000040	0.001490	0.000041	0.001199	0.000034	0.000173	0.000072	0.000507	0.000421	0.000161	0.026903	0.000015	0.000162	0.000072	0.002399	0.001970	0.010251	0.000509	0.026857	0.003777	0.005614	0.002759	0.000821	0.001882	0.001469	0.003505	0.005040	0.001301	0.000231	0.018686	0.001669	0.000524	0.004932	0.005597	0.000660	0.000022	0.143179	0.001424	0.000447	0.000612	0.000254
197107591 - Ellen Allien - Rosen - Kckc (Epic Mix)	197107591	0.104313	0.001453	0.000556	0.000976	0.000233	0.000739	0.000183	0.000377	0.000123	0.000107	0.000177	0.000057	0.000076	0.000020	0.000589	0.000967	0.000593	0.000158	0.000154	0.000155	0.000117	0.000176	0.000218	0.000152	0.000173	0.000176	0.000398	0.001588	0.000179	0.000024	0.000202	0.000415	0.000250	0.000115	0.000057	0.000234	0.000266	0.000045	0.000268	0.000103	0.001658	0.000500	0.000097	0.000081	0.000237	0.000066	0.000213	0.000503	0.000191	0.000490	0.000102	0.000106	0.001367	0.000276	0.000298	0.000209	0.000010	0.000028	0.000296	0.000466	0.000129	0.000116	0.000179	0.000232	0.001338	0.002321	0.000123	0.000079	0.000059	0.001467	0.000591	0.000014	0.002875	0.001963	0.001388	0.000509	0.000266	0.000205	0.000380	0.000163	0.000173	0.000206	0.000019	0.000159	0.000137	0.000043	0.000197	0.000138	0.000136	0.000031	0.000045	0.000042	0.000034	0.000098	0.000207	0.000073	0.000097	0.000104	0.000451	0.000343	0.000150	0.000215	0.000106	0.000098	0.000112	0.000124	0.000073	0.000074	0.000075	0.000045	0.000137	0.002733	0.002157	0.003350	0.000048	0.000219	0.000178	0.000136	0.000121	0.000191	0.000048	0.000140	0.000470	0.000158	0.000355	0.000078	0.004069	0.007385	0.000165	0.000325	0.004161	0.000194	0.002113	0.000734	0.000109	0.001278	0.000159	0.791709	0.027926	0.001651	0.001974	0.000488	0.000459	0.000330	0.000076	0.000073	0.000341	0.000161	0.000221	0.000099	0.000066	0.000114	0.003814	0.002178	0.001183	0.000220	0.000146	0.000115	0.015821	0.018411	0.000181	0.002867	0.003125	0.007772	0.005484	0.000861	0.000387	0.000365	0.002028	0.000986	0.000109	0.000709	0.000464	0.000797	0.000526	0.000150	0.000219	0.000231	0.000123	0.000230	0.000332	0.000263	0.000098	0.000055	0.000769	0.000614	0.000142	0.000266	0.000215	0.000622	0.000108	0.000748	0.000196	0.000301	0.000230	0.001281	0.000389	0.000082	0.000118	0.000138	0.000343	0.000074	0.000508	0.000114	0.000281	0.000302	0.000147	0.000024	0.000304	0.000148	0.000099	0.002391	0.000154	0.004151	0.000817	0.001304	0.003525	0.003014	0.000673	0.003692	0.001770	0.000685	0.000193	0.000923	0.000659	0.000201	0.002934	0.000631	0.000425	0.000513	0.000083	0.000163	0.001642	0.000216	0.000376	0.001181	0.009881	0.000801	0.000122	0.383390	0.037427	0.165026	0.015891	0.049780	0.071701	0.032525	0.009391	0.312092	0.000259	0.000080	0.000134	0.001220	0.000337	0.001193	0.000514	0.000053	0.000420	0.000138	0.000310	0.000237	0.000197	0.000151	0.000054	0.000281	0.000304	0.001614	0.001069	0.004121	0.002110	0.000804	0.017060	0.000132	0.001378	0.000359	0.005850	0.000069	0.000847	0.000339	0.000231	0.000604	0.005221	0.000590	0.001758	0.000144	0.000116	0.000123	0.000043	0.000053	0.000259	0.000041	0.000042	0.000031	0.000078	0.000014	0.000061	0.000043	0.000065	0.000196	0.000043	0.000265	0.002240	0.000229	0.000044	0.000106	0.000096	0.000045	0.000234	0.000739	0.001386	0.000211	0.000441	0.000006	0.000031	0.000031	0.000107	0.000108	0.000214	0.000040	0.001637	0.000024	0.000028	0.000041	0.000124	0.000152	0.000068	0.000055	0.000174	0.000060	0.000228	0.000355	0.000145	0.000181	0.000209	0.000006	0.000051	0.000107	0.000022	0.000030	0.000044	0.000077	0.000088	0.000316	0.000110	0.000237	0.000012	0.000006	0.000024	0.000014	0.000092	0.000090	0.000024	0.000066	0.000091	0.000147	0.000512	0.000384	0.000262	0.000110	0.000177	0.000235	0.000744	0.000217	0.000016	0.000046	0.000134	0.000064	0.000070	0.000020	0.000288	0.000022	0.000120	0.000086	0.000133	0.000004	0.000027	0.000009	0.000019	0.000019	0.000098	0.000324	0.000153	0.000149	0.000134	0.000054	0.000239	0.000094	0.000263	0.000296	0.014240	0.001179	0.000494	0.000613	0.000541	0.001598	0.003203	0.000737	0.000847	0.000245	0.005510	0.008573	0.018942	0.000117	0.009081	0.000105	0.000114	0.000042	0.000233	0.000556	0.000485	0.000043	0.000012	0.000021	0.000173	0.000015	0.000053	0.000037	0.000087	0.000180	0.000224	0.000121	0.000004	0.000017	0.000033	0.000007	0.000087	0.000063	0.000235	0.000298	0.000107	0.000029	0.000045	0.000370	0.000198	0.000070	0.000449	0.000044	0.000053	0.000141	0.000210	0.000007	0.000076	0.000350	0.000129	0.000028	0.000310	0.000023	0.000030	0.000180	0.000565	0.000084	0.000173	0.000041	0.000065	0.000118	0.000023	0.000013	0.000023	0.018143	0.000376	0.001347	0.000478	0.000194	0.000179	0.000882	0.000212	0.000249	0.000370	0.000245	0.000209	0.000087	0.000110	0.000458	0.000039	0.000118	0.000243	0.000473	0.000093	0.001050	0.000004	0.000034	0.000038	0.005282	0.001439	0.000469	0.000114	0.000099	0.000015	0.002418	0.000037	0.001172	0.000034	0.000903	0.000048	0.002334	0.001794	0.000339	0.030807	0.000050	0.000360	0.000056	0.004450	0.005242	0.005633	0.001244	0.034998	0.015476	0.010321	0.005971	0.001321	0.001548	0.002295	0.008659	0.006017	0.000775	0.001657	0.015408	0.001657	0.000468	0.005968	0.005949	0.001003	0.000040	0.143929	0.001258	0.001086	0.001049	0.000450
278775845 - Fred again - Mike (desert island duvet) - Mike (desert island duvet)	278775845	0.264325	0.001702	0.001193	0.002379	0.000273	0.001251	0.000314	0.000830	0.000417	0.000338	0.000350	0.000083	0.000027	0.000036	0.000394	0.000803	0.000655	0.000284	0.000399	0.000173	0.000255	0.000147	0.000706	0.000666	0.000824	0.000289	0.000394	0.030033	0.000314	0.000972	0.000172	0.000437	0.001959	0.001945	0.000743	0.000538	0.050309	0.001295	0.001086	0.000032	0.001096	0.000459	0.000067	0.000127	0.000308	0.000024	0.000205	0.000382	0.000178	0.000264	0.000120	0.000082	0.000029	0.000117	0.000386	0.000212	0.000026	0.000331	0.000132	0.000277	0.000251	0.000080	0.000060	0.000074	0.000867	0.000729	0.000104	0.000012	0.000058	0.000278	0.000104	0.000020	0.002583	0.002208	0.001487	0.000491	0.000349	0.000722	0.000474	0.000226	0.000272	0.000386	0.000128	0.000301	0.000273	0.000067	0.000255	0.000171	0.000155	0.000062	0.000066	0.000064	0.000478	0.000073	0.000176	0.000082	0.000256	0.000212	0.000690	0.000306	0.000163	0.000174	0.000226	0.000237	0.000144	0.000236	0.000163	0.000168	0.000053	0.000033	0.000110	0.001074	0.000496	0.000456	0.000054	0.000131	0.000102	0.000202	0.000212	0.000300	0.000107	0.000009	0.000594	0.000188	0.000211	0.000059	0.000378	0.000331	0.000168	0.000092	0.000362	0.000031	0.000405	0.000176	0.000090	0.001347	0.000196	0.743714	0.019914	0.002249	0.002401	0.000446	0.000419	0.000510	0.000266	0.000200	0.000393	0.000224	0.000181	0.000366	0.000316	0.000463	0.005297	0.004369	0.003109	0.001960	0.001698	0.000847	0.027074	0.022669	0.000335	0.002343	0.002243	0.027692	0.003335	0.000776	0.000580	0.000296	0.001653	0.000392	0.000087	0.000503	0.000458	0.000495	0.000600	0.001142	0.001847	0.000693	0.000499	0.003730	0.005263	0.004704	0.002536	0.000273	0.001066	0.001575	0.000833	0.000805	0.000320	0.000704	0.000119	0.000923	0.000645	0.000296	0.000159	0.003767	0.004403	0.000342	0.000693	0.001063	0.000314	0.000104	0.000707	0.000155	0.000672	0.001030	0.000413	0.000010	0.000371	0.000173	0.000089	0.000193	0.001482	0.007892	0.009730	0.001861	0.031192	0.123613	0.000366	0.001393	0.000582	0.001640	0.000529	0.001012	0.001323	0.000163	0.032032	0.007443	0.010258	0.000872	0.000764	0.000260	0.013547	0.000998	0.002994	0.004993	0.020212	0.001866	0.000591	0.069765	0.048464	0.010954	0.010684	0.047473	0.050654	0.013679	0.026061	0.008879	0.001955	0.000644	0.000285	0.004567	0.002242	0.012751	0.000981	0.000258	0.020681	0.043020	0.001527	0.002250	0.001744	0.000131	0.000694	0.000787	0.000680	0.012041	0.020331	0.006567	0.002909	0.002678	0.012615	0.002937	0.000562	0.001438	0.025489	0.000330	0.004758	0.002322	0.001177	0.005280	0.013978	0.000070	0.000167	0.000101	0.000148	0.000094	0.000019	0.000022	0.000303	0.000042	0.000046	0.000047	0.000082	0.000053	0.000065	0.000047	0.000250	0.000258	0.000059	0.000130	0.002133	0.000184	0.000042	0.000140	0.000059	0.000025	0.000148	0.000590	0.000797	0.000144	0.000387	0.000010	0.000029	0.000037	0.000082	0.000086	0.000108	0.000020	0.000427	0.000021	0.000104	0.000040	0.000457	0.000377	0.000281	0.000109	0.000159	0.000037	0.000156	0.000207	0.000080	0.000077	0.000134	0.000005	0.000050	0.000112	0.000023	0.000040	0.000041	0.000060	0.000075	0.000429	0.000161	0.000183	0.000009	0.000020	0.000031	0.000017	0.000075	0.000040	0.000009	0.000032	0.000045	0.000112	0.000215	0.000395	0.000584	0.000084	0.000083	0.000092	0.000251	0.000480	0.000005	0.000022	0.000140	0.000088	0.000096	0.000041	0.000049	0.000062	0.000131	0.000083	0.000086	0.000030	0.000022	0.000054	0.000038	0.000039	0.000272	0.001126	0.000103	0.000291	0.000087	0.000100	0.000984	0.000164	0.000955	0.000373	0.004793	0.001767	0.000757	0.002048	0.001037	0.006668	0.009442	0.001370	0.001762	0.000415	0.002832	0.005945	0.005883	0.000763	0.002414	0.000092	0.000306	0.000159	0.000512	0.000587	0.000516	0.000154	0.000041	0.000056	0.000138	0.000021	0.000055	0.000065	0.000290	0.000625	0.000378	0.000021	0.000015	0.000018	0.000058	0.000017	0.000129	0.000142	0.000295	0.000329	0.000107	0.000038	0.000039	0.000236	0.000077	0.000064	0.000977	0.000067	0.000024	0.000082	0.000178	0.000002	0.000031	0.000267	0.000357	0.000062	0.000268	0.000029	0.000055	0.000290	0.001091	0.000026	0.000133	0.000075	0.000111	0.001478	0.000028	0.000023	0.000041	0.001734	0.000089	0.000573	0.000059	0.000142	0.000749	0.001330	0.000418	0.000118	0.000109	0.000168	0.000026	0.000013	0.000056	0.000051	0.000015	0.000042	0.000960	0.000198	0.000112	0.000703	0.000006	0.000068	0.000077	0.006876	0.000426	0.000453	0.000090	0.000045	0.000032	0.000424	0.000029	0.000279	0.000064	0.001635	0.000033	0.000145	0.001123	0.000712	0.005030	0.001076	0.000570	0.000176	0.005748	0.031999	0.003591	0.006867	0.005307	0.002150	0.017056	0.004462	0.000793	0.001402	0.001398	0.001638	0.005457	0.000228	0.000216	0.007403	0.000221	0.000452	0.008680	0.000174	0.000485	0.000054	0.004072	0.000086	0.000937	0.002375	0.000080
23644377 - Grizzly Bear - Shields- B-Sides - Will Calls (Marfa Demo)	23644377	0.024333	0.000297	0.000398	0.000658	0.000075	0.000206	0.000187	0.000032	0.000275	0.000220	0.000293	0.000178	0.000056	0.000058	0.000252	0.000436	0.000293	0.000127	0.000156	0.000075	0.000108	0.000083	0.000204	0.000208	0.000270	0.000202	0.000236	0.103464	0.000689	0.000432	0.000365	0.000714	0.004044	0.003170	0.000529	0.000315	0.000332	0.004344	0.000261	0.000045	0.001005	0.000404	0.000060	0.000065	0.000194	0.000034	0.000097	0.000174	0.000098	0.000539	0.000128	0.000048	0.000014	0.000182	0.000156	0.000102	0.000018	0.000194	0.000146	0.000619	0.000064	0.000133	0.000212	0.000247	0.001140	0.000461	0.000193	0.000069	0.000028	0.000642	0.000058	0.000012	0.003166	0.002827	0.002394	0.000862	0.000523	0.000926	0.000719	0.000219	0.000286	0.000252	0.000155	0.000140	0.000193	0.000063	0.000192	0.000056	0.000058	0.000014	0.000054	0.000055	0.001684	0.000044	0.000061	0.000081	0.000152	0.000132	0.000371	0.000183	0.000091	0.000114	0.000083	0.000074	0.000076	0.000124	0.000126	0.000138	0.000055	0.000038	0.000132	0.000619	0.000267	0.000231	0.000020	0.000090	0.000068	0.000095	0.000106	0.000196	0.000057	0.000014	0.000870	0.000074	0.000143	0.000043	0.000402	0.000189	0.000161	0.000148	0.000213	0.000057	0.000330	0.000130	0.000096	0.000309	0.000098	0.529170	0.127275	0.017917	0.033036	0.003815	0.009125	0.002934	0.001671	0.000703	0.002558	0.000350	0.000139	0.000200	0.000216	0.000487	0.002810	0.002451	0.001345	0.001018	0.000666	0.000535	0.003829	0.002663	0.000092	0.274708	0.402678	0.005601	0.385673	0.272842	0.239082	0.069508	0.321242	0.014612	0.000204	0.092715	0.063125	0.008963	0.000290	0.000086	0.000105	0.001702	0.000571	0.001669	0.002712	0.001781	0.001888	0.000126	0.002830	0.001467	0.000467	0.000553	0.000319	0.002581	0.000177	0.000902	0.000774	0.000710	0.001327	0.001602	0.000888	0.000725	0.000471	0.000335	0.000852	0.000269	0.000206	0.000312	0.002806	0.000296	0.000087	0.000026	0.000772	0.000203	0.000078	0.000159	0.000715	0.002213	0.003946	0.000056	0.011364	0.001395	0.000141	0.060093	0.007541	0.011004	0.013059	0.017551	0.005600	0.020250	0.008816	0.004823	0.001126	0.004766	0.000331	0.001162	0.004600	0.000558	0.000567	0.005907	0.000409	0.001469	0.000360	0.002871	0.000655	0.000362	0.000435	0.000517	0.000827	0.000282	0.004781	0.000251	0.000287	0.000061	0.000135	0.011488	0.000552	0.001778	0.002104	0.000367	0.000184	0.000104	0.001372	0.001974	0.000633	0.000117	0.000117	0.001599	0.000287	0.032027	0.010109	0.001029	0.000630	0.000318	0.001928	0.001877	0.000096	0.000650	0.001189	0.000505	0.000783	0.000185	0.000750	0.003523	0.002985	0.000135	0.000087	0.000069	0.000183	0.000066	0.000046	0.000071	0.000224	0.000060	0.000059	0.000052	0.000096	0.000054	0.000040	0.000037	0.000136	0.000148	0.000048	0.000132	0.001753	0.000123	0.000030	0.000086	0.000047	0.000020	0.000125	0.000413	0.000752	0.000077	0.000299	0.000025	0.000021	0.000030	0.000056	0.000072	0.000107	0.000022	0.000237	0.000019	0.000022	0.000044	0.000210	0.000178	0.000071	0.000084	0.000171	0.000024	0.000167	0.000219	0.000099	0.000089	0.000165	0.000006	0.000026	0.000135	0.000028	0.000055	0.000039	0.000049	0.000094	0.000451	0.000401	0.000196	0.000006	0.000023	0.000026	0.000029	0.000071	0.000054	0.000010	0.000054	0.000066	0.000125	0.000256	0.000643	0.000378	0.000082	0.000069	0.000239	0.000232	0.000200	0.000018	0.000068	0.000165	0.000102	0.000027	0.000049	0.000120	0.000063	0.000081	0.000064	0.000049	0.000026	0.000081	0.000005	0.000032	0.000034	0.000082	0.000425	0.000096	0.000161	0.000112	0.000016	0.000162	0.000060	0.000208	0.000117	0.003585	0.001686	0.000674	0.000877	0.000412	0.003487	0.007430	0.000870	0.001228	0.000368	0.001631	0.005872	0.008683	0.000347	0.001450	0.000137	0.000085	0.000045	0.000365	0.000539	0.000408	0.000039	0.000008	0.000028	0.000131	0.000010	0.000073	0.000050	0.000189	0.000323	0.000306	0.000063	0.000014	0.000026	0.000045	0.000004	0.000107	0.000139	0.000330	0.000503	0.000095	0.000028	0.000074	0.000615	0.000128	0.000082	0.000513	0.000069	0.000058	0.000117	0.000144	0.000005	0.000027	0.000190	0.000310	0.000079	0.000125	0.000035	0.000034	0.000150	0.000196	0.000012	0.000073	0.000046	0.000045	0.000148	0.000016	0.000028	0.000019	0.001462	0.000549	0.000331	0.000244	0.000519	0.002017	0.003410	0.001852	0.000040	0.000555	0.000148	0.000103	0.000015	0.000078	0.000078	0.000094	0.000065	0.000086	0.000071	0.000098	0.005429	0.000007	0.000041	0.000042	0.007014	0.000881	0.001168	0.000372	0.000052	0.000019	0.000554	0.000038	0.000412	0.000055	0.000627	0.000042	0.000434	0.000590	0.000120	0.001976	0.000034	0.000619	0.000060	0.007691	0.048591	0.003149	0.013603	0.003583	0.001117	0.015087	0.010729	0.000955	0.001339	0.001793	0.001879	0.005302	0.000202	0.000154	0.000522	0.000211	0.002004	0.001480	0.000104	0.000242	0.000046	0.001779	0.000146	0.000184	0.000328	0.000148
29855640 - Martyn - Glassbeadgames (8 Hours at Fabric Dub) - Glassbeadgames (8 Hours at Fabric Dub)	29855640	0.028863	0.000231	0.000321	0.000650	0.000056	0.000185	0.000086	0.000078	0.000157	0.000093	0.000178	0.000058	0.000025	0.000036	0.000171	0.000252	0.000331	0.000123	0.000121	0.000112	0.000092	0.000090	0.000189	0.000182	0.000204	0.000058	0.000102	0.004787	0.000160	0.000174	0.000070	0.000085	0.000180	0.000383	0.000082	0.000125	0.000628	0.000532	0.000158	0.000010	0.000352	0.000214	0.000029	0.000089	0.000081	0.000042	0.000166	0.000182	0.000105	0.000193	0.000025	0.000174	0.000142	0.000102	0.000265	0.000235	0.000014	0.000080	0.000034	0.000097	0.000130	0.000099	0.000184	0.000113	0.000795	0.000760	0.000092	0.000039	0.000050	0.000597	0.000204	0.000041	0.002448	0.001695	0.001106	0.000232	0.000222	0.000392	0.000292	0.000066	0.000223	0.000609	0.000172	0.000482	0.000344	0.000096	0.000350	0.000201	0.000210	0.000065	0.000104	0.000114	0.001638	0.000038	0.000108	0.000088	0.000246	0.000191	0.000909	0.000373	0.000230	0.000277	0.000282	0.000282	0.000157	0.000213	0.000241	0.000258	0.000077	0.000051	0.000096	0.000893	0.000533	0.000664	0.000063	0.000148	0.000136	0.000091	0.000094	0.000316	0.000219	0.000027	0.000357	0.000152	0.000215	0.000158	0.002682	0.000519	0.001137	0.001576	0.002955	0.000467	0.000154	0.000075	0.000088	0.001164	0.000074	0.769867	0.026214	0.001907	0.002050	0.000462	0.000600	0.000289	0.000147	0.000172	0.000229	0.000084	0.000304	0.000141	0.000275	0.000146	0.007990	0.006232	0.004856	0.000384	0.000375	0.000127	0.057854	0.069406	0.000835	0.008620	0.005735	0.105279	0.010697	0.002714	0.001652	0.001021	0.004298	0.002234	0.000370	0.001404	0.001414	0.004604	0.000223	0.000336	0.000388	0.001030	0.001119	0.007881	0.012683	0.010091	0.003545	0.000250	0.000668	0.000672	0.000148	0.000468	0.000167	0.000746	0.000083	0.001024	0.000821	0.000294	0.000171	0.001805	0.003450	0.000217	0.000535	0.000609	0.000464	0.000145	0.000306	0.000129	0.000538	0.002384	0.001048	0.000045	0.000223	0.000173	0.000204	0.000162	0.000326	0.004296	0.001637	0.002698	0.020181	0.015806	0.000346	0.001534	0.000406	0.000554	0.000204	0.000567	0.000575	0.000203	0.007470	0.002109	0.001170	0.000277	0.000963	0.000085	0.012126	0.000547	0.001356	0.002269	0.036189	0.001009	0.000425	0.225543	0.198543	0.059166	0.030382	0.043414	0.106341	0.101431	0.005331	0.031890	0.000525	0.000348	0.000094	0.001486	0.000958	0.001322	0.000434	0.000075	0.002883	0.004827	0.000350	0.000459	0.002306	0.000401	0.000847	0.000234	0.000678	0.002265	0.002197	0.006603	0.003086	0.000956	0.015922	0.000550	0.002462	0.000279	0.025850	0.000130	0.001703	0.002035	0.000431	0.001562	0.007463	0.000065	0.000412	0.000235	0.000285	0.000220	0.000099	0.000142	0.000406	0.000179	0.000147	0.000146	0.000100	0.000074	0.000155	0.000133	0.000244	0.000344	0.000078	0.000220	0.004125	0.000448	0.000104	0.000157	0.000194	0.000113	0.000345	0.001393	0.001015	0.000310	0.000492	0.000023	0.000082	0.000095	0.000250	0.000209	0.000199	0.000051	0.000534	0.000038	0.000396	0.000148	0.000446	0.000360	0.000424	0.000134	0.000311	0.000108	0.000236	0.000361	0.000106	0.000113	0.000207	0.000006	0.000066	0.000221	0.000047	0.000049	0.000061	0.000056	0.000171	0.000710	0.000206	0.000411	0.000021	0.000014	0.000074	0.000021	0.000213	0.000113	0.000022	0.000104	0.000146	0.000332	0.000439	0.001365	0.008841	0.000224	0.000140	0.000220	0.000382	0.000668	0.000013	0.000061	0.000363	0.000233	0.000025	0.000079	0.000210	0.000046	0.000141	0.000134	0.000066	0.000043	0.000117	0.000149	0.000153	0.000052	0.000180	0.000707	0.000082	0.000571	0.000595	0.000064	0.000425	0.000179	0.000546	0.000346	0.001033	0.001059	0.000242	0.027260	0.000793	0.000771	0.002905	0.000881	0.001094	0.000293	0.002181	0.001057	0.001305	0.000203	0.000906	0.000215	0.000342	0.000135	0.000491	0.001277	0.001144	0.000160	0.000018	0.000067	0.000116	0.000033	0.000119	0.000315	0.000438	0.000644	0.000422	0.000151	0.000007	0.000031	0.000103	0.000022	0.000130	0.000120	0.000399	0.000398	0.000089	0.000044	0.000048	0.000268	0.000111	0.000074	0.000898	0.000111	0.000052	0.000114	0.000103	0.000004	0.000053	0.000381	0.000756	0.000080	0.000340	0.000033	0.000107	0.001183	0.001932	0.000034	0.000193	0.000118	0.000195	0.001913	0.000073	0.000088	0.000039	0.000598	0.000165	0.000848	0.000172	0.000142	0.001252	0.001904	0.000354	0.000237	0.000132	0.000175	0.000061	0.000043	0.000060	0.000092	0.000080	0.000101	0.001472	0.000215	0.000180	0.001169	0.000016	0.000071	0.000051	0.004230	0.001424	0.001745	0.000362	0.000015	0.000022	0.000947	0.000093	0.000568	0.000125	0.000401	0.000059	0.000300	0.000506	0.001301	0.012404	0.003869	0.000806	0.000100	0.007178	0.004900	0.003046	0.001544	0.011687	0.003024	0.010036	0.003696	0.000850	0.002511	0.001816	0.001644	0.004671	0.000195	0.000247	0.005705	0.001696	0.000743	0.000712	0.001795	0.000994	0.000125	0.011015	0.000410	0.000536	0.000182	0.000072
193282128 - PinkPantheress - Just for me - Just for me	193282128	0.032277	0.000200	0.000667	0.005272	0.000074	0.000359	0.000359	0.000163	0.000380	0.000128	0.000215	0.000078	0.000041	0.000138	0.000467	0.001508	0.000556	0.000440	0.000279	0.000099	0.000192	0.000122	0.001112	0.001197	0.000982	0.000086	0.000160	0.033517	0.000199	0.000173	0.000050	0.000526	0.000648	0.007782	0.004663	0.004089	0.003064	0.000848	0.000180	0.000026	0.000689	0.000259	0.000067	0.000247	0.000281	0.000064	0.000231	0.001036	0.000242	0.000481	0.000275	0.000121	0.000166	0.000102	0.000383	0.000121	0.000009	0.000132	0.000306	0.000939	0.000150	0.000453	0.000145	0.000679	0.001450	0.002460	0.000336	0.000083	0.000038	0.000551	0.000065	0.000047	0.004185	0.003017	0.002048	0.000355	0.000313	0.000778	0.000355	0.000115	0.000415	0.000838	0.000169	0.000712	0.000205	0.000109	0.000514	0.000328	0.000320	0.000056	0.000100	0.000092	0.000462	0.000263	0.000436	0.000232	0.000279	0.000304	0.001319	0.001115	0.000607	0.000794	0.000345	0.000297	0.000218	0.000263	0.000258	0.000289	0.000032	0.000018	0.000060	0.001952	0.000705	0.000665	0.000030	0.000125	0.000092	0.000172	0.000187	0.000369	0.000044	0.000029	0.000471	0.000683	0.000368	0.000240	0.000954	0.000871	0.000321	0.000299	0.001109	0.000106	0.000808	0.000276	0.000071	0.000695	0.000021	0.778961	0.019612	0.006210	0.006897	0.001763	0.002250	0.003717	0.000460	0.000482	0.002446	0.000255	0.000942	0.000751	0.002709	0.000772	0.003071	0.002906	0.002061	0.000391	0.000235	0.000149	0.012927	0.022221	0.000832	0.001987	0.002786	0.032008	0.003928	0.001045	0.000743	0.000359	0.002630	0.000175	0.000223	0.000769	0.000691	0.000973	0.000252	0.000133	0.000092	0.000183	0.000190	0.001272	0.001822	0.002086	0.000273	0.000048	0.000310	0.000571	0.000230	0.000399	0.000093	0.001730	0.000241	0.002115	0.004793	0.000574	0.000340	0.001855	0.001780	0.000359	0.000511	0.003961	0.000457	0.000161	0.000278	0.000349	0.000121	0.000656	0.000606	0.000092	0.000943	0.000209	0.000720	0.000105	0.000554	0.000478	0.000673	0.000459	0.039207	0.017702	0.000497	0.002213	0.002363	0.002759	0.001683	0.002811	0.001643	0.000134	0.057125	0.006842	0.002039	0.000928	0.000168	0.000359	0.005066	0.001398	0.003080	0.004846	0.005680	0.001277	0.000237	0.115254	0.031500	0.016675	0.071585	0.023850	0.044162	0.026210	0.005052	0.011609	0.001385	0.000417	0.000575	0.008217	0.013211	0.010542	0.000948	0.000254	0.005641	0.007879	0.001131	0.001706	0.002372	0.000614	0.000557	0.000312	0.002105	0.009612	0.009227	0.010573	0.008489	0.001855	0.026383	0.017410	0.000818	0.001119	0.026218	0.000789	0.012759	0.002218	0.007232	0.025734	0.012822	0.000223	0.000159	0.000134	0.000183	0.000133	0.000040	0.000047	0.000490	0.000088	0.000113	0.000073	0.000152	0.000106	0.000076	0.000064	0.000157	0.000304	0.000096	0.000125	0.002395	0.000215	0.000044	0.000112	0.000104	0.000035	0.000255	0.000644	0.000617	0.000093	0.000795	0.000028	0.000026	0.000046	0.000113	0.000097	0.000332	0.000039	0.000330	0.000039	0.000179	0.000084	0.001610	0.001248	0.000834	0.000436	0.000172	0.000056	0.000234	0.000290	0.000066	0.000104	0.000213	0.000008	0.000038	0.000260	0.000047	0.000073	0.000075	0.000091	0.000149	0.000249	0.000096	0.000408	0.000013	0.000030	0.000074	0.000047	0.000170	0.000076	0.000026	0.000064	0.000105	0.000178	0.000207	0.000145	0.000483	0.000094	0.000090	0.000167	0.000801	0.000436	0.000006	0.000021	0.000102	0.000084	0.000036	0.000046	0.000041	0.000038	0.000133	0.000069	0.000122	0.000048	0.000056	0.000060	0.000131	0.000057	0.000131	0.000280	0.000041	0.000407	0.000274	0.000043	0.000262	0.000128	0.000294	0.000369	0.003604	0.000830	0.000728	0.011061	0.000315	0.001264	0.001410	0.000861	0.004169	0.000732	0.002038	0.002945	0.005914	0.000062	0.001419	0.000106	0.000297	0.000189	0.000941	0.002576	0.001602	0.000207	0.000023	0.000036	0.000032	0.000007	0.000055	0.000127	0.000313	0.000681	0.000290	0.000063	0.000020	0.000061	0.000049	0.000012	0.000146	0.000116	0.000332	0.000278	0.000107	0.000028	0.000058	0.000170	0.000321	0.000242	0.001499	0.000041	0.000051	0.000197	0.000519	0.000020	0.000029	0.000402	0.000355	0.000088	0.000276	0.000114	0.000134	0.000262	0.000811	0.000052	0.000193	0.000129	0.000121	0.000416	0.000061	0.000038	0.000024	0.000521	0.000160	0.000397	0.000154	0.000037	0.004757	0.002792	0.000944	0.000053	0.000119	0.000191	0.000041	0.000017	0.000091	0.000101	0.000090	0.000080	0.000485	0.000100	0.000132	0.000655	0.000019	0.000045	0.000041	0.002806	0.000803	0.000459	0.000085	0.000057	0.000030	0.000474	0.000051	0.000433	0.000066	0.000558	0.000067	0.000091	0.001096	0.001090	0.006132	0.015973	0.000252	0.000165	0.005412	0.004164	0.004112	0.001528	0.005098	0.006367	0.006099	0.001509	0.000423	0.001219	0.001649	0.001766	0.004855	0.000262	0.000271	0.008322	0.000801	0.001377	0.000988	0.000856	0.000359	0.000044	0.004301	0.000196	0.000244	0.000464	0.000045
245665015 - Pedestrian - Circadian Rhythms - Jnt	245665015	0.036881	0.000326	0.000385	0.000561	0.000102	0.000234	0.000082	0.000103	0.000367	0.000147	0.000232	0.000084	0.000061	0.000078	0.000201	0.000214	0.000225	0.000047	0.000054	0.000102	0.000063	0.000085	0.000120	0.000165	0.000123	0.000024	0.000105	0.005270	0.000475	0.000273	0.000090	0.000136	0.000289	0.000350	0.000140	0.000155	0.003609	0.000123	0.000087	0.000007	0.000446	0.000336	0.000035	0.000105	0.000050	0.000079	0.000126	0.000105	0.000065	0.000109	0.000091	0.000252	0.000051	0.000233	0.000247	0.000211	0.000019	0.000136	0.000051	0.000157	0.000071	0.000179	0.000057	0.000131	0.001000	0.000614	0.000272	0.000086	0.000131	0.000933	0.000255	0.000064	0.001994	0.001513	0.001109	0.000298	0.000235	0.000457	0.000434	0.000075	0.000187	0.000429	0.000089	0.000196	0.000247	0.000052	0.000252	0.000323	0.000284	0.000088	0.000106	0.000104	0.000406	0.000054	0.000135	0.000172	0.000234	0.000238	0.000506	0.000298	0.000161	0.000158	0.000156	0.000146	0.000103	0.000130	0.000114	0.000120	0.000056	0.000045	0.000103	0.000581	0.000250	0.000199	0.000011	0.000169	0.000118	0.000078	0.000057	0.000100	0.000034	0.000013	0.000304	0.000154	0.000258	0.000136	0.000495	0.000123	0.000055	0.000168	0.000408	0.000156	0.000169	0.000071	0.000086	0.000694	0.000306	0.654258	0.078275	0.003827	0.004955	0.000822	0.001141	0.000723	0.000215	0.000242	0.000559	0.000237	0.000254	0.000299	0.000338	0.000237	0.024473	0.022452	0.009215	0.010964	0.004869	0.003913	0.053856	0.030923	0.001067	0.006505	0.004373	0.041475	0.005440	0.001802	0.001446	0.000792	0.003004	0.002060	0.000224	0.000842	0.000813	0.001328	0.000148	0.000302	0.000360	0.000886	0.000770	0.017752	0.023377	0.021300	0.005910	0.000703	0.024387	0.104775	0.060252	0.025145	0.045583	0.007215	0.001026	0.006837	0.001191	0.004358	0.003087	0.009948	0.004687	0.005447	0.015133	0.001381	0.000755	0.000336	0.000319	0.000089	0.000586	0.004973	0.002112	0.000072	0.002240	0.007488	0.000282	0.003951	0.001157	0.019359	0.006815	0.003715	0.005656	0.023269	0.000388	0.001534	0.000533	0.000385	0.000138	0.000378	0.000390	0.000138	0.002524	0.001217	0.004572	0.000330	0.000845	0.000163	0.002669	0.000368	0.000630	0.003801	0.004343	0.016973	0.000663	0.122510	0.016460	0.008970	0.025303	0.102551	0.022132	0.008927	0.021741	0.006422	0.001262	0.000606	0.000197	0.000877	0.000462	0.001776	0.000301	0.000071	0.002931	0.003833	0.000836	0.000395	0.001267	0.000233	0.000262	0.000392	0.000539	0.001212	0.001276	0.003299	0.001808	0.000731	0.005167	0.000476	0.001161	0.000649	0.003251	0.000281	0.000554	0.000928	0.000405	0.001178	0.002584	0.000175	0.000300	0.000477	0.000450	0.000405	0.000052	0.000055	0.000659	0.000114	0.000086	0.000108	0.000231	0.000176	0.000353	0.000280	0.000206	0.000405	0.000174	0.000198	0.005944	0.000896	0.000180	0.000303	0.000229	0.000335	0.000457	0.001754	0.001683	0.000478	0.000198	0.000057	0.000175	0.000180	0.000268	0.000347	0.000394	0.000101	0.000967	0.000073	0.000751	0.000214	0.000697	0.000432	0.000358	0.000234	0.000262	0.000190	0.000460	0.000662	0.000191	0.000252	0.000359	0.000017	0.000134	0.000218	0.000039	0.000057	0.000054	0.000060	0.000164	0.001030	0.000839	0.000476	0.000016	0.000018	0.000064	0.000051	0.000195	0.000128	0.000035	0.000098	0.000124	0.000278	0.000512	0.000288	0.001042	0.000241	0.000156	0.000290	0.000383	0.000172	0.000037	0.000109	0.000279	0.000130	0.000121	0.000091	0.000158	0.000084	0.000188	0.000135	0.000102	0.000117	0.000110	0.000122	0.000034	0.000126	0.000158	0.000654	0.000065	0.000252	0.000244	0.000055	0.000300	0.000157	0.000335	0.000345	0.000538	0.000416	0.000141	0.000723	0.000414	0.001141	0.001063	0.000543	0.001643	0.000517	0.000798	0.000536	0.000195	0.017796	0.000539	0.000136	0.000362	0.000153	0.001116	0.001514	0.001632	0.000140	0.000023	0.000248	0.000286	0.000067	0.000072	0.000231	0.000321	0.000322	0.000696	0.000154	0.000022	0.000086	0.000152	0.000023	0.000203	0.000173	0.000232	0.000293	0.000116	0.000085	0.000063	0.000108	0.000207	0.000082	0.000462	0.000077	0.000061	0.000340	0.000697	0.000014	0.000034	0.001542	0.000606	0.000094	0.000488	0.000071	0.000131	0.000323	0.000771	0.000102	0.000349	0.000198	0.000288	0.000660	0.000086	0.000072	0.000066	0.008022	0.000153	0.001159	0.000143	0.000322	0.001733	0.002597	0.000414	0.000690	0.000075	0.000158	0.000141	0.000106	0.000062	0.000405	0.000072	0.000086	0.002017	0.000210	0.000269	0.000331	0.000014	0.000065	0.000025	0.002940	0.000623	0.000717	0.000122	0.000043	0.000045	0.000774	0.000048	0.000540	0.000114	0.000300	0.000075	0.000287	0.000535	0.000838	0.009065	0.000725	0.000278	0.000097	0.005667	0.021726	0.003768	0.007477	0.005607	0.003184	0.011104	0.015431	0.003320	0.003858	0.001592	0.001766	0.002957	0.000840	0.000113	0.007124	0.000989	0.000969	0.002913	0.000637	0.000977	0.000255	0.009501	0.000254	0.002538	0.000836	0.000050
183374187 - Skrillex - Butterflies - Butterflies	183374187	0.050410	0.000847	0.000743	0.001253	0.000199	0.000644	0.000183	0.000345	0.000174	0.000099	0.000144	0.000043	0.000051	0.000027	0.000189	0.000476	0.000512	0.000143	0.000119	0.000185	0.000156	0.000176	0.000337	0.000260	0.000255	0.000132	0.000146	0.011648	0.000289	0.000219	0.000142	0.000320	0.001035	0.000702	0.000353	0.000864	0.006917	0.000063	0.000254	0.000021	0.000458	0.000279	0.000087	0.000212	0.000096	0.000043	0.000195	0.000230	0.000109	0.000220	0.000183	0.000128	0.000158	0.000184	0.000587	0.000314	0.000036	0.000083	0.000182	0.000339	0.000216	0.000271	0.000141	0.000293	0.000609	0.000652	0.000097	0.000042	0.000184	0.000451	0.000162	0.000065	0.003185	0.002265	0.001518	0.000464	0.000461	0.000403	0.000652	0.000129	0.000365	0.000539	0.000101	0.000316	0.000366	0.000125	0.000402	0.000228	0.000206	0.000060	0.000095	0.000088	0.000408	0.000143	0.000280	0.000183	0.000283	0.000278	0.000876	0.000527	0.000275	0.000338	0.000272	0.000258	0.000212	0.000287	0.000188	0.000187	0.000049	0.000037	0.000081	0.001454	0.000636	0.000621	0.000037	0.000287	0.000195	0.000112	0.000100	0.000120	0.000038	0.000038	0.000361	0.000291	0.000336	0.000223	0.001118	0.000715	0.000189	0.000323	0.001300	0.000218	0.000629	0.000257	0.000195	0.001977	0.000043	0.812746	0.023229	0.002904	0.002821	0.000555	0.000385	0.000492	0.000119	0.000122	0.000474	0.000797	0.000384	0.000554	0.000471	0.000351	0.004746	0.004474	0.002236	0.000742	0.000608	0.000303	0.014713	0.048079	0.000501	0.002688	0.003335	0.047853	0.005175	0.001108	0.000848	0.000496	0.002361	0.000188	0.000216	0.000572	0.000491	0.000721	0.000313	0.000887	0.001188	0.000165	0.000613	0.006279	0.007666	0.008136	0.000870	0.000266	0.000680	0.001213	0.000359	0.000679	0.000349	0.000875	0.000092	0.000927	0.000922	0.000282	0.000161	0.001521	0.000960	0.000380	0.000508	0.000694	0.000417	0.000118	0.000411	0.000236	0.000127	0.003953	0.002280	0.000053	0.000399	0.000427	0.000197	0.000121	0.000340	0.000541	0.000540	0.001604	0.024319	0.046423	0.000228	0.001780	0.000728	0.002149	0.000552	0.001306	0.001338	0.000172	0.023469	0.002612	0.010871	0.001094	0.000677	0.000500	0.011182	0.000471	0.001937	0.005423	0.030434	0.001207	0.000178	0.158137	0.126302	0.039303	0.011826	0.105881	0.105695	0.048567	0.003459	0.031981	0.001603	0.000326	0.000115	0.005059	0.001145	0.002216	0.000557	0.000135	0.027932	0.135313	0.000965	0.001177	0.000535	0.000165	0.000127	0.000768	0.000562	0.006247	0.015070	0.006753	0.003240	0.001492	0.018034	0.001093	0.001125	0.000903	0.058467	0.000122	0.005496	0.003458	0.000325	0.003067	0.018658	0.000064	0.000105	0.000192	0.000213	0.000164	0.000049	0.000057	0.000564	0.000120	0.000130	0.000122	0.000137	0.000063	0.000100	0.000076	0.000246	0.000380	0.000157	0.000350	0.003110	0.000304	0.000070	0.000142	0.000128	0.000049	0.000261	0.000890	0.000559	0.000096	0.000462	0.000021	0.000037	0.000045	0.000131	0.000115	0.000223	0.000042	0.000298	0.000049	0.000938	0.000084	0.000592	0.000400	0.000349	0.000190	0.000146	0.000069	0.000278	0.000395	0.000096	0.000121	0.000223	0.000011	0.000109	0.000224	0.000043	0.000060	0.000050	0.000090	0.000146	0.000748	0.000452	0.000326	0.000012	0.000020	0.000057	0.000024	0.000123	0.000066	0.000020	0.000083	0.000082	0.000150	0.000330	0.000634	0.001230	0.000191	0.000097	0.000114	0.000415	0.000263	0.000017	0.000063	0.000313	0.000167	0.000106	0.000170	0.000103	0.000051	0.000284	0.000201	0.000171	0.000062	0.000078	0.000286	0.000117	0.000081	0.000285	0.001585	0.000246	0.000338	0.000478	0.000249	0.000375	0.000291	0.000399	0.000442	0.002538	0.001998	0.000784	0.009541	0.001290	0.001156	0.000900	0.001987	0.001635	0.000352	0.002867	0.002677	0.002444	0.000221	0.001123	0.000126	0.000598	0.000358	0.002188	0.001775	0.001826	0.000365	0.000047	0.000083	0.000103	0.000027	0.000169	0.000218	0.000660	0.000759	0.000387	0.000095	0.000013	0.000057	0.000175	0.000093	0.000116	0.000116	0.000316	0.000385	0.000126	0.000037	0.000059	0.000242	0.000174	0.000136	0.001282	0.000096	0.000031	0.000258	0.000421	0.000007	0.000070	0.000656	0.000817	0.000057	0.000424	0.000055	0.000132	0.000564	0.001400	0.000080	0.000225	0.000218	0.000210	0.001629	0.000065	0.000137	0.000050	0.000746	0.000138	0.000793	0.000083	0.000075	0.000327	0.000713	0.000264	0.000253	0.000093	0.000294	0.000073	0.000065	0.000099	0.000209	0.000067	0.000064	0.000790	0.000613	0.000355	0.000999	0.000036	0.000217	0.000163	0.002892	0.001387	0.000770	0.000128	0.000042	0.000053	0.000824	0.000033	0.000633	0.000236	0.000406	0.000067	0.000124	0.000687	0.001247	0.005659	0.006106	0.000264	0.000323	0.003256	0.001205	0.003259	0.000307	0.009554	0.004682	0.009138	0.003192	0.000985	0.001520	0.001588	0.001214	0.004669	0.000187	0.000281	0.023033	0.000694	0.000286	0.001772	0.000696	0.000545	0.000072	0.004461	0.000183	0.001034	0.001134	0.000116
95469341 - Columbine - Adieu bientôt - Adieu bientôt	95469341	0.022646	0.000319	0.000280	0.001464	0.000074	0.000263	0.000347	0.000101	0.000333	0.000325	0.000338	0.000135	0.000032	0.000065	0.000755	0.001103	0.000398	0.000329	0.000263	0.000083	0.000259	0.000061	0.000658	0.000720	0.000637	0.000341	0.000273	0.034355	0.000164	0.000058	0.000053	0.000129	0.000803	0.000906	0.000299	0.000293	0.055075	0.000149	0.000262	0.000036	0.003729	0.000367	0.000098	0.000093	0.000611	0.000045	0.000193	0.000400	0.000289	0.000429	0.000121	0.000030	0.000034	0.000084	0.000401	0.000191	0.000012	0.000155	0.000249	0.000521	0.000163	0.000132	0.000354	0.000147	0.001108	0.000727	0.000168	0.000026	0.000023	0.000391	0.000063	0.000031	0.004474	0.003975	0.003185	0.001012	0.000475	0.001061	0.000648	0.000204	0.000437	0.000597	0.000121	0.000376	0.000170	0.000126	0.000219	0.000125	0.000086	0.000052	0.000031	0.000030	0.000203	0.000139	0.000261	0.000115	0.000163	0.000168	0.000414	0.000338	0.000147	0.000351	0.000107	0.000095	0.000091	0.000170	0.000096	0.000111	0.000022	0.000017	0.000045	0.001470	0.000681	0.000726	0.000045	0.000090	0.000066	0.000223	0.000329	0.000705	0.000138	0.000034	0.000929	0.000253	0.000281	0.000084	0.000806	0.000803	0.000208	0.000160	0.000177	0.000054	0.001422	0.000541	0.000070	0.000273	0.000023	0.790313	0.018692	0.004680	0.004976	0.001030	0.001069	0.002282	0.000567	0.000208	0.001617	0.000438	0.000210	0.000476	0.000677	0.000778	0.005337	0.006343	0.005078	0.000926	0.000544	0.000424	0.004469	0.007800	0.000573	0.001837	0.002132	0.003937	0.002837	0.000562	0.000499	0.000135	0.001453	0.000250	0.000118	0.000338	0.000316	0.000338	0.000099	0.000072	0.000093	0.000218	0.001223	0.010826	0.012975	0.016375	0.002178	0.000127	0.000520	0.001004	0.000280	0.000790	0.000248	0.000813	0.000081	0.000907	0.001597	0.000289	0.000181	0.002929	0.002089	0.000590	0.000402	0.001693	0.000376	0.000097	0.000221	0.000110	0.000372	0.007476	0.003818	0.000037	0.001053	0.000166	0.000372	0.000031	0.000384	0.000406	0.001447	0.000148	0.059894	0.109691	0.000255	0.001519	0.002751	0.010311	0.002311	0.009142	0.005157	0.000216	0.172785	0.022343	0.005306	0.001751	0.000396	0.000856	0.015843	0.000993	0.007291	0.027191	0.002697	0.001085	0.000098	0.005606	0.003224	0.001322	0.002902	0.000619	0.005064	0.001090	0.003537	0.000575	0.000635	0.000195	0.000161	0.034990	0.002681	0.019701	0.000733	0.000101	0.002784	0.002744	0.001021	0.002712	0.001194	0.000134	0.000167	0.001410	0.000672	0.037920	0.014451	0.022015	0.009902	0.000853	0.052511	0.004776	0.001126	0.001300	0.021605	0.000522	0.012835	0.003179	0.007066	0.037276	0.034526	0.000188	0.000139	0.000077	0.000121	0.000069	0.000021	0.000027	0.000225	0.000037	0.000061	0.000031	0.000096	0.000034	0.000040	0.000033	0.000110	0.000219	0.000024	0.000073	0.001365	0.000117	0.000022	0.000092	0.000040	0.000011	0.000090	0.000273	0.000388	0.000058	0.000588	0.000008	0.000011	0.000013	0.000043	0.000029	0.000113	0.000012	0.000126	0.000017	0.000644	0.000030	0.000546	0.000492	0.000283	0.000124	0.000095	0.000020	0.000106	0.000147	0.000054	0.000064	0.000096	0.000002	0.000024	0.000072	0.000011	0.000018	0.000021	0.000032	0.000041	0.000181	0.000139	0.000131	0.000007	0.000034	0.000025	0.000019	0.000047	0.000025	0.000005	0.000021	0.000027	0.000086	0.000195	0.000924	0.002021	0.000064	0.000103	0.000149	0.000295	0.000517	0.000004	0.000012	0.000078	0.000056	0.000135	0.000014	0.000065	0.000013	0.000069	0.000049	0.000065	0.000019	0.000034	0.000012	0.000046	0.000026	0.000120	0.000312	0.000051	0.000174	0.000067	0.000043	0.000301	0.000030	0.000386	0.000170	0.002945	0.001797	0.000737	0.005186	0.000699	0.003831	0.002236	0.001151	0.001512	0.000282	0.001313	0.004738	0.005081	0.000047	0.007561	0.000120	0.000108	0.000047	0.001215	0.001078	0.001078	0.000043	0.000012	0.000016	0.000030	0.000006	0.000079	0.000034	0.000209	0.000322	0.000169	0.000027	0.000005	0.000015	0.000018	0.000003	0.000070	0.000083	0.000292	0.000139	0.000027	0.000010	0.000025	0.000167	0.000242	0.000127	0.001570	0.000034	0.000028	0.000079	0.001373	0.000007	0.000019	0.000417	0.000352	0.000030	0.000173	0.000035	0.000041	0.000251	0.000747	0.000029	0.000157	0.000028	0.000051	0.000136	0.000013	0.000010	0.000013	0.000807	0.000181	0.000241	0.000085	0.000145	0.001947	0.001244	0.000528	0.000158	0.000670	0.000668	0.000040	0.000020	0.000067	0.000134	0.000037	0.000035	0.000089	0.000078	0.000038	0.001007	0.000011	0.000049	0.000041	0.003688	0.000564	0.001048	0.000124	0.000039	0.000021	0.000309	0.000016	0.000214	0.000026	0.001718	0.000028	0.000079	0.001308	0.001802	0.001138	0.001397	0.000228	0.000135	0.004180	0.005512	0.003462	0.001970	0.003237	0.001011	0.008207	0.001317	0.000239	0.000865	0.001240	0.000929	0.003635	0.000053	0.000300	0.001195	0.000194	0.000536	0.000315	0.000105	0.000134	0.000019	0.001028	0.000070	0.000168	0.000238	0.000054
92271761 - Stupeflip - Stup Virus - Le trou noir	92271761	0.226362	0.002398	0.000916	0.002246	0.000435	0.001560	0.000307	0.000952	0.000660	0.000400	0.000466	0.000129	0.000044	0.000080	0.000580	0.000556	0.000744	0.000251	0.000325	0.000317	0.000375	0.000209	0.000886	0.000952	0.000787	0.000143	0.000598	0.029572	0.000346	0.000306	0.000165	0.000263	0.000816	0.000562	0.000311	0.000385	0.218866	0.000405	0.000499	0.000058	0.001920	0.000358	0.000045	0.000104	0.000290	0.000041	0.000167	0.000266	0.000281	0.000292	0.000103	0.000216	0.000021	0.000122	0.000271	0.000159	0.000036	0.000139	0.000163	0.000176	0.000328	0.000146	0.000092	0.000146	0.000795	0.000642	0.000195	0.000058	0.000172	0.000642	0.000206	0.000063	0.004295	0.003191	0.001858	0.000446	0.000396	0.001001	0.000591	0.000141	0.000330	0.000808	0.000132	0.000548	0.000167	0.000171	0.000535	0.000276	0.000200	0.000158	0.000169	0.000173	0.000108	0.000166	0.000474	0.000246	0.000564	0.000535	0.001420	0.000585	0.000278	0.000513	0.000388	0.000387	0.000287	0.000461	0.000321	0.000355	0.000109	0.000100	0.000172	0.001496	0.000772	0.000650	0.000069	0.000181	0.000142	0.000341	0.000389	0.000442	0.000103	0.000044	0.000671	0.000152	0.000235	0.000092	0.001067	0.000393	0.000638	0.000470	0.000427	0.000158	0.001029	0.000499	0.000091	0.000188	0.000110	0.729646	0.019944	0.003506	0.003771	0.001130	0.001162	0.000617	0.000695	0.000444	0.000540	0.000301	0.000452	0.000406	0.000436	0.000217	0.012494	0.010298	0.008444	0.002365	0.002302	0.000801	0.045766	0.043611	0.001340	0.001285	0.001185	0.023761	0.001618	0.000387	0.000340	0.000124	0.000845	0.000579	0.000158	0.000207	0.000196	0.000189	0.000058	0.000103	0.000065	0.000540	0.000308	0.004740	0.006851	0.006039	0.002212	0.000158	0.001734	0.002901	0.001130	0.001487	0.000662	0.001930	0.000402	0.003657	0.001030	0.000979	0.000552	0.005740	0.004538	0.001123	0.001692	0.000898	0.000375	0.000225	0.000274	0.000106	0.000292	0.001341	0.000675	0.000039	0.001675	0.000546	0.000219	0.001052	0.001526	0.014949	0.002680	0.002257	0.020390	0.292246	0.000574	0.002231	0.001501	0.002001	0.001175	0.003289	0.001899	0.000577	0.017249	0.007019	0.008110	0.001030	0.000479	0.000421	0.007493	0.000589	0.001712	0.003582	0.002393	0.002559	0.000662	0.058359	0.004288	0.002993	0.041580	0.010358	0.021775	0.001891	0.027309	0.002583	0.000593	0.000206	0.000130	0.005363	0.001035	0.008740	0.001056	0.000125	0.002357	0.001585	0.001271	0.001237	0.001769	0.000264	0.000363	0.000710	0.000306	0.013574	0.010253	0.007658	0.003587	0.001299	0.008065	0.000503	0.000929	0.001087	0.004177	0.000257	0.000876	0.000971	0.001262	0.005086	0.006620	0.000372	0.000474	0.000210	0.000139	0.000179	0.000038	0.000044	0.000382	0.000054	0.000039	0.000042	0.000110	0.000045	0.000100	0.000079	0.000097	0.000188	0.000082	0.000102	0.003258	0.000364	0.000067	0.000201	0.000128	0.000076	0.000215	0.000851	0.000709	0.000183	0.000429	0.000039	0.000089	0.000073	0.000149	0.000181	0.000225	0.000051	0.000304	0.000066	0.000315	0.000106	0.000570	0.000594	0.000271	0.000140	0.000301	0.000057	0.000228	0.000303	0.000100	0.000161	0.000206	0.000008	0.000053	0.000154	0.000028	0.000031	0.000041	0.000057	0.000108	0.000604	0.000933	0.000175	0.000011	0.000022	0.000034	0.000029	0.000067	0.000045	0.000013	0.000038	0.000061	0.000129	0.000414	0.000366	0.000836	0.000094	0.000185	0.000140	0.000233	0.000149	0.000024	0.000024	0.000136	0.000073	0.000216	0.000036	0.000152	0.000045	0.000098	0.000060	0.000115	0.000025	0.000040	0.000034	0.000063	0.000049	0.000231	0.000226	0.000066	0.000122	0.000445	0.000078	0.000236	0.000047	0.000301	0.000245	0.003052	0.001773	0.000556	0.002606	0.000848	0.005465	0.003697	0.000810	0.001479	0.000367	0.001764	0.006005	0.003608	0.000566	0.002003	0.000083	0.000122	0.000054	0.000363	0.000456	0.000459	0.000049	0.000015	0.000053	0.000121	0.000033	0.000075	0.000122	0.000409	0.000842	0.000285	0.000072	0.000018	0.000026	0.000038	0.000008	0.000100	0.000129	0.000440	0.000322	0.000095	0.000071	0.000100	0.000185	0.000309	0.000158	0.001106	0.000090	0.000104	0.000120	0.000621	0.000012	0.000028	0.000300	0.000229	0.000136	0.000246	0.000070	0.000102	0.000234	0.000529	0.000039	0.000211	0.000060	0.000097	0.000478	0.000027	0.000017	0.000024	0.003438	0.000300	0.000539	0.000149	0.000236	0.000680	0.003643	0.001666	0.000641	0.000299	0.000755	0.000059	0.000040	0.000085	0.000113	0.000056	0.000049	0.001056	0.000081	0.000094	0.000588	0.000006	0.000069	0.000049	0.006359	0.000267	0.000625	0.000094	0.000035	0.000019	0.000286	0.000022	0.000225	0.000049	0.000542	0.000038	0.000168	0.000729	0.000772	0.007753	0.000515	0.001283	0.000146	0.010083	0.013126	0.002298	0.004237	0.003873	0.000907	0.012382	0.005602	0.001076	0.003109	0.001627	0.001066	0.004230	0.000172	0.000304	0.002770	0.000709	0.001464	0.006527	0.000329	0.000307	0.000076	0.008330	0.000102	0.001226	0.002567	0.000055
136062174 - Headie One - GANG - The Boys (Interlude)	136062174	0.442448	0.006150	0.001400	0.001486	0.000775	0.002564	0.000240	0.001282	0.001219	0.001260	0.001716	0.000349	0.000042	0.000106	0.000949	0.000453	0.001089	0.000305	0.000442	0.000538	0.000269	0.000538	0.000685	0.000770	0.000966	0.000248	0.001203	0.040783	0.000453	0.000473	0.000211	0.000281	0.004997	0.000839	0.000277	0.000853	0.224452	0.000137	0.003054	0.000277	0.000935	0.000467	0.000102	0.000321	0.000532	0.000050	0.000189	0.001846	0.001287	0.000552	0.000143	0.000148	0.000079	0.000128	0.000168	0.000322	0.000055	0.000118	0.000688	0.000399	0.000409	0.000060	0.000056	0.000239	0.000167	0.000387	0.000431	0.000113	0.000340	0.001660	0.001028	0.000038	0.004646	0.003181	0.002129	0.000541	0.000619	0.000806	0.000726	0.000316	0.000503	0.000862	0.000108	0.000705	0.000301	0.000199	0.000396	0.000301	0.000209	0.000152	0.000109	0.000100	0.000109	0.000206	0.000710	0.000199	0.000697	0.000600	0.000953	0.000674	0.000313	0.000510	0.000193	0.000197	0.000274	0.000487	0.000186	0.000210	0.000101	0.000106	0.000461	0.001519	0.000710	0.000725	0.000080	0.000189	0.000173	0.000291	0.000248	0.000512	0.000080	0.000027	0.000674	0.000267	0.000332	0.000100	0.000555	0.000358	0.000177	0.000185	0.000453	0.000092	0.000875	0.000332	0.000261	0.000869	0.000089	0.786002	0.038176	0.001989	0.001764	0.000426	0.000409	0.000299	0.000551	0.000267	0.000232	0.000742	0.000166	0.000532	0.000526	0.000340	0.096297	0.099898	0.091484	0.006140	0.009503	0.002214	0.047788	0.018761	0.005463	0.001437	0.001197	0.011232	0.001580	0.000396	0.000311	0.000185	0.000723	0.000146	0.000095	0.000262	0.000215	0.000259	0.000137	0.000491	0.000468	0.000369	0.000533	0.004618	0.005954	0.006411	0.001631	0.000560	0.000539	0.001278	0.000407	0.000721	0.000264	0.001117	0.000155	0.001480	0.001184	0.000440	0.000291	0.002054	0.001708	0.000550	0.000610	0.001251	0.000340	0.000113	0.000284	0.000053	0.000071	0.000569	0.000185	0.000024	0.000670	0.000531	0.000079	0.000430	0.000565	0.003502	0.001142	0.005005	0.017258	0.293662	0.001328	0.001187	0.000938	0.002064	0.000399	0.001543	0.001221	0.000219	0.015910	0.003750	0.009291	0.001126	0.000370	0.000570	0.003351	0.000573	0.002229	0.005036	0.001680	0.003200	0.000593	0.029304	0.006073	0.002950	0.009545	0.003997	0.009179	0.001954	0.007385	0.001492	0.001676	0.000308	0.000113	0.004488	0.001490	0.006775	0.001763	0.000185	0.004056	0.004277	0.001545	0.002044	0.002852	0.000144	0.000249	0.000979	0.000450	0.017709	0.010855	0.007369	0.002477	0.001906	0.008564	0.001749	0.000962	0.001079	0.004530	0.000513	0.001917	0.002767	0.001494	0.006463	0.004724	0.000143	0.000265	0.000137	0.000159	0.000123	0.000028	0.000030	0.000333	0.000059	0.000049	0.000062	0.000080	0.000043	0.000063	0.000047	0.000165	0.000228	0.000057	0.000203	0.003295	0.000248	0.000066	0.000106	0.000115	0.000039	0.000218	0.000934	0.000848	0.000212	0.000307	0.000029	0.000043	0.000047	0.000166	0.000146	0.000196	0.000053	0.000417	0.000044	0.001396	0.000134	0.000410	0.000370	0.000152	0.000134	0.000221	0.000057	0.000282	0.000443	0.000143	0.000167	0.000234	0.000008	0.000110	0.000104	0.000014	0.000031	0.000029	0.000064	0.000062	0.000527	0.000853	0.000289	0.000016	0.000017	0.000025	0.000027	0.000139	0.000073	0.000016	0.000088	0.000097	0.000188	0.000410	0.001325	0.001894	0.000149	0.000186	0.000137	0.000344	0.000321	0.000013	0.000021	0.000114	0.000053	0.000301	0.000067	0.000214	0.000033	0.000127	0.000079	0.000084	0.000029	0.000035	0.000050	0.000043	0.000037	0.000289	0.000318	0.000075	0.000083	0.000383	0.000058	0.000318	0.000076	0.000438	0.000306	0.002046	0.004217	0.001501	0.008574	0.001319	0.011587	0.006921	0.001461	0.001277	0.000399	0.001962	0.001850	0.001143	0.000205	0.000797	0.000155	0.000201	0.000077	0.000352	0.000495	0.000447	0.000068	0.000014	0.000093	0.000098	0.000030	0.000107	0.000105	0.000606	0.001321	0.000197	0.000020	0.000019	0.000024	0.000050	0.000005	0.000074	0.000098	0.000436	0.000301	0.000168	0.000059	0.000037	0.000178	0.000098	0.000074	0.001395	0.000108	0.000093	0.000104	0.000320	0.000005	0.000038	0.000159	0.000271	0.000121	0.000187	0.000046	0.000091	0.000158	0.000219	0.000018	0.000125	0.000050	0.000087	0.000321	0.000028	0.000028	0.000056	0.007149	0.000118	0.000954	0.000115	0.000382	0.001902	0.001431	0.000553	0.000325	0.000980	0.000863	0.000106	0.000057	0.000075	0.000065	0.000046	0.000127	0.001859	0.000576	0.000089	0.000605	0.000006	0.000029	0.000030	0.018681	0.000723	0.001561	0.000256	0.000109	0.000017	0.000850	0.000033	0.000778	0.000102	0.000491	0.000055	0.000478	0.002006	0.001294	0.000960	0.001661	0.001083	0.000109	0.008430	0.004515	0.004203	0.000877	0.011653	0.000309	0.021595	0.010395	0.004357	0.004414	0.001889	0.002495	0.004426	0.000223	0.000237	0.001245	0.000192	0.000471	0.007855	0.001128	0.000426	0.000068	0.000932	0.000164	0.003335	0.007726	0.000157
87949222 - Stromae - Défiler (Bande originale de la capsule No. 5 Mosaert) - Défiler (Bande originale de la capsule No. 5 Mosaert)	87949222	0.154169	0.003172	0.000494	0.001008	0.000297	0.001456	0.000142	0.000300	0.000628	0.000383	0.000529	0.000109	0.000138	0.000043	0.000491	0.000671	0.000442	0.000180	0.000211	0.000144	0.000170	0.000152	0.000326	0.000312	0.000540	0.000154	0.000457	0.063742	0.001129	0.000215	0.000604	0.001137	0.005089	0.001135	0.000226	0.000501	0.063645	0.000398	0.000262	0.000025	0.001584	0.000886	0.000061	0.000122	0.000480	0.000106	0.000308	0.000177	0.000204	0.000323	0.000065	0.000135	0.000045	0.000239	0.000360	0.000316	0.000011	0.000172	0.000087	0.000227	0.000155	0.000084	0.000701	0.000213	0.003701	0.001950	0.000159	0.000054	0.000112	0.000743	0.000218	0.000039	0.004979	0.003630	0.002574	0.000682	0.000534	0.000818	0.000834	0.000142	0.000400	0.000426	0.000114	0.000240	0.000429	0.000075	0.000257	0.000234	0.000193	0.000076	0.000065	0.000063	0.000221	0.000078	0.000182	0.000093	0.000221	0.000200	0.000649	0.000315	0.000137	0.000237	0.000165	0.000159	0.000156	0.000239	0.000166	0.000187	0.000064	0.000046	0.000086	0.001337	0.000649	0.000506	0.000124	0.000263	0.000173	0.000193	0.000221	0.000429	0.000210	0.000063	0.000759	0.000179	0.000523	0.000093	0.000770	0.000494	0.000194	0.000191	0.000812	0.000107	0.000271	0.000116	0.000256	0.000702	0.000065	0.740602	0.016023	0.002625	0.003195	0.000601	0.000843	0.000634	0.000425	0.000135	0.000454	0.000343	0.000248	0.000329	0.000225	0.000407	0.003727	0.003215	0.002648	0.001692	0.001209	0.000699	0.010486	0.012737	0.000369	0.002963	0.003373	0.019283	0.004763	0.001154	0.000949	0.000377	0.002754	0.001579	0.000225	0.000571	0.000501	0.000906	0.000761	0.000239	0.000397	0.000401	0.000453	0.001969	0.002785	0.002378	0.001026	0.000140	0.002372	0.001878	0.000782	0.000714	0.000410	0.001060	0.000234	0.001785	0.000730	0.000459	0.000274	0.001982	0.001843	0.000474	0.000315	0.000471	0.000621	0.000357	0.000842	0.000234	0.000883	0.000623	0.000350	0.000037	0.000724	0.000390	0.000194	0.000219	0.000718	0.001494	0.002991	0.000333	0.038381	0.163145	0.000276	0.002061	0.001726	0.003529	0.001517	0.004249	0.002113	0.000434	0.124637	0.039662	0.005963	0.002264	0.000543	0.000832	0.013553	0.001477	0.006528	0.008097	0.004031	0.001635	0.000777	0.017592	0.008015	0.002398	0.010248	0.004704	0.019652	0.003183	0.034697	0.002432	0.001020	0.000236	0.000175	0.013121	0.000814	0.029729	0.001400	0.000402	0.009719	0.008442	0.005034	0.011077	0.002916	0.000183	0.001166	0.000788	0.000823	0.026238	0.032273	0.010509	0.004702	0.002283	0.013848	0.002606	0.000410	0.003219	0.008996	0.001067	0.003055	0.000740	0.007715	0.024712	0.012200	0.000222	0.000762	0.000093	0.000190	0.000084	0.000028	0.000034	0.000439	0.000050	0.000054	0.000050	0.000097	0.000051	0.000060	0.000046	0.000310	0.000230	0.000061	0.000135	0.003294	0.000181	0.000046	0.000113	0.000068	0.000037	0.000213	0.000890	0.001108	0.000209	0.000416	0.000063	0.000041	0.000057	0.000132	0.000125	0.000155	0.000057	0.000359	0.000039	0.000135	0.000133	0.000282	0.000290	0.000127	0.000083	0.000270	0.000055	0.000274	0.000391	0.000123	0.000134	0.000236	0.000015	0.000100	0.000090	0.000013	0.000040	0.000042	0.000045	0.000060	0.000728	0.000397	0.000261	0.000013	0.000040	0.000032	0.000023	0.000096	0.000065	0.000016	0.000076	0.000071	0.000173	0.000865	0.000518	0.000632	0.000351	0.000247	0.000264	0.000518	0.000672	0.000048	0.000070	0.000264	0.000177	0.000161	0.000052	0.000358	0.000060	0.000166	0.000128	0.000104	0.000021	0.000073	0.000033	0.000073	0.000048	0.000212	0.001000	0.000258	0.000287	0.000279	0.000108	0.000416	0.000129	0.000496	0.000418	0.003442	0.000987	0.000442	0.001429	0.000524	0.002390	0.002794	0.001339	0.000887	0.000188	0.002530	0.014501	0.007183	0.000239	0.003841	0.000179	0.000276	0.000132	0.000510	0.000857	0.000862	0.000112	0.000035	0.000148	0.000307	0.000060	0.000255	0.000252	0.000605	0.000808	0.000539	0.000144	0.000029	0.000030	0.000062	0.000009	0.000152	0.000226	0.000380	0.000789	0.000178	0.000059	0.000108	0.000628	0.000162	0.000090	0.001094	0.000068	0.000078	0.000160	0.000971	0.000007	0.000044	0.000415	0.000662	0.000150	0.000418	0.000037	0.000057	0.000482	0.001437	0.000051	0.000288	0.000090	0.000168	0.001170	0.000048	0.000039	0.000069	0.000805	0.000459	0.000605	0.000249	0.000286	0.000580	0.001177	0.000727	0.000551	0.000304	0.001020	0.000084	0.000059	0.000102	0.000139	0.000163	0.000061	0.000292	0.000097	0.000109	0.000809	0.000006	0.000059	0.000039	0.006906	0.000873	0.001256	0.000250	0.000102	0.000050	0.000513	0.000039	0.000413	0.000071	0.000767	0.000045	0.000481	0.000665	0.000762	0.016020	0.001510	0.000295	0.000173	0.007390	0.008548	0.003729	0.001281	0.003552	0.006445	0.012612	0.006719	0.001354	0.002292	0.001794	0.001565	0.007519	0.000059	0.000372	0.003777	0.000901	0.000449	0.000749	0.000101	0.000347	0.000052	0.014863	0.000138	0.001250	0.000873	0.000091
228425067 - Too Many T's - Roots - Roots	228425067	0.029379	0.000744	0.000412	0.001280	0.000142	0.000621	0.000292	0.000221	0.000498	0.000861	0.000668	0.000439	0.000087	0.000071	0.000973	0.002138	0.000505	0.000165	0.000312	0.000161	0.000228	0.000102	0.000461	0.000471	0.000533	0.000284	0.000215	0.033500	0.000364	0.000139	0.000216	0.000182	0.000872	0.000754	0.000399	0.000377	0.329263	0.000150	0.000189	0.000049	0.002101	0.000465	0.000114	0.000122	0.000221	0.000055	0.000143	0.000228	0.000206	0.000284	0.000140	0.000153	0.000032	0.000201	0.000369	0.000231	0.000012	0.001068	0.000148	0.000416	0.000269	0.000162	0.000317	0.000115	0.001508	0.000779	0.000194	0.000027	0.000076	0.000591	0.000157	0.000034	0.007322	0.005981	0.004445	0.001360	0.000787	0.001559	0.001172	0.000188	0.000587	0.001037	0.000333	0.000432	0.000190	0.000176	0.000341	0.000328	0.000276	0.000090	0.000085	0.000088	0.000025	0.000183	0.000342	0.000151	0.000246	0.000233	0.001302	0.000376	0.000180	0.000232	0.000689	0.000599	0.000226	0.000343	0.000355	0.000394	0.000078	0.000056	0.000078	0.001860	0.000734	0.000613	0.000043	0.000213	0.000151	0.000386	0.000438	0.000477	0.000168	0.000056	0.001213	0.000207	0.000166	0.000161	0.000651	0.000163	0.000371	0.000365	0.000587	0.000158	0.000749	0.000258	0.000135	0.000269	0.000051	0.791664	0.007586	0.001501	0.001895	0.000551	0.000625	0.000364	0.000080	0.000074	0.000364	0.000100	0.000151	0.000063	0.000044	0.000100	0.001161	0.001151	0.000742	0.000294	0.000199	0.000128	0.002967	0.032445	0.000096	0.001053	0.001709	0.003526	0.001993	0.000461	0.000416	0.000131	0.001132	0.000628	0.000125	0.000232	0.000191	0.000103	0.000035	0.000057	0.000059	0.000184	0.000050	0.000365	0.000540	0.000459	0.000174	0.000056	0.000868	0.001193	0.000332	0.000647	0.000342	0.000405	0.000053	0.000695	0.000141	0.000190	0.000109	0.001427	0.000972	0.000228	0.000215	0.000075	0.000141	0.000081	0.000147	0.000045	0.000233	0.000197	0.000130	0.000017	0.000234	0.000109	0.000058	0.000049	0.000893	0.000967	0.000310	0.001260	0.043164	0.264232	0.000317	0.003098	0.002877	0.013654	0.002485	0.008161	0.009042	0.000540	0.038540	0.007314	0.013067	0.000713	0.000778	0.000225	0.030933	0.000436	0.004614	0.012037	0.007082	0.000804	0.000154	0.016235	0.003533	0.001726	0.009812	0.004688	0.008688	0.001251	0.001828	0.000877	0.000568	0.000159	0.000074	0.009802	0.000368	0.002199	0.000957	0.000103	0.002088	0.001304	0.000675	0.001011	0.002358	0.000202	0.000153	0.003248	0.000118	0.025780	0.016046	0.004769	0.005144	0.001226	0.014510	0.000212	0.000398	0.000585	0.017479	0.000071	0.001953	0.002182	0.000459	0.002740	0.038134	0.000815	0.000144	0.000237	0.000146	0.000201	0.000035	0.000047	0.000240	0.000047	0.000048	0.000036	0.000115	0.000031	0.000088	0.000076	0.000097	0.000247	0.000096	0.000140	0.004206	0.000409	0.000064	0.000259	0.000152	0.000048	0.000207	0.000858	0.000612	0.000099	0.000209	0.000029	0.000070	0.000058	0.000173	0.000138	0.000128	0.000027	0.000203	0.000017	0.000112	0.000068	0.000376	0.000433	0.000138	0.000116	0.000359	0.000031	0.000130	0.000173	0.000069	0.000075	0.000111	0.000002	0.000029	0.000158	0.000024	0.000041	0.000033	0.000081	0.000102	0.000795	0.007336	0.000135	0.000006	0.000028	0.000022	0.000019	0.000055	0.000027	0.000005	0.000017	0.000029	0.000140	0.000316	0.000143	0.000267	0.000074	0.000293	0.000126	0.000295	0.000241	0.000011	0.000017	0.000055	0.000024	0.000210	0.000029	0.000069	0.000013	0.000054	0.000040	0.000058	0.000017	0.000019	0.000011	0.000032	0.000054	0.000251	0.000135	0.000032	0.000077	0.000129	0.000061	0.000186	0.000014	0.000232	0.000216	0.003487	0.001699	0.000470	0.001500	0.000909	0.005969	0.003874	0.000426	0.001893	0.000685	0.001610	0.007179	0.005963	0.000198	0.006202	0.000095	0.000045	0.000017	0.000261	0.000445	0.000414	0.000013	0.000004	0.000009	0.000060	0.000010	0.000020	0.000030	0.000164	0.000325	0.000131	0.000020	0.000003	0.000014	0.000008	0.000002	0.000047	0.000051	0.000499	0.000238	0.000047	0.000029	0.000143	0.000149	0.001134	0.000443	0.002122	0.000109	0.000063	0.000072	0.001126	0.000006	0.000010	0.000075	0.000092	0.000029	0.000217	0.000076	0.000094	0.000285	0.000479	0.000030	0.000343	0.000043	0.000053	0.000296	0.000010	0.000009	0.000024	0.001040	0.000502	0.000430	0.000100	0.000229	0.000247	0.000719	0.000255	0.000617	0.001071	0.001858	0.000057	0.000026	0.000046	0.000162	0.000081	0.000079	0.000684	0.000138	0.000036	0.002171	0.000008	0.000068	0.000101	0.005300	0.000165	0.000254	0.000064	0.000031	0.000017	0.000570	0.000020	0.000307	0.000051	0.000868	0.000023	0.000224	0.001017	0.000198	0.002713	0.000176	0.000319	0.000114	0.007615	0.008416	0.000644	0.001651	0.004489	0.000700	0.006491	0.002076	0.000446	0.002239	0.001811	0.000562	0.002401	0.000175	0.000326	0.003607	0.000227	0.000372	0.001464	0.000178	0.000381	0.000038	0.002822	0.000092	0.000466	0.000823	0.000048
214051088 - Benny The Butcher - Johnny P's Caddy - Johnny P's Caddy	214051088	0.048511	0.001255	0.000416	0.001841	0.000140	0.000949	0.000648	0.000282	0.000317	0.000360	0.000347	0.000131	0.000045	0.000034	0.000591	0.000631	0.001005	0.000510	0.000569	0.000190	0.000633	0.000162	0.001298	0.001472	0.001690	0.000663	0.000257	0.040955	0.000704	0.000257	0.000177	0.000228	0.001777	0.001175	0.000635	0.000517	0.361521	0.000692	0.000428	0.000060	0.002539	0.000396	0.000135	0.000059	0.000789	0.000029	0.000150	0.000517	0.000543	0.000395	0.000036	0.000073	0.000037	0.000074	0.000151	0.000073	0.000015	0.000105	0.000299	0.000355	0.000230	0.000107	0.000337	0.000118	0.000573	0.000331	0.000067	0.000017	0.000061	0.000250	0.000076	0.000047	0.005188	0.004890	0.003479	0.001130	0.000698	0.001917	0.000801	0.000208	0.000587	0.000734	0.000108	0.000484	0.000099	0.000175	0.000247	0.000167	0.000122	0.000117	0.000044	0.000040	0.000085	0.000125	0.000257	0.000139	0.000233	0.000244	0.000657	0.000408	0.000194	0.000251	0.000216	0.000199	0.000101	0.000173	0.000148	0.000169	0.000075	0.000054	0.000067	0.001509	0.000678	0.000741	0.000085	0.000165	0.000123	0.000176	0.000220	0.000918	0.000200	0.000042	0.001188	0.000099	0.000107	0.000046	0.000442	0.000236	0.000249	0.000144	0.000143	0.000039	0.000396	0.000227	0.000054	0.000219	0.000027	0.843640	0.021254	0.005512	0.006317	0.001686	0.001154	0.000933	0.000963	0.000385	0.001071	0.000272	0.000228	0.000348	0.000130	0.000523	0.002276	0.002218	0.001303	0.001339	0.000957	0.000652	0.003063	0.015561	0.000146	0.001174	0.001331	0.002152	0.001826	0.000412	0.000338	0.000082	0.000823	0.000213	0.000102	0.000224	0.000200	0.000099	0.000071	0.000093	0.000050	0.000138	0.000181	0.000978	0.001383	0.001138	0.000478	0.000061	0.001369	0.001478	0.000345	0.000871	0.000277	0.001253	0.000178	0.002638	0.000447	0.000347	0.000154	0.004046	0.003229	0.000707	0.000726	0.000452	0.000224	0.000096	0.000204	0.000053	0.000136	0.000555	0.000271	0.000020	0.000902	0.000300	0.000237	0.000044	0.000971	0.003384	0.000574	0.000636	0.024548	0.319267	0.000297	0.002423	0.002878	0.007383	0.001761	0.010265	0.004543	0.000746	0.037841	0.018264	0.001825	0.001939	0.000418	0.000714	0.021921	0.000803	0.004342	0.012340	0.002748	0.001564	0.000721	0.003921	0.002040	0.000768	0.001389	0.000293	0.005350	0.000262	0.002490	0.000357	0.000278	0.000074	0.000092	0.016115	0.000417	0.005657	0.001211	0.000235	0.000448	0.000211	0.001316	0.003568	0.000395	0.000228	0.000149	0.001559	0.000302	0.046503	0.019786	0.006617	0.002698	0.000606	0.016359	0.000839	0.000395	0.001274	0.008376	0.000255	0.001683	0.001957	0.002220	0.009682	0.021050	0.000188	0.000130	0.000074	0.000067	0.000070	0.000012	0.000016	0.000136	0.000022	0.000022	0.000019	0.000037	0.000010	0.000029	0.000022	0.000055	0.000099	0.000026	0.000052	0.001378	0.000135	0.000027	0.000073	0.000056	0.000015	0.000102	0.000293	0.000396	0.000081	0.000279	0.000009	0.000016	0.000013	0.000042	0.000035	0.000075	0.000009	0.000118	0.000015	0.000190	0.000033	0.000331	0.000310	0.000185	0.000080	0.000170	0.000022	0.000086	0.000113	0.000048	0.000050	0.000079	0.000002	0.000015	0.000046	0.000008	0.000010	0.000015	0.000026	0.000030	0.000265	0.000400	0.000079	0.000005	0.000013	0.000023	0.000019	0.000031	0.000017	0.000004	0.000011	0.000024	0.000063	0.000200	0.000573	0.000521	0.000047	0.000105	0.000080	0.000227	0.000338	0.000004	0.000012	0.000089	0.000054	0.000139	0.000011	0.000058	0.000013	0.000048	0.000034	0.000089	0.000005	0.000017	0.000015	0.000024	0.000015	0.000104	0.000184	0.000046	0.000064	0.000061	0.000045	0.000196	0.000024	0.000258	0.000123	0.005363	0.001677	0.000727	0.001413	0.000863	0.003142	0.001972	0.000930	0.001110	0.000223	0.001866	0.007712	0.011709	0.000045	0.007864	0.000072	0.000058	0.000029	0.000257	0.000231	0.000277	0.000026	0.000007	0.000011	0.000038	0.000008	0.000045	0.000027	0.000099	0.000208	0.000103	0.000017	0.000005	0.000008	0.000012	0.000003	0.000041	0.000045	0.000145	0.000138	0.000029	0.000014	0.000033	0.000109	0.000170	0.000080	0.000667	0.000036	0.000029	0.000044	0.000579	0.000002	0.000013	0.000092	0.000149	0.000056	0.000096	0.000025	0.000018	0.000137	0.000412	0.000017	0.000146	0.000019	0.000033	0.000105	0.000008	0.000007	0.000011	0.000778	0.000127	0.000197	0.000099	0.000324	0.000570	0.003617	0.001552	0.000284	0.000382	0.001097	0.000037	0.000017	0.000055	0.000124	0.000014	0.000033	0.000308	0.000094	0.000034	0.000973	0.000008	0.000077	0.000110	0.003632	0.000277	0.000272	0.000041	0.000031	0.000011	0.000267	0.000012	0.000174	0.000019	0.000565	0.000019	0.000075	0.000467	0.000363	0.000798	0.000024	0.000263	0.000074	0.004129	0.001425	0.001328	0.000417	0.002971	0.000294	0.011909	0.002169	0.000310	0.001180	0.001291	0.001366	0.004181	0.000051	0.000209	0.000746	0.000101	0.001576	0.000492	0.000099	0.000076	0.000014	0.000981	0.000049	0.000324	0.000799	0.000038
59980794 - Axwell, Ingrosso, Steve Angello and Laidback Luke feat. Deborah Cox - Leave The World Behind - Leave The World Behind (Radio Edit)	59980794	0.035081	0.000533	0.000698	0.000768	0.000122	0.000385	0.000294	0.000047	0.000352	0.000424	0.000801	0.000193	0.000023	0.000060	0.000813	0.000424	0.000362	0.000128	0.000220	0.000132	0.000089	0.000185	0.000393	0.000421	0.000528	0.000158	0.000334	0.059249	0.000374	0.000907	0.000033	0.000068	0.001554	0.004226	0.000561	0.000360	0.000443	0.000631	0.000138	0.000015	0.000842	0.000348	0.000102	0.000168	0.000251	0.000041	0.000281	0.000197	0.000243	0.000180	0.000064	0.000071	0.000483	0.000091	0.000292	0.000194	0.000014	0.000208	0.000078	0.000193	0.000093	0.000117	0.000084	0.000155	0.000533	0.000414	0.000196	0.000024	0.000062	0.000818	0.000143	0.000033	0.002918	0.002066	0.001357	0.000340	0.000293	0.000492	0.000325	0.000078	0.000330	0.000618	0.000184	0.000350	0.000237	0.000167	0.000234	0.000217	0.000167	0.000081	0.000066	0.000067	0.000053	0.000039	0.000096	0.000120	0.000229	0.000214	0.000708	0.000422	0.000225	0.000269	0.000122	0.000114	0.000100	0.000089	0.000228	0.000233	0.000066	0.000043	0.000048	0.001104	0.000408	0.000324	0.000036	0.000215	0.000144	0.000268	0.000256	0.000353	0.000113	0.000011	0.000411	0.000097	0.000148	0.000069	0.000465	0.000117	0.000252	0.000222	0.007564	0.000103	0.000154	0.000058	0.000093	0.000427	0.000042	0.789666	0.018172	0.002237	0.002468	0.000449	0.000438	0.000387	0.000253	0.000184	0.000328	0.000349	0.000370	0.000172	0.000192	0.000333	0.002965	0.003367	0.001697	0.000943	0.000468	0.000440	0.004945	0.004804	0.000537	0.001810	0.002454	0.002035	0.003204	0.000786	0.000522	0.000190	0.001328	0.000231	0.000134	0.000647	0.000553	0.000127	0.000040	0.000041	0.000081	0.000151	0.000153	0.000592	0.000895	0.000768	0.000384	0.000045	0.001476	0.001869	0.000442	0.001230	0.000686	0.001085	0.000124	0.001073	0.000526	0.000482	0.000299	0.003649	0.001528	0.000713	0.000629	0.000278	0.000603	0.000329	0.000718	0.000163	0.000776	0.000721	0.000476	0.000095	0.000580	0.000512	0.000877	0.000048	0.000540	0.000498	0.000853	0.000235	0.115005	0.004902	0.000038	0.001146	0.000481	0.000623	0.000601	0.001145	0.001152	0.000096	0.028584	0.002863	0.000882	0.000961	0.001117	0.000575	0.011128	0.000620	0.002564	0.009055	0.048273	0.002127	0.001684	0.151285	0.276200	0.019227	0.063024	0.011673	0.045660	0.439946	0.001077	0.038093	0.000701	0.000196	0.000051	0.006049	0.000482	0.002334	0.000328	0.000130	0.000774	0.001223	0.001492	0.002086	0.014710	0.000442	0.000076	0.000962	0.000486	0.006399	0.035737	0.003304	0.001823	0.001170	0.011744	0.001031	0.000211	0.001714	0.238559	0.000636	0.006529	0.001177	0.000583	0.003531	0.032644	0.000012	0.000074	0.000102	0.000125	0.000093	0.000018	0.000023	0.000243	0.000020	0.000023	0.000016	0.000055	0.000019	0.000041	0.000032	0.000101	0.000137	0.000040	0.000079	0.001980	0.000138	0.000026	0.000103	0.000064	0.000028	0.000162	0.000424	0.000511	0.000059	0.000157	0.000011	0.000017	0.000028	0.000091	0.000045	0.000179	0.000019	0.000520	0.000014	0.000131	0.000053	0.001099	0.000881	0.000466	0.000326	0.000139	0.000035	0.000121	0.000176	0.000041	0.000046	0.000109	0.000003	0.000022	0.000095	0.000015	0.000050	0.000027	0.000051	0.000053	0.000080	0.000036	0.000184	0.000009	0.000038	0.000018	0.000012	0.000066	0.000042	0.000007	0.000023	0.000039	0.000135	0.000211	0.000141	0.000352	0.000106	0.000110	0.000084	0.000187	0.000033	0.000009	0.000036	0.000109	0.000068	0.000017	0.000035	0.000087	0.000016	0.000059	0.000063	0.000043	0.000045	0.000044	0.000033	0.000065	0.000039	0.000135	0.000084	0.000024	0.000118	0.000257	0.000016	0.000137	0.000010	0.000171	0.000541	0.000943	0.000569	0.000297	0.001177	0.000167	0.000710	0.001042	0.000279	0.004021	0.001471	0.000714	0.001618	0.002156	0.000160	0.001451	0.000074	0.000056	0.000019	0.000355	0.000425	0.000508	0.000021	0.000014	0.000016	0.000074	0.000017	0.000035	0.000049	0.000087	0.000240	0.000106	0.000018	0.000002	0.000012	0.000025	0.000002	0.000036	0.000046	0.000245	0.000104	0.000018	0.000009	0.000032	0.000069	0.000202	0.000069	0.002030	0.000052	0.000007	0.000078	0.000085	0.000002	0.000014	0.000114	0.000095	0.000044	0.000240	0.000022	0.000052	0.000663	0.000997	0.000022	0.000157	0.000011	0.000068	0.000241	0.000015	0.000042	0.000026	0.000645	0.000137	0.000386	0.000044	0.000078	0.000441	0.000828	0.000208	0.000116	0.000241	0.000144	0.000020	0.000015	0.000023	0.000159	0.000060	0.000101	0.000027	0.000057	0.000045	0.000891	0.000007	0.000026	0.000026	0.001261	0.000669	0.000430	0.000073	0.000012	0.000008	0.000593	0.000023	0.000255	0.000085	0.000775	0.000017	0.000051	0.000419	0.000367	0.000786	0.006205	0.000317	0.000139	0.004249	0.006776	0.000649	0.001588	0.003949	0.000932	0.006750	0.002875	0.000614	0.001084	0.001282	0.000925	0.004931	0.000043	0.000217	0.000517	0.000138	0.000449	0.000124	0.000134	0.000299	0.000043	0.000685	0.000189	0.000473	0.000250	0.000112
215721863 - Hermitude - HyperParadise - Get In My Life	215721863	0.056046	0.000561	0.000622	0.001871	0.000142	0.000499	0.000124	0.000127	0.000383	0.000340	0.000368	0.000168	0.000072	0.000058	0.000456	0.000382	0.000296	0.000070	0.000137	0.000108	0.000116	0.000098	0.000223	0.000322	0.000421	0.000116	0.000192	0.018403	0.000312	0.000403	0.000118	0.000119	0.000561	0.000814	0.000536	0.000801	0.049885	0.000222	0.000184	0.000029	0.001127	0.000314	0.000070	0.000078	0.000150	0.000053	0.000195	0.000119	0.000119	0.000178	0.000163	0.000167	0.000117	0.000312	0.000378	0.000215	0.000046	0.000465	0.000120	0.000147	0.000212	0.000275	0.000087	0.000219	0.000986	0.001139	0.000191	0.000059	0.000088	0.000694	0.000212	0.000097	0.002331	0.001639	0.001222	0.000272	0.000324	0.000572	0.000461	0.000089	0.000293	0.000470	0.000129	0.000309	0.000323	0.000083	0.000252	0.000277	0.000237	0.000073	0.000069	0.000064	0.000033	0.000120	0.000303	0.000110	0.000232	0.000195	0.000456	0.000336	0.000158	0.000227	0.000142	0.000130	0.000089	0.000159	0.000073	0.000077	0.000042	0.000032	0.000103	0.000872	0.000375	0.000272	0.000011	0.000196	0.000172	0.000077	0.000082	0.000421	0.000162	0.000023	0.000286	0.000259	0.000523	0.000186	0.000619	0.000139	0.000157	0.000262	0.000964	0.000153	0.000190	0.000064	0.000137	0.000643	0.000160	0.790306	0.048308	0.002200	0.003081	0.000618	0.000868	0.000430	0.000098	0.000121	0.000418	0.000125	0.000161	0.000124	0.000085	0.000175	0.007680	0.005376	0.004813	0.000438	0.000366	0.000192	0.054317	0.116594	0.000171	0.002920	0.007416	0.088412	0.009803	0.002183	0.001781	0.000570	0.004862	0.000801	0.000129	0.000836	0.000724	0.000193	0.000087	0.000168	0.000091	0.000381	0.000054	0.000504	0.000713	0.000648	0.000177	0.000064	0.000941	0.002615	0.000541	0.001515	0.000712	0.000626	0.000061	0.001266	0.000294	0.000150	0.000132	0.006258	0.004393	0.000678	0.000748	0.000123	0.000131	0.000065	0.000120	0.000056	0.000081	0.000262	0.000149	0.000022	0.002168	0.000599	0.000273	0.000673	0.000718	0.004247	0.000184	0.007371	0.024045	0.196661	0.000826	0.004368	0.002097	0.003956	0.001081	0.003518	0.003270	0.000506	0.013587	0.002324	0.007331	0.000502	0.001432	0.000168	0.014370	0.000480	0.001204	0.005729	0.006905	0.000914	0.000161	0.113078	0.009402	0.008074	0.039063	0.022882	0.016240	0.006388	0.002883	0.002488	0.000839	0.000138	0.000067	0.003425	0.001037	0.000457	0.000988	0.000102	0.001415	0.001599	0.000431	0.000428	0.002312	0.000224	0.000250	0.001056	0.000246	0.005352	0.006599	0.002013	0.002443	0.000905	0.006869	0.000199	0.000662	0.000410	0.007807	0.000050	0.000918	0.002803	0.000121	0.000927	0.009457	0.000267	0.000105	0.000293	0.000188	0.000284	0.000090	0.000113	0.000395	0.000100	0.000087	0.000075	0.000160	0.000060	0.000132	0.000108	0.000212	0.000407	0.000126	0.000356	0.004490	0.000459	0.000118	0.000239	0.000157	0.000064	0.000276	0.001054	0.000723	0.000322	0.000197	0.000039	0.000074	0.000076	0.000153	0.000209	0.000223	0.000100	0.000321	0.000048	0.000176	0.000142	0.000391	0.000274	0.000190	0.000106	0.000456	0.000076	0.000367	0.000525	0.000128	0.000203	0.000304	0.000018	0.000125	0.000237	0.000042	0.000093	0.000053	0.000077	0.000174	0.001403	0.003091	0.000311	0.000021	0.000039	0.000061	0.000047	0.000104	0.000068	0.000016	0.000064	0.000073	0.000180	0.000603	0.000100	0.000365	0.000236	0.000248	0.000153	0.000460	0.000135	0.000032	0.000107	0.000221	0.000134	0.000107	0.000081	0.000193	0.000076	0.000157	0.000119	0.000097	0.000099	0.000076	0.000012	0.000088	0.000123	0.000322	0.000545	0.000146	0.000386	0.000731	0.000134	0.000571	0.000122	0.000657	0.000264	0.000615	0.000822	0.000332	0.002931	0.000442	0.002046	0.001945	0.000665	0.000912	0.000199	0.000644	0.000838	0.000436	0.000173	0.002836	0.000195	0.000418	0.000161	0.000387	0.000994	0.000836	0.000136	0.000032	0.000144	0.000233	0.000054	0.000108	0.000194	0.000405	0.000611	0.000554	0.000051	0.000008	0.000063	0.000072	0.000028	0.000194	0.000214	0.000360	0.000331	0.000089	0.000066	0.000073	0.000316	0.000335	0.000207	0.001513	0.000115	0.000101	0.000227	0.000840	0.000019	0.000028	0.000179	0.000220	0.000053	0.000446	0.000098	0.000107	0.000528	0.000924	0.000057	0.000313	0.000139	0.000158	0.000822	0.000062	0.000040	0.000095	0.001605	0.000399	0.000903	0.000253	0.000180	0.000497	0.003398	0.000795	0.000766	0.000245	0.000496	0.000085	0.000060	0.000045	0.000229	0.000128	0.000176	0.002543	0.000374	0.000180	0.001623	0.000022	0.000190	0.000137	0.004616	0.000292	0.000241	0.000060	0.000036	0.000099	0.000920	0.000038	0.000690	0.000116	0.000799	0.000077	0.000230	0.000557	0.000292	0.011359	0.001100	0.000487	0.000214	0.005543	0.007976	0.001127	0.002889	0.010879	0.000998	0.011980	0.003891	0.000997	0.002624	0.001808	0.001371	0.004155	0.001460	0.000132	0.010593	0.001086	0.001340	0.007960	0.001596	0.001061	0.000098	0.010164	0.000278	0.000404	0.001609	0.000105
36594193 - ODESZA - Say My Name Remixes - Say My Name (feat. Zyra) (Jai Wolf Remix)	36594193	0.046476	0.000556	0.000568	0.003558	0.000115	0.000566	0.000268	0.000149	0.000549	0.000231	0.000424	0.000131	0.000238	0.000155	0.000792	0.000497	0.000390	0.000166	0.000172	0.000148	0.000135	0.000177	0.000553	0.000643	0.000557	0.000137	0.000173	0.038960	0.000515	0.000309	0.000075	0.000176	0.001177	0.005075	0.002139	0.002664	0.009865	0.000231	0.000166	0.000031	0.000320	0.000278	0.000024	0.000088	0.000173	0.000098	0.000146	0.000185	0.000098	0.000217	0.000117	0.000151	0.000228	0.000228	0.000405	0.000214	0.000021	0.000155	0.000098	0.000259	0.000234	0.000434	0.000223	0.000873	0.002773	0.003265	0.000362	0.000294	0.000117	0.001149	0.000176	0.000256	0.003850	0.002321	0.001665	0.000287	0.000284	0.000458	0.000378	0.000077	0.000325	0.000431	0.000088	0.000310	0.000692	0.000080	0.000267	0.000239	0.000222	0.000045	0.000066	0.000059	0.000183	0.000217	0.000346	0.000185	0.000291	0.000271	0.000585	0.000295	0.000136	0.000171	0.000199	0.000159	0.000182	0.000274	0.000124	0.000128	0.000061	0.000041	0.000115	0.001224	0.000572	0.000529	0.000022	0.000130	0.000083	0.000080	0.000088	0.000274	0.000050	0.000024	0.000334	0.000375	0.000745	0.000155	0.000959	0.000470	0.000354	0.000395	0.001849	0.000154	0.000460	0.000129	0.000163	0.001092	0.000035	0.762593	0.027870	0.002699	0.003051	0.000768	0.000761	0.000556	0.000242	0.000175	0.000522	0.000308	0.000616	0.000235	0.000245	0.000219	0.004327	0.003742	0.002326	0.000683	0.000380	0.000275	0.022478	0.034767	0.000303	0.002928	0.005200	0.070118	0.007330	0.001311	0.001192	0.000349	0.003540	0.000248	0.000319	0.000710	0.000627	0.000786	0.000510	0.000231	0.000161	0.000099	0.000292	0.001456	0.002301	0.001978	0.000325	0.000114	0.001057	0.001374	0.000272	0.000818	0.000322	0.001389	0.000162	0.002449	0.000768	0.000381	0.000257	0.002012	0.001115	0.001059	0.000465	0.000348	0.000600	0.000264	0.000562	0.000427	0.000184	0.000592	0.000490	0.000092	0.001063	0.000426	0.000919	0.000198	0.000472	0.000858	0.000274	0.001408	0.052679	0.084115	0.000257	0.002000	0.001734	0.002967	0.000979	0.002766	0.001618	0.000262	0.105998	0.008781	0.002813	0.000954	0.000542	0.000562	0.007027	0.000950	0.003897	0.009079	0.006480	0.001280	0.000413	0.087483	0.028870	0.010857	0.046188	0.014038	0.038219	0.030322	0.004481	0.007725	0.000820	0.000225	0.000114	0.009051	0.002201	0.003309	0.000618	0.000187	0.003835	0.008608	0.001320	0.002622	0.004081	0.000382	0.000728	0.000361	0.000847	0.005631	0.014291	0.005221	0.004341	0.001296	0.013310	0.002057	0.000592	0.001090	0.019411	0.000438	0.004112	0.001495	0.002121	0.010662	0.014029	0.000166	0.000149	0.000171	0.000266	0.000150	0.000114	0.000126	0.001625	0.000354	0.000474	0.000270	0.000554	0.000275	0.000163	0.000129	0.000652	0.000550	0.000119	0.000251	0.003782	0.000329	0.000082	0.000216	0.000107	0.000040	0.000328	0.001113	0.000992	0.000207	0.000386	0.000039	0.000055	0.000110	0.000144	0.000201	0.000254	0.000083	0.000441	0.000029	0.000179	0.000137	0.000603	0.000395	0.000306	0.000169	0.000309	0.000073	0.000464	0.000573	0.000207	0.000283	0.000393	0.000021	0.000062	0.000247	0.000043	0.000113	0.000089	0.000123	0.000159	0.000606	0.000451	0.000524	0.000021	0.000062	0.000075	0.000070	0.000180	0.000107	0.000040	0.000124	0.000122	0.000245	0.000426	0.000141	0.000468	0.000182	0.000290	0.000495	0.000825	0.000418	0.000017	0.000060	0.000253	0.000194	0.000124	0.000307	0.000090	0.000176	0.000561	0.000347	0.000440	0.000096	0.000351	0.000062	0.000145	0.000151	0.000310	0.000572	0.000278	0.000441	0.000957	0.000054	0.000189	0.000131	0.000258	0.000409	0.001464	0.000822	0.000365	0.008808	0.000449	0.001672	0.000981	0.000673	0.001457	0.000285	0.002321	0.002766	0.001906	0.000123	0.001656	0.000439	0.000551	0.000280	0.000655	0.001727	0.001082	0.000266	0.000019	0.000067	0.000050	0.000025	0.000091	0.000107	0.000508	0.000807	0.000724	0.000183	0.000033	0.000184	0.000111	0.000044	0.000322	0.000368	0.000401	0.000465	0.000200	0.000057	0.000104	0.000348	0.000521	0.000288	0.001592	0.000075	0.000107	0.000630	0.002988	0.000057	0.000103	0.000432	0.000871	0.000258	0.001409	0.000332	0.000382	0.000696	0.007182	0.000361	0.000952	0.000354	0.000541	0.001007	0.000227	0.000251	0.000121	0.000373	0.000182	0.001141	0.000302	0.000054	0.000611	0.002168	0.000961	0.000607	0.000289	0.000499	0.000106	0.000124	0.000182	0.000256	0.000262	0.000114	0.000601	0.000189	0.000309	0.000849	0.000031	0.000072	0.000036	0.002976	0.001368	0.001494	0.000227	0.000082	0.000027	0.000680	0.000051	0.000648	0.000248	0.000400	0.000132	0.000128	0.002578	0.001197	0.016179	0.044814	0.001031	0.000186	0.011696	0.003416	0.002800	0.001362	0.009078	0.048566	0.008219	0.003647	0.000973	0.001947	0.002309	0.001742	0.006843	0.000307	0.000267	0.019376	0.002110	0.000896	0.001127	0.000603	0.001055	0.000410	0.010447	0.000287	0.000514	0.000511	0.000054
36042581 - Jill Scott - Who Is Jill Scott- - Words and Sounds, Vol. 1 - He Loves Me (Lyzel in E Flat)	36042581	0.017694	0.000166	0.000256	0.002017	0.000047	0.000150	0.000293	0.000066	0.000168	0.000068	0.000104	0.000043	0.000028	0.000033	0.000201	0.000533	0.000217	0.000138	0.000117	0.000031	0.000066	0.000039	0.000498	0.000578	0.000413	0.000100	0.000174	0.061171	0.000399	0.000157	0.000254	0.001097	0.000764	0.006269	0.001512	0.000907	0.003973	0.006505	0.000172	0.000006	0.000916	0.000352	0.000044	0.000137	0.000159	0.000040	0.000160	0.000226	0.000057	0.000279	0.000069	0.000030	0.000017	0.000118	0.000245	0.000092	0.000003	0.000233	0.000034	0.000272	0.000131	0.000077	0.000044	0.000080	0.002335	0.001224	0.000075	0.000010	0.000018	0.000214	0.000024	0.000015	0.003011	0.001953	0.001576	0.000230	0.000211	0.000679	0.000224	0.000089	0.000222	0.000359	0.000188	0.000208	0.000347	0.000046	0.000257	0.000133	0.000110	0.000026	0.000052	0.000047	0.000076	0.000080	0.000089	0.000112	0.000139	0.000131	0.000385	0.000273	0.000117	0.000217	0.000098	0.000084	0.000092	0.000128	0.000071	0.000073	0.000032	0.000021	0.000048	0.001038	0.000509	0.000455	0.000022	0.000064	0.000039	0.000102	0.000132	0.000408	0.000079	0.000013	0.000380	0.000151	0.000394	0.000043	0.001025	0.000785	0.000555	0.000287	0.000732	0.000089	0.000343	0.000102	0.000154	0.000337	0.000028	0.728665	0.015978	0.001587	0.002030	0.000399	0.000701	0.000632	0.000231	0.000092	0.000346	0.000044	0.000185	0.000112	0.000160	0.000208	0.006124	0.005964	0.005964	0.000777	0.000488	0.000263	0.031194	0.007637	0.000398	0.001068	0.001478	0.017525	0.001874	0.000502	0.000317	0.000156	0.001001	0.000534	0.000066	0.000444	0.000430	0.000188	0.000134	0.000136	0.000113	0.000196	0.000272	0.003392	0.004304	0.005486	0.000731	0.000023	0.000673	0.001306	0.000652	0.000907	0.000279	0.000865	0.000126	0.001540	0.000628	0.000514	0.000281	0.004495	0.008171	0.000657	0.000730	0.000591	0.000697	0.000154	0.000614	0.001349	0.000604	0.003077	0.001487	0.000030	0.001552	0.000215	0.000333	0.000027	0.001253	0.004130	0.001476	0.000252	0.028944	0.033501	0.000134	0.000622	0.000384	0.000998	0.000378	0.000912	0.000397	0.000144	0.123767	0.044345	0.001812	0.000368	0.000353	0.000076	0.004577	0.001404	0.004498	0.004294	0.001204	0.001364	0.000412	0.021750	0.004662	0.001641	0.007803	0.001456	0.005816	0.001928	0.017135	0.001127	0.000679	0.000101	0.000089	0.005227	0.016372	0.015505	0.001375	0.000531	0.003343	0.002798	0.008507	0.008776	0.008267	0.000621	0.001726	0.000175	0.001575	0.011836	0.013983	0.010451	0.008515	0.003156	0.019158	0.046889	0.000964	0.009863	0.002940	0.001432	0.006591	0.000923	0.021520	0.045505	0.004117	0.000018	0.000187	0.000084	0.000149	0.000076	0.000024	0.000029	0.000282	0.000051	0.000056	0.000041	0.000074	0.000035	0.000040	0.000031	0.000286	0.000129	0.000030	0.000075	0.001251	0.000122	0.000029	0.000087	0.000046	0.000016	0.000117	0.000342	0.000551	0.000068	0.000967	0.000021	0.000010	0.000019	0.000047	0.000046	0.000104	0.000020	0.000266	0.000026	0.000079	0.000042	0.000557	0.000582	0.000382	0.000148	0.000108	0.000026	0.000119	0.000161	0.000078	0.000067	0.000105	0.000005	0.000017	0.000090	0.000011	0.000039	0.000033	0.000089	0.000052	0.000261	0.000032	0.000144	0.000004	0.000083	0.000014	0.000028	0.000053	0.000026	0.000005	0.000019	0.000028	0.000095	0.000202	0.000326	0.002993	0.000074	0.000102	0.000161	0.000147	0.002662	0.000009	0.000017	0.000037	0.000033	0.000010	0.000026	0.000094	0.000015	0.000099	0.000064	0.000064	0.000009	0.000041	0.000020	0.000079	0.000024	0.000110	0.000304	0.000063	0.000172	0.000347	0.000018	0.000085	0.000028	0.000109	0.000257	0.024165	0.000977	0.001380	0.011271	0.000259	0.001976	0.002073	0.005093	0.002567	0.000533	0.013926	0.064035	0.032322	0.000130	0.005978	0.000192	0.000255	0.000170	0.000694	0.000550	0.000379	0.000116	0.000022	0.000011	0.000027	0.000007	0.000074	0.000049	0.000487	0.000480	0.000261	0.000015	0.000012	0.000027	0.000040	0.000011	0.000140	0.000157	0.000180	0.000266	0.000063	0.000026	0.000034	0.000130	0.000109	0.000082	0.000431	0.000037	0.000022	0.000103	0.000172	0.000003	0.000021	0.000381	0.000390	0.000079	0.000171	0.000027	0.000048	0.000116	0.000679	0.000022	0.000115	0.000056	0.000051	0.000507	0.000017	0.000011	0.000017	0.001488	0.000088	0.000367	0.000105	0.000130	0.002354	0.001852	0.001142	0.000074	0.000049	0.000108	0.000034	0.000026	0.000072	0.000070	0.000039	0.000048	0.000094	0.000050	0.000083	0.000218	0.000012	0.000062	0.000040	0.016981	0.000946	0.004425	0.000357	0.000115	0.000014	0.000226	0.000033	0.000214	0.000032	0.000334	0.000019	0.000154	0.000585	0.004523	0.004347	0.024180	0.000402	0.000129	0.004951	0.022325	0.002315	0.006134	0.003787	0.004103	0.010815	0.002721	0.000309	0.000722	0.001590	0.001497	0.007290	0.000263	0.000239	0.001243	0.000602	0.000679	0.000540	0.000332	0.000261	0.000033	0.003468	0.000090	0.000261	0.000219	0.000027
63589320 - ODESZA - Summer's Gone - How Did I Get Here	63589320	0.046923	0.000326	0.000656	0.006839	0.000095	0.000211	0.000893	0.000075	0.000340	0.000142	0.000249	0.000091	0.000127	0.000064	0.000689	0.000482	0.000627	0.000445	0.000534	0.000159	0.000339	0.000124	0.000740	0.000972	0.000619	0.000197	0.000285	0.016616	0.000295	0.000091	0.000065	0.000134	0.000383	0.002570	0.002576	0.002021	0.009713	0.000999	0.000644	0.000024	0.000620	0.000873	0.000072	0.000109	0.000408	0.000053	0.000315	0.000486	0.000411	0.000773	0.000129	0.000136	0.000038	0.000193	0.000665	0.000539	0.000098	0.000073	0.000118	0.000464	0.000634	0.001753	0.001372	0.000874	0.002255	0.001019	0.000142	0.000057	0.000058	0.000432	0.000052	0.000090	0.003947	0.002264	0.001194	0.000333	0.000313	0.000436	0.000384	0.000123	0.000256	0.000563	0.000065	0.000464	0.000684	0.000112	0.000467	0.000181	0.000163	0.000042	0.000111	0.000097	0.000133	0.000164	0.000375	0.000171	0.000328	0.000290	0.000771	0.000514	0.000238	0.000314	0.000149	0.000142	0.000256	0.000452	0.000172	0.000180	0.000043	0.000034	0.000109	0.001632	0.000880	0.000745	0.000065	0.000216	0.000171	0.000356	0.000487	0.000754	0.000279	0.000045	0.000381	0.000450	0.000428	0.000224	0.002339	0.001392	0.000775	0.000804	0.001574	0.000372	0.001073	0.000484	0.000275	0.001245	0.000138	0.622529	0.020922	0.001826	0.002252	0.000452	0.000659	0.000315	0.000232	0.000169	0.000264	0.000077	0.000134	0.000193	0.000319	0.000366	0.012707	0.010385	0.009099	0.004771	0.005562	0.001673	0.027075	0.010067	0.000548	0.005940	0.003508	0.015520	0.004952	0.001477	0.000977	0.000464	0.002261	0.000825	0.000146	0.000771	0.000636	0.001272	0.000191	0.000347	0.000134	0.000939	0.001212	0.025856	0.037153	0.033638	0.007927	0.000198	0.000590	0.000408	0.000250	0.000175	0.000093	0.000625	0.000093	0.000653	0.000746	0.000245	0.000224	0.001193	0.001082	0.000155	0.000132	0.000567	0.000632	0.000129	0.000513	0.000902	0.000342	0.003546	0.000917	0.000019	0.000270	0.000111	0.000062	0.000345	0.000471	0.002805	0.002593	0.002049	0.011255	0.052201	0.000481	0.001406	0.000598	0.000680	0.000539	0.000885	0.000381	0.000226	0.014969	0.003795	0.001147	0.000240	0.000116	0.000071	0.001925	0.000168	0.000508	0.001630	0.000819	0.000988	0.000116	0.060247	0.003453	0.002192	0.025194	0.007531	0.010470	0.002277	0.061708	0.002140	0.000198	0.000053	0.000067	0.002085	0.003850	0.007440	0.000469	0.000078	0.000814	0.000674	0.001087	0.000569	0.002593	0.000086	0.000111	0.000089	0.000215	0.005708	0.003476	0.004927	0.002349	0.001474	0.005523	0.004915	0.000488	0.001091	0.001600	0.000154	0.000884	0.000356	0.000871	0.005382	0.002108	0.000190	0.000367	0.000129	0.000282	0.000117	0.000050	0.000059	0.001255	0.000092	0.000137	0.000097	0.000205	0.000071	0.000069	0.000057	0.000523	0.000485	0.000071	0.000400	0.004129	0.000281	0.000056	0.000220	0.000107	0.000025	0.000246	0.001059	0.002254	0.000202	0.000657	0.000085	0.000075	0.000134	0.000162	0.000268	0.000182	0.000062	0.000674	0.000035	0.000730	0.000084	0.000354	0.000292	0.000200	0.000113	0.000275	0.000043	0.000313	0.000455	0.000206	0.000212	0.000262	0.000010	0.000103	0.000217	0.000037	0.000057	0.000071	0.000070	0.000164	0.002991	0.002891	0.000339	0.000009	0.000025	0.000035	0.000058	0.000122	0.000072	0.000024	0.000071	0.000078	0.000207	0.000600	0.000692	0.004013	0.000173	0.000215	0.000260	0.000779	0.000320	0.000036	0.000073	0.000326	0.000180	0.000096	0.000121	0.000228	0.000124	0.000491	0.000347	0.000508	0.000037	0.000230	0.000083	0.000160	0.000081	0.000282	0.000423	0.000229	0.000668	0.001010	0.000185	0.000388	0.000474	0.000581	0.000241	0.006627	0.003809	0.001954	0.010037	0.002992	0.004255	0.007863	0.007405	0.001791	0.000422	0.004625	0.006924	0.007121	0.000163	0.001144	0.000315	0.001158	0.000812	0.002507	0.001948	0.001847	0.000706	0.000103	0.000221	0.000310	0.000031	0.000333	0.000322	0.005427	0.006136	0.000958	0.000147	0.000028	0.000055	0.000093	0.000031	0.000317	0.000440	0.000263	0.001436	0.000263	0.000085	0.000059	0.002644	0.000148	0.000128	0.000736	0.000072	0.000101	0.000415	0.000790	0.000077	0.000175	0.000274	0.000620	0.000225	0.000752	0.000117	0.000209	0.001129	0.002537	0.000067	0.000276	0.000175	0.000291	0.002707	0.000102	0.000063	0.000076	0.003413	0.000742	0.000617	0.000290	0.000433	0.000871	0.002205	0.001239	0.000401	0.000131	0.001497	0.000233	0.000098	0.000171	0.000146	0.000368	0.000114	0.002132	0.000255	0.000205	0.000333	0.000077	0.000228	0.000109	0.007936	0.000861	0.001856	0.000272	0.000095	0.000082	0.000619	0.000120	0.000597	0.000138	0.000359	0.000050	0.000193	0.001183	0.001756	0.018695	0.003054	0.000805	0.000620	0.013076	0.008582	0.002963	0.002993	0.004843	0.001650	0.029671	0.007705	0.001376	0.003466	0.003219	0.001985	0.006097	0.000301	0.000297	0.006327	0.001915	0.000728	0.004226	0.000453	0.000907	0.000078	0.018416	0.000192	0.000727	0.001459	0.000051
84751053 - Superorganism - Superorganism - It’s All Good	84751053	0.292966	0.001982	0.001133	0.004105	0.000393	0.001148	0.000363	0.000394	0.001966	0.001819	0.002447	0.001265	0.000365	0.000420	0.002017	0.002319	0.000620	0.000173	0.000636	0.000326	0.000254	0.000298	0.000687	0.000977	0.001008	0.001014	0.001074	0.048342	0.001860	0.000266	0.000659	0.000552	0.004287	0.002864	0.001295	0.001752	0.049927	0.000394	0.001524	0.000122	0.001933	0.000834	0.000109	0.000122	0.000513	0.000105	0.000258	0.000449	0.000771	0.000621	0.000323	0.000405	0.000089	0.000686	0.001518	0.000972	0.000074	0.000433	0.000361	0.000693	0.000992	0.000492	0.000490	0.000324	0.005665	0.002690	0.001002	0.000313	0.000096	0.001965	0.000418	0.000153	0.007916	0.006151	0.004036	0.000983	0.001207	0.000853	0.001756	0.000497	0.000972	0.001245	0.000202	0.001053	0.000511	0.000297	0.000430	0.000550	0.000397	0.000230	0.000153	0.000159	0.000054	0.000219	0.000701	0.000307	0.001436	0.001087	0.000953	0.000512	0.000308	0.000229	0.000277	0.000224	0.000472	0.000920	0.000212	0.000220	0.000063	0.000053	0.000330	0.001991	0.001064	0.001124	0.000098	0.000215	0.000177	0.000211	0.000225	0.000541	0.000084	0.000066	0.001190	0.000871	0.001847	0.000336	0.002393	0.000470	0.001215	0.001443	0.004175	0.000651	0.002003	0.000860	0.000243	0.001558	0.000048	0.765799	0.010376	0.002360	0.003305	0.000623	0.001398	0.000452	0.000198	0.000098	0.000413	0.000124	0.000051	0.000139	0.000089	0.000334	0.001056	0.000931	0.000814	0.000353	0.000262	0.000189	0.003023	0.020758	0.000050	0.001381	0.002235	0.011472	0.002622	0.000792	0.000680	0.000262	0.001569	0.000273	0.000079	0.000342	0.000301	0.000243	0.000467	0.000481	0.000230	0.000207	0.000085	0.000673	0.000794	0.000849	0.000102	0.000030	0.000681	0.000545	0.000110	0.000314	0.000189	0.000524	0.000083	0.000739	0.000230	0.000171	0.000138	0.001501	0.000681	0.000165	0.000197	0.000107	0.000687	0.000175	0.002559	0.002173	0.000402	0.000680	0.000557	0.000027	0.000629	0.000377	0.000152	0.000266	0.000429	0.001032	0.000212	0.001972	0.043455	0.111393	0.000770	0.011741	0.004381	0.009504	0.011804	0.007905	0.005440	0.002366	0.027259	0.006625	0.006280	0.001357	0.000976	0.000373	0.020928	0.000549	0.000910	0.002910	0.005757	0.000451	0.000183	0.014499	0.003388	0.001778	0.005132	0.001631	0.003773	0.001954	0.000836	0.000728	0.000556	0.000089	0.000074	0.004484	0.004110	0.000660	0.002062	0.000615	0.000824	0.000554	0.003356	0.001853	0.007363	0.000133	0.000218	0.001148	0.000284	0.022269	0.012866	0.002739	0.002860	0.013221	0.005519	0.000434	0.000213	0.002899	0.007434	0.000127	0.003197	0.002813	0.000220	0.001744	0.015105	0.001555	0.000172	0.000486	0.000688	0.000470	0.000088	0.000097	0.002517	0.000247	0.000279	0.000267	0.000758	0.000330	0.000259	0.000247	0.000429	0.001165	0.000246	0.000940	0.010338	0.001036	0.000213	0.000676	0.000355	0.000092	0.000779	0.002756	0.001639	0.000420	0.001935	0.000354	0.000150	0.000277	0.000601	0.000418	0.000420	0.000208	0.000605	0.000078	0.000217	0.000308	0.001505	0.001558	0.000687	0.000324	0.000880	0.000140	0.000422	0.000614	0.000244	0.000317	0.000373	0.000029	0.000115	0.000351	0.000058	0.000226	0.000154	0.000228	0.000196	0.006993	0.012387	0.000621	0.000021	0.000171	0.000138	0.000208	0.000208	0.000138	0.000038	0.000169	0.000168	0.000347	0.001608	0.000581	0.000857	0.000617	0.000890	0.000323	0.000608	0.001024	0.000093	0.000088	0.000826	0.000619	0.000085	0.000185	0.001157	0.000222	0.000500	0.000353	0.000339	0.000339	0.000347	0.000089	0.000262	0.000398	0.000609	0.003421	0.001418	0.001880	0.000840	0.000192	0.000610	0.000214	0.000833	0.000424	0.010150	0.003652	0.002916	0.001627	0.001445	0.004042	0.004474	0.005258	0.004338	0.000945	0.009066	0.019935	0.017366	0.000177	0.003107	0.000482	0.000764	0.000373	0.001029	0.002035	0.001730	0.000301	0.000078	0.000190	0.001150	0.000120	0.000391	0.000106	0.001468	0.004730	0.002157	0.000220	0.000054	0.000085	0.000108	0.000008	0.000822	0.000964	0.000860	0.001414	0.000321	0.000286	0.000264	0.001597	0.000268	0.000212	0.003016	0.000264	0.000517	0.000340	0.000664	0.000062	0.000395	0.000700	0.005577	0.000666	0.001776	0.000589	0.000948	0.001249	0.002998	0.000249	0.001497	0.000579	0.000683	0.001782	0.000175	0.000083	0.000170	0.000625	0.001256	0.001709	0.000756	0.001220	0.000774	0.001163	0.000450	0.002543	0.001147	0.001277	0.000469	0.000209	0.000839	0.000177	0.000306	0.000298	0.001299	0.000841	0.000193	0.002633	0.000048	0.000201	0.000225	0.017246	0.003138	0.003556	0.000616	0.000158	0.000092	0.001503	0.000081	0.000962	0.000206	0.001984	0.000089	0.000516	0.001591	0.002339	0.009830	0.001082	0.001902	0.001035	0.008521	0.006903	0.001216	0.002032	0.010408	0.000687	0.028742	0.010691	0.002465	0.009525	0.006214	0.000971	0.003251	0.000912	0.000483	0.009250	0.001075	0.000732	0.008409	0.000895	0.001258	0.000467	0.012293	0.000351	0.001398	0.007653	0.000104
35718641 - Juvenile - Solja Rags - Money On The Couch (Album Version)	35718641	0.055415	0.000866	0.000326	0.000849	0.000136	0.000630	0.000208	0.000298	0.000374	0.000284	0.000480	0.000197	0.000030	0.000151	0.000577	0.000782	0.000452	0.000188	0.000161	0.000234	0.000195	0.000184	0.000621	0.000712	0.000649	0.000190	0.000177	0.026370	0.000277	0.000183	0.000086	0.000158	0.001351	0.000775	0.000380	0.000656	0.282721	0.000218	0.000211	0.000075	0.002924	0.000336	0.000148	0.000198	0.000319	0.000071	0.000209	0.000192	0.000283	0.000152	0.000177	0.000059	0.000034	0.000152	0.000487	0.000217	0.000010	0.000344	0.000224	0.000387	0.000164	0.000152	0.000353	0.000170	0.000386	0.000341	0.000211	0.000030	0.000038	0.000478	0.000066	0.000040	0.004560	0.002669	0.002395	0.000382	0.000436	0.000975	0.000500	0.000100	0.000392	0.000539	0.000143	0.000337	0.001121	0.000118	0.000347	0.000185	0.000109	0.000088	0.000060	0.000053	0.000465	0.000353	0.000455	0.000209	0.000265	0.000298	0.000949	0.000664	0.000348	0.000375	0.000250	0.000207	0.000196	0.000310	0.000218	0.000222	0.000137	0.000085	0.000070	0.001394	0.000691	0.000658	0.000019	0.000103	0.000074	0.000088	0.000112	0.000332	0.000034	0.000026	0.000623	0.000313	0.000749	0.000183	0.001980	0.000962	0.000414	0.000598	0.000276	0.000204	0.001083	0.000433	0.000720	0.000704	0.000037	0.829514	0.045387	0.006241	0.006034	0.001539	0.003364	0.001014	0.000283	0.000593	0.001166	0.000336	0.000376	0.000173	0.000092	0.000154	0.003145	0.002649	0.001799	0.000393	0.000299	0.000233	0.011700	0.038809	0.000233	0.003642	0.006765	0.057502	0.009780	0.001579	0.001648	0.000306	0.004421	0.000155	0.000243	0.001135	0.001055	0.000358	0.000304	0.000245	0.000322	0.000074	0.000181	0.001263	0.001940	0.001575	0.000267	0.000071	0.000545	0.001247	0.000148	0.001081	0.000230	0.000751	0.000060	0.001380	0.000336	0.000183	0.000128	0.010601	0.008147	0.000629	0.000915	0.000213	0.000372	0.000106	0.000278	0.000075	0.000335	0.000603	0.000486	0.000042	0.003110	0.000426	0.000952	0.000032	0.001147	0.000934	0.000515	0.004863	0.018102	0.405549	0.000638	0.002437	0.002991	0.006100	0.000874	0.005903	0.004397	0.000409	0.021310	0.006691	0.013230	0.001009	0.000746	0.000422	0.026617	0.000805	0.002365	0.010086	0.004640	0.000959	0.000182	0.012329	0.003517	0.002086	0.004232	0.001262	0.005754	0.000717	0.000649	0.000376	0.000621	0.000275	0.000062	0.008930	0.000635	0.001451	0.001048	0.000141	0.000634	0.000655	0.000652	0.001237	0.000332	0.000373	0.000171	0.002565	0.000434	0.015441	0.014362	0.003514	0.001954	0.000740	0.011221	0.000597	0.001003	0.000796	0.007468	0.000069	0.001168	0.004813	0.000403	0.002960	0.012749	0.000120	0.000034	0.000103	0.000121	0.000091	0.000014	0.000016	0.000373	0.000050	0.000066	0.000044	0.000074	0.000019	0.000035	0.000026	0.000609	0.000155	0.000096	0.000123	0.001963	0.000260	0.000041	0.000137	0.000083	0.000022	0.000177	0.000439	0.000423	0.000097	0.000742	0.000030	0.000037	0.000025	0.000050	0.000056	0.000147	0.000023	0.000207	0.000038	0.000538	0.000036	0.001647	0.001225	0.000887	0.000394	0.000138	0.000026	0.000169	0.000224	0.000124	0.000087	0.000141	0.000003	0.000009	0.000113	0.000019	0.000050	0.000030	0.000102	0.000071	0.000349	0.000147	0.000186	0.000008	0.000260	0.000038	0.000051	0.000066	0.000034	0.000008	0.000032	0.000041	0.000102	0.000199	0.000441	0.000477	0.000060	0.000062	0.000216	0.000315	0.000288	0.000008	0.000034	0.000470	0.000336	0.000328	0.000165	0.000077	0.000033	0.000191	0.000143	0.000103	0.000066	0.000059	0.000033	0.000378	0.000080	0.000155	0.000554	0.000131	0.000183	0.001141	0.000074	0.000411	0.000036	0.000463	0.000340	0.005107	0.002469	0.000523	0.005311	0.001103	0.003364	0.001465	0.001081	0.005302	0.001574	0.002314	0.004128	0.011015	0.000030	0.012427	0.000508	0.000492	0.000270	0.000809	0.000830	0.000846	0.000179	0.000046	0.000016	0.000068	0.000014	0.000065	0.000094	0.000101	0.000178	0.000550	0.000076	0.000010	0.000076	0.000096	0.000016	0.000161	0.000205	0.000102	0.000222	0.000041	0.000018	0.000026	0.000217	0.000136	0.000106	0.000604	0.000033	0.000026	0.000266	0.001764	0.000013	0.000024	0.000467	0.000408	0.000064	0.000374	0.000020	0.000050	0.000295	0.000823	0.000083	0.000246	0.000085	0.000125	0.000360	0.000036	0.000173	0.000076	0.000411	0.000177	0.000241	0.000046	0.000105	0.001295	0.002292	0.000776	0.000157	0.000276	0.000893	0.000073	0.000031	0.000070	0.000235	0.000049	0.000053	0.001114	0.000347	0.000188	0.001141	0.000022	0.000155	0.000086	0.004387	0.000543	0.000591	0.000135	0.000069	0.000054	0.000615	0.000041	0.000360	0.000246	0.001674	0.000030	0.000128	0.000625	0.001149	0.002010	0.000077	0.000290	0.000130	0.005597	0.003271	0.001963	0.000794	0.005185	0.000772	0.014296	0.001419	0.000211	0.000902	0.002225	0.000956	0.001316	0.000266	0.000611	0.002961	0.000770	0.000986	0.000538	0.000364	0.000306	0.000055	0.001076	0.000110	0.000592	0.001778	0.000048
84751058 - Superorganism - Superorganism - Something For Your M.I.N.D	84751058	0.089189	0.000784	0.001143	0.013331	0.000285	0.000729	0.000539	0.000210	0.000790	0.000546	0.000673	0.000385	0.000067	0.000127	0.001097	0.002000	0.000551	0.000177	0.000551	0.000167	0.000201	0.000160	0.000908	0.001332	0.001533	0.001389	0.001452	0.028452	0.000383	0.000179	0.000243	0.000418	0.002997	0.003079	0.002427	0.001359	0.069974	0.000270	0.002990	0.000154	0.001574	0.000353	0.000116	0.000099	0.000314	0.000045	0.000140	0.000437	0.000453	0.000708	0.000150	0.000157	0.000043	0.000523	0.000828	0.000414	0.000116	0.000343	0.000500	0.000967	0.000723	0.000216	0.000178	0.000123	0.001901	0.001440	0.000215	0.000028	0.000072	0.000532	0.000174	0.000219	0.012744	0.007754	0.004906	0.001161	0.001044	0.001254	0.001762	0.000521	0.001098	0.001224	0.000129	0.001050	0.000426	0.000291	0.001324	0.000621	0.000464	0.000177	0.000260	0.000281	0.000092	0.000578	0.001337	0.000566	0.001402	0.001248	0.002538	0.001885	0.001073	0.000830	0.000981	0.000714	0.000564	0.000770	0.000437	0.000468	0.000145	0.000105	0.000274	0.009245	0.005991	0.006635	0.000254	0.000287	0.000291	0.000372	0.000454	0.000885	0.000103	0.000221	0.001432	0.004169	0.007320	0.000660	0.001715	0.000874	0.000897	0.000588	0.002145	0.000266	0.001675	0.000605	0.000334	0.001187	0.000137	0.713908	0.007420	0.001278	0.001936	0.000387	0.000545	0.000343	0.000116	0.000091	0.000358	0.000078	0.000033	0.000056	0.000053	0.000120	0.001075	0.000990	0.000664	0.000384	0.000320	0.000220	0.003120	0.023420	0.000042	0.001896	0.002862	0.017924	0.003661	0.001078	0.000983	0.000331	0.002283	0.000515	0.000040	0.000347	0.000338	0.000200	0.000403	0.000418	0.000283	0.000236	0.000248	0.005437	0.005985	0.007414	0.000404	0.000062	0.000610	0.000588	0.000135	0.000399	0.000262	0.000385	0.000060	0.000588	0.000156	0.000175	0.000122	0.001608	0.000643	0.000162	0.000279	0.000098	0.000781	0.000125	0.001688	0.001909	0.000543	0.007138	0.006288	0.000024	0.000728	0.000149	0.000103	0.000100	0.000604	0.000509	0.000370	0.002463	0.026620	0.141900	0.000337	0.004148	0.002021	0.007715	0.005024	0.005019	0.004004	0.000972	0.041728	0.005875	0.006785	0.000922	0.001052	0.000223	0.012461	0.000406	0.001061	0.004029	0.002494	0.000455	0.000084	0.027896	0.002830	0.001256	0.021155	0.004164	0.003995	0.001526	0.001467	0.000480	0.000597	0.000071	0.000040	0.006450	0.016302	0.000864	0.000988	0.000229	0.000987	0.000864	0.002046	0.000742	0.002386	0.000077	0.000167	0.000879	0.000252	0.018581	0.009176	0.003451	0.003499	0.004607	0.008913	0.001371	0.000430	0.002651	0.006629	0.000123	0.002016	0.003471	0.000430	0.002370	0.013240	0.000391	0.000132	0.000382	0.000638	0.000349	0.000093	0.000100	0.001148	0.000163	0.000188	0.000132	0.000351	0.000108	0.000155	0.000137	0.000214	0.000820	0.000113	0.000419	0.005446	0.000732	0.000154	0.000477	0.000192	0.000073	0.000381	0.001329	0.000676	0.000231	0.000616	0.000050	0.000081	0.000140	0.000213	0.000268	0.000219	0.000080	0.000376	0.000044	0.000641	0.000209	0.001187	0.001059	0.000625	0.000273	0.000496	0.000076	0.000295	0.000390	0.000111	0.000168	0.000258	0.000026	0.000086	0.000192	0.000027	0.000090	0.000072	0.000084	0.000106	0.001764	0.003188	0.000273	0.000014	0.000052	0.000063	0.000051	0.000097	0.000061	0.000013	0.000029	0.000059	0.000213	0.000382	0.001059	0.006207	0.000129	0.000191	0.000208	0.000436	0.001829	0.000025	0.000027	0.000299	0.000216	0.000110	0.000062	0.000236	0.000038	0.000209	0.000138	0.000207	0.000037	0.000075	0.000048	0.000056	0.000080	0.000527	0.001422	0.001183	0.000924	0.000305	0.000110	0.000322	0.000063	0.000385	0.000326	0.002795	0.001202	0.001313	0.002830	0.000435	0.002314	0.002453	0.000949	0.002667	0.000583	0.002311	0.008958	0.006323	0.000140	0.002276	0.000165	0.000235	0.000105	0.000219	0.000492	0.000379	0.000081	0.000043	0.000040	0.000119	0.000032	0.000094	0.000036	0.000298	0.000956	0.000368	0.000063	0.000009	0.000023	0.000035	0.000005	0.000135	0.000125	0.000584	0.000557	0.000163	0.000101	0.000110	0.000712	0.000239	0.000234	0.002611	0.000100	0.000167	0.000119	0.000746	0.000013	0.000254	0.001053	0.006978	0.000764	0.000912	0.000316	0.000416	0.001342	0.002996	0.000111	0.000545	0.000190	0.000206	0.001445	0.000053	0.000044	0.000056	0.000866	0.000693	0.001604	0.000244	0.000584	0.000348	0.000668	0.000475	0.000917	0.000552	0.001046	0.000378	0.000239	0.000500	0.000152	0.000324	0.000214	0.001673	0.000399	0.000084	0.001773	0.000043	0.000144	0.000168	0.007416	0.001639	0.014483	0.001266	0.000141	0.000052	0.000892	0.000044	0.000609	0.000096	0.001453	0.000061	0.000300	0.003506	0.011451	0.004580	0.003454	0.002132	0.000558	0.004894	0.011524	0.000889	0.005954	0.008307	0.000548	0.016016	0.003671	0.000949	0.004497	0.008236	0.000753	0.003334	0.000449	0.002855	0.008847	0.000336	0.000351	0.002490	0.000423	0.000595	0.000122	0.004912	0.000166	0.000660	0.000981	0.000069
187550472 - qrtr - infina ad nausea - Blame Me	187550472	0.058532	0.000387	0.000848	0.003790	0.000100	0.000331	0.000328	0.000112	0.000658	0.000255	0.000421	0.000090	0.000160	0.000075	0.000634	0.000204	0.000891	0.000299	0.000453	0.000363	0.000499	0.000321	0.000641	0.000929	0.000509	0.000125	0.000135	0.008433	0.000998	0.000963	0.000180	0.000204	0.000623	0.002020	0.001417	0.001352	0.000343	0.000195	0.000194	0.000034	0.000380	0.000238	0.000038	0.000076	0.000126	0.000042	0.000165	0.000239	0.000141	0.000148	0.000100	0.000196	0.000123	0.000207	0.000314	0.000230	0.000056	0.000111	0.000267	0.000211	0.000162	0.000454	0.000049	0.000446	0.000265	0.000547	0.000199	0.000085	0.000218	0.001496	0.000365	0.000285	0.002823	0.002636	0.001843	0.000595	0.000532	0.000753	0.000753	0.000099	0.000388	0.000629	0.000069	0.000504	0.000144	0.000159	0.000224	0.000201	0.000173	0.000091	0.000047	0.000051	0.000323	0.000138	0.000300	0.000147	0.000289	0.000213	0.000447	0.000369	0.000193	0.000234	0.000100	0.000104	0.000087	0.000137	0.000097	0.000097	0.000051	0.000042	0.000162	0.000780	0.000255	0.000204	0.000023	0.000220	0.000159	0.000091	0.000068	0.000286	0.000115	0.000015	0.000536	0.000117	0.000129	0.000112	0.000392	0.000066	0.000120	0.000196	0.001060	0.000111	0.000141	0.000102	0.000074	0.000865	0.000376	0.809043	0.038468	0.004251	0.005484	0.000952	0.000808	0.000531	0.000256	0.000243	0.000435	0.000387	0.000226	0.000331	0.000254	0.000523	0.005052	0.003985	0.002627	0.001659	0.001621	0.000668	0.035640	0.047971	0.000186	0.004629	0.004464	0.035476	0.008104	0.001837	0.000994	0.000852	0.002803	0.002220	0.000351	0.000928	0.000707	0.001812	0.000143	0.000089	0.000133	0.002049	0.000306	0.000721	0.001082	0.000858	0.000476	0.000386	0.001365	0.000999	0.000308	0.000480	0.000310	0.001063	0.000180	0.001275	0.000605	0.000310	0.000200	0.001622	0.001236	0.000216	0.000415	0.000433	0.000576	0.000308	0.000247	0.000039	0.000079	0.000390	0.000192	0.000084	0.000293	0.000605	0.000139	0.000530	0.000322	0.005176	0.001686	0.001580	0.014135	0.006156	0.000251	0.003701	0.000936	0.000688	0.000324	0.000921	0.001104	0.000244	0.003779	0.001350	0.001995	0.000648	0.000824	0.000284	0.004789	0.000467	0.001156	0.001727	0.030862	0.001286	0.000745	0.280909	0.196091	0.049335	0.016618	0.111948	0.161721	0.114542	0.023663	0.104228	0.000974	0.000512	0.000151	0.001701	0.000973	0.002208	0.000584	0.000224	0.002070	0.003008	0.000668	0.000661	0.001108	0.000273	0.000235	0.000624	0.000351	0.002651	0.004150	0.004191	0.002624	0.001231	0.010786	0.000346	0.000932	0.000449	0.035248	0.000117	0.001513	0.001130	0.000212	0.001249	0.008068	0.000201	0.000360	0.000213	0.000122	0.000185	0.000085	0.000122	0.000588	0.000085	0.000058	0.000064	0.000129	0.000064	0.000117	0.000084	0.000093	0.000451	0.000243	0.000440	0.003831	0.000334	0.000088	0.000125	0.000183	0.000065	0.000269	0.001178	0.000489	0.000166	0.000091	0.000016	0.000090	0.000118	0.000256	0.000274	0.000246	0.000071	0.000155	0.000028	0.000158	0.000102	0.000231	0.000200	0.000115	0.000092	0.000232	0.000091	0.000320	0.000481	0.000107	0.000138	0.000266	0.000007	0.000160	0.000197	0.000043	0.000049	0.000049	0.000069	0.000134	0.000668	0.001303	0.000238	0.000030	0.000013	0.000070	0.000027	0.000098	0.000080	0.000020	0.000058	0.000077	0.000177	0.000651	0.000232	0.000560	0.000263	0.000347	0.000164	0.000811	0.000155	0.000024	0.000089	0.000416	0.000176	0.000052	0.000071	0.000248	0.000124	0.000099	0.000072	0.000223	0.000098	0.000176	0.000032	0.000022	0.000100	0.000235	0.000417	0.000103	0.000164	0.000097	0.000057	0.000233	0.000089	0.000299	0.000146	0.000490	0.000418	0.000202	0.001605	0.000301	0.000420	0.001721	0.000379	0.000913	0.000260	0.000772	0.000626	0.000948	0.000136	0.000892	0.000105	0.000170	0.000060	0.000298	0.000754	0.000784	0.000073	0.000013	0.000103	0.000206	0.000031	0.000078	0.000110	0.000166	0.000349	0.000360	0.000090	0.000007	0.000032	0.000074	0.000012	0.000094	0.000081	0.001136	0.000309	0.000103	0.000066	0.000121	0.000208	0.000501	0.000284	0.002059	0.000238	0.000149	0.000214	0.000239	0.000020	0.000117	0.000444	0.000390	0.000101	0.000489	0.000163	0.000188	0.001170	0.001032	0.000058	0.000271	0.000103	0.000283	0.000604	0.000046	0.000075	0.000069	0.002457	0.000180	0.001521	0.000602	0.000268	0.000672	0.007844	0.002052	0.000399	0.000173	0.000199	0.000105	0.000102	0.000184	0.000382	0.000068	0.000108	0.001025	0.000395	0.000119	0.001282	0.000035	0.000093	0.000057	0.001083	0.000756	0.000307	0.000090	0.000015	0.000039	0.001432	0.000041	0.000706	0.000110	0.000435	0.000063	0.000301	0.000616	0.000230	0.004320	0.000480	0.000356	0.000172	0.007091	0.001277	0.002377	0.000347	0.012105	0.003709	0.010595	0.008404	0.002534	0.002525	0.001285	0.006251	0.011571	0.000201	0.000109	0.004153	0.000292	0.003108	0.001379	0.000927	0.000687	0.000100	0.007469	0.000294	0.000924	0.000638	0.000129
203900170 - Ledé Markson - Napalm - Liège Flippe	203900170	0.030133	0.000628	0.000276	0.000841	0.000093	0.000384	0.000170	0.000198	0.000203	0.000274	0.000277	0.000102	0.000041	0.000046	0.000427	0.000509	0.000456	0.000234	0.000181	0.000120	0.000194	0.000093	0.000448	0.000400	0.000414	0.000179	0.000236	0.047143	0.000236	0.000053	0.000103	0.000224	0.000849	0.000535	0.000138	0.000110	0.190125	0.000329	0.000349	0.000050	0.000849	0.000313	0.000043	0.000071	0.000304	0.000059	0.000110	0.000285	0.000241	0.000241	0.000022	0.000046	0.000032	0.000079	0.000171	0.000073	0.000009	0.000187	0.000278	0.000277	0.000176	0.000124	0.000262	0.000243	0.000951	0.000701	0.000121	0.000026	0.000041	0.000413	0.000096	0.000036	0.003215	0.002544	0.002149	0.000692	0.000370	0.000457	0.000563	0.000126	0.000335	0.000269	0.000073	0.000151	0.000183	0.000054	0.000158	0.000112	0.000079	0.000039	0.000028	0.000026	0.000189	0.000121	0.000189	0.000102	0.000169	0.000162	0.000441	0.000226	0.000103	0.000167	0.000111	0.000093	0.000129	0.000247	0.000150	0.000176	0.000039	0.000034	0.000059	0.000956	0.000484	0.000570	0.000054	0.000085	0.000062	0.000173	0.000226	0.000409	0.000087	0.000018	0.000510	0.000181	0.000196	0.000069	0.000665	0.000368	0.000208	0.000191	0.000208	0.000057	0.000783	0.000275	0.000103	0.000512	0.000023	0.865647	0.046609	0.039251	0.041749	0.006399	0.009172	0.023972	0.001082	0.001994	0.012653	0.000415	0.000247	0.000996	0.001100	0.001696	0.001817	0.001706	0.001418	0.000238	0.000155	0.000105	0.005591	0.016937	0.000416	0.001699	0.002554	0.014956	0.003351	0.000647	0.000634	0.000174	0.001897	0.000263	0.000100	0.000389	0.000356	0.000512	0.000126	0.000145	0.000285	0.000091	0.000119	0.000699	0.000975	0.000939	0.000258	0.000036	0.000429	0.000476	0.000118	0.000305	0.000116	0.001396	0.000076	0.000658	0.002066	0.000290	0.000218	0.001183	0.000773	0.000291	0.000226	0.002299	0.000124	0.000054	0.000126	0.000042	0.000109	0.000387	0.000255	0.000017	0.000623	0.000090	0.000184	0.000028	0.000282	0.000476	0.000512	0.000727	0.043266	0.268951	0.000598	0.002835	0.006033	0.015033	0.002152	0.009324	0.006648	0.000424	0.107537	0.017631	0.007669	0.002103	0.000345	0.000837	0.028206	0.000873	0.007720	0.020324	0.003981	0.001071	0.000110	0.007018	0.004223	0.001689	0.001843	0.000702	0.005719	0.000860	0.001585	0.000480	0.001832	0.000280	0.002298	0.028463	0.000406	0.007310	0.001266	0.000154	0.003171	0.003998	0.000993	0.002027	0.000757	0.000142	0.000150	0.002455	0.000332	0.044688	0.018817	0.008443	0.005432	0.000563	0.025023	0.002334	0.000513	0.000997	0.013443	0.000212	0.005645	0.001784	0.003767	0.018471	0.029839	0.000227	0.000101	0.000079	0.000083	0.000069	0.000019	0.000024	0.000219	0.000036	0.000049	0.000031	0.000065	0.000027	0.000030	0.000025	0.000117	0.000140	0.000054	0.000089	0.001493	0.000111	0.000021	0.000070	0.000054	0.000017	0.000162	0.000463	0.000463	0.000088	0.000666	0.000007	0.000022	0.000020	0.000066	0.000049	0.000149	0.000022	0.000170	0.000022	0.000100	0.000045	0.000417	0.000391	0.000202	0.000118	0.000127	0.000027	0.000106	0.000145	0.000040	0.000049	0.000098	0.000003	0.000020	0.000067	0.000011	0.000028	0.000022	0.000039	0.000042	0.000163	0.000131	0.000146	0.000009	0.000064	0.000024	0.000019	0.000051	0.000032	0.000006	0.000034	0.000039	0.000097	0.000165	0.000184	0.000343	0.000049	0.000103	0.000137	0.000237	0.000438	0.000004	0.000008	0.000110	0.000064	0.000386	0.000029	0.000072	0.000020	0.000096	0.000072	0.000065	0.000010	0.000048	0.000023	0.000055	0.000020	0.000083	0.000269	0.000044	0.000130	0.000156	0.000029	0.000109	0.000024	0.000139	0.000128	0.008400	0.001190	0.000455	0.002517	0.000519	0.003650	0.002376	0.001347	0.001301	0.000187	0.003366	0.006035	0.013582	0.000025	0.002446	0.000073	0.000120	0.000052	0.000368	0.000489	0.000405	0.000043	0.000007	0.000013	0.000020	0.000005	0.000025	0.000031	0.000065	0.000136	0.000176	0.000054	0.000009	0.000031	0.000028	0.000008	0.000056	0.000077	0.000313	0.000186	0.000058	0.000020	0.000047	0.000147	0.000235	0.000112	0.001267	0.000048	0.000053	0.000128	0.002364	0.000009	0.000023	0.000209	0.000206	0.000075	0.000163	0.000024	0.000041	0.000096	0.000415	0.000027	0.000186	0.000048	0.000075	0.000207	0.000014	0.000021	0.000014	0.000445	0.000108	0.000275	0.000127	0.000116	0.012825	0.004361	0.001483	0.000157	0.000405	0.001575	0.000069	0.000033	0.000115	0.000138	0.000039	0.000030	0.000266	0.000146	0.000084	0.001075	0.000009	0.000040	0.000036	0.003001	0.000263	0.000243	0.000069	0.000092	0.000016	0.000409	0.000020	0.000298	0.000041	0.000407	0.000023	0.000211	0.000912	0.000412	0.001648	0.000308	0.000323	0.000055	0.007012	0.006759	0.003350	0.002312	0.004753	0.002175	0.009424	0.001745	0.000256	0.001022	0.001276	0.002169	0.003022	0.000165	0.000250	0.003270	0.000249	0.001606	0.000513	0.000243	0.000208	0.000038	0.001268	0.000103	0.000227	0.000297	0.000060
192849379 - John Glacier - SHILOH- Lost For Words - Platoon	192849379	0.072437	0.000649	0.001043	0.002106	0.000210	0.000818	0.000250	0.000193	0.000353	0.000421	0.000571	0.000191	0.000028	0.000068	0.000703	0.001554	0.000707	0.000283	0.000341	0.000326	0.000240	0.000241	0.000406	0.000643	0.000872	0.000299	0.000186	0.016467	0.000132	0.000134	0.000078	0.000429	0.001752	0.001320	0.000523	0.000689	0.097057	0.000251	0.000419	0.000049	0.001532	0.000449	0.000117	0.000096	0.000359	0.000035	0.000143	0.000599	0.000439	0.000376	0.000172	0.000082	0.000096	0.000114	0.000434	0.000190	0.000024	0.000223	0.000188	0.000885	0.000120	0.000148	0.000232	0.000156	0.003114	0.003172	0.000143	0.000014	0.000070	0.000408	0.000124	0.000054	0.006623	0.004528	0.004096	0.001779	0.001325	0.001673	0.001819	0.000338	0.000943	0.000520	0.000080	0.000357	0.000314	0.000168	0.000458	0.000278	0.000188	0.000103	0.000072	0.000073	0.000328	0.000201	0.000359	0.000176	0.000493	0.000380	0.002591	0.001224	0.000653	0.000634	0.001419	0.001187	0.000259	0.000329	0.000553	0.000663	0.000083	0.000048	0.000093	0.002285	0.001187	0.001104	0.000078	0.000200	0.000185	0.000317	0.000400	0.000857	0.000200	0.000034	0.001251	0.000747	0.000793	0.000118	0.000984	0.000823	0.000171	0.000203	0.000960	0.000094	0.001345	0.000433	0.000173	0.000876	0.000109	0.778894	0.018114	0.002112	0.002694	0.000584	0.000924	0.000597	0.000077	0.000153	0.000591	0.000195	0.000116	0.000114	0.000069	0.000259	0.001980	0.001605	0.001008	0.000437	0.000238	0.000293	0.006870	0.026803	0.000060	0.002829	0.004793	0.047695	0.008130	0.001248	0.001347	0.000307	0.003956	0.000168	0.000108	0.000548	0.000505	0.000589	0.000243	0.000141	0.000360	0.000251	0.000175	0.001145	0.001441	0.001478	0.000222	0.000053	0.000405	0.000675	0.000155	0.000461	0.000156	0.000435	0.000067	0.000592	0.000223	0.000201	0.000141	0.003038	0.001258	0.000261	0.000325	0.000153	0.000264	0.000070	0.000313	0.000149	0.000455	0.000880	0.000641	0.000017	0.000863	0.000197	0.000282	0.000145	0.000682	0.000481	0.000982	0.003058	0.036779	0.215149	0.000805	0.002980	0.002834	0.009977	0.002547	0.005415	0.004308	0.000281	0.066005	0.006489	0.013900	0.000685	0.000502	0.000266	0.018336	0.000812	0.003239	0.009874	0.009635	0.000525	0.000065	0.035681	0.013358	0.006022	0.013253	0.007106	0.015753	0.004856	0.002606	0.001352	0.001144	0.000304	0.000077	0.009982	0.000968	0.002461	0.000967	0.000129	0.003754	0.006576	0.000389	0.000649	0.000639	0.000137	0.000167	0.001847	0.000423	0.017125	0.014375	0.005199	0.003884	0.001082	0.020443	0.001445	0.000487	0.000439	0.023602	0.000105	0.003021	0.003964	0.000692	0.003913	0.023211	0.000313	0.000142	0.000113	0.000164	0.000114	0.000040	0.000053	0.000378	0.000059	0.000117	0.000050	0.000156	0.000051	0.000066	0.000051	0.000164	0.000539	0.000070	0.000140	0.002483	0.000269	0.000052	0.000240	0.000064	0.000022	0.000220	0.000631	0.000786	0.000146	0.002220	0.000035	0.000042	0.000043	0.000109	0.000067	0.000168	0.000032	0.000299	0.000024	0.000178	0.000060	0.001722	0.001289	0.001064	0.000350	0.000186	0.000049	0.000182	0.000231	0.000082	0.000091	0.000160	0.000010	0.000035	0.000110	0.000019	0.000040	0.000038	0.000037	0.000072	0.000393	0.000472	0.000225	0.000014	0.000041	0.000063	0.000024	0.000099	0.000052	0.000007	0.000046	0.000049	0.000162	0.000330	0.000389	0.000481	0.000162	0.000123	0.000151	0.000502	0.000362	0.000007	0.000048	0.000412	0.000272	0.000134	0.000067	0.000135	0.000033	0.000108	0.000073	0.000120	0.000045	0.000035	0.000014	0.000088	0.000046	0.000190	0.000988	0.000094	0.000384	0.000292	0.000074	0.000555	0.000048	0.000639	0.000338	0.003504	0.001359	0.000478	0.002677	0.001418	0.002520	0.002666	0.000743	0.003643	0.000493	0.002376	0.004730	0.009555	0.000105	0.004013	0.000117	0.000176	0.000073	0.000643	0.001790	0.001497	0.000059	0.000017	0.000032	0.000071	0.000012	0.000138	0.000081	0.000222	0.000450	0.000384	0.000063	0.000004	0.000016	0.000035	0.000003	0.000099	0.000088	0.000537	0.000473	0.000060	0.000019	0.000085	0.000635	0.000143	0.000107	0.002763	0.000057	0.000031	0.000129	0.002298	0.000005	0.000057	0.000478	0.000971	0.000085	0.000435	0.000080	0.000124	0.000839	0.002945	0.000054	0.000330	0.000085	0.000142	0.000681	0.000043	0.000087	0.000052	0.001493	0.000459	0.000736	0.000125	0.000112	0.000736	0.000760	0.000324	0.000223	0.000539	0.000702	0.000096	0.000032	0.000072	0.000284	0.000080	0.000085	0.001012	0.000390	0.000064	0.001722	0.000008	0.000040	0.000031	0.004091	0.001161	0.000529	0.000158	0.000065	0.000025	0.000800	0.000034	0.000631	0.000111	0.003806	0.000043	0.000201	0.001111	0.000690	0.013747	0.000793	0.000159	0.000075	0.003369	0.004819	0.002727	0.001418	0.009475	0.008333	0.014404	0.001745	0.000436	0.001390	0.002381	0.001391	0.003671	0.000136	0.000529	0.020215	0.001094	0.000349	0.002529	0.000306	0.000556	0.000057	0.013178	0.000175	0.000577	0.001996	0.000069
203900171 - Ledé Markson - Napalm - Momentum	203900171	0.065135	0.002627	0.000471	0.000877	0.000325	0.001613	0.000186	0.000403	0.000316	0.000709	0.000547	0.000245	0.000053	0.000032	0.000524	0.000868	0.000432	0.000145	0.000198	0.000137	0.000161	0.000142	0.000379	0.000332	0.000675	0.000333	0.000389	0.033577	0.000419	0.000130	0.000546	0.000693	0.001581	0.000452	0.000125	0.000270	0.251863	0.000374	0.000401	0.000088	0.001137	0.000850	0.000072	0.000063	0.000696	0.000041	0.000201	0.000369	0.000259	0.000315	0.000041	0.000050	0.000054	0.000111	0.000186	0.000079	0.000004	0.000441	0.000119	0.000279	0.000141	0.000055	0.000174	0.000074	0.003312	0.000870	0.000096	0.000019	0.000057	0.000458	0.000154	0.000022	0.003370	0.002572	0.002280	0.000872	0.000458	0.000888	0.000682	0.000193	0.000313	0.000268	0.000084	0.000129	0.000130	0.000043	0.000150	0.000096	0.000073	0.000029	0.000033	0.000033	0.000031	0.000064	0.000145	0.000073	0.000168	0.000139	0.000264	0.000137	0.000056	0.000092	0.000101	0.000090	0.000068	0.000139	0.000074	0.000087	0.000052	0.000042	0.000077	0.000727	0.000336	0.000289	0.000015	0.000122	0.000088	0.000096	0.000129	0.000313	0.000115	0.000012	0.000728	0.000069	0.000118	0.000029	0.000392	0.000131	0.000179	0.000130	0.000442	0.000041	0.000316	0.000109	0.000105	0.000237	0.000140	0.793142	0.014171	0.003493	0.004085	0.000858	0.001602	0.000656	0.000213	0.000127	0.000607	0.000132	0.000152	0.000073	0.000063	0.000175	0.002237	0.002072	0.001587	0.000899	0.000374	0.000485	0.005713	0.017393	0.000111	0.001660	0.002249	0.004077	0.002818	0.000601	0.000526	0.000128	0.001520	0.003015	0.000053	0.000366	0.000283	0.000145	0.000078	0.000037	0.000059	0.000890	0.000166	0.000890	0.001204	0.001073	0.000363	0.000054	0.000828	0.000879	0.000234	0.000435	0.000272	0.000653	0.000055	0.000574	0.000251	0.000304	0.000214	0.002190	0.001315	0.000349	0.000261	0.000193	0.000204	0.000088	0.000233	0.000119	0.000748	0.000497	0.000222	0.000021	0.001163	0.000125	0.000146	0.000136	0.000620	0.001204	0.001822	0.000523	0.036018	0.298256	0.000511	0.003916	0.003694	0.016004	0.002844	0.010407	0.006582	0.001046	0.099721	0.020670	0.004894	0.001011	0.000618	0.000286	0.031976	0.000526	0.004648	0.013742	0.004700	0.000946	0.000186	0.011940	0.003726	0.001750	0.004279	0.001108	0.007240	0.000877	0.010430	0.000582	0.000371	0.000061	0.000066	0.019120	0.000379	0.005090	0.001413	0.000247	0.001196	0.000882	0.000979	0.001653	0.001013	0.000170	0.000181	0.002189	0.000178	0.038118	0.024548	0.006286	0.004370	0.000732	0.024234	0.000922	0.000399	0.001011	0.011783	0.000102	0.001828	0.001584	0.001676	0.007371	0.024160	0.000443	0.001282	0.000100	0.000087	0.000094	0.000032	0.000045	0.000104	0.000030	0.000031	0.000023	0.000045	0.000017	0.000055	0.000039	0.000064	0.000153	0.000028	0.000059	0.002133	0.000169	0.000035	0.000104	0.000075	0.000032	0.000160	0.000577	0.000411	0.000084	0.000166	0.000010	0.000022	0.000019	0.000106	0.000066	0.000104	0.000019	0.000126	0.000013	0.000097	0.000052	0.000205	0.000184	0.000100	0.000061	0.000195	0.000039	0.000113	0.000156	0.000049	0.000067	0.000101	0.000005	0.000041	0.000121	0.000017	0.000037	0.000046	0.000051	0.000082	0.000267	0.001197	0.000119	0.000006	0.000018	0.000014	0.000008	0.000045	0.000029	0.000003	0.000010	0.000024	0.000119	0.000234	0.000290	0.000644	0.000071	0.000204	0.000060	0.000175	0.000200	0.000009	0.000025	0.000051	0.000028	0.000079	0.000016	0.000086	0.000011	0.000039	0.000029	0.000036	0.000006	0.000012	0.000004	0.000021	0.000014	0.000089	0.000214	0.000035	0.000084	0.000145	0.000037	0.000100	0.000007	0.000124	0.000229	0.003418	0.001834	0.001014	0.001567	0.000560	0.005251	0.004787	0.000567	0.000619	0.000145	0.001743	0.005401	0.008870	0.000137	0.005372	0.000045	0.000033	0.000010	0.000186	0.000257	0.000240	0.000007	0.000002	0.000008	0.000032	0.000012	0.000023	0.000020	0.000064	0.000170	0.000109	0.000024	0.000002	0.000008	0.000011	0.000002	0.000044	0.000049	0.000496	0.000208	0.000033	0.000017	0.000090	0.000141	0.000289	0.000104	0.001585	0.000100	0.000066	0.000045	0.000630	0.000001	0.000008	0.000146	0.000128	0.000046	0.000126	0.000017	0.000021	0.000212	0.000517	0.000017	0.000195	0.000022	0.000038	0.000198	0.000008	0.000005	0.000023	0.003910	0.000304	0.000452	0.000185	0.000227	0.000978	0.002022	0.000770	0.000297	0.000690	0.000952	0.000049	0.000023	0.000044	0.000090	0.000041	0.000045	0.000208	0.000095	0.000029	0.001717	0.000002	0.000032	0.000034	0.003753	0.000256	0.000432	0.000108	0.000021	0.000011	0.000443	0.000023	0.000243	0.000025	0.000644	0.000023	0.001089	0.000611	0.000348	0.009918	0.000154	0.000234	0.000063	0.004751	0.013229	0.001815	0.002345	0.005829	0.002559	0.009673	0.003192	0.000506	0.001295	0.001250	0.003165	0.007145	0.000176	0.000232	0.006803	0.000523	0.000921	0.002049	0.000193	0.000422	0.000027	0.012374	0.000131	0.000337	0.000589	0.000109
70974998 - Pham - Alibi - Alibi	70974998	0.037945	0.000514	0.000439	0.002770	0.000086	0.000290	0.000443	0.000136	0.000297	0.000215	0.000224	0.000103	0.000152	0.000054	0.000947	0.000812	0.001003	0.000475	0.000508	0.000186	0.000434	0.000125	0.001430	0.001552	0.001956	0.000379	0.000575	0.015014	0.000204	0.000165	0.000153	0.000273	0.000368	0.000865	0.000440	0.000856	0.014024	0.000550	0.000578	0.000053	0.000940	0.000977	0.000360	0.000181	0.000543	0.000100	0.000300	0.001040	0.000523	0.001472	0.000174	0.000056	0.000025	0.000133	0.000441	0.000157	0.000064	0.000203	0.000457	0.000622	0.000376	0.000180	0.000063	0.000115	0.003244	0.001854	0.000132	0.000026	0.000041	0.000480	0.000052	0.000046	0.009070	0.007894	0.006059	0.002699	0.001193	0.003568	0.001486	0.000674	0.000975	0.000881	0.000155	0.000470	0.000305	0.000151	0.000447	0.000185	0.000113	0.000063	0.000106	0.000105	0.000018	0.000326	0.000367	0.000263	0.000343	0.000317	0.000824	0.000493	0.000201	0.000406	0.000221	0.000212	0.000163	0.000229	0.000273	0.000283	0.000068	0.000053	0.000198	0.001662	0.000626	0.000515	0.000038	0.000159	0.000123	0.000307	0.000320	0.001223	0.000390	0.000032	0.001654	0.000385	0.000301	0.000111	0.000828	0.000422	0.000273	0.000295	0.002286	0.000148	0.000719	0.000263	0.000098	0.000252	0.000146	0.664691	0.014208	0.001727	0.002429	0.000536	0.000720	0.000393	0.000166	0.000095	0.000273	0.000099	0.000154	0.000120	0.000142	0.000186	0.003403	0.002677	0.002461	0.001132	0.000739	0.000447	0.016251	0.022340	0.000151	0.000823	0.001404	0.007016	0.001635	0.000467	0.000337	0.000149	0.000890	0.000654	0.000049	0.000344	0.000282	0.000045	0.000067	0.000039	0.000043	0.001509	0.000148	0.000887	0.001097	0.001265	0.000387	0.000033	0.000669	0.003302	0.001323	0.001396	0.001070	0.000570	0.000074	0.000862	0.000307	0.000289	0.000222	0.003804	0.001949	0.000531	0.000785	0.000182	0.000361	0.000198	0.000219	0.000154	0.000461	0.001174	0.000638	0.000032	0.001342	0.000633	0.000199	0.001471	0.001555	0.001653	0.002252	0.000561	0.026879	0.070264	0.000178	0.002335	0.001480	0.002406	0.001843	0.001939	0.001118	0.000173	0.024143	0.002411	0.002712	0.000271	0.000412	0.000097	0.004600	0.000258	0.001109	0.003504	0.003982	0.000836	0.000137	0.139025	0.010760	0.004359	0.072975	0.043207	0.021120	0.015982	0.032054	0.006481	0.000405	0.000083	0.000033	0.003017	0.000483	0.002252	0.000472	0.000119	0.001533	0.001826	0.000626	0.000460	0.002059	0.000195	0.000134	0.000355	0.000214	0.004778	0.008757	0.002647	0.002489	0.000582	0.008629	0.000636	0.000247	0.000411	0.009932	0.000060	0.000695	0.000494	0.000481	0.002019	0.006715	0.000832	0.000426	0.000202	0.000151	0.000186	0.000084	0.000120	0.000389	0.000082	0.000066	0.000063	0.000119	0.000061	0.000103	0.000077	0.000251	0.000236	0.000069	0.000100	0.003812	0.000270	0.000057	0.000153	0.000083	0.000054	0.000249	0.001031	0.001555	0.000259	0.000246	0.000029	0.000059	0.000113	0.000192	0.000219	0.000247	0.000056	0.000545	0.000026	0.000206	0.000094	0.000413	0.000340	0.000229	0.000096	0.000445	0.000069	0.000339	0.000430	0.000199	0.000262	0.000280	0.000010	0.000079	0.000227	0.000039	0.000064	0.000089	0.000073	0.000158	0.000682	0.000880	0.000266	0.000017	0.000047	0.000075	0.000062	0.000086	0.000049	0.000012	0.000056	0.000048	0.000168	0.000489	0.000295	0.001184	0.000169	0.000249	0.000086	0.000157	0.000586	0.000025	0.000055	0.000135	0.000095	0.000027	0.000047	0.000191	0.000060	0.000107	0.000078	0.000162	0.000049	0.000051	0.000024	0.000128	0.000084	0.000175	0.000317	0.000088	0.000206	0.000718	0.000042	0.000137	0.000041	0.000161	0.000221	0.001285	0.000927	0.000569	0.001196	0.000411	0.001829	0.002222	0.000781	0.001353	0.000338	0.001080	0.001714	0.001975	0.000898	0.002715	0.000237	0.000164	0.000070	0.000467	0.000461	0.000517	0.000049	0.000015	0.000075	0.000184	0.000017	0.000118	0.000087	0.000237	0.000413	0.000600	0.000042	0.000012	0.000043	0.000087	0.000012	0.000274	0.000268	0.000573	0.000487	0.000133	0.000064	0.000063	0.000540	0.000278	0.000249	0.001244	0.000090	0.000103	0.000178	0.000369	0.000013	0.000034	0.000170	0.000108	0.000094	0.000181	0.000150	0.000082	0.000215	0.000443	0.000021	0.000147	0.000054	0.000056	0.000413	0.000049	0.000021	0.000027	0.003445	0.000451	0.000728	0.000139	0.000125	0.000825	0.003617	0.001623	0.000224	0.000207	0.000578	0.000065	0.000047	0.000081	0.000124	0.000087	0.000069	0.000210	0.000111	0.000150	0.000464	0.000012	0.000067	0.000046	0.001930	0.000183	0.000401	0.000147	0.000053	0.000042	0.000394	0.000022	0.000286	0.000063	0.000633	0.000063	0.000270	0.000233	0.000283	0.049157	0.006541	0.000239	0.000225	0.006549	0.007785	0.000866	0.004451	0.005342	0.003740	0.009803	0.002390	0.000426	0.001672	0.001890	0.002375	0.008279	0.000303	0.000259	0.008860	0.004331	0.001924	0.002475	0.000374	0.000832	0.000065	0.031256	0.000235	0.000308	0.000656	0.000058
72841645 - Hippie Sabotage - Options - Straigh to My Head	72841645	0.018299	0.000353	0.000297	0.000713	0.000074	0.000297	0.000108	0.000092	0.000449	0.000332	0.000306	0.000159	0.000078	0.000055	0.000350	0.000223	0.000216	0.000080	0.000087	0.000090	0.000069	0.000071	0.000170	0.000304	0.000272	0.000084	0.000272	0.025404	0.000617	0.000494	0.000138	0.000278	0.000672	0.001671	0.000577	0.001108	0.017408	0.000315	0.000225	0.000022	0.000165	0.000222	0.000069	0.000102	0.000265	0.000028	0.000181	0.000104	0.000116	0.000090	0.000121	0.000195	0.000066	0.000256	0.000516	0.000240	0.000016	0.000134	0.000104	0.000094	0.000125	0.000143	0.000054	0.000188	0.000802	0.001469	0.000173	0.000061	0.000099	0.000517	0.000112	0.000069	0.001973	0.001096	0.000633	0.000208	0.000193	0.000324	0.000279	0.000079	0.000178	0.000446	0.000095	0.000327	0.000189	0.000079	0.000275	0.000339	0.000297	0.000134	0.000118	0.000109	0.000086	0.000054	0.000166	0.000145	0.000449	0.000338	0.000428	0.000316	0.000143	0.000152	0.000119	0.000108	0.000106	0.000155	0.000093	0.000097	0.000034	0.000028	0.000129	0.000879	0.000367	0.000275	0.000010	0.000166	0.000109	0.000149	0.000165	0.000202	0.000036	0.000013	0.000153	0.000150	0.000361	0.000100	0.000327	0.000085	0.000110	0.000144	0.001055	0.000079	0.000216	0.000068	0.000062	0.001475	0.000091	0.802814	0.041249	0.002476	0.002930	0.000700	0.000445	0.000632	0.000264	0.000125	0.000523	0.000387	0.000582	0.000276	0.000252	0.000269	0.002221	0.002126	0.001075	0.000735	0.000359	0.000297	0.007987	0.031779	0.000170	0.003634	0.009311	0.048019	0.011917	0.002794	0.002274	0.000763	0.006370	0.000450	0.000267	0.001164	0.001086	0.000511	0.000197	0.000168	0.000176	0.000229	0.000092	0.000815	0.001094	0.001131	0.000221	0.000109	0.003110	0.029863	0.010111	0.015134	0.010605	0.001849	0.000371	0.003412	0.000482	0.000807	0.000467	0.008038	0.001885	0.003262	0.002442	0.000238	0.000253	0.000161	0.000384	0.000045	0.000033	0.000518	0.000320	0.000061	0.000835	0.000994	0.000524	0.001931	0.001567	0.001372	0.000309	0.002866	0.032629	0.104844	0.000246	0.003567	0.002002	0.002666	0.001621	0.002193	0.002298	0.000360	0.023052	0.003127	0.005154	0.000845	0.001319	0.000438	0.005146	0.000591	0.002006	0.008354	0.004194	0.002955	0.000560	0.105501	0.007684	0.003450	0.039509	0.096961	0.018760	0.009428	0.008359	0.002942	0.001043	0.000399	0.000084	0.003805	0.000694	0.001699	0.000693	0.000210	0.002078	0.004352	0.000887	0.000849	0.002584	0.000389	0.000178	0.000727	0.000496	0.005882	0.015237	0.003535	0.003525	0.001262	0.008419	0.000964	0.000390	0.000632	0.008825	0.000214	0.001195	0.000983	0.000807	0.003016	0.008940	0.000580	0.000232	0.000254	0.000191	0.000241	0.000070	0.000083	0.000406	0.000144	0.000140	0.000116	0.000173	0.000068	0.000159	0.000117	0.000146	0.000255	0.000137	0.000261	0.003236	0.000408	0.000094	0.000188	0.000143	0.000077	0.000227	0.000852	0.000452	0.000300	0.000054	0.000020	0.000086	0.000154	0.000148	0.000250	0.000224	0.000056	0.000202	0.000045	0.000071	0.000073	0.000362	0.000198	0.000175	0.000110	0.000395	0.000089	0.000465	0.000565	0.000149	0.000244	0.000383	0.000030	0.000090	0.000344	0.000067	0.000075	0.000076	0.000136	0.000213	0.001213	0.001704	0.000321	0.000026	0.000020	0.000103	0.000078	0.000104	0.000081	0.000035	0.000064	0.000087	0.000145	0.000319	0.000048	0.000530	0.000149	0.000294	0.000150	0.000577	0.000050	0.000008	0.000042	0.000210	0.000116	0.000109	0.000083	0.000068	0.000065	0.000152	0.000088	0.000087	0.000056	0.000071	0.000045	0.000036	0.000092	0.000248	0.000720	0.000235	0.000529	0.000328	0.000066	0.000168	0.000077	0.000223	0.000227	0.000168	0.000360	0.000150	0.001492	0.000168	0.000480	0.000480	0.000247	0.000831	0.000244	0.000314	0.000256	0.000136	0.001805	0.000485	0.000100	0.000397	0.000177	0.000336	0.000581	0.000525	0.000145	0.000019	0.000098	0.000165	0.000028	0.000048	0.000087	0.000272	0.000806	0.000509	0.000076	0.000023	0.000057	0.000087	0.000013	0.000189	0.000150	0.000449	0.000262	0.000192	0.000197	0.000050	0.000106	0.000363	0.000143	0.001759	0.000132	0.000146	0.000284	0.004236	0.000025	0.000065	0.000226	0.000390	0.000163	0.000475	0.000061	0.000111	0.000613	0.001903	0.000064	0.000479	0.000127	0.000209	0.000695	0.000083	0.000064	0.000064	0.000541	0.000158	0.001079	0.000191	0.000068	0.000446	0.001973	0.000972	0.001379	0.000419	0.000288	0.000117	0.000227	0.000097	0.000441	0.000051	0.000111	0.002086	0.000291	0.000161	0.001572	0.000054	0.000124	0.000079	0.000785	0.000729	0.000278	0.000057	0.000009	0.000046	0.000721	0.000031	0.000800	0.000107	0.000488	0.000117	0.000099	0.000292	0.000499	0.008217	0.003092	0.000092	0.000274	0.011615	0.000515	0.001048	0.000218	0.007726	0.004570	0.005865	0.004843	0.001123	0.001747	0.001532	0.001451	0.009443	0.000222	0.000146	0.011506	0.001049	0.000914	0.001070	0.000296	0.000634	0.000114	0.005714	0.000246	0.000601	0.000648	0.000119
72128615 - Ledé Markson - Momentum - Momentum	72128615	0.063213	0.002465	0.000464	0.000932	0.000319	0.001533	0.000206	0.000440	0.000308	0.000639	0.000497	0.000227	0.000052	0.000030	0.000503	0.000921	0.000475	0.000167	0.000200	0.000142	0.000175	0.000142	0.000413	0.000332	0.000641	0.000338	0.000447	0.035449	0.000420	0.000135	0.000585	0.000701	0.001388	0.000428	0.000124	0.000269	0.264226	0.000403	0.000417	0.000097	0.001204	0.000895	0.000078	0.000075	0.000713	0.000044	0.000200	0.000424	0.000277	0.000326	0.000041	0.000048	0.000048	0.000108	0.000208	0.000081	0.000005	0.000399	0.000130	0.000298	0.000150	0.000058	0.000173	0.000072	0.002721	0.000753	0.000089	0.000019	0.000059	0.000445	0.000150	0.000024	0.003412	0.002595	0.002217	0.000849	0.000407	0.000755	0.000610	0.000200	0.000295	0.000292	0.000094	0.000134	0.000117	0.000045	0.000155	0.000101	0.000078	0.000033	0.000034	0.000034	0.000029	0.000073	0.000150	0.000080	0.000165	0.000138	0.000274	0.000140	0.000057	0.000094	0.000107	0.000097	0.000072	0.000141	0.000079	0.000092	0.000060	0.000050	0.000086	0.000794	0.000372	0.000331	0.000019	0.000123	0.000090	0.000104	0.000136	0.000375	0.000127	0.000013	0.000681	0.000079	0.000127	0.000033	0.000398	0.000145	0.000171	0.000130	0.000392	0.000043	0.000335	0.000112	0.000098	0.000222	0.000136	0.796153	0.013364	0.003310	0.003918	0.000825	0.001479	0.000657	0.000215	0.000123	0.000579	0.000132	0.000170	0.000073	0.000069	0.000162	0.002211	0.002050	0.001613	0.000866	0.000372	0.000457	0.005829	0.018146	0.000121	0.001561	0.002186	0.004120	0.002707	0.000592	0.000515	0.000127	0.001473	0.002801	0.000052	0.000357	0.000278	0.000139	0.000077	0.000036	0.000057	0.000792	0.000159	0.000887	0.001184	0.001082	0.000357	0.000052	0.000795	0.000835	0.000222	0.000400	0.000262	0.000658	0.000059	0.000569	0.000248	0.000320	0.000223	0.002058	0.001325	0.000351	0.000243	0.000189	0.000199	0.000087	0.000242	0.000127	0.000671	0.000543	0.000244	0.000020	0.001181	0.000129	0.000131	0.000144	0.000531	0.001329	0.001774	0.000583	0.036572	0.311761	0.000537	0.003892	0.003587	0.015821	0.002792	0.010387	0.006408	0.001057	0.096642	0.020910	0.004843	0.000962	0.000621	0.000274	0.031727	0.000512	0.004747	0.013565	0.004579	0.000905	0.000200	0.011718	0.003620	0.001684	0.004042	0.001110	0.007286	0.000856	0.010592	0.000588	0.000384	0.000061	0.000068	0.018926	0.000387	0.005604	0.001531	0.000254	0.001243	0.000934	0.001044	0.001684	0.001072	0.000179	0.000184	0.002166	0.000169	0.037610	0.023624	0.006271	0.004658	0.000737	0.023789	0.000900	0.000405	0.001044	0.011410	0.000099	0.001748	0.001567	0.001727	0.007513	0.023322	0.000442	0.001339	0.000103	0.000085	0.000097	0.000032	0.000046	0.000105	0.000031	0.000031	0.000023	0.000042	0.000016	0.000057	0.000041	0.000057	0.000135	0.000029	0.000058	0.002106	0.000166	0.000034	0.000103	0.000073	0.000033	0.000155	0.000571	0.000378	0.000086	0.000147	0.000010	0.000023	0.000021	0.000101	0.000069	0.000100	0.000018	0.000110	0.000014	0.000090	0.000051	0.000181	0.000166	0.000092	0.000053	0.000198	0.000042	0.000118	0.000162	0.000052	0.000070	0.000104	0.000005	0.000043	0.000121	0.000017	0.000034	0.000044	0.000052	0.000081	0.000274	0.001206	0.000113	0.000007	0.000017	0.000014	0.000008	0.000042	0.000027	0.000003	0.000010	0.000023	0.000113	0.000230	0.000289	0.000684	0.000069	0.000193	0.000060	0.000159	0.000238	0.000010	0.000025	0.000054	0.000031	0.000082	0.000015	0.000083	0.000012	0.000038	0.000028	0.000036	0.000006	0.000012	0.000005	0.000022	0.000014	0.000086	0.000223	0.000038	0.000097	0.000147	0.000043	0.000113	0.000008	0.000140	0.000245	0.003532	0.001913	0.001097	0.001691	0.000596	0.004690	0.004145	0.000623	0.000522	0.000117	0.001696	0.005199	0.007914	0.000127	0.005415	0.000040	0.000036	0.000012	0.000206	0.000251	0.000232	0.000008	0.000003	0.000010	0.000034	0.000012	0.000027	0.000021	0.000080	0.000183	0.000114	0.000022	0.000002	0.000009	0.000013	0.000002	0.000046	0.000052	0.000441	0.000214	0.000036	0.000019	0.000083	0.000153	0.000297	0.000103	0.001468	0.000095	0.000072	0.000046	0.000616	0.000001	0.000008	0.000161	0.000131	0.000051	0.000123	0.000017	0.000020	0.000193	0.000489	0.000017	0.000185	0.000021	0.000037	0.000175	0.000008	0.000005	0.000021	0.003986	0.000296	0.000452	0.000180	0.000229	0.000989	0.002091	0.000865	0.000312	0.000606	0.000876	0.000047	0.000022	0.000043	0.000096	0.000037	0.000043	0.000242	0.000098	0.000033	0.001683	0.000002	0.000036	0.000037	0.003838	0.000240	0.000441	0.000108	0.000021	0.000012	0.000413	0.000021	0.000229	0.000022	0.000696	0.000024	0.000902	0.000642	0.000371	0.008756	0.000175	0.000224	0.000072	0.004863	0.009438	0.001782	0.001922	0.005774	0.002348	0.009658	0.003078	0.000493	0.001271	0.001252	0.002973	0.007110	0.000162	0.000247	0.006288	0.000497	0.000939	0.001860	0.000193	0.000376	0.000027	0.010582	0.000125	0.000324	0.000534	0.000108
248376163 - Fred again - Actual Life 3 (January 1 - September 9 2022) - Eyelar (shutters)	248376163	0.183003	0.000936	0.001228	0.003833	0.000235	0.000558	0.000424	0.000112	0.000422	0.000399	0.000591	0.000203	0.000089	0.000035	0.000551	0.000328	0.000626	0.000229	0.000307	0.000282	0.000238	0.000226	0.000520	0.000954	0.000975	0.000313	0.000390	0.024138	0.000413	0.000583	0.000142	0.000348	0.002224	0.005197	0.002593	0.002986	0.010763	0.002077	0.000520	0.000044	0.000184	0.000962	0.000080	0.000085	0.000605	0.000134	0.000459	0.000352	0.000232	0.000220	0.000146	0.000347	0.002189	0.000595	0.000191	0.000239	0.000138	0.000517	0.000120	0.000266	0.000213	0.000326	0.000177	0.000219	0.010227	0.009525	0.000151	0.000056	0.000154	0.000861	0.000445	0.000124	0.003974	0.002893	0.002308	0.000507	0.000626	0.000990	0.000891	0.000167	0.000575	0.000643	0.000073	0.000589	0.000308	0.000132	0.000360	0.000385	0.000362	0.000116	0.000103	0.000082	0.000166	0.000072	0.000240	0.000236	0.000844	0.000759	0.000810	0.000684	0.000323	0.000277	0.000219	0.000204	0.000216	0.000331	0.000177	0.000188	0.000078	0.000068	0.000260	0.000918	0.000320	0.000252	0.000039	0.000245	0.000228	0.000219	0.000202	0.000663	0.000315	0.000012	0.000574	0.000151	0.000179	0.000076	0.000365	0.000104	0.000099	0.000174	0.001324	0.000116	0.000153	0.000068	0.000102	0.000901	0.000184	0.659857	0.015450	0.002043	0.002307	0.000420	0.000390	0.000473	0.000116	0.000098	0.000347	0.000230	0.000329	0.000221	0.000258	0.000606	0.003893	0.003196	0.002301	0.000779	0.000519	0.000372	0.011750	0.019522	0.000261	0.001558	0.001519	0.023507	0.002576	0.000637	0.000462	0.000211	0.001115	0.000588	0.000180	0.000289	0.000250	0.000402	0.000070	0.000143	0.000159	0.001150	0.000407	0.001896	0.002771	0.002479	0.000829	0.000129	0.000440	0.000912	0.000332	0.000419	0.000258	0.000433	0.000063	0.000541	0.000554	0.000166	0.000117	0.001260	0.001236	0.000228	0.000185	0.000418	0.000416	0.000215	0.000202	0.000067	0.000187	0.000612	0.000268	0.000034	0.000224	0.000148	0.000098	0.001151	0.000404	0.001322	0.001005	0.009271	0.020302	0.049293	0.001662	0.001510	0.000543	0.001625	0.000620	0.000788	0.001185	0.000277	0.013783	0.002219	0.002155	0.000556	0.000390	0.000220	0.005041	0.000495	0.001379	0.002444	0.009166	0.000788	0.000385	0.056393	0.035127	0.011487	0.009298	0.008810	0.022528	0.018349	0.008645	0.004262	0.000721	0.000169	0.000113	0.002075	0.000937	0.001631	0.001428	0.000328	0.002158	0.004545	0.000468	0.000460	0.002356	0.000245	0.000356	0.000347	0.000295	0.005495	0.008187	0.002122	0.001595	0.000909	0.006095	0.003448	0.000253	0.000446	0.012951	0.000144	0.001424	0.001233	0.000611	0.002673	0.005372	0.000104	0.000202	0.000230	0.000240	0.000232	0.000137	0.000178	0.000623	0.000158	0.000166	0.000141	0.000211	0.000120	0.000154	0.000109	0.000221	0.000540	0.000115	0.000412	0.004440	0.000405	0.000132	0.000260	0.000127	0.000076	0.000392	0.001139	0.001731	0.000438	0.000352	0.000041	0.000075	0.000087	0.000277	0.000201	0.000319	0.000062	0.000599	0.000050	0.000584	0.000174	0.000776	0.000461	0.000496	0.000210	0.000262	0.000130	0.000482	0.000699	0.000160	0.000275	0.000378	0.000016	0.000160	0.000267	0.000041	0.000063	0.000071	0.000087	0.000165	0.000696	0.002137	0.000365	0.000026	0.000008	0.000070	0.000025	0.000132	0.000106	0.000024	0.000065	0.000092	0.000227	0.000869	0.000588	0.001142	0.000581	0.000461	0.000215	0.000876	0.000182	0.000029	0.000123	0.000278	0.000125	0.000066	0.000152	0.000229	0.000135	0.000193	0.000149	0.000267	0.000103	0.000128	0.000076	0.000091	0.000084	0.000597	0.000283	0.000084	0.000281	0.000981	0.000144	0.000142	0.000088	0.000177	0.000525	0.000291	0.000897	0.000479	0.003070	0.000724	0.001124	0.003050	0.000564	0.001313	0.000237	0.001369	0.000472	0.000463	0.000515	0.000449	0.000184	0.000292	0.000086	0.000411	0.001250	0.001263	0.000085	0.000015	0.000104	0.000176	0.000038	0.000133	0.000268	0.000173	0.000549	0.000343	0.000061	0.000008	0.000058	0.000084	0.000038	0.000140	0.000147	0.000816	0.000353	0.000118	0.000075	0.000123	0.000139	0.000266	0.000128	0.001914	0.000180	0.000103	0.000262	0.000794	0.000014	0.000081	0.000107	0.000322	0.000079	0.000561	0.000128	0.000226	0.000804	0.003014	0.000062	0.000768	0.000167	0.000236	0.001045	0.000135	0.000113	0.000090	0.002833	0.000299	0.002282	0.000383	0.000145	0.000750	0.001783	0.000468	0.001827	0.000407	0.000565	0.000143	0.000088	0.000053	0.000699	0.000114	0.000304	0.009038	0.000853	0.000218	0.000970	0.000031	0.000075	0.000057	0.002378	0.002081	0.000505	0.000128	0.000020	0.000055	0.001181	0.000059	0.000986	0.000180	0.000227	0.000125	0.000417	0.000624	0.000343	0.077667	0.001736	0.000382	0.000138	0.007723	0.002041	0.001628	0.000648	0.014990	0.027338	0.014916	0.006986	0.002003	0.003188	0.002230	0.004857	0.007657	0.000168	0.000122	0.018183	0.004443	0.000837	0.010113	0.000678	0.001048	0.000166	0.075395	0.000334	0.001149	0.001414	0.000144
248376168 - Fred again - Actual Life 3 (January 1 - September 9 2022) - Nathan (still breathing)	248376168	0.039483	0.000441	0.000780	0.002428	0.000114	0.000361	0.000402	0.000177	0.000227	0.000162	0.000242	0.000104	0.000151	0.000037	0.000476	0.000966	0.000570	0.000372	0.000391	0.000180	0.000253	0.000203	0.000286	0.000344	0.000505	0.000499	0.001103	0.022691	0.000581	0.000453	0.000465	0.001006	0.002064	0.006434	0.001850	0.001601	0.001842	0.002219	0.000632	0.000058	0.000498	0.000498	0.000092	0.000071	0.000665	0.000091	0.000275	0.000558	0.000340	0.001112	0.000104	0.000168	0.000184	0.000343	0.000364	0.000248	0.000066	0.000189	0.000227	0.000338	0.000185	0.000170	0.000119	0.000238	0.020060	0.026553	0.000146	0.000051	0.000025	0.000473	0.000086	0.000020	0.005150	0.004294	0.002960	0.001172	0.000640	0.001233	0.000756	0.000328	0.000502	0.000574	0.000109	0.000410	0.000161	0.000094	0.000289	0.000237	0.000231	0.000072	0.000069	0.000064	0.000055	0.000172	0.000265	0.000112	0.000213	0.000164	0.000855	0.000472	0.000247	0.000375	0.000153	0.000156	0.000247	0.000291	0.000351	0.000360	0.000094	0.000070	0.000323	0.001645	0.000639	0.000446	0.000232	0.000211	0.000152	0.000332	0.000290	0.001849	0.000606	0.000065	0.000998	0.000297	0.000128	0.000161	0.000441	0.000203	0.000085	0.000167	0.001460	0.000119	0.000338	0.000182	0.000052	0.000411	0.000226	0.663008	0.012434	0.001539	0.002099	0.000437	0.000418	0.000426	0.000104	0.000142	0.000332	0.000098	0.000101	0.000075	0.000107	0.000354	0.002387	0.001607	0.001086	0.000894	0.000812	0.000393	0.017499	0.023285	0.000089	0.001387	0.002023	0.015993	0.002707	0.000829	0.000608	0.000342	0.001577	0.000508	0.000100	0.000463	0.000370	0.000260	0.000120	0.000059	0.000074	0.000553	0.000119	0.000528	0.000743	0.000683	0.000333	0.000081	0.000536	0.000798	0.000529	0.000298	0.000247	0.000440	0.000100	0.000435	0.000242	0.000243	0.000173	0.000752	0.000443	0.000104	0.000168	0.000146	0.000336	0.000114	0.000259	0.000321	0.000216	0.000236	0.000113	0.000016	0.000295	0.000192	0.000037	0.000921	0.000143	0.001767	0.001063	0.000739	0.017388	0.009702	0.000876	0.002162	0.000864	0.001301	0.001100	0.001165	0.000918	0.000212	0.008038	0.001743	0.001105	0.000389	0.000208	0.000105	0.002862	0.000319	0.000898	0.001783	0.008192	0.000626	0.000335	0.180597	0.050039	0.021572	0.063955	0.039499	0.059338	0.050052	0.019113	0.037900	0.000726	0.000156	0.000103	0.002473	0.001420	0.002572	0.002335	0.000888	0.001701	0.001509	0.000991	0.000549	0.002150	0.000159	0.000085	0.000341	0.000254	0.007667	0.007890	0.002508	0.002017	0.001001	0.007484	0.005353	0.000402	0.000849	0.014622	0.000154	0.000911	0.000391	0.000572	0.002222	0.005364	0.000289	0.000275	0.000311	0.000210	0.000305	0.000229	0.000270	0.000691	0.000223	0.000176	0.000184	0.000179	0.000090	0.000144	0.000120	0.000165	0.000369	0.000110	0.000215	0.003047	0.000310	0.000094	0.000218	0.000114	0.000059	0.000191	0.000830	0.000661	0.000172	0.000147	0.000018	0.000071	0.000116	0.000127	0.000269	0.000188	0.000052	0.000242	0.000035	0.000045	0.000062	0.000269	0.000249	0.000132	0.000081	0.000256	0.000059	0.000466	0.000577	0.000158	0.000271	0.000412	0.000019	0.000179	0.000265	0.000053	0.000078	0.000085	0.000104	0.000182	0.000712	0.000542	0.000300	0.000014	0.000040	0.000059	0.000061	0.000109	0.000084	0.000029	0.000057	0.000093	0.000226	0.000496	0.000143	0.000508	0.000173	0.000166	0.000129	0.000609	0.000717	0.000025	0.000062	0.000303	0.000169	0.000027	0.000093	0.000133	0.000172	0.000246	0.000171	0.000486	0.000051	0.000118	0.000022	0.000097	0.000084	0.000257	0.000270	0.000095	0.000103	0.000207	0.000041	0.000191	0.000091	0.000211	0.000169	0.001751	0.000551	0.000452	0.001521	0.000212	0.000643	0.002798	0.000468	0.000745	0.000098	0.001106	0.001883	0.003932	0.000348	0.001045	0.000131	0.000276	0.000152	0.000093	0.000199	0.000214	0.000133	0.000039	0.000077	0.000142	0.000022	0.000104	0.000087	0.000104	0.000250	0.000453	0.000058	0.000011	0.000055	0.000178	0.000041	0.000218	0.000253	0.000467	0.000479	0.000162	0.000084	0.000064	0.000387	0.000461	0.000231	0.001117	0.000142	0.000192	0.000220	0.000138	0.000009	0.000108	0.000122	0.000175	0.000065	0.000368	0.000160	0.000141	0.000469	0.001260	0.000064	0.000281	0.000106	0.000157	0.000404	0.000068	0.000080	0.000047	0.001678	0.000126	0.000863	0.000436	0.000299	0.000317	0.001036	0.000768	0.000172	0.000207	0.000379	0.000104	0.000051	0.000103	0.000126	0.000103	0.000132	0.000273	0.000241	0.000334	0.000689	0.000026	0.000137	0.000092	0.001870	0.000635	0.000621	0.000216	0.000034	0.000040	0.000659	0.000059	0.000448	0.000093	0.000253	0.000118	0.000480	0.000462	0.000183	0.057232	0.001109	0.000249	0.000161	0.001915	0.002557	0.002154	0.000940	0.010197	0.007272	0.010251	0.004979	0.000662	0.001454	0.001538	0.004688	0.010458	0.000090	0.000111	0.004569	0.001427	0.000553	0.003445	0.000261	0.000357	0.000077	0.099540	0.000262	0.000236	0.000268	0.000080
204870678 - Lorde - The Love Club EP - Bravado	204870678	0.016522	0.000580	0.000601	0.001244	0.000140	0.000349	0.000273	0.000083	0.000192	0.000394	0.000253	0.000148	0.000372	0.000120	0.000276	0.000803	0.000318	0.000173	0.000243	0.000105	0.000169	0.000113	0.000265	0.000317	0.000365	0.000275	0.000692	0.081541	0.014686	0.000508	0.005069	0.001702	0.001984	0.006961	0.000855	0.001595	0.004261	0.007946	0.000587	0.000056	0.000444	0.001090	0.000152	0.000090	0.001538	0.000099	0.000535	0.000261	0.000323	0.000835	0.000056	0.000045	0.000014	0.000108	0.000292	0.000096	0.000056	0.000180	0.000168	0.000302	0.000122	0.000211	0.000205	0.000185	0.004354	0.002666	0.000184	0.000018	0.000044	0.000411	0.000042	0.000018	0.002800	0.002235	0.001478	0.000412	0.000311	0.000522	0.000385	0.000285	0.000298	0.000430	0.000098	0.000316	0.000223	0.000085	0.000207	0.000185	0.000144	0.000088	0.000052	0.000051	0.000019	0.000075	0.000132	0.000120	0.000197	0.000153	0.000620	0.000304	0.000161	0.000269	0.000121	0.000119	0.000127	0.000177	0.000211	0.000186	0.000100	0.000091	0.000281	0.001124	0.000554	0.000435	0.000040	0.000135	0.000091	0.000270	0.000296	0.001025	0.000319	0.000017	0.000419	0.000181	0.000154	0.000088	0.000812	0.000585	0.000180	0.000209	0.000295	0.000131	0.000225	0.000120	0.000094	0.000132	0.000218	0.680020	0.030133	0.004367	0.006076	0.001400	0.002706	0.000627	0.000321	0.000275	0.000438	0.000078	0.000035	0.000131	0.000167	0.000209	0.007949	0.005986	0.005283	0.003646	0.003391	0.001611	0.031094	0.015023	0.000262	0.002352	0.004402	0.007389	0.004475	0.001581	0.001077	0.000438	0.003173	0.000973	0.000033	0.001184	0.000905	0.000097	0.000043	0.000043	0.000078	0.009482	0.000218	0.000862	0.001262	0.001181	0.000450	0.000056	0.000682	0.000702	0.000298	0.000297	0.000196	0.000648	0.000059	0.000816	0.000435	0.000212	0.000176	0.001626	0.000644	0.000186	0.000440	0.000758	0.000384	0.000204	0.000147	0.000054	0.001155	0.000554	0.000191	0.000033	0.000625	0.000314	0.000179	0.000317	0.000607	0.012637	0.019548	0.000211	0.037295	0.018337	0.000361	0.005784	0.004324	0.002473	0.004004	0.005042	0.001534	0.000398	0.033348	0.013074	0.000936	0.000534	0.000197	0.000135	0.009436	0.000543	0.000800	0.002488	0.002017	0.001015	0.001723	0.021586	0.001736	0.001112	0.004761	0.001965	0.004410	0.000832	0.045138	0.000894	0.000485	0.000072	0.000108	0.002697	0.001899	0.005454	0.008882	0.017263	0.001153	0.000466	0.015138	0.017670	0.002281	0.000085	0.000172	0.000555	0.000259	0.015932	0.021534	0.002193	0.002589	0.004060	0.006844	0.001949	0.000525	0.005196	0.002740	0.000224	0.002304	0.000773	0.000514	0.003516	0.007390	0.000886	0.000371	0.000249	0.000113	0.000227	0.000121	0.000161	0.000273	0.000112	0.000075	0.000087	0.000090	0.000067	0.000090	0.000084	0.000174	0.000216	0.000055	0.000094	0.002364	0.000231	0.000053	0.000129	0.000095	0.000037	0.000210	0.000696	0.000982	0.000192	0.000259	0.000010	0.000048	0.000063	0.000091	0.000137	0.000234	0.000043	0.000257	0.000021	0.000030	0.000076	0.000882	0.001061	0.000365	0.000188	0.000220	0.000057	0.000318	0.000415	0.000142	0.000131	0.000282	0.000011	0.000083	0.000136	0.000037	0.000076	0.000054	0.000047	0.000113	0.000195	0.000141	0.000220	0.000015	0.000017	0.000037	0.000026	0.000090	0.000061	0.000012	0.000034	0.000060	0.000174	0.000183	0.000147	0.000353	0.000075	0.000149	0.000074	0.000126	0.000305	0.000023	0.000038	0.000088	0.000050	0.000038	0.000028	0.000073	0.000049	0.000110	0.000076	0.000127	0.000043	0.000029	0.000013	0.000043	0.000067	0.000110	0.000173	0.000022	0.000114	0.000085	0.000036	0.000138	0.000030	0.000176	0.000307	0.001222	0.000738	0.000397	0.001016	0.000162	0.002211	0.003006	0.000375	0.002261	0.000278	0.000685	0.000933	0.002426	0.000208	0.000687	0.000113	0.000096	0.000043	0.000110	0.000207	0.000209	0.000038	0.000016	0.000060	0.000126	0.000022	0.000035	0.000058	0.000091	0.000333	0.000230	0.000032	0.000009	0.000018	0.000063	0.000022	0.000106	0.000120	0.000307	0.000562	0.000153	0.000062	0.000036	0.000326	0.000121	0.000112	0.000496	0.000086	0.000093	0.000069	0.000130	0.000005	0.000033	0.000118	0.000084	0.000044	0.000146	0.000036	0.000040	0.000268	0.000322	0.000011	0.000136	0.000059	0.000059	0.000483	0.000032	0.000008	0.000024	0.002071	0.000202	0.000440	0.000144	0.000158	0.003232	0.013468	0.017715	0.000219	0.000109	0.000331	0.000091	0.000035	0.000074	0.000071	0.000070	0.000039	0.000150	0.000103	0.000125	0.000571	0.000014	0.000049	0.000062	0.000930	0.000133	0.000191	0.000090	0.000025	0.000018	0.000231	0.000045	0.000226	0.000030	0.000306	0.000077	0.000369	0.000333	0.000233	0.006366	0.000625	0.000338	0.000188	0.004363	0.032832	0.004895	0.012890	0.003711	0.000142	0.011607	0.004700	0.000423	0.001072	0.001394	0.004979	0.013316	0.000197	0.000225	0.001632	0.000351	0.004402	0.000607	0.000144	0.000285	0.000058	0.003745	0.000112	0.000242	0.000425	0.000042
78475917 - ODESZA - A Moment Apart - Across The Room (feat. Leon Bridges)	78475917	0.027152	0.000540	0.000248	0.000729	0.000094	0.000293	0.000246	0.000067	0.000144	0.000126	0.000178	0.000106	0.000026	0.000041	0.000737	0.000579	0.000662	0.000385	0.000326	0.000153	0.000297	0.000110	0.000501	0.000613	0.000662	0.000227	0.000151	0.049023	0.000235	0.000100	0.000108	0.000145	0.001542	0.001187	0.000208	0.000310	0.003372	0.000237	0.000273	0.000020	0.001206	0.000421	0.000156	0.000101	0.000443	0.000049	0.000260	0.000263	0.000222	0.000319	0.000128	0.000065	0.000010	0.000130	0.000234	0.000147	0.000019	0.000153	0.000152	0.000189	0.000084	0.000051	0.000025	0.000056	0.001451	0.000900	0.000099	0.000028	0.000038	0.000262	0.000062	0.000034	0.004028	0.003130	0.002074	0.000694	0.000504	0.000692	0.000583	0.000218	0.000380	0.000464	0.000174	0.000235	0.000162	0.000110	0.000355	0.000167	0.000146	0.000082	0.000066	0.000063	0.000139	0.000179	0.000237	0.000235	0.000323	0.000289	0.000932	0.000552	0.000259	0.000564	0.000181	0.000168	0.000131	0.000200	0.000234	0.000222	0.000056	0.000043	0.000117	0.001405	0.000565	0.000458	0.000098	0.000177	0.000128	0.000180	0.000203	0.000485	0.000100	0.000040	0.000662	0.000225	0.000208	0.000133	0.000434	0.000330	0.000149	0.000141	0.000227	0.000079	0.000406	0.000160	0.000069	0.000277	0.000063	0.656883	0.041446	0.004074	0.005622	0.001469	0.002437	0.000768	0.001306	0.000191	0.000605	0.000112	0.000064	0.000149	0.000306	0.000117	0.029403	0.028181	0.037728	0.003359	0.002529	0.001274	0.043092	0.020325	0.000785	0.005021	0.010110	0.008786	0.010214	0.003464	0.002685	0.000566	0.006778	0.001385	0.000049	0.001978	0.001490	0.000211	0.000055	0.000062	0.000076	0.002200	0.000693	0.003656	0.004373	0.004999	0.001229	0.000127	0.000839	0.001338	0.000716	0.000880	0.000332	0.000913	0.000067	0.001107	0.000790	0.000505	0.000370	0.001752	0.001214	0.000411	0.000582	0.000729	0.000922	0.000318	0.000334	0.000580	0.000698	0.002529	0.001022	0.000038	0.000718	0.000200	0.000119	0.000081	0.000688	0.005395	0.004190	0.000165	0.043253	0.017184	0.000063	0.006673	0.002089	0.004069	0.010942	0.008663	0.002581	0.001807	0.075128	0.042336	0.001558	0.001741	0.000563	0.000430	0.014750	0.000447	0.002123	0.005324	0.002062	0.001353	0.000528	0.015426	0.003283	0.000984	0.003533	0.001883	0.008014	0.001338	0.077632	0.000726	0.000350	0.000095	0.000078	0.008612	0.000609	0.008149	0.000288	0.000078	0.000873	0.000720	0.003988	0.003907	0.002251	0.000067	0.000627	0.000645	0.000171	0.065506	0.017509	0.005264	0.002698	0.000919	0.008803	0.002475	0.000295	0.001649	0.005104	0.000741	0.003272	0.000486	0.003942	0.014417	0.008332	0.000207	0.000160	0.000142	0.000121	0.000119	0.000050	0.000064	0.000276	0.000069	0.000078	0.000061	0.000096	0.000038	0.000064	0.000052	0.000119	0.000208	0.000069	0.000132	0.002345	0.000263	0.000059	0.000127	0.000111	0.000027	0.000128	0.000580	0.000528	0.000080	0.000304	0.000010	0.000038	0.000041	0.000089	0.000105	0.000134	0.000039	0.000114	0.000026	0.000142	0.000041	0.000480	0.000502	0.000216	0.000114	0.000209	0.000032	0.000170	0.000209	0.000078	0.000075	0.000157	0.000008	0.000027	0.000152	0.000025	0.000044	0.000044	0.000061	0.000103	0.000474	0.000475	0.000216	0.000007	0.000047	0.000035	0.000020	0.000070	0.000048	0.000010	0.000034	0.000052	0.000133	0.000146	0.000560	0.001899	0.000063	0.000081	0.000065	0.000120	0.000423	0.000011	0.000035	0.000106	0.000082	0.000028	0.000044	0.000085	0.000028	0.000100	0.000066	0.000071	0.000010	0.000035	0.000013	0.000020	0.000027	0.000103	0.000450	0.000088	0.000086	0.000078	0.000030	0.000117	0.000029	0.000141	0.000154	0.007854	0.002124	0.001431	0.004722	0.000358	0.004368	0.002288	0.003403	0.001310	0.000188	0.002591	0.010431	0.012050	0.000139	0.002467	0.000103	0.000108	0.000059	0.000741	0.000358	0.000438	0.000044	0.000017	0.000031	0.000056	0.000012	0.000060	0.000038	0.000177	0.000311	0.000222	0.000016	0.000017	0.000019	0.000064	0.000010	0.000094	0.000121	0.000284	0.000227	0.000078	0.000031	0.000044	0.000148	0.000209	0.000107	0.000620	0.000090	0.000046	0.000077	0.000169	0.000003	0.000015	0.000277	0.000256	0.000056	0.000212	0.000049	0.000039	0.000262	0.000457	0.000018	0.000137	0.000035	0.000077	0.000404	0.000031	0.000023	0.000034	0.001520	0.000113	0.000251	0.000064	0.000096	0.003719	0.012048	0.007319	0.000115	0.000076	0.000146	0.000026	0.000019	0.000052	0.000046	0.000039	0.000055	0.000206	0.000098	0.000103	0.000966	0.000012	0.000092	0.000067	0.004223	0.000421	0.000770	0.000200	0.000103	0.000013	0.000274	0.000027	0.000226	0.000055	0.000167	0.000032	0.000139	0.000109	0.000356	0.002683	0.001094	0.000305	0.000136	0.003254	0.011517	0.003553	0.007025	0.003522	0.000512	0.011594	0.003545	0.000573	0.001582	0.001616	0.004296	0.033497	0.000156	0.000205	0.002053	0.000165	0.004470	0.002489	0.000152	0.000216	0.000030	0.003214	0.000100	0.000269	0.000598	0.000058
32904103 - ODESZA - In Return - White Lies (feat. Jenni Potts)	32904103	0.029087	0.000302	0.000417	0.002313	0.000076	0.000225	0.000253	0.000104	0.000300	0.000139	0.000224	0.000087	0.000055	0.000063	0.000555	0.000515	0.000632	0.000303	0.000293	0.000157	0.000226	0.000132	0.000683	0.000586	0.000606	0.000172	0.000240	0.017776	0.000174	0.000467	0.000063	0.000140	0.000366	0.001074	0.000444	0.000783	0.009705	0.000459	0.000408	0.000027	0.000835	0.000261	0.000059	0.000074	0.000149	0.000061	0.000160	0.000212	0.000114	0.000425	0.000041	0.000077	0.000031	0.000139	0.000622	0.000230	0.000080	0.000065	0.000116	0.000154	0.000188	0.000174	0.000117	0.000126	0.000545	0.000549	0.000143	0.000017	0.000074	0.000540	0.000095	0.000077	0.004463	0.003321	0.002190	0.000532	0.000393	0.001916	0.000421	0.000197	0.000344	0.000475	0.000111	0.000321	0.000310	0.000111	0.000349	0.000109	0.000096	0.000040	0.000082	0.000083	0.000125	0.000207	0.000257	0.000226	0.000326	0.000283	0.000710	0.000402	0.000251	0.000276	0.000190	0.000178	0.000182	0.000227	0.000184	0.000189	0.000054	0.000035	0.000129	0.001867	0.000954	0.000990	0.000078	0.000140	0.000112	0.000156	0.000170	0.000533	0.000209	0.000036	0.000845	0.000587	0.000620	0.000221	0.001589	0.000956	0.000595	0.000459	0.000923	0.000176	0.000648	0.000277	0.000109	0.000494	0.000101	0.708490	0.020908	0.001688	0.002308	0.000503	0.000498	0.000329	0.000241	0.000174	0.000289	0.000189	0.000284	0.000200	0.000293	0.000187	0.005887	0.004149	0.003453	0.002615	0.002460	0.001000	0.032643	0.030783	0.000314	0.003642	0.003971	0.026262	0.005196	0.001387	0.000993	0.000388	0.002764	0.000343	0.000096	0.000643	0.000563	0.000413	0.000146	0.000198	0.000244	0.000452	0.000907	0.021531	0.024618	0.028582	0.004802	0.000237	0.001385	0.001999	0.001244	0.000971	0.000526	0.000810	0.000131	0.001472	0.000436	0.000312	0.000175	0.005172	0.004479	0.000447	0.001124	0.000302	0.000680	0.000138	0.000712	0.000423	0.000961	0.013603	0.006223	0.000027	0.001104	0.000838	0.000321	0.000469	0.001898	0.010782	0.006938	0.002195	0.036277	0.065127	0.000219	0.002448	0.000898	0.001513	0.001603	0.002010	0.001292	0.000282	0.024750	0.004458	0.005165	0.000429	0.000763	0.000192	0.011829	0.000458	0.001418	0.002657	0.012801	0.001520	0.000387	0.132341	0.031346	0.007343	0.063309	0.044037	0.053356	0.024690	0.030822	0.008039	0.000799	0.000204	0.000061	0.002890	0.001619	0.005243	0.000337	0.000098	0.004118	0.007333	0.000817	0.000527	0.002801	0.000218	0.000293	0.000755	0.000476	0.006717	0.007429	0.005786	0.003600	0.001247	0.010482	0.001151	0.000821	0.000842	0.021502	0.000174	0.001672	0.001213	0.000475	0.003109	0.010422	0.000141	0.000138	0.000154	0.000217	0.000140	0.000040	0.000048	0.000446	0.000075	0.000079	0.000058	0.000121	0.000050	0.000090	0.000071	0.000227	0.000224	0.000079	0.000166	0.002784	0.000268	0.000060	0.000141	0.000082	0.000042	0.000223	0.000673	0.000613	0.000177	0.000259	0.000024	0.000029	0.000069	0.000082	0.000116	0.000235	0.000049	0.000373	0.000038	0.000308	0.000103	0.000678	0.000536	0.000494	0.000191	0.000275	0.000081	0.000250	0.000315	0.000094	0.000140	0.000211	0.000015	0.000058	0.000147	0.000029	0.000046	0.000049	0.000040	0.000101	0.000776	0.000314	0.000318	0.000010	0.000028	0.000071	0.000034	0.000104	0.000062	0.000018	0.000052	0.000062	0.000156	0.000319	0.000287	0.002608	0.000106	0.000119	0.000118	0.000232	0.000994	0.000014	0.000046	0.000237	0.000185	0.000048	0.000045	0.000117	0.000045	0.000158	0.000120	0.000140	0.000023	0.000071	0.000063	0.000060	0.000059	0.000284	0.000903	0.000161	0.000468	0.000219	0.000053	0.000297	0.000094	0.000349	0.000219	0.002152	0.000857	0.000617	0.003186	0.000530	0.001623	0.002688	0.001103	0.002356	0.000698	0.001425	0.004579	0.002058	0.000426	0.001754	0.000118	0.000455	0.000219	0.000725	0.000536	0.000583	0.000208	0.000081	0.000074	0.000101	0.000023	0.000137	0.000084	0.000698	0.000762	0.000516	0.000053	0.000015	0.000028	0.000100	0.000017	0.000176	0.000184	0.000320	0.000483	0.000114	0.000058	0.000046	0.000485	0.000248	0.000149	0.001345	0.000040	0.000063	0.000114	0.000279	0.000006	0.000055	0.001088	0.000910	0.000210	0.000384	0.000085	0.000085	0.000632	0.001687	0.000042	0.000185	0.000071	0.000135	0.001113	0.000045	0.000039	0.000031	0.001423	0.000220	0.000609	0.000101	0.000183	0.000625	0.003402	0.001028	0.000292	0.000163	0.000279	0.000072	0.000078	0.000119	0.000072	0.000078	0.000063	0.001016	0.000164	0.000143	0.000811	0.000023	0.000103	0.000088	0.003835	0.000388	0.001607	0.000185	0.000069	0.000073	0.000460	0.000040	0.000306	0.000071	0.000413	0.000046	0.000059	0.000588	0.002626	0.004789	0.005781	0.000421	0.000292	0.004488	0.021326	0.001700	0.011388	0.005769	0.003130	0.011385	0.003569	0.000704	0.001882	0.001960	0.001968	0.009981	0.000371	0.000434	0.004878	0.000356	0.001167	0.001620	0.000290	0.000371	0.000057	0.005028	0.000176	0.000539	0.000530	0.000037
157751888 - Bicep - Isles - Atlas	157751888	0.018709	0.000225	0.000296	0.000811	0.000053	0.000166	0.000250	0.000047	0.000314	0.000154	0.000238	0.000080	0.000218	0.000116	0.000560	0.000198	0.000609	0.000169	0.000242	0.000224	0.000284	0.000162	0.000519	0.000616	0.000458	0.000118	0.000061	0.001912	0.000332	0.000417	0.000108	0.000134	0.000160	0.000403	0.000166	0.000371	0.000570	0.000195	0.000183	0.000028	0.000432	0.000244	0.000099	0.000256	0.000128	0.000060	0.000300	0.000195	0.000074	0.000251	0.000125	0.000093	0.000024	0.000125	0.000226	0.000139	0.000021	0.000033	0.000086	0.000256	0.000151	0.000203	0.000063	0.000341	0.000095	0.000167	0.000266	0.000047	0.000095	0.000725	0.000067	0.000048	0.004268	0.003043	0.002424	0.000504	0.000529	0.001595	0.000497	0.000165	0.000440	0.000474	0.000138	0.000200	0.000301	0.000071	0.000230	0.000219	0.000188	0.000090	0.000078	0.000073	0.000060	0.000098	0.000126	0.000139	0.000157	0.000138	0.000705	0.000380	0.000216	0.000244	0.000148	0.000152	0.000094	0.000095	0.000225	0.000233	0.000117	0.000067	0.000127	0.001015	0.000368	0.000295	0.000011	0.000147	0.000095	0.000096	0.000076	0.000239	0.000134	0.000025	0.000783	0.000111	0.000143	0.000088	0.000735	0.000257	0.000193	0.000289	0.000868	0.000174	0.000195	0.000063	0.000094	0.000377	0.000165	0.764047	0.056551	0.002419	0.002550	0.000692	0.000321	0.000370	0.000157	0.000294	0.000406	0.000356	0.000389	0.000215	0.000222	0.000091	0.016604	0.011027	0.006012	0.002124	0.001675	0.000677	0.078378	0.057222	0.000691	0.001724	0.004439	0.021174	0.007156	0.001190	0.000875	0.000508	0.003261	0.000122	0.000256	0.000811	0.000677	0.000397	0.000130	0.000055	0.000085	0.000319	0.000062	0.000440	0.000646	0.000540	0.000182	0.000041	0.000768	0.002519	0.000984	0.001744	0.000424	0.001072	0.000161	0.003405	0.000387	0.000362	0.000163	0.018416	0.016627	0.000737	0.002479	0.000265	0.000216	0.000124	0.000056	0.000019	0.000197	0.000240	0.000141	0.000093	0.001081	0.000800	0.001966	0.000662	0.009565	0.027688	0.002202	0.000661	0.005633	0.011874	0.000151	0.001483	0.000782	0.000348	0.000190	0.000762	0.000404	0.000096	0.004937	0.001640	0.001121	0.000349	0.000164	0.000176	0.002203	0.000669	0.001277	0.001871	0.002816	0.002084	0.000559	0.257223	0.018653	0.015000	0.079657	0.478968	0.093700	0.025453	0.058284	0.025706	0.000272	0.000167	0.000074	0.001330	0.000134	0.009600	0.000314	0.000129	0.001559	0.002887	0.000258	0.000484	0.000474	0.000418	0.000317	0.000139	0.000883	0.001098	0.001726	0.005688	0.004778	0.000381	0.009433	0.000481	0.002199	0.000149	0.005421	0.000243	0.000755	0.000496	0.001214	0.002453	0.003315	0.000191	0.000475	0.000146	0.000182	0.000121	0.000021	0.000028	0.000323	0.000057	0.000049	0.000043	0.000116	0.000062	0.000099	0.000071	0.000217	0.000181	0.000079	0.000120	0.002530	0.000222	0.000038	0.000094	0.000114	0.000045	0.000283	0.000811	0.000814	0.000144	0.000378	0.000024	0.000053	0.000081	0.000098	0.000137	0.000353	0.000037	0.000861	0.000039	0.000100	0.000064	0.001301	0.000873	0.000837	0.000407	0.000192	0.000080	0.000215	0.000270	0.000075	0.000073	0.000180	0.000005	0.000037	0.000160	0.000024	0.000052	0.000055	0.000098	0.000088	0.000145	0.000108	0.000266	0.000024	0.000022	0.000136	0.000057	0.000112	0.000059	0.000020	0.000047	0.000073	0.000140	0.000313	0.000092	0.000147	0.000140	0.000106	0.000084	0.000315	0.000278	0.000012	0.000086	0.000117	0.000055	0.000118	0.000060	0.000069	0.000043	0.000107	0.000070	0.000101	0.000095	0.000039	0.000028	0.000050	0.000110	0.000156	0.000183	0.000040	0.000083	0.000347	0.000051	0.000177	0.000070	0.000206	0.000195	0.001334	0.000378	0.000115	0.001979	0.000283	0.000874	0.000607	0.000423	0.007160	0.002985	0.001553	0.001190	0.001727	0.000375	0.002294	0.000165	0.000109	0.000047	0.000235	0.000362	0.000381	0.000044	0.000013	0.000082	0.000067	0.000016	0.000072	0.000147	0.000107	0.000210	0.000398	0.000042	0.000012	0.000047	0.000070	0.000013	0.000163	0.000125	0.000125	0.000172	0.000051	0.000019	0.000022	0.000155	0.000109	0.000052	0.000316	0.000027	0.000017	0.000208	0.000480	0.000019	0.000021	0.000116	0.000073	0.000020	0.000261	0.000062	0.000063	0.000401	0.000700	0.000027	0.000126	0.000050	0.000096	0.000482	0.000059	0.000029	0.000034	0.001459	0.000086	0.000314	0.000080	0.000060	0.000436	0.003496	0.000788	0.000095	0.000055	0.000125	0.000038	0.000038	0.000034	0.000142	0.000068	0.000062	0.000409	0.000090	0.000136	0.000355	0.000013	0.000056	0.000033	0.002152	0.000191	0.000059	0.000026	0.000019	0.000014	0.000558	0.000024	0.000282	0.000082	0.000174	0.000043	0.000072	0.000274	0.000070	0.003790	0.002163	0.000133	0.000075	0.002808	0.006798	0.002456	0.001293	0.004177	0.003372	0.009707	0.003040	0.000531	0.001103	0.001449	0.001272	0.005233	0.000546	0.000190	0.004105	0.000552	0.001169	0.000278	0.000685	0.000631	0.000055	0.002545	0.000199	0.000324	0.000326	0.000039
157751889 - Bicep - Isles - Cazenove	157751889	0.016245	0.000127	0.000190	0.000396	0.000048	0.000145	0.000108	0.000041	0.000120	0.000043	0.000094	0.000031	0.000031	0.000040	0.000143	0.000242	0.000175	0.000063	0.000075	0.000045	0.000062	0.000043	0.000194	0.000159	0.000117	0.000054	0.000071	0.001167	0.000150	0.000051	0.000066	0.000083	0.000117	0.000180	0.000068	0.000051	0.000843	0.000219	0.000108	0.000024	0.000396	0.000232	0.000037	0.000160	0.000037	0.000035	0.000228	0.000090	0.000035	0.000111	0.000044	0.000059	0.000021	0.000224	0.000497	0.000303	0.000006	0.000118	0.000041	0.000096	0.000158	0.000090	0.000059	0.000079	0.000192	0.000456	0.000119	0.000031	0.000030	0.000492	0.000062	0.000014	0.002338	0.001125	0.000706	0.000114	0.000100	0.000292	0.000111	0.000067	0.000102	0.000298	0.000158	0.000122	0.000337	0.000050	0.000414	0.000191	0.000172	0.000048	0.000107	0.000102	0.000678	0.000123	0.000105	0.000136	0.000122	0.000134	0.000554	0.000258	0.000141	0.000136	0.000209	0.000195	0.000115	0.000096	0.000150	0.000133	0.000119	0.000060	0.000107	0.001301	0.000591	0.000521	0.000024	0.000128	0.000089	0.000086	0.000079	0.000151	0.000044	0.000040	0.000254	0.000219	0.000297	0.000199	0.002601	0.000934	0.000993	0.001171	0.001733	0.000477	0.000352	0.000091	0.000202	0.000827	0.000060	0.792159	0.095291	0.002450	0.002710	0.000579	0.000479	0.000468	0.000176	0.000164	0.000485	0.000214	0.000325	0.000134	0.000254	0.000172	0.016369	0.011063	0.008665	0.000685	0.000760	0.000240	0.108210	0.096213	0.000945	0.005910	0.017935	0.191523	0.028034	0.003944	0.003345	0.001171	0.013052	0.000173	0.000168	0.002294	0.002240	0.000627	0.000504	0.000111	0.000157	0.000126	0.000286	0.001257	0.001999	0.001528	0.000426	0.000065	0.000627	0.000802	0.000247	0.000527	0.000201	0.000894	0.000123	0.001984	0.000476	0.000335	0.000168	0.001726	0.001415	0.000219	0.000212	0.000267	0.000486	0.000176	0.000281	0.000093	0.000202	0.001440	0.001234	0.000061	0.000194	0.000112	0.000462	0.000166	0.000981	0.006660	0.000497	0.000778	0.007328	0.023064	0.000088	0.001880	0.000788	0.000780	0.000344	0.001250	0.000731	0.000203	0.011833	0.002921	0.001602	0.000505	0.000351	0.000174	0.003712	0.000625	0.001871	0.002901	0.005245	0.001462	0.000126	0.223264	0.032221	0.051882	0.073523	0.239783	0.133838	0.032570	0.010013	0.037370	0.000284	0.000140	0.000057	0.003197	0.000304	0.004334	0.000187	0.000062	0.001372	0.002533	0.000395	0.000591	0.000386	0.000273	0.000189	0.000249	0.000579	0.002378	0.000975	0.007878	0.005036	0.000847	0.014149	0.000746	0.005607	0.000323	0.007248	0.000208	0.001656	0.000789	0.001188	0.003187	0.007415	0.000049	0.000174	0.000224	0.000284	0.000180	0.000021	0.000027	0.000234	0.000062	0.000056	0.000048	0.000091	0.000021	0.000080	0.000054	0.000200	0.000152	0.000092	0.000233	0.002455	0.000361	0.000054	0.000142	0.000144	0.000063	0.000224	0.000687	0.000490	0.000116	0.000430	0.000030	0.000030	0.000052	0.000081	0.000114	0.000181	0.000037	0.000542	0.000054	0.000066	0.000055	0.000474	0.000385	0.000279	0.000190	0.000156	0.000051	0.000200	0.000288	0.000080	0.000117	0.000171	0.000005	0.000026	0.000149	0.000017	0.000046	0.000045	0.000089	0.000092	0.000322	0.000060	0.000212	0.000004	0.000073	0.000039	0.000064	0.000090	0.000052	0.000017	0.000052	0.000060	0.000150	0.000311	0.000191	0.000565	0.000124	0.000071	0.000141	0.000194	0.000349	0.000015	0.000060	0.000149	0.000099	0.000052	0.000064	0.000106	0.000022	0.000105	0.000082	0.000034	0.000017	0.000045	0.000048	0.000126	0.000030	0.000196	0.000908	0.000185	0.000332	0.000431	0.000049	0.000373	0.000132	0.000459	0.000301	0.004256	0.000883	0.000292	0.011823	0.000370	0.000938	0.000865	0.001223	0.003298	0.001308	0.005820	0.011422	0.011743	0.000174	0.001802	0.000130	0.000361	0.000197	0.000413	0.000428	0.000439	0.000158	0.000058	0.000052	0.000071	0.000009	0.000126	0.000149	0.000342	0.000459	0.000463	0.000061	0.000011	0.000063	0.000095	0.000022	0.000149	0.000146	0.000109	0.000256	0.000066	0.000024	0.000020	0.000329	0.000101	0.000058	0.000292	0.000039	0.000024	0.000267	0.000444	0.000016	0.000033	0.000352	0.000415	0.000019	0.000354	0.000013	0.000050	0.000689	0.001027	0.000083	0.000133	0.000063	0.000129	0.000726	0.000034	0.000032	0.000034	0.000437	0.000171	0.000349	0.000062	0.000075	0.000629	0.001691	0.000736	0.000041	0.000076	0.000062	0.000031	0.000029	0.000050	0.000066	0.000030	0.000126	0.000208	0.000236	0.000187	0.000895	0.000053	0.000163	0.000110	0.006168	0.000627	0.000528	0.000166	0.000034	0.000031	0.001036	0.000074	0.000531	0.000090	0.000454	0.000034	0.000126	0.000297	0.000731	0.003133	0.002080	0.000120	0.000132	0.004743	0.008374	0.004563	0.002466	0.008889	0.005113	0.008707	0.001892	0.000324	0.000994	0.002194	0.001099	0.005637	0.000301	0.000611	0.005614	0.000530	0.000529	0.000158	0.000530	0.000459	0.000058	0.002616	0.000157	0.000299	0.000147	0.000063
157751891 - Bicep - Isles - Saku	157751891	0.022541	0.000137	0.000493	0.001127	0.000077	0.000154	0.000230	0.000049	0.000159	0.000069	0.000090	0.000053	0.000047	0.000069	0.000174	0.001090	0.000283	0.000117	0.000120	0.000079	0.000089	0.000072	0.000445	0.000311	0.000280	0.000077	0.000132	0.007975	0.000669	0.000210	0.000346	0.000688	0.000380	0.001233	0.000484	0.000541	0.000283	0.001730	0.000138	0.000013	0.000555	0.000387	0.000073	0.000159	0.000062	0.000024	0.000241	0.000183	0.000071	0.000263	0.000083	0.000043	0.000028	0.000107	0.000714	0.000228	0.000008	0.000036	0.000107	0.000237	0.000280	0.000224	0.000242	0.000100	0.000225	0.000843	0.000159	0.000029	0.000039	0.000460	0.000054	0.000018	0.001951	0.001361	0.000889	0.000229	0.000148	0.000435	0.000150	0.000090	0.000139	0.000312	0.000081	0.000150	0.000247	0.000054	0.000203	0.000073	0.000068	0.000018	0.000044	0.000044	0.000210	0.000065	0.000062	0.000067	0.000066	0.000068	0.000489	0.000283	0.000158	0.000154	0.000132	0.000122	0.000149	0.000131	0.000120	0.000100	0.000024	0.000012	0.000036	0.001082	0.000440	0.000399	0.000027	0.000081	0.000053	0.000108	0.000084	0.000120	0.000024	0.000018	0.000292	0.000205	0.000161	0.000118	0.000615	0.000270	0.000158	0.000220	0.000961	0.000114	0.000238	0.000073	0.000079	0.000538	0.000029	0.787267	0.034287	0.001086	0.001342	0.000264	0.000203	0.000248	0.000110	0.000079	0.000206	0.000120	0.000113	0.000070	0.000091	0.000155	0.005624	0.003484	0.002485	0.000779	0.000846	0.000259	0.043288	0.046031	0.000246	0.002144	0.005095	0.100972	0.007657	0.001495	0.000884	0.000585	0.003500	0.000111	0.000070	0.001406	0.001397	0.000227	0.000370	0.000108	0.000080	0.000152	0.000104	0.000553	0.000740	0.000726	0.000258	0.000025	0.000633	0.000570	0.000234	0.000250	0.000131	0.000500	0.000177	0.000963	0.000152	0.000243	0.000095	0.001614	0.001533	0.000152	0.000267	0.000149	0.000354	0.000121	0.000276	0.000053	0.000214	0.000400	0.000263	0.000032	0.000212	0.000148	0.000277	0.000099	0.000872	0.007018	0.002395	0.000535	0.009811	0.005468	0.000209	0.001957	0.000754	0.000617	0.000306	0.000676	0.000446	0.000090	0.005021	0.001348	0.000715	0.000303	0.000098	0.000096	0.001275	0.000319	0.000966	0.000934	0.006714	0.001342	0.000356	0.307860	0.047744	0.074718	0.048117	0.282959	0.106744	0.041244	0.016609	0.179137	0.000281	0.000100	0.000051	0.001227	0.000360	0.005473	0.001351	0.000584	0.000634	0.000546	0.000815	0.000622	0.000587	0.000254	0.000136	0.000156	0.000273	0.002489	0.002546	0.004663	0.003367	0.000976	0.012342	0.001752	0.001314	0.000680	0.009168	0.000188	0.001151	0.000298	0.001017	0.002266	0.004821	0.000112	0.000150	0.000098	0.000117	0.000089	0.000012	0.000014	0.000385	0.000040	0.000043	0.000034	0.000082	0.000045	0.000047	0.000038	0.000210	0.000128	0.000058	0.000137	0.002193	0.000197	0.000031	0.000060	0.000097	0.000030	0.000202	0.000525	0.000595	0.000118	0.000398	0.000014	0.000031	0.000051	0.000057	0.000092	0.000193	0.000029	0.000527	0.000022	0.000058	0.000041	0.000564	0.000476	0.000421	0.000235	0.000198	0.000061	0.000183	0.000249	0.000095	0.000107	0.000149	0.000005	0.000026	0.000127	0.000018	0.000055	0.000033	0.000108	0.000070	0.000181	0.000022	0.000243	0.000012	0.000052	0.000047	0.000131	0.000104	0.000050	0.000019	0.000062	0.000068	0.000114	0.000198	0.000117	0.000256	0.000064	0.000042	0.000183	0.000213	0.000335	0.000010	0.000029	0.000237	0.000177	0.000045	0.000070	0.000071	0.000087	0.000154	0.000099	0.000130	0.000090	0.000027	0.000040	0.000157	0.000074	0.000158	0.000648	0.000154	0.000422	0.000449	0.000084	0.000580	0.000161	0.000658	0.000386	0.002753	0.000865	0.000389	0.001741	0.000586	0.001306	0.002288	0.000484	0.003188	0.001288	0.002024	0.001559	0.006859	0.000239	0.000984	0.000129	0.000390	0.000223	0.000569	0.000579	0.000551	0.000197	0.000053	0.000063	0.000084	0.000010	0.000069	0.000077	0.000189	0.000167	0.000675	0.000033	0.000020	0.000079	0.000123	0.000019	0.000269	0.000251	0.000063	0.000199	0.000053	0.000015	0.000009	0.000241	0.000051	0.000044	0.000199	0.000018	0.000010	0.000268	0.000124	0.000014	0.000036	0.000348	0.000140	0.000016	0.000245	0.000018	0.000052	0.000205	0.000522	0.000044	0.000083	0.000068	0.000068	0.000617	0.000039	0.000044	0.000031	0.000827	0.000052	0.000246	0.000037	0.000060	0.000522	0.001054	0.000447	0.000038	0.000052	0.000062	0.000032	0.000019	0.000048	0.000122	0.000017	0.000045	0.000194	0.000165	0.000267	0.000522	0.000034	0.000114	0.000090	0.002157	0.000369	0.000175	0.000059	0.000016	0.000035	0.000652	0.000048	0.000294	0.000097	0.000839	0.000033	0.000056	0.000304	0.000228	0.005727	0.001100	0.000116	0.000145	0.005546	0.005967	0.004791	0.001261	0.006355	0.001673	0.009712	0.002524	0.000373	0.000836	0.001114	0.001144	0.003159	0.000587	0.000276	0.008217	0.000649	0.000326	0.001316	0.000379	0.000472	0.000069	0.006434	0.000209	0.000362	0.000309	0.000038
157751893 - Bicep - Isles - X	157751893	0.026547	0.000278	0.000229	0.000502	0.000069	0.000225	0.000115	0.000095	0.000193	0.000062	0.000118	0.000030	0.000033	0.000037	0.000253	0.000241	0.000408	0.000121	0.000123	0.000192	0.000161	0.000156	0.000295	0.000320	0.000389	0.000107	0.000110	0.001722	0.000110	0.000080	0.000044	0.000135	0.000361	0.000323	0.000146	0.000330	0.001260	0.000046	0.000179	0.000031	0.000284	0.000203	0.000124	0.000180	0.000074	0.000057	0.000165	0.000190	0.000186	0.000161	0.000215	0.000254	0.000094	0.000233	0.000366	0.000209	0.000009	0.000062	0.000273	0.000217	0.000128	0.000169	0.000273	0.000308	0.000443	0.001295	0.000126	0.000051	0.000116	0.000655	0.000166	0.000061	0.002404	0.001670	0.001155	0.000225	0.000240	0.000493	0.000302	0.000094	0.000204	0.000353	0.000083	0.000152	0.000176	0.000074	0.000305	0.000213	0.000256	0.000060	0.000085	0.000072	0.011998	0.000082	0.000188	0.000112	0.000182	0.000158	0.000651	0.000551	0.000334	0.000283	0.000162	0.000152	0.000104	0.000117	0.000107	0.000118	0.000057	0.000037	0.000088	0.000927	0.000446	0.000473	0.000021	0.000117	0.000087	0.000071	0.000070	0.000093	0.000048	0.000027	0.000322	0.000195	0.000336	0.000134	0.000847	0.000406	0.000199	0.000301	0.000415	0.000137	0.000751	0.000258	0.000104	0.001835	0.000018	0.780453	0.105403	0.002640	0.002674	0.000755	0.000557	0.000580	0.000088	0.000291	0.000644	0.000371	0.000677	0.000244	0.000301	0.000113	0.007242	0.005042	0.002754	0.000376	0.000253	0.000140	0.057142	0.124935	0.000772	0.023310	0.036986	0.388533	0.069837	0.010877	0.009755	0.002832	0.034656	0.000231	0.001079	0.004645	0.004348	0.012006	0.000566	0.000126	0.000188	0.000084	0.000285	0.000927	0.001439	0.001141	0.000227	0.000124	0.001565	0.001699	0.000408	0.001136	0.000360	0.001083	0.000247	0.002946	0.000472	0.000329	0.000164	0.004686	0.003965	0.000693	0.000803	0.000232	0.000522	0.000194	0.000182	0.000124	0.000100	0.000511	0.000461	0.000099	0.000554	0.001516	0.001593	0.000202	0.000948	0.000888	0.000277	0.000658	0.007106	0.020065	0.000166	0.002164	0.001031	0.000762	0.000292	0.001244	0.000639	0.000176	0.015692	0.003855	0.001544	0.000634	0.000229	0.000334	0.005711	0.002299	0.004730	0.003619	0.007456	0.002305	0.000207	0.082739	0.025788	0.031309	0.023487	0.026493	0.087311	0.015514	0.003389	0.012120	0.000648	0.000394	0.000180	0.002982	0.000224	0.003370	0.000098	0.000017	0.005078	0.008367	0.000302	0.000495	0.000457	0.000621	0.000220	0.000206	0.003928	0.004272	0.001068	0.007063	0.007788	0.000833	0.012768	0.000599	0.003183	0.000316	0.009189	0.000569	0.002097	0.001119	0.001401	0.005179	0.009744	0.000048	0.000152	0.000122	0.000154	0.000113	0.000024	0.000030	0.000224	0.000063	0.000069	0.000048	0.000103	0.000029	0.000068	0.000052	0.000109	0.000188	0.000073	0.000174	0.002764	0.000338	0.000062	0.000168	0.000100	0.000064	0.000269	0.000754	0.001289	0.000245	0.000458	0.000028	0.000040	0.000065	0.000098	0.000103	0.000214	0.000036	0.000789	0.000046	0.000198	0.000087	0.000499	0.000280	0.000316	0.000163	0.000207	0.000067	0.000197	0.000274	0.000081	0.000102	0.000165	0.000005	0.000030	0.000117	0.000013	0.000028	0.000036	0.000064	0.000069	0.000339	0.000209	0.000263	0.000012	0.000020	0.000065	0.000062	0.000114	0.000070	0.000013	0.000072	0.000071	0.000186	0.000251	0.000184	0.000153	0.000090	0.000113	0.000383	0.000521	0.000161	0.000008	0.000042	0.000499	0.000288	0.000330	0.000063	0.000119	0.000050	0.000099	0.000063	0.000048	0.000031	0.000051	0.000027	0.000054	0.000047	0.000109	0.000568	0.000080	0.000217	0.000377	0.000044	0.000199	0.000076	0.000235	0.000236	0.001671	0.000789	0.000178	0.005227	0.000895	0.001118	0.000765	0.000969	0.001559	0.000485	0.002881	0.002612	0.004096	0.000131	0.001451	0.000093	0.000343	0.000172	0.000763	0.002215	0.001984	0.000154	0.000034	0.000038	0.000052	0.000012	0.000092	0.000201	0.000134	0.000262	0.000713	0.000256	0.000015	0.000069	0.000089	0.000006	0.000160	0.000141	0.000137	0.000232	0.000052	0.000016	0.000059	0.000261	0.000174	0.000071	0.000495	0.000041	0.000020	0.000413	0.005842	0.000027	0.000067	0.000558	0.000839	0.000053	0.000400	0.000025	0.000053	0.000352	0.001476	0.000058	0.000426	0.000103	0.000151	0.000806	0.000065	0.000055	0.000026	0.000166	0.000103	0.000509	0.000078	0.000055	0.000366	0.001226	0.000419	0.000594	0.000059	0.000273	0.000123	0.000064	0.000044	0.000937	0.000121	0.000086	0.000387	0.000196	0.000168	0.000918	0.000025	0.000056	0.000023	0.003307	0.001771	0.000598	0.000213	0.000017	0.000036	0.000635	0.000038	0.000922	0.000089	0.000544	0.000036	0.000058	0.000965	0.000383	0.003160	0.000722	0.000193	0.000090	0.003296	0.001386	0.004665	0.000318	0.007199	0.013841	0.007947	0.002683	0.000744	0.001548	0.001466	0.001060	0.003634	0.000096	0.000245	0.004531	0.000494	0.000434	0.000356	0.000523	0.000320	0.000039	0.003289	0.000144	0.000670	0.000528	0.000105
157751892 - Bicep - Isles - Lido	157751892	0.014651	0.000280	0.000170	0.000553	0.000048	0.000153	0.000176	0.000096	0.000501	0.000168	0.000205	0.000076	0.000079	0.000053	0.000482	0.000210	0.000336	0.000164	0.000152	0.000104	0.000166	0.000093	0.000217	0.000189	0.000168	0.000083	0.000155	0.002373	0.000610	0.000092	0.000147	0.000206	0.000338	0.000778	0.000211	0.000511	0.000136	0.000057	0.000338	0.000066	0.000479	0.000498	0.000052	0.000339	0.000173	0.000098	0.000151	0.000314	0.000086	0.000531	0.000098	0.000042	0.000147	0.000076	0.000163	0.000109	0.000065	0.000125	0.000171	0.000274	0.000154	0.000063	0.000049	0.000077	0.000066	0.000096	0.000158	0.000022	0.000053	0.000816	0.000138	0.000029	0.004286	0.002422	0.001689	0.000414	0.000327	0.000658	0.000330	0.000110	0.000224	0.000535	0.000115	0.000244	0.001317	0.000098	0.000678	0.000093	0.000068	0.000057	0.000221	0.000188	0.000633	0.000130	0.000204	0.000328	0.000335	0.000395	0.000660	0.000592	0.000268	0.000440	0.000152	0.000140	0.000099	0.000108	0.000131	0.000133	0.000077	0.000050	0.000131	0.001427	0.000570	0.000425	0.000031	0.000237	0.000146	0.000115	0.000093	0.000393	0.000148	0.000034	0.000399	0.000161	0.000110	0.000087	0.001509	0.000347	0.000479	0.000825	0.000776	0.000473	0.000183	0.000081	0.000312	0.000248	0.000291	0.769937	0.080734	0.003066	0.002905	0.000754	0.000488	0.000261	0.000269	0.000428	0.000297	0.000306	0.000184	0.000388	0.001321	0.000254	0.083185	0.076920	0.026484	0.024820	0.016920	0.010484	0.087911	0.014636	0.005052	0.002616	0.000733	0.001468	0.001030	0.000182	0.000106	0.000094	0.000304	0.000299	0.000119	0.000279	0.000203	0.000361	0.000055	0.000024	0.000040	0.001555	0.001696	0.003413	0.006422	0.003900	0.002278	0.000262	0.003319	0.001445	0.001010	0.000783	0.000322	0.001673	0.000301	0.002695	0.002071	0.000577	0.000291	0.002355	0.001375	0.000335	0.000386	0.001777	0.001727	0.000850	0.000082	0.000038	0.000100	0.000546	0.000291	0.000927	0.000226	0.000646	0.000355	0.000188	0.001826	0.017938	0.006794	0.000227	0.001516	0.001097	0.000116	0.000815	0.000635	0.000220	0.000088	0.000439	0.000215	0.000060	0.001744	0.001501	0.000211	0.000440	0.000053	0.000205	0.000269	0.000368	0.001133	0.001104	0.000706	0.009022	0.001341	0.154663	0.011240	0.018892	0.012341	0.004234	0.056850	0.008709	0.181473	0.047846	0.000151	0.000081	0.000082	0.001552	0.000291	0.037119	0.000323	0.000076	0.000196	0.000114	0.000678	0.000777	0.000550	0.000159	0.000138	0.000099	0.001698	0.002517	0.000648	0.011039	0.007870	0.000444	0.011782	0.001773	0.005580	0.000517	0.001217	0.001042	0.001221	0.000588	0.002414	0.007665	0.001717	0.000105	0.002273	0.000181	0.000315	0.000183	0.000041	0.000044	0.000425	0.000080	0.000048	0.000063	0.000200	0.000300	0.000116	0.000083	0.001030	0.000191	0.000059	0.000084	0.002518	0.000226	0.000051	0.000051	0.000140	0.000058	0.000264	0.000952	0.001305	0.000285	0.000106	0.000028	0.000052	0.000060	0.000140	0.000174	0.000307	0.000085	0.000912	0.000052	0.000256	0.000141	0.000271	0.000151	0.000162	0.000169	0.000181	0.000095	0.000477	0.000660	0.000287	0.000237	0.000439	0.000012	0.000153	0.000195	0.000031	0.000115	0.000065	0.000061	0.000116	0.000091	0.000027	0.000413	0.000044	0.000083	0.000031	0.000146	0.000204	0.000147	0.000018	0.000068	0.000136	0.000261	0.000219	0.000079	0.000114	0.000096	0.000062	0.000103	0.000152	0.000470	0.000020	0.000032	0.000152	0.000065	0.000031	0.000109	0.000166	0.000091	0.000238	0.000155	0.000107	0.000168	0.000107	0.000036	0.000069	0.000211	0.000098	0.000066	0.000044	0.000028	0.000262	0.000014	0.000182	0.000045	0.000241	0.000253	0.002161	0.000711	0.000249	0.003647	0.000359	0.000965	0.000537	0.000664	0.002712	0.001610	0.001391	0.002815	0.001629	0.000043	0.000943	0.000755	0.000132	0.000069	0.000302	0.000390	0.000617	0.000054	0.000023	0.000039	0.000119	0.000041	0.000063	0.000155	0.000191	0.000165	0.000661	0.000087	0.000031	0.000174	0.000131	0.000054	0.000286	0.000356	0.000212	0.000187	0.000058	0.000022	0.000041	0.000077	0.000054	0.000055	0.000362	0.000088	0.000028	0.000393	0.000081	0.000010	0.000036	0.000421	0.000216	0.000048	0.000203	0.000068	0.000046	0.000088	0.000270	0.000033	0.000056	0.000070	0.000107	0.002314	0.000068	0.000070	0.000035	0.006472	0.000135	0.000364	0.000049	0.000072	0.000435	0.003189	0.001600	0.000044	0.000068	0.000159	0.000052	0.000070	0.000128	0.000074	0.000035	0.000083	0.000144	0.000149	0.000309	0.000141	0.000010	0.000047	0.000031	0.004406	0.000602	0.000123	0.000055	0.000072	0.000010	0.000802	0.000066	0.000313	0.000194	0.000243	0.000057	0.000328	0.000495	0.000095	0.001802	0.000306	0.000325	0.000072	0.003533	0.007934	0.012436	0.000772	0.008006	0.001325	0.009832	0.006208	0.001121	0.001071	0.001041	0.009021	0.006928	0.001329	0.000301	0.002794	0.000523	0.001100	0.000443	0.001557	0.001765	0.000412	0.000986	0.000291	0.001500	0.001482	0.000037
157751890 - Bicep - Isles - Apricots	157751890	0.024855	0.000459	0.000927	0.001399	0.000196	0.000526	0.000360	0.000124	0.000399	0.000249	0.000298	0.000100	0.000067	0.000071	0.000583	0.000325	0.000768	0.000223	0.000357	0.000432	0.000238	0.000324	0.000358	0.000474	0.000366	0.000225	0.000134	0.017600	0.000429	0.002185	0.000064	0.000132	0.001296	0.004549	0.002300	0.004471	0.002436	0.000248	0.000124	0.000022	0.000318	0.000153	0.000046	0.000064	0.000089	0.000029	0.000084	0.000212	0.000111	0.000226	0.000068	0.000053	0.000092	0.000105	0.000252	0.000128	0.000014	0.000045	0.000097	0.000460	0.000392	0.000777	0.000167	0.000494	0.000645	0.001533	0.000155	0.000025	0.000056	0.000446	0.000106	0.000031	0.003129	0.002298	0.001566	0.000555	0.000397	0.000494	0.000613	0.000109	0.000286	0.000565	0.000065	0.000547	0.000172	0.000097	0.000296	0.000233	0.000205	0.000096	0.000074	0.000074	0.000106	0.000105	0.000204	0.000220	0.000487	0.000326	0.000915	0.000505	0.000260	0.000309	0.000196	0.000174	0.000141	0.000257	0.000190	0.000190	0.000062	0.000040	0.000076	0.001132	0.000489	0.000436	0.000031	0.000113	0.000080	0.000155	0.000139	0.000267	0.000060	0.000025	0.000388	0.000145	0.000227	0.000142	0.001104	0.000379	0.000741	0.000553	0.000910	0.000160	0.000532	0.000210	0.000070	0.000859	0.000011	0.810724	0.051978	0.003272	0.004022	0.000830	0.001280	0.000473	0.000187	0.000258	0.000559	0.000303	0.000169	0.000149	0.000100	0.000284	0.016506	0.009526	0.008196	0.002142	0.002412	0.000930	0.087865	0.143369	0.000250	0.002797	0.005559	0.296334	0.009829	0.001651	0.001163	0.000543	0.004632	0.000272	0.000304	0.000898	0.000969	0.001084	0.000222	0.000716	0.000332	0.000151	0.000082	0.000652	0.000938	0.000843	0.000165	0.000112	0.000745	0.002076	0.000234	0.001918	0.000643	0.000569	0.000071	0.000835	0.000240	0.000146	0.000109	0.002954	0.000801	0.000572	0.000713	0.000174	0.000287	0.000145	0.000461	0.000106	0.000066	0.000253	0.000193	0.000081	0.000776	0.000701	0.000707	0.000563	0.001258	0.002296	0.000222	0.004865	0.018235	0.028118	0.000873	0.003971	0.001040	0.001200	0.000793	0.001877	0.001778	0.000477	0.008602	0.002746	0.015300	0.000727	0.001718	0.000273	0.009221	0.001031	0.001620	0.002067	0.012913	0.000812	0.000262	0.217402	0.055394	0.018303	0.089814	0.068894	0.040171	0.032706	0.002146	0.007895	0.001273	0.000546	0.000068	0.001704	0.003591	0.000673	0.001238	0.000473	0.001727	0.001670	0.000959	0.000747	0.001464	0.000261	0.000476	0.001249	0.000506	0.003505	0.004828	0.002620	0.003118	0.003230	0.007128	0.000290	0.001331	0.000803	0.009878	0.000132	0.001356	0.005160	0.000206	0.001296	0.006558	0.000071	0.000103	0.000102	0.000108	0.000099	0.000036	0.000039	0.000315	0.000051	0.000047	0.000040	0.000111	0.000045	0.000056	0.000049	0.000124	0.000163	0.000052	0.000111	0.002785	0.000243	0.000049	0.000139	0.000090	0.000042	0.000276	0.000696	0.001243	0.000262	0.000413	0.000093	0.000027	0.000037	0.000062	0.000054	0.000308	0.000044	0.002112	0.000029	0.000131	0.000087	0.001009	0.000524	0.000455	0.000379	0.000156	0.000060	0.000263	0.000322	0.000109	0.000157	0.000226	0.000007	0.000030	0.000112	0.000026	0.000063	0.000038	0.000073	0.000070	0.000117	0.000078	0.000280	0.000023	0.000056	0.000076	0.000057	0.000115	0.000067	0.000017	0.000098	0.000084	0.000193	0.000453	0.000113	0.000353	0.000179	0.000125	0.000912	0.000731	0.000108	0.000021	0.000115	0.000178	0.000091	0.000166	0.000095	0.000106	0.000060	0.000159	0.000117	0.000191	0.000078	0.000068	0.000027	0.000136	0.000147	0.000208	0.000368	0.000088	0.000300	0.000578	0.000096	0.000539	0.000123	0.000838	0.000335	0.001641	0.001030	0.000327	0.004329	0.000522	0.001427	0.001144	0.000414	0.003322	0.000767	0.001650	0.001000	0.002326	0.000232	0.000566	0.000158	0.000249	0.000107	0.000482	0.001271	0.000901	0.000106	0.000041	0.000053	0.000090	0.000012	0.000072	0.000155	0.000153	0.000225	0.000451	0.000039	0.000010	0.000060	0.000085	0.000020	0.000149	0.000202	0.000112	0.000234	0.000095	0.000015	0.000028	0.000163	0.000051	0.000033	0.000485	0.000029	0.000017	0.000358	0.000687	0.000036	0.000065	0.000140	0.000162	0.000038	0.000271	0.000039	0.000045	0.000497	0.000632	0.000020	0.000135	0.000051	0.000102	0.000412	0.000061	0.000071	0.000018	0.000297	0.000088	0.000370	0.000129	0.000217	0.000506	0.005065	0.002230	0.000130	0.000067	0.000230	0.000075	0.000020	0.000053	0.000170	0.000091	0.000054	0.000570	0.000128	0.000180	0.001282	0.000015	0.000057	0.000051	0.001271	0.000415	0.000256	0.000060	0.000013	0.000025	0.000618	0.000029	0.000523	0.000097	0.001522	0.000043	0.000114	0.001363	0.000407	0.004249	0.001005	0.000715	0.000101	0.004543	0.002375	0.001501	0.000708	0.009225	0.000666	0.014490	0.004072	0.000510	0.001312	0.001437	0.001942	0.004271	0.000302	0.000160	0.002507	0.000534	0.002411	0.001739	0.000575	0.000448	0.000069	0.005422	0.000204	0.000639	0.000839	0.000032
157751894 - Bicep - Isles - Rever	157751894	0.012121	0.000231	0.000219	0.000439	0.000077	0.000190	0.000069	0.000101	0.000170	0.000131	0.000109	0.000042	0.000064	0.000053	0.000132	0.000175	0.000163	0.000050	0.000048	0.000047	0.000050	0.000030	0.000118	0.000214	0.000144	0.000038	0.000075	0.004829	0.001237	0.000195	0.000424	0.000402	0.000285	0.000457	0.000203	0.000203	0.002556	0.000339	0.000077	0.000014	0.000362	0.000131	0.000044	0.000078	0.000046	0.000015	0.000113	0.000061	0.000045	0.000074	0.000103	0.000122	0.000059	0.000518	0.000231	0.000161	0.000004	0.000309	0.000052	0.000202	0.000096	0.000154	0.000011	0.000080	0.001976	0.001553	0.000102	0.000036	0.000046	0.000411	0.000048	0.000039	0.003006	0.001538	0.001011	0.000268	0.000293	0.000552	0.000403	0.000126	0.000190	0.000418	0.000122	0.000260	0.000163	0.000100	0.000539	0.000379	0.000308	0.000077	0.000187	0.000177	0.000085	0.000082	0.000150	0.000176	0.000384	0.000335	0.000433	0.000342	0.000139	0.000183	0.000105	0.000094	0.000112	0.000189	0.000084	0.000084	0.000107	0.000075	0.000126	0.000755	0.000304	0.000221	0.000009	0.000251	0.000179	0.000080	0.000078	0.000108	0.000049	0.000043	0.000269	0.000114	0.000262	0.000099	0.000525	0.000137	0.000231	0.000258	0.002633	0.000113	0.000179	0.000080	0.000099	0.000809	0.000476	0.773661	0.072328	0.003438	0.004433	0.000725	0.001217	0.000590	0.000413	0.000093	0.000464	0.000161	0.000134	0.000247	0.000144	0.000164	0.024899	0.016069	0.013242	0.004601	0.002727	0.002029	0.100292	0.098079	0.000321	0.006391	0.010491	0.130555	0.020581	0.004366	0.003270	0.001421	0.008814	0.004106	0.000155	0.001423	0.001617	0.000509	0.000417	0.000308	0.000481	0.001197	0.000231	0.000760	0.000951	0.000875	0.000419	0.000178	0.003296	0.003156	0.000496	0.001557	0.001259	0.001065	0.000152	0.001725	0.000376	0.000376	0.000255	0.003325	0.002703	0.000683	0.000535	0.000431	0.000495	0.000253	0.000421	0.000044	0.000158	0.000500	0.000205	0.000055	0.000819	0.000690	0.001311	0.000305	0.000726	0.025893	0.002477	0.006529	0.004287	0.038546	0.000233	0.003100	0.000676	0.000748	0.000345	0.001309	0.000612	0.000969	0.005782	0.005644	0.003310	0.000909	0.002341	0.000229	0.005920	0.000578	0.000850	0.002824	0.002789	0.002260	0.000330	0.128990	0.008968	0.009143	0.010126	0.127330	0.021772	0.003668	0.037917	0.003345	0.000653	0.000457	0.000118	0.001533	0.000776	0.002151	0.000608	0.000278	0.001132	0.001545	0.001441	0.001271	0.000715	0.000117	0.000599	0.000319	0.000440	0.001598	0.001950	0.005187	0.006562	0.001983	0.012887	0.000335	0.005358	0.001069	0.001577	0.000187	0.000872	0.001684	0.000785	0.002254	0.002519	0.000365	0.002299	0.000211	0.000261	0.000215	0.000112	0.000160	0.000297	0.000124	0.000123	0.000116	0.000130	0.000057	0.000101	0.000081	0.000115	0.000275	0.000079	0.000289	0.002492	0.000253	0.000078	0.000176	0.000129	0.000035	0.000209	0.000672	0.000496	0.000138	0.000078	0.000028	0.000029	0.000043	0.000079	0.000079	0.000186	0.000026	0.000385	0.000030	0.000066	0.000045	0.000366	0.000200	0.000185	0.000177	0.000245	0.000049	0.000216	0.000303	0.000095	0.000119	0.000200	0.000012	0.000054	0.000236	0.000034	0.000074	0.000072	0.000135	0.000138	0.000387	0.000850	0.000241	0.000021	0.000016	0.000075	0.000024	0.000092	0.000063	0.000011	0.000053	0.000077	0.000165	0.000454	0.000104	0.000489	0.000275	0.000217	0.000222	0.000256	0.000224	0.000020	0.000088	0.000112	0.000043	0.000025	0.000102	0.000118	0.000027	0.000118	0.000078	0.000065	0.000025	0.000105	0.000012	0.000029	0.000057	0.000115	0.000953	0.000146	0.000160	0.000432	0.000132	0.000141	0.000062	0.000193	0.000183	0.000681	0.000415	0.000255	0.000721	0.000097	0.002013	0.002241	0.000207	0.001702	0.000654	0.000992	0.000645	0.000638	0.000963	0.001780	0.000100	0.000084	0.000033	0.000289	0.000764	0.000543	0.000032	0.000006	0.000029	0.000101	0.000022	0.000034	0.000099	0.000089	0.000439	0.000227	0.000064	0.000005	0.000036	0.000030	0.000016	0.000080	0.000077	0.000136	0.000216	0.000075	0.000062	0.000051	0.000107	0.000104	0.000069	0.000244	0.000045	0.000021	0.000136	0.000317	0.000015	0.000055	0.000201	0.000351	0.000029	0.000382	0.000029	0.000057	0.000339	0.000712	0.000023	0.000222	0.000147	0.000138	0.000650	0.000065	0.000051	0.000047	0.010788	0.000223	0.000852	0.000307	0.000515	0.001291	0.006120	0.002585	0.000197	0.000039	0.000137	0.000120	0.000086	0.000076	0.000228	0.000094	0.000071	0.001268	0.000225	0.000107	0.000802	0.000028	0.000166	0.000100	0.002567	0.000713	0.000322	0.000050	0.000028	0.000010	0.000814	0.000021	0.000508	0.000143	0.000249	0.000050	0.000394	0.000280	0.000546	0.042965	0.000745	0.000091	0.000159	0.006757	0.016161	0.003738	0.002503	0.011052	0.000845	0.007135	0.006146	0.000895	0.001431	0.001777	0.004048	0.006071	0.002358	0.000129	0.034285	0.003323	0.002041	0.007646	0.001723	0.001837	0.000062	0.039281	0.000338	0.000812	0.000615	0.000083
157751896 - Bicep - Isles - Fir	157751896	0.015845	0.000129	0.000222	0.001256	0.000040	0.000162	0.000125	0.000031	0.000053	0.000022	0.000057	0.000009	0.000019	0.000028	0.000106	0.000513	0.000152	0.000066	0.000105	0.000046	0.000084	0.000045	0.000225	0.000268	0.000151	0.000066	0.000057	0.000983	0.000157	0.000023	0.000028	0.000057	0.000065	0.000154	0.000116	0.000041	0.000255	0.000037	0.000035	0.000014	0.000265	0.000163	0.000015	0.000064	0.000060	0.000044	0.000147	0.000056	0.000035	0.000073	0.000022	0.000054	0.000073	0.000084	0.000239	0.000214	0.000012	0.000075	0.000050	0.000071	0.000054	0.000234	0.000139	0.000125	0.000154	0.000249	0.000057	0.000041	0.000030	0.000317	0.000029	0.000049	0.002262	0.001562	0.000763	0.000141	0.000118	0.000213	0.000152	0.000057	0.000117	0.000445	0.000105	0.000297	0.000089	0.000062	0.000278	0.000146	0.000141	0.000052	0.000048	0.000045	0.001101	0.000069	0.000121	0.000166	0.000118	0.000126	0.000536	0.000295	0.000161	0.000130	0.000190	0.000178	0.000075	0.000071	0.000109	0.000097	0.000052	0.000038	0.000075	0.001004	0.000361	0.000208	0.000016	0.000180	0.000113	0.000061	0.000062	0.000105	0.000026	0.000031	0.000189	0.000093	0.000075	0.000068	0.000684	0.000100	0.000316	0.000438	0.000802	0.000139	0.000209	0.000107	0.000029	0.000339	0.000013	0.793323	0.069045	0.002124	0.002376	0.000465	0.000373	0.000359	0.000124	0.000075	0.000317	0.000223	0.000281	0.000255	0.000322	0.000102	0.011020	0.007600	0.004753	0.000670	0.000459	0.000243	0.076764	0.109428	0.000358	0.004699	0.006456	0.073680	0.010936	0.001596	0.001128	0.000499	0.004252	0.000176	0.000108	0.001080	0.001006	0.000718	0.000089	0.000020	0.000045	0.000311	0.000473	0.001714	0.002477	0.002079	0.000436	0.000196	0.001759	0.002459	0.000396	0.001413	0.000651	0.000832	0.000128	0.002059	0.000376	0.000244	0.000121	0.001604	0.000351	0.000327	0.000364	0.000173	0.001884	0.000732	0.000204	0.000092	0.000126	0.000952	0.000762	0.000190	0.000236	0.000239	0.000508	0.000110	0.000485	0.005344	0.000463	0.000673	0.005285	0.008415	0.000046	0.001342	0.000443	0.000256	0.000165	0.000768	0.000318	0.000103	0.005090	0.001090	0.000252	0.000382	0.000154	0.000156	0.002450	0.000293	0.000655	0.002165	0.005380	0.001680	0.000258	0.251730	0.051432	0.051440	0.103414	0.159665	0.201692	0.089006	0.009380	0.112809	0.000118	0.000109	0.000044	0.001805	0.000330	0.001732	0.000081	0.000022	0.000331	0.000395	0.000272	0.000388	0.000322	0.000202	0.000048	0.000125	0.000328	0.001948	0.000817	0.005627	0.003620	0.000656	0.011784	0.000149	0.003501	0.000311	0.007973	0.000182	0.001090	0.000729	0.000417	0.001418	0.007029	0.000077	0.000186	0.000105	0.000093	0.000091	0.000021	0.000024	0.000239	0.000051	0.000034	0.000031	0.000069	0.000024	0.000048	0.000035	0.000069	0.000078	0.000030	0.000130	0.002182	0.000194	0.000033	0.000056	0.000100	0.000035	0.000226	0.000527	0.000810	0.000088	0.000268	0.000004	0.000019	0.000038	0.000054	0.000087	0.000291	0.000029	0.000772	0.000038	0.000054	0.000033	0.000666	0.000648	0.000374	0.000271	0.000111	0.000052	0.000184	0.000236	0.000058	0.000101	0.000162	0.000003	0.000019	0.000123	0.000016	0.000035	0.000043	0.000057	0.000077	0.000110	0.000073	0.000221	0.000004	0.000019	0.000031	0.000016	0.000102	0.000062	0.000026	0.000034	0.000075	0.000132	0.000242	0.000106	0.000220	0.000066	0.000070	0.000182	0.000187	0.000267	0.000011	0.000052	0.000183	0.000102	0.000046	0.000051	0.000054	0.000040	0.000079	0.000060	0.000065	0.000030	0.000050	0.000021	0.000024	0.000062	0.000168	0.000287	0.000191	0.000217	0.000112	0.000056	0.000317	0.000110	0.000443	0.000335	0.002068	0.000653	0.000237	0.003075	0.000255	0.000526	0.000575	0.000716	0.003291	0.001216	0.001723	0.003050	0.004729	0.000078	0.000806	0.000050	0.000103	0.000053	0.000284	0.000366	0.000425	0.000047	0.000015	0.000066	0.000068	0.000010	0.000054	0.000187	0.000211	0.000397	0.000277	0.000059	0.000008	0.000019	0.000082	0.000017	0.000076	0.000102	0.000075	0.000186	0.000041	0.000036	0.000015	0.000206	0.000122	0.000064	0.000270	0.000020	0.000016	0.000166	0.000211	0.000016	0.000018	0.000188	0.000242	0.000016	0.000326	0.000021	0.000030	0.000503	0.000750	0.000034	0.000154	0.000043	0.000130	0.000692	0.000043	0.000051	0.000017	0.000743	0.000059	0.000341	0.000036	0.000040	0.000204	0.001448	0.000559	0.000042	0.000037	0.000045	0.000020	0.000026	0.000030	0.000109	0.000038	0.000072	0.000205	0.000124	0.000122	0.000430	0.000036	0.000150	0.000093	0.002679	0.000795	0.000314	0.000092	0.000015	0.000009	0.000397	0.000027	0.000324	0.000063	0.000178	0.000035	0.000050	0.000240	0.000365	0.003359	0.001233	0.000346	0.000134	0.003491	0.002309	0.002563	0.000625	0.006005	0.020760	0.008122	0.003067	0.000368	0.000979	0.000793	0.001041	0.004963	0.000110	0.000115	0.007240	0.000345	0.000515	0.000220	0.000559	0.000304	0.000048	0.004382	0.000216	0.000317	0.000116	0.000027
157751897 - Bicep - Isles - Hawk	157751897	0.076435	0.000670	0.000734	0.002239	0.000209	0.000479	0.000256	0.000097	0.000346	0.000217	0.000288	0.000083	0.000102	0.000092	0.000755	0.001003	0.000728	0.000184	0.000388	0.000237	0.000251	0.000226	0.000867	0.000754	0.000870	0.000171	0.000481	0.003886	0.000229	0.000078	0.000096	0.000127	0.000380	0.000379	0.000205	0.000311	0.001136	0.000146	0.000341	0.000045	0.000527	0.000629	0.000072	0.000059	0.000340	0.000070	0.000279	0.000351	0.000247	0.000584	0.000200	0.000070	0.000025	0.000093	0.000346	0.000228	0.000040	0.000150	0.000298	0.000456	0.000262	0.000184	0.000396	0.000173	0.000394	0.000835	0.000177	0.000045	0.000088	0.000627	0.000091	0.000034	0.002675	0.002245	0.001252	0.000255	0.000231	0.000669	0.000309	0.000144	0.000183	0.000532	0.000076	0.000342	0.000156	0.000120	0.000254	0.000089	0.000082	0.000040	0.000078	0.000077	0.000433	0.000078	0.000208	0.000146	0.000255	0.000201	0.000402	0.000339	0.000152	0.000199	0.000085	0.000084	0.000093	0.000163	0.000059	0.000053	0.000047	0.000043	0.000151	0.000895	0.000337	0.000282	0.000017	0.000108	0.000085	0.000087	0.000080	0.000190	0.000041	0.000012	0.000339	0.000161	0.000250	0.000103	0.000452	0.000133	0.000224	0.000282	0.000919	0.000104	0.000355	0.000126	0.000069	0.000721	0.000018	0.721692	0.046794	0.002692	0.002903	0.000649	0.000666	0.000447	0.000130	0.000171	0.000382	0.000328	0.000421	0.000311	0.000228	0.000186	0.008266	0.005409	0.003448	0.000267	0.000235	0.000110	0.063059	0.167586	0.000282	0.003051	0.005071	0.283720	0.008470	0.001598	0.001209	0.000654	0.003668	0.000412	0.000260	0.001013	0.001001	0.001181	0.000213	0.000051	0.000086	0.000133	0.000152	0.000460	0.000633	0.000593	0.000141	0.000076	0.000601	0.001218	0.000269	0.000726	0.000309	0.000685	0.000104	0.001206	0.000318	0.000183	0.000112	0.002597	0.000778	0.000303	0.000433	0.000157	0.000267	0.000116	0.000244	0.000075	0.000100	0.000270	0.000178	0.000049	0.000714	0.000473	0.000516	0.000347	0.000811	0.001521	0.000222	0.001123	0.009346	0.019784	0.000237	0.003118	0.001093	0.000589	0.000440	0.001033	0.000647	0.000153	0.005079	0.001201	0.000764	0.000500	0.000230	0.000227	0.004348	0.000375	0.000938	0.001847	0.006006	0.000991	0.000223	0.136853	0.026963	0.024038	0.042024	0.081990	0.088015	0.023566	0.003434	0.040415	0.000426	0.000290	0.000130	0.001644	0.000453	0.000882	0.000307	0.000072	0.001189	0.001389	0.000468	0.000515	0.000747	0.000348	0.000224	0.000166	0.000318	0.002113	0.001676	0.004139	0.005157	0.001169	0.008834	0.000222	0.002890	0.000277	0.006210	0.000082	0.000725	0.000695	0.000327	0.001141	0.005598	0.000437	0.000308	0.000121	0.000098	0.000114	0.000039	0.000051	0.000298	0.000070	0.000053	0.000053	0.000103	0.000039	0.000061	0.000050	0.000087	0.000176	0.000054	0.000169	0.002715	0.000235	0.000044	0.000079	0.000100	0.000053	0.000281	0.000825	0.000783	0.000149	0.000251	0.000016	0.000055	0.000084	0.000130	0.000166	0.000306	0.000075	0.000898	0.000036	0.000064	0.000064	0.000710	0.000656	0.000292	0.000233	0.000220	0.000054	0.000194	0.000257	0.000073	0.000105	0.000174	0.000006	0.000047	0.000129	0.000017	0.000052	0.000047	0.000075	0.000076	0.000222	0.000210	0.000200	0.000015	0.000026	0.000040	0.000032	0.000084	0.000054	0.000018	0.000045	0.000053	0.000173	0.000512	0.000158	0.000261	0.000193	0.000165	0.000242	0.000306	0.000233	0.000019	0.000107	0.000421	0.000234	0.000056	0.000042	0.000211	0.000094	0.000100	0.000064	0.000115	0.000056	0.000044	0.000017	0.000049	0.000100	0.000136	0.000376	0.000237	0.000389	0.000542	0.000097	0.000350	0.000126	0.000494	0.000513	0.004231	0.001373	0.000426	0.005315	0.000629	0.001393	0.002468	0.001040	0.002808	0.000664	0.003546	0.006624	0.010127	0.000158	0.001261	0.000070	0.000229	0.000082	0.000368	0.000759	0.000551	0.000068	0.000022	0.000069	0.000128	0.000015	0.000114	0.000146	0.000258	0.000783	0.000581	0.000062	0.000009	0.000026	0.000062	0.000010	0.000158	0.000209	0.000285	0.000297	0.000061	0.000031	0.000026	0.000441	0.000100	0.000071	0.000852	0.000054	0.000053	0.000238	0.000334	0.000020	0.000120	0.000264	0.000688	0.000046	0.000333	0.000031	0.000058	0.000623	0.001130	0.000031	0.000127	0.000084	0.000102	0.001403	0.000036	0.000023	0.000035	0.000365	0.000108	0.000815	0.000080	0.000065	0.000435	0.001548	0.000630	0.000096	0.000091	0.000289	0.000048	0.000062	0.000080	0.000105	0.000064	0.000063	0.000552	0.000171	0.000130	0.000548	0.000018	0.000056	0.000046	0.005512	0.000451	0.000591	0.000168	0.000011	0.000021	0.000528	0.000046	0.000418	0.000049	0.000747	0.000037	0.000106	0.000796	0.000385	0.013466	0.003589	0.000522	0.000113	0.007160	0.002774	0.001991	0.000680	0.006705	0.018849	0.020340	0.004462	0.000726	0.001070	0.000868	0.000704	0.004694	0.000160	0.000109	0.012738	0.001282	0.000727	0.001207	0.000912	0.000616	0.000114	0.012790	0.000220	0.001212	0.000381	0.000030
75160674 - Bicep - Bicep - Orca	75160674	0.014836	0.000108	0.000170	0.000429	0.000037	0.000100	0.000078	0.000043	0.000114	0.000051	0.000099	0.000024	0.000029	0.000028	0.000152	0.000091	0.000235	0.000078	0.000148	0.000060	0.000098	0.000063	0.000170	0.000165	0.000147	0.000043	0.000069	0.001604	0.000161	0.000096	0.000042	0.000062	0.000129	0.000352	0.000134	0.000206	0.000179	0.000097	0.000123	0.000017	0.000205	0.000152	0.000025	0.000089	0.000053	0.000030	0.000110	0.000114	0.000059	0.000115	0.000087	0.000021	0.000016	0.000031	0.000093	0.000069	0.000006	0.000044	0.000094	0.000104	0.000070	0.000024	0.000026	0.000050	0.000119	0.000261	0.000080	0.000015	0.000023	0.000358	0.000046	0.000007	0.001148	0.000921	0.000690	0.000195	0.000123	0.000245	0.000177	0.000054	0.000102	0.000190	0.000056	0.000136	0.000138	0.000032	0.000141	0.000046	0.000039	0.000023	0.000034	0.000033	0.002444	0.000046	0.000100	0.000047	0.000070	0.000055	0.000283	0.000200	0.000112	0.000108	0.000059	0.000062	0.000054	0.000074	0.000050	0.000046	0.000033	0.000023	0.000065	0.000532	0.000208	0.000204	0.000009	0.000066	0.000046	0.000029	0.000023	0.000115	0.000042	0.000009	0.000196	0.000076	0.000053	0.000039	0.000516	0.000153	0.000154	0.000245	0.000423	0.000100	0.000191	0.000081	0.000039	0.000683	0.000031	0.787959	0.070333	0.002711	0.003137	0.000697	0.000404	0.000356	0.000195	0.000168	0.000393	0.000165	0.000130	0.000179	0.000190	0.000185	0.007011	0.004925	0.003060	0.000929	0.000849	0.000375	0.059975	0.079579	0.000230	0.007105	0.012793	0.202871	0.020055	0.003716	0.002313	0.001595	0.007711	0.000320	0.000081	0.003227	0.002834	0.001018	0.000198	0.000030	0.000062	0.000227	0.000403	0.000484	0.000701	0.000570	0.000210	0.000190	0.000948	0.000807	0.000202	0.000461	0.000189	0.000662	0.000096	0.001097	0.000309	0.000180	0.000100	0.001758	0.000611	0.000238	0.000267	0.000226	0.000945	0.000307	0.000335	0.000133	0.000221	0.000480	0.000306	0.000084	0.000180	0.000183	0.000265	0.000094	0.000539	0.002227	0.000620	0.000597	0.008915	0.006744	0.000077	0.002194	0.000771	0.000394	0.000195	0.000819	0.000485	0.000082	0.006284	0.001548	0.000961	0.000359	0.000263	0.000125	0.003869	0.000246	0.000707	0.002301	0.014599	0.001064	0.000206	0.210676	0.097054	0.059909	0.034699	0.109278	0.198156	0.074690	0.009186	0.132705	0.000314	0.000213	0.000059	0.001712	0.000333	0.002519	0.000147	0.000050	0.000934	0.001076	0.000340	0.000397	0.000357	0.000104	0.000090	0.000245	0.000200	0.002151	0.000957	0.004889	0.003266	0.000927	0.011809	0.000255	0.001833	0.000317	0.016493	0.000095	0.001533	0.000601	0.000296	0.001504	0.010044	0.000059	0.000143	0.000067	0.000076	0.000059	0.000013	0.000019	0.000138	0.000024	0.000017	0.000019	0.000052	0.000017	0.000055	0.000039	0.000119	0.000097	0.000018	0.000075	0.001653	0.000151	0.000026	0.000053	0.000069	0.000025	0.000140	0.000464	0.000920	0.000154	0.000258	0.000006	0.000019	0.000033	0.000060	0.000057	0.000111	0.000021	0.000365	0.000016	0.000042	0.000031	0.000239	0.000202	0.000146	0.000098	0.000127	0.000044	0.000172	0.000247	0.000079	0.000088	0.000149	0.000004	0.000037	0.000057	0.000010	0.000030	0.000019	0.000045	0.000038	0.000107	0.000042	0.000167	0.000007	0.000020	0.000027	0.000020	0.000063	0.000039	0.000012	0.000046	0.000044	0.000133	0.000161	0.000238	0.000404	0.000058	0.000056	0.000102	0.000118	0.000131	0.000004	0.000037	0.000190	0.000113	0.000017	0.000027	0.000141	0.000027	0.000050	0.000036	0.000026	0.000023	0.000034	0.000005	0.000030	0.000040	0.000067	0.000389	0.000063	0.000047	0.000071	0.000010	0.000115	0.000039	0.000136	0.000071	0.007087	0.000921	0.000417	0.004801	0.000290	0.000811	0.001688	0.001892	0.001570	0.000437	0.006723	0.010949	0.025587	0.000069	0.001090	0.000118	0.000241	0.000099	0.000547	0.000567	0.000579	0.000089	0.000023	0.000031	0.000057	0.000008	0.000060	0.000095	0.000071	0.000148	0.000359	0.000056	0.000009	0.000021	0.000042	0.000004	0.000093	0.000098	0.000093	0.000131	0.000041	0.000011	0.000011	0.000170	0.000051	0.000032	0.000327	0.000024	0.000011	0.000129	0.000127	0.000006	0.000013	0.000309	0.000269	0.000013	0.000186	0.000021	0.000024	0.000226	0.000470	0.000017	0.000063	0.000035	0.000076	0.000352	0.000023	0.000021	0.000016	0.000493	0.000037	0.000351	0.000041	0.000032	0.000365	0.002900	0.000917	0.000022	0.000043	0.000057	0.000031	0.000020	0.000030	0.000044	0.000024	0.000034	0.000142	0.000121	0.000057	0.000678	0.000006	0.000016	0.000009	0.005825	0.000354	0.000781	0.000274	0.000009	0.000018	0.000572	0.000030	0.000380	0.000043	0.000260	0.000028	0.000060	0.000395	0.000395	0.001619	0.000622	0.000198	0.000020	0.003510	0.004979	0.002157	0.000832	0.007625	0.004046	0.008191	0.002620	0.000369	0.000650	0.000722	0.001937	0.007634	0.000092	0.000118	0.002549	0.000150	0.001041	0.000259	0.000289	0.000232	0.000044	0.002700	0.000140	0.000703	0.000319	0.000039
75160675 - Bicep - Bicep - Glue	75160675	0.022015	0.000258	0.000316	0.000785	0.000087	0.000324	0.000142	0.000208	0.000163	0.000098	0.000140	0.000053	0.000051	0.000043	0.000253	0.000192	0.000533	0.000280	0.000242	0.000177	0.000219	0.000108	0.000436	0.000602	0.000331	0.000096	0.000077	0.001815	0.000144	0.000264	0.000081	0.000137	0.000171	0.000364	0.000234	0.000310	0.003520	0.000304	0.000212	0.000025	0.000878	0.000230	0.000056	0.000054	0.000062	0.000057	0.000116	0.000237	0.000112	0.000146	0.000091	0.000044	0.000020	0.000071	0.000185	0.000116	0.000003	0.000023	0.000096	0.000200	0.000069	0.000192	0.000014	0.000122	0.000339	0.000660	0.000093	0.000024	0.000030	0.000380	0.000053	0.000019	0.002016	0.001621	0.001291	0.000332	0.000279	0.000563	0.000317	0.000086	0.000212	0.000210	0.000034	0.000150	0.000153	0.000041	0.000251	0.000131	0.000122	0.000049	0.000057	0.000052	0.000852	0.000091	0.000193	0.000138	0.000295	0.000201	0.000470	0.000319	0.000187	0.000177	0.000149	0.000154	0.000080	0.000136	0.000090	0.000098	0.000027	0.000019	0.000058	0.000473	0.000271	0.000252	0.000005	0.000087	0.000058	0.000026	0.000029	0.000192	0.000077	0.000018	0.000432	0.000090	0.000094	0.000051	0.000529	0.000226	0.000153	0.000182	0.000191	0.000057	0.000324	0.000128	0.000068	0.001392	0.000036	0.726277	0.104135	0.002519	0.002982	0.000650	0.000679	0.000582	0.000241	0.000192	0.000551	0.000175	0.000138	0.000145	0.000204	0.000136	0.021720	0.014258	0.010583	0.001750	0.001706	0.000712	0.072524	0.070623	0.000697	0.012787	0.027094	0.275799	0.049719	0.008300	0.007034	0.002346	0.022226	0.000121	0.000168	0.003842	0.004016	0.001464	0.000968	0.000484	0.000829	0.000296	0.000196	0.000702	0.000955	0.000900	0.000233	0.000065	0.000517	0.000648	0.000153	0.000386	0.000124	0.000561	0.000080	0.000823	0.000253	0.000252	0.000156	0.005720	0.007884	0.000317	0.000465	0.000197	0.000312	0.000074	0.000360	0.000114	0.000330	0.000527	0.000247	0.000012	0.000853	0.000562	0.000159	0.000714	0.002199	0.007701	0.001761	0.012564	0.003451	0.057398	0.001082	0.002631	0.000713	0.000643	0.000242	0.000804	0.000606	0.000276	0.004715	0.002856	0.004438	0.000363	0.000458	0.000114	0.004155	0.000788	0.000886	0.001321	0.002935	0.000998	0.000139	0.157288	0.011719	0.010184	0.033843	0.120830	0.021984	0.004362	0.010951	0.002606	0.000424	0.000198	0.000072	0.001367	0.000634	0.002313	0.000532	0.000087	0.001070	0.001454	0.000427	0.000409	0.000227	0.000167	0.000230	0.000242	0.000492	0.001840	0.001158	0.002285	0.002012	0.000817	0.004078	0.000554	0.000606	0.000350	0.002006	0.000128	0.000638	0.000625	0.000554	0.001609	0.002573	0.000056	0.000089	0.000094	0.000078	0.000087	0.000015	0.000020	0.000162	0.000036	0.000031	0.000030	0.000052	0.000013	0.000044	0.000032	0.000110	0.000109	0.000047	0.000158	0.001706	0.000231	0.000037	0.000096	0.000107	0.000027	0.000139	0.000479	0.000547	0.000146	0.000798	0.000010	0.000022	0.000028	0.000060	0.000055	0.000112	0.000016	0.000186	0.000019	0.000116	0.000029	0.000609	0.000563	0.000322	0.000172	0.000102	0.000034	0.000094	0.000127	0.000056	0.000047	0.000079	0.000002	0.000010	0.000060	0.000008	0.000017	0.000020	0.000035	0.000035	0.000220	0.000111	0.000177	0.000007	0.000012	0.000041	0.000011	0.000075	0.000052	0.000010	0.000037	0.000052	0.000125	0.000141	0.000167	0.000521	0.000055	0.000054	0.000089	0.000152	0.000236	0.000004	0.000043	0.000146	0.000078	0.000121	0.000041	0.000042	0.000016	0.000064	0.000040	0.000052	0.000006	0.000022	0.000045	0.000039	0.000014	0.000129	0.000847	0.000190	0.000233	0.000138	0.000063	0.000212	0.000102	0.000287	0.000315	0.006875	0.001254	0.000656	0.004645	0.000597	0.004367	0.004106	0.002016	0.003079	0.000682	0.005537	0.007786	0.014952	0.000096	0.006770	0.000140	0.000245	0.000122	0.000623	0.000753	0.000636	0.000098	0.000017	0.000052	0.000032	0.000005	0.000107	0.000115	0.000132	0.000241	0.000283	0.000029	0.000010	0.000030	0.000078	0.000020	0.000060	0.000050	0.000122	0.000219	0.000066	0.000021	0.000020	0.000289	0.000057	0.000034	0.000266	0.000028	0.000018	0.000163	0.000627	0.000013	0.000026	0.000286	0.000218	0.000017	0.000138	0.000024	0.000033	0.000199	0.000316	0.000018	0.000093	0.000044	0.000067	0.000360	0.000021	0.000026	0.000012	0.001581	0.000055	0.000410	0.000061	0.000048	0.001492	0.003993	0.002101	0.000036	0.000032	0.000112	0.000055	0.000012	0.000042	0.000120	0.000036	0.000054	0.005332	0.000235	0.000153	0.000995	0.000026	0.000105	0.000089	0.004708	0.000225	0.000507	0.000220	0.000019	0.000011	0.000563	0.000034	0.000456	0.000055	0.000413	0.000023	0.000062	0.000622	0.000479	0.002397	0.000097	0.000267	0.000080	0.004423	0.017462	0.002830	0.003005	0.007346	0.001912	0.012921	0.002548	0.000361	0.000983	0.001032	0.002775	0.005030	0.000295	0.000107	0.004837	0.000189	0.001208	0.002198	0.000498	0.000267	0.000023	0.002666	0.000141	0.000318	0.000482	0.000050
75160676 - Bicep - Bicep - Kites	75160676	0.024610	0.000399	0.000375	0.000513	0.000157	0.000314	0.000147	0.000082	0.000189	0.000095	0.000165	0.000039	0.000068	0.000055	0.000226	0.000243	0.000290	0.000076	0.000126	0.000105	0.000095	0.000115	0.000232	0.000190	0.000173	0.000096	0.000145	0.002407	0.000316	0.000082	0.000066	0.000071	0.000236	0.000240	0.000109	0.000167	0.002238	0.000082	0.000151	0.000034	0.000512	0.000291	0.000069	0.000224	0.000094	0.000066	0.000210	0.000146	0.000102	0.000247	0.000134	0.000040	0.000034	0.000140	0.000264	0.000163	0.000021	0.000113	0.000132	0.000186	0.000571	0.000160	0.000105	0.000256	0.000171	0.000391	0.000152	0.000049	0.000048	0.000483	0.000066	0.000018	0.003228	0.002407	0.001544	0.000337	0.000274	0.000695	0.000351	0.000139	0.000222	0.000624	0.000141	0.000334	0.000255	0.000139	0.000629	0.000220	0.000152	0.000088	0.000157	0.000138	0.000502	0.000098	0.000124	0.000150	0.000167	0.000166	0.000950	0.000898	0.000476	0.000519	0.000155	0.000145	0.000106	0.000133	0.000118	0.000097	0.000090	0.000075	0.000134	0.001196	0.000390	0.000303	0.000019	0.000184	0.000125	0.000091	0.000076	0.000103	0.000041	0.000034	0.000453	0.000135	0.000157	0.000108	0.000928	0.000185	0.000588	0.000695	0.000419	0.000284	0.000224	0.000105	0.000077	0.000418	0.000013	0.778415	0.123555	0.002438	0.002694	0.000558	0.000494	0.000425	0.000212	0.000118	0.000481	0.000484	0.000247	0.000245	0.000277	0.000177	0.040642	0.027715	0.021700	0.003096	0.003428	0.001126	0.170552	0.125457	0.002370	0.007753	0.018990	0.350757	0.031917	0.004306	0.003807	0.001290	0.012969	0.000264	0.000197	0.001654	0.001629	0.000953	0.000225	0.000073	0.000193	0.000094	0.000383	0.002428	0.004345	0.002930	0.000765	0.000387	0.001475	0.001940	0.000423	0.001347	0.000711	0.000853	0.000090	0.001945	0.000600	0.000225	0.000100	0.002437	0.001145	0.000466	0.000526	0.000335	0.000652	0.000386	0.000364	0.000095	0.000229	0.000594	0.000438	0.000162	0.000486	0.000611	0.000993	0.000144	0.001556	0.003258	0.000218	0.001500	0.012375	0.036642	0.000149	0.001542	0.000438	0.000671	0.000295	0.001031	0.000928	0.000185	0.018332	0.004725	0.006487	0.001122	0.000988	0.000456	0.013535	0.000547	0.001462	0.003588	0.011022	0.002016	0.000237	0.097925	0.029380	0.027060	0.016490	0.026739	0.065872	0.014116	0.002661	0.009857	0.000560	0.000285	0.000072	0.003161	0.000692	0.002228	0.000205	0.000074	0.003427	0.008715	0.000829	0.001136	0.000432	0.000161	0.000154	0.000568	0.000490	0.003050	0.001294	0.007405	0.005816	0.001823	0.012559	0.000428	0.007594	0.000812	0.008100	0.000248	0.003842	0.003630	0.000487	0.003108	0.012135	0.000017	0.000073	0.000126	0.000127	0.000104	0.000026	0.000034	0.000238	0.000060	0.000043	0.000045	0.000080	0.000028	0.000082	0.000062	0.000170	0.000137	0.000043	0.000122	0.001959	0.000209	0.000043	0.000080	0.000086	0.000041	0.000229	0.000610	0.000855	0.000174	0.000346	0.000028	0.000031	0.000046	0.000068	0.000087	0.000271	0.000041	0.001634	0.000032	0.000139	0.000048	0.000984	0.000571	0.000393	0.000406	0.000146	0.000062	0.000263	0.000362	0.000145	0.000164	0.000222	0.000006	0.000029	0.000140	0.000016	0.000048	0.000036	0.000075	0.000079	0.000102	0.000120	0.000204	0.000010	0.000035	0.000046	0.000071	0.000078	0.000050	0.000009	0.000091	0.000057	0.000158	0.000418	0.000484	0.000545	0.000167	0.000118	0.000386	0.000215	0.000171	0.000028	0.000160	0.000210	0.000124	0.000115	0.000073	0.000119	0.000057	0.000110	0.000083	0.000058	0.000050	0.000084	0.000018	0.000080	0.000067	0.000209	0.000476	0.000108	0.000085	0.000339	0.000088	0.000113	0.000077	0.000169	0.000205	0.001993	0.002216	0.000740	0.012135	0.000718	0.003625	0.002372	0.000976	0.005688	0.002085	0.002414	0.002419	0.002341	0.000210	0.000729	0.000200	0.000127	0.000059	0.000844	0.000979	0.001105	0.000049	0.000025	0.000047	0.000057	0.000014	0.000124	0.000132	0.000205	0.000347	0.000449	0.000087	0.000013	0.000095	0.000105	0.000021	0.000161	0.000171	0.000125	0.000316	0.000102	0.000023	0.000032	0.000270	0.000085	0.000060	0.000397	0.000035	0.000013	0.000437	0.000768	0.000024	0.000051	0.000155	0.000333	0.000024	0.000235	0.000020	0.000049	0.000373	0.000584	0.000024	0.000105	0.000055	0.000082	0.000553	0.000033	0.000035	0.000023	0.000244	0.000091	0.000261	0.000052	0.000117	0.000513	0.002179	0.000796	0.000079	0.000082	0.000287	0.000077	0.000053	0.000061	0.000229	0.000119	0.000067	0.000247	0.000212	0.000200	0.000898	0.000031	0.000055	0.000046	0.004115	0.000653	0.000984	0.000255	0.000016	0.000014	0.000386	0.000030	0.000342	0.000089	0.000226	0.000060	0.000049	0.000859	0.001391	0.001083	0.003200	0.000449	0.000114	0.004173	0.007418	0.004156	0.001497	0.008020	0.002082	0.008108	0.002059	0.000338	0.000884	0.001193	0.000677	0.003428	0.000208	0.000159	0.003798	0.000347	0.000742	0.000661	0.000723	0.000276	0.000065	0.000748	0.000091	0.001114	0.000474	0.000044
75160677 - Bicep - Bicep - Vespa	75160677	0.671638	0.008794	0.005611	0.004261	0.001439	0.005822	0.000467	0.001827	0.001203	0.000651	0.000693	0.000135	0.000144	0.000077	0.000957	0.012093	0.000554	0.000194	0.000243	0.000194	0.000147	0.000266	0.000358	0.000247	0.000334	0.000574	0.001642	0.007146	0.001909	0.000080	0.000675	0.000980	0.001149	0.001084	0.000419	0.000352	0.001594	0.000274	0.001106	0.000504	0.000567	0.001507	0.000073	0.000331	0.000746	0.000261	0.000848	0.000269	0.000242	0.000820	0.000237	0.000207	0.000662	0.000505	0.001417	0.000766	0.000427	0.000424	0.000269	0.000473	0.000507	0.000558	0.000580	0.000374	0.000078	0.000146	0.000508	0.000344	0.000264	0.002934	0.001392	0.000042	0.005010	0.002801	0.001666	0.000345	0.000291	0.000461	0.000316	0.000526	0.000311	0.000806	0.000177	0.000487	0.000698	0.000194	0.000718	0.000461	0.000356	0.000148	0.000224	0.000198	0.000030	0.000329	0.000803	0.000213	0.000408	0.000389	0.000752	0.000481	0.000239	0.000271	0.000185	0.000173	0.000371	0.000518	0.000208	0.000196	0.000195	0.000147	0.000898	0.002371	0.001114	0.000906	0.000124	0.000554	0.000357	0.000376	0.000322	0.000230	0.000077	0.000052	0.000588	0.000350	0.000479	0.000174	0.002082	0.000439	0.000649	0.001255	0.006631	0.000824	0.000532	0.000253	0.000320	0.000784	0.001434	0.654226	0.064518	0.002611	0.003618	0.000566	0.000424	0.000372	0.000175	0.000074	0.000445	0.000081	0.000046	0.000111	0.000079	0.000518	0.024180	0.014430	0.007208	0.002688	0.002548	0.001306	0.072315	0.014298	0.000230	0.002442	0.000825	0.001821	0.001563	0.000251	0.000124	0.000174	0.000355	0.000349	0.000060	0.000242	0.000158	0.000525	0.000444	0.000130	0.000299	0.002530	0.000397	0.000695	0.001188	0.000763	0.000662	0.000355	0.004028	0.003449	0.001245	0.000828	0.001089	0.000543	0.000109	0.000739	0.000200	0.000202	0.000096	0.001507	0.000415	0.000139	0.000111	0.000374	0.001222	0.000516	0.000071	0.000044	0.000262	0.000194	0.000097	0.000051	0.000045	0.000139	0.000126	0.001357	0.000818	0.045445	0.002723	0.002783	0.001035	0.003460	0.001143	0.001291	0.000653	0.000299	0.000143	0.000323	0.000252	0.000101	0.000561	0.000422	0.000411	0.000207	0.000038	0.000059	0.000317	0.000216	0.000325	0.000776	0.000992	0.004311	0.000556	0.121167	0.010468	0.010890	0.011765	0.007174	0.020892	0.007162	0.032854	0.021074	0.000229	0.000136	0.000101	0.000365	0.000396	0.003488	0.001146	0.000252	0.000281	0.000162	0.000341	0.000589	0.000363	0.000135	0.000059	0.000103	0.000352	0.001292	0.002406	0.000817	0.000605	0.000391	0.001866	0.000676	0.000299	0.000244	0.000993	0.000163	0.000204	0.000418	0.000357	0.001046	0.000731	0.000145	0.000375	0.000286	0.000747	0.000270	0.000198	0.000221	0.000557	0.000236	0.000160	0.000174	0.000326	0.000170	0.000215	0.000142	0.000383	0.000457	0.000121	0.000569	0.003750	0.000450	0.000111	0.000181	0.000200	0.000122	0.000276	0.000977	0.002269	0.000108	0.000135	0.000027	0.000055	0.000068	0.000239	0.000277	0.000315	0.000122	0.001976	0.000025	0.000022	0.000122	0.000418	0.000373	0.000179	0.000255	0.000206	0.000084	0.000527	0.000819	0.000205	0.000329	0.000457	0.000010	0.000290	0.000344	0.000055	0.000148	0.000137	0.000174	0.000222	0.000285	0.000211	0.000403	0.000019	0.000031	0.000030	0.000052	0.000194	0.000213	0.000023	0.000060	0.000124	0.000365	0.001106	0.000102	0.000077	0.000429	0.000315	0.000172	0.001142	0.000231	0.000051	0.000311	0.000510	0.000238	0.000154	0.000169	0.000444	0.000140	0.000221	0.000171	0.000177	0.000046	0.000092	0.000039	0.000086	0.000122	0.001631	0.000152	0.000127	0.000680	0.000220	0.000284	0.001590	0.000168	0.001791	0.002590	0.002364	0.001550	0.000264	0.000450	0.000749	0.001396	0.001208	0.000155	0.011573	0.008393	0.001516	0.003680	0.003547	0.000670	0.000592	0.000526	0.000156	0.000072	0.000151	0.000628	0.000762	0.000061	0.000046	0.000122	0.000313	0.000077	0.000267	0.000131	0.000729	0.000595	0.000448	0.000079	0.000014	0.000048	0.000111	0.000054	0.000171	0.000282	0.000611	0.000741	0.000219	0.000131	0.000187	0.000930	0.000232	0.000124	0.000903	0.000289	0.000082	0.000212	0.000213	0.000009	0.000211	0.000117	0.000424	0.000063	0.000513	0.000079	0.000107	0.000700	0.000760	0.000167	0.000283	0.000062	0.000109	0.001129	0.000034	0.000074	0.000113	0.004043	0.000308	0.001715	0.000526	0.000381	0.000327	0.004562	0.000964	0.000133	0.000348	0.000470	0.000217	0.000143	0.000137	0.000070	0.000180	0.000377	0.002019	0.000900	0.000244	0.000211	0.000009	0.000305	0.000330	0.003349	0.000915	0.000190	0.000065	0.000098	0.000024	0.005318	0.000175	0.001448	0.000234	0.009444	0.000079	0.000405	0.001378	0.000105	0.001908	0.000069	0.001079	0.000354	0.009155	0.008655	0.006375	0.001253	0.034459	0.001426	0.043523	0.019568	0.005548	0.003451	0.002615	0.033673	0.032946	0.001381	0.000644	0.004268	0.000299	0.001407	0.002815	0.003236	0.003302	0.000569	0.001121	0.000461	0.003501	0.002624	0.000432
75160678 - Bicep - Bicep - Ayaya	75160678	0.019302	0.000194	0.000346	0.000825	0.000109	0.000214	0.000187	0.000083	0.000123	0.000037	0.000070	0.000025	0.000043	0.000041	0.000209	0.000068	0.000457	0.000165	0.000162	0.000158	0.000125	0.000106	0.000428	0.000401	0.000322	0.000073	0.000088	0.001745	0.000099	0.000184	0.000047	0.000130	0.000132	0.000385	0.000261	0.000237	0.001290	0.000244	0.000307	0.000018	0.000142	0.000156	0.000044	0.000122	0.000058	0.000036	0.000131	0.000204	0.000099	0.000102	0.000099	0.000078	0.000013	0.000134	0.000174	0.000171	0.000012	0.000028	0.000140	0.000102	0.000261	0.000195	0.000074	0.000227	0.000268	0.000727	0.000092	0.000035	0.000080	0.000361	0.000079	0.000052	0.003072	0.002001	0.001552	0.000398	0.000398	0.000733	0.000485	0.000168	0.000278	0.000379	0.000119	0.000217	0.000180	0.000085	0.000268	0.000147	0.000141	0.000037	0.000076	0.000069	0.001207	0.000090	0.000152	0.000105	0.000146	0.000143	0.000501	0.000296	0.000164	0.000169	0.000125	0.000126	0.000119	0.000165	0.000105	0.000107	0.000062	0.000046	0.000116	0.000813	0.000345	0.000288	0.000010	0.000124	0.000082	0.000167	0.000152	0.000096	0.000037	0.000021	0.000420	0.000172	0.000199	0.000137	0.000761	0.000322	0.000247	0.000290	0.000197	0.000101	0.000241	0.000061	0.000122	0.002915	0.000144	0.791874	0.099178	0.002710	0.002868	0.000529	0.000543	0.000468	0.000246	0.000197	0.000460	0.000233	0.000290	0.000241	0.000422	0.000219	0.014815	0.009278	0.005882	0.001824	0.001671	0.000720	0.120345	0.051203	0.000526	0.017322	0.012462	0.222266	0.029235	0.003557	0.002229	0.000975	0.008876	0.000389	0.000519	0.002665	0.002413	0.005623	0.000823	0.000481	0.000408	0.000514	0.001591	0.009382	0.013427	0.011824	0.004461	0.000268	0.000896	0.000936	0.000331	0.000414	0.000146	0.000756	0.000082	0.001207	0.000642	0.000238	0.000128	0.008047	0.011031	0.000592	0.000605	0.000796	0.000602	0.000167	0.000772	0.000061	0.000327	0.002166	0.000578	0.000017	0.000647	0.000247	0.000348	0.000628	0.004063	0.007192	0.008721	0.001440	0.003044	0.023595	0.000607	0.001372	0.000523	0.000349	0.000155	0.000505	0.000310	0.000137	0.005223	0.003837	0.002153	0.000481	0.000161	0.000166	0.002004	0.000990	0.001280	0.001796	0.001574	0.001941	0.000130	0.142351	0.010905	0.016707	0.023156	0.038174	0.053975	0.005178	0.080006	0.008166	0.000347	0.000227	0.000165	0.001567	0.000867	0.022358	0.000277	0.000097	0.001313	0.001061	0.000662	0.000357	0.000342	0.000326	0.000206	0.000109	0.001350	0.001679	0.000526	0.006777	0.003391	0.001215	0.008738	0.002640	0.001560	0.000887	0.001635	0.000213	0.000913	0.000406	0.001349	0.004621	0.001774	0.000022	0.000199	0.000139	0.000121	0.000117	0.000039	0.000045	0.000334	0.000125	0.000161	0.000124	0.000094	0.000027	0.000085	0.000055	0.000113	0.000210	0.000096	0.000263	0.002741	0.000354	0.000065	0.000167	0.000102	0.000040	0.000237	0.000676	0.000817	0.000234	0.000235	0.000019	0.000031	0.000043	0.000082	0.000110	0.000178	0.000038	0.000411	0.000029	0.000282	0.000072	0.000359	0.000241	0.000245	0.000155	0.000260	0.000079	0.000231	0.000319	0.000112	0.000164	0.000194	0.000006	0.000040	0.000093	0.000014	0.000028	0.000037	0.000058	0.000062	0.000640	0.000073	0.000248	0.000011	0.000011	0.000041	0.000055	0.000091	0.000054	0.000025	0.000061	0.000068	0.000175	0.000243	0.000114	0.001606	0.000091	0.000060	0.000235	0.000310	0.000126	0.000009	0.000039	0.000332	0.000161	0.000127	0.000072	0.000050	0.000031	0.000195	0.000112	0.000099	0.000012	0.000038	0.000046	0.000052	0.000026	0.000193	0.000936	0.000067	0.000344	0.000188	0.000063	0.000184	0.000263	0.000213	0.000118	0.001380	0.000528	0.000237	0.003534	0.000284	0.001187	0.000928	0.000547	0.001612	0.000554	0.000954	0.000921	0.000995	0.000197	0.000847	0.000107	0.000728	0.000380	0.001525	0.001915	0.001834	0.000385	0.000063	0.000052	0.000065	0.000013	0.000052	0.000125	0.000109	0.000218	0.000396	0.000145	0.000042	0.000042	0.000053	0.000012	0.000089	0.000055	0.000100	0.000252	0.000090	0.000022	0.000022	0.000229	0.000067	0.000046	0.000183	0.000044	0.000024	0.000235	0.001300	0.000025	0.000104	0.002011	0.001099	0.000039	0.000393	0.000041	0.000060	0.000312	0.001548	0.000057	0.000125	0.000128	0.000173	0.000729	0.000048	0.000050	0.000036	0.002058	0.000090	0.000244	0.000086	0.000069	0.000762	0.002204	0.000718	0.000079	0.000021	0.000172	0.000097	0.000046	0.000061	0.000118	0.000050	0.000059	0.000504	0.000207	0.000094	0.000443	0.000028	0.000111	0.000032	0.000877	0.000942	0.000959	0.000243	0.000009	0.000036	0.000381	0.000038	0.000579	0.000072	0.000162	0.000047	0.000087	0.000331	0.001711	0.002721	0.000087	0.000113	0.000068	0.003051	0.003766	0.006412	0.001207	0.005224	0.001081	0.010039	0.003629	0.000536	0.001253	0.001440	0.002398	0.008073	0.000149	0.000088	0.001750	0.000295	0.000473	0.000420	0.000148	0.000214	0.000025	0.003353	0.000124	0.000416	0.000256	0.000041
75160681 - Bicep - Bicep - Opal	75160681	0.015425	0.000215	0.000250	0.000429	0.000063	0.000194	0.000113	0.000060	0.000104	0.000058	0.000088	0.000026	0.000043	0.000040	0.000219	0.000129	0.000222	0.000096	0.000110	0.000089	0.000093	0.000088	0.000191	0.000238	0.000203	0.000064	0.000093	0.001472	0.000131	0.000061	0.000040	0.000077	0.000169	0.000255	0.000147	0.000089	0.000683	0.000080	0.000132	0.000019	0.000265	0.000161	0.000068	0.000115	0.000061	0.000035	0.000113	0.000119	0.000062	0.000135	0.000127	0.000029	0.000034	0.000062	0.000093	0.000077	0.000004	0.000086	0.000165	0.000129	0.000076	0.000078	0.000026	0.000084	0.000715	0.002189	0.000084	0.000020	0.000023	0.000299	0.000047	0.000019	0.002107	0.001659	0.001319	0.000332	0.000281	0.000762	0.000305	0.000116	0.000191	0.000267	0.000068	0.000165	0.000238	0.000052	0.000223	0.000082	0.000060	0.000028	0.000068	0.000070	0.003367	0.000047	0.000073	0.000107	0.000187	0.000157	0.000459	0.000267	0.000143	0.000205	0.000141	0.000134	0.000074	0.000102	0.000105	0.000101	0.000067	0.000050	0.000104	0.000534	0.000240	0.000194	0.000015	0.000086	0.000075	0.000082	0.000077	0.000160	0.000045	0.000014	0.000394	0.000076	0.000086	0.000046	0.000383	0.000122	0.000122	0.000205	0.000202	0.000082	0.000215	0.000101	0.000077	0.000676	0.000025	0.776084	0.128093	0.007004	0.007331	0.001334	0.001794	0.001038	0.000392	0.000481	0.000909	0.000272	0.000220	0.000383	0.000470	0.000680	0.019500	0.013976	0.008968	0.000582	0.000534	0.000277	0.169621	0.140128	0.000559	0.012142	0.021750	0.585211	0.038348	0.006139	0.005113	0.001407	0.015604	0.000250	0.000201	0.003309	0.003240	0.002640	0.000135	0.000123	0.000142	0.000399	0.000480	0.001449	0.002381	0.001784	0.000656	0.000345	0.000567	0.001192	0.000213	0.001044	0.000301	0.001092	0.000065	0.001347	0.001165	0.000231	0.000184	0.003769	0.001507	0.000675	0.000905	0.000757	0.000554	0.000356	0.000180	0.000065	0.000153	0.000285	0.000200	0.000120	0.000995	0.000338	0.000329	0.000074	0.001949	0.001775	0.000540	0.002183	0.006017	0.023164	0.000211	0.001983	0.000411	0.000438	0.000194	0.000679	0.000371	0.000196	0.006231	0.002305	0.005625	0.000524	0.000762	0.000187	0.007104	0.000417	0.000673	0.002808	0.008203	0.000964	0.000075	0.184738	0.067741	0.036770	0.035152	0.019911	0.062923	0.027206	0.003104	0.009133	0.000541	0.000280	0.000130	0.002301	0.000573	0.000741	0.000185	0.000049	0.001740	0.002769	0.000430	0.000438	0.000293	0.000163	0.000119	0.000280	0.000379	0.001991	0.000544	0.002690	0.001891	0.000692	0.005812	0.000473	0.001077	0.000338	0.005678	0.000115	0.001192	0.000993	0.000222	0.001446	0.004171	0.000016	0.000056	0.000111	0.000085	0.000101	0.000031	0.000040	0.000202	0.000033	0.000023	0.000023	0.000057	0.000024	0.000053	0.000044	0.000178	0.000101	0.000034	0.000101	0.002157	0.000149	0.000029	0.000074	0.000057	0.000032	0.000256	0.000649	0.001109	0.000154	0.000425	0.000015	0.000028	0.000036	0.000064	0.000072	0.000287	0.000034	0.001207	0.000023	0.000157	0.000050	0.001524	0.000822	0.000540	0.000611	0.000124	0.000059	0.000215	0.000295	0.000141	0.000161	0.000189	0.000003	0.000026	0.000117	0.000021	0.000043	0.000025	0.000053	0.000079	0.000106	0.000052	0.000173	0.000015	0.000049	0.000023	0.000034	0.000077	0.000044	0.000008	0.000068	0.000043	0.000192	0.000197	0.000163	0.000367	0.000086	0.000058	0.000225	0.000130	0.000191	0.000013	0.000066	0.000210	0.000116	0.000027	0.000074	0.000089	0.000052	0.000100	0.000078	0.000054	0.000052	0.000063	0.000006	0.000065	0.000081	0.000070	0.000395	0.000055	0.000088	0.000242	0.000032	0.000116	0.000039	0.000175	0.000141	0.001853	0.000669	0.000232	0.007131	0.000359	0.002168	0.001708	0.000651	0.006202	0.001729	0.001519	0.001384	0.003475	0.000055	0.000727	0.000192	0.000122	0.000048	0.000384	0.000767	0.000613	0.000037	0.000012	0.000024	0.000058	0.000015	0.000046	0.000128	0.000108	0.000131	0.000348	0.000071	0.000008	0.000043	0.000089	0.000024	0.000091	0.000123	0.000127	0.000202	0.000066	0.000015	0.000024	0.000127	0.000070	0.000048	0.000250	0.000034	0.000021	0.000259	0.000415	0.000011	0.000020	0.000252	0.000325	0.000022	0.000196	0.000024	0.000038	0.000238	0.000426	0.000018	0.000083	0.000044	0.000103	0.000381	0.000029	0.000058	0.000022	0.000483	0.000039	0.000439	0.000056	0.000056	0.002112	0.005496	0.001227	0.000034	0.000034	0.000103	0.000048	0.000018	0.000034	0.000127	0.000028	0.000053	0.000217	0.000174	0.000165	0.000533	0.000008	0.000039	0.000018	0.001851	0.000715	0.000576	0.000267	0.000014	0.000013	0.000398	0.000031	0.000370	0.000084	0.000257	0.000035	0.000132	0.000359	0.000509	0.002574	0.000213	0.000152	0.000028	0.003730	0.006959	0.004193	0.002128	0.007253	0.004815	0.012969	0.002727	0.000310	0.001125	0.001025	0.002327	0.006941	0.000190	0.000089	0.002669	0.000291	0.001866	0.002149	0.000453	0.000300	0.000052	0.003740	0.000095	0.000291	0.000314	0.000031
75160679 - Bicep - Bicep - Spring	75160679	0.022597	0.000195	0.000235	0.000561	0.000069	0.000164	0.000132	0.000073	0.000122	0.000054	0.000089	0.000041	0.000020	0.000040	0.000244	0.000221	0.000299	0.000088	0.000128	0.000062	0.000098	0.000062	0.000255	0.000284	0.000185	0.000062	0.000088	0.005037	0.000268	0.000803	0.000075	0.000078	0.000626	0.000949	0.000258	0.000959	0.000251	0.000458	0.000124	0.000015	0.000613	0.000171	0.000078	0.000216	0.000043	0.000016	0.000148	0.000109	0.000042	0.000128	0.000148	0.000046	0.000017	0.000096	0.000161	0.000115	0.000002	0.000074	0.000044	0.000112	0.000107	0.000041	0.000030	0.000062	0.000151	0.000286	0.000101	0.000020	0.000031	0.000348	0.000040	0.000020	0.003398	0.002200	0.001395	0.000314	0.000240	0.000379	0.000328	0.000096	0.000211	0.000521	0.000169	0.000349	0.000477	0.000131	0.000700	0.000213	0.000180	0.000105	0.000170	0.000162	0.013066	0.000186	0.000146	0.000225	0.000248	0.000259	0.000714	0.000552	0.000289	0.000301	0.000166	0.000162	0.000147	0.000197	0.000121	0.000112	0.000088	0.000046	0.000053	0.001195	0.000480	0.000444	0.000022	0.000182	0.000122	0.000068	0.000062	0.000196	0.000075	0.000055	0.000339	0.000194	0.000154	0.000128	0.001374	0.000392	0.001112	0.000879	0.000428	0.000213	0.000335	0.000142	0.000149	0.000982	0.000024	0.688116	0.110666	0.002875	0.003432	0.000745	0.000944	0.000379	0.000287	0.000215	0.000454	0.000321	0.000226	0.000193	0.000197	0.000243	0.014369	0.012276	0.007105	0.000372	0.000371	0.000159	0.066420	0.126655	0.001017	0.037119	0.072990	0.337081	0.104261	0.028785	0.022371	0.009412	0.056709	0.000460	0.000359	0.014548	0.012942	0.002975	0.000721	0.000299	0.000573	0.000102	0.000578	0.001289	0.001825	0.001521	0.000420	0.000423	0.001096	0.000920	0.000155	0.000444	0.000240	0.000992	0.000074	0.001470	0.000453	0.000300	0.000195	0.000907	0.000514	0.000246	0.000306	0.000408	0.000759	0.000201	0.000657	0.000200	0.000239	0.000538	0.000452	0.000088	0.000112	0.000113	0.000135	0.000050	0.000561	0.006975	0.000295	0.001195	0.009191	0.007547	0.000129	0.002795	0.000601	0.000561	0.000281	0.001107	0.001114	0.000345	0.008911	0.004800	0.003839	0.001373	0.001338	0.000522	0.015863	0.000766	0.001584	0.003518	0.035783	0.001733	0.001403	0.145226	0.071889	0.036303	0.011920	0.069919	0.060031	0.023522	0.001817	0.021429	0.000798	0.000531	0.000095	0.002258	0.000616	0.000656	0.000276	0.000113	0.001346	0.002360	0.000564	0.000929	0.000689	0.000240	0.000763	0.000542	0.000379	0.002883	0.003165	0.004463	0.002347	0.001102	0.011106	0.000509	0.003194	0.000476	0.013902	0.000305	0.002412	0.002062	0.000387	0.001477	0.010186	0.000024	0.000081	0.000107	0.000113	0.000085	0.000023	0.000028	0.000239	0.000068	0.000050	0.000055	0.000078	0.000024	0.000061	0.000046	0.000391	0.000121	0.000060	0.000167	0.001899	0.000216	0.000036	0.000087	0.000107	0.000032	0.000150	0.000503	0.000314	0.000066	0.000272	0.000015	0.000017	0.000020	0.000064	0.000051	0.000132	0.000031	0.000177	0.000024	0.000082	0.000035	0.000361	0.000335	0.000200	0.000130	0.000173	0.000031	0.000226	0.000315	0.000111	0.000104	0.000202	0.000006	0.000024	0.000128	0.000022	0.000052	0.000024	0.000104	0.000078	0.000193	0.000055	0.000277	0.000006	0.000086	0.000029	0.000026	0.000101	0.000067	0.000014	0.000055	0.000083	0.000158	0.000227	0.000423	0.000565	0.000095	0.000053	0.000137	0.000259	0.000196	0.000008	0.000076	0.000125	0.000074	0.000029	0.000086	0.000060	0.000022	0.000108	0.000072	0.000053	0.000022	0.000048	0.000015	0.000117	0.000044	0.000165	0.000674	0.000080	0.000072	0.000368	0.000033	0.000145	0.000119	0.000166	0.000127	0.002949	0.000859	0.000283	0.003759	0.000208	0.001382	0.001614	0.000670	0.002433	0.000871	0.003294	0.004151	0.010690	0.000122	0.002367	0.000322	0.000341	0.000194	0.000372	0.000597	0.000599	0.000168	0.000029	0.000033	0.000025	0.000005	0.000050	0.000136	0.000091	0.000214	0.000321	0.000091	0.000022	0.000025	0.000046	0.000008	0.000113	0.000160	0.000089	0.000227	0.000067	0.000014	0.000029	0.000199	0.000139	0.000097	0.000277	0.000033	0.000008	0.000137	0.000127	0.000007	0.000037	0.000279	0.000353	0.000035	0.000189	0.000033	0.000043	0.000169	0.000345	0.000028	0.000100	0.000037	0.000083	0.000630	0.000030	0.000045	0.000020	0.000287	0.000064	0.000364	0.000049	0.000076	0.000459	0.002528	0.000857	0.000044	0.000034	0.000075	0.000050	0.000033	0.000067	0.000088	0.000075	0.000044	0.000342	0.000149	0.000083	0.001507	0.000017	0.000068	0.000058	0.003381	0.000454	0.000998	0.000323	0.000020	0.000017	0.000678	0.000058	0.000542	0.000108	0.000163	0.000047	0.000058	0.000247	0.000884	0.001344	0.000561	0.000372	0.000066	0.003511	0.007948	0.001683	0.001257	0.006696	0.001321	0.008884	0.003450	0.000381	0.001076	0.001404	0.001301	0.005246	0.000145	0.000304	0.003374	0.000241	0.000994	0.001637	0.000588	0.000268	0.000036	0.001537	0.000130	0.000475	0.000467	0.000119
75160680 - Bicep - Bicep - Drift	75160680	0.004984	0.000123	0.000121	0.000330	0.000027	0.000086	0.000058	0.000013	0.000077	0.000035	0.000057	0.000024	0.000022	0.000018	0.000050	0.000074	0.000095	0.000033	0.000057	0.000036	0.000060	0.000047	0.000048	0.000044	0.000057	0.000018	0.000043	0.000769	0.000162	0.000059	0.000032	0.000049	0.000106	0.000257	0.000098	0.000100	0.000078	0.000046	0.000054	0.000011	0.000030	0.000136	0.000010	0.000055	0.000024	0.000032	0.000075	0.000044	0.000018	0.000065	0.000019	0.000037	0.000021	0.000048	0.000048	0.000046	0.000009	0.000013	0.000029	0.000040	0.000047	0.000042	0.000029	0.000039	0.000022	0.000084	0.000053	0.000023	0.000035	0.000180	0.000029	0.000024	0.001070	0.000619	0.000477	0.000097	0.000086	0.000107	0.000120	0.000036	0.000071	0.000147	0.000032	0.000105	0.000168	0.000023	0.000112	0.000042	0.000040	0.000013	0.000033	0.000030	0.000217	0.000032	0.000052	0.000040	0.000048	0.000050	0.000168	0.000120	0.000064	0.000068	0.000030	0.000027	0.000043	0.000048	0.000044	0.000044	0.000028	0.000022	0.000057	0.000351	0.000151	0.000101	0.000003	0.000104	0.000059	0.000036	0.000032	0.000033	0.000012	0.000013	0.000127	0.000034	0.000038	0.000045	0.000456	0.000066	0.000079	0.000265	0.000244	0.000190	0.000027	0.000009	0.000049	0.000153	0.000026	0.831705	0.120084	0.001885	0.001771	0.000520	0.000310	0.000180	0.000099	0.000437	0.000238	0.000149	0.000076	0.000203	0.000313	0.000244	0.121315	0.089920	0.056726	0.003619	0.007099	0.000802	0.366391	0.052998	0.002381	0.002924	0.000645	0.005945	0.001355	0.000218	0.000115	0.000108	0.000315	0.000087	0.000063	0.000222	0.000176	0.000313	0.000025	0.000035	0.000027	0.000264	0.001057	0.007445	0.014753	0.009533	0.004170	0.000458	0.000830	0.000543	0.000201	0.000353	0.000135	0.000806	0.000120	0.001467	0.000703	0.000215	0.000088	0.000783	0.000497	0.000170	0.000498	0.000757	0.000933	0.000189	0.000116	0.000015	0.000069	0.000422	0.000115	0.000138	0.000114	0.000307	0.000142	0.000144	0.000161	0.019948	0.001996	0.000124	0.001923	0.000889	0.000027	0.000789	0.000538	0.000226	0.000192	0.000640	0.000303	0.000071	0.001797	0.001095	0.000156	0.000446	0.000073	0.000143	0.000460	0.000352	0.000981	0.000802	0.000889	0.002450	0.000220	0.180115	0.014470	0.025281	0.019844	0.006969	0.079859	0.015950	0.056550	0.067853	0.000167	0.000120	0.000078	0.001018	0.000423	0.011731	0.000135	0.000055	0.000176	0.000101	0.000386	0.000248	0.000370	0.000083	0.000072	0.000099	0.000821	0.003693	0.000219	0.021393	0.012397	0.001265	0.022326	0.001283	0.031334	0.000489	0.001716	0.000313	0.001631	0.002056	0.001062	0.004630	0.002927	0.000070	0.000402	0.000085	0.000181	0.000076	0.000028	0.000032	0.000284	0.000081	0.000061	0.000068	0.000118	0.000086	0.000079	0.000061	0.000137	0.000103	0.000028	0.000063	0.001791	0.000136	0.000036	0.000033	0.000068	0.000018	0.000169	0.000438	0.000530	0.000088	0.000035	0.000010	0.000040	0.000049	0.000049	0.000092	0.000240	0.000047	0.000298	0.000017	0.000186	0.000065	0.000281	0.000166	0.000150	0.000126	0.000124	0.000048	0.000271	0.000355	0.000070	0.000111	0.000243	0.000009	0.000066	0.000119	0.000032	0.000036	0.000045	0.000081	0.000081	0.000116	0.000024	0.000238	0.000016	0.000020	0.000061	0.000086	0.000103	0.000066	0.000040	0.000045	0.000109	0.000105	0.000134	0.000081	0.000465	0.000058	0.000030	0.000041	0.000111	0.000013	0.000011	0.000026	0.000093	0.000045	0.000010	0.000069	0.000050	0.000119	0.000160	0.000107	0.000087	0.000045	0.000056	0.000005	0.000034	0.000136	0.000040	0.000128	0.000021	0.000017	0.000084	0.000010	0.000073	0.000032	0.000113	0.000048	0.000225	0.000285	0.000061	0.007656	0.000047	0.000375	0.000230	0.000072	0.000896	0.000242	0.000089	0.000069	0.000097	0.000035	0.000057	0.000117	0.000079	0.000040	0.000167	0.000223	0.000329	0.000035	0.000006	0.000058	0.000106	0.000030	0.000016	0.000063	0.000045	0.000064	0.000299	0.000030	0.000023	0.000032	0.000043	0.000007	0.000147	0.000157	0.000047	0.000076	0.000037	0.000017	0.000009	0.000033	0.000042	0.000021	0.000094	0.000021	0.000014	0.000193	0.000045	0.000013	0.000013	0.000161	0.000181	0.000009	0.000159	0.000027	0.000029	0.000129	0.000302	0.000017	0.000054	0.000045	0.000083	0.000259	0.000041	0.000054	0.000024	0.001093	0.000034	0.000138	0.000027	0.000039	0.000306	0.002951	0.000767	0.000015	0.000029	0.000034	0.000018	0.000035	0.000035	0.000022	0.000023	0.000035	0.000030	0.000055	0.000086	0.000226	0.000004	0.000033	0.000013	0.000387	0.000753	0.000171	0.000030	0.000007	0.000006	0.000384	0.000032	0.000201	0.000085	0.000034	0.000053	0.000024	0.000089	0.000441	0.000723	0.000219	0.000049	0.000021	0.001849	0.000674	0.017528	0.000163	0.005375	0.000216	0.008461	0.001947	0.000271	0.000826	0.000816	0.001286	0.008850	0.000176	0.000093	0.000683	0.000149	0.000968	0.000597	0.001024	0.000267	0.000092	0.000932	0.000178	0.000493	0.000276	0.000019
75160682 - Bicep - Bicep - Rain	75160682	0.031142	0.000451	0.000770	0.004017	0.000141	0.000318	0.001143	0.000055	0.000887	0.000510	0.000830	0.000290	0.000224	0.000493	0.005068	0.000182	0.001136	0.000674	0.001299	0.000483	0.000743	0.000368	0.004724	0.005737	0.002048	0.000523	0.000097	0.004268	0.000373	0.000236	0.000122	0.000129	0.000490	0.000922	0.001504	0.001287	0.000282	0.000104	0.000499	0.000044	0.001002	0.000186	0.000066	0.000108	0.000077	0.000035	0.000110	0.000376	0.000113	0.000400	0.000083	0.000071	0.000043	0.000044	0.000087	0.000071	0.000023	0.000105	0.000282	0.000316	0.000186	0.000183	0.000033	0.000229	0.000092	0.000240	0.000590	0.000060	0.000089	0.001705	0.000112	0.000184	0.011547	0.009883	0.007715	0.001746	0.001480	0.008523	0.001181	0.000429	0.001010	0.001786	0.000086	0.001394	0.000287	0.000484	0.000641	0.000158	0.000110	0.000084	0.000142	0.000134	0.000537	0.000142	0.000154	0.000367	0.000311	0.000297	0.001077	0.000752	0.000380	0.000617	0.000186	0.000180	0.000197	0.000268	0.000331	0.000304	0.000114	0.000066	0.000117	0.001462	0.000460	0.000324	0.000086	0.000200	0.000136	0.000242	0.000240	0.000384	0.000146	0.000026	0.004031	0.000147	0.000082	0.000075	0.000438	0.000075	0.000184	0.000321	0.000204	0.000143	0.000394	0.000177	0.000063	0.000297	0.000021	0.779111	0.049623	0.002220	0.002398	0.000601	0.000472	0.000309	0.000281	0.000241	0.000303	0.000407	0.000129	0.000233	0.000152	0.000232	0.011148	0.007320	0.006928	0.000803	0.000962	0.000331	0.105248	0.101628	0.000312	0.001650	0.001864	0.090838	0.003576	0.000462	0.000334	0.000184	0.001010	0.000083	0.000080	0.000282	0.000266	0.000300	0.000054	0.000049	0.000099	0.000246	0.000260	0.000748	0.001168	0.000915	0.000408	0.000370	0.000714	0.001429	0.000305	0.000820	0.000443	0.000717	0.000094	0.001377	0.000407	0.000208	0.000087	0.002494	0.000783	0.000315	0.000629	0.000352	0.000644	0.000412	0.000167	0.000027	0.000149	0.000248	0.000189	0.000185	0.000260	0.000273	0.000341	0.000117	0.002484	0.006361	0.000573	0.000824	0.014829	0.006617	0.000074	0.001826	0.000353	0.000650	0.000343	0.000796	0.000827	0.000164	0.007658	0.001529	0.001169	0.000787	0.000665	0.000314	0.006802	0.000455	0.001264	0.001750	0.039293	0.001010	0.000323	0.282653	0.189300	0.120012	0.016172	0.009358	0.144124	0.078654	0.002427	0.120066	0.000579	0.000241	0.000062	0.002023	0.001112	0.000981	0.000223	0.000110	0.001196	0.001299	0.000537	0.000603	0.000674	0.000247	0.000243	0.000637	0.000341	0.003570	0.002188	0.003834	0.002415	0.001349	0.010421	0.000325	0.001298	0.000530	0.034678	0.000166	0.003756	0.002048	0.000178	0.000916	0.016584	0.000013	0.000031	0.000118	0.000095	0.000099	0.000021	0.000023	0.000290	0.000064	0.000037	0.000047	0.000130	0.000055	0.000050	0.000039	0.000219	0.000109	0.000046	0.000053	0.002572	0.000198	0.000034	0.000072	0.000103	0.000037	0.000317	0.000592	0.000627	0.000108	0.000221	0.000006	0.000036	0.000050	0.000063	0.000086	0.000514	0.000051	0.001086	0.000026	0.000177	0.000078	0.002018	0.001692	0.000792	0.000961	0.000139	0.000051	0.000297	0.000377	0.000142	0.000132	0.000257	0.000004	0.000027	0.000108	0.000014	0.000041	0.000037	0.000055	0.000066	0.000063	0.000020	0.000246	0.000010	0.000043	0.000025	0.000073	0.000103	0.000067	0.000010	0.000036	0.000071	0.000197	0.000143	0.000171	0.000178	0.000040	0.000054	0.000068	0.000089	0.000254	0.000009	0.000028	0.000076	0.000041	0.000008	0.000069	0.000063	0.000039	0.000090	0.000059	0.000184	0.000050	0.000036	0.000003	0.000042	0.000069	0.000078	0.000145	0.000029	0.000017	0.000104	0.000015	0.000068	0.000011	0.000109	0.000083	0.001540	0.000584	0.000223	0.003683	0.000224	0.002133	0.001384	0.000284	0.012486	0.006801	0.001026	0.001006	0.003044	0.000168	0.001211	0.000239	0.000046	0.000021	0.000135	0.000159	0.000175	0.000016	0.000005	0.000017	0.000049	0.000010	0.000011	0.000052	0.000052	0.000064	0.000233	0.000019	0.000004	0.000025	0.000025	0.000004	0.000100	0.000088	0.000102	0.000148	0.000029	0.000007	0.000018	0.000081	0.000056	0.000053	0.000371	0.000031	0.000011	0.000132	0.000048	0.000005	0.000010	0.000117	0.000134	0.000008	0.000157	0.000090	0.000041	0.000095	0.000209	0.000017	0.000061	0.000040	0.000072	0.000211	0.000025	0.000034	0.000027	0.000218	0.000037	0.000163	0.000028	0.000034	0.000619	0.004592	0.000788	0.000020	0.000055	0.000209	0.000029	0.000014	0.000022	0.000058	0.000028	0.000039	0.000053	0.000091	0.000060	0.000780	0.000004	0.000016	0.000014	0.001583	0.000309	0.000299	0.000123	0.000015	0.000006	0.000377	0.000036	0.000257	0.000086	0.000101	0.000057	0.000028	0.000275	0.000298	0.000531	0.000502	0.000373	0.000034	0.002733	0.007817	0.003836	0.001102	0.006006	0.000586	0.009138	0.002806	0.000488	0.001318	0.001423	0.001047	0.006712	0.000194	0.000127	0.001605	0.000084	0.001996	0.001632	0.000575	0.000196	0.000045	0.001127	0.000135	0.000364	0.000509	0.000034
75160683 - Bicep - Bicep - Ayr	75160683	0.024440	0.000265	0.000323	0.000511	0.000136	0.000228	0.000107	0.000079	0.000156	0.000052	0.000097	0.000025	0.000150	0.000043	0.000208	0.000214	0.000402	0.000086	0.000126	0.000122	0.000086	0.000080	0.000203	0.000215	0.000243	0.000067	0.000045	0.002238	0.000348	0.000094	0.000114	0.000224	0.000254	0.000466	0.000207	0.000203	0.001246	0.000094	0.000171	0.000018	0.000530	0.000117	0.000016	0.000028	0.000061	0.000027	0.000058	0.000084	0.000073	0.000086	0.000064	0.000177	0.000068	0.000650	0.000229	0.000229	0.000023	0.000079	0.000055	0.000179	0.000249	0.000533	0.000099	0.000607	0.001706	0.001214	0.000147	0.000133	0.000075	0.000482	0.000075	0.000029	0.005251	0.003593	0.002788	0.000923	0.000867	0.000909	0.001333	0.000236	0.000481	0.000411	0.000125	0.000233	0.000111	0.000096	0.000376	0.000310	0.000318	0.000039	0.000107	0.000105	0.000347	0.000121	0.000172	0.000105	0.000210	0.000195	0.000947	0.000331	0.000151	0.000142	0.000440	0.000427	0.000284	0.000439	0.000202	0.000210	0.000087	0.000059	0.000124	0.001079	0.000428	0.000379	0.000060	0.000165	0.000103	0.000202	0.000176	0.000150	0.000076	0.000048	0.000724	0.000200	0.000245	0.000141	0.000633	0.000272	0.000207	0.000258	0.000714	0.000112	0.000527	0.000198	0.000084	0.001326	0.000058	0.729469	0.064404	0.004822	0.005651	0.001039	0.001198	0.000953	0.000428	0.000288	0.000864	0.000127	0.000144	0.000224	0.000462	0.000215	0.018009	0.014546	0.010833	0.003388	0.003448	0.001299	0.069959	0.053034	0.000851	0.032211	0.014126	0.071716	0.046786	0.005476	0.003099	0.003149	0.014652	0.166533	0.000786	0.000922	0.000871	0.014115	0.001252	0.000408	0.000280	0.002229	0.000878	0.001616	0.003047	0.001707	0.001734	0.000625	0.003931	0.001153	0.000326	0.000392	0.000305	0.000926	0.000105	0.001235	0.000927	0.000301	0.000199	0.002172	0.002154	0.000272	0.000466	0.001362	0.000926	0.000491	0.000478	0.000061	0.000185	0.000154	0.000055	0.000109	0.000236	0.000166	0.000640	0.000232	0.001388	0.004462	0.001091	0.000925	0.002878	0.011819	0.000393	0.001362	0.000594	0.000339	0.000256	0.000825	0.000426	0.000213	0.005412	0.003258	0.001083	0.000804	0.000172	0.000188	0.002256	0.001127	0.001158	0.002029	0.000977	0.003872	0.000201	0.074317	0.005412	0.013560	0.010813	0.017419	0.027148	0.002884	0.037524	0.003918	0.000691	0.000242	0.001155	0.001792	0.000495	0.006711	0.000259	0.000085	0.001219	0.000735	0.000611	0.000687	0.000580	0.000208	0.000327	0.000098	0.001327	0.002067	0.000545	0.011900	0.007559	0.000846	0.013167	0.000574	0.004797	0.000682	0.001578	0.000461	0.001125	0.000717	0.001453	0.004801	0.002864	0.000339	0.001099	0.000216	0.000229	0.000191	0.000166	0.000241	0.000284	0.000180	0.000200	0.000153	0.000151	0.000039	0.000105	0.000082	0.000078	0.000362	0.000122	0.000408	0.003505	0.000448	0.000097	0.000239	0.000150	0.000090	0.000221	0.000807	0.001320	0.000168	0.000526	0.000018	0.000035	0.000049	0.000102	0.000125	0.000186	0.000027	0.000645	0.000018	0.000062	0.000093	0.000320	0.000209	0.000137	0.000137	0.000285	0.000043	0.000232	0.000337	0.000113	0.000212	0.000214	0.000005	0.000041	0.000129	0.000024	0.000037	0.000061	0.000071	0.000094	0.000736	0.001520	0.000258	0.000020	0.000004	0.000037	0.000047	0.000106	0.000071	0.000020	0.000078	0.000101	0.000183	0.001090	0.000352	0.000237	0.000318	0.000408	0.001028	0.001355	0.000120	0.000047	0.000110	0.000237	0.000082	0.000334	0.000050	0.000137	0.000033	0.000117	0.000080	0.000106	0.000010	0.000058	0.000013	0.000033	0.000018	0.000150	0.000562	0.000143	0.000251	0.000139	0.000091	0.000180	0.000370	0.000183	0.000093	0.002656	0.001069	0.000275	0.002461	0.000445	0.001691	0.002372	0.000527	0.002140	0.000746	0.002227	0.002278	0.003698	0.000361	0.001113	0.000104	0.000136	0.000064	0.000697	0.002659	0.002286	0.000078	0.000025	0.000034	0.000072	0.000020	0.000047	0.000086	0.000097	0.000315	0.000295	0.000814	0.000023	0.000019	0.000014	0.000008	0.000076	0.000035	0.000499	0.000702	0.000298	0.000045	0.000196	0.000334	0.000163	0.000155	0.000453	0.000135	0.000057	0.000181	0.000789	0.000013	0.000063	0.000523	0.000381	0.000040	0.000430	0.000077	0.000057	0.000465	0.000920	0.000045	0.000329	0.000104	0.000153	0.000554	0.000049	0.000028	0.000034	0.000634	0.000818	0.000322	0.002466	0.001500	0.000704	0.003527	0.001010	0.000469	0.000143	0.000385	0.000319	0.000061	0.000082	0.000307	0.000248	0.000089	0.000476	0.000131	0.000050	0.000487	0.000017	0.000059	0.000022	0.001607	0.001739	0.000567	0.000151	0.000040	0.000016	0.000543	0.000024	0.000728	0.000050	0.000091	0.000064	0.000348	0.000422	0.000453	0.012979	0.000251	0.000433	0.000100	0.002606	0.006253	0.004671	0.001154	0.008547	0.001147	0.008508	0.005605	0.000717	0.001610	0.001959	0.003463	0.006894	0.000256	0.000113	0.001934	0.000602	0.000944	0.000543	0.000274	0.000358	0.000037	0.018346	0.000168	0.000410	0.000372	0.000095
75160684 - Bicep - Bicep - Vale	75160684	0.023228	0.000217	0.000304	0.000817	0.000059	0.000119	0.000145	0.000040	0.000201	0.000120	0.000154	0.000072	0.000102	0.000031	0.000322	0.000249	0.000297	0.000187	0.000122	0.000058	0.000097	0.000043	0.000262	0.000209	0.000176	0.000044	0.000121	0.014113	0.000222	0.000143	0.000107	0.000147	0.000401	0.000740	0.000256	0.000600	0.001185	0.000455	0.000152	0.000015	0.000354	0.000342	0.000054	0.000119	0.000066	0.000027	0.000178	0.000363	0.000137	0.000248	0.000081	0.000017	0.000026	0.000089	0.000173	0.000133	0.000013	0.000051	0.000252	0.000289	0.000270	0.000147	0.000038	0.000148	0.000383	0.000762	0.000097	0.000020	0.000016	0.000434	0.000038	0.000008	0.002681	0.002005	0.001755	0.000782	0.000329	0.000464	0.000461	0.000171	0.000188	0.000208	0.000104	0.000090	0.000297	0.000041	0.000191	0.000061	0.000058	0.000020	0.000047	0.000044	0.000242	0.000068	0.000067	0.000098	0.000131	0.000122	0.000414	0.000252	0.000117	0.000150	0.000099	0.000102	0.000095	0.000135	0.000093	0.000085	0.000030	0.000022	0.000067	0.000628	0.000230	0.000218	0.000008	0.000068	0.000051	0.000099	0.000083	0.000197	0.000054	0.000021	0.000503	0.000098	0.000104	0.000041	0.000466	0.000260	0.000064	0.000161	0.000501	0.000083	0.000163	0.000061	0.000076	0.000903	0.000014	0.759713	0.038005	0.000928	0.001290	0.000181	0.000277	0.000196	0.000084	0.000048	0.000135	0.000081	0.000041	0.000077	0.000080	0.000146	0.009983	0.006510	0.005359	0.000697	0.000754	0.000262	0.104081	0.070533	0.000272	0.003393	0.008590	0.177326	0.012540	0.002714	0.001894	0.000738	0.005553	0.000162	0.000034	0.001897	0.001978	0.000265	0.000530	0.000210	0.000300	0.000235	0.000129	0.000516	0.000779	0.000670	0.000245	0.000027	0.000320	0.000360	0.000108	0.000163	0.000111	0.000185	0.000034	0.000231	0.000100	0.000075	0.000050	0.000774	0.000835	0.000102	0.000117	0.000073	0.000442	0.000096	0.000571	0.000093	0.000459	0.000354	0.000171	0.000014	0.000170	0.000144	0.000061	0.000134	0.000306	0.003525	0.002717	0.001425	0.021809	0.028143	0.000158	0.002411	0.000502	0.000937	0.000465	0.000757	0.000932	0.000173	0.010224	0.002540	0.003403	0.000292	0.000511	0.000078	0.005557	0.000292	0.000831	0.001201	0.016386	0.000407	0.000137	0.227609	0.079356	0.034630	0.022877	0.085355	0.071359	0.048738	0.019667	0.032691	0.000483	0.000088	0.000041	0.001680	0.000479	0.002460	0.000404	0.000085	0.001511	0.002764	0.000729	0.000455	0.001282	0.000048	0.000126	0.000392	0.000130	0.003468	0.005026	0.002432	0.002155	0.001225	0.006989	0.000526	0.000582	0.000570	0.014944	0.000064	0.001085	0.000465	0.000318	0.001413	0.005312	0.000062	0.000133	0.000062	0.000087	0.000056	0.000013	0.000019	0.000252	0.000024	0.000023	0.000021	0.000057	0.000024	0.000025	0.000021	0.000275	0.000079	0.000022	0.000088	0.001229	0.000113	0.000024	0.000053	0.000046	0.000015	0.000094	0.000287	0.000491	0.000081	0.000129	0.000006	0.000023	0.000031	0.000032	0.000057	0.000088	0.000016	0.000401	0.000008	0.000031	0.000026	0.000183	0.000138	0.000109	0.000080	0.000115	0.000021	0.000132	0.000187	0.000111	0.000064	0.000111	0.000005	0.000019	0.000112	0.000016	0.000041	0.000034	0.000075	0.000062	0.000155	0.000064	0.000154	0.000010	0.000027	0.000031	0.000041	0.000045	0.000036	0.000009	0.000047	0.000041	0.000089	0.000145	0.000230	0.000391	0.000041	0.000063	0.000183	0.000122	0.000195	0.000012	0.000032	0.000154	0.000086	0.000033	0.000055	0.000064	0.000032	0.000113	0.000092	0.000082	0.000032	0.000040	0.000007	0.000043	0.000027	0.000082	0.000362	0.000127	0.000142	0.000184	0.000042	0.000143	0.000072	0.000197	0.000145	0.003246	0.001711	0.000976	0.002042	0.000515	0.007999	0.011517	0.001175	0.001245	0.000353	0.002269	0.001591	0.004436	0.000128	0.001706	0.000240	0.000171	0.000087	0.000326	0.000264	0.000243	0.000063	0.000028	0.000035	0.000057	0.000005	0.000064	0.000043	0.000105	0.000141	0.000499	0.000046	0.000020	0.000048	0.000063	0.000012	0.000184	0.000177	0.000082	0.000334	0.000085	0.000027	0.000011	0.000398	0.000048	0.000041	0.000284	0.000022	0.000017	0.000215	0.000170	0.000010	0.000038	0.000255	0.000128	0.000037	0.000160	0.000018	0.000025	0.000122	0.000398	0.000019	0.000055	0.000040	0.000058	0.000513	0.000036	0.000032	0.000019	0.002985	0.000054	0.000203	0.000060	0.000097	0.000676	0.001522	0.000798	0.000053	0.000069	0.000129	0.000051	0.000025	0.000057	0.000419	0.000022	0.000045	0.000255	0.000158	0.000142	0.001078	0.000025	0.000077	0.000039	0.004158	0.000410	0.000397	0.000158	0.000026	0.000011	0.000474	0.000023	0.000326	0.000080	0.000225	0.000020	0.000044	0.000186	0.000331	0.004677	0.001675	0.000215	0.000092	0.005406	0.043210	0.002528	0.006180	0.007455	0.003161	0.009867	0.002439	0.000349	0.000638	0.000904	0.001990	0.003669	0.000332	0.000113	0.006560	0.000551	0.000501	0.007043	0.000495	0.000638	0.000057	0.006501	0.000172	0.000277	0.000347	0.000029
75160685 - Bicep - Bicep - Aura.part	75160685	0.019757	0.000297	0.000271	0.000447	0.000074	0.000256	0.000122	0.000046	0.000122	0.000060	0.000117	0.000039	0.000028	0.000040	0.000140	0.000428	0.000367	0.000084	0.000173	0.000107	0.000128	0.000106	0.000290	0.000163	0.000190	0.000093	0.000107	0.001811	0.000272	0.000114	0.000069	0.000081	0.000135	0.000184	0.000061	0.000096	0.000879	0.000065	0.000078	0.000013	0.000408	0.000279	0.000045	0.000144	0.000057	0.000068	0.000211	0.000146	0.000035	0.000205	0.000027	0.000074	0.000051	0.000225	0.000313	0.000167	0.000024	0.000166	0.000046	0.000136	0.000201	0.000076	0.000072	0.000137	0.000871	0.001279	0.000108	0.000043	0.000045	0.000367	0.000051	0.000023	0.004494	0.002765	0.001488	0.000279	0.000202	0.000609	0.000253	0.000125	0.000193	0.000744	0.000339	0.000374	0.000159	0.000111	0.000423	0.000228	0.000183	0.000080	0.000076	0.000068	0.000244	0.000153	0.000129	0.000182	0.000122	0.000124	0.001037	0.000409	0.000218	0.000255	0.000320	0.000300	0.000154	0.000146	0.000362	0.000324	0.000122	0.000074	0.000085	0.001866	0.000817	0.000684	0.000097	0.000205	0.000132	0.000102	0.000090	0.000367	0.000159	0.000081	0.000378	0.000302	0.000225	0.000203	0.002481	0.000834	0.000999	0.001294	0.001294	0.000549	0.000615	0.000207	0.000091	0.000322	0.000038	0.792989	0.061880	0.001971	0.002344	0.000567	0.000460	0.000371	0.000152	0.000166	0.000411	0.000204	0.000116	0.000208	0.000246	0.000143	0.022273	0.014828	0.010263	0.001481	0.001894	0.000482	0.117050	0.107634	0.001084	0.001858	0.003515	0.092714	0.006175	0.000859	0.000662	0.000300	0.002366	0.000270	0.000059	0.000435	0.000447	0.000140	0.000194	0.000044	0.000075	0.000115	0.000420	0.001408	0.002038	0.001693	0.000482	0.000267	0.001589	0.001418	0.000429	0.000931	0.000344	0.000930	0.000119	0.002815	0.000630	0.000363	0.000152	0.002114	0.002292	0.000272	0.000435	0.000462	0.000781	0.000241	0.000539	0.000102	0.000437	0.001264	0.000926	0.000089	0.000253	0.000120	0.000529	0.000140	0.000715	0.008098	0.001276	0.000554	0.008188	0.012861	0.000125	0.001028	0.000417	0.000548	0.000254	0.000997	0.000867	0.000148	0.008880	0.002144	0.000774	0.000553	0.000288	0.000212	0.003654	0.000298	0.000689	0.002159	0.012474	0.002391	0.000634	0.290227	0.055588	0.171090	0.048492	0.052936	0.183672	0.044557	0.010927	0.154355	0.000215	0.000068	0.000048	0.002868	0.000441	0.003513	0.000271	0.000091	0.000776	0.001138	0.000586	0.000611	0.000347	0.000117	0.000101	0.000245	0.000338	0.002713	0.001115	0.009069	0.004752	0.001066	0.019193	0.000539	0.008250	0.000768	0.012296	0.000244	0.002254	0.001614	0.000635	0.002382	0.011323	0.000020	0.000219	0.000202	0.000192	0.000162	0.000033	0.000040	0.000270	0.000091	0.000077	0.000066	0.000109	0.000025	0.000073	0.000054	0.000096	0.000117	0.000045	0.000121	0.002203	0.000250	0.000049	0.000106	0.000140	0.000030	0.000240	0.000591	0.000479	0.000104	0.000209	0.000010	0.000030	0.000038	0.000056	0.000094	0.000286	0.000043	0.000653	0.000046	0.000167	0.000059	0.000585	0.000389	0.000387	0.000275	0.000139	0.000047	0.000242	0.000318	0.000064	0.000110	0.000217	0.000014	0.000045	0.000198	0.000027	0.000071	0.000057	0.000107	0.000128	0.000232	0.000061	0.000208	0.000006	0.000051	0.000044	0.000024	0.000079	0.000048	0.000019	0.000043	0.000069	0.000144	0.000378	0.000264	0.000366	0.000114	0.000067	0.000156	0.000156	0.001152	0.000024	0.000064	0.000144	0.000078	0.000045	0.000052	0.000065	0.000019	0.000146	0.000124	0.000058	0.000025	0.000053	0.000055	0.000139	0.000029	0.000160	0.000411	0.000079	0.000126	0.000359	0.000069	0.000116	0.000045	0.000138	0.000366	0.004400	0.000697	0.000282	0.004528	0.000173	0.000712	0.000467	0.001221	0.002912	0.001135	0.001501	0.004636	0.005618	0.000180	0.001506	0.000055	0.000131	0.000070	0.000685	0.000348	0.000456	0.000056	0.000023	0.000038	0.000126	0.000014	0.000051	0.000102	0.000159	0.000174	0.000291	0.000055	0.000008	0.000037	0.000078	0.000016	0.000103	0.000110	0.000070	0.000228	0.000034	0.000016	0.000018	0.000194	0.000084	0.000050	0.000201	0.000033	0.000013	0.000220	0.000135	0.000013	0.000027	0.000277	0.000217	0.000019	0.000289	0.000019	0.000034	0.000214	0.000701	0.000097	0.000112	0.000031	0.000082	0.000319	0.000031	0.000026	0.000031	0.001076	0.000181	0.000159	0.000048	0.000174	0.000254	0.001215	0.000746	0.000057	0.000051	0.000104	0.000040	0.000038	0.000042	0.000090	0.000040	0.000082	0.000098	0.000147	0.000163	0.000858	0.000019	0.000082	0.000074	0.001972	0.000348	0.000360	0.000098	0.000062	0.000012	0.000479	0.000028	0.000228	0.000077	0.000113	0.000044	0.000104	0.000213	0.000737	0.006862	0.001388	0.000194	0.000115	0.002774	0.007964	0.004981	0.002656	0.005620	0.003276	0.009543	0.002734	0.000305	0.001103	0.002169	0.000683	0.003820	0.000180	0.000509	0.004563	0.000886	0.000445	0.000388	0.000761	0.000254	0.000044	0.010421	0.000181	0.000285	0.000155	0.000046
268085663 - Bicep - Flex - Sniperking	268085663	0.021688	0.000556	0.000407	0.000540	0.000120	0.000428	0.000092	0.000124	0.000169	0.000100	0.000123	0.000062	0.000046	0.000059	0.000364	0.000114	0.000645	0.000127	0.000107	0.000422	0.000114	0.000322	0.000351	0.000359	0.000802	0.000184	0.000162	0.001668	0.000194	0.000020	0.000152	0.000435	0.000398	0.000214	0.000066	0.000098	0.001109	0.000047	0.000477	0.000224	0.000031	0.000205	0.000166	0.000256	0.000212	0.000083	0.000128	0.000569	0.000315	0.000438	0.000068	0.000150	0.000234	0.000239	0.000170	0.000058	0.000029	0.000010	0.001142	0.000262	0.000559	0.000106	0.000060	0.000397	0.000381	0.003317	0.000175	0.000141	0.000096	0.000471	0.000108	0.000080	0.003023	0.001648	0.001276	0.000292	0.000293	0.000157	0.000312	0.000213	0.000296	0.000409	0.000037	0.000274	0.000412	0.000128	0.000659	0.000320	0.000236	0.000112	0.000234	0.000223	0.000525	0.000500	0.000389	0.000367	0.000588	0.000544	0.000860	0.000848	0.000570	0.000512	0.000183	0.000134	0.000415	0.000747	0.000283	0.000300	0.000151	0.000117	0.000240	0.001310	0.000405	0.000289	0.000067	0.000182	0.000111	0.000363	0.000337	0.000231	0.000050	0.000047	0.000304	0.000207	0.000176	0.000090	0.001273	0.000301	0.000141	0.000793	0.000563	0.000575	0.000776	0.000254	0.000163	0.001203	0.000008	0.847522	0.279233	0.024048	0.029994	0.004272	0.005195	0.017825	0.000804	0.001315	0.011360	0.000574	0.000172	0.000310	0.000615	0.000180	0.023496	0.012762	0.008958	0.000168	0.000169	0.000079	0.100536	0.084216	0.001503	0.009622	0.022137	0.460439	0.052033	0.006101	0.005956	0.001312	0.023249	0.000088	0.000366	0.001735	0.001701	0.003973	0.000362	0.000091	0.000112	0.000056	0.000700	0.000735	0.001114	0.001159	0.000058	0.000069	0.000247	0.000450	0.000075	0.000407	0.000148	0.000959	0.000065	0.000836	0.000911	0.000258	0.000185	0.000512	0.000063	0.000159	0.000085	0.000159	0.000170	0.000088	0.000126	0.000042	0.000004	0.000161	0.000103	0.000043	0.000351	0.000154	0.000141	0.000246	0.000015	0.000114	0.000044	0.002395	0.005082	0.017175	0.002997	0.002131	0.001611	0.001087	0.000523	0.000708	0.001271	0.000212	0.006198	0.001100	0.000776	0.001363	0.000090	0.000677	0.002677	0.000579	0.001277	0.001605	0.002540	0.001348	0.000067	0.083935	0.010039	0.020083	0.030730	0.002512	0.008074	0.004613	0.000821	0.001763	0.000520	0.000187	0.000352	0.002939	0.000313	0.000724	0.000689	0.000081	0.000589	0.001048	0.000573	0.000471	0.000447	0.000327	0.000089	0.000173	0.000512	0.002823	0.000419	0.003079	0.004134	0.000446	0.007738	0.001842	0.002281	0.000521	0.002478	0.000173	0.000825	0.001132	0.001221	0.003065	0.002344	0.000112	0.000214	0.000360	0.000200	0.000321	0.000292	0.000321	0.001115	0.000688	0.000449	0.000447	0.000272	0.000149	0.000197	0.000175	0.000330	0.000249	0.000138	0.000257	0.003081	0.000440	0.000156	0.000134	0.000208	0.000041	0.000375	0.000901	0.000146	0.000062	0.000130	0.000060	0.000128	0.000150	0.000158	0.000264	0.000275	0.000124	0.000059	0.000067	0.000044	0.000163	0.000526	0.000277	0.000212	0.000169	0.000372	0.000078	0.000717	0.000860	0.000089	0.000113	0.000651	0.000040	0.000087	0.000291	0.000089	0.000072	0.000072	0.000118	0.000194	0.000309	0.000210	0.000992	0.000051	0.000120	0.000327	0.000638	0.000370	0.000204	0.000176	0.000303	0.000349	0.000367	0.000325	0.000138	0.000530	0.000169	0.000149	0.000482	0.000746	0.000279	0.000011	0.000037	0.000986	0.000602	0.000076	0.000448	0.000060	0.000219	0.000473	0.000257	0.000267	0.000199	0.000270	0.000043	0.000218	0.000247	0.000053	0.000312	0.000151	0.000176	0.000671	0.000024	0.000406	0.000186	0.000662	0.000107	0.000428	0.000151	0.000049	0.002691	0.000056	0.000087	0.000089	0.000511	0.000731	0.000054	0.000407	0.000061	0.000172	0.000039	0.000030	0.000096	0.000888	0.000769	0.000766	0.001863	0.001268	0.000569	0.000113	0.000269	0.000052	0.000042	0.000095	0.000253	0.000052	0.000118	0.001026	0.000343	0.000223	0.000438	0.000549	0.000165	0.000602	0.000297	0.000284	0.000523	0.000282	0.000169	0.000116	0.000311	0.000272	0.000306	0.000574	0.000105	0.000140	0.001603	0.003719	0.000216	0.000631	0.000301	0.000832	0.000244	0.000565	0.000130	0.000235	0.000134	0.000482	0.000094	0.000356	0.000446	0.000349	0.000536	0.000283	0.000819	0.000074	0.000081	0.000058	0.000360	0.000301	0.000182	0.027781	0.005273	0.001430	0.000427	0.000247	0.000620	0.000472	0.000165	0.000253	0.000211	0.000115	0.000081	0.000248	0.000773	0.001195	0.001201	0.000130	0.000130	0.000056	0.000342	0.000654	0.000311	0.000286	0.000045	0.000055	0.000543	0.000081	0.000770	0.000366	0.000088	0.000233	0.000032	0.000372	0.000331	0.000761	0.000618	0.000088	0.000076	0.001706	0.000037	0.022600	0.000040	0.012055	0.002651	0.012638	0.001065	0.000331	0.001731	0.002410	0.002256	0.002004	0.000259	0.000077	0.001233	0.000336	0.001857	0.000069	0.001308	0.000259	0.000188	0.000706	0.000370	0.000174	0.000086	0.000123
268085664 - Bicep - Flex - Sniping wildcat	268085664	0.028696	0.000844	0.000450	0.001278	0.000159	0.000724	0.000229	0.000207	0.000249	0.000157	0.000222	0.000052	0.000387	0.000118	0.000446	0.000256	0.000715	0.000267	0.000169	0.000348	0.000261	0.000417	0.000216	0.000282	0.000326	0.000194	0.000201	0.003128	0.000710	0.000068	0.000106	0.000176	0.000513	0.000718	0.000415	0.000197	0.003870	0.000039	0.000327	0.000122	0.000139	0.000470	0.000213	0.000303	0.000193	0.000112	0.000195	0.000281	0.000233	0.000416	0.000047	0.000120	0.000260	0.000276	0.000560	0.000165	0.000018	0.000014	0.000236	0.000195	0.000281	0.000589	0.000156	0.002346	0.000514	0.005255	0.000312	0.000372	0.000134	0.001228	0.000186	0.000227	0.002119	0.001433	0.001320	0.000407	0.000274	0.000169	0.000322	0.000146	0.000295	0.000321	0.000075	0.000170	0.001110	0.000109	0.000301	0.000208	0.000157	0.000081	0.000081	0.000070	0.000175	0.000292	0.000258	0.000216	0.000217	0.000228	0.000583	0.000395	0.000233	0.000172	0.000168	0.000137	0.000158	0.000186	0.000186	0.000183	0.000117	0.000077	0.000139	0.000987	0.000460	0.000372	0.000030	0.000236	0.000146	0.000136	0.000148	0.000229	0.000077	0.000077	0.000332	0.000205	0.000173	0.000123	0.000815	0.000316	0.000124	0.000373	0.000500	0.000214	0.000328	0.000127	0.000260	0.002479	0.000009	0.860419	0.226574	0.005661	0.006312	0.001492	0.000656	0.001509	0.000258	0.000259	0.001861	0.000728	0.000515	0.000413	0.000312	0.000368	0.006463	0.004789	0.001435	0.000349	0.000250	0.000177	0.039939	0.057902	0.000433	0.028609	0.112868	0.365403	0.190845	0.017743	0.021795	0.002178	0.089284	0.000117	0.000388	0.005493	0.005346	0.002580	0.000811	0.000170	0.000133	0.000030	0.000298	0.000739	0.001312	0.000892	0.000203	0.000418	0.002869	0.001387	0.000405	0.000981	0.000380	0.002477	0.000299	0.007485	0.001060	0.000803	0.000350	0.001431	0.000455	0.000662	0.000448	0.000253	0.000324	0.000197	0.000350	0.000063	0.000022	0.000226	0.000137	0.000158	0.001349	0.001506	0.000444	0.000115	0.000070	0.000105	0.000049	0.002526	0.010931	0.068848	0.000740	0.002786	0.002708	0.001849	0.000727	0.001876	0.002269	0.000202	0.019815	0.003481	0.001469	0.001359	0.000416	0.000831	0.004758	0.000835	0.002334	0.005202	0.006049	0.002459	0.000301	0.101423	0.017437	0.022042	0.056341	0.003716	0.037531	0.010863	0.002391	0.002634	0.000477	0.000290	0.000134	0.005618	0.000175	0.001314	0.000307	0.000100	0.001016	0.002006	0.000637	0.001175	0.000379	0.000292	0.000080	0.000426	0.001103	0.002645	0.001856	0.003012	0.002371	0.000484	0.006008	0.001042	0.000462	0.000528	0.006202	0.000403	0.001289	0.000490	0.000843	0.003847	0.008257	0.000078	0.000085	0.000176	0.000128	0.000159	0.000104	0.000115	0.001261	0.000284	0.000287	0.000180	0.000187	0.000063	0.000118	0.000095	0.000849	0.000186	0.000122	0.000255	0.002008	0.000280	0.000071	0.000078	0.000147	0.000043	0.000307	0.000681	0.000383	0.000187	0.000140	0.000043	0.000079	0.000125	0.000127	0.000225	0.000178	0.000079	0.000192	0.000043	0.000030	0.000106	0.000372	0.000175	0.000167	0.000156	0.000243	0.000081	0.000810	0.000913	0.000213	0.000330	0.000673	0.000052	0.000077	0.000289	0.000089	0.000161	0.000068	0.000163	0.000200	0.000364	0.000090	0.000656	0.000029	0.000226	0.000122	0.000354	0.000223	0.000149	0.000072	0.000207	0.000168	0.000264	0.000517	0.000057	0.000134	0.000162	0.000327	0.001069	0.001307	0.000040	0.000021	0.000050	0.000735	0.000467	0.000122	0.000450	0.000056	0.000280	0.001011	0.000689	0.000404	0.000119	0.000823	0.000024	0.000293	0.000427	0.000131	0.000789	0.000379	0.000297	0.000872	0.000049	0.000302	0.000226	0.000540	0.000182	0.000319	0.000406	0.000163	0.003001	0.000159	0.000366	0.000205	0.000298	0.000764	0.000132	0.000608	0.000376	0.000342	0.000021	0.000290	0.000439	0.000638	0.000585	0.000598	0.001321	0.001020	0.000391	0.000046	0.000181	0.000028	0.000018	0.000169	0.000217	0.000202	0.000167	0.002271	0.000910	0.000129	0.000841	0.000886	0.000260	0.000997	0.001061	0.000201	0.000493	0.000243	0.000069	0.000074	0.000440	0.000252	0.000180	0.000822	0.000049	0.000098	0.002686	0.014100	0.000095	0.000191	0.000442	0.000485	0.000147	0.000779	0.000124	0.000169	0.000491	0.002428	0.000164	0.000692	0.000222	0.000510	0.001083	0.000283	0.000379	0.000031	0.000082	0.000065	0.000660	0.000558	0.000127	0.000291	0.002615	0.001762	0.000647	0.000429	0.001389	0.000649	0.000213	0.000196	0.000619	0.000101	0.000091	0.000234	0.000607	0.001497	0.002225	0.000034	0.000280	0.000079	0.000482	0.001595	0.000299	0.000112	0.000052	0.000022	0.000997	0.000160	0.001364	0.000313	0.000256	0.000200	0.000056	0.000793	0.000498	0.001720	0.000419	0.000061	0.000184	0.001362	0.000081	0.005058	0.000039	0.022339	0.009430	0.007238	0.002180	0.000667	0.000923	0.001126	0.003503	0.005475	0.000083	0.000150	0.004246	0.000328	0.000897	0.000049	0.000227	0.000275	0.000076	0.001589	0.000211	0.000389	0.000284	0.000166
268085667 - Bicep - Flex - Sohopark	268085667	0.021974	0.000400	0.000153	0.000493	0.000061	0.000268	0.000165	0.000079	0.000261	0.000281	0.000422	0.000085	0.000222	0.000271	0.000887	0.000275	0.000291	0.000142	0.000170	0.000124	0.000170	0.000120	0.000299	0.000459	0.000242	0.000115	0.000049	0.001728	0.000599	0.000037	0.000152	0.000227	0.000698	0.000624	0.000323	0.000273	0.001760	0.000057	0.000136	0.000026	0.000212	0.000282	0.000128	0.000195	0.000044	0.000037	0.000169	0.000236	0.000145	0.000255	0.000076	0.000121	0.000305	0.000189	0.000301	0.000128	0.000006	0.000085	0.000111	0.000232	0.000094	0.000233	0.000227	0.000649	0.004611	0.012771	0.000857	0.000305	0.000060	0.001669	0.000202	0.000042	0.002900	0.001747	0.001155	0.000173	0.000217	0.000556	0.000214	0.000057	0.000202	0.000506	0.000116	0.000221	0.001729	0.000116	0.000208	0.000211	0.000200	0.000047	0.000054	0.000052	0.000440	0.000129	0.000156	0.000097	0.000227	0.000210	0.000572	0.000356	0.000212	0.000171	0.000245	0.000176	0.000143	0.000165	0.000082	0.000086	0.000058	0.000028	0.000036	0.000960	0.000461	0.000395	0.000020	0.000171	0.000131	0.000073	0.000085	0.000176	0.000049	0.000035	0.000330	0.000269	0.000341	0.000128	0.000865	0.000433	0.000170	0.000329	0.000760	0.000142	0.000846	0.000226	0.000236	0.000807	0.000018	0.824095	0.170256	0.012318	0.011089	0.003247	0.002204	0.002180	0.000238	0.000537	0.002748	0.000992	0.001056	0.000778	0.000616	0.000592	0.010729	0.008617	0.003557	0.000349	0.000231	0.000193	0.053699	0.067328	0.001312	0.008867	0.026356	0.272887	0.052229	0.003085	0.003874	0.000502	0.022542	0.000147	0.000849	0.001086	0.001054	0.002204	0.000615	0.000134	0.000095	0.000067	0.000463	0.001071	0.002009	0.001286	0.000279	0.000320	0.001552	0.001124	0.000333	0.000837	0.000233	0.002861	0.000166	0.006699	0.002634	0.000711	0.000413	0.002925	0.001464	0.000552	0.000501	0.000479	0.000517	0.000478	0.000369	0.000084	0.000096	0.000340	0.000295	0.000364	0.000560	0.000271	0.001519	0.000085	0.001128	0.000658	0.000220	0.001373	0.008896	0.026311	0.000384	0.002290	0.002545	0.002042	0.000797	0.002601	0.002822	0.000282	0.022616	0.005366	0.001363	0.002095	0.000411	0.001235	0.008239	0.001609	0.004857	0.006382	0.008154	0.002623	0.000203	0.080131	0.025075	0.052990	0.020123	0.002457	0.051560	0.012333	0.002409	0.004517	0.000448	0.000251	0.000203	0.006399	0.000221	0.001688	0.000248	0.000117	0.001499	0.001807	0.000602	0.001332	0.000409	0.000596	0.000173	0.000414	0.001835	0.004591	0.000972	0.006098	0.003678	0.000944	0.012233	0.001205	0.001898	0.000461	0.008341	0.000386	0.003514	0.001253	0.000805	0.004475	0.012627	0.000129	0.000170	0.000147	0.000115	0.000141	0.000058	0.000071	0.000779	0.000195	0.000228	0.000155	0.000224	0.000081	0.000066	0.000056	0.001930	0.000272	0.000080	0.000153	0.003886	0.000439	0.000063	0.000144	0.000318	0.000083	0.000418	0.000858	0.001479	0.000250	0.000654	0.000027	0.000073	0.000074	0.000172	0.000164	0.000320	0.000079	0.001180	0.000052	0.000188	0.000140	0.001492	0.000892	0.000628	0.000708	0.000219	0.000059	0.001032	0.001305	0.000506	0.000669	0.000897	0.000027	0.000062	0.000235	0.000047	0.000248	0.000070	0.000320	0.000151	0.000276	0.000059	0.000680	0.000018	0.000909	0.000078	0.000244	0.000305	0.000170	0.000037	0.000159	0.000203	0.000322	0.000451	0.000139	0.000123	0.000142	0.000244	0.000682	0.000730	0.000091	0.000014	0.000020	0.000128	0.000072	0.000026	0.000334	0.000085	0.000133	0.000671	0.000486	0.000222	0.000161	0.000322	0.000016	0.000706	0.000469	0.000041	0.000534	0.000028	0.000130	0.001207	0.000017	0.000124	0.000032	0.000177	0.000162	0.001928	0.000861	0.000238	0.007738	0.000154	0.001229	0.000553	0.001276	0.008466	0.003900	0.002882	0.001976	0.005287	0.000057	0.001469	0.002306	0.000397	0.000285	0.001747	0.004487	0.004143	0.000169	0.000014	0.000027	0.000038	0.000013	0.000053	0.000436	0.000110	0.000233	0.001747	0.000473	0.000039	0.000448	0.000106	0.000033	0.000854	0.000814	0.000151	0.000186	0.000051	0.000012	0.000033	0.000136	0.000145	0.000082	0.000658	0.000061	0.000024	0.000934	0.004751	0.000041	0.000023	0.000167	0.000284	0.000011	0.000412	0.000068	0.000122	0.000240	0.001043	0.000087	0.000481	0.000263	0.000391	0.001101	0.000319	0.000149	0.000038	0.000131	0.000174	0.000296	0.000237	0.000024	0.000523	0.002810	0.001184	0.000197	0.000146	0.000909	0.000130	0.000027	0.000028	0.000195	0.000058	0.000120	0.000085	0.000229	0.000341	0.002143	0.000007	0.000040	0.000027	0.001357	0.001233	0.000230	0.000066	0.000049	0.000010	0.000950	0.000205	0.001063	0.000239	0.000243	0.000234	0.000212	0.000552	0.000447	0.007209	0.000302	0.000060	0.000033	0.003346	0.003318	0.014101	0.000840	0.013931	0.008164	0.006477	0.001703	0.000579	0.001462	0.001802	0.001516	0.004471	0.000097	0.000216	0.004682	0.000665	0.001170	0.000115	0.000478	0.000350	0.000042	0.008603	0.000175	0.000245	0.000520	0.000085
268085662 - Bicep - Flex - Snaymon	268085662	0.026304	0.000782	0.000272	0.000618	0.000108	0.000661	0.000139	0.000243	0.000532	0.000267	0.000459	0.000100	0.000413	0.000327	0.000839	0.000389	0.000557	0.000272	0.000154	0.000286	0.000216	0.000277	0.000378	0.000485	0.000456	0.000176	0.000147	0.004088	0.000762	0.000065	0.000109	0.000202	0.000738	0.000712	0.000268	0.000333	0.005721	0.000035	0.000231	0.000066	0.000637	0.000400	0.000184	0.000172	0.000168	0.000187	0.000141	0.000200	0.000237	0.000363	0.000042	0.000172	0.000361	0.000287	0.000507	0.000137	0.000008	0.000012	0.000106	0.000161	0.000075	0.000548	0.000343	0.002167	0.001276	0.006393	0.000896	0.000328	0.000162	0.002613	0.000312	0.000102	0.002690	0.002198	0.001667	0.000351	0.000330	0.000448	0.000328	0.000090	0.000346	0.000341	0.000071	0.000197	0.000442	0.000103	0.000360	0.000207	0.000170	0.000055	0.000076	0.000070	0.000490	0.000172	0.000171	0.000171	0.000213	0.000232	0.000819	0.000571	0.000351	0.000301	0.000240	0.000190	0.000205	0.000210	0.000235	0.000264	0.000079	0.000039	0.000043	0.001579	0.000751	0.000586	0.000082	0.000273	0.000166	0.000130	0.000154	0.000361	0.000060	0.000191	0.000398	0.000467	0.000581	0.000230	0.000616	0.000338	0.000085	0.000210	0.000215	0.000125	0.000380	0.000104	0.000156	0.002629	0.000011	0.818890	0.245043	0.010017	0.010857	0.002849	0.001487	0.002581	0.000432	0.000662	0.003206	0.000902	0.000549	0.000691	0.000441	0.000547	0.007304	0.005147	0.001756	0.000411	0.000378	0.000218	0.028266	0.030783	0.000572	0.032454	0.128936	0.292872	0.221447	0.018168	0.024942	0.002321	0.112884	0.000076	0.000570	0.004843	0.004636	0.004656	0.001375	0.000350	0.000318	0.000039	0.000294	0.000898	0.001507	0.001096	0.000120	0.000567	0.002932	0.002053	0.000392	0.001708	0.000390	0.002997	0.000313	0.014560	0.001439	0.000738	0.000344	0.005698	0.002502	0.001371	0.001026	0.000346	0.000682	0.000434	0.000292	0.000087	0.000019	0.000299	0.000226	0.000663	0.004627	0.001661	0.003857	0.000068	0.000356	0.000145	0.000077	0.002358	0.009738	0.079719	0.001180	0.003295	0.004378	0.002451	0.000829	0.002867	0.003131	0.000206	0.025334	0.006013	0.001533	0.001724	0.000558	0.001067	0.005795	0.001535	0.003233	0.006824	0.003876	0.002189	0.000308	0.052502	0.007309	0.014481	0.030926	0.001872	0.020078	0.003617	0.001884	0.001484	0.001061	0.000552	0.000403	0.008318	0.000188	0.001737	0.000526	0.000196	0.001554	0.002263	0.000636	0.001694	0.000311	0.000337	0.000099	0.000592	0.001919	0.004757	0.001956	0.004283	0.003433	0.000641	0.007860	0.001276	0.001089	0.000458	0.005005	0.000568	0.001998	0.000679	0.001165	0.005961	0.008170	0.000136	0.000141	0.000198	0.000106	0.000183	0.000061	0.000074	0.000425	0.000155	0.000186	0.000107	0.000123	0.000028	0.000080	0.000062	0.000304	0.000173	0.000171	0.000301	0.003058	0.000350	0.000077	0.000107	0.000157	0.000076	0.000397	0.000667	0.000928	0.000346	0.000842	0.000022	0.000082	0.000090	0.000101	0.000171	0.000221	0.000072	0.000351	0.000047	0.000119	0.000179	0.000958	0.000616	0.000434	0.000383	0.000291	0.000082	0.000765	0.000999	0.000233	0.000396	0.000662	0.000034	0.000075	0.000146	0.000031	0.000075	0.000033	0.000077	0.000095	0.000283	0.000056	0.000629	0.000030	0.000069	0.000120	0.000140	0.000229	0.000184	0.000047	0.000168	0.000203	0.000199	0.000625	0.000133	0.000155	0.000173	0.000339	0.000995	0.002502	0.000176	0.000012	0.000020	0.000412	0.000279	0.000220	0.000100	0.000070	0.000040	0.000283	0.000155	0.000147	0.000018	0.000212	0.000015	0.000045	0.000059	0.000029	0.001145	0.000269	0.000357	0.000135	0.000036	0.000715	0.000340	0.001073	0.000258	0.001235	0.000830	0.000220	0.010124	0.000215	0.000459	0.000291	0.000866	0.002097	0.000328	0.001662	0.001499	0.001993	0.000016	0.001384	0.000375	0.000388	0.000237	0.000920	0.003029	0.002245	0.000185	0.000034	0.000048	0.000031	0.000014	0.000155	0.000216	0.000132	0.000187	0.001003	0.000714	0.000052	0.000359	0.000340	0.000057	0.000259	0.000151	0.000215	0.000541	0.000214	0.000041	0.000092	0.000442	0.000280	0.000166	0.000808	0.000055	0.000107	0.001214	0.016586	0.000054	0.000086	0.000385	0.000461	0.000049	0.000361	0.000087	0.000082	0.000246	0.001145	0.000101	0.000556	0.000182	0.000208	0.000729	0.000157	0.000097	0.000021	0.000099	0.000126	0.000336	0.000671	0.000088	0.000360	0.002029	0.001798	0.000430	0.000449	0.001517	0.000499	0.000107	0.000071	0.000528	0.000085	0.000126	0.000153	0.000446	0.000637	0.002670	0.000027	0.000152	0.000058	0.001239	0.000677	0.000356	0.000104	0.000089	0.000021	0.001172	0.000107	0.002081	0.000098	0.000552	0.000184	0.000094	0.000310	0.000679	0.001722	0.000251	0.000039	0.000093	0.001984	0.000449	0.009570	0.000149	0.016573	0.006649	0.009006	0.002366	0.000937	0.001587	0.001673	0.002239	0.003505	0.000062	0.000135	0.001840	0.000164	0.000792	0.000032	0.000268	0.000162	0.000021	0.001859	0.000152	0.000263	0.000461	0.000223
268085665 - Bicep - Flex - Snookered	268085665	0.019424	0.000735	0.000300	0.000607	0.000129	0.000521	0.000102	0.000163	0.000092	0.000067	0.000113	0.000023	0.000125	0.000030	0.000238	0.000255	0.000448	0.000153	0.000126	0.000230	0.000153	0.000223	0.000170	0.000185	0.000197	0.000083	0.000050	0.002333	0.000507	0.000087	0.000124	0.000278	0.000390	0.000385	0.000203	0.000163	0.003567	0.000028	0.000089	0.000026	0.000115	0.000113	0.000038	0.000087	0.000044	0.000060	0.000079	0.000259	0.000163	0.000139	0.000022	0.000243	0.000222	0.000374	0.000511	0.000135	0.000051	0.000027	0.000160	0.000156	0.000105	0.000677	0.000162	0.002614	0.000880	0.005943	0.000120	0.000254	0.000226	0.000589	0.000145	0.000145	0.002526	0.001311	0.001021	0.000236	0.000260	0.000173	0.000307	0.000073	0.000252	0.000373	0.000091	0.000176	0.000295	0.000085	0.000258	0.000506	0.000488	0.000110	0.000065	0.000057	0.000454	0.000240	0.000254	0.000179	0.000207	0.000213	0.000726	0.000350	0.000211	0.000223	0.000346	0.000296	0.000182	0.000185	0.000175	0.000184	0.000083	0.000054	0.000065	0.001208	0.000608	0.000394	0.000025	0.000477	0.000271	0.000090	0.000084	0.000129	0.000070	0.000147	0.000200	0.000293	0.000221	0.000277	0.000583	0.000228	0.000046	0.000201	0.000284	0.000195	0.000182	0.000061	0.000120	0.001792	0.000024	0.876184	0.166696	0.005754	0.005778	0.001247	0.000945	0.000989	0.000244	0.000300	0.001124	0.000753	0.000272	0.000684	0.000732	0.000495	0.021326	0.016234	0.007329	0.002254	0.002300	0.001090	0.156252	0.083050	0.001091	0.019213	0.037715	0.400889	0.092323	0.007661	0.006937	0.001822	0.030037	0.000150	0.000584	0.002529	0.002430	0.004810	0.000551	0.000468	0.000335	0.000172	0.000813	0.002793	0.004380	0.003478	0.000900	0.001214	0.001307	0.001325	0.000451	0.000811	0.000327	0.001839	0.000165	0.003050	0.002468	0.000492	0.000286	0.001272	0.000903	0.000723	0.000556	0.001458	0.000561	0.000384	0.000441	0.000057	0.000031	0.000629	0.000423	0.000168	0.000418	0.000498	0.000251	0.000262	0.000090	0.000626