extends MeshInstance2D
class_name ValuesCurve

var xcurve: Curve

var filename_prefix := "res://windowed/windowed_ana_"

var cols: Vector3i
var target = 242

var col = 0

var song_values := Array()

func _ready():
	load_windowed(filename_prefix + "10_2.5.csv", target)

# Called when the node enters the scene tree for the first time.
func load_windowed(filename, target):
	xcurve = mesh.curve
	xcurve.clear_points()
	song_values.clear()
	
	var curve_file = FileAccess.open(filename, FileAccess.READ)
	
	var max = 0
	var generator = get_node("/root/Node3D/Generator") as Generator
	cols = generator.cols
	self.target = cols[col]
	
	while !curve_file.eof_reached():
		var values = curve_file.get_csv_line("\t")
		if values.size() > 1:
			var vv = Array()
			for v in values:
				vv.append(float(v))
				
			if vv[target] > max:
				max = vv[target]

			song_values.append(vv)

	for i in range(song_values.size()):
		xcurve.add_point(Vector2(i/song_values.size(), song_values[i][target] / max))
	
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
