import os
import sys
from http.cookiejar import MozillaCookieJar
from urllib.parse import urlparse

from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.common.keys import Keys
import threading
import time
from datetime import datetime, timedelta
import pytz

user_email = "noraaz@gwu.edu"
user_password = "ZhZh0808"
product = "224"

def load_cookies_txt_file(driver, cookie_file_path):
    """
    Load cookies from a Netscape HTTP cookie file into a Selenium WebDriver instance

    Args:
        driver: Selenium WebDriver instance
        cookie_file_path: Path to the Netscape HTTP cookie file
    """
    # Read and parse cookie file
    cookies = []
    with open(cookie_file_path, 'r') as file:
        lines = file.readlines()

    # Skip header lines
    cookie_lines = [line.strip() for line in lines if line.strip() and not line.startswith('#') and not line.startswith('Netscape')]

    # Group cookies by domain
    domain_cookies = {}
    for line in cookie_lines:
        try:
            fields = line.split('\t')
            if len(fields) < 7:  # Check if the line has enough fields
                continue

            domain, flag, path, secure, expiry, name, value = fields

            # Convert fields to appropriate types
            secure = secure.lower() == 'true'

            # Handle expiry time
            if expiry == '0':
                expiry = None
            else:
                expiry = int(expiry)

            cookie = {
                'domain': domain,
                'path': path,
                'name': name,
                'value': value,
                'secure': secure,
                'expiry': expiry
            }

            if domain not in domain_cookies:
                domain_cookies[domain] = []
            domain_cookies[domain].append(cookie)
        except Exception as e:
            print(f"Error parsing cookie: {e}")

    # Add cookies for each domain
    for domain, cookies in domain_cookies.items():
        # Navigate to the domain first
        protocol = "https" if any(cookie['secure'] for cookie in cookies) else "http"
        url = f"{protocol}://{domain}"
        current_url = driver.current_url

        # Only navigate if we're not already on a page from this domain
        if domain not in current_url:
            driver.get(url)

        # Add the cookies
        for cookie in cookies:
            try:
                driver.add_cookie(cookie)
                print(f"Successfully added cookie: {cookie['name']} for domain {domain}")
            except Exception as e:
                print(f"Error adding cookie: {e}")

def wait_for_element(driver, by, value, retries=3, timeout=1):
    for i in range(retries):
        try:
            return WebDriverWait(driver, timeout).until(EC.presence_of_element_located((by, value)))
        except Exception as e:
            if i < retries - 1:
                time.sleep(0.5)  # brief pause before retrying
                continue
            else:
                raise e


def accept_policy():
    try:
        accept_button = wait_for_element(driver, By.XPATH, '//div[contains(@class, "policy_acceptBtn__ZNU71") and text()="ACCEPT"]')
        accept_button.click()
        print(f"Accepted policy for product {product}")
    except Exception as e:
        print(f"No policy prompt for product {product}: {e}")

def sign_in():
    signed_in = False
    retry_count = 0
    while not signed_in and retry_count < 3:
        try:
            sign_in_button = wait_for_element(driver, By.XPATH, '//div[contains(@class, "header_infoTitle__Fse4B ") and text()="Sign in / Register"]')
            sign_in_button.click()
            print(f"Clicked Sign in for product {product}")

            email_input = wait_for_element(driver, By.XPATH, '//input[@id="email" and @placeholder="Enter your e-mail address"]')
            email_input.send_keys(user_email)
            print(f"Entered email for product {product}")

            continue_button = wait_for_element(driver, By.XPATH, '//button[@type="button" and contains(@class, "ant-btn-primary") and text()="CONTINUE"]')
            continue_button.click()
            print(f"Clicked Continue for product {product}")

            password_input = wait_for_element(driver, By.XPATH, '//input[@id="password" and @placeholder="Enter your password"]')
            password_input.send_keys(user_password)
            print(f"Entered password for product {product}")

            sign_in_submit_button = wait_for_element(driver, By.XPATH, '//button[@type="submit" and contains(@class, "ant-btn-primary") and text()="SIGN IN"]')
            sign_in_submit_button.click()
            print(f"Clicked Sign in submit for product {product}")
            time.sleep(2)  # Wait for 2 seconds to ensure sign-in completes
            signed_in = True
        except Exception as e:
            print(f"Sign in process failed for product {product}, retrying... ({retry_count+1}/3): {e}")
            retry_count += 1
            driver.get(f'https://www.popmart.com/us/pop-now/set/{product}')
            accept_policy()

    if not signed_in:
        print(f"Failed to sign in for product {product} after 3 attempts.")
        driver.quit()
        return False
    return True

chromedriver_path = "/usr/bin/chromedriver"
service = Service(chromedriver_path)
options = webdriver.ChromeOptions()
driver = webdriver.Chrome(service=service, options=options)

#cookie_file = "cookies-popmart-com.txt"
#load_cookies_txt_file(driver, cookie_file)

driver.get("https://www.popmart.com/us/pop-now/set/224")
time.sleep(5)



#sign_in()
#time.sleep(2)
#accept_policy()
#time.sleep(2)

#driver.get("https://www.popmart.com/us/pop-now/set/224")
#time.sleep(2)
