# HOW TO

## Build (Comment l'utiliser)

```
make linux      Compile en executable statique avec musl-gcc pour Linux
make macos      Compile en dynamically linked (avec gcc) pour MacOS
make shared     Compile en dynamically linked (avec gcc) pour linux
make pgcarmv7   Cross-compile visant armv7
make pgcarmv64  Cross-compile visant arm64
```

## Usage

```
./pgc [filtres] [fichier]

-2347      : selectionner les couches que l'on souhaite exclure (par defaut: aucune)
fichier    : selectionner le fichier de trames a lire (par defaut: vide)
```

### Pour utiliser le mode raw socket (exclusivement sur linux):

`setcap cap_net_raw,cap_net_admin=eip ${BIN}`

> Attention! L’étape setcap n’est que nécessaire lorsque vous voulez utiliser le mode écoute live.


## Exemples

`./pgc`

Ouvre un socket d'ecoute pour tout les packets ETH_T_ALL
Affiche tout les packets sous forme de flow graph

`./pgc trames.txt`

Lit le fichier `packets.txt` du repertoire courant.
Affiche tout les packets sous forme de flow graph

`./pgc -24 trames.txt`

Lit le fichier `packets.txt` du repertoire courant.
Affiche seulement les packets de la couche 3 et 7 sous forme de flow graph

`./pgc -2`

Ouvre un socket d'ecoute pour tout les packets ETH_T_ALL
N'affiche que les packets des couches > 2

`./pgc -2 | zstd - >/tmp/packets.zstd`

Ouvre un socket d'ecoute pour tout les packets `ETH_T_ALL`. Pipe l'affichage des packets des couches > 2 dans un fichier `/tmp/packets.zstd`. La lecture est possible avec `zstdless /tmp/packets.zstd`

`./pgc -2 in.txt >flow.txt`

Lit le fichier `in.txt` contenant des trames en hexa et output le flow graph dans le fichier `flow.txt`. Pipe l'affichage des packets des couches > 2 dans un fichier `flow.txt`.
