// create our structs (make sure they're packed)
#pragma once

// define access macros
#define VERSION(ih)   ((0xF0 & ih->vihl) >> 4)
#define IHL(ih)       ((0x0F & ih->vihl) << 2)

#define DF(ffrag)       (0x4000 & ffrag)
#define MF(ffrag)       (0x2000 & ffrag)
#define FOFFSET(ffrag)  (0x1fff & ffrag)

#define THL(th)     ((0xf000 & th->tflags) >> 10)
#define ACK(th)     ((0x0010 & th->tflags) >> 4)
#define SYN(th)     ((0x0002 & th->tflags) >> 1)

#pragma pack(push, 1)

// MAC

typedef struct
{
    uint8_t addr[6];
} MAC_ADDR;

typedef struct
{
    MAC_ADDR dst;
    MAC_ADDR src;
    uint16_t type;
} _MAC_HEADER;

typedef _MAC_HEADER MAC_HEADER;

// IPV4

typedef struct
{
    uint8_t addr[4];
} IPV4_ADDR;

typedef struct
{
    uint8_t vihl;
    uint8_t tos;
    uint16_t total_length;
    uint16_t identification;
    uint16_t ffrag;
    uint8_t ttl;
    uint8_t protocol;
    uint16_t header_checksum;
    IPV4_ADDR src;
    IPV4_ADDR dst;
} _IPV4_HEADER;

typedef _IPV4_HEADER IPV4_HEADER;

typedef struct
{
    uint16_t srcprt;
    uint16_t dstprt;
    uint32_t seqnum;
    uint32_t acknum;
    uint16_t tflags;
    uint16_t window;
    uint16_t chksum;
    uint16_t urgpnt;
} _TCP_HEADER;

typedef _TCP_HEADER TCP_HEADER;

typedef struct
{
    uint16_t srcprt;
    uint16_t dstprt;
    uint16_t length;
    uint16_t chksum;
} _UDP_HEADER;

typedef _UDP_HEADER UDP_HEADER;

#pragma pack(pop)

// helper function for byteswap conversion
inline static TCP_HEADER* BSWAP_TCP(_TCP_HEADER *th) {
    th->srcprt = bswap_16(th->srcprt);
    th->dstprt = bswap_16(th->dstprt);
    th->seqnum = bswap_32(th->seqnum);
    th->acknum = bswap_32(th->acknum);
    th->tflags = bswap_16(th->tflags);
    th->window = bswap_16(th->window);
    th->chksum = bswap_16(th->chksum);
    th->urgpnt = bswap_16(th->urgpnt);
    return th;
}

// helper function to byteswap UDP
inline static UDP_HEADER* BSWAP_UDP(_UDP_HEADER *th) {
    th->srcprt = bswap_16(th->srcprt);
    th->dstprt = bswap_16(th->dstprt);
    th->length = bswap_16(th->length);
    th->chksum = bswap_16(th->chksum);
    return th;
}

// helper function for byteswap conversion
inline static IPV4_HEADER* BSWAP_IPv4(_IPV4_HEADER *ih) {
    ih->total_length = bswap_16(ih->total_length);
    ih->identification = bswap_16(ih->identification);
    ih->ffrag = bswap_16(ih->ffrag);
    ih->header_checksum = bswap_16(ih->header_checksum);
    return ih;
}

// helper function for byteswap conversion
inline static MAC_HEADER* BSWAP_MAC(_MAC_HEADER *mh) {
    mh->type = bswap_16(mh->type);
    return mh;
}

//
/*inline static TCP_HEADER* INTERP_TCP(void *data) {
    _TCP_HEADER *th = (_TCP_HEADER *)data;
    BSWAP_TCP(th);
    return th
}

*/
