import wx
from modules.gui.PyCSI import DialogBackgroundGradientGUI
from modules.gui.panel_button import Button

class DialogBackgroundGradient(DialogBackgroundGradientGUI):
  def __init__(self, parent, color_high, color_low, type):
    super().__init__(parent)
    
    self.choice = type
    self.choice_background_style.SetSelection(type)

    if type == 0:
      self.text_gradient_high.Hide()
      self.button_background_high.Hide()
      self.text_gradient_low.SetLabel("Background")
      self.SetSize(wx.Size(self.GetSize()[0], 175))

    sizer = self.panel_main.GetSizer()

    button_font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_LIGHT, False, "Calibri Light" )
    self.button_okay = Button(parent = self.panel_main, label = "Okay", background= wx.Colour(252, 252, 252), font = button_font, radius = 10, id = wx.ID_ANY, pos = wx.DefaultPosition, size = wx.Size(152,35))
    sizer.Add(self.button_okay, 1, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
    
    self.button_cancel = Button(parent = self.panel_main, label = "Cancel", background= wx.Colour(252, 252, 252), font = button_font, radius = 10, id = wx.ID_ANY, pos = wx.DefaultPosition, size = wx.Size(152,35))
    sizer.Add(self.button_cancel, 1, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
    
    img = wx.Image(138,15)
    img.SetRGB(wx.Rect(0,0, 138, 15), color_low[0], color_low[1], color_low[2])
    self.button_background_low.SetBitmap(img.ConvertToBitmap())

    img = wx.Image(138,15)
    img.SetRGB(wx.Rect(0,0, 138, 15), color_high[0], color_high[1], color_high[2])
    self.button_background_high.SetBitmap(img.ConvertToBitmap())

    self.color_high = color_high
    self.color_low = color_low

    self.button_okay.Bind(wx.EVT_LEFT_UP, self.OnOkay)
    self.button_cancel.Bind(wx.EVT_LEFT_UP, self.OnCancel)



  def OnOkay(self, event):
    self.EndModal(wx.ID_OK)

  def OnCancel(self, event):
    self.EndModal(wx.ID_CANCEL)

  # Returns both color_high and color_low, and the users choice of solid or gradient background
  def GetColors(self):
      return [self.color_high, self.color_low, self.choice]
  
  def OnHighClick(self, event):
    dia = wx.ColourDialog(self)
   
    if dia.ShowModal() == wx.ID_OK:
      color = dia.GetColourData().GetColour()

    img = wx.Image(138,15)
    img.SetRGB(wx.Rect(0,0, 138, 15), color[0], color[1], color[2])
    
    self.color_high = color
    self.button_background_high.SetBitmap(img.ConvertToBitmap())
    self.Refresh()

  def OnLowClick(self, event):
    dia = wx.ColourDialog(self)
 
    if dia.ShowModal() == wx.ID_OK:
      color = dia.GetColourData().GetColour()
    
    img = wx.Image(138,15)
    img.SetRGB(wx.Rect(0,0, 138, 15), color[0], color[1], color[2])
    
    self.color_low = color
    self.button_background_low.SetBitmap(img.ConvertToBitmap())
    self.Refresh()
  
  def OnChoice(self, event):
    self.choice = self.choice_background_style.GetSelection()

    if self.choice == 0:
      self.text_gradient_high.Hide()
      self.button_background_high.Hide()
      self.text_gradient_low.SetLabel("Background")
      self.SetSize(wx.Size(self.GetSize()[0], 175))

    else:
      self.text_gradient_high.Show()
      self.button_background_high.Show()
      self.text_gradient_low.SetLabel("Background Low")
      self.SetSize(wx.Size(self.GetSize()[0], 200))

    self.Refresh()

