import wx
from modules.gui.panel_button import Button

class DialogConfirmOverwrite(wx.Dialog):
  def __init__(self, parent, id = wx.ID_ANY, title = "Overwrite?",style = wx.DEFAULT_DIALOG_STYLE, msg="", button_1 = "Yes", button_2 = "No"):
    super().__init__(parent, id = id, title = title, style = style)
    self.SetSize(self.FromDIP(wx.Size(400, 200)))
    self.SetBackgroundColour(wx.Colour(33, 33, 33))

    sizer = wx.BoxSizer(wx.VERTICAL)
    
    msg_panel = wx.Panel(self)
    msg_sizer = wx.BoxSizer(wx.VERTICAL)
    msg_panel.SetSizer(msg_sizer)

    msg = wx.StaticText(msg_panel, label = msg, style=wx.ALIGN_CENTER_HORIZONTAL)
    msg.SetFont(wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_NORMAL, False, "Calibri"))
    msg.SetForegroundColour(wx.Colour(255, 255, 255))

    msg_sizer.Add((0, 0), 1, wx.EXPAND|wx.ALL, 5)
    msg_sizer.Add(msg, 1, wx.EXPAND|wx.ALL, 5)
    msg_sizer.Add((0, 0), 1, wx.EXPAND|wx.ALL, 5)

    button_panel = wx.Panel(self, size=self.FromDIP(wx.Size(400, 50)))
    button_sizer = wx.BoxSizer(wx.HORIZONTAL)
    button_panel.SetSizer(button_sizer)

    button_yes = Button(parent = button_panel,
                        label = button_1,
                        background= self.GetBackgroundColour(),
                        font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_NORMAL, False, "Calibri"),
                        radius = 10,
                        id = wx.ID_ANY,
                        pos = wx.DefaultPosition,
                        size = self.FromDIP(wx.Size(100,30)),
                        color=4,
                        font_color=[255, 255,255])
    button_no = Button(parent = button_panel,
                        label = button_2,
                        background= self.GetBackgroundColour(),
                        font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_NORMAL, False, "Calibri"),
                        radius = 10,
                        id = wx.ID_ANY,
                        pos = wx.DefaultPosition,
                        size = self.FromDIP(wx.Size(100,30)),
                        color=2,
                        font_color=[255, 255,255])
    button_sizer.Add((0, 0), 1, wx.EXPAND|wx.ALL, 5)
    button_sizer.Add(button_no, 0, wx.ALL, 5)
    button_sizer.Add(button_yes, 0, wx.ALL, 5)
    button_sizer.Add((0, 0), 1, wx.EXPAND|wx.ALL, 5)
    sizer.Add(msg_panel, 1, wx.EXPAND|wx.ALL, 5)
    sizer.Add(button_panel, 0, wx.ALL, 5)

    self.SetSizer(sizer)

    button_yes.Bind(wx.EVT_LEFT_UP, self.on_yes)
    button_no.Bind(wx.EVT_LEFT_UP, self.on_no)

  def on_yes(self, event):
    self.EndModal(wx.ID_OK)

  def on_no(self, event):
    self.EndModal(wx.ID_NO)
