import wx
import cv2
import numpy as np
from modules.gui.PyCSI import DialogNewModelGUI
from modules.gui.panel_button import Button

class FileDropTarget(wx.FileDropTarget):
  def __init__(self, parent):
    super().__init__()
    self.Parent = parent

  def OnDropFiles(self, x, y, filenames):
    self.Parent.printTarget(filenames[0])
    return True

class FileDrawPanel(wx.Panel):
  def __init__(self, parent, logo_path, font_color, dash_color):
    super().__init__(parent)

    self.font_color = font_color
    self.dash_color = dash_color
   
    img_mat = cv2.imread(logo_path, cv2.IMREAD_UNCHANGED)

    # Set mat to 10% opacity, while avoiding pixels that are totally transparent
    b, g, r, a = cv2.split(img_mat)
    non_zero_alpha_mask = (a>0)
    a[non_zero_alpha_mask] = 26
    img_mat = cv2.merge((b,g,r,a))

    # Covert to RGBA and uint8
    img_mat = cv2.cvtColor(img_mat, cv2.COLOR_BGRA2RGBA)
    img_mat = img_mat.astype(np.uint8)
    

    # Rescale width to 200 while preserving aspect ratio
    width, height, z = img_mat.shape
    aspect_ratio = width / height

    new_width = 200
    new_height = int(new_width * aspect_ratio)

    img_mat = cv2.resize(img_mat, (new_width, new_height))

    # Generate wx.Bitmap from resultant cv2 mat
    self.bmp = wx.Bitmap.FromBufferRGBA(new_width, new_height, img_mat)
    #self.SetBackgroundStyle(wx.BG_STYLE_PAINT)
    self.Bind(wx.EVT_PAINT, self.OnPaint)
    self.Bind(wx.EVT_SIZE, self.OnSize)

  def OnSize(self, event):
    self.Refresh()

  def OnPaint(self, event):
    dc = wx.PaintDC(self)
    gc = wx.GraphicsContext.Create(dc)
    
    
    size = self.GetSize()
    bmp_size = self.bmp.GetSize()

    x = int((size[0] - bmp_size[0]) / 2)
    y = int((size[1] - bmp_size[1]) / 2)

    #dc.SetPen(wx.Pen(wx.Colour(252,252,252), 1, wx.PENSTYLE_SOLID))
    #dc.DrawRectangle(0,0,self.GetSize().x, self.GetSize().y)
    gc.DrawBitmap(gc.CreateBitmap(self.bmp), x, y-25, bmp_size[0], bmp_size[1])

    #dc.Clear()
    text = "Drop inspection folder here or"
    dc.SetFont(wx.Font( 18, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_LIGHT, False, "Calibri Light" ))
    dc.SetTextForeground(self.font_color)

    dc.DrawText(text, x-50, y+200)

    pen = wx.Pen(self.dash_color, 2, wx.PENSTYLE_SHORT_DASH)
    dc.SetPen(pen)
    dc.SetBrush(wx.TRANSPARENT_BRUSH)
    dc.DrawRoundedRectangle(32, 32, size[0]-64,size[1]-64, 15)

class DialogNewModel(DialogNewModelGUI):

  def __init__(self, parent, dark):
    super().__init__(parent)
    
    white = wx.Colour(252, 252, 252)
    black = wx.Colour(33, 33, 33)
    neutral_90 = wx.Colour(227, 227, 227)
    neutral_70 = wx.Colour(172, 172, 172)

    back_color = None
    font_color = None
    dash_color = None
    logo_path = None

    if dark:
      back_color = black
      font_color = wx.Colour(102,102,102)
      dash_color = wx.Colour(102,102,102)
      logo_path = "assets/Icons/Folder and Mouse Icon-02.png"
    
    else:
      back_color = white
      font_color = neutral_70
      dash_color = neutral_90
      logo_path = "assets/Icons/Folder and Mouse Icon-03.png"
    

    self.SetBackgroundColour(back_color)
    sizer_main = wx.BoxSizer(wx.VERTICAL)
    
    self.panel_main = wx.Panel(self, wx.ID_ANY, wx.DefaultPosition, wx.DefaultSize, wx.TAB_TRAVERSAL)
    sizer_panel_main = wx.BoxSizer(wx.VERTICAL)

    self.panel_folderclick = FileDrawPanel(self.panel_main, logo_path=logo_path, font_color=font_color, dash_color=dash_color)
    self.panel_folderclick.SetDropTarget(FileDropTarget(self))
    sizer_panel_main.Add(self.panel_folderclick, 1, wx.EXPAND|wx.ALL, 5)

    self.panel_button = wx.Panel(self.panel_main, wx.ID_ANY, wx.DefaultPosition, wx.DefaultSize, wx.TAB_TRAVERSAL )
    sizer_button_browse = wx.BoxSizer( wx.HORIZONTAL )
    button_font = wx.Font(24, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_LIGHT, False, "Calibri Light" )
    self.button_browse = Button( parent = self.panel_button, id = wx.ID_ANY, label = "BROWSE",background = back_color, font = button_font, radius = 20, pos = wx.DefaultPosition, size = wx.Size( 300,75 ))
    sizer_button_browse.Add((0, 0), 1,  wx.EXPAND, 5)
    sizer_button_browse.Add( self.button_browse, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5 )
    sizer_button_browse.Add((0, 0), 1,  wx.EXPAND, 5)

    self.panel_button.SetSizer( sizer_button_browse )
    self.panel_button.Layout()
    sizer_button_browse.Fit( self.panel_button )
    sizer_panel_main.Add( self.panel_button, 0, wx.EXPAND|wx.ALL, 5 )

    sizer_main.Add(self.panel_main, 1, wx.EXPAND | wx.ALL, 25 )
    self.panel_main.SetSizer(sizer_panel_main)
    self.panel_main.Layout()
   
    self.SetSizer( sizer_main )
    self.Layout()

    self.Centre( wx.BOTH )
    
    self.button_browse.Bind( wx.EVT_LEFT_UP, self.OnBrowseClick )

  def printTarget(self, filepath):
    print("User dropped dir: \t" + filepath)
    self.Destroy()

  def OnBrowseClick(self, event):
    dlg = wx.DirDialog(self, "Select Insepction Folder", style=wx.DIRP_DIR_MUST_EXIST)
      
    result = dlg.ShowModal()

    if result == wx.ID_OK:
      print("User loaded directory: \t" + dlg.GetPath())
      self.Destroy()
    if result == wx.ID_CANCEL:
      print("Browse Inspection File Dialog Cancelled.")