import wx
from modules.gui.PyCSI import DialogExportGui
from modules.gui.panel_button import Button

class DialogExport(DialogExportGui):
  def __init__(self, parent):
    super().__init__(parent)
    self.SetSize(self.FromDIP(wx.Size(500, 175)))
    button_background = wx.Colour(66, 66, 66)
    button_font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_LIGHT, False, "Calibri Light" )
    button_export_dir = Button(parent = self.panel_export,
                               label = "...",
                               background= button_background,
                               font = button_font, radius = 16,
                               id = wx.ID_ANY,
                               pos = wx.DefaultPosition,
                               size = self.FromDIP(wx.Size(40,28)),
                               color=2)
    button_export = Button( parent = self.panel_buttons,
                        label = "Export",
                        background= button_background,
                        font = button_font,
                        radius = 16,
                        id = wx.ID_ANY,
                        pos = wx.DefaultPosition,
                        size = self.FromDIP(wx.Size(200,35)),
                        color=1)
    button_cancel = Button( parent = self.panel_buttons,
                            label = "Cancel",
                            background= button_background,
                            font = button_font,
                            radius = 16,
                            id = wx.ID_ANY,
                            pos = wx.DefaultPosition,
                            size = self.FromDIP(wx.Size(200,35)),
                            color=3)
    sizer = self.panel_buttons.GetSizer()
    sizer.Add((0,0), 1, wx.EXPAND|wx.ALL, 5)
    sizer.Add(button_cancel, 0, wx.ALL, 5)
    sizer.Add(button_export, 0, wx.ALL, 5)
    sizer.Add((0,0), 1, wx.EXPAND|wx.ALL, 5)
    self.panel_export.GetSizer().Add(button_export_dir, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)


    button_export.Bind(wx.EVT_LEFT_UP, self.on_export_click)
    button_cancel.Bind(wx.EVT_LEFT_UP, self.on_cancel_click)
    button_export_dir.Bind(wx.EVT_LEFT_UP, self.on_export_dir_click)

  def on_export_click(self, event):
    self.EndModal(wx.ID_OK)
  
  def on_cancel_click(self, event):
    self.EndModal(wx.ID_CANCEL)
  
  def on_export_dir_click(self, event):
    file_dialog = wx.FileDialog(self, "Select Export Path", style=wx.FD_SAVE, wildcard="*.ply")
    if file_dialog.ShowModal() == wx.ID_OK:
      self.textctrl_export_dir.SetValue(file_dialog.GetPath())
    file_dialog.Destroy()

  def get_export_dir(self):
    return self.textctrl_export_dir.GetValue()