import wx
from modules.gui.PyCSI import DialogNewSceneGui
from modules.gui.panel_button import Button

class DialogNewScene(DialogNewSceneGui):
  def __init__(self, *args, **kwargs):
    super().__init__(*args, **kwargs)
    button_background = wx.Colour(233, 233, 233)
    button_font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_LIGHT, False, "Calibri Light" )
    button_select_scene_dir = Button(parent = self.panel_scene_dir,
                               label = "...",
                               background= button_background,
                               font = button_font, radius = 8,
                               id = wx.ID_ANY,
                               pos = wx.DefaultPosition,
                               size = wx.Size(40,28),
                               color=2)

    button_create = Button( parent = self.panel_buttons,
                        label = "Create",
                        background= button_background,
                        font = button_font,
                        radius = 8,
                        id = wx.ID_ANY,
                        pos = wx.DefaultPosition,
                        size = wx.Size(200,35),
                        color=1)
    button_cancel = Button( parent = self.panel_buttons,
                            label = "Cancel",
                            background= button_background,
                            font = button_font,
                            radius = 8,
                            id = wx.ID_ANY,
                            pos = wx.DefaultPosition,
                            size = wx.Size(200,35),
                            color=3)
    sizer = self.panel_buttons.GetSizer()
    sizer.Add((0,0), 1, wx.EXPAND|wx.ALL, 5)
    sizer.Add(button_cancel, 0, wx.ALL, 5)
    sizer.Add(button_create, 0, wx.ALL, 5)
    sizer.Add((0,0), 1, wx.EXPAND|wx.ALL, 5)
    self.panel_scene_dir.GetSizer().Add(button_select_scene_dir, 0, wx.ALL, 5)

    button_create.Bind(wx.EVT_LEFT_UP, self.on_create_click)
    button_cancel.Bind(wx.EVT_LEFT_UP, self.on_cancel_click)
    button_select_scene_dir.Bind(wx.EVT_LEFT_UP, self.on_select_scene_dir_click)

  def on_create_click(self, event):
    self.scene_dir = self.textctrl_scene_dir.GetValue()
    self.scene_name = self.textctrl_scene_name.GetValue()
    self.EndModal(wx.ID_OK)
  
  def on_cancel_click(self, event):
    self.EndModal(wx.ID_CANCEL)

  def on_select_scene_dir_click(self, event):
    dir_dialog = wx.DirDialog(self, "Select Scene Directory", style=wx.DD_DEFAULT_STYLE | wx.DD_DIR_MUST_EXIST)
    if dir_dialog.ShowModal() == wx.ID_OK:
      self.textctrl_scene_dir.SetValue(dir_dialog.GetPath())
    dir_dialog.Destroy()

  def get_name(self):
    return self.scene_name
  
  def get_scene_dir(self):
    return self.scene_dir

