import wx
import os
from modules.proto import app_data_pb2
import time
class PanelSceneSelect(wx.Panel):
  def __init__(self, parent, background):
    super().__init__(parent)
    self.SetBackgroundColour(background)
    self.sizer = wx.BoxSizer(wx.VERTICAL)
    self.SetSizer(self.sizer)
    self.scene_dict = {}
    self.scene_font = wx.Font(11, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, False, "Calibri Bold" )
    self.all_font = wx.Font(11, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_LIGHT, False, "Calibri Light" )
    self.background = background
    self.panel_top_bar = wx.Panel(self)
    self.panel_top_bar_sizer = wx.BoxSizer(wx.HORIZONTAL)
    self.panel_top_bar.SetSizer(self.panel_top_bar_sizer)

    self.text_ctrl_filter = wx.TextCtrl(self.panel_top_bar)
    self.text_ctrl_filter.SetBackgroundColour(wx.Colour(40, 40, 40))
    self.text_ctrl_filter.SetForegroundColour(wx.Colour(255, 255, 255))
    self.text_ctrl_filter.SetWindowStyle(wx.BORDER_NONE)
    self.text_ctrl_filter.SetFont(self.all_font)

    recent_font = wx.Font(18, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, False, "Calibri Bold" )
    text_recent = wx.StaticText(self.panel_top_bar, label="Recent")
    text_recent.SetFont(recent_font)
    text_recent.SetForegroundColour(wx.Colour(255, 255, 255))

    text_filter = wx.StaticText(self.panel_top_bar, label="Filter")
    text_filter.SetFont(self.all_font)
    text_filter.SetForegroundColour(wx.Colour(197, 197, 197))

    self.panel_top_bar_sizer.Add(text_recent, 0, wx.ALL, 5)
    self.panel_top_bar_sizer.Add((0,0), 1, wx.EXPAND | wx.ALL, 5)
    self.panel_top_bar_sizer.Add(text_filter, 0, wx.ALL, 5)
    self.panel_top_bar_sizer.Add(self.text_ctrl_filter, 0, wx.ALL, 5)

    self.sizer.Add(self.panel_top_bar, 0, wx.EXPAND|wx.ALL, 5)
    self.panel_scenes = wx.Panel(self)
    self.panel_scenes_list = wx.ScrolledCanvas(self.panel_scenes)
    self.panel_scenes_list.SetBackgroundColour(self.background)
    self.panel_scenes_list.SetScrollbars(10,10,0,0)
    list_sizer = wx.BoxSizer(wx.VERTICAL)
    self.panel_scenes_list.SetSizer(list_sizer)
    self.panel_scenes_sizer = wx.BoxSizer(wx.VERTICAL)
    self.panel_scenes.SetSizer(self.panel_scenes_sizer)

    sizer_scene_bar_text = wx.BoxSizer(wx.HORIZONTAL)
    
    name = wx.StaticText(self.panel_scenes, label="Name")
    name.SetForegroundColour(wx.Colour(197, 197, 197))
    name.SetFont(self.all_font)

    recent = wx.StaticText(self.panel_scenes, label="Recent")
    recent.SetForegroundColour(wx.Colour(197, 197, 197))
    recent.SetFont(self.all_font)

    size = wx.StaticText(self.panel_scenes, label="Size")
    size.SetForegroundColour(wx.Colour(197, 197, 197))
    size.SetFont(self.all_font)

    sizer_scene_bar_text.Add(name, 3, wx.ALL, 5)
    sizer_scene_bar_text.Add(recent, 1, wx.ALL, 5)
    sizer_scene_bar_text.Add(size, 1, wx.ALL, 5)

    self.panel_scenes_sizer.Add(sizer_scene_bar_text, 0, wx.EXPAND |wx.ALL, 5)
    self.panel_scenes_sizer.Add(self.panel_scenes_list, 1, wx.EXPAND |wx.ALL, 5)
    
    self.add_separator()

    self.current_highlighted = None
    self.sizer.Add(self.panel_scenes, 1, wx.EXPAND |wx.ALL, 5)

    #self.sizer.Add((0,0), 1, wx.EXPAND | wx.ALL, 5)
    app_data_folder = os.path.join(os.getenv('APPDATA'), 'Virtualize')
    self.app_data_path = str(app_data_folder) + "/appdata.bin" 
    if not os.path.exists(app_data_folder):
        os.makedirs(app_data_folder)
        
    self.app_data = app_data_pb2.AppData()
    if os.path.exists(self.app_data_path):
        with open(self.app_data_path, "rb") as appDataFile:
          data = appDataFile.read()
          self.app_data.ParseFromString(data)
    
    for path in self.app_data.ScenePaths:
      if not os.path.exists(path):
        self.app_data.ScenePaths.remove(path)
      else:
        self.add_scene(path)

  def open_scene(self, path):
    if not path in self.app_data.ScenePaths:
      self.app_data.ScenePaths.extend([path])
    self.add_scene(path)
    self.Layout()
    self.Refresh()

  def on_close(self):
    with open(self.app_data_path, "wb") as appDataFile:
      data = self.app_data.SerializeToString()
      appDataFile.write(data)
    
  def add_scene(self, scenepath):

    self.scene_font = wx.Font(11, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, False, "Calibri Bold" )
    panel_dir = wx.Panel(self.panel_scenes_list, size=wx.Size(-1,30))
    sizer_dir = wx.BoxSizer(wx.HORIZONTAL)
    panel_dir.SetSizer(sizer_dir)

    name = wx.StaticText(panel_dir, label=os.path.splitext(os.path.basename(scenepath))[0])
    name.SetForegroundColour(wx.Colour(252, 252, 252))
    name.SetFont(self.scene_font)
    

    diff_time = time.time() - os.path.getmtime(scenepath)
    days = int(diff_time / (60 * 60 * 24))
    hours = int((diff_time % (60 * 60 * 24)) / (60 * 60))
    minutes = int((diff_time % (60 * 60)) / 60)

    recent_label = ""
    if days > 0:
      recent_label += f"{days} days ago"
    elif hours > 0:
      recent_label += f"{hours} hours ago"
    else:
      recent_label += f"{minutes} minutes ago"

    recent = wx.StaticText(panel_dir, label=recent_label)
    recent.SetForegroundColour(wx.Colour(197, 197, 197))
    recent.SetFont(self.all_font)
    
    total_size = 0.0
    for root, dirs, files in os.walk(os.path.dirname(scenepath)):
      for f in files:
        file_path = os.path.join(root, f)
        total_size += os.path.getsize(file_path)
    
    total_size = total_size / (1024*1024*1024)
    total_size = f"{total_size:.1f} GBs" 
    size = wx.StaticText(panel_dir, label=total_size)
    size.SetForegroundColour(wx.Colour(197, 197, 197))
    size.SetFont(self.all_font)
    
    
    sizer_dir.Add(name, 3, wx.ALL, 5)
    sizer_dir.Add(recent, 1, wx.ALL, 5)
    sizer_dir.Add(size, 1, wx.ALL, 5)

    size.Bind(wx.EVT_MOTION, self.on_highlight_child_clicked)
    name.Bind(wx.EVT_MOTION, self.on_highlight_child_clicked)
    name.Bind(wx.EVT_MOTION, self.on_highlight_child_clicked)
    size.Bind(wx.EVT_LEFT_DCLICK, self.on_open_scene_child)
    name.Bind(wx.EVT_LEFT_DCLICK, self.on_open_scene_child)
    name.Bind(wx.EVT_LEFT_DCLICK, self.on_open_scene_child)
    panel_dir.Bind(wx.EVT_MOTION, self.on_highlight_scene)
    panel_dir.Bind(wx.EVT_LEFT_DCLICK, self.on_open_scene)
    
    self.scene_dict[panel_dir] = scenepath
    self.panel_scenes_list.GetSizer().Add(panel_dir, 0, wx.EXPAND |wx.ALL, 5)
    self.add_separator()
  
  def on_highlight_scene(self, event):
    self.set_highlight(event.GetEventObject())
  
  def on_open_scene(self, event):
    print("Double Click Open Scene")
    self.GetParent().start_main(self.scene_dict[event.GetEventObject()])
    

  def on_open_scene_child(self, event):
    self.GetParent().start_main(self.scene_dict[event.GetEventObject().GetParent()])
    

  def on_highlight_child_clicked(self, event):
    self.set_highlight(event.GetEventObject().GetParent())

  def set_highlight(self, to_highlight):

    if self.current_highlighted == to_highlight:
      return
    
    if self.current_highlighted is not None:
      self.current_highlighted.SetBackgroundColour(self.background)

    self.current_highlighted = to_highlight
    self.current_highlighted.SetBackgroundColour(wx.Colour(121, 121, 121))
    self.Refresh()

  def add_separator(self):
    separator = wx.Panel(self.panel_scenes_list, size=wx.Size(-1,1))
    separator.SetBackgroundColour(wx.Colour(61, 61, 61))
    self.panel_scenes_list.GetSizer().Add(separator, 0, wx.EXPAND |wx.ALL, 0)