from PyInstaller.utils.hooks import collect_all, collect_data_files
tensorly_data = collect_all('tensorly')
torchmetrics_data = collect_all('torchmetrics')
panda3d_data = collect_all('panda3d')
viser_data = collect_all('viser')
timm_data = collect_all('timm')
sam2_data = collect_all('sam2')
embreex_data = collect_all('embreex')
nerfstudio_data = collect_all('nerfstudio')

a = Analysis(
    ['main.py'],
    pathex=[],
    binaries=[]+tensorly_data[1] + torchmetrics_data[1] + panda3d_data[1] + viser_data[1] + timm_data[1] + sam2_data[1] + embreex_data[1] + nerfstudio_data[1],
    datas=[('./assets', 'assets'), ('./checkpoints/depth_pro.pt', './checkpoints'),
           ('./modules/server/server-win.exe','./modules/server')]+ tensorly_data[0] + torchmetrics_data[0] + panda3d_data[0] + viser_data[0] + timm_data[0] + sam2_data[0] + embreex_data[0],   
    hiddenimports=['pyi_splash']+ tensorly_data[2] + torchmetrics_data[2] + panda3d_data[2] + viser_data[2] + timm_data[2] + nerfstudio_data[2],
    hookspath=[],
    hooksconfig={},
    runtime_hooks=['./hooks/hook-torchmetrics.py'],
    excludes=[],
    noarchive=False,
    optimize=0,
)
pyz = PYZ(a.pure)

splash = Splash(
    './assets/Icons/splash.png',
    binaries=a.binaries,
    datas=a.datas,
    text_pos=None,
    text_size=12,
    minify_script=True,
    always_on_top=True,
)

exe = EXE(
    pyz,
    a.scripts,
    splash,
    splash.binaries,
    exclude_binaries=True,
    name='Virtualize',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    console=True,
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
    icon=['assets\\Logos\\Virtualize Icon.png'],
    version="version.txt"
)
coll = COLLECT(
    exe,
    a.binaries,
    a.datas,
    strip=False,
    upx=True,
    upx_exclude=[],
    name='Virtualize',
)