import wx
import cv2
import numpy as np

class DialogSplash(wx.Frame):
  def __init__(self, parent, id=wx.ID_ANY, size=(1000, 575)):
    super().__init__( parent, id=wx.ID_ANY, size=(975, 500), style=wx.FRAME_SHAPED |
                               wx.SIMPLE_BORDER |
                               wx.FRAME_NO_TASKBAR)
    
    
    self.name_font = wx.Font(24, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_EXTRAHEAVY, False, "Calibri" )
    self.name = "AVID Desktop"

    self.text_font = wx.Font(16, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_EXTRAHEAVY, False, "Calibri" )
    self.text = "© 1990-2024 Quidient. All Rights Reserved.\n\n\
For more details and legal notices,\n\
go to the About Quidient Screen.\n\n\
Initalizing Tools..."

    self.dev_font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_EXTRAHEAVY, False, "Calibri" )
    self.dev_text = "Emma Johnson, Ethan Martinez, Olivia Smith, Liam Davis,\n\
Ava Brown, Noah Anderson, Sophia Wilson, Jackson Taylor,\n\
Isabella Moore, Aiden Harris, Mia Jackson, Lucas Thompson,\n\
Amelia Miller, Mason Clark, Harper White, Oliver Adams,\n\
Evelyn Hall, Elijah Lee, Scarlett Wright, Logan Nelson,\n\
Aria Mitchell, Carter Turner, Grace Scott, Benjamin King,\n\
Lily Baker, Alexander Young, Chloe Cooper, Samuel Reed..."
    self.init_shape()
    self.init_bmps()
    self.Center()
    self.Bind(wx.EVT_PAINT, self.on_paint)

  def init_shape(self):
    r = 50
    w = 975
    h = 500
    c = wx.Colour(5, 5, 5)
    bmap = wx.Bitmap(w, h, 32)    
    dc = wx.MemoryDC()
    dc.SelectObject(bmap)
    gc = wx.GraphicsContext.Create(dc) 
    gc.SetAntialiasMode(wx.ANTIALIAS_DEFAULT)
    gc.SetBrush(wx.Brush(c))
    gc.SetPen(wx.Pen(c, 5))
    gc.DrawRoundedRectangle(0, 0, w, h, r)
    dc.SelectObject(wx.NullBitmap)
    image = wx.ImageFromBitmap(bmap)
    reg = image.ConvertToRegion()
    self.SetShape(reg)
    self.SetBackgroundColour(wx.Colour(227, 227, 227))

  def init_bmps(self):
    self.bmp_list = []
    logo = "assets/AVID Logos/AVID Logo Full Black.png"
    planes = "assets/images/airforce_planes.png"

    logo_mat = cv2.imread(logo, cv2.IMREAD_UNCHANGED)
    logo_mat = cv2.cvtColor(logo_mat, cv2.COLOR_BGRA2RGBA)
    logo_mat = logo_mat.astype(np.uint8)

    width, height, z = logo_mat.shape
    aspect_ratio = width / height

    new_width = 250
    new_height = int(new_width * aspect_ratio)
    logo_mat = cv2.resize(logo_mat, (new_width, new_height))

    logo_bmp = wx.StaticBitmap(self, bitmap=wx.BitmapFromBufferRGBA(new_width, new_height,logo_mat), pos = wx.Point(25,25))

    plane_mat = cv2.imread(planes, cv2.IMREAD_UNCHANGED)
    plane_mat = cv2.cvtColor(plane_mat, cv2.COLOR_BGRA2RGBA)
    plane_mat = plane_mat.astype(np.uint8)

    width, height, z = plane_mat.shape
    aspect_ratio = width / height

    new_width = 450
    new_height = int(new_width * aspect_ratio)
    plane_mat = cv2.resize(plane_mat, (new_width, new_height))
    self.bmp_list.append(wx.Bitmap.FromBufferRGBA(new_width, new_height, plane_mat))

    plane_bmp = wx.StaticBitmap(self, bitmap=wx.BitmapFromBufferRGBA(new_width, new_height, plane_mat), pos = wx.Point(500,25))


  def on_paint(self, event):
    dc = wx.PaintDC(self)
    gc = wx.GraphicsContext.Create(dc)
    gc.SetInterpolationQuality(wx.INTERPOLATION_BEST)
    gc.SetAntialiasMode(wx.ANTIALIAS_DEFAULT)
   
    font = gc.CreateFont(self.name_font, wx.Colour(33, 33, 33))
    gc.SetFont(font)
    #text_width, text_height = gc.GetTextExtent(self.text)
    gc.DrawText(self.name, 300, 25)

    font = gc.CreateFont(self.text_font, wx.Colour(144, 144, 144))
    gc.SetFont(font)
    gc.DrawText(self.text, 25, 100)

    font = gc.CreateFont(self.dev_font, wx.Colour(144, 144, 144))
    gc.SetFont(font)
    gc.DrawText(self.dev_text, 25, 275)

    gdc = wx.GCDC(dc)
    w, h = self.GetSizeTuple()
    r = 45
    gdc.SetPen(wx.Pen(wx.Colour(0, 0, 0), width = 8 ))
    gdc.SetBrush(wx.Brush(wx.Colour(255,255,255), wx.BRUSHSTYLE_TRANSPARENT))
    gdc.DrawRoundedRectangle( 0,0,w,h,r )