import wx
import sys
from modules.gui.panel_button import Button

class PanelTopBar(wx.Panel):
  def __init__(self, parent, size):
    super().__init__(parent, size=size)
    
    self.mainframe = parent
    self.toggle = 0
    self.SetBackgroundColour(wx.Colour(61, 61, 61))
    # logo = "assets/Logos/Virtualize Logo.png"
    # if getattr(sys, 'frozen', False):
    #   logo = "_internal/" + logo

    # img = wx.Image(logo, wx.BITMAP_TYPE_ANY)
    # ratio = img.GetSize().width / img.GetSize().height
    # size = [int(40 * ratio) , 40]#self.FromDIP(wx.Size(150, 60))
    # scaled_image = img.Rescale(size[0], size[1], wx.IMAGE_QUALITY_HIGH)
    #bmp = wx.BitmapFromImage(scaled_image)
    # print(self.GetSize().height)
    # print(size[1])
    # pos = wx.Point(50, 40)
    # logo_bmp = wx.StaticBitmap(self, bitmap=wx.Bitmap(scaled_image), pos = pos)

    sizer = wx.BoxSizer(wx.VERTICAL)
    self.SetSizer(sizer)

    horz_sizer = wx.BoxSizer(wx.HORIZONTAL)
    horz_sizer.Add((0,0), 1, wx.EXPAND|wx.ALL, 5)
    
    button_font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, False, "Calibri Bold")
    
    self.button_recon_scene = Button(parent = self,
                                    label = "Reconstruct Scene",
                                    background= wx.Colour(61, 61, 61),
                                    font = button_font,
                                    radius = 10,
                                    id = wx.ID_ANY,
                                    pos = wx.DefaultPosition,
                                    size = self.FromDIP(wx.Size(200,40)),
                                    color=4,
                                    font_color=[0, 0, 0])
    
    self.button_scale = Button(parent = self,
                                    label = "Scale Model",
                                    background= wx.Colour(61, 61, 61),
                                    font = button_font,
                                    radius = 10,
                                    id = wx.ID_ANY,
                                    pos = wx.DefaultPosition,
                                    size = self.FromDIP(wx.Size(200,40)),
                                    color=2,
                                    font_color=[0, 0, 0])
    # self.button_scale.Disable()

    # self.button_export = Button(parent = self,
    #                                 label = "Export",
    #                                 background= wx.Colour(61, 61, 61),
    #                                 font = button_font,
    #                                 radius = 10,
    #                                 id = wx.ID_ANY,
    #                                 pos = wx.DefaultPosition,
    #                                 size = self.FromDIP(wx.Size(100,40)),
    #                                 color=0,
    #                                 font_color=[0, 0, 0])
    
    self.button_measure = Button(parent = self,
                                    label = "Measure Tool: ON",
                                    background= wx.Colour(61, 61, 61),
                                    font = button_font,
                                    radius = 10,
                                    id = wx.ID_ANY,
                                    pos = wx.DefaultPosition,
                                    size = self.FromDIP(wx.Size(200,40)),
                                    color=2,
                                    font_color=[0, 0, 0], toggle=True)
    
    #self.button_measure.OnMouseUp(wx.EVT_LEFT_UP)
    self.button_measure.Disable()
    
    self.button_reset = Button(parent = self,
                                    label = "Reset View",
                                    background= wx.Colour(61, 61, 61),
                                    font = button_font,
                                    radius = 10,
                                    id = wx.ID_ANY,
                                    pos = wx.DefaultPosition,
                                    size = self.FromDIP(wx.Size(100,40)),
                                    color=3,
                                    font_color=[0, 0, 0], toggle=True)


    horz_sizer.Add(self.button_reset, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
    # horz_sizer.Add(self.button_export, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
    horz_sizer.Add(self.button_scale, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
    horz_sizer.Add(self.button_measure, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
    horz_sizer.Add(self.button_recon_scene, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)

    divider = wx.Panel(self, size=wx.Size(4000, 1))
    divider.SetBackgroundColour(wx.Colour(252, 252, 252))

    sizer.Add(horz_sizer, 1, wx.EXPAND|wx.ALL, 5)
    sizer.Add(divider, 0, wx.ALL, 0)

    self.button_reset.Bind(wx.EVT_LEFT_UP, self.on_reset)
    self.button_recon_scene.Bind(wx.EVT_LEFT_UP, self.on_reconstruct_scene)
    # self.button_export.Bind(wx.EVT_LEFT_UP, self.on_export)
    self.button_measure.Bind(wx.EVT_LEFT_UP, self.toggle_measure)
    self.button_scale.Bind(wx.EVT_LEFT_UP, self.on_scale)
    self.Layout()
    self.Refresh()

  def on_reset(self, event):
    if not self.button_reset.IsDisabled():
      self.mainframe.reset_viewport_camera()

  def on_scale(self, event):
    if not self.button_scale.IsDisabled():
      self.mainframe.scale()

  def toggle_measure(self, event):
    pass
    # if not self.button_measure.IsDisabled():
      
    #   if not self.button_measure.IsToggled():
    #     self.button_measure.set_label("Measure Tool: ON")
    #     self.button_scale.Enable()
    #   else:
    #     self.button_measure.set_label("Measure Tool: OFF")
    #     self.button_scale.Disable()
    #   self.mainframe.toggle_measure(not self.button_measure.IsToggled())

  def on_export(self, event):
    if not self.button_export.IsDisabled():
      self.mainframe.export_recon()
      
  def on_toggle_view(self, event):
    
    if self.button_view_toggle.IsDisabled():
      return
    
    self.toggle = self.toggle + 1 if self.toggle < 2 else 0
    
    if self.toggle == 0:
      self.button_view_toggle.set_label("Mode: Textured")
    elif self.toggle == 1:
      self.button_view_toggle.set_label("Mode: Untextured")
    else:
      self.button_view_toggle.set_label("Mode: Points")
    self.button_view_toggle.Refresh()
    self.mainframe.toggle_view(self.toggle)
    event.Skip()

  def disable_buttons(self):
    self.button_export.Disable()
    self.button_view_toggle.Disable()
    self.button_reset.Disable()
    self.button_scale.Disable()

  def enable_buttons(self):
    self.button_export.Enable()
    self.button_view_toggle.Enable()
    self.button_reset.Enable()
    self.button_scale.Enable()

  def on_reconstruct_scene(self, event):
    if not self.button_recon_scene.IsDisabled():
      self.mainframe.reconstruct_scene()


