import qrcode
import wx

class QRCode(wx.Bitmap):
    def __init__(self, parent, data, box_size=10, border=0):
        qr_img = self.generate_qr_code(data, box_size, border)
        qr_bitmap = self.pil_img_to_wx_img(qr_img)
        super().__init__(qr_bitmap)

    def generate_qr_code(self, data, box_size, border):
        qr = qrcode.QRCode(version=1, box_size=box_size, border=border)
        qr.add_data(data)
        qr.make(fit=True)
        qr_img = qr.make_image(fill_color="black", back_color="white")
        return qr_img
    
    def pil_img_to_wx_img(self, pil_img):
        image = wx.Image(pil_img.size[0], pil_img.size[1])
        image.SetData(pil_img.convert("RGB").tobytes())

        return image