SetCompressor /SOLID lzma
SetCompressorDictSize 64

Name "Virtualize"
OutFile "Virtualize.exe"
InstallDir "$PROGRAMFILES\Virtualize"
ShowInstDetails show
ShowUnInstDetails show

!define MUI_BRANDINGTEXT "Copyright Quidient 2025"
!include "MUI2.nsh"
; Include Modern UI (optional but recommended for a better UI)

Icon ".\assets\Logos\VirtualizeIcon.ico"
; Specify the license file
LicenseData "license_test.txt"

; Pages

!define MUI_FINISHPAGE_RUN "$INSTDIR\Virtualize.exe"
!define MUI_FINISHPAGE_RUN_TEXT "Run Virtualize"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "license_test.txt"
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_LANGUAGE "English"



Section "MainSection" SEC01

  SetOutPath $INSTDIR
  File /r ".\Virtualize.dist\*.*"

  ; Create a shortcut to the application in the Start Menu Programs directory
  CreateDirectory "$SMPROGRAMS\Virtualize"
  CreateShortCut "$SMPROGRAMS\Virtualize\Launch Virtualize.lnk" "$INSTDIR\Virtualize.exe"

  ; Write uninstall information for Windows Add/Remove Programs
  WriteUninstaller "$INSTDIR\Uninstall.exe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Virtualize" "DisplayName" "Virtualize"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Virtualize" "UninstallString" "$\"$INSTDIR\Uninstall.exe$\""

SectionEnd

Section "Uninstall"

  RMDir /r "$INSTDIR"

  Delete "$SMPROGRAMS\Virtualize\Launch Virtualize.lnk"
  RMDir "$SMPROGRAMS\Virtualize"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Virtualize"

SectionEnd

