#!/usr/local/bin/python3
import os
import re
import subprocess
import requests
import argparse
import sys
import urllib
import glob

bcurl = ""
site = ""

ytdl_location = "/home/tristan/.local/bin/yt-dlp"
dl_location = "/home/tristan/dev/newsongbot/downloads"
url_prefix = "http://192.168.1.17:9898/"

if not os.path.exists(dl_location):
    os.mkdir(dl_location)

# check that the user specified an html
"""
if len(sys.argv) < 2:
    print("Error: please html file containing album links")
    print("Usage: \"python3 ./rip.py {uk.html,randsrecords,jamie_xx_mixcloud.html}\"")
    sys.exit(2)
"""
# create appropriate folder
"""
title = sys.argv[1].split(".")[0]
if len(sys.argv) == 4:
    site = ""
    title = sys.argv[3]

if not os.path.exists(title):
    os.mkdir(title)
    """

# filter and generate absolute url from stubs
def sanitize(url):
    # invalidate improbable urls
    if len(url) > 500:
        return ""

    # parse for bandcamp link
    if site == "bandcamp" or site == "":
        if "album/" in url:
            if "https" not in url:
                url = bcurl + url
            u = url.split("?")[0]
            return u
    # look for mixcloud
    if site == "mixcloud" or site == "":
        if url.startswith("https://www.mixcloud") or url.startswith("http://www.mixcloud"):
            if "iframe" not in url:
                return url
    # look for soundcloud
    if site == "soundcloud" or site == "":
        if url.startswith("https://soundcloud.com/") and "mixesdb" not in url:
            return url
    # and finally youtube
    if site == "youtube" or site == "" or site == "ytaudio":
        if url.startswith("https://youtube.com/"):
            return url
    if site == "vimeo" or site == "":
        if url.startswith("https://i.vimeo.com/"):
            return url
    return url

# open our html file
def download(text, mode):
    # if needing to parse html
    rawlinks = re.findall('href="(.+)"', text)
    links = []

    # if we're in text mode, grab links directly
    if mode == "txt":
        for l in text.split("\n"):
            links.append(l)

    # for each one, make sure it's proper url 
    for r in rawlinks:
        links.append(sanitize(r))
    links = [url for url in links if url != ""]
    links = list(dict.fromkeys(links))

    # inform user
    total = len(links)
    print("There are " + str(total) + " albums to be downloaded")
    count = 0

    # loop over each one
    for l in links:
        print("[" + str(count) + "/" + str(total) + "] - " + l)
        count = count + 1
        # change filename depending on the mode
        #name = title + "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"

        if "tidal" in l:
            tidal_location = dl_location + l.split('/')[-1]

        name = "/%(title)s.%(ext)s"
        if mode == "album":
            name = "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
        if "mixcloud" in l or "soundcloud" in l or "youtu" in l:
            name = "/%(title)s.%(ext)s"
        # do the actual downloading
        command = [ytdl_location, "-o", dl_location + name, "--embed-thumbnail", "-x", "--prefer-ffmpeg", "--embed-metadata", l]
        if "tidal" in l:
            command = ['/home/tristan/.local/bin/tidal-dl', '--link', l, '-q', 'HiFi', '-o', tidal_location]
        if "soundcloud" in l and os.path.exists("soundcloud.txt"):
            command = [ytdl_location, "-o", dl_location + name, "--embed-thumbnail", "--embed-metadata", "--cookies", "soundcloud.txt", l]
        space = ' '
        pipe = None
        final = ""
        final_filename = ""
        #final = str(urllib.parse.quote(final, safe='/'))
        #final = final.replace(dl_location, url_prefix)
        subprocess.run(command)

        if "tidal" not in l:
            pipe = subprocess.Popen(command + ["--get-filename"], stdout=subprocess.PIPE, encoding="UTF-8")
            final = str(pipe.stdout.read())[:-1]
            final_filename = final.split('/')[-1]
        else:
            if not os.path.exists(tidal_location):
                os.mkdir(tidal_location)
            found_files_glob = glob.glob(f"{tidal_location}/**/*.flac", recursive=True)
            final = "\n".join([f for f in found_files_glob if 'jpg' not in f])

        print(final)

        if "youtu" in l:
            #    final = final.replace("m4a", "mp3")
            #    final = final.replace("opus", "mp3")
            final = final.replace("webm", "opus")
        
        return str(final), final_filename

def handle_rip_link(thingy):
    #print(str(thingy))
    if str(thingy).startswith("https://") or str(thingy).startswith("http://"):
        #print(str(thingy))
        return download(thingy, "txt")


"""
def download_html(file):
    print("Downloading " + str(site) + " from " + file)
    # read and parse urls
    with open(file, 'r') as f:
        contents = f.read()
        download(contents, "")

def download_txt(file):
    print("Downloading " + str(site) + " from " + file)
    # read and parse urls
    with open(file, 'r') as f:
        contents = f.read()
        download(contents, "txt")

def download_bc_url(name):
    global bcurl
    print("Downloading bandcamp albums from url")
    # if requesting bandcamp label
    bcurl = "https://" + name + ".bandcamp.com/"
    print("Requesting " + bcurl + " ...")
    req = requests.get(bcurl + "music")

    # get page and request
    if req.status_code == 200:
        print("Success! fetched webpage")
        download(req.text, "album")
    else:
        # if that fails...
        print("ERROR: http error code " + str(req.status_code))
"""

"""
if ".html" in sys.argv[1]:
    # assume bandcamp and if not use mixcloud
    if len(sys.argv) == 3:
        site = sys.argv[2]
        if sys.argv[2] == "all":
            site = ""
    download_html(sys.argv[1])
elif ".txt" in sys.argv[1]:
    # assume all
    if len(sys.argv) == 3:
        site = sys.argv[2]
        if sys.argv[2] == "all":
            site = ""
    download_txt(sys.argv[1])
elif "https://" in sys.argv[1]:
    mode = "txt"
    download(sys.argv[1], mode)
else:
    # download bandcamp
    download_bc_url(sys.argv[1])

"""    
"""
def main(args):


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="Welcome to my downloader")

    # add flag arguments here
    #parser.add_argument("-v", "--verbose", help="print changes", action="store_true")
    parser.add_argument("-o", "--output", help="set the output directory for downloads", action="store", dest='output')
    parser.add_argument("")
"""
