#!/usr/local/bin/python3
from __future__ import unicode_literals
import os
import re
import subprocess
import requests
import argparse
import sys
import urllib

import youtube_dl

# check that the user specified an html
"""
if len(sys.argv) < 2:
    print("Error: please html file containing album links")
    print("Usage: \"python3 ./rip.py {uk.html,randsrecords,jamie_xx_mixcloud.html}\"")
    sys.exit(2)
"""

class RipDownloader:
    def __init__(self, ytdl="/usr/local/bin/youtube-dl", dl="/Users/tristan/Documents/songs", urlpre="http://192.168.1.17:9898/", site=""):
        self.bcurl = ""
        self.site = site

        self.ytdl_location = ytdl
        self.dl_location = dl
        self.url_prefix = urlpre

        ytdl_opts = {'format': 'bestaudio/best'}
        self.ytdl = youtube_dl.YoutubeDL(ytdl_opts)

    # filter and generate absolute url from stubs
    def sanitize(self, url):
        # invalidate improbable urls
        if len(url) > 500:
            return ""

        # parse for bandcamp link
        if self.site == "bandcamp" or self.site == "":
            if "album/" in url:
                if "https" not in url:
                    url = self.bcurl + url
                u = url.split("?")[0]
                return u
        # look for mixcloud
        if self.site == "mixcloud" or self.site == "":
            if url.startswith("https://www.mixcloud") or url.startswith("http://www.mixcloud"):
                if "iframe" not in url:
                    return url
        # look for soundcloud
        if self.site == "soundcloud" or self.site == "":
            if url.startswith("https://soundcloud.com/") and "mixesdb" not in url:
                return url
        # and finally youtube
        if self.site == "youtube" or self.site == "" or self.site == "ytaudio":
            if url.startswith("https://youtube.com/"):
                return url
        if self.site == "vimeo" or self.site == "":
            if url.startswith("https://i.vimeo.com/"):
                return url
        return url

    # open our html file
    def download(self, text="", mode="txt"):
        # if needing to parse html
        rawlinks = re.findall('href="(.+)"', text)
        links = []

        # if we're in text mode, grab links directly
        if mode == "txt":
            for l in text.split("\n"):
                links.append(l)

        # for each one, make sure it's proper url 
        for r in rawlinks:
            links.append(self.sanitize(r))
        links = [url for url in links if url != ""]
        links = list(dict.fromkeys(links))

        # inform user
        total = len(links)
        print("There are " + str(total) + " albums to be downloaded")
        count = 0

        # loop over each one
        for l in links:
            print("[" + str(count) + "/" + str(total) + "] - " + l)
            count = count + 1
            
            # change filename depending on the mode
            name = "/%(title)s.%(ext)s"
            if self.site == "bandcamp" or "bandcamp" in l:
                name = "/%(artist)s - %(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
                if "/track/" in l:
                    name = "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
            elif mode == "album":
                name = "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
            if "mixcloud" in l or "soundcloud" in l or "youtu" in l:
                name = "/%(title)s.%(ext)s"
            
            # prep command
            command = [self.ytdl_location, "-o", self.dl_location + name, "--embed-thumbnail", "-x", "--audio-format", "mp3", "--prefer-ffmpeg", "--add-metadata", "--download-archive", "downloads.txt"]
            if "tidal" in l:
                command = ['/usr/local/bin/tidal-dl', '--link']
            if "soundcloud" in l and os.path.exists("soundcloud.txt"):
                command = command + ["--cookies", "soundcloud.txt"]
            command = command + [l]
            #runs = subprocess.Popen(command, stdout=subprocess.PIPE, encoding="UTF-8")
            
            # cleaner api implementation
            """
            with self.ytdl:
                result = self.ytdl.extract_info(l, download=False)
                video = result

                print(video)
                video_url = video['url']
                print(video_url + "\n")
            """

            # fetch future filename
            
            pipe = subprocess.Popen(command + ["--get-filename"], stdout=subprocess.PIPE, encoding="UTF-8")
            final = str(pipe.stdout.read())[:-1]
            final_filename = final.split('/')[-1]
            final = str(urllib.parse.quote(final, safe='/'))
            final = final.replace(self.dl_location, self.url_prefix)
            print(final)
            

            # run command
            subprocess.run(command)
            
            # set output to mp3
            if "youtu" in l:
                final = final.replace("m4a", "mp3")
                final = final.replace("opus", "mp3")
            
            # return values
            return str(final), final_filename

    def handle_rip_link(self, thingy):
        #print(str(thingy))
        if str(thingy).startswith("https://") or str(thingy).startswith("http://"):
            #print(str(thingy))
            return self.download(thingy, "txt")

    def download_bc_url(self, name):
        global bcurl
        print("Downloading bandcamp albums from url")
        # if requesting bandcamp label
        bcurl = "https://" + name + ".bandcamp.com/"
        print("Requesting " + bcurl + " ...")
        req = requests.get(bcurl + "music")

        # get page and request
        if req.status_code == 200:
            print("Success! fetched webpage")
            self.download(req.text, "album")
        else:
            # if that fails...
            print("ERROR: could not find page: " + str(bcurl))

def run_standalone():
    # init variables
    title = sys.argv[1].split(".")[0]
    site = ""
    target = sys.argv[1]

    if len(sys.argv) >= 3:
        site = sys.argv[2]

    if len(sys.argv) >= 4:
        title = sys.argv[3]

    # create appropriate folder
    if not os.path.exists(title):
        os.mkdir(title)

    # create downloader instance
    rip = RipDownloader(dl=title, site=site)
    print("Downloading " + str(site) + " from " + target)

    # handle user's request
    
    # handle random link
    if "https://" in target:
        rip.download(target, "txt")
    # if specifying local file then parse it
    elif ".html" in target or ".txt" in target:
        with open(target, 'r') as f:
            contents = f.read()
            rip.download(contents, "")
    # if single word then refer to site
    else:
        rip.download_bc_url(target)

if __name__ == '__main__':
    run_standalone()

"""
if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="Welcome to my downloader")

    # add flag arguments here
    #parser.add_argument("-v", "--verbose", help="print changes", action="store_true")
    parser.add_argument("-o", "--output", help="set the output directory for downloads", action="store", dest='output')
    parser.add_argument("")
"""