#!/usr/local/bin/python3
import os
import re
import subprocess
import requests
import argparse
import sys
from time import sleep

bcurl = "https://kareemali19.bandcamp.com"
site = ""

# check that the user specified an html
if len(sys.argv) < 2:
    print("Error: please html file containing album links")
    print("Usage: \"python3 ./rip.py {uk.html,randsrecords,jamie_xx_mixcloud.html}\"")
    sys.exit(2)

# create appropriate folder
title = sys.argv[1].split(".")[0]
if len(sys.argv) == 4:
    title = sys.argv[3]

if not os.path.exists(title) and len(title) > 0:
    os.mkdir(title)

# filter and generate absolute url from stubs
def sanitize(url):
    # invalidate improbable urls
    if "open.spotify" in url or "/release/album" in url or "apple.com" in url:
        return ""
    if len(url) > 500:
        return ""
    print(url)
    url = url.split("\"")[0]

    # parse for bandcamp link
    if site == "bandcamp" or site == "":
        #print(url)
        if "/album/" in url:
            if "https" not in url:
                url = bcurl + url
            u = url.split("?")[0]
            return u
    # look for mixcloud
    if site == "mixcloud" or site == "":
        if url.startswith("https://www.mixcloud") or url.startswith("http://www.mixcloud"):
            if "iframe" not in url:
                return url
    # look for soundcloud
    if site == "soundcloud" or site == "":
        if url.startswith("https://soundcloud.com/") and "mixesdb" not in url:
            return url
    # and finally youtube
    if site == "youtube" or site == "" or site == "ytaudio":
        if url.startswith("https://youtube.com/"):
            return url
    if site == "vimeo" or site == "":
        if url.startswith("https://i.vimeo.com/"):
            return url
    return ""

# open our html file
def download(text, mode):
    rawlinks = re.findall('href="(.+)"', text)
    links = []

    # if we're in text mode, grab links directly
    if mode == "txt":
        for l in text.split("\n"):
            links.append(l)

    # for each one, make sure it's proper url
    for r in rawlinks:
        links.append(sanitize(r))
    links = [url for url in links if url != ""]
    links = list(dict.fromkeys(links))

    # inform user
    total = len(links)
    print("There are " + str(total) + " albums to be downloaded")
    count = 0

    for l in links:
        print(l)

    # if user specifies starting point
    if len(sys.argv) == 5:
        count = int(sys.argv[4])
        links = links[count:]

    # loop over each one
    for l in links:
        print("[" + str(count) + "/" + str(total) + "] - " + l)
        count = count + 1
        if "class=" in l:
            pass

        # change filename depending on the mode
        name = title + "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
        if site == "bandcamp" or "bandcamp" in l:
            name = title + "/%(artist)s - %(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
            if "/track/" in l:
                name = title + "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
        if mode == "album":
            name = title + "/%(playlist)s/%(playlist_index)s. %(title)s.%(ext)s"
        if "mixcloud" in l or "soundcloud" in l or "youtube" in l:
            name = title + "/%(title)s.%(ext)s"

        # do the actual downloading
        command = ["youtube-dl", "-cwni", "--write-info-json", "-o", name, "--embed-thumbnail", "--download-archive", "downloads" + ".txt", "--add-metadata", l]
        if "tidal" in l:
            command = ['/usr/local/bin/tidal-dl', '--link', l]
        if "soundcloud" in l and os.path.exists("soundcloud.txt"):
            command = ["youtube-dl", "-q", "-o", name, "--embed-thumbnail", "--add-metadata", "--cookies", "soundcloud.txt", l]
        #if "ytaudio" in site:
        if True:
            print("ytaudio")
            command = ["youtube-dl", "-i", "-q", "-o", name, "--embed-thumbnail", "-x", "--audio-format", "mp3", "--prefer-ffmpeg", "--download-archive", "downloads" + ".txt", "--add-metadata", l]
        subprocess.run(command)
        sleep(1)

def download_html(file):
    print("Downloading " + str(site) + " from " + file)
    # read and parse urls
    with open(file, 'r') as f:
        contents = f.read()
        download(contents, "")

def download_txt(file):
    print("Downloading " + str(site) + " from " + file)
    # read and parse urls
    with open(file, 'r') as f:
        contents = f.read()
        download(contents, "txt")

def download_bc_url(name):
    global bcurl
    print("Downloading bandcamp albums from url")
    # if requesting bandcamp label
    bcurl = "https://" + name + ".bandcamp.com/"
    print("Requesting " + bcurl + " ...")
    req = requests.get(bcurl + "music")

    # get page and request
    if req.status_code == 200:
        print("Success! fetched webpage")
        download(req.text, "album")
    else:
        # if that fails...
        print("ERROR: http error code " + str(req.status_code))

if ".html" in sys.argv[1]:
    # assume bandcamp and if not use mixcloud
    if len(sys.argv) == 3:
        site = sys.argv[2]
        if sys.argv[2] == "all":
            site = ""
    download_html(sys.argv[1])
elif ".txt" in sys.argv[1]:
    # assume all
    if len(sys.argv) == 3:
        site = sys.argv[2]
        if sys.argv[2] == "all":
            site = ""
    download_txt(sys.argv[1])
elif "https://" in sys.argv[1]:
    mode = "txt"
    download(sys.argv[1], mode)
else:
    # download bandcamp
    download_bc_url(sys.argv[1])

"""
def main(args):


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="Welcome to my downloader")

    # add flag arguments here
    #parser.add_argument("-v", "--verbose", help="print changes", action="store_true")
    parser.add_argument("-o", "--output", help="set the output directory for downloads", action="store", dest='output')
    parser.add_argument("")
"""
