extends ScrollContainer
class_name Options

@onready var items: Array = $VBoxContainer.get_children()
@export var config_filename = "user://config.txt"

@onready var generator := (get_node("/root/Node3D/Generator") as Generator)

@onready var player := (get_node("/root/Node3D/Player/PlayerNode") as PlayerNode)

var config: Dictionary
#@onready var items

func save_config():
	var file = FileAccess.open(config_filename, FileAccess.WRITE)
	file.store_var(config)
	file.close()
	print("Saved config:\n" + str(config))

func update_config():
	print("Updating config...")
	
	config["ServerURL"] = find_child("ServerURL").text
	config["OffsetDiff"] = find_child("OffsetDiff").value
	config["ShowHelp"] = find_child("ShowHelp").button_pressed
	config["RatingsUsername"] = find_child("RatingsUsername").text
	config["ActivateRatings"] = find_child("ActivateRatings").button_pressed
	
func apply_config():
	print("Applying config...")
	
	if config.has("SerrverURL"):
		find_child("ServerURL").text = config["ServerURL"]
		generator.base_url = config["ServerURL"]
		player.base_rating_url = generator.base_url
		
	if config.has("OffsetDiff"):
		find_child("OffsetDiff").value = float(config["OffsetDiff"])
		generator.offset_diff = config["OffsetDiff"]
		
	if config.has("ShowHelp"):
		find_child("ShowHelp").button_pressed = config["ShowHelp"]
		generator.show_help_on_startup = config["ShowHelp"]
		
	if config.has("ActivateRatings"):
		find_child("ActivateRatings").button_pressed = config["ActivateRatings"]
		get_node("/root/Node3D/HoverCard/Ratings").visible = true if bool(config["ActivateRatings"]) else false
		get_node("/root/Node3D/HoverCard/Ratings").process_mode = Node.PROCESS_MODE_INHERIT if bool(config["ActivateRatings"]) else Node.PROCESS_MODE_DISABLED
		#for c in get_node("/root/Node3D/HoverCard/Ratings").find_children("./", "StaticBody3D"):
		#	print(c.name)
		#	c.input_ray_pickable = config["ActivateRatings"]
		
	if config.has("RatingsUsername"):
		find_child("RatingsUsername").text = config["RatingsUsername"]
		player.username = config["RatingsUsername"]
		player.update_username(player.username)
	
	

# Called when the node enters the scene tree for the first time.
func _ready():
	# read in config file
	if FileAccess.file_exists(config_filename):
		var file = FileAccess.open(config_filename, FileAccess.READ)
		config = file.get_var(true)
		apply_config()
		print(config)
		#update_config()
		file.close()
	else:
		update_config()
		apply_config()
		save_config()
		#items[0] = config["ServerURL"]
	reload_all()

	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass

func reload_all():
	save_config()
	apply_config()
	$"/root/Node3D/LockscreenControls".visible = false
	generator.refresh_datasets()
	

func _on_server_url_text_submitted(new_text):
	config["ServerURL"] = new_text

func _on_offset_diff_drag_ended(value_changed):
	config["OffsetDiff"] = value_changed

func _on_show_help_toggled(button_pressed):
	config["ShowHelp"] = button_pressed
	pass # Replace with function body.
	

func _on_ratings_username_text_submitted(new_text):
	config["RatingsUsername"] = new_text
	pass # Replace with function body.



func _on_save_config_pressed():
	update_config()
	apply_config()
	save_config()
	pass # Replace with function body.


func _on_reload_all_pressed():
	update_config()
	apply_config()
	reload_all()
	pass # Replace with function body.




func _on_activate_ratings_toggled(button_pressed):
	config["ActivateRatings"] = button_pressed
	pass # Replace with function body.
