extends Node3D
class_name Generator

@export var cols = Vector3i(245, 276, 239)
var facts = Vector3(1, 1, 1)
var pow_scaling = 0.4
var size = 1

var indices = Array()
var planes = Array()
var dims = Array()
var col_names
var song_ids = []
var song_values
var song_filenames
var song_classification = Array()
var lines = Array()
var jpgs = Array()

var fullscreen = false
var help_visible = false
var thread

var requesting = false

var basenames = Array()

var value_curve: ValuesCurve
var axis_modif = Vector3i(0, 0, 0)

var offset := 0
var offset_diff := 60

var zreader: ZIPReader
var show_help_on_startup = false

var total = 0

@export var basename := "merge_2023"
@export var base_url := "https://boite.trido.fr/"

@export var txt_url := ""
@export var csv_filename := "res://songcache_additions.txt"#"my_tracklist_10k_ana_results.csv"
@export var texture_folder_path := "res://"#"res://rating_10k_art"
@export var datasets_url = base_url + "datasets.txt"

@export var dynamic_datasets := true

@onready var info := $"/root/Node3D/UserControls/Info"
@onready var status := $"/root/Node3D/UserControls/Status"
@onready var collection_bar: CollectionBar = $"/root/Node3D/UserControls/CollectionBar"

@onready var lcontrols : LockscreenControls

var zip_url := "https://boite.trido.fr/mateo_divers.zip"
var zip_filename := "user://"

func process_zip(zip_filename):
	zreader = ZIPReader.new()
	zreader.open(zip_filename)
	
	var files = zreader.get_files()
	for f in files:
		print(f)

	#basename = "mateo_divers"
	
	texture_folder_path = basename + "/" + basename + "_art"
	var txt_file = basename + "/" + basename + "_results.txt"
	
	var file_names = zreader.read_file(txt_file).get_string_from_utf8()
	lines = file_names.split("\n")
	
	var res = parse_data(lines)
	self.song_ids = res[0]
	self.song_values = res[1]
	self.song_filenames = res[2]
	self.col_names = res[3]

func _on_request_completed_zip(result, _response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song collection could not be loaded!")
	
	print("Received zip!!")
	#print("body size: " + str(body.size()))
	
	process_zip(zip_filename)
	start_loading_thread()
	#$HTTPRequest2.request(txt_url)

func load_next_group(force=false):
	for p in planes:
		#remove_child(p)
		p.free()
	planes = Array()
	offset += offset_diff
	if thread:
		thread.wait_to_finish()
	# check if got to the end of our dataset
	if offset > total or force:
		offset = 0
		$HTTPRequest.request(datasets_url)
	else:
		start_loading_thread()
	#$HTTPRequest.request(txt_url)

func _input(event):
	if !lcontrols.visible:
		if event is InputEventMultiScreenTap:
			if event.fingers == 3:
				load_next_group()
				
		if event.as_text() == "switch_group" or event.as_text() == "7" or Input.is_action_just_pressed("switch_group"):
			if event.is_pressed():
				load_next_group()

func get_song_from_id(song_id):
	var index = song_ids.find(song_id)
	if index != -1:
		return song_filenames[index]

func parse_data(lines):
	#var file = FileAccess.open("res://my_tracklist_10k_ana_results.csv", FileAccess.READ)

	#var file = FileAccess.open(csv_filename, FileAccess.READ)
	#file.get_line()
	song_ids = Array()
	song_values = Array()
	song_filenames = Array()
	
	var file_names = FileAccess.open("res://col_names.txt", FileAccess.READ)
	col_names = file_names.get_as_text().split("\n")

	print("lines size: " + str(lines.size()))
	
	for li in range(lines.size()):
		var l = lines[li]
		if l.length() > 0:
			#print(l)
			var csv = l.split('\t')
			var song_id = csv[0].split(" ")[0].split("/")[-1]
			var song_filename = csv[0].split("/")[-1]
			var values = Array(csv.duplicate().slice(1))
			song_ids.append(song_id)
			song_filenames.append(song_filename)
			var vv = Array()
			for v in values:
				vv.append(float(v))

			song_values.append(vv)

	#file.close()
	var res = [song_ids, song_values, song_filenames, col_names]
	
	return res
	
func _on_request_completed_datasets(result, _response_code, headers, body: PackedByteArray):
	var file
	
	if result != HTTPRequest.RESULT_SUCCESS:
		print("Datasets could not be loaded!")
		print("Using built-in datasets...")
		file = FileAccess.get_file_as_string("res://datasets.txt")
	else:
		print("Received datasets list!!")
		print("body size: " + str(body.size()))
		file = body.get_string_from_utf8()
	
	lines = file.split("\n")
	
	basenames.clear()
	for l in lines:
		if l.length() > 0:
			basenames.append(l)
			
	print("Got basenames: ")
	print(basenames)
	
	if !dynamic_datasets:		
		basename = "mateo_divers"
		
		texture_folder_path = "res://" + basename + "_art/"
		txt_url = base_url + basename + "_results.txt"
		
		$HTTPRequest2.request(txt_url)
	else:
		get_node("/root/Node3D/DatasetControls").visible = true
		(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("release_mouse")
		var dataset_list : ItemList = get_node("/root/Node3D/DatasetControls/DatasetList")
		dataset_list.clear()
		
		var idx := 0
		for b in basenames:
			dataset_list.add_item(b)
			
			if FileAccess.file_exists("user://" + b + ".zip"):
				dataset_list.set_item_custom_fg_color(idx, Color.ALICE_BLUE)
				
			idx += 1
			
		


func request_dataset(index):
	basename = basenames[index]
	print("got basename: " + basename)
	zip_filename = "user://" + basename + ".zip"
	zip_url = base_url + basename + ".zip"
	if !FileAccess.file_exists(zip_filename):
		$HTTPRequest3.download_file = zip_filename
		$HTTPRequest3.request(zip_url)
	else:
		process_zip(zip_filename)

		if thread:
			thread.wait_to_finish()
		start_loading_thread()
		

func start_loading_thread():
	var texture_filelist: PackedStringArray
	
	if !zreader:
		texture_filelist = DirAccess.get_files_at(texture_folder_path)
	else:
		var tmp_list = zreader.get_files()
		for t in tmp_list:
			if t.ends_with(".jpg"):
				texture_filelist.append(t)
	
	jpgs = Array()
	for j in texture_filelist:
		jpgs.append(j.split("/")[-1].split(" ")[0])
	
	var callable = Callable(self, "_thread_function")
	callable = callable.bindv([jpgs])
	thread = Thread.new()
	# Third argument is optional userdata, it can be any variable.
	thread.start(callable)
	#_thread_function(jpgs)
	#stream_length = stream.get_length()

func _on_request_completed_results(result, response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song collection could not be loaded!")
	
	print("Received songcache!!")
	print("body size: " + str(body.size()))
	var file = body.get_string_from_utf8()
	lines = file.split("\n")
	
	var res = parse_data(lines)
	self.song_ids = res[0]
	self.song_values = res[1]
	self.song_filenames = res[2]
	self.col_names = res[3]
	
	start_loading_thread()

func scale_coord(val):
	return Vector3((pow(val[0] * facts[0], pow_scaling) * 20) - 10, \
			(pow(val[1] * facts[1], pow_scaling) * 20) - 10, \
			(pow(val[2] * facts[2], pow_scaling) * 20) - 10)

func normalize_scene():	
	var raw_vals = [[], [], []]
	
	if planes.size() > 0:
		for index in range(planes.size()):
			var nindex = indices[index]
			raw_vals[0].append(song_values[nindex][cols[0]])
			raw_vals[1].append(song_values[nindex][cols[1]])
			raw_vals[2].append(song_values[nindex][cols[2]])
		
		var mins = Vector3(raw_vals[0].min(), raw_vals[1].min(), raw_vals[2].min())
		var maxs = Vector3(raw_vals[0].max(), raw_vals[1].max(), raw_vals[2].max())
		
		facts = Vector3(1, 1, 1) / (maxs - mins)
		
		#for index in range(planes.size()):
		#	var nindex = indices[index]
		#	planes[index].position = Vector3((song_values[nindex][cols[0]] * 20) - 10, (song_values[nindex][cols[1]] * 20) - 10, (song_values[nindex][cols[2]] * 20) - 10)

func refresh_label():
	info.text = str(basename + "\n" + "X: " + col_names[cols[0]] + "\nY: " + col_names[cols[1]] + "\nZ: " + col_names[cols[2]])
	#info.text = str("scaling: " + str(pow_scaling) + "\nX: " + col_names[cols[0]] + "\nY: " + col_names[cols[1]] + "\nZ: " + col_names[cols[2]])
	
	
	
func refresh_load_status(now, total):
	if now - (offset + offset_diff) > 0:
		status.text = str("Loading... " + str(now) + " / " + str(total) + "...")
	else:
		status.text = str("Loaded " + str(now) + " / " + str(total))
		
	self.collection_bar.call_deferred("update_texture")

func update_scene(modif, force = false):
	if (modif[0] == 0 and modif[1] == 0 and modif[2] == 0) and force == false:
		return
	
	value_curve = get_parent().find_child("ValueCurves") as ValuesCurve
	
	cols += modif
	if value_curve:
		value_curve.refresh_windowed2(cols)
	print("cols: " + str(cols[0]) + ", " + str(cols[1]) + ", " + str(cols[2]))
	refresh_label()
	
	normalize_scene()
	
	for dim in range(dims.size()):
		dims[dim].text = str(cols[dim]) + "\n" + str(col_names[cols[dim]])
		
	for index in range(planes.size()):
		var nindex = indices[index]
		planes[index].position = scale_coord(Vector3(song_values[nindex][cols[0]], song_values[nindex][cols[1]], song_values[nindex][cols[2]]))

func update_scaling(diff):
	pow_scaling += diff

func update_size(diff):
	size += diff
	for index in range(planes.size()):
		var nindex = indices[index]
		planes[index].scale = Vector3(1, 1, 1) * size
	var player = get_parent().find_child("PlayerNode") as PlayerNode
	player.acceleration = size
	player.speed = size / 5


func _process(delta):
	if !lcontrols.visible:
		var modif = Vector3i()
		
		if Input.is_action_just_pressed("inc_x"):
			modif[0] += 1
		if Input.is_action_just_pressed("dec_x"):
			modif[0] -= 1
		if Input.is_action_just_pressed("inc_y"):
			modif[1] += 1
		if Input.is_action_just_pressed("dec_y"):
			modif[1] -= 1
		if Input.is_action_just_pressed("inc_z"):
			modif[2] += 1
		if Input.is_action_just_pressed("dec_z"):
			modif[2] -= 1
		
		var should_update = false
		
		if axis_modif.x != 0 or axis_modif.y != 0 or axis_modif.z != 0:
			print("should update!~")
			
			modif = Vector3i(axis_modif)
			print(axis_modif)
			axis_modif = Vector3i(0, 0, 0)
			#update_scene(modif)
		
		if Input.is_action_just_pressed("scale_up"):
			update_scaling(0.1)
			should_update = true
		if Input.is_action_just_pressed("scale_down"):
			update_scaling(-0.1)
			should_update = true
			
		if Input.is_action_just_pressed("size_up"):
			update_size(0.1)
		if Input.is_action_just_pressed("size_down"):
			update_size(-0.1)
		
		if Input.is_action_just_pressed("normalize") or should_update:
			#normalize_scene()
			update_scene(Vector3i(0, 0, 0), true)
		else:
			update_scene(modif)
			
		if Input.is_action_just_pressed("fullscreen"):
			toggle_fullscreen()
			
		if Input.is_action_just_pressed("help_wanted"):
			help_visible = !help_visible
			(get_parent_node_3d().find_child("HelpMenu") as Control).visible = help_visible
			

func toggle_fullscreen():
	fullscreen = !fullscreen
	
	if fullscreen:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_EXCLUSIVE_FULLSCREEN)
		(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("capture_mouse")
	else:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_MAXIMIZED)
		(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("release_mouse")
		
	var playernode = (get_parent_node_3d().find_child("Player").find_child("PlayerNode") as PlayerNode)
	playernode.call_deferred("update_crossbars")
	(get_parent_node_3d().find_child("Control").find_child("ProgressIndicator")).call_deferred("_ready")
	(get_parent_node_3d().find_child("UserControls").find_child("CollectionBar")).call_deferred("_ready")

func _ready():
	if OS.get_name() == "iOS":
		offset_diff = 100
	else:
		offset_diff = 100
		
	lcontrols = $"/root/Node3D/LockscreenControls" as LockscreenControls
	
	$HTTPRequest.request_completed.connect(_on_request_completed_datasets)
	$HTTPRequest2.request_completed.connect(_on_request_completed_results)
	$HTTPRequest3.request_completed.connect(_on_request_completed_zip)
	
	#$HTTPRequest3.request(zip_url)
	
func refresh_datasets():
	for p in planes:
		#remove_child(p)
		p.free()
	planes = Array()
	offset += offset_diff
	if thread:
		thread.wait_to_finish()
		
	datasets_url = base_url + "datasets.txt"
	print("Trying new datasets url! : " + datasets_url)
	offset = 0
	$HTTPRequest.request(datasets_url)

	
func _thread_function(jpgs):
	# Get the path to the folder containing the textures
	#var texture_folder_path := "res://songcache_art"
	#var texture_folder_path := "res://rating_10k_art"
	
	if dims.size() == 0:
		for i in range(0, 3):
			var dim = Label3D.new()
			dim.name = "col_" + str(i)
			dim.text = str(cols[i]) + "\n" + str(col_names[cols[i]])
			dim.position[(i+2)%3] -= 10
			dim.font_size = 256
			dims.append(dim)
			self.call_deferred("add_child", dim)
			
		(dims[1] as Label3D).call_deferred("rotate_z", -PI/2.0)
		(dims[1] as Label3D).call_deferred("rotate_y", PI/2.0)
		(dims[2] as Label3D).call_deferred("rotate_z", PI/2.0)
		(dims[2] as Label3D).call_deferred("rotate_x", -PI/2.0)
		
		#dims[1].rotation[1] = PI/2#(i+1)%3
		#dims[1].rotation[2] = -PI/2
		#dims[2].rotation[0] = -PI/2#(i+1)%3
		#dims[2].rotation[2] = PI/2#(i+1)%3
		
		dims[0].modulate = "ff4545"
		dims[1].modulate = "45ff45"
		dims[2].modulate = "4545ff"
	
	var filenames = Array()
	
	print(jpgs)
	
	for f in song_filenames:
		if jpgs.find(f.split("/")[-1].split(" ")[0]) != -1:
			if !((f as String).contains(".part")):
				filenames.append((f as String).replace(".m4a", "")+".jpg")
				
	var now = 0
	
	#filenames = filenames.slice(20, 80)
	total = filenames.size()
	offset = offset % total 
	filenames = filenames.slice(offset, offset+offset_diff)
	
	#if offset+offset_diff > total:
	#	filenames.slice(0, total-(offset+offset_diff))
	
	self.collection_bar.init(total)
	
	for texture_path in filenames:#DirAccess.get_files_at(texture_folder_path):
		print(texture_path)
		var ext_song_id = texture_path.split("/")[-1].split(" ")[0]
		var index = song_ids.find(ext_song_id)
		
		if texture_path.ends_with(".jpg") and index != -1:
			var texture_plane := MeshInstance3D.new()
			texture_plane.name = ext_song_id
			texture_plane.mesh = QuadMesh.new()
			
			var texture: ImageTexture
			
			if !zreader:
				texture = ResourceLoader.load(texture_folder_path + "/" + texture_path)
			else:
				var new_image = Image.new()
				var buff = zreader.read_file(texture_folder_path + "/" + texture_path)
				new_image.load_jpg_from_buffer(buff)
				texture = ImageTexture.create_from_image(new_image)
			
			var texture_material := StandardMaterial3D.new()

			texture_material.albedo_texture = texture
			texture_material.shading_mode = BaseMaterial3D.SHADING_MODE_UNSHADED
			#texture_material.fixed_size = true
			#texture_material.billboard_mode = BaseMaterial3D.BILLBOARD_ENABLED
			#texture_material.billboard_keep_scale = true
			#texture_material.billboard_mode = BaseMaterial3D.BILLBOARD_ENABLED

			texture_plane.mesh.surface_set_material(0, texture_material)
			print(texture_path.split(" ")[0])
			
			if index != -1:
				#print("FOUND INDEX")
				indices.append(index)
				texture_plane.position = scale_coord(Vector3(song_values[index][cols[0]], song_values[index][cols[1]], song_values[index][cols[2]]))
				texture_plane.call_deferred("create_convex_collision")
				planes.append(texture_plane)
				self.collection_bar.song_statuses[(planes.size() - 1)+offset] = self.collection_bar.STATUS.LOADED
				self.call_deferred("add_child", texture_plane)
			else:
				print("COULD NOT FIND INDEX")
			
			if now % 10 == 0:
				self.call_deferred("refresh_load_status", now+offset, total)
			
			if now % 10 == 0:
				self.call_deferred("update_scene", Vector3i(0, 0, 0), true)
				
			now += 1
	
	self.call_deferred("refresh_load_status", now+offset, total)
	self.call_deferred("update_scene", Vector3i(0, 0, 0), true)
	
	#print("Could not find any textures")
	print("Planes len: " + str(self.planes.size()))
	
	requesting = false
	

func _exit_tree():
	if thread:
		thread.wait_to_finish()

func _on_dataset_list_item_clicked(index, at_position, mouse_button_index):
	if !requesting:
		if show_help_on_startup:
			help_visible = !help_visible
			(get_parent_node_3d().find_child("HelpMenu") as Control).visible = help_visible
			#(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("capture_mouse")
			
		request_dataset(index)
		get_node("/root/Node3D/DatasetControls").visible = false
		requesting = true
		(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("update_crossbars")
		#ProjectSettings.set_setting("input_devices/pointing/emulate_mouse_from_touch", false)


func _on_dataset_list_item_selected(index):
	if !requesting:
		if show_help_on_startup:
			help_visible = !help_visible
			(get_parent_node_3d().find_child("HelpMenu") as Control).visible = help_visible
			#(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("capture_mouse")
			
		request_dataset(index)
		get_node("/root/Node3D/DatasetControls").visible = false
		(get_parent_node_3d().find_child("Player").find_child("PlayerNode")).call_deferred("update_crossbars")
		requesting = true
		#ProjectSettings.set_setting("input_devices/pointing/emulate_mouse_from_touch", false)
