#!/usr/bin/python3
from http.server import SimpleHTTPRequestHandler, HTTPServer, CGIHTTPRequestHandler
from process import *
import urllib.parse

#
trido = Trido(site_map='site.map')
trido.read_site_map('site.map')

# get server info
server_info = urllib.parse.urlparse(trido.s['server'])

port = server_info.port
address = (server_info.hostname, server_info.port)

trido.s['output_dir'] = ''
trido.post_maps_to_html()
trido.generate_home_page()

class ProjectRequestHandler(CGIHTTPRequestHandler):
    # handle get requests
    def do_GET(self):
        out = self.wfile.write
        if self.path == '/' or self.path.endswith('.py'):
            self.send_response(200)
            self.send_header("Content-type", "text/html")
            self.end_headers()
            with open('home.html', 'rb') as h:
                out(h.read())
        else:
            SimpleHTTPRequestHandler.do_GET(self)
    
    # handle post
    def do_POST(self):
        content_length = int(self.headers['Content-Length'])
        
        if self.headers['Content-Type'] == "application/x-www-form-urlencoded":
            post_data = self.rfile.read(content_length)
            #self.log_message("POST request,\nPath: %s\nHeaders:\n%s\n\nBody:\n%s\n",
            #str(self.path), str(self.headers), str(post_data.decode('utf-8')))

            form = urllib.parse.parse_qs(post_data.decode('utf-8'))
            filename = os.path.split(self.path)[1]
            trido.handle_post(filename, form)
            
            self.send_response(303)
            self.send_header("Location", trido.s['server'])
            self.end_headers()

if __name__ == '__main__':
    with HTTPServer(address, ProjectRequestHandler) as httpd:
        try:
            httpd.serve_forever()
        except:
            print("Failed")