//
// Created by tristan on 1/3/21.
//

#ifndef UNTITLED_BOARD_H
#define UNTITLED_BOARD_H


#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define P1 6
#define P2 13

#define BOARD_SIZE 14

#define int8 int_fast8_t
#define BOARD int8 b[BOARD_SIZE]
#define Move struct MoveStruct
#define RESULT enum ResultEnum
#define DEFAULT 4, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 0

#define MAX_ITER 24

enum ResultEnum { UNEXPLORED, DONE, PLAY_AGAIN, CAPTURE, ROOT };

int next_id = 1;

struct MoveStruct {
    Move* parent;
    int8 player;
    int8 layer;
    int8 move_pos;
    RESULT res;
    long id;
    BOARD;

    int8 number_of_next;
    Move* next;
    float score;
} ;

Move* play(Move*);
void create_move(Move*, Move*, int8, int8);
void execute_move(Move*);
Move* init_game();
void print_move(Move*);
void loop(Move*);

Move* add_move(Move*, Move*);

void reset(BOARD);
void init(BOARD);
RESULT can_play_again(Move*, int8, int8);
int8 get_score(BOARD, int8);
void print_board(BOARD);

Move* moves[MAX_ITER + 1];
int record = 0;

#endif //UNTITLED_BOARD_H
